package tv.cjump.jni;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.util.Log;
import io.dcloud.common.constant.AbsoluteConst;
import java.lang.reflect.Field;

public class NativeBitmapFactory {
    static Field nativeIntField = null;
    static boolean nativeLibLoaded = false;
    static boolean notLoadAgain = false;

    private static native Bitmap createBitmap(int i, int i2, int i3, boolean z);

    private static native Bitmap createBitmap19(int i, int i2, int i3, boolean z);

    private static native boolean init();

    private static native boolean release();

    public static boolean isInNativeAlloc() {
        return Build.VERSION.SDK_INT < 11 || (nativeLibLoaded && nativeIntField != null);
    }

    public static void loadLibs() {
        if (!notLoadAgain) {
            if (!DeviceUtils.isRealARMArch() && !DeviceUtils.isRealX86Arch()) {
                notLoadAgain = true;
                nativeLibLoaded = false;
            } else if (!nativeLibLoaded) {
                try {
                    if (Build.VERSION.SDK_INT < 11 || Build.VERSION.SDK_INT >= 23) {
                        notLoadAgain = true;
                        nativeLibLoaded = false;
                    } else {
                        System.loadLibrary("ndkbitmap");
                        nativeLibLoaded = true;
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                    notLoadAgain = true;
                    nativeLibLoaded = false;
                } catch (Error e2) {
                    e2.printStackTrace();
                    notLoadAgain = true;
                    nativeLibLoaded = false;
                }
                if (nativeLibLoaded) {
                    if (!init()) {
                        release();
                        notLoadAgain = true;
                        nativeLibLoaded = false;
                    } else {
                        initField();
                        if (!testLib()) {
                            release();
                            notLoadAgain = true;
                            nativeLibLoaded = false;
                        }
                    }
                }
                Log.e("NativeBitmapFactory", AbsoluteConst.EVENTS_LOADED + nativeLibLoaded);
            }
        }
    }

    public static void releaseLibs() {
        if (nativeLibLoaded) {
            release();
        }
        nativeIntField = null;
        nativeLibLoaded = false;
    }

    static void initField() {
        try {
            Field declaredField = Bitmap.Config.class.getDeclaredField("nativeInt");
            nativeIntField = declaredField;
            declaredField.setAccessible(true);
        } catch (NoSuchFieldException e) {
            nativeIntField = null;
            e.printStackTrace();
        }
    }

    private static boolean testLib() {
        if (nativeIntField == null) {
            return false;
        }
        Bitmap bitmap = null;
        try {
            Bitmap createNativeBitmap = createNativeBitmap(2, 2, Bitmap.Config.ARGB_8888, true);
            boolean z = createNativeBitmap != null && createNativeBitmap.getWidth() == 2 && createNativeBitmap.getHeight() == 2;
            if (z) {
                if (Build.VERSION.SDK_INT >= 17 && !createNativeBitmap.isPremultiplied()) {
                    createNativeBitmap.setPremultiplied(true);
                }
                Canvas canvas = new Canvas(createNativeBitmap);
                Paint paint = new Paint();
                paint.setColor(-65536);
                paint.setTextSize(20.0f);
                canvas.drawRect(0.0f, 0.0f, (float) createNativeBitmap.getWidth(), (float) createNativeBitmap.getHeight(), paint);
                canvas.drawText("TestLib", 0.0f, 0.0f, paint);
                if (Build.VERSION.SDK_INT >= 17) {
                    z = createNativeBitmap.isPremultiplied();
                }
            }
            if (createNativeBitmap != null) {
                createNativeBitmap.recycle();
            }
            return z;
        } catch (Exception e) {
            Log.e("NativeBitmapFactory", "exception:" + e.toString());
            if (0 != 0) {
                bitmap.recycle();
            }
            return false;
        } catch (Error unused) {
            if (0 != 0) {
                bitmap.recycle();
            }
            return false;
        } catch (Throwable th) {
            if (0 != 0) {
                bitmap.recycle();
            }
            throw th;
        }
    }

    public static int getNativeConfig(Bitmap.Config config) {
        try {
            Field field = nativeIntField;
            if (field == null) {
                return 0;
            }
            return field.getInt(config);
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            return 0;
        } catch (IllegalAccessException e2) {
            e2.printStackTrace();
            return 0;
        }
    }

    public static Bitmap createBitmap(int i, int i2, Bitmap.Config config) {
        return createBitmap(i, i2, config, config.equals(Bitmap.Config.ARGB_8888));
    }

    public static void recycle(Bitmap bitmap) {
        bitmap.recycle();
    }

    public static Bitmap createBitmap(int i, int i2, Bitmap.Config config, boolean z) {
        if (!nativeLibLoaded || nativeIntField == null) {
            return Bitmap.createBitmap(i, i2, config);
        }
        return createNativeBitmap(i, i2, config, z);
    }

    private static Bitmap createNativeBitmap(int i, int i2, Bitmap.Config config, boolean z) {
        int nativeConfig = getNativeConfig(config);
        if (Build.VERSION.SDK_INT == 19) {
            return createBitmap19(i, i2, nativeConfig, z);
        }
        return createBitmap(i, i2, nativeConfig, z);
    }
}
