package tv.cjump.jni;

import android.os.Build;
import android.os.Environment;
import android.text.TextUtils;
import android.util.Log;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Field;

public class DeviceUtils {
    public static final String ABI_MIPS = "mips";
    public static final String ABI_X86 = "x86";
    private static final int EM_386 = 3;
    private static final int EM_AARCH64 = 183;
    private static final int EM_ARM = 40;
    private static final int EM_MIPS = 8;
    private static ARCH sArch = ARCH.Unknown;

    public enum ARCH {
        Unknown,
        ARM,
        X86,
        MIPS,
        ARM64
    }

    /* JADX WARNING: Removed duplicated region for block: B:37:0x0084 A[SYNTHETIC, Splitter:B:37:0x0084] */
    /* JADX WARNING: Removed duplicated region for block: B:43:0x0090 A[SYNTHETIC, Splitter:B:43:0x0090] */
    /* JADX WARNING: Removed duplicated region for block: B:47:0x0098 A[SYNTHETIC, Splitter:B:47:0x0098] */
    public static synchronized ARCH getMyCpuArch() {
        Throwable th;
        FileNotFoundException e;
        IOException e2;
        synchronized (DeviceUtils.class) {
            byte[] bArr = new byte[20];
            File file = new File(Environment.getRootDirectory(), "lib/libc.so");
            if (file.canRead()) {
                RandomAccessFile randomAccessFile = null;
                try {
                    RandomAccessFile randomAccessFile2 = new RandomAccessFile(file, "r");
                    try {
                        randomAccessFile2.readFully(bArr);
                        int i = bArr[18] | (bArr[19] << 8);
                        if (i == 3) {
                            sArch = ARCH.X86;
                        } else if (i == 8) {
                            sArch = ARCH.MIPS;
                        } else if (i == 40) {
                            sArch = ARCH.ARM;
                        } else if (i != 183) {
                            Log.e("NativeBitmapFactory", "libc.so is unknown arch: " + Integer.toHexString(i));
                        } else {
                            sArch = ARCH.ARM64;
                        }
                        try {
                            randomAccessFile2.close();
                        } catch (IOException e3) {
                            e = e3;
                        }
                    } catch (FileNotFoundException e4) {
                        e = e4;
                        randomAccessFile = randomAccessFile2;
                        e.printStackTrace();
                        if (randomAccessFile != null) {
                            try {
                                randomAccessFile.close();
                            } catch (IOException e5) {
                                e = e5;
                            }
                        }
                        return sArch;
                    } catch (IOException e6) {
                        e2 = e6;
                        randomAccessFile = randomAccessFile2;
                        try {
                            e2.printStackTrace();
                            if (randomAccessFile != null) {
                                try {
                                    randomAccessFile.close();
                                } catch (IOException e7) {
                                    e = e7;
                                }
                            }
                            return sArch;
                        } catch (Throwable th2) {
                            th = th2;
                            if (randomAccessFile != null) {
                            }
                            throw th;
                        }
                    } catch (Throwable th3) {
                        th = th3;
                        randomAccessFile = randomAccessFile2;
                        if (randomAccessFile != null) {
                            try {
                                randomAccessFile.close();
                            } catch (IOException e8) {
                                e8.printStackTrace();
                            }
                        }
                        throw th;
                    }
                } catch (FileNotFoundException e9) {
                    e = e9;
                    e.printStackTrace();
                    if (randomAccessFile != null) {
                    }
                    return sArch;
                } catch (IOException e10) {
                    e2 = e10;
                    e2.printStackTrace();
                    if (randomAccessFile != null) {
                    }
                    return sArch;
                }
            }
        }
        return sArch;
        e.printStackTrace();
        return sArch;
    }

    public static String get_CPU_ABI() {
        return Build.CPU_ABI;
    }

    public static String get_CPU_ABI2() {
        try {
            Field declaredField = Build.class.getDeclaredField("CPU_ABI2");
            if (declaredField == null) {
                return null;
            }
            Object obj = declaredField.get(null);
            if (!(obj instanceof String)) {
                return null;
            }
            return (String) obj;
        } catch (Exception unused) {
            return null;
        }
    }

    public static boolean supportABI(String str) {
        String _cpu_abi = get_CPU_ABI();
        if (!TextUtils.isEmpty(_cpu_abi) && _cpu_abi.equalsIgnoreCase(str)) {
            return true;
        }
        if (TextUtils.isEmpty(get_CPU_ABI2()) || !_cpu_abi.equalsIgnoreCase(str)) {
            return false;
        }
        return true;
    }

    public static boolean supportX86() {
        return supportABI("x86");
    }

    public static boolean supportMips() {
        return supportABI(ABI_MIPS);
    }

    public static boolean isARMSimulatedByX86() {
        return !supportX86() && ARCH.X86.equals(getMyCpuArch());
    }

    public static boolean isMiBox2Device() {
        return Build.MANUFACTURER.equalsIgnoreCase("Xiaomi") && Build.PRODUCT.equalsIgnoreCase("dredd");
    }

    public static boolean isMagicBoxDevice() {
        return Build.MANUFACTURER.equalsIgnoreCase("MagicBox") && Build.PRODUCT.equalsIgnoreCase("MagicBox");
    }

    public static boolean isProblemBoxDevice() {
        return isMiBox2Device() || isMagicBoxDevice();
    }

    public static boolean isRealARMArch() {
        return (supportABI("armeabi-v7a") || supportABI("armeabi")) && ARCH.ARM.equals(getMyCpuArch());
    }

    public static boolean isRealX86Arch() {
        return supportABI("x86") || ARCH.X86.equals(getMyCpuArch());
    }
}
