package org.mozilla.universalchardet;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.util.Objects;

public class UnicodeBOMInputStream extends InputStream {
    private final BOM bom;
    private final PushbackInputStream in;
    private boolean skipped;

    public static final class BOM {
        static final /* synthetic */ boolean $assertionsDisabled = false;
        public static final BOM NONE = new BOM(new byte[0], "NONE");
        public static final BOM UTF_16_BE = new BOM(new byte[]{-2, -1}, "UTF-16 big-endian");
        public static final BOM UTF_16_LE = new BOM(new byte[]{-1, -2}, "UTF-16 little-endian");
        public static final BOM UTF_32_BE = new BOM(new byte[]{0, 0, -2, -1}, "UTF-32 big-endian");
        public static final BOM UTF_32_LE = new BOM(new byte[]{-1, -2, 0, 0}, "UTF-32 little-endian");
        public static final BOM UTF_8 = new BOM(new byte[]{-17, -69, -65}, "UTF-8");
        final byte[] bytes;
        private final String description;

        private BOM(byte[] bArr, String str) {
            this.bytes = bArr;
            this.description = str;
        }

        public final byte[] getBytes() {
            byte[] bArr = this.bytes;
            int length = bArr.length;
            byte[] bArr2 = new byte[length];
            System.arraycopy(bArr, 0, bArr2, 0, length);
            return bArr2;
        }

        public final String toString() {
            return this.description;
        }
    }

    public UnicodeBOMInputStream(InputStream inputStream) throws IOException {
        this(inputStream, true);
    }

    @Override // java.io.InputStream
    public int available() throws IOException {
        return this.in.available();
    }

    @Override // java.io.Closeable, java.lang.AutoCloseable, java.io.InputStream
    public void close() throws IOException {
        this.in.close();
    }

    public final BOM getBOM() {
        return this.bom;
    }

    public synchronized void mark(int i) {
        this.in.mark(i);
    }

    public boolean markSupported() {
        return this.in.markSupported();
    }

    @Override // java.io.InputStream
    public int read() throws IOException {
        this.skipped = true;
        return this.in.read();
    }

    @Override // java.io.InputStream
    public synchronized void reset() throws IOException {
        this.in.reset();
    }

    @Override // java.io.InputStream
    public long skip(long j) throws IOException {
        this.skipped = true;
        return this.in.skip(j);
    }

    public final synchronized UnicodeBOMInputStream skipBOM() throws IOException {
        if (!this.skipped) {
            long length = (long) this.bom.bytes.length;
            for (long skip = this.in.skip(length); skip < length; skip++) {
                this.in.read();
            }
            this.skipped = true;
        }
        return this;
    }

    /* JADX WARNING: Removed duplicated region for block: B:42:0x0086  */
    /* JADX WARNING: Removed duplicated region for block: B:44:0x008b  */
    /* JADX WARNING: Removed duplicated region for block: B:46:? A[RETURN, SYNTHETIC] */
    public UnicodeBOMInputStream(InputStream inputStream, boolean z) throws IOException {
        this.skipped = false;
        Objects.requireNonNull(inputStream, "invalid input stream: null is not allowed");
        PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, 4);
        this.in = pushbackInputStream;
        byte[] bArr = new byte[4];
        int read = pushbackInputStream.read(bArr);
        if (read != 2) {
            if (read != 3) {
                if (read == 4) {
                    if (bArr[0] == -1 && bArr[1] == -2 && bArr[2] == 0 && bArr[3] == 0) {
                        this.bom = BOM.UTF_32_LE;
                        if (read > 0) {
                        }
                        if (z) {
                        }
                    } else if (bArr[0] == 0 && bArr[1] == 0 && bArr[2] == -2 && bArr[3] == -1) {
                        this.bom = BOM.UTF_32_BE;
                        if (read > 0) {
                            pushbackInputStream.unread(bArr, 0, read);
                        }
                        if (z) {
                            skipBOM();
                            return;
                        }
                        return;
                    }
                }
                this.bom = BOM.NONE;
                if (read > 0) {
                }
                if (z) {
                }
            }
            if (bArr[0] == -17 && bArr[1] == -69 && bArr[2] == -65) {
                this.bom = BOM.UTF_8;
                if (read > 0) {
                }
                if (z) {
                }
            }
        }
        if (bArr[0] == -1 && bArr[1] == -2) {
            this.bom = BOM.UTF_16_LE;
            if (read > 0) {
            }
            if (z) {
            }
        } else {
            if (bArr[0] == -2 && bArr[1] == -1) {
                this.bom = BOM.UTF_16_BE;
                if (read > 0) {
                }
                if (z) {
                }
            }
            this.bom = BOM.NONE;
            if (read > 0) {
            }
            if (z) {
            }
        }
    }

    @Override // java.io.InputStream
    public int read(byte[] bArr) throws IOException {
        this.skipped = true;
        return this.in.read(bArr, 0, bArr.length);
    }

    @Override // java.io.InputStream
    public int read(byte[] bArr, int i, int i2) throws IOException {
        this.skipped = true;
        return this.in.read(bArr, i, i2);
    }
}
