package net.lingala.zip4j.tasks;

import com.taobao.weex.el.parse.Operators;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.util.List;
import net.lingala.zip4j.exception.ZipException;
import net.lingala.zip4j.headers.HeaderSignature;
import net.lingala.zip4j.headers.HeaderWriter;
import net.lingala.zip4j.model.EndOfCentralDirectoryRecord;
import net.lingala.zip4j.model.FileHeader;
import net.lingala.zip4j.model.Zip4jConfig;
import net.lingala.zip4j.model.Zip64EndOfCentralDirectoryLocator;
import net.lingala.zip4j.model.Zip64EndOfCentralDirectoryRecord;
import net.lingala.zip4j.model.ZipModel;
import net.lingala.zip4j.model.enums.RandomAccessFileMode;
import net.lingala.zip4j.progress.ProgressMonitor;
import net.lingala.zip4j.tasks.AsyncZipTask;
import net.lingala.zip4j.util.FileUtils;
import net.lingala.zip4j.util.RawIO;

public class MergeSplitZipFileTask extends AsyncZipTask<MergeSplitZipFileTaskParameters> {
    private final RawIO rawIO = new RawIO();
    private final ZipModel zipModel;

    public static class MergeSplitZipFileTaskParameters extends AbstractZipTaskParameters {
        private File outputZipFile;

        public MergeSplitZipFileTaskParameters(File file, Zip4jConfig zip4jConfig) {
            super(zip4jConfig);
            this.outputZipFile = file;
        }
    }

    public MergeSplitZipFileTask(ZipModel zipModel2, AsyncZipTask.AsyncTaskParameters asyncTaskParameters) {
        super(asyncTaskParameters);
        this.zipModel = zipModel2;
    }

    private RandomAccessFile createSplitZipFileStream(ZipModel zipModel2, int i) throws FileNotFoundException {
        return new RandomAccessFile(getNextSplitZipFile(zipModel2, i), RandomAccessFileMode.READ.getValue());
    }

    private File getNextSplitZipFile(ZipModel zipModel2, int i) {
        if (i == zipModel2.getEndOfCentralDirectoryRecord().getNumberOfThisDisk()) {
            return zipModel2.getZipFile();
        }
        String str = i >= 9 ? ".z" : ".z0";
        String path = zipModel2.getZipFile().getPath();
        return new File(zipModel2.getZipFile().getPath().substring(0, path.lastIndexOf(Operators.DOT_STR)) + str + (i + 1));
    }

    private void updateFileHeaderOffsetsForIndex(List<FileHeader> list, long j, int i, int i2) {
        for (FileHeader fileHeader : list) {
            if (fileHeader.getDiskNumberStart() == i) {
                fileHeader.setOffsetLocalHeader((fileHeader.getOffsetLocalHeader() + j) - ((long) i2));
                fileHeader.setDiskNumberStart(0);
            }
        }
    }

    private void updateHeadersForMergeSplitFileAction(ZipModel zipModel2, long j, OutputStream outputStream, Charset charset) throws IOException, CloneNotSupportedException {
        ZipModel zipModel3 = (ZipModel) zipModel2.clone();
        zipModel3.getEndOfCentralDirectoryRecord().setOffsetOfStartOfCentralDirectory(j);
        updateSplitZipModel(zipModel3, j);
        new HeaderWriter().finalizeZipFileWithoutValidations(zipModel3, outputStream, charset);
    }

    private void updateSplitEndCentralDirectory(ZipModel zipModel2) {
        int size = zipModel2.getCentralDirectory().getFileHeaders().size();
        EndOfCentralDirectoryRecord endOfCentralDirectoryRecord = zipModel2.getEndOfCentralDirectoryRecord();
        endOfCentralDirectoryRecord.setNumberOfThisDisk(0);
        endOfCentralDirectoryRecord.setNumberOfThisDiskStartOfCentralDir(0);
        endOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectory(size);
        endOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk(size);
    }

    private void updateSplitZip64EndCentralDirLocator(ZipModel zipModel2, long j) {
        if (zipModel2.getZip64EndOfCentralDirectoryLocator() != null) {
            Zip64EndOfCentralDirectoryLocator zip64EndOfCentralDirectoryLocator = zipModel2.getZip64EndOfCentralDirectoryLocator();
            zip64EndOfCentralDirectoryLocator.setNumberOfDiskStartOfZip64EndOfCentralDirectoryRecord(0);
            zip64EndOfCentralDirectoryLocator.setOffsetZip64EndOfCentralDirectoryRecord(zip64EndOfCentralDirectoryLocator.getOffsetZip64EndOfCentralDirectoryRecord() + j);
            zip64EndOfCentralDirectoryLocator.setTotalNumberOfDiscs(1);
        }
    }

    private void updateSplitZip64EndCentralDirRec(ZipModel zipModel2, long j) {
        if (zipModel2.getZip64EndOfCentralDirectoryRecord() != null) {
            Zip64EndOfCentralDirectoryRecord zip64EndOfCentralDirectoryRecord = zipModel2.getZip64EndOfCentralDirectoryRecord();
            zip64EndOfCentralDirectoryRecord.setNumberOfThisDisk(0);
            zip64EndOfCentralDirectoryRecord.setNumberOfThisDiskStartOfCentralDirectory(0);
            zip64EndOfCentralDirectoryRecord.setTotalNumberOfEntriesInCentralDirectoryOnThisDisk((long) zipModel2.getEndOfCentralDirectoryRecord().getTotalNumberOfEntriesInCentralDirectory());
            zip64EndOfCentralDirectoryRecord.setOffsetStartCentralDirectoryWRTStartDiskNumber(zip64EndOfCentralDirectoryRecord.getOffsetStartCentralDirectoryWRTStartDiskNumber() + j);
        }
    }

    private void updateSplitZipModel(ZipModel zipModel2, long j) {
        zipModel2.setSplitArchive(false);
        updateSplitEndCentralDirectory(zipModel2);
        if (zipModel2.isZip64Format()) {
            updateSplitZip64EndCentralDirLocator(zipModel2, j);
            updateSplitZip64EndCentralDirRec(zipModel2, j);
        }
    }

    /* access modifiers changed from: protected */
    @Override // net.lingala.zip4j.tasks.AsyncZipTask
    public ProgressMonitor.Task getTask() {
        return ProgressMonitor.Task.MERGE_ZIP_FILES;
    }

    /* access modifiers changed from: protected */
    public long calculateTotalWork(MergeSplitZipFileTaskParameters mergeSplitZipFileTaskParameters) {
        long j = 0;
        if (!this.zipModel.isSplitArchive()) {
            return 0;
        }
        for (int i = 0; i <= this.zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk(); i++) {
            j += getNextSplitZipFile(this.zipModel, i).length();
        }
        return j;
    }

    /* access modifiers changed from: protected */
    /* JADX WARNING: Removed duplicated region for block: B:23:0x005c A[Catch:{ all -> 0x0050 }] */
    /* JADX WARNING: Removed duplicated region for block: B:28:0x008e  */
    /* JADX WARNING: Removed duplicated region for block: B:29:0x0090  */
    /* JADX WARNING: Removed duplicated region for block: B:43:0x00bb A[SYNTHETIC, Splitter:B:43:0x00bb] */
    public void executeTask(MergeSplitZipFileTaskParameters mergeSplitZipFileTaskParameters, ProgressMonitor progressMonitor) throws IOException {
        FileOutputStream fileOutputStream;
        Throwable th;
        RandomAccessFile randomAccessFile;
        Throwable th2;
        Throwable th3;
        int i;
        if (this.zipModel.isSplitArchive()) {
            try {
                FileOutputStream fileOutputStream2 = new FileOutputStream(mergeSplitZipFileTaskParameters.outputZipFile);
                try {
                    int numberOfThisDisk = this.zipModel.getEndOfCentralDirectoryRecord().getNumberOfThisDisk();
                    if (numberOfThisDisk > 0) {
                        long j = 0;
                        long j2 = 0;
                        int i2 = 0;
                        int i3 = 0;
                        while (i3 <= numberOfThisDisk) {
                            RandomAccessFile createSplitZipFileStream = createSplitZipFileStream(this.zipModel, i3);
                            try {
                                long length = createSplitZipFileStream.length();
                                int i4 = 4;
                                if (i3 == 0) {
                                    try {
                                        if (((long) this.rawIO.readIntLittleEndian(createSplitZipFileStream)) == HeaderSignature.SPLIT_ZIP.getValue()) {
                                            i = 4;
                                            if (i3 == numberOfThisDisk) {
                                                length = this.zipModel.getEndOfCentralDirectoryRecord().getOffsetOfStartOfCentralDirectory();
                                            }
                                            long j3 = (long) i4;
                                            randomAccessFile = createSplitZipFileStream;
                                            FileUtils.copyFile(createSplitZipFileStream, fileOutputStream2, j3, length, progressMonitor, mergeSplitZipFileTaskParameters.zip4jConfig.getBufferSize());
                                            j2 += length - j3;
                                            fileOutputStream = fileOutputStream2;
                                            try {
                                                updateFileHeaderOffsetsForIndex(this.zipModel.getCentralDirectory().getFileHeaders(), i3 != 0 ? j : j2, i3, i);
                                                verifyIfTaskIsCancelled();
                                                randomAccessFile.close();
                                                i3++;
                                                numberOfThisDisk = numberOfThisDisk;
                                                fileOutputStream2 = fileOutputStream;
                                                j = j;
                                                i2 = i;
                                            } catch (Throwable th4) {
                                                th3 = th4;
                                                th2 = th3;
                                                if (randomAccessFile != null) {
                                                }
                                                throw th2;
                                            }
                                        } else {
                                            createSplitZipFileStream.seek(j);
                                        }
                                    } catch (Throwable th5) {
                                        th2 = th5;
                                        randomAccessFile = createSplitZipFileStream;
                                        if (randomAccessFile != null) {
                                            try {
                                                randomAccessFile.close();
                                            } catch (Throwable th6) {
                                                th2.addSuppressed(th6);
                                            }
                                        }
                                        throw th2;
                                    }
                                }
                                i = i2;
                                i4 = 0;
                                if (i3 == numberOfThisDisk) {
                                }
                                long j32 = (long) i4;
                                randomAccessFile = createSplitZipFileStream;
                                try {
                                    FileUtils.copyFile(createSplitZipFileStream, fileOutputStream2, j32, length, progressMonitor, mergeSplitZipFileTaskParameters.zip4jConfig.getBufferSize());
                                    j2 += length - j32;
                                    fileOutputStream = fileOutputStream2;
                                    updateFileHeaderOffsetsForIndex(this.zipModel.getCentralDirectory().getFileHeaders(), i3 != 0 ? j : j2, i3, i);
                                    verifyIfTaskIsCancelled();
                                } catch (Throwable th7) {
                                    th3 = th7;
                                    th2 = th3;
                                    if (randomAccessFile != null) {
                                    }
                                    throw th2;
                                }
                                try {
                                    randomAccessFile.close();
                                    i3++;
                                    numberOfThisDisk = numberOfThisDisk;
                                    fileOutputStream2 = fileOutputStream;
                                    j = j;
                                    i2 = i;
                                } catch (Throwable th8) {
                                    th = th8;
                                    try {
                                        fileOutputStream.close();
                                    } catch (Throwable th9) {
                                        th.addSuppressed(th9);
                                    }
                                    throw th;
                                }
                            } catch (Throwable th10) {
                                th3 = th10;
                                randomAccessFile = createSplitZipFileStream;
                                th2 = th3;
                                if (randomAccessFile != null) {
                                }
                                throw th2;
                            }
                        }
                        updateHeadersForMergeSplitFileAction(this.zipModel, j2, fileOutputStream2, mergeSplitZipFileTaskParameters.zip4jConfig.getCharset());
                        progressMonitor.endProgressMonitor();
                        fileOutputStream2.close();
                        return;
                    }
                    throw new ZipException("zip archive not a split zip file");
                } catch (Throwable th11) {
                    th = th11;
                    fileOutputStream = fileOutputStream2;
                    fileOutputStream.close();
                    throw th;
                }
            } catch (CloneNotSupportedException e) {
                throw new ZipException(e);
            }
        } else {
            ZipException zipException = new ZipException("archive not a split zip file");
            progressMonitor.endProgressMonitor(zipException);
            throw zipException;
        }
    }
}
