package net.lingala.zip4j.io.inputstream;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

abstract class DecompressedInputStream extends InputStream {
    private CipherInputStream<?> cipherInputStream;
    protected byte[] oneByteBuffer = new byte[1];

    public DecompressedInputStream(CipherInputStream<?> cipherInputStream2) {
        this.cipherInputStream = cipherInputStream2;
    }

    @Override // java.io.Closeable, java.lang.AutoCloseable, java.io.InputStream
    public void close() throws IOException {
        this.cipherInputStream.close();
    }

    public void endOfEntryReached(InputStream inputStream, int i) throws IOException {
        this.cipherInputStream.endOfEntryReached(inputStream, i);
    }

    /* access modifiers changed from: protected */
    public byte[] getLastReadRawDataCache() {
        return this.cipherInputStream.getLastReadRawDataCache();
    }

    public int pushBackInputStreamIfNecessary(PushbackInputStream pushbackInputStream) throws IOException {
        return 0;
    }

    @Override // java.io.InputStream
    public int read() throws IOException {
        if (read(this.oneByteBuffer) == -1) {
            return -1;
        }
        return this.oneByteBuffer[0];
    }

    @Override // java.io.InputStream
    public int read(byte[] bArr) throws IOException {
        return read(bArr, 0, bArr.length);
    }

    @Override // java.io.InputStream
    public int read(byte[] bArr, int i, int i2) throws IOException {
        return this.cipherInputStream.read(bArr, i, i2);
    }
}
