package master.flame.danmaku.ui.widget;

import android.graphics.RectF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import master.flame.danmaku.controller.IDanmakuView;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.IDanmakuIterator;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.android.Danmakus;

public class DanmakuTouchHelper {
    private IDanmakuView danmakuView;
    private RectF mDanmakuBounds = new RectF();
    private final GestureDetector.OnGestureListener mOnGestureListener;
    private final GestureDetector mTouchDelegate;

    private DanmakuTouchHelper(IDanmakuView iDanmakuView) {
        AnonymousClass1 r0 = new GestureDetector.SimpleOnGestureListener() {
            /* class master.flame.danmaku.ui.widget.DanmakuTouchHelper.AnonymousClass1 */

            public boolean onDown(MotionEvent motionEvent) {
                return (DanmakuTouchHelper.this.danmakuView == null || DanmakuTouchHelper.this.danmakuView.getOnDanmakuClickListener() == null) ? false : true;
            }

            public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
                IDanmakus iDanmakus = DanmakuTouchHelper.this.touchHitDanmaku(motionEvent.getX(), motionEvent.getY());
                boolean performDanmakuClick = (iDanmakus == null || iDanmakus.isEmpty()) ? false : DanmakuTouchHelper.this.performDanmakuClick(iDanmakus);
                return !performDanmakuClick ? DanmakuTouchHelper.this.performViewClick() : performDanmakuClick;
            }
        };
        this.mOnGestureListener = r0;
        this.danmakuView = iDanmakuView;
        this.mTouchDelegate = new GestureDetector(((View) iDanmakuView).getContext(), r0);
    }

    public static synchronized DanmakuTouchHelper instance(IDanmakuView iDanmakuView) {
        DanmakuTouchHelper danmakuTouchHelper;
        synchronized (DanmakuTouchHelper.class) {
            danmakuTouchHelper = new DanmakuTouchHelper(iDanmakuView);
        }
        return danmakuTouchHelper;
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.mTouchDelegate.onTouchEvent(motionEvent);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private boolean performDanmakuClick(IDanmakus iDanmakus) {
        IDanmakuView.OnDanmakuClickListener onDanmakuClickListener = this.danmakuView.getOnDanmakuClickListener();
        if (onDanmakuClickListener != null) {
            return onDanmakuClickListener.onDanmakuClick(iDanmakus);
        }
        return false;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private boolean performViewClick() {
        IDanmakuView.OnDanmakuClickListener onDanmakuClickListener = this.danmakuView.getOnDanmakuClickListener();
        if (onDanmakuClickListener != null) {
            return onDanmakuClickListener.onViewClick(this.danmakuView);
        }
        return false;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private IDanmakus touchHitDanmaku(float f, float f2) {
        Danmakus danmakus = new Danmakus();
        this.mDanmakuBounds.setEmpty();
        IDanmakus currentVisibleDanmakus = this.danmakuView.getCurrentVisibleDanmakus();
        if (currentVisibleDanmakus != null && !currentVisibleDanmakus.isEmpty()) {
            IDanmakuIterator it = currentVisibleDanmakus.iterator();
            while (it.hasNext()) {
                BaseDanmaku next = it.next();
                if (next != null) {
                    this.mDanmakuBounds.set(next.getLeft(), next.getTop(), next.getRight(), next.getBottom());
                    if (this.mDanmakuBounds.contains(f, f2)) {
                        danmakus.addItem(next);
                    }
                }
            }
        }
        return danmakus;
    }
}
