package master.flame.danmaku.danmaku.renderer.android;

import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.IDanmakuIterator;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.util.DanmakuUtils;

public class DanmakusRetainer {
    private IDanmakusRetainer fbdrInstance = null;
    private IDanmakusRetainer ftdrInstance = null;
    private IDanmakusRetainer lrdrInstance = null;
    private IDanmakusRetainer rldrInstance = null;

    public interface IDanmakusRetainer {
        void clear();

        void fix(BaseDanmaku baseDanmaku, IDisplayer iDisplayer, Verifier verifier);
    }

    public interface Verifier {
        boolean skipLayout(BaseDanmaku baseDanmaku, float f, int i, boolean z);
    }

    public DanmakusRetainer(boolean z) {
        alignBottom(z);
    }

    public void alignBottom(boolean z) {
        this.rldrInstance = z ? new AlignBottomRetainer() : new AlignTopRetainer();
        this.lrdrInstance = z ? new AlignBottomRetainer() : new AlignTopRetainer();
        if (this.ftdrInstance == null) {
            this.ftdrInstance = new FTDanmakusRetainer();
        }
        if (this.fbdrInstance == null) {
            this.fbdrInstance = new AlignBottomRetainer();
        }
    }

    public void fix(BaseDanmaku baseDanmaku, IDisplayer iDisplayer, Verifier verifier) {
        int type = baseDanmaku.getType();
        if (type == 1) {
            this.rldrInstance.fix(baseDanmaku, iDisplayer, verifier);
        } else if (type == 4) {
            this.fbdrInstance.fix(baseDanmaku, iDisplayer, verifier);
        } else if (type == 5) {
            this.ftdrInstance.fix(baseDanmaku, iDisplayer, verifier);
        } else if (type == 6) {
            this.lrdrInstance.fix(baseDanmaku, iDisplayer, verifier);
        } else if (type == 7) {
            baseDanmaku.layout(iDisplayer, 0.0f, 0.0f);
        }
    }

    public void clear() {
        IDanmakusRetainer iDanmakusRetainer = this.rldrInstance;
        if (iDanmakusRetainer != null) {
            iDanmakusRetainer.clear();
        }
        IDanmakusRetainer iDanmakusRetainer2 = this.lrdrInstance;
        if (iDanmakusRetainer2 != null) {
            iDanmakusRetainer2.clear();
        }
        IDanmakusRetainer iDanmakusRetainer3 = this.ftdrInstance;
        if (iDanmakusRetainer3 != null) {
            iDanmakusRetainer3.clear();
        }
        IDanmakusRetainer iDanmakusRetainer4 = this.fbdrInstance;
        if (iDanmakusRetainer4 != null) {
            iDanmakusRetainer4.clear();
        }
    }

    public void release() {
        clear();
    }

    /* access modifiers changed from: private */
    public static class AlignTopRetainer implements IDanmakusRetainer {
        protected boolean mCancelFixingFlag;
        protected Danmakus mVisibleDanmakus;

        private AlignTopRetainer() {
            this.mVisibleDanmakus = new Danmakus(1);
            this.mCancelFixingFlag = false;
        }

        /* JADX WARNING: Removed duplicated region for block: B:55:0x00f9  */
        /* JADX WARNING: Removed duplicated region for block: B:56:0x0107  */
        /* JADX WARNING: Removed duplicated region for block: B:58:0x010a  */
        /* JADX WARNING: Removed duplicated region for block: B:59:0x010d  */
        /* JADX WARNING: Removed duplicated region for block: B:64:0x0118  */
        /* JADX WARNING: Removed duplicated region for block: B:65:0x0120  */
        @Override // master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer.IDanmakusRetainer
        public void fix(BaseDanmaku baseDanmaku, IDisplayer iDisplayer, Verifier verifier) {
            boolean z;
            BaseDanmaku baseDanmaku2;
            int i;
            BaseDanmaku baseDanmaku3;
            BaseDanmaku baseDanmaku4;
            boolean z2;
            BaseDanmaku baseDanmaku5;
            boolean z3;
            float f;
            boolean z4;
            boolean z5;
            boolean z6;
            float f2;
            float f3;
            if (!baseDanmaku.isOutside()) {
                boolean isShown = baseDanmaku.isShown();
                int i2 = 1;
                int i3 = 0;
                boolean z7 = !isShown && !this.mVisibleDanmakus.isEmpty();
                float f4 = 0.0f;
                BaseDanmaku baseDanmaku6 = null;
                if (!isShown) {
                    this.mCancelFixingFlag = false;
                    IDanmakuIterator it = this.mVisibleDanmakus.iterator();
                    BaseDanmaku baseDanmaku7 = null;
                    BaseDanmaku baseDanmaku8 = null;
                    BaseDanmaku baseDanmaku9 = null;
                    int i4 = 0;
                    while (true) {
                        if (this.mCancelFixingFlag || !it.hasNext()) {
                            i = i4;
                            baseDanmaku2 = baseDanmaku7;
                            baseDanmaku4 = null;
                            baseDanmaku3 = baseDanmaku9;
                        } else {
                            i = i4 + 1;
                            baseDanmaku4 = it.next();
                            if (baseDanmaku4 == baseDanmaku) {
                                baseDanmaku2 = baseDanmaku7;
                                baseDanmaku3 = null;
                                z7 = false;
                                z2 = false;
                                isShown = true;
                                break;
                            }
                            baseDanmaku2 = baseDanmaku7 == null ? baseDanmaku4 : baseDanmaku7;
                            if (baseDanmaku.paintHeight + baseDanmaku4.getTop() > ((float) iDisplayer.getHeight())) {
                                baseDanmaku4 = null;
                                baseDanmaku3 = baseDanmaku9;
                                z2 = true;
                                break;
                            }
                            BaseDanmaku baseDanmaku10 = (baseDanmaku8 != null && baseDanmaku8.getRight() < baseDanmaku4.getRight()) ? baseDanmaku8 : baseDanmaku4;
                            z7 = DanmakuUtils.willHitInDuration(iDisplayer, baseDanmaku4, baseDanmaku, baseDanmaku.getDuration(), baseDanmaku.getTimer().currMillisecond);
                            if (!z7) {
                                baseDanmaku3 = baseDanmaku9;
                                baseDanmaku8 = baseDanmaku10;
                                baseDanmaku4 = baseDanmaku4;
                                break;
                            }
                            i4 = i;
                            baseDanmaku7 = baseDanmaku2;
                            baseDanmaku8 = baseDanmaku10;
                            baseDanmaku9 = baseDanmaku4;
                        }
                    }
                    i = i4;
                    baseDanmaku2 = baseDanmaku7;
                    baseDanmaku4 = null;
                    baseDanmaku3 = baseDanmaku9;
                    z2 = false;
                    if (baseDanmaku4 != null) {
                        if (baseDanmaku3 != null) {
                            f3 = baseDanmaku3.getBottom();
                        } else {
                            f3 = baseDanmaku4.getTop();
                        }
                        if (baseDanmaku4 != baseDanmaku) {
                            z4 = z7;
                            f = f3;
                            baseDanmaku5 = baseDanmaku4;
                            z5 = true;
                            z3 = false;
                            if (!z5) {
                                z6 = isOutVerticalEdge(z2, baseDanmaku, iDisplayer, f, baseDanmaku2, baseDanmaku3);
                            } else {
                                z6 = false;
                            }
                            if (!z6) {
                                z4 = true;
                                f = 0.0f;
                            } else {
                                i2 = baseDanmaku5 != null ? i - 1 : i;
                            }
                            if (f != 0.0f) {
                                z = z6;
                                z7 = z4;
                                i3 = i2;
                                f4 = f;
                                baseDanmaku6 = baseDanmaku5;
                                isShown = false;
                            } else {
                                z = z6;
                                z7 = z4;
                                i3 = i2;
                                f4 = f;
                                isShown = z3;
                                baseDanmaku6 = baseDanmaku5;
                            }
                        } else {
                            z3 = isShown;
                            baseDanmaku5 = null;
                            z4 = z7;
                            f = f3;
                        }
                    } else {
                        if (z2 && baseDanmaku8 != null) {
                            f2 = baseDanmaku8.getTop();
                            z4 = z7;
                            baseDanmaku5 = null;
                            z5 = false;
                            z3 = false;
                        } else if (baseDanmaku3 != null) {
                            f2 = baseDanmaku3.getBottom();
                            z3 = isShown;
                            baseDanmaku5 = null;
                            z5 = true;
                            z4 = false;
                        } else if (baseDanmaku2 != null) {
                            z4 = z7;
                            f = baseDanmaku2.getTop();
                            baseDanmaku5 = baseDanmaku2;
                            z5 = true;
                            z3 = false;
                            if (!z5) {
                            }
                            if (!z6) {
                            }
                            if (f != 0.0f) {
                            }
                        } else {
                            z3 = isShown;
                            baseDanmaku5 = null;
                            f = 0.0f;
                            z4 = z7;
                        }
                        f = f2;
                        if (!z5) {
                        }
                        if (!z6) {
                        }
                        if (f != 0.0f) {
                        }
                    }
                    z5 = true;
                    if (!z5) {
                    }
                    if (!z6) {
                    }
                    if (f != 0.0f) {
                    }
                } else {
                    z = false;
                }
                if (verifier == null || !verifier.skipLayout(baseDanmaku, f4, i3, z7)) {
                    if (z) {
                        clear();
                    }
                    baseDanmaku.layout(iDisplayer, baseDanmaku.getLeft(), f4);
                    if (!isShown) {
                        this.mVisibleDanmakus.removeItem(baseDanmaku6);
                        this.mVisibleDanmakus.addItem(baseDanmaku);
                    }
                }
            }
        }

        /* access modifiers changed from: protected */
        public boolean isOutVerticalEdge(boolean z, BaseDanmaku baseDanmaku, IDisplayer iDisplayer, float f, BaseDanmaku baseDanmaku2, BaseDanmaku baseDanmaku3) {
            if (f >= 0.0f) {
                return (baseDanmaku2 != null && baseDanmaku2.getTop() > 0.0f) || f + baseDanmaku.paintHeight > ((float) iDisplayer.getHeight());
            }
            return true;
        }

        @Override // master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer.IDanmakusRetainer
        public void clear() {
            this.mCancelFixingFlag = true;
            this.mVisibleDanmakus.clear();
        }
    }

    /* access modifiers changed from: private */
    public static class FTDanmakusRetainer extends AlignTopRetainer {
        private FTDanmakusRetainer() {
            super();
        }

        /* access modifiers changed from: protected */
        @Override // master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer.AlignTopRetainer
        public boolean isOutVerticalEdge(boolean z, BaseDanmaku baseDanmaku, IDisplayer iDisplayer, float f, BaseDanmaku baseDanmaku2, BaseDanmaku baseDanmaku3) {
            return f + baseDanmaku.paintHeight > ((float) iDisplayer.getHeight());
        }
    }

    /* access modifiers changed from: private */
    public static class AlignBottomRetainer extends FTDanmakusRetainer {
        protected Danmakus mVisibleDanmakus;

        private AlignBottomRetainer() {
            super();
            this.mVisibleDanmakus = new Danmakus(2);
        }

        /* JADX WARNING: Code restructure failed: missing block: B:39:0x00a9, code lost:
            r21 = null;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:40:0x00ab, code lost:
            r14 = r1;
         */
        @Override // master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer.AlignTopRetainer, master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer.IDanmakusRetainer
        public void fix(BaseDanmaku baseDanmaku, IDisplayer iDisplayer, Verifier verifier) {
            BaseDanmaku baseDanmaku2;
            int i;
            boolean z;
            BaseDanmaku baseDanmaku3;
            BaseDanmaku baseDanmaku4;
            if (!baseDanmaku.isOutside()) {
                boolean isShown = baseDanmaku.isShown();
                float top = isShown ? baseDanmaku.getTop() : -1.0f;
                int i2 = 1;
                boolean z2 = false;
                boolean z3 = !isShown && !this.mVisibleDanmakus.isEmpty();
                if (top < 0.0f) {
                    top = ((float) iDisplayer.getHeight()) - baseDanmaku.paintHeight;
                }
                BaseDanmaku baseDanmaku5 = null;
                if (!isShown) {
                    this.mCancelFixingFlag = false;
                    IDanmakuIterator it = this.mVisibleDanmakus.iterator();
                    float f = top;
                    BaseDanmaku baseDanmaku6 = null;
                    int i3 = 0;
                    while (true) {
                        if (this.mCancelFixingFlag || !it.hasNext()) {
                            i = i3;
                            baseDanmaku3 = baseDanmaku6;
                        } else {
                            i = i3 + 1;
                            baseDanmaku3 = it.next();
                            if (baseDanmaku3 == baseDanmaku) {
                                baseDanmaku3 = baseDanmaku6;
                                baseDanmaku2 = null;
                                z = false;
                                break;
                            }
                            if (baseDanmaku6 != null) {
                                baseDanmaku4 = baseDanmaku6;
                            } else if (baseDanmaku3.getBottom() != ((float) iDisplayer.getHeight())) {
                                break;
                            } else {
                                baseDanmaku4 = baseDanmaku3;
                            }
                            if (f < 0.0f) {
                                baseDanmaku2 = null;
                                baseDanmaku3 = baseDanmaku4;
                                break;
                            }
                            baseDanmaku2 = baseDanmaku3;
                            z3 = DanmakuUtils.willHitInDuration(iDisplayer, baseDanmaku3, baseDanmaku, baseDanmaku.getDuration(), baseDanmaku.getTimer().currMillisecond);
                            if (!z3) {
                                z = z3;
                                baseDanmaku3 = baseDanmaku4;
                                break;
                            }
                            f = baseDanmaku2.getTop() - baseDanmaku.paintHeight;
                            i3 = i;
                            baseDanmaku6 = baseDanmaku4;
                        }
                    }
                    boolean isOutVerticalEdge = isOutVerticalEdge(false, baseDanmaku, iDisplayer, f, baseDanmaku3, null);
                    if (isOutVerticalEdge) {
                        z2 = isOutVerticalEdge;
                        top = ((float) iDisplayer.getHeight()) - baseDanmaku.paintHeight;
                        baseDanmaku5 = baseDanmaku2;
                        z3 = true;
                    } else {
                        boolean z4 = f >= 0.0f ? false : z;
                        if (baseDanmaku2 != null) {
                            z2 = isOutVerticalEdge;
                            top = f;
                            baseDanmaku5 = baseDanmaku2;
                            i2 = i - 1;
                            z3 = z4;
                        } else {
                            z2 = isOutVerticalEdge;
                            z3 = z4;
                            top = f;
                            i2 = i;
                            baseDanmaku5 = baseDanmaku2;
                        }
                    }
                } else {
                    i2 = 0;
                }
                if (verifier == null || !verifier.skipLayout(baseDanmaku, top, i2, z3)) {
                    if (z2) {
                        clear();
                    }
                    baseDanmaku.layout(iDisplayer, baseDanmaku.getLeft(), top);
                    if (!isShown) {
                        this.mVisibleDanmakus.removeItem(baseDanmaku5);
                        this.mVisibleDanmakus.addItem(baseDanmaku);
                    }
                }
            }
        }

        /* access modifiers changed from: protected */
        @Override // master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer.AlignTopRetainer, master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer.FTDanmakusRetainer
        public boolean isOutVerticalEdge(boolean z, BaseDanmaku baseDanmaku, IDisplayer iDisplayer, float f, BaseDanmaku baseDanmaku2, BaseDanmaku baseDanmaku3) {
            if (f >= 0.0f) {
                return (baseDanmaku2 == null || baseDanmaku2.getBottom() == ((float) iDisplayer.getHeight())) ? false : true;
            }
            return true;
        }

        @Override // master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer.AlignTopRetainer, master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer.IDanmakusRetainer
        public void clear() {
            this.mCancelFixingFlag = true;
            this.mVisibleDanmakus.clear();
        }
    }
}
