package master.flame.danmaku.danmaku.renderer.android;

import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.ICacheManager;
import master.flame.danmaku.danmaku.model.IDanmakuIterator;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.IDrawingCache;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.renderer.IRenderer;
import master.flame.danmaku.danmaku.renderer.Renderer;
import master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer;

public class DanmakuRenderer extends Renderer {
    private ICacheManager mCacheManager;
    private final DanmakuContext mContext;
    private final DanmakusRetainer mDanmakusRetainer;
    private IRenderer.OnDanmakuShownListener mOnDanmakuShownListener;
    private DanmakuTimer mStartTimer;
    private DanmakusRetainer.Verifier mVerifier;
    private final DanmakusRetainer.Verifier verifier = new DanmakusRetainer.Verifier() {
        /* class master.flame.danmaku.danmaku.renderer.android.DanmakuRenderer.AnonymousClass1 */

        @Override // master.flame.danmaku.danmaku.renderer.android.DanmakusRetainer.Verifier
        public boolean skipLayout(BaseDanmaku baseDanmaku, float f, int i, boolean z) {
            if (baseDanmaku.priority != 0 || !DanmakuRenderer.this.mContext.mDanmakuFilters.filterSecondary(baseDanmaku, i, 0, DanmakuRenderer.this.mStartTimer, z, DanmakuRenderer.this.mContext)) {
                return false;
            }
            baseDanmaku.setVisibility(false);
            return true;
        }
    };

    public DanmakuRenderer(DanmakuContext danmakuContext) {
        this.mContext = danmakuContext;
        this.mDanmakusRetainer = new DanmakusRetainer(danmakuContext.isAlignBottom());
    }

    @Override // master.flame.danmaku.danmaku.renderer.IRenderer
    public void clear() {
        clearRetainer();
        this.mContext.mDanmakuFilters.clear();
    }

    @Override // master.flame.danmaku.danmaku.renderer.IRenderer
    public void clearRetainer() {
        this.mDanmakusRetainer.clear();
    }

    @Override // master.flame.danmaku.danmaku.renderer.IRenderer
    public void release() {
        this.mDanmakusRetainer.release();
        this.mContext.mDanmakuFilters.clear();
    }

    @Override // master.flame.danmaku.danmaku.renderer.IRenderer
    public void setVerifierEnabled(boolean z) {
        this.mVerifier = z ? this.verifier : null;
    }

    @Override // master.flame.danmaku.danmaku.renderer.IRenderer
    public void draw(IDisplayer iDisplayer, IDanmakus iDanmakus, long j, IRenderer.RenderingState renderingState) {
        this.mStartTimer = renderingState.timer;
        IDanmakuIterator it = iDanmakus.iterator();
        BaseDanmaku baseDanmaku = null;
        while (true) {
            if (!it.hasNext()) {
                break;
            }
            baseDanmaku = it.next();
            if (baseDanmaku.isTimeOut()) {
                iDisplayer.recycle(baseDanmaku);
            } else if (renderingState.isRunningDanmakus || !baseDanmaku.isOffset()) {
                if (!baseDanmaku.hasPassedFilter()) {
                    this.mContext.mDanmakuFilters.filter(baseDanmaku, renderingState.indexInScreen, renderingState.totalSizeInScreen, renderingState.timer, false, this.mContext);
                }
                if (baseDanmaku.getActualTime() >= j && (baseDanmaku.priority != 0 || !baseDanmaku.isFiltered())) {
                    if (baseDanmaku.isLate()) {
                        IDrawingCache<?> drawingCache = baseDanmaku.getDrawingCache();
                        if (this.mCacheManager != null && (drawingCache == null || drawingCache.get() == null)) {
                            this.mCacheManager.addDanmaku(baseDanmaku);
                        }
                    } else {
                        if (baseDanmaku.getType() == 1) {
                            renderingState.indexInScreen++;
                        }
                        if (!baseDanmaku.isMeasured()) {
                            baseDanmaku.measure(iDisplayer, false);
                        }
                        if (!baseDanmaku.isPrepared()) {
                            baseDanmaku.prepare(iDisplayer, false);
                        }
                        this.mDanmakusRetainer.fix(baseDanmaku, iDisplayer, this.mVerifier);
                        if (baseDanmaku.isShown() && (baseDanmaku.lines != null || baseDanmaku.getBottom() <= ((float) iDisplayer.getHeight()))) {
                            int draw = baseDanmaku.draw(iDisplayer);
                            if (draw == 1) {
                                renderingState.cacheHitCount++;
                            } else if (draw == 2) {
                                renderingState.cacheMissCount++;
                                ICacheManager iCacheManager = this.mCacheManager;
                                if (iCacheManager != null) {
                                    iCacheManager.addDanmaku(baseDanmaku);
                                }
                            }
                            renderingState.addCount(baseDanmaku.getType(), 1);
                            renderingState.addTotalCount(1);
                            renderingState.appendToRunningDanmakus(baseDanmaku);
                            if (!(this.mOnDanmakuShownListener == null || baseDanmaku.firstShownFlag == this.mContext.mGlobalFlagValues.FIRST_SHOWN_RESET_FLAG)) {
                                baseDanmaku.firstShownFlag = this.mContext.mGlobalFlagValues.FIRST_SHOWN_RESET_FLAG;
                                this.mOnDanmakuShownListener.onDanmakuShown(baseDanmaku);
                            }
                        }
                    }
                }
            } else {
                it.remove();
            }
        }
        renderingState.lastDanmaku = baseDanmaku;
    }

    @Override // master.flame.danmaku.danmaku.renderer.IRenderer
    public void setCacheManager(ICacheManager iCacheManager) {
        this.mCacheManager = iCacheManager;
    }

    @Override // master.flame.danmaku.danmaku.renderer.IRenderer
    public void setOnDanmakuShownListener(IRenderer.OnDanmakuShownListener onDanmakuShownListener) {
        this.mOnDanmakuShownListener = onDanmakuShownListener;
    }

    @Override // master.flame.danmaku.danmaku.renderer.IRenderer
    public void removeOnDanmakuShownListener() {
        this.mOnDanmakuShownListener = null;
    }

    @Override // master.flame.danmaku.danmaku.renderer.IRenderer
    public void alignBottom(boolean z) {
        DanmakusRetainer danmakusRetainer = this.mDanmakusRetainer;
        if (danmakusRetainer != null) {
            danmakusRetainer.alignBottom(z);
        }
    }
}
