package master.flame.danmaku.danmaku.model.android;

import android.graphics.Canvas;
import android.graphics.Paint;
import android.text.TextPaint;
import java.util.HashMap;
import java.util.Map;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.android.AndroidDisplayer;

public class SimpleTextCacheStuffer extends BaseCacheStuffer {
    private static final Map<Float, Float> sTextHeightCache = new HashMap();

    /* access modifiers changed from: protected */
    public void drawBackground(BaseDanmaku baseDanmaku, Canvas canvas, float f, float f2) {
    }

    /* access modifiers changed from: protected */
    public Float getCacheHeight(BaseDanmaku baseDanmaku, Paint paint) {
        Float valueOf = Float.valueOf(paint.getTextSize());
        Map<Float, Float> map = sTextHeightCache;
        Float f = map.get(valueOf);
        if (f != null) {
            return f;
        }
        Paint.FontMetrics fontMetrics = paint.getFontMetrics();
        Float valueOf2 = Float.valueOf((fontMetrics.descent - fontMetrics.ascent) + fontMetrics.leading);
        map.put(valueOf, valueOf2);
        return valueOf2;
    }

    @Override // master.flame.danmaku.danmaku.model.android.BaseCacheStuffer
    public void measure(BaseDanmaku baseDanmaku, TextPaint textPaint, boolean z) {
        float f = 0.0f;
        Float valueOf = Float.valueOf(0.0f);
        if (baseDanmaku.lines == null) {
            if (baseDanmaku.text != null) {
                f = textPaint.measureText(baseDanmaku.text.toString());
                valueOf = getCacheHeight(baseDanmaku, textPaint);
            }
            baseDanmaku.paintWidth = f;
            baseDanmaku.paintHeight = valueOf.floatValue();
            return;
        }
        Float cacheHeight = getCacheHeight(baseDanmaku, textPaint);
        String[] strArr = baseDanmaku.lines;
        for (String str : strArr) {
            if (str.length() > 0) {
                f = Math.max(textPaint.measureText(str), f);
            }
        }
        baseDanmaku.paintWidth = f;
        baseDanmaku.paintHeight = ((float) baseDanmaku.lines.length) * cacheHeight.floatValue();
    }

    /* access modifiers changed from: protected */
    public void drawStroke(BaseDanmaku baseDanmaku, String str, Canvas canvas, float f, float f2, Paint paint) {
        if (str != null) {
            canvas.drawText(str, f, f2, paint);
        } else {
            canvas.drawText(baseDanmaku.text.toString(), f, f2, paint);
        }
    }

    /* access modifiers changed from: protected */
    public void drawText(BaseDanmaku baseDanmaku, String str, Canvas canvas, float f, float f2, TextPaint textPaint, boolean z) {
        if (str != null) {
            canvas.drawText(str, f, f2, textPaint);
        } else {
            canvas.drawText(baseDanmaku.text.toString(), f, f2, textPaint);
        }
    }

    @Override // master.flame.danmaku.danmaku.model.android.BaseCacheStuffer
    public void clearCaches() {
        sTextHeightCache.clear();
    }

    @Override // master.flame.danmaku.danmaku.model.android.BaseCacheStuffer
    public void drawDanmaku(BaseDanmaku baseDanmaku, Canvas canvas, float f, float f2, boolean z, AndroidDisplayer.DisplayerConfig displayerConfig) {
        float f3;
        float f4;
        String[] strArr;
        int i;
        float f5;
        float f6;
        float f7;
        float f8;
        float f9 = f + ((float) baseDanmaku.padding);
        float f10 = f2 + ((float) baseDanmaku.padding);
        if (baseDanmaku.borderColor != 0) {
            f9 += 4.0f;
            f10 += 4.0f;
        }
        displayerConfig.definePaintParams(z);
        TextPaint paint = displayerConfig.getPaint(baseDanmaku, z);
        drawBackground(baseDanmaku, canvas, f, f2);
        boolean z2 = true;
        if (baseDanmaku.lines != null) {
            String[] strArr2 = baseDanmaku.lines;
            if (strArr2.length == 1) {
                if (displayerConfig.hasStroke(baseDanmaku)) {
                    displayerConfig.applyPaintConfig(baseDanmaku, paint, true);
                    float ascent = f10 - paint.ascent();
                    if (displayerConfig.HAS_PROJECTION) {
                        float f11 = displayerConfig.sProjectionOffsetX + f9;
                        f7 = ascent + displayerConfig.sProjectionOffsetY;
                        f8 = f11;
                    } else {
                        f7 = ascent;
                        f8 = f9;
                    }
                    drawStroke(baseDanmaku, strArr2[0], canvas, f8, f7, paint);
                }
                displayerConfig.applyPaintConfig(baseDanmaku, paint, false);
                drawText(baseDanmaku, strArr2[0], canvas, f9, f10 - paint.ascent(), paint, z);
            } else {
                float length = (baseDanmaku.paintHeight - ((float) (baseDanmaku.padding * 2))) / ((float) strArr2.length);
                int i2 = 0;
                while (i2 < strArr2.length) {
                    if (strArr2[i2] == null || strArr2[i2].length() == 0) {
                        i = i2;
                        strArr = strArr2;
                    } else {
                        if (displayerConfig.hasStroke(baseDanmaku)) {
                            displayerConfig.applyPaintConfig(baseDanmaku, paint, z2);
                            float ascent2 = ((((float) i2) * length) + f10) - paint.ascent();
                            if (displayerConfig.HAS_PROJECTION) {
                                float f12 = displayerConfig.sProjectionOffsetX + f9;
                                f5 = ascent2 + displayerConfig.sProjectionOffsetY;
                                f6 = f12;
                            } else {
                                f5 = ascent2;
                                f6 = f9;
                            }
                            i = i2;
                            drawStroke(baseDanmaku, strArr2[i2], canvas, f6, f5, paint);
                        } else {
                            i = i2;
                        }
                        displayerConfig.applyPaintConfig(baseDanmaku, paint, false);
                        strArr = strArr2;
                        drawText(baseDanmaku, strArr2[i], canvas, f9, ((((float) i) * length) + f10) - paint.ascent(), paint, z);
                    }
                    i2 = i + 1;
                    strArr2 = strArr;
                    z2 = true;
                }
            }
        } else {
            if (displayerConfig.hasStroke(baseDanmaku)) {
                displayerConfig.applyPaintConfig(baseDanmaku, paint, true);
                float ascent3 = f10 - paint.ascent();
                if (displayerConfig.HAS_PROJECTION) {
                    float f13 = displayerConfig.sProjectionOffsetX + f9;
                    f3 = ascent3 + displayerConfig.sProjectionOffsetY;
                    f4 = f13;
                } else {
                    f3 = ascent3;
                    f4 = f9;
                }
                drawStroke(baseDanmaku, null, canvas, f4, f3, paint);
            }
            displayerConfig.applyPaintConfig(baseDanmaku, paint, false);
            drawText(baseDanmaku, null, canvas, f9, f10 - paint.ascent(), paint, z);
        }
        if (baseDanmaku.underlineColor != 0) {
            Paint underlinePaint = displayerConfig.getUnderlinePaint(baseDanmaku);
            float f14 = (f2 + baseDanmaku.paintHeight) - ((float) displayerConfig.UNDERLINE_HEIGHT);
            canvas.drawLine(f, f14, f + baseDanmaku.paintWidth, f14, underlinePaint);
        }
        if (baseDanmaku.borderColor != 0) {
            canvas.drawRect(f, f2, f + baseDanmaku.paintWidth, f2 + baseDanmaku.paintHeight, displayerConfig.getBorderPaint(baseDanmaku));
        }
    }
}
