package master.flame.danmaku.controller;

import android.graphics.Canvas;
import master.flame.danmaku.controller.IDrawTask;
import master.flame.danmaku.danmaku.model.AbsDisplayer;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.IDanmakuIterator;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.renderer.IRenderer;
import master.flame.danmaku.danmaku.renderer.android.DanmakuRenderer;
import master.flame.danmaku.danmaku.util.SystemClock;

public class DrawTask implements IDrawTask {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    protected boolean clearRetainerFlag;
    protected IDanmakus danmakuList;
    private IDanmakus danmakus = new Danmakus(4);
    private DanmakuContext.ConfigChangedCallback mConfigChangedCallback = new DanmakuContext.ConfigChangedCallback() {
        /* class master.flame.danmaku.controller.DrawTask.AnonymousClass1 */

        @Override // master.flame.danmaku.danmaku.model.android.DanmakuContext.ConfigChangedCallback
        public boolean onDanmakuConfigChanged(DanmakuContext danmakuContext, DanmakuContext.DanmakuConfigTag danmakuConfigTag, Object... objArr) {
            return DrawTask.this.onDanmakuConfigChanged(danmakuContext, danmakuConfigTag, objArr);
        }
    };
    protected final DanmakuContext mContext;
    protected final AbsDisplayer mDisp;
    private boolean mIsHidden;
    private long mLastBeginMills;
    private BaseDanmaku mLastDanmaku;
    private long mLastEndMills;
    private Danmakus mLiveDanmakus = new Danmakus(4);
    protected BaseDanmakuParser mParser;
    protected int mPlayState;
    protected boolean mReadyState;
    final IRenderer mRenderer;
    private final IRenderer.RenderingState mRenderingState = new IRenderer.RenderingState();
    private IDanmakus mRunningDanmakus;
    private long mStartRenderTime = 0;
    IDrawTask.TaskListener mTaskListener;
    DanmakuTimer mTimer;

    /* access modifiers changed from: protected */
    public void onDanmakuRemoved(BaseDanmaku baseDanmaku) {
    }

    public DrawTask(DanmakuTimer danmakuTimer, DanmakuContext danmakuContext, IDrawTask.TaskListener taskListener) {
        if (danmakuContext != null) {
            this.mContext = danmakuContext;
            this.mDisp = danmakuContext.getDisplayer();
            this.mTaskListener = taskListener;
            DanmakuRenderer danmakuRenderer = new DanmakuRenderer(danmakuContext);
            this.mRenderer = danmakuRenderer;
            danmakuRenderer.setOnDanmakuShownListener(new IRenderer.OnDanmakuShownListener() {
                /* class master.flame.danmaku.controller.DrawTask.AnonymousClass2 */

                @Override // master.flame.danmaku.danmaku.renderer.IRenderer.OnDanmakuShownListener
                public void onDanmakuShown(BaseDanmaku baseDanmaku) {
                    if (DrawTask.this.mTaskListener != null) {
                        DrawTask.this.mTaskListener.onDanmakuShown(baseDanmaku);
                    }
                }
            });
            danmakuRenderer.setVerifierEnabled(danmakuContext.isPreventOverlappingEnabled() || danmakuContext.isMaxLinesLimited());
            initTimer(danmakuTimer);
            Boolean valueOf = Boolean.valueOf(danmakuContext.isDuplicateMergingEnabled());
            if (valueOf == null) {
                return;
            }
            if (valueOf.booleanValue()) {
                danmakuContext.mDanmakuFilters.registerFilter(DanmakuFilters.TAG_DUPLICATE_FILTER);
            } else {
                danmakuContext.mDanmakuFilters.unregisterFilter(DanmakuFilters.TAG_DUPLICATE_FILTER);
            }
        } else {
            throw new IllegalArgumentException("context is null");
        }
    }

    /* access modifiers changed from: protected */
    public void initTimer(DanmakuTimer danmakuTimer) {
        this.mTimer = danmakuTimer;
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public synchronized void addDanmaku(BaseDanmaku baseDanmaku) {
        boolean addItem;
        IDrawTask.TaskListener taskListener;
        boolean addItem2;
        if (this.danmakuList != null) {
            if (baseDanmaku.isLive) {
                this.mLiveDanmakus.addItem(baseDanmaku);
                removeUnusedLiveDanmakusIn(10);
            }
            baseDanmaku.index = this.danmakuList.size();
            boolean z = true;
            if (this.mLastBeginMills <= baseDanmaku.getActualTime() && baseDanmaku.getActualTime() <= this.mLastEndMills) {
                synchronized (this.danmakus) {
                    addItem2 = this.danmakus.addItem(baseDanmaku);
                }
                z = addItem2;
            } else if (baseDanmaku.isLive) {
                z = false;
            }
            synchronized (this.danmakuList) {
                addItem = this.danmakuList.addItem(baseDanmaku);
            }
            if (!z) {
                this.mLastEndMills = 0;
                this.mLastBeginMills = 0;
            }
            if (addItem && (taskListener = this.mTaskListener) != null) {
                taskListener.onDanmakuAdd(baseDanmaku);
            }
            BaseDanmaku baseDanmaku2 = this.mLastDanmaku;
            if (baseDanmaku2 == null || !(baseDanmaku == null || baseDanmaku2 == null || baseDanmaku.getActualTime() <= this.mLastDanmaku.getActualTime())) {
                this.mLastDanmaku = baseDanmaku;
            }
        }
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void invalidateDanmaku(BaseDanmaku baseDanmaku, boolean z) {
        this.mContext.getDisplayer().getCacheStuffer().clearCache(baseDanmaku);
        baseDanmaku.requestFlags |= 2;
        if (z) {
            baseDanmaku.paintWidth = -1.0f;
            baseDanmaku.paintHeight = -1.0f;
            baseDanmaku.requestFlags |= 1;
            baseDanmaku.measureResetFlag++;
        }
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public synchronized void removeAllDanmakus(boolean z) {
        IDanmakus iDanmakus = this.danmakuList;
        if (iDanmakus != null) {
            if (!iDanmakus.isEmpty()) {
                synchronized (this.danmakuList) {
                    if (!z) {
                        IDanmakus subnew = this.danmakuList.subnew((this.mTimer.currMillisecond - this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION) - 100, this.mTimer.currMillisecond + this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION);
                        if (subnew != null) {
                            this.danmakus = subnew;
                        }
                    }
                    this.danmakuList.clear();
                }
            }
        }
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public synchronized void removeAllLiveDanmakus() {
        IDanmakus iDanmakus = this.danmakus;
        if (iDanmakus != null) {
            if (!iDanmakus.isEmpty()) {
                synchronized (this.danmakus) {
                    IDanmakuIterator it = this.danmakus.iterator();
                    while (it.hasNext()) {
                        BaseDanmaku next = it.next();
                        if (next.isLive) {
                            it.remove();
                            onDanmakuRemoved(next);
                        }
                    }
                }
            }
        }
    }

    /* access modifiers changed from: protected */
    public synchronized void removeUnusedLiveDanmakusIn(int i) {
        BaseDanmaku next;
        boolean isTimeOut;
        IDanmakus iDanmakus = this.danmakuList;
        if (iDanmakus != null && !iDanmakus.isEmpty()) {
            if (!this.mLiveDanmakus.isEmpty()) {
                long uptimeMillis = SystemClock.uptimeMillis();
                IDanmakuIterator it = this.mLiveDanmakus.iterator();
                while (it.hasNext() && (isTimeOut = (next = it.next()).isTimeOut())) {
                    it.remove();
                    this.danmakuList.removeItem(next);
                    onDanmakuRemoved(next);
                    if (isTimeOut) {
                        if (SystemClock.uptimeMillis() - uptimeMillis > ((long) i)) {
                            break;
                        }
                    } else {
                        break;
                    }
                }
            }
        }
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public IDanmakus getVisibleDanmakusOnTime(long j) {
        long j2 = j + this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION;
        IDanmakus subnew = this.danmakuList.subnew((j - this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION) - 100, j2);
        Danmakus danmakus2 = new Danmakus();
        if (subnew != null && !subnew.isEmpty()) {
            IDanmakuIterator it = subnew.iterator();
            while (it.hasNext()) {
                BaseDanmaku next = it.next();
                if (next.isShown() && !next.isOutside()) {
                    danmakus2.addItem(next);
                }
            }
        }
        return danmakus2;
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public synchronized IRenderer.RenderingState draw(AbsDisplayer absDisplayer) {
        return drawDanmakus(absDisplayer, this.mTimer);
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void reset() {
        if (this.danmakus != null) {
            this.danmakus = new Danmakus();
        }
        IRenderer iRenderer = this.mRenderer;
        if (iRenderer != null) {
            iRenderer.clear();
        }
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void seek(long j) {
        BaseDanmaku last;
        reset();
        this.mContext.mGlobalFlagValues.updateVisibleFlag();
        this.mContext.mGlobalFlagValues.updateFirstShownFlag();
        this.mContext.mGlobalFlagValues.updateSyncOffsetTimeFlag();
        this.mContext.mGlobalFlagValues.updatePrepareFlag();
        this.mRunningDanmakus = new Danmakus(4);
        if (j < 1000) {
            j = 0;
        }
        this.mStartRenderTime = j;
        this.mRenderingState.reset();
        this.mRenderingState.endTime = this.mStartRenderTime;
        this.mLastEndMills = 0;
        this.mLastBeginMills = 0;
        IDanmakus iDanmakus = this.danmakuList;
        if (iDanmakus != null && (last = iDanmakus.last()) != null && !last.isTimeOut()) {
            this.mLastDanmaku = last;
        }
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void clearDanmakusOnScreen(long j) {
        reset();
        this.mContext.mGlobalFlagValues.updateVisibleFlag();
        this.mContext.mGlobalFlagValues.updateFirstShownFlag();
        this.mStartRenderTime = j;
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void start() {
        this.mContext.registerConfigChangedCallback(this.mConfigChangedCallback);
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void quit() {
        this.mContext.unregisterAllConfigChangedCallbacks();
        IRenderer iRenderer = this.mRenderer;
        if (iRenderer != null) {
            iRenderer.release();
        }
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void prepare() {
        loadDanmakus(this.mParser);
        this.mLastEndMills = 0;
        this.mLastBeginMills = 0;
        IDrawTask.TaskListener taskListener = this.mTaskListener;
        if (taskListener != null) {
            taskListener.ready();
            this.mReadyState = true;
        }
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void onPlayStateChanged(int i) {
        this.mPlayState = i;
    }

    /* access modifiers changed from: protected */
    public void loadDanmakus(BaseDanmakuParser baseDanmakuParser) {
        IDanmakus danmakus2 = baseDanmakuParser.setConfig(this.mContext).setDisplayer(this.mDisp).setTimer(this.mTimer).getDanmakus();
        this.danmakuList = danmakus2;
        if (danmakus2 != null && !danmakus2.isEmpty() && this.danmakuList.first().flags == null) {
            IDanmakuIterator it = this.danmakuList.iterator();
            while (it.hasNext()) {
                BaseDanmaku next = it.next();
                if (next != null) {
                    next.flags = this.mContext.mGlobalFlagValues;
                }
            }
        }
        this.mContext.mGlobalFlagValues.resetAll();
        IDanmakus iDanmakus = this.danmakuList;
        if (iDanmakus != null) {
            this.mLastDanmaku = iDanmakus.last();
        }
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void setParser(BaseDanmakuParser baseDanmakuParser) {
        this.mParser = baseDanmakuParser;
        this.mReadyState = false;
    }

    /* access modifiers changed from: protected */
    public IRenderer.RenderingState drawDanmakus(AbsDisplayer absDisplayer, DanmakuTimer danmakuTimer) {
        long j;
        long j2;
        IDanmakus iDanmakus;
        IDanmakus iDanmakus2;
        if (this.clearRetainerFlag) {
            this.mRenderer.clearRetainer();
            this.clearRetainerFlag = false;
        }
        if (this.danmakuList == null) {
            return null;
        }
        DrawHelper.clearCanvas((Canvas) absDisplayer.getExtraData());
        if (this.mIsHidden) {
            return this.mRenderingState;
        }
        IRenderer.RenderingState renderingState = this.mRenderingState;
        long j3 = (danmakuTimer.currMillisecond - this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION) - 100;
        long j4 = danmakuTimer.currMillisecond + this.mContext.mDanmakuFactory.MAX_DANMAKU_DURATION;
        IDanmakus iDanmakus3 = this.danmakus;
        if (this.mLastBeginMills <= j3) {
            long j5 = danmakuTimer.currMillisecond;
            long j6 = this.mLastEndMills;
            if (j5 <= j6) {
                iDanmakus = iDanmakus3;
                j = j6;
                j2 = this.mLastBeginMills;
                iDanmakus2 = this.mRunningDanmakus;
                beginTracing(renderingState, iDanmakus2, iDanmakus);
                if (iDanmakus2 != null && !iDanmakus2.isEmpty()) {
                    this.mRenderingState.isRunningDanmakus = true;
                    this.mRenderer.draw(absDisplayer, iDanmakus2, 0, this.mRenderingState);
                }
                this.mRenderingState.isRunningDanmakus = false;
                if (iDanmakus != null || iDanmakus.isEmpty()) {
                    renderingState.nothingRendered = true;
                    renderingState.beginTime = j2;
                    renderingState.endTime = j;
                    return renderingState;
                }
                this.mRenderer.draw(this.mDisp, iDanmakus, this.mStartRenderTime, renderingState);
                endTracing(renderingState);
                if (renderingState.nothingRendered) {
                    BaseDanmaku baseDanmaku = this.mLastDanmaku;
                    if (baseDanmaku != null && baseDanmaku.isTimeOut()) {
                        this.mLastDanmaku = null;
                        IDrawTask.TaskListener taskListener = this.mTaskListener;
                        if (taskListener != null) {
                            taskListener.onDanmakusDrawingFinished();
                        }
                    }
                    if (renderingState.beginTime == -1) {
                        renderingState.beginTime = j2;
                    }
                    if (renderingState.endTime == -1) {
                        renderingState.endTime = j;
                    }
                }
                return renderingState;
            }
        }
        IDanmakus sub = this.danmakuList.sub(j3, j4);
        if (sub != null) {
            this.danmakus = sub;
        }
        this.mLastBeginMills = j3;
        this.mLastEndMills = j4;
        j2 = j3;
        j = j4;
        iDanmakus = sub;
        iDanmakus2 = this.mRunningDanmakus;
        beginTracing(renderingState, iDanmakus2, iDanmakus);
        this.mRenderingState.isRunningDanmakus = true;
        this.mRenderer.draw(absDisplayer, iDanmakus2, 0, this.mRenderingState);
        this.mRenderingState.isRunningDanmakus = false;
        if (iDanmakus != null) {
        }
        renderingState.nothingRendered = true;
        renderingState.beginTime = j2;
        renderingState.endTime = j;
        return renderingState;
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void requestClear() {
        this.mLastEndMills = 0;
        this.mLastBeginMills = 0;
        this.mIsHidden = false;
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void requestClearRetainer() {
        this.clearRetainerFlag = true;
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void requestSync(long j, long j2, long j3) {
        IDanmakus obtainRunningDanmakus = this.mRenderingState.obtainRunningDanmakus();
        this.mRunningDanmakus = obtainRunningDanmakus;
        IDanmakuIterator it = obtainRunningDanmakus.iterator();
        while (it.hasNext()) {
            BaseDanmaku next = it.next();
            if (next.isOutside()) {
                it.remove();
            } else {
                next.setTimeOffset(next.timeOffset + j3);
                next.isOffset = true;
            }
        }
        this.mStartRenderTime = j2;
    }

    public boolean onDanmakuConfigChanged(DanmakuContext danmakuContext, DanmakuContext.DanmakuConfigTag danmakuConfigTag, Object... objArr) {
        boolean handleOnDanmakuConfigChanged = handleOnDanmakuConfigChanged(danmakuContext, danmakuConfigTag, objArr);
        IDrawTask.TaskListener taskListener = this.mTaskListener;
        if (taskListener != null) {
            taskListener.onDanmakuConfigChanged();
        }
        return handleOnDanmakuConfigChanged;
    }

    /* access modifiers changed from: protected */
    public boolean handleOnDanmakuConfigChanged(DanmakuContext danmakuContext, DanmakuContext.DanmakuConfigTag danmakuConfigTag, Object[] objArr) {
        Boolean bool;
        boolean z = false;
        if (danmakuConfigTag == null || DanmakuContext.DanmakuConfigTag.MAXIMUM_NUMS_IN_SCREEN.equals(danmakuConfigTag)) {
            return true;
        }
        if (DanmakuContext.DanmakuConfigTag.DUPLICATE_MERGING_ENABLED.equals(danmakuConfigTag)) {
            Boolean bool2 = (Boolean) objArr[0];
            if (bool2 != null) {
                if (bool2.booleanValue()) {
                    this.mContext.mDanmakuFilters.registerFilter(DanmakuFilters.TAG_DUPLICATE_FILTER);
                    return true;
                }
                this.mContext.mDanmakuFilters.unregisterFilter(DanmakuFilters.TAG_DUPLICATE_FILTER);
                return true;
            }
        } else if (DanmakuContext.DanmakuConfigTag.SCALE_TEXTSIZE.equals(danmakuConfigTag) || DanmakuContext.DanmakuConfigTag.SCROLL_SPEED_FACTOR.equals(danmakuConfigTag)) {
            requestClearRetainer();
        } else if (DanmakuContext.DanmakuConfigTag.MAXIMUN_LINES.equals(danmakuConfigTag) || DanmakuContext.DanmakuConfigTag.OVERLAPPING_ENABLE.equals(danmakuConfigTag)) {
            IRenderer iRenderer = this.mRenderer;
            if (iRenderer == null) {
                return true;
            }
            if (this.mContext.isPreventOverlappingEnabled() || this.mContext.isMaxLinesLimited()) {
                z = true;
            }
            iRenderer.setVerifierEnabled(z);
            return true;
        } else if (DanmakuContext.DanmakuConfigTag.ALIGN_BOTTOM.equals(danmakuConfigTag) && (bool = (Boolean) objArr[0]) != null) {
            IRenderer iRenderer2 = this.mRenderer;
            if (iRenderer2 == null) {
                return true;
            }
            iRenderer2.alignBottom(bool.booleanValue());
            return true;
        }
        return false;
    }

    @Override // master.flame.danmaku.controller.IDrawTask
    public void requestHide() {
        this.mIsHidden = true;
    }

    private void beginTracing(IRenderer.RenderingState renderingState, IDanmakus iDanmakus, IDanmakus iDanmakus2) {
        renderingState.reset();
        renderingState.timer.update(SystemClock.uptimeMillis());
        int i = 0;
        renderingState.indexInScreen = 0;
        int size = iDanmakus != null ? iDanmakus.size() : 0;
        if (iDanmakus2 != null) {
            i = iDanmakus2.size();
        }
        renderingState.totalSizeInScreen = size + i;
    }

    private void endTracing(IRenderer.RenderingState renderingState) {
        renderingState.nothingRendered = renderingState.totalDanmakuCount == 0;
        long j = -1;
        if (renderingState.nothingRendered) {
            renderingState.beginTime = -1;
        }
        BaseDanmaku baseDanmaku = renderingState.lastDanmaku;
        renderingState.lastDanmaku = null;
        if (baseDanmaku != null) {
            j = baseDanmaku.getActualTime();
        }
        renderingState.endTime = j;
        renderingState.consumingTime = renderingState.timer.update(SystemClock.uptimeMillis());
    }
}
