package master.flame.danmaku.controller;

import android.content.Context;
import android.graphics.Canvas;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.util.DisplayMetrics;
import java.util.LinkedList;
import master.flame.danmaku.controller.IDrawTask;
import master.flame.danmaku.danmaku.model.AbsDanmakuSync;
import master.flame.danmaku.danmaku.model.AbsDisplayer;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.IDanmakus;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.renderer.IRenderer;
import master.flame.danmaku.danmaku.util.AndroidUtils;
import master.flame.danmaku.danmaku.util.SystemClock;
import tv.cjump.jni.DeviceUtils;

public class DrawHandler extends Handler {
    private static final int CLEAR_DANMAKUS_ON_SCREEN = 13;
    private static final int HIDE_DANMAKUS = 9;
    private static final long INDEFINITE_TIME = 10000000;
    private static final int MAX_RECORD_SIZE = 500;
    private static final int NOTIFY_DISP_SIZE_CHANGED = 10;
    private static final int NOTIFY_RENDERING = 11;
    private static final int PAUSE = 7;
    public static final int PREPARE = 5;
    private static final int QUIT = 6;
    public static final int RESUME = 3;
    public static final int SEEK_POS = 4;
    private static final int SHOW_DANMAKUS = 8;
    public static final int START = 1;
    public static final int UPDATE = 2;
    private static final int UPDATE_WHEN_PAUSED = 12;
    public IDrawTask drawTask;
    private Callback mCallback;
    private DanmakuContext mContext;
    private long mCordonTime = 30;
    private long mCordonTime2 = 60;
    private IDanmakuViewController mDanmakuView;
    private boolean mDanmakusVisible = true;
    private long mDesireSeekingTime;
    private AbsDisplayer mDisp;
    private LinkedList<Long> mDrawTimes = new LinkedList<>();
    private long mFrameUpdateRate = 16;
    private boolean mIdleSleep;
    private boolean mInSeekingAction;
    private boolean mInSyncAction;
    private boolean mInWaitingState;
    private long mLastDeltaTime;
    private BaseDanmakuParser mParser;
    private boolean mReady;
    private long mRemainingTime;
    private final IRenderer.RenderingState mRenderingState = new IRenderer.RenderingState();
    private UpdateThread mThread;
    private long mThresholdTime;
    private long mTimeBase;
    private final boolean mUpdateInNewThread;
    private long pausedPosition = 0;
    private boolean quitFlag = true;
    private DanmakuTimer timer = new DanmakuTimer();

    public interface Callback {
        void danmakuShown(BaseDanmaku baseDanmaku);

        void drawingFinished();

        void prepared();

        void updateTimer(DanmakuTimer danmakuTimer);
    }

    public DrawHandler(Looper looper, IDanmakuViewController iDanmakuViewController, boolean z) {
        super(looper);
        this.mUpdateInNewThread = Runtime.getRuntime().availableProcessors() > 3;
        this.mIdleSleep = true ^ DeviceUtils.isProblemBoxDevice();
        bindView(iDanmakuViewController);
        if (z) {
            showDanmakus(null);
        } else {
            hideDanmakus(false);
        }
        this.mDanmakusVisible = z;
    }

    private void bindView(IDanmakuViewController iDanmakuViewController) {
        this.mDanmakuView = iDanmakuViewController;
    }

    public void setConfig(DanmakuContext danmakuContext) {
        this.mContext = danmakuContext;
    }

    public void setParser(BaseDanmakuParser baseDanmakuParser) {
        this.mParser = baseDanmakuParser;
    }

    public void setCallback(Callback callback) {
        this.mCallback = callback;
    }

    public void quit() {
        sendEmptyMessage(6);
    }

    public boolean isStop() {
        return this.quitFlag;
    }

    /* JADX WARNING: Removed duplicated region for block: B:108:? A[RETURN, SYNTHETIC] */
    /* JADX WARNING: Removed duplicated region for block: B:44:0x00d9  */
    /* JADX WARNING: Removed duplicated region for block: B:47:0x00df  */
    /* JADX WARNING: Removed duplicated region for block: B:50:0x00f2  */
    /* JADX WARNING: Removed duplicated region for block: B:52:0x00fa  */
    /* JADX WARNING: Removed duplicated region for block: B:73:0x0152  */
    /* JADX WARNING: Removed duplicated region for block: B:74:0x0159  */
    /* JADX WARNING: Removed duplicated region for block: B:77:0x0160  */
    /* JADX WARNING: Removed duplicated region for block: B:83:0x01a2  */
    /* JADX WARNING: Removed duplicated region for block: B:86:0x01d2  */
    /* JADX WARNING: Removed duplicated region for block: B:97:? A[RETURN, SYNTHETIC] */
    public void handleMessage(Message message) {
        Long l;
        IDrawTask iDrawTask;
        boolean z;
        IDanmakuViewController iDanmakuViewController;
        IDrawTask iDrawTask2;
        int i = message.what;
        switch (i) {
            case 1:
                l = (Long) message.obj;
                if (l != null) {
                    this.pausedPosition = l.longValue();
                } else {
                    this.pausedPosition = 0;
                }
                if (i == 4) {
                    this.quitFlag = true;
                    quitUpdateThread();
                    Long l2 = (Long) message.obj;
                    this.mTimeBase -= l2.longValue() - this.timer.currMillisecond;
                    this.timer.update(l2.longValue());
                    this.mContext.mGlobalFlagValues.updateMeasureFlag();
                    IDrawTask iDrawTask3 = this.drawTask;
                    if (iDrawTask3 != null) {
                        iDrawTask3.seek(l2.longValue());
                    }
                    this.pausedPosition = l2.longValue();
                }
                removeMessages(7);
                this.quitFlag = false;
                if (this.mReady) {
                    this.mRenderingState.reset();
                    this.mDrawTimes.clear();
                    long uptimeMillis = SystemClock.uptimeMillis();
                    long j = this.pausedPosition;
                    this.mTimeBase = uptimeMillis - j;
                    this.timer.update(j);
                    removeMessages(3);
                    sendEmptyMessage(2);
                    this.drawTask.start();
                    notifyRendering();
                    this.mInSeekingAction = false;
                    IDrawTask iDrawTask4 = this.drawTask;
                    if (iDrawTask4 != null) {
                        iDrawTask4.onPlayStateChanged(1);
                        return;
                    }
                    return;
                }
                sendEmptyMessageDelayed(3, 100);
                return;
            case 2:
                if (this.mUpdateInNewThread) {
                    updateInNewThread();
                    return;
                } else {
                    updateInCurrentThread();
                    return;
                }
            case 3:
                removeMessages(7);
                this.quitFlag = false;
                if (this.mReady) {
                }
                break;
            case 4:
                if (i == 4) {
                }
                removeMessages(7);
                this.quitFlag = false;
                if (this.mReady) {
                }
                break;
            case 5:
                this.mTimeBase = SystemClock.uptimeMillis();
                if (this.mParser == null || !this.mDanmakuView.isViewReady()) {
                    sendEmptyMessageDelayed(5, 100);
                    return;
                } else {
                    prepare(new Runnable() {
                        /* class master.flame.danmaku.controller.DrawHandler.AnonymousClass1 */

                        public void run() {
                            DrawHandler.this.pausedPosition = 0;
                            DrawHandler.this.mReady = true;
                            if (DrawHandler.this.mCallback != null) {
                                DrawHandler.this.mCallback.prepared();
                            }
                        }
                    });
                    return;
                }
            case 6:
                if (i == 6) {
                    removeCallbacksAndMessages(null);
                }
                this.quitFlag = true;
                syncTimerIfNeeded();
                this.pausedPosition = this.timer.currMillisecond;
                if (this.mThread != null) {
                    notifyRendering();
                    quitUpdateThread();
                }
                if (i == 6) {
                    IDrawTask iDrawTask5 = this.drawTask;
                    if (iDrawTask5 != null) {
                        iDrawTask5.quit();
                    }
                    BaseDanmakuParser baseDanmakuParser = this.mParser;
                    if (baseDanmakuParser != null) {
                        baseDanmakuParser.release();
                    }
                    if (getLooper() != Looper.getMainLooper()) {
                        getLooper().quit();
                        return;
                    }
                    return;
                }
                return;
            case 7:
                removeMessages(3);
                removeMessages(2);
                iDrawTask = this.drawTask;
                if (iDrawTask != null) {
                    iDrawTask.onPlayStateChanged(2);
                }
                if (i == 6) {
                }
                this.quitFlag = true;
                syncTimerIfNeeded();
                this.pausedPosition = this.timer.currMillisecond;
                if (this.mThread != null) {
                }
                if (i == 6) {
                }
                break;
            case 8:
                this.mDanmakusVisible = true;
                Long l3 = (Long) message.obj;
                IDrawTask iDrawTask6 = this.drawTask;
                if (iDrawTask6 != null) {
                    if (l3 == null) {
                        this.timer.update(getCurrentTime());
                        this.drawTask.requestClear();
                    } else {
                        iDrawTask6.start();
                        this.drawTask.seek(l3.longValue());
                        this.drawTask.requestClear();
                        z = true;
                        if (this.quitFlag && (iDanmakuViewController = this.mDanmakuView) != null) {
                            iDanmakuViewController.drawDanmakus();
                        }
                        notifyRendering();
                        if (!z) {
                            return;
                        }
                        l = (Long) message.obj;
                        if (l != null) {
                        }
                        if (i == 4) {
                        }
                        removeMessages(7);
                        this.quitFlag = false;
                        if (this.mReady) {
                        }
                    }
                }
                z = false;
                iDanmakuViewController.drawDanmakus();
                notifyRendering();
                if (!z) {
                }
                l = (Long) message.obj;
                if (l != null) {
                }
                if (i == 4) {
                }
                removeMessages(7);
                this.quitFlag = false;
                if (this.mReady) {
                }
                break;
            case 9:
                this.mDanmakusVisible = false;
                IDanmakuViewController iDanmakuViewController2 = this.mDanmakuView;
                if (iDanmakuViewController2 != null) {
                    iDanmakuViewController2.clear();
                }
                IDrawTask iDrawTask7 = this.drawTask;
                if (iDrawTask7 != null) {
                    iDrawTask7.requestClear();
                    this.drawTask.requestHide();
                }
                Boolean bool = (Boolean) message.obj;
                if (bool.booleanValue() && (iDrawTask2 = this.drawTask) != null) {
                    iDrawTask2.quit();
                }
                if (!bool.booleanValue()) {
                    return;
                }
                removeMessages(3);
                removeMessages(2);
                iDrawTask = this.drawTask;
                if (iDrawTask != null) {
                }
                if (i == 6) {
                }
                this.quitFlag = true;
                syncTimerIfNeeded();
                this.pausedPosition = this.timer.currMillisecond;
                if (this.mThread != null) {
                }
                if (i == 6) {
                }
                break;
            case 10:
                this.mContext.mDanmakuFactory.notifyDispSizeChanged(this.mContext);
                Boolean bool2 = (Boolean) message.obj;
                if (bool2 != null && bool2.booleanValue()) {
                    this.mContext.mGlobalFlagValues.updateMeasureFlag();
                    this.mContext.mGlobalFlagValues.updateVisibleFlag();
                    this.drawTask.requestClearRetainer();
                    return;
                }
                return;
            case 11:
                notifyRendering();
                return;
            case 12:
                if (this.quitFlag && this.mDanmakuView != null) {
                    this.drawTask.requestClear();
                    this.mDanmakuView.drawDanmakus();
                    notifyRendering();
                    return;
                }
                return;
            case 13:
                IDrawTask iDrawTask8 = this.drawTask;
                if (iDrawTask8 != null) {
                    iDrawTask8.clearDanmakusOnScreen(getCurrentTime());
                    return;
                }
                return;
            default:
                return;
        }
    }

    private void quitUpdateThread() {
        UpdateThread updateThread = this.mThread;
        if (updateThread != null) {
            this.mThread = null;
            synchronized (this.drawTask) {
                this.drawTask.notifyAll();
            }
            updateThread.quit();
            try {
                updateThread.join();
            } catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void updateInCurrentThread() {
        if (!this.quitFlag) {
            long syncTimer = syncTimer(SystemClock.uptimeMillis());
            if (syncTimer < 0) {
                removeMessages(2);
                sendEmptyMessageDelayed(2, 60 - syncTimer);
                return;
            }
            long drawDanmakus = this.mDanmakuView.drawDanmakus();
            removeMessages(2);
            if (drawDanmakus > this.mCordonTime2) {
                this.timer.add(drawDanmakus);
                this.mDrawTimes.clear();
            }
            if (!this.mDanmakusVisible) {
                waitRendering(INDEFINITE_TIME);
                return;
            }
            if (this.mRenderingState.nothingRendered && this.mIdleSleep) {
                long j = this.mRenderingState.endTime - this.timer.currMillisecond;
                if (j > 500) {
                    waitRendering(j - 10);
                    return;
                }
            }
            long j2 = this.mFrameUpdateRate;
            if (drawDanmakus < j2) {
                sendEmptyMessageDelayed(2, j2 - drawDanmakus);
            } else {
                sendEmptyMessage(2);
            }
        }
    }

    private void updateInNewThread() {
        if (this.mThread == null) {
            AnonymousClass2 r0 = new UpdateThread("DFM Update") {
                /* class master.flame.danmaku.controller.DrawHandler.AnonymousClass2 */

                @Override // master.flame.danmaku.controller.UpdateThread
                public void run() {
                    long uptimeMillis = SystemClock.uptimeMillis();
                    while (!isQuited() && !DrawHandler.this.quitFlag) {
                        long uptimeMillis2 = SystemClock.uptimeMillis();
                        if (DrawHandler.this.mFrameUpdateRate - (SystemClock.uptimeMillis() - uptimeMillis) > 1) {
                            SystemClock.sleep(1);
                        } else {
                            long syncTimer = DrawHandler.this.syncTimer(uptimeMillis2);
                            if (syncTimer < 0) {
                                SystemClock.sleep(60 - syncTimer);
                            } else {
                                long drawDanmakus = DrawHandler.this.mDanmakuView.drawDanmakus();
                                if (drawDanmakus > DrawHandler.this.mCordonTime2) {
                                    DrawHandler.this.timer.add(drawDanmakus);
                                    DrawHandler.this.mDrawTimes.clear();
                                }
                                if (!DrawHandler.this.mDanmakusVisible) {
                                    DrawHandler.this.waitRendering(DrawHandler.INDEFINITE_TIME);
                                } else if (DrawHandler.this.mRenderingState.nothingRendered && DrawHandler.this.mIdleSleep) {
                                    long j = DrawHandler.this.mRenderingState.endTime - DrawHandler.this.timer.currMillisecond;
                                    if (j > 500) {
                                        DrawHandler.this.notifyRendering();
                                        DrawHandler.this.waitRendering(j - 10);
                                    }
                                }
                            }
                            uptimeMillis = uptimeMillis2;
                        }
                    }
                }
            };
            this.mThread = r0;
            r0.start();
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private final long syncTimer(long j) {
        long j2 = 0;
        if (!this.mInSeekingAction && !this.mInSyncAction) {
            this.mInSyncAction = true;
            long j3 = j - this.mTimeBase;
            if (!this.mDanmakusVisible || this.mRenderingState.nothingRendered || this.mInWaitingState) {
                this.timer.update(j3);
                this.mRemainingTime = 0;
            } else {
                long j4 = j3 - this.timer.currMillisecond;
                long max = Math.max(this.mFrameUpdateRate, getAverageRenderingTime());
                if (j4 <= 2000) {
                    long j5 = this.mRenderingState.consumingTime;
                    long j6 = this.mCordonTime;
                    if (j5 <= j6 && max <= j6) {
                        long j7 = this.mFrameUpdateRate;
                        long min = Math.min(this.mCordonTime, Math.max(j7, max + (j4 / j7)));
                        long j8 = this.mLastDeltaTime;
                        long j9 = min - j8;
                        if (j9 > 3 && j9 < 8 && j8 >= this.mFrameUpdateRate && j8 <= this.mCordonTime) {
                            min = j8;
                        }
                        long j10 = j4 - min;
                        this.mLastDeltaTime = min;
                        j4 = min;
                        j2 = j10;
                    }
                }
                this.mRemainingTime = j2;
                this.timer.add(j4);
                j2 = j4;
            }
            Callback callback = this.mCallback;
            if (callback != null) {
                callback.updateTimer(this.timer);
            }
            this.mInSyncAction = false;
        }
        return j2;
    }

    private void syncTimerIfNeeded() {
        if (this.mInWaitingState) {
            syncTimer(SystemClock.uptimeMillis());
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void initRenderingConfigs() {
        long max = Math.max(33L, (long) (((float) 16) * 2.5f));
        this.mCordonTime = max;
        this.mCordonTime2 = (long) (((float) max) * 2.5f);
        long max2 = Math.max(16L, 15L);
        this.mFrameUpdateRate = max2;
        this.mThresholdTime = max2 + 3;
    }

    private void prepare(final Runnable runnable) {
        if (this.drawTask == null) {
            this.drawTask = createDrawTask(this.mDanmakuView.isDanmakuDrawingCacheEnabled(), this.timer, this.mDanmakuView.getContext(), this.mDanmakuView.getWidth(), this.mDanmakuView.getHeight(), this.mDanmakuView.isHardwareAccelerated(), new IDrawTask.TaskListener() {
                /* class master.flame.danmaku.controller.DrawHandler.AnonymousClass3 */

                @Override // master.flame.danmaku.controller.IDrawTask.TaskListener
                public void ready() {
                    DrawHandler.this.initRenderingConfigs();
                    runnable.run();
                }

                @Override // master.flame.danmaku.controller.IDrawTask.TaskListener
                public void onDanmakuAdd(BaseDanmaku baseDanmaku) {
                    if (!baseDanmaku.isTimeOut()) {
                        long actualTime = baseDanmaku.getActualTime() - DrawHandler.this.timer.currMillisecond;
                        if (actualTime > 0) {
                            DrawHandler.this.sendEmptyMessageDelayed(11, actualTime);
                        } else if (DrawHandler.this.mInWaitingState) {
                            DrawHandler.this.notifyRendering();
                        }
                    }
                }

                @Override // master.flame.danmaku.controller.IDrawTask.TaskListener
                public void onDanmakuShown(BaseDanmaku baseDanmaku) {
                    if (DrawHandler.this.mCallback != null) {
                        DrawHandler.this.mCallback.danmakuShown(baseDanmaku);
                    }
                }

                @Override // master.flame.danmaku.controller.IDrawTask.TaskListener
                public void onDanmakusDrawingFinished() {
                    if (DrawHandler.this.mCallback != null) {
                        DrawHandler.this.mCallback.drawingFinished();
                    }
                }

                @Override // master.flame.danmaku.controller.IDrawTask.TaskListener
                public void onDanmakuConfigChanged() {
                    DrawHandler.this.redrawIfNeeded();
                }
            });
        } else {
            runnable.run();
        }
    }

    public boolean isPrepared() {
        return this.mReady;
    }

    private IDrawTask createDrawTask(boolean z, DanmakuTimer danmakuTimer, Context context, int i, int i2, boolean z2, IDrawTask.TaskListener taskListener) {
        AbsDisplayer displayer = this.mContext.getDisplayer();
        this.mDisp = displayer;
        displayer.setSize(i, i2);
        DisplayMetrics displayMetrics = context.getResources().getDisplayMetrics();
        this.mDisp.setDensities(displayMetrics.density, displayMetrics.densityDpi, displayMetrics.scaledDensity);
        this.mDisp.resetSlopPixel(this.mContext.scaleTextSize);
        this.mDisp.setHardwareAccelerated(z2);
        IDrawTask cacheManagingDrawTask = z ? new CacheManagingDrawTask(danmakuTimer, this.mContext, taskListener, (AndroidUtils.getMemoryClass(context) * 1048576) / 3) : new DrawTask(danmakuTimer, this.mContext, taskListener);
        cacheManagingDrawTask.setParser(this.mParser);
        cacheManagingDrawTask.prepare();
        obtainMessage(10, false).sendToTarget();
        return cacheManagingDrawTask;
    }

    public void seekTo(Long l) {
        this.mInSeekingAction = true;
        this.mDesireSeekingTime = l.longValue();
        removeMessages(2);
        removeMessages(3);
        removeMessages(4);
        obtainMessage(4, l).sendToTarget();
    }

    public void addDanmaku(BaseDanmaku baseDanmaku) {
        if (this.drawTask != null) {
            baseDanmaku.flags = this.mContext.mGlobalFlagValues;
            baseDanmaku.setTimer(this.timer);
            this.drawTask.addDanmaku(baseDanmaku);
            obtainMessage(11).sendToTarget();
        }
    }

    public void invalidateDanmaku(BaseDanmaku baseDanmaku, boolean z) {
        IDrawTask iDrawTask = this.drawTask;
        if (!(iDrawTask == null || baseDanmaku == null)) {
            iDrawTask.invalidateDanmaku(baseDanmaku, z);
        }
        redrawIfNeeded();
    }

    public void resume() {
        removeMessages(7);
        sendEmptyMessage(3);
    }

    public void prepare() {
        sendEmptyMessage(5);
    }

    public void pause() {
        removeMessages(3);
        syncTimerIfNeeded();
        sendEmptyMessage(7);
    }

    public void showDanmakus(Long l) {
        if (!this.mDanmakusVisible) {
            this.mDanmakusVisible = true;
            removeMessages(8);
            removeMessages(9);
            obtainMessage(8, l).sendToTarget();
        }
    }

    public long hideDanmakus(boolean z) {
        if (!this.mDanmakusVisible) {
            return this.timer.currMillisecond;
        }
        this.mDanmakusVisible = false;
        removeMessages(8);
        removeMessages(9);
        obtainMessage(9, Boolean.valueOf(z)).sendToTarget();
        return this.timer.currMillisecond;
    }

    public boolean getVisibility() {
        return this.mDanmakusVisible;
    }

    public IRenderer.RenderingState draw(Canvas canvas) {
        AbsDanmakuSync absDanmakuSync;
        boolean isSyncPlayingState;
        if (this.drawTask == null) {
            return this.mRenderingState;
        }
        if (!this.mInWaitingState && (absDanmakuSync = this.mContext.danmakuSync) != null && ((isSyncPlayingState = absDanmakuSync.isSyncPlayingState()) || this.quitFlag)) {
            int syncState = absDanmakuSync.getSyncState();
            if (syncState == 2) {
                long j = this.timer.currMillisecond;
                long uptimeMillis = absDanmakuSync.getUptimeMillis();
                long j2 = uptimeMillis - j;
                if (Math.abs(j2) > absDanmakuSync.getThresholdTimeMills()) {
                    if (isSyncPlayingState && this.quitFlag) {
                        resume();
                    }
                    this.drawTask.requestSync(j, uptimeMillis, j2);
                    this.timer.update(uptimeMillis);
                    this.mTimeBase = SystemClock.uptimeMillis() - uptimeMillis;
                    this.mRemainingTime = 0;
                }
            } else if (syncState == 1 && isSyncPlayingState && !this.quitFlag) {
                pause();
            }
        }
        this.mDisp.setExtraData(canvas);
        this.mRenderingState.set(this.drawTask.draw(this.mDisp));
        recordRenderingTime();
        return this.mRenderingState;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void redrawIfNeeded() {
        if (this.quitFlag && this.mDanmakusVisible) {
            obtainMessage(12).sendToTarget();
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void notifyRendering() {
        if (this.mInWaitingState) {
            IDrawTask iDrawTask = this.drawTask;
            if (iDrawTask != null) {
                iDrawTask.requestClear();
            }
            if (this.mUpdateInNewThread) {
                synchronized (this) {
                    this.mDrawTimes.clear();
                }
                synchronized (this.drawTask) {
                    this.drawTask.notifyAll();
                }
            } else {
                this.mDrawTimes.clear();
                removeMessages(2);
                sendEmptyMessage(2);
            }
            this.mInWaitingState = false;
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void waitRendering(long j) {
        this.mRenderingState.sysTime = SystemClock.uptimeMillis();
        this.mInWaitingState = true;
        if (this.mUpdateInNewThread) {
            if (this.mThread != null) {
                try {
                    synchronized (this.drawTask) {
                        if (j == INDEFINITE_TIME) {
                            this.drawTask.wait();
                        } else {
                            this.drawTask.wait(j);
                        }
                        sendEmptyMessage(11);
                    }
                } catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else if (j == INDEFINITE_TIME) {
            removeMessages(11);
            removeMessages(2);
        } else {
            removeMessages(11);
            removeMessages(2);
            sendEmptyMessageDelayed(11, j);
        }
    }

    private synchronized long getAverageRenderingTime() {
        int size = this.mDrawTimes.size();
        if (size <= 0) {
            return 0;
        }
        Long peekFirst = this.mDrawTimes.peekFirst();
        Long peekLast = this.mDrawTimes.peekLast();
        if (peekFirst == null || peekLast == null) {
            return 0;
        }
        return (peekLast.longValue() - peekFirst.longValue()) / ((long) size);
    }

    private synchronized void recordRenderingTime() {
        this.mDrawTimes.addLast(Long.valueOf(SystemClock.uptimeMillis()));
        if (this.mDrawTimes.size() > MAX_RECORD_SIZE) {
            this.mDrawTimes.removeFirst();
        }
    }

    public IDisplayer getDisplayer() {
        return this.mDisp;
    }

    public void notifyDispSizeChanged(int i, int i2) {
        AbsDisplayer absDisplayer = this.mDisp;
        if (absDisplayer != null) {
            if (absDisplayer.getWidth() != i || this.mDisp.getHeight() != i2) {
                this.mDisp.setSize(i, i2);
                obtainMessage(10, true).sendToTarget();
            }
        }
    }

    public void removeAllDanmakus(boolean z) {
        IDrawTask iDrawTask = this.drawTask;
        if (iDrawTask != null) {
            iDrawTask.removeAllDanmakus(z);
        }
    }

    public void removeAllLiveDanmakus() {
        IDrawTask iDrawTask = this.drawTask;
        if (iDrawTask != null) {
            iDrawTask.removeAllLiveDanmakus();
        }
    }

    public IDanmakus getCurrentVisibleDanmakus() {
        IDrawTask iDrawTask = this.drawTask;
        if (iDrawTask != null) {
            return iDrawTask.getVisibleDanmakusOnTime(getCurrentTime());
        }
        return null;
    }

    public long getCurrentTime() {
        long j;
        long j2;
        if (!this.mReady) {
            return 0;
        }
        if (this.mInSeekingAction) {
            return this.mDesireSeekingTime;
        }
        if (this.quitFlag || !this.mInWaitingState) {
            j = this.timer.currMillisecond;
            j2 = this.mRemainingTime;
        } else {
            j = SystemClock.uptimeMillis();
            j2 = this.mTimeBase;
        }
        return j - j2;
    }

    public void clearDanmakusOnScreen() {
        obtainMessage(13).sendToTarget();
    }

    public DanmakuContext getConfig() {
        return this.mContext;
    }
}
