package io.openinstall.dcloud;

import android.app.Activity;
import android.content.Intent;
import android.text.TextUtils;
import android.util.Log;
import com.fm.openinstall.Configuration;
import com.fm.openinstall.OpenInstall;
import com.fm.openinstall.listener.AppInstallListener;
import com.fm.openinstall.listener.AppInstallRetryAdapter;
import com.fm.openinstall.listener.AppWakeUpAdapter;
import com.fm.openinstall.listener.AppWakeUpListener;
import com.fm.openinstall.listener.ResultCallback;
import com.fm.openinstall.model.AppData;
import com.fm.openinstall.model.Error;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.feature.uniapp.common.UniModule;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class OpenInstallModule extends UniModule {
    private static final String HANDLED_FLAG = "_op_handled_";
    private static final String TAG = "OpenInstallModule";
    private static Configuration configuration;
    private boolean alwaysCallback = false;
    private boolean debuggable = true;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private JSCallback wakeupCallback = null;
    private Intent wakeupIntent = null;

    @JSMethod
    public void configAndroid(Map<String, Object> map) {
        debugLog("configAndroid");
        Configuration.Builder builder = new Configuration.Builder();
        if (isPresent(map, "androidId")) {
            builder.androidId(optString(map, "androidId", null));
        }
        if (isPresent(map, "serialNumber")) {
            builder.serialNumber(optString(map, "serialNumber", null));
        }
        builder.adEnabled(optBoolean(map, "adEnabled", false));
        if (optBoolean(map, "macDisabled", false)) {
            builder.macDisabled();
        }
        if (optBoolean(map, "imeiDisabled", false)) {
            builder.imeiDisabled();
        }
        if (isPresent(map, "imei")) {
            builder.imei(optString(map, "imei", null));
        }
        if (isPresent(map, "macAddress")) {
            builder.macAddress(optString(map, "macAddress", null));
        }
        if (isPresent(map, "oaid")) {
            builder.oaid(optString(map, "oaid", null));
        }
        if (isPresent(map, "gaid")) {
            builder.gaid(optString(map, "gaid", null));
        }
        configuration = builder.build();
    }

    @JSMethod
    public void clipBoardEnabled(boolean z) {
        OpenInstall.clipBoardEnabled(z);
    }

    @JSMethod
    public void serialEnabled(boolean z) {
        OpenInstall.serialEnabled(z);
    }

    @JSMethod
    public void setDebug(boolean z) {
        this.debuggable = z;
        OpenInstall.setDebug(z);
    }

    @JSMethod
    public void init() {
        debugLog("init");
        if (!this.initialized.getAndSet(true)) {
            OpenInstall.init(this.mWXSDKInstance.getContext().getApplicationContext(), configuration);
            Intent intent = this.wakeupIntent;
            if (intent != null) {
                wakeup(intent);
                this.wakeupIntent = null;
            }
        }
    }

    @JSMethod
    public void getInstall(int i, final JSCallback jSCallback) {
        debugLog("getInstall");
        checkInit();
        OpenInstall.getInstall(new AppInstallListener() {
            /* class io.openinstall.dcloud.OpenInstallModule.AnonymousClass1 */

            @Override // com.fm.openinstall.listener.AppInstallListener
            public void onInstallFinish(AppData appData, Error error) {
                Map parseData = OpenInstallModule.this.parseData(appData);
                OpenInstallModule.this.putError2Map(parseData, error);
                jSCallback.invoke(parseData);
            }
        }, i);
    }

    @JSMethod
    public void getInstallCanRetry(int i, final JSCallback jSCallback) {
        debugLog("getInstallCanRetry");
        checkInit();
        OpenInstall.getInstallCanRetry(new AppInstallRetryAdapter() {
            /* class io.openinstall.dcloud.OpenInstallModule.AnonymousClass2 */

            @Override // com.fm.openinstall.listener.AppInstallRetryAdapter
            public void onInstall(AppData appData, boolean z) {
                Map parseData = OpenInstallModule.this.parseData(appData);
                parseData.put(AbsoluteConst.JSON_KEY_RETRY, Boolean.valueOf(z));
                parseData.put("shouldRetry", Boolean.valueOf(z));
                jSCallback.invoke(parseData);
            }
        }, i);
    }

    @Override // com.taobao.weex.common.WXModule
    public void onActivityResume() {
        super.onActivityResume();
        debugLog("onActivityResume");
        getWakeup();
    }

    @JSMethod
    public void registerWakeUp(JSCallback jSCallback) {
        debugLog("registerWakeUp");
        this.wakeupCallback = jSCallback;
        getWakeup();
    }

    @JSMethod
    public void registerWakeUpAlwaysCallback(JSCallback jSCallback) {
        debugLog("registerWakeUpAlwaysCallback");
        this.alwaysCallback = true;
        this.wakeupCallback = jSCallback;
        getWakeup();
    }

    private void getWakeup() {
        if (this.mWXSDKInstance.getContext() instanceof Activity) {
            Intent intent = ((Activity) this.mWXSDKInstance.getContext()).getIntent();
            String action = intent.getAction();
            if (action == null || !action.equalsIgnoreCase("android.intent.action.VIEW")) {
                debugLog("invalid intent.action");
                return;
            }
            String dataString = intent.getDataString();
            boolean booleanExtra = intent.getBooleanExtra(HANDLED_FLAG, false);
            if (TextUtils.isEmpty(dataString) || booleanExtra) {
                debugLog("invalid intent.data or intent has handled");
                return;
            }
            debugLog("getWakeup data = " + dataString);
            checkInit();
            intent.putExtra(HANDLED_FLAG, true);
            Intent intent2 = new Intent("android.intent.action.VIEW");
            intent2.setData(intent.getData());
            if (this.initialized.get()) {
                wakeup(intent2);
            } else {
                this.wakeupIntent = intent2;
            }
        }
    }

    private void wakeup(Intent intent) {
        if (this.alwaysCallback) {
            OpenInstall.getWakeUpAlwaysCallback(intent, new AppWakeUpListener() {
                /* class io.openinstall.dcloud.OpenInstallModule.AnonymousClass3 */

                @Override // com.fm.openinstall.listener.AppWakeUpListener
                public void onWakeUpFinish(AppData appData, Error error) {
                    if (error != null) {
                        OpenInstallModule openInstallModule = OpenInstallModule.this;
                        openInstallModule.debugLog("onWakeUpFinish : " + error.toString());
                    }
                    if (OpenInstallModule.this.wakeupCallback != null) {
                        OpenInstallModule.this.wakeupCallback.invokeAndKeepAlive(OpenInstallModule.this.parseData(appData));
                    }
                }
            });
        } else {
            OpenInstall.getWakeUp(intent, new AppWakeUpAdapter() {
                /* class io.openinstall.dcloud.OpenInstallModule.AnonymousClass4 */

                @Override // com.fm.openinstall.listener.AppWakeUpAdapter
                public void onWakeUp(AppData appData) {
                    OpenInstallModule openInstallModule = OpenInstallModule.this;
                    openInstallModule.debugLog("onWakeUp : " + appData.toString());
                    if (OpenInstallModule.this.wakeupCallback != null) {
                        OpenInstallModule.this.wakeupCallback.invokeAndKeepAlive(OpenInstallModule.this.parseData(appData));
                    }
                }
            });
        }
    }

    @JSMethod
    public void reportRegister() {
        debugLog("reportRegister");
        checkInit();
        OpenInstall.reportRegister();
    }

    @JSMethod
    public void reportEffectPoint(String str, long j) {
        debugLog("reportEffectPoint");
        checkInit();
        OpenInstall.reportEffectPoint(str, j);
    }

    @JSMethod
    public void reportEffectPoint(String str, long j, Map<String, String> map) {
        debugLog("reportEffectPoint");
        checkInit();
        OpenInstall.reportEffectPoint(str, j, map);
    }

    @JSMethod
    public void reportShare(String str, String str2, final JSCallback jSCallback) {
        debugLog("reportShare");
        checkInit();
        OpenInstall.reportShare(str, str2, new ResultCallback<Void>() {
            /* class io.openinstall.dcloud.OpenInstallModule.AnonymousClass5 */

            public void onResult(Void r2, Error error) {
                if (jSCallback != null) {
                    HashMap hashMap = new HashMap();
                    OpenInstallModule.this.putError2Map(hashMap, error);
                    jSCallback.invoke(hashMap);
                }
            }
        });
    }

    @JSMethod
    public void getOpid(JSCallback jSCallback) {
        debugLog("getOpid");
        String opid = OpenInstall.getOpid();
        if (jSCallback != null) {
            jSCallback.invoke(opid);
        }
    }

    @JSMethod
    public void setChannel(String str) {
        debugLog("setChannel");
        OpenInstall.setChannel(str);
    }

    private void checkInit() {
        if (!this.initialized.get()) {
            Log.w(TAG, "从 1.3.2 开始，需要手动调用 openinstall.init() 进行初始化操作");
            Log.w(TAG, "为了兼容老用户没有调用初始化，在未调用初始化时，调用了其它API，插件将自动进行初始化");
            init();
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private Map<String, Object> parseData(AppData appData) {
        HashMap hashMap = new HashMap();
        if (appData != null) {
            hashMap.put("channelCode", appData.getChannel());
            hashMap.put("bindData", appData.getData());
        }
        return hashMap;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void putError2Map(Map<String, Object> map, Error error) {
        if (map == null) {
            map = new HashMap<>();
        }
        map.put("shouldRetry", Boolean.valueOf(error != null && error.shouldRetry()));
        if (error != null) {
            map.put("message", error.getErrorMsg());
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void debugLog(String str) {
        if (this.debuggable) {
            Log.d(TAG, str);
        }
    }

    private boolean isPresent(Map<String, Object> map, String str) {
        return map != null && map.containsKey(str);
    }

    private boolean optBoolean(Map<String, Object> map, String str, Boolean bool) {
        if (map == null || !map.containsKey(str)) {
            return bool.booleanValue();
        }
        Object obj = map.get(str);
        if (obj == null) {
            return bool.booleanValue();
        }
        if (TextUtils.equals(AbsoluteConst.FALSE, obj.toString())) {
            return false;
        }
        if (TextUtils.equals(AbsoluteConst.TRUE, obj.toString())) {
            return true;
        }
        return bool.booleanValue();
    }

    private String optString(Map<String, Object> map, String str, String str2) {
        Object obj;
        if (map == null || !map.containsKey(str) || (obj = map.get(str)) == null) {
            return str2;
        }
        if (obj instanceof String) {
            return (String) obj;
        }
        return obj.toString();
    }
}
