package io.dcloud.weex;

import android.content.Context;
import android.text.TextUtils;
import android.util.Base64;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.feature.weex.WeexInstanceMgr;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.json.JSONObject;

public class DCFileUtils {
    /* JADX WARNING: Can't wrap try/catch for region: R(6:7|8|9|11|12|(2:14|(1:30)(2:18|(2:19|(1:21)(3:25|22|31))))(2:23|32)) */
    /* JADX WARNING: Code restructure failed: missing block: B:10:0x0022, code lost:
        r5 = move-exception;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:24:0x0099, code lost:
        r5.printStackTrace();
     */
    /* JADX WARNING: Code restructure failed: missing block: B:26:?, code lost:
        return r0;
     */
    /* JADX WARNING: Failed to process nested try/catch */
    /* JADX WARNING: Missing exception handler attribute for start block: B:11:0x0025 */
    public static InputStream loadWeexAsset(String str, Context context) {
        InputStream loadWeexAsset = AppRuntime.loadWeexAsset(str, context);
        if (loadWeexAsset != null || !str.startsWith("uni-jsframework") || !str.endsWith(".js")) {
            return loadWeexAsset;
        }
        InputStream inputStream = null;
        inputStream = context.getAssets().open(str);
        WeexInstanceMgr.self().setJSFKFileNotFound(true);
        if (inputStream != null) {
            WeexInstanceMgr.self().setJSFKFileNotFound(false);
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
            JSONObject jSONObject = new JSONObject(bufferedReader.readLine().substring(2));
            BaseInfo.setUniVersionV3(jSONObject.optString("version"), context);
            String optString = jSONObject.optString("encode");
            if (TextUtils.isEmpty(optString) || !optString.equals("base64")) {
                return loadWeexAsset;
            }
            String readLine = bufferedReader.readLine();
            while (true) {
                String readLine2 = bufferedReader.readLine();
                if (readLine2 == null) {
                    return new ByteArrayInputStream(Base64.decode(readLine, 0));
                }
                readLine = readLine + readLine2;
            }
        } else {
            WeexInstanceMgr.self().setJSFKFileNotFound(true);
            return loadWeexAsset;
        }
    }

    public static String getAssetPath(String str) {
        String str2;
        if (!TextUtils.isEmpty(str) && str.equals("weex-main-jsfm.js")) {
            String str3 = WeexInstanceMgr.self().getVueVersion() == 3 ? "uni-jsframework-vue3" : "uni-jsframework";
            if (BaseInfo.SyncDebug) {
                str2 = str3 + "-dev.js";
            } else {
                str2 = str3 + ".js";
            }
            if (PlatformUtil.getResInputStream(str2) != null || !BaseInfo.SyncDebug) {
                str = str2;
            } else {
                str = str3 + ".js";
            }
            Logger.i("DCFileUtils", "getAssetPath---------" + str);
        }
        return str;
    }
}
