package io.dcloud.sdk.core.api;

import android.content.Context;
import android.view.View;
import android.widget.FrameLayout;
import io.dcloud.sdk.core.DCloudAOLManager;
import io.dcloud.sdk.core.api.ContentPage;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public interface AOLLoader {

    public interface AdLoadListener {
        void onError(int i, String str);
    }

    public interface ContentPageLoadListener {
        void onContentPageAdLoad(ContentPage contentPage);

        void onError(int i, String str, JSONArray jSONArray);
    }

    public interface ContentPageVideoListener extends VideoAdInteractionListener {
        void onComplete(ContentPage.ContentPageItem contentPageItem);

        void onError(ContentPage.ContentPageItem contentPageItem);

        void onPause(ContentPage.ContentPageItem contentPageItem);

        void onResume(ContentPage.ContentPageItem contentPageItem);

        void onStart(ContentPage.ContentPageItem contentPageItem);
    }

    public interface DrawAdInteractionListener extends FeedAdInteractionListener {
        void onEnd();

        void onPause();

        void onResume();

        void onStart();
    }

    public interface DrawAdLoadListener extends AdLoadListener {
        void onDrawAdLoad(List<DrawAOL> list);

        @Override // io.dcloud.sdk.core.api.AOLLoader.AdLoadListener
        void onError(int i, String str);
    }

    public interface FeedAdInteractionListener {
        void onClicked();

        void onClosed(String str);

        void onRenderFail();

        void onRenderSuccess();

        void onShow();

        void onShowError();
    }

    public interface FeedAdLoadListener extends AdLoadListener {
        @Override // io.dcloud.sdk.core.api.AOLLoader.AdLoadListener
        void onError(int i, String str);

        void onFeedAdLoad(List<FeedAOL> list);
    }

    public interface FullScreenVideoAdInteractionListener extends VideoAdInteractionListener {
    }

    public interface FullScreenVideoAdLoadListener {
        void onError(int i, String str);

        void onFullScreenVideoAdLoad(FSVideoAOL fSVideoAOL);
    }

    public interface InterstitialAdListener extends VideoAdInteractionListener {
    }

    public interface InterstitialAdLoadListener {
        void onError(int i, String str);

        void onInterstitialAdLoad(IntAOL intAOL);
    }

    public interface RewardVideoAdInteractionListener extends VideoAdInteractionListener {
        void onReward(JSONObject jSONObject);
    }

    public interface RewardVideoAdLoadListener {
        void onError(int i, String str);

        void onRewardVideoAdLoad(RewVideoAOL rewVideoAOL);
    }

    public interface SplashAdInteractionListener extends VideoAdInteractionListener {
    }

    public interface SplashAdListener {
        void onClick();

        void onError(int i, String str);

        void onPlayError(int i, String str);

        void onShow();
    }

    public interface SplashAdLoadListener {
        void onError(int i, String str);

        void onSplashAdLoad(SplashAOL splashAOL);

        void pushAd(JSONObject jSONObject);

        void redBag(View view, FrameLayout.LayoutParams layoutParams);
    }

    public interface VideoAdInteractionListener {
        void onClick();

        void onClose();

        void onShow();

        void onShowError(int i, String str);

        void onSkip();

        void onVideoPlayEnd();
    }

    boolean getPersonalAd(Context context);

    void setPersonalAd(Context context, boolean z);

    void setPrivacyConfig(DCloudAOLManager.PrivacyConfig privacyConfig);

    void updatePrivacyConfig(Context context, JSONObject jSONObject);
}
