package io.dcloud.nineoldandroids.util;

import com.taobao.weex.el.parse.Operators;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ReflectiveProperty<T, V> extends Property<T, V> {
    private static final String PREFIX_GET = "get";
    private static final String PREFIX_IS = "is";
    private static final String PREFIX_SET = "set";
    private Field mField;
    private Method mGetter;
    private Method mSetter;

    /* JADX WARNING: Can't wrap try/catch for region: R(3:19|20|(1:22)(2:23|24)) */
    /* JADX WARNING: Can't wrap try/catch for region: R(6:6|5|7|8|9|10) */
    /* JADX WARNING: Code restructure failed: missing block: B:20:?, code lost:
        r11 = r11.getField(r13);
        r10.mField = r11;
        r11 = r11.getType();
     */
    /* JADX WARNING: Code restructure failed: missing block: B:21:0x00bb, code lost:
        if (typesMatch(r12, r11) != false) goto L_0x00bd;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:22:0x00bd, code lost:
        return;
     */
    /* JADX WARNING: Code restructure failed: missing block: B:24:0x00db, code lost:
        throw new io.dcloud.nineoldandroids.util.NoSuchPropertyException("Underlying type (" + r11 + ") " + "does not match Property type (" + r12 + com.taobao.weex.el.parse.Operators.BRACKET_END_STR);
     */
    /* JADX WARNING: Failed to process nested try/catch */
    /* JADX WARNING: Missing exception handler attribute for start block: B:19:0x00ad */
    /* JADX WARNING: Missing exception handler attribute for start block: B:3:0x003f */
    /* JADX WARNING: Missing exception handler attribute for start block: B:9:0x005e */
    public ReflectiveProperty(Class<T> cls, Class<V> cls2, String str) {
        super(cls2, str);
        char upperCase = Character.toUpperCase(str.charAt(0));
        String str2 = String.valueOf(upperCase) + str.substring(1);
        String str3 = PREFIX_GET + str2;
        this.mGetter = cls.getMethod(str3, null);
        try {
            Method declaredMethod = cls.getDeclaredMethod(str3, null);
            this.mGetter = declaredMethod;
            declaredMethod.setAccessible(true);
        } catch (NoSuchMethodException unused) {
            String str4 = PREFIX_IS + str2;
            this.mGetter = cls.getMethod(str4, null);
            Method declaredMethod2 = cls.getDeclaredMethod(str4, null);
            this.mGetter = declaredMethod2;
            declaredMethod2.setAccessible(true);
        } catch (NoSuchFieldException unused2) {
            throw new NoSuchPropertyException("No accessor method or field found for property with name " + str);
        }
        Class<?> returnType = this.mGetter.getReturnType();
        if (typesMatch(cls2, returnType)) {
            try {
                Method declaredMethod3 = cls.getDeclaredMethod(PREFIX_SET + str2, returnType);
                this.mSetter = declaredMethod3;
                declaredMethod3.setAccessible(true);
            } catch (NoSuchMethodException unused3) {
            }
        } else {
            throw new NoSuchPropertyException("Underlying type (" + returnType + ") " + "does not match Property type (" + cls2 + Operators.BRACKET_END_STR);
        }
    }

    private boolean typesMatch(Class<V> cls, Class cls2) {
        if (cls2 != cls) {
            return cls2.isPrimitive() && ((cls2 == Float.TYPE && cls == Float.class) || ((cls2 == Integer.TYPE && cls == Integer.class) || ((cls2 == Boolean.TYPE && cls == Boolean.class) || ((cls2 == Long.TYPE && cls == Long.class) || ((cls2 == Double.TYPE && cls == Double.class) || ((cls2 == Short.TYPE && cls == Short.class) || ((cls2 == Byte.TYPE && cls == Byte.class) || (cls2 == Character.TYPE && cls == Character.class))))))));
        }
        return true;
    }

    @Override // io.dcloud.nineoldandroids.util.Property
    public V get(T t) {
        Method method = this.mGetter;
        if (method != null) {
            try {
                return (V) method.invoke(t, null);
            } catch (IllegalAccessException unused) {
                throw new AssertionError();
            } catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        } else {
            Field field = this.mField;
            if (field != null) {
                try {
                    return (V) field.get(t);
                } catch (IllegalAccessException unused2) {
                    throw new AssertionError();
                }
            } else {
                throw new AssertionError();
            }
        }
    }

    @Override // io.dcloud.nineoldandroids.util.Property
    public boolean isReadOnly() {
        return this.mSetter == null && this.mField == null;
    }

    @Override // io.dcloud.nineoldandroids.util.Property
    public void set(T t, V v) {
        Method method = this.mSetter;
        if (method != null) {
            try {
                method.invoke(t, v);
            } catch (IllegalAccessException unused) {
                throw new AssertionError();
            } catch (InvocationTargetException e) {
                throw new RuntimeException(e.getCause());
            }
        } else {
            Field field = this.mField;
            if (field != null) {
                try {
                    field.set(t, v);
                } catch (IllegalAccessException unused2) {
                    throw new AssertionError();
                }
            } else {
                throw new UnsupportedOperationException("Property " + getName() + " is read-only");
            }
        }
    }
}
