package io.dcloud.nineoldandroids.animation;

import android.view.View;
import com.taobao.weex.common.Constants;
import io.dcloud.nineoldandroids.util.FloatProperty;
import io.dcloud.nineoldandroids.util.IntProperty;
import io.dcloud.nineoldandroids.util.Property;
import io.dcloud.nineoldandroids.view.animation.AnimatorProxy;

final class PreHoneycombCompat {
    static Property<View, Float> ALPHA = new FloatProperty<View>("alpha") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass1 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getAlpha());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setAlpha(f);
        }
    };
    static Property<View, Float> PIVOT_X = new FloatProperty<View>("pivotX") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass2 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getPivotX());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setPivotX(f);
        }
    };
    static Property<View, Float> PIVOT_Y = new FloatProperty<View>("pivotY") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass3 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getPivotY());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setPivotY(f);
        }
    };
    static Property<View, Float> ROTATION = new FloatProperty<View>("rotation") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass6 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getRotation());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setRotation(f);
        }
    };
    static Property<View, Float> ROTATION_X = new FloatProperty<View>("rotationX") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass7 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getRotationX());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setRotationX(f);
        }
    };
    static Property<View, Float> ROTATION_Y = new FloatProperty<View>("rotationY") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass8 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getRotationY());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setRotationY(f);
        }
    };
    static Property<View, Float> SCALE_X = new FloatProperty<View>("scaleX") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass9 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getScaleX());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setScaleX(f);
        }
    };
    static Property<View, Float> SCALE_Y = new FloatProperty<View>("scaleY") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass10 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getScaleY());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setScaleY(f);
        }
    };
    static Property<View, Integer> SCROLL_X = new IntProperty<View>("scrollX") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass11 */

        public Integer get(View view) {
            return Integer.valueOf(AnimatorProxy.wrap(view).getScrollX());
        }

        public void setValue(View view, int i) {
            AnimatorProxy.wrap(view).setScrollX(i);
        }
    };
    static Property<View, Integer> SCROLL_Y = new IntProperty<View>("scrollY") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass12 */

        public Integer get(View view) {
            return Integer.valueOf(AnimatorProxy.wrap(view).getScrollY());
        }

        public void setValue(View view, int i) {
            AnimatorProxy.wrap(view).setScrollY(i);
        }
    };
    static Property<View, Float> TRANSLATION_X = new FloatProperty<View>("translationX") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass4 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getTranslationX());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setTranslationX(f);
        }
    };
    static Property<View, Float> TRANSLATION_Y = new FloatProperty<View>("translationY") {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass5 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getTranslationY());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setTranslationY(f);
        }
    };
    static Property<View, Float> X = new FloatProperty<View>(Constants.Name.X) {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass13 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getX());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setX(f);
        }
    };
    static Property<View, Float> Y = new FloatProperty<View>(Constants.Name.Y) {
        /* class io.dcloud.nineoldandroids.animation.PreHoneycombCompat.AnonymousClass14 */

        public Float get(View view) {
            return Float.valueOf(AnimatorProxy.wrap(view).getY());
        }

        public void setValue(View view, float f) {
            AnimatorProxy.wrap(view).setY(f);
        }
    };

    private PreHoneycombCompat() {
    }
}
