package io.dcloud.net;

import android.text.TextUtils;
import android.util.Log;
import android.webkit.CookieManager;
import io.dcloud.common.DHInterface.IReqListener;
import io.dcloud.common.DHInterface.IResponseListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.net.NetWork;
import io.dcloud.common.util.net.RequestData;
import io.dcloud.common.util.net.UploadMgr;
import io.dcloud.net.JsUpload;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONObject;

public class UploadNetWork extends NetWork {
    public static String REQMETHOD_GET = "GET";
    public static String REQMETHOD_POST = "POST";
    public static final String TAG = "UploadNetWork";
    long RANGE_BUF = 102400;
    long mContentLength;
    public int mStatus = 0;
    private boolean mSupport = false;
    long mTotalSize;
    LinkedHashMap<String, JsUpload.UploadItem> mUploadItems = new LinkedHashMap<>(4);
    long mUploadedSize;
    StringBuffer mUploadingFile = new StringBuffer();
    String responseHeaders;

    public UploadNetWork(int i, RequestData requestData, IReqListener iReqListener, IResponseListener iResponseListener) {
        super(i, requestData, iReqListener, iResponseListener);
    }

    private void addCutoffLine(String str) {
        this.mContentLength = appendPostParemeter("--" + str + "\r\n", this.mContentLength);
    }

    private void addFileInputStream(String str, JsUpload.UploadFile uploadFile) {
        if (this.mSupport) {
            this.mContentLength = appendPostParemeter("Content-Disposition: attachments; name=\"" + str + "\"; filename=\"" + uploadFile.mFilename + "\"; range=\"0-777/777\"\r\n", this.mContentLength);
        } else {
            this.mContentLength = appendPostParemeter("Content-Disposition: form-data; name=\"" + str + "\"; filename=\"" + uploadFile.mFilename + "\"\r\n", this.mContentLength);
        }
        long appendPostParemeter = appendPostParemeter("Content-Type: " + uploadFile.mMimetype + "\r\n\r\n", this.mContentLength);
        this.mContentLength = appendPostParemeter;
        long appendPostParemeter2 = appendPostParemeter("\r\n", appendPostParemeter);
        this.mContentLength = appendPostParemeter2;
        this.mContentLength = appendPostParemeter2 + uploadFile.mFileSize;
    }

    private void addPropertyInputStream(String str, String str2) {
        this.mContentLength = appendPostParemeter("Content-Disposition: form-data; name=\"" + str + "\"\r\n\r\n", this.mContentLength);
        StringBuilder sb = new StringBuilder();
        sb.append(str2);
        sb.append("\r\n");
        this.mContentLength = appendPostParemeter(sb.toString(), this.mContentLength);
    }

    private void initUploadData() throws Exception {
        DataOutputStream dataOutputStream;
        String str = this.mMainBoundry;
        HttpURLConnection httpRequest = this.mRequestData.getHttpRequest();
        this.mRequest = httpRequest;
        if (httpRequest == null) {
            new Exception("url error");
        }
        initHttpsURLConnectionVel();
        this.mRequest.setDoOutput(true);
        this.mRequest.setDoInput(true);
        this.mRequest.setRequestProperty("Connection", "Keep-Alive");
        this.mRequest.setRequestProperty("Charset", "UTF-8");
        HttpURLConnection httpURLConnection = this.mRequest;
        httpURLConnection.setRequestProperty(NetWork.CONTENT_TYPE, "multipart/form-data; boundary=" + str);
        int i = 0;
        this.mRequest.setUseCaches(false);
        initContentLength();
        int i2 = 10240;
        int i3 = this.mRequestData.mChunkSize;
        if (i3 > 0) {
            i2 = i3 * 1024;
            this.mRequest.setChunkedStreamingMode(i2);
        } else {
            this.mRequest.setFixedLengthStreamingMode(this.mContentLength);
        }
        DataOutputStream dataOutputStream2 = new DataOutputStream(this.mRequest.getOutputStream());
        this.mReqListener.onNetStateChanged(IReqListener.NetState.NET_REQUEST_BEGIN, this.isAbort);
        LinkedHashMap<String, JsUpload.UploadItem> linkedHashMap = this.mUploadItems;
        if (linkedHashMap != null && linkedHashMap.size() > 0) {
            Set<String> keySet = this.mUploadItems.keySet();
            this.mTotalSize = this.mContentLength;
            for (String str2 : keySet) {
                JsUpload.UploadItem uploadItem = this.mUploadItems.get(str2);
                dataOutputStream2.writeBytes("--" + str + "\r\n");
                if (uploadItem instanceof JsUpload.UploadFile) {
                    JsUpload.UploadFile uploadFile = (JsUpload.UploadFile) uploadItem;
                    InputStream inputStream = uploadFile.mFileInputS;
                    if (inputStream != null) {
                        this.mUploadingFile.append(str2);
                        dataOutputStream2.write(("Content-Disposition: form-data; name=\"" + str2 + "\"; filename=\"" + uploadFile.mFilename + JSUtil.QUOTE + "\r\n").getBytes());
                        StringBuilder sb = new StringBuilder();
                        sb.append("Content-Type: ");
                        sb.append(uploadFile.mMimetype);
                        sb.append("\r\n");
                        dataOutputStream2.write(sb.toString().getBytes());
                        dataOutputStream2.writeBytes("\r\n");
                        int min = Math.min(inputStream.available(), i2);
                        byte[] bArr = new byte[min];
                        long j = 0;
                        int read = inputStream.read(bArr, i, min);
                        while (read > 0) {
                            j += (long) read;
                            this.mUploadedSize = j;
                            Log.e("UploadNetWort", "initUploadData: mUploadedSize==" + this.mUploadedSize + " ===== length =" + read + " ====== buffer =" + min);
                            dataOutputStream2.write(bArr, 0, read);
                            this.mReqListener.onNetStateChanged(IReqListener.NetState.NET_HANDLE_ING, this.isAbort);
                            read = inputStream.read(bArr, 0, Math.min(inputStream.available(), i2));
                            dataOutputStream2 = dataOutputStream2;
                        }
                        dataOutputStream = dataOutputStream2;
                        dataOutputStream.writeBytes("\r\n");
                        inputStream.close();
                    }
                } else {
                    dataOutputStream = dataOutputStream2;
                    if (uploadItem instanceof JsUpload.UploadString) {
                        StringBuilder sb2 = new StringBuilder();
                        sb2.append("Content-Disposition: form-data; name=\"" + str2 + JSUtil.QUOTE + "\r\n");
                        sb2.append("\r\n");
                        sb2.append(((JsUpload.UploadString) uploadItem).mData);
                        sb2.append("\r\n");
                        dataOutputStream.write(sb2.toString().getBytes());
                        sb2.delete(0, sb2.length());
                        this.mReqListener.onNetStateChanged(IReqListener.NetState.NET_HANDLE_ING, this.isAbort);
                        dataOutputStream2 = dataOutputStream;
                        i = 0;
                    }
                }
                this.mReqListener.onNetStateChanged(IReqListener.NetState.NET_HANDLE_ING, this.isAbort);
                dataOutputStream2 = dataOutputStream;
                i = 0;
            }
        }
        dataOutputStream2.writeBytes("--" + str + "--" + "\r\n");
        this.mUploadedSize = (long) dataOutputStream2.size();
        dataOutputStream2.flush();
        responseUpload();
        dataOutputStream2.close();
    }

    private static boolean isRightRequest(int i) {
        return i >= 200 && i < 300;
    }

    private void uploadContent() {
        this.mTimes = 1;
        connet(true);
        dispose();
    }

    public boolean addFile(String str, JsUpload.UploadFile uploadFile) {
        if (this.mUploadItems.containsKey(uploadFile)) {
            return false;
        }
        this.mUploadItems.put(str, uploadFile);
        return true;
    }

    public boolean addParemeter(String str, String str2) {
        if (this.mUploadItems.containsKey(str)) {
            return false;
        }
        this.mUploadItems.put(str, new JsUpload.UploadString(str2));
        return true;
    }

    public long appendPostParemeter(String str, long j) {
        try {
            return ((long) new ByteArrayInputStream(str.getBytes("utf-8")).available()) + j;
        } catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void connet(boolean z) {
        if (z) {
            try {
                this.mReqListener.onNetStateChanged(IReqListener.NetState.NET_CONNECTED, this.isAbort);
            } catch (Exception e) {
                Logger.d("upload is ERROR:" + e.getLocalizedMessage());
                this.mResponseText = e.getMessage();
                this.mReqListener.onNetStateChanged(IReqListener.NetState.NET_ERROR, this.isAbort);
                e.printStackTrace();
                long currentTimeMillis = System.currentTimeMillis();
                long j = this.mRetryIntervalTime;
                int i = this.mTimes;
                long j2 = currentTimeMillis + ((j * ((long) (1 << i))) / 2);
                if (i < this.MAX_TIMES) {
                    this.mTimes = i + 1;
                    do {
                    } while (System.currentTimeMillis() <= j2);
                    connet(z);
                    return;
                }
                return;
            }
        }
        initUploadData();
        this.responseHeaders = getResponseHeaders();
    }

    @Override // io.dcloud.common.util.net.NetWork
    public void dispose() {
        this.mHeaderList = null;
        this.mRequest = null;
        this.mUploadedSize = 0;
        this.mTotalSize = 0;
        UploadMgr.getUploadMgr().removeNetWork(this);
    }

    public String getResponseHeaders() {
        try {
            HttpURLConnection httpURLConnection = this.mRequest;
            if (httpURLConnection == null) {
                return "";
            }
            Map<String, List<String>> headerFields = httpURLConnection.getHeaderFields();
            HashMap hashMap = new HashMap();
            for (Map.Entry<String, List<String>> entry : headerFields.entrySet()) {
                Iterator<String> it = entry.getValue().iterator();
                String str = "";
                while (it.hasNext()) {
                    str = str + "  " + it.next();
                }
                if (!PdrUtil.isEmpty(entry.getKey())) {
                    hashMap.put(entry.getKey(), str);
                }
            }
            return new JSONObject(hashMap).toString();
        } catch (Exception e) {
            e.printStackTrace();
            return "{}";
        }
    }

    public void initContentLength() {
        this.mContentLength = 0;
        LinkedHashMap<String, JsUpload.UploadItem> linkedHashMap = this.mUploadItems;
        if (linkedHashMap != null && linkedHashMap.size() > 0) {
            for (String str : this.mUploadItems.keySet()) {
                JsUpload.UploadItem uploadItem = this.mUploadItems.get(str);
                if (uploadItem instanceof JsUpload.UploadFile) {
                    this.mUploadingFile.append(str);
                    addCutoffLine(this.mMainBoundry);
                    addFileInputStream(str, (JsUpload.UploadFile) uploadItem);
                } else if (uploadItem instanceof JsUpload.UploadString) {
                    addCutoffLine(this.mMainBoundry);
                    addPropertyInputStream(str, ((JsUpload.UploadString) uploadItem).mData);
                }
            }
        }
        this.mContentLength = appendPostParemeter("--" + this.mMainBoundry + "--\r\n", this.mContentLength);
    }

    public void responseUpload() {
        InputStream inputStream;
        try {
            HttpURLConnection httpURLConnection = this.mRequest;
            if (httpURLConnection != null) {
                this.mStatus = httpURLConnection.getResponseCode();
            }
            String headerField = this.mRequest.getHeaderField(IWebview.SET_COOKIE);
            if (!TextUtils.isEmpty(headerField)) {
                CookieManager.getInstance().setCookie(this.mRequestData.getUrl(), headerField);
            }
            if (this.mStatus > 400) {
                inputStream = this.mRequest.getErrorStream();
            } else {
                inputStream = this.mRequest.getInputStream();
            }
            byte[] bArr = new byte[1024];
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            while (true) {
                int read = inputStream.read(bArr);
                if (read <= 0) {
                    break;
                }
                byteArrayOutputStream.write(bArr, 0, read);
            }
            String str = new String(byteArrayOutputStream.toByteArray(), "utf-8");
            this.mResponseText = str;
            try {
                JSONObject jSONObject = new JSONObject(str);
                JSONUtil.getString(jSONObject, "result");
                JSONUtil.getString(jSONObject, "code");
                JSONUtil.getString(jSONObject, "message");
            } catch (Exception unused) {
                Logger.e("uploadnetwork", "responseUpload JSONObject _data=" + str + ";url=" + this.mRequestData.getUrl());
            }
            if (isRightRequest(this.mStatus)) {
                this.mReqListener.onNetStateChanged(IReqListener.NetState.NET_HANDLE_ING, this.isAbort);
                this.mReqListener.onNetStateChanged(IReqListener.NetState.NET_HANDLE_END, this.isAbort);
            } else {
                this.mReqListener.onNetStateChanged(IReqListener.NetState.NET_ERROR, this.isAbort);
            }
            byteArrayOutputStream.close();
            inputStream.close();
        } catch (Exception e) {
            Logger.e("uploadnetwork", "responseUpload " + e.getLocalizedMessage() + ";url=" + this.mRequestData.getUrl());
            this.mResponseText = e.getMessage();
            this.mReqListener.onNetStateChanged(IReqListener.NetState.NET_ERROR, this.isAbort);
        }
    }

    @Override // io.dcloud.common.util.net.NetWork
    public void run() {
        uploadContent();
    }
}
