package io.dcloud.net;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.text.TextUtils;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.Deprecated_JSUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.net.DownloadMgr;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class DownloadJSMgr {
    static final int DELETE = 2;
    static final int SAVE = 1;
    private static DownloadJSMgr mDownloadJSMgr;
    AppDownloadInfo curAppSharePref = null;
    public HashMap<String, AppDownloadInfo> mAppsDownloadTasks = null;
    Handler mHander = new Handler(Looper.getMainLooper()) {
        /* class io.dcloud.net.DownloadJSMgr.AnonymousClass1 */

        public void handleMessage(Message message) {
            int i = message.what;
            if (i == 1) {
                String[] strArr = (String[]) message.obj;
                String str = strArr[0];
                String str2 = strArr[1];
                String str3 = strArr[2];
                SharedPreferences.Editor edit = DownloadJSMgr.this.getAppTaskList(str).sharePref.edit();
                edit.putString(str2, str3);
                edit.commit();
            } else if (i == 2) {
                String[] strArr2 = (String[]) message.obj;
                String str4 = strArr2[0];
                String str5 = strArr2[1];
                SharedPreferences sharedPreferences = DownloadJSMgr.this.getAppTaskList(str4).sharePref;
                if (!TextUtils.isEmpty(sharedPreferences.getString(str5, ""))) {
                    sharedPreferences.edit().remove(str5).commit();
                }
            }
        }
    };

    /* access modifiers changed from: package-private */
    public class AppDownloadInfo {
        String appid;
        ArrayList<JsDownload> mList = null;
        SharedPreferences sharePref;

        AppDownloadInfo(Context context, IWebview iWebview, String str) {
            this.appid = str;
            this.sharePref = context.getSharedPreferences(str + JsDownload.DOWNLOAD_NAME, 0);
            this.mList = new ArrayList<>();
            Map<String, ?> all = this.sharePref.getAll();
            if (all != null) {
                ArrayList<JsDownload> arrayList = this.mList;
                for (String str2 : all.keySet()) {
                    try {
                        arrayList.add(new JsDownload(DownloadJSMgr.this, iWebview, new JSONObject((String) all.get(str2))));
                    } catch (JSONException unused) {
                    }
                }
                this.mList = arrayList;
            }
        }
    }

    private DownloadJSMgr() {
        if (this.mAppsDownloadTasks == null) {
            this.mAppsDownloadTasks = new HashMap<>();
        }
    }

    private JsDownload createDownloadTask(IWebview iWebview, JSONObject jSONObject) {
        return new JsDownload(this, iWebview, jSONObject);
    }

    private void enumerate(IWebview iWebview, String str, String str2, String str3) {
        String str4;
        AppDownloadInfo appTaskList = getAppTaskList(str3);
        try {
            int parseInt = Integer.parseInt(str2);
            if (!(parseInt == 0 || parseInt == 1 || parseInt == 2 || parseInt == 3 || parseInt == 4)) {
                if (parseInt != 5) {
                    str4 = enumerateArr(iWebview, appTaskList.mList);
                    Deprecated_JSUtil.execCallback(iWebview, str, str4, JSUtil.OK, true, false);
                }
            }
            ArrayList<JsDownload> arrayList = new ArrayList<>();
            if (appTaskList != null && !appTaskList.mList.isEmpty()) {
                int size = appTaskList.mList.size();
                for (int i = 0; i < size; i++) {
                    JsDownload jsDownload = appTaskList.mList.get(i);
                    if (jsDownload.mWebview.obtainApp() == null) {
                        jsDownload.mWebview = iWebview;
                    }
                    if (parseInt == jsDownload.mState) {
                        arrayList.add(jsDownload);
                    }
                }
            }
            str4 = enumerateArr(iWebview, arrayList);
        } catch (Exception unused) {
            ArrayList<JsDownload> arrayList2 = new ArrayList<>();
            if (appTaskList != null && !appTaskList.mList.isEmpty()) {
                int size2 = appTaskList.mList.size();
                for (int i2 = 0; i2 < size2; i2++) {
                    JsDownload jsDownload2 = appTaskList.mList.get(i2);
                    jsDownload2.mWebview = iWebview;
                    if (jsDownload2.mState != 4) {
                        arrayList2.add(jsDownload2);
                    }
                }
            }
            str4 = enumerateArr(iWebview, arrayList2);
        }
        Deprecated_JSUtil.execCallback(iWebview, str, str4, JSUtil.OK, true, false);
    }

    private String enumerateArr(IWebview iWebview, ArrayList<JsDownload> arrayList) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(Operators.ARRAY_START_STR);
        if (arrayList != null && !arrayList.isEmpty()) {
            int size = arrayList.size();
            for (int i = 0; i < size; i++) {
                JsDownload jsDownload = arrayList.get(i);
                stringBuffer.append(jsDownload.toSaveJSON());
                jsDownload.addRelWebview(iWebview);
                if (i != size - 1) {
                    stringBuffer.append(",");
                }
            }
        }
        stringBuffer.append(Operators.ARRAY_END_STR);
        return stringBuffer.toString();
    }

    private JsDownload findDownloadTask(IWebview iWebview, String str, String str2) {
        AppDownloadInfo appTaskList = getAppTaskList(str);
        if (appTaskList != null) {
            int size = appTaskList.mList.size();
            for (int i = 0; i < size; i++) {
                JsDownload jsDownload = appTaskList.mList.get(i);
                if (str2.equals(jsDownload.mUUID)) {
                    if (jsDownload.mWebview.obtainApp() != null) {
                        return jsDownload;
                    } else {
                        jsDownload.mWebview = iWebview;
                        return jsDownload;
                    }
                }
            }
        }
        return null;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private AppDownloadInfo getAppTaskList(String str) {
        return this.mAppsDownloadTasks.get(str);
    }

    protected static DownloadJSMgr getInstance() {
        if (mDownloadJSMgr == null) {
            mDownloadJSMgr = new DownloadJSMgr();
        }
        return mDownloadJSMgr;
    }

    private void initAppDownloadList(IWebview iWebview, String str) {
        if (!this.mAppsDownloadTasks.containsKey(str)) {
            this.mAppsDownloadTasks.put(str, new AppDownloadInfo(iWebview.getContext(), iWebview, str));
        }
    }

    private void pushDownloadTask(IWebview iWebview, String str, JsDownload jsDownload) {
        AppDownloadInfo appDownloadInfo = this.mAppsDownloadTasks.get(str);
        if (appDownloadInfo == null) {
            appDownloadInfo = new AppDownloadInfo(iWebview.getContext(), iWebview, str);
            this.mAppsDownloadTasks.put(str, appDownloadInfo);
        }
        appDownloadInfo.mList.add(jsDownload);
    }

    /* access modifiers changed from: package-private */
    public void deleteDownloadTaskInfo(String str, String str2) {
        Message obtain = Message.obtain();
        obtain.what = 2;
        obtain.obj = new String[]{str, str2};
        this.mHander.sendMessage(obtain);
    }

    public void dispose() {
        for (String str : this.mAppsDownloadTasks.keySet()) {
            Iterator<JsDownload> it = getAppTaskList(str).mList.iterator();
            while (it.hasNext()) {
                it.next().saveInDatabase();
            }
        }
    }

    public String execute(IWebview iWebview, String str, String[] strArr) {
        char c;
        int i;
        try {
            String obtainAppId = iWebview.obtainFrameView().obtainApp().obtainAppId();
            initAppDownloadList(iWebview, obtainAppId);
            switch (str.hashCode()) {
                case -1944579676:
                    if (str.equals("createDownload")) {
                        c = 7;
                        break;
                    }
                    c = 65535;
                    break;
                case -934426579:
                    if (str.equals(AbsoluteConst.EVENTS_RESUME)) {
                        c = 1;
                        break;
                    }
                    c = 65535;
                    break;
                case 92611376:
                    if (str.equals("abort")) {
                        c = 3;
                        break;
                    }
                    c = 65535;
                    break;
                case 94746189:
                    if (str.equals("clear")) {
                        c = 4;
                        break;
                    }
                    c = 65535;
                    break;
                case 106440182:
                    if (str.equals("pause")) {
                        c = 2;
                        break;
                    }
                    c = 65535;
                    break;
                case 109757538:
                    if (str.equals("start")) {
                        c = 0;
                        break;
                    }
                    c = 65535;
                    break;
                case 247395940:
                    if (str.equals("enumerate")) {
                        c = 6;
                        break;
                    }
                    c = 65535;
                    break;
                case 1316768223:
                    if (str.equals("startAll")) {
                        c = 5;
                        break;
                    }
                    c = 65535;
                    break;
                default:
                    c = 65535;
                    break;
            }
            switch (c) {
                case 0:
                case 1:
                    JsDownload findDownloadTask = findDownloadTask(iWebview, obtainAppId, strArr[0]);
                    findDownloadTask.start();
                    String str2 = strArr[1];
                    if (TextUtils.isEmpty(str2)) {
                        return null;
                    }
                    JSONObject jSONObject = new JSONObject(str2);
                    if (jSONObject.length() <= 0) {
                        return null;
                    }
                    Iterator<String> keys = jSONObject.keys();
                    while (keys.hasNext()) {
                        String next = keys.next();
                        findDownloadTask.setRequestHeader(next, jSONObject.getString(next));
                    }
                    return null;
                case 2:
                    JsDownload findDownloadTask2 = findDownloadTask(iWebview, obtainAppId, strArr[0]);
                    findDownloadTask2.mPause = true;
                    DownloadMgr.getDownloadMgr().removeTask(findDownloadTask2.mDownloadNetWork);
                    return null;
                case 3:
                    JsDownload findDownloadTask3 = findDownloadTask(iWebview, obtainAppId, strArr[0]);
                    if (PdrUtil.isEmpty(findDownloadTask3)) {
                        return null;
                    }
                    getAppTaskList(obtainAppId).mList.remove(findDownloadTask3);
                    findDownloadTask3.mPause = true;
                    DownloadMgr.getDownloadMgr().removeTask(findDownloadTask3.mDownloadNetWork);
                    findDownloadTask3.abort();
                    return null;
                case 4:
                    AppDownloadInfo appTaskList = getAppTaskList(obtainAppId);
                    int parseInt = Integer.parseInt(strArr[0]);
                    if (appTaskList == null) {
                        return null;
                    }
                    for (int size = appTaskList.mList.size() - 1; size >= 0; size--) {
                        JsDownload jsDownload = appTaskList.mList.get(size);
                        if (parseInt == -1 || parseInt == (i = jsDownload.mState) || (parseInt == -10000 && i != 4)) {
                            jsDownload.abort();
                            appTaskList.mList.remove(size);
                        }
                    }
                    return null;
                case 5:
                    AppDownloadInfo appTaskList2 = getAppTaskList(obtainAppId);
                    if (appTaskList2.mList == null) {
                        return null;
                    }
                    for (int i2 = 0; i2 < appTaskList2.mList.size(); i2++) {
                        appTaskList2.mList.get(i2).start();
                    }
                    return null;
                case 6:
                    enumerate(iWebview, strArr[0], strArr[1], obtainAppId);
                    return null;
                case 7:
                    pushDownloadTask(iWebview, obtainAppId, createDownloadTask(iWebview, new JSONObject(strArr[0])));
                    return null;
                default:
                    return null;
            }
        } catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    /* access modifiers changed from: package-private */
    public void saveDownloadTaskInfo(String str, String str2, String str3) {
        Message obtain = Message.obtain();
        obtain.what = 1;
        obtain.obj = new String[]{str, str2, str3};
        this.mHander.sendMessage(obtain);
    }
}
