package io.dcloud.media.weex.weex_video.ijkplayer.utils;

import android.content.Context;
import android.net.Uri;
import com.facebook.common.statfs.StatFsHelper;
import java.io.File;

public class VideoCacheUtil {
    private static final int CACHE_FOLDER_MAX_LIMIT = 104857600;
    private static final String VIDEO_CACHE_FOLDER_NAME = "videoPlayer_CacheFiles";

    public static Uri cacheHttpUriWrap(Uri uri) {
        return Uri.parse("ijkio:cache:ffio:" + uri.toString());
    }

    public static String getCacheFilePath(Context context, Uri uri) {
        if (context == null || uri == null) {
            return null;
        }
        File cacheRootFile = getCacheRootFile(context);
        return cacheRootFile.getPath() + File.separator + (String.valueOf(uri.hashCode()) + ".videoCache");
    }

    public static String getCacheMapFilePath(Context context, Uri uri) {
        if (context == null || uri == null) {
            return null;
        }
        File cacheRootFile = getCacheRootFile(context);
        return cacheRootFile.getPath() + File.separator + (String.valueOf(uri.hashCode()) + ".videoCacheMap");
    }

    public static void cleanCacheIfNesscessary(Context context) {
        boolean z;
        File cacheRootFile = getCacheRootFile(context);
        if (cacheRootFile.canRead()) {
            File[] listFiles = cacheRootFile.listFiles();
            long j = 0;
            int length = listFiles.length;
            int i = 0;
            while (true) {
                if (i >= length) {
                    z = false;
                    break;
                }
                File file = listFiles[i];
                if (file.isFile()) {
                    j += file.length();
                }
                if (j >= StatFsHelper.DEFAULT_DISK_RED_LEVEL_IN_BYTES) {
                    z = true;
                    break;
                }
                i++;
            }
            if (z) {
                for (File file2 : listFiles) {
                    file2.delete();
                }
            }
        }
    }

    private static File getCacheRootFile(Context context) {
        File file = new File(context.getCacheDir().toString() + File.separator + VIDEO_CACHE_FOLDER_NAME);
        if (!file.exists()) {
            file.mkdir();
        }
        return file;
    }
}
