package io.dcloud.media.weex.weex_video.ijkplayer.utils;

import android.graphics.PointF;
import android.view.MotionEvent;

public final class MotionEventUtils {
    public static final int FINGER_FLAG_1 = 601;
    public static final int FINGER_FLAG_2 = 602;
    public static final int FINGER_FLAG_3 = 603;

    private MotionEventUtils() {
        throw new AssertionError();
    }

    public static float calcSpacing(MotionEvent motionEvent, int i, int i2) {
        float x = motionEvent.getX(i) - motionEvent.getX(i2);
        float y = motionEvent.getY(i) - motionEvent.getY(i2);
        return (float) Math.sqrt((double) ((x * x) + (y * y)));
    }

    public static float calcSpacing(MotionEvent motionEvent, int i) {
        float f;
        float f2;
        float f3;
        float f4;
        float y;
        float y2;
        if (601 == i) {
            f = ((motionEvent.getX(0) + motionEvent.getX(1)) / 2.0f) - motionEvent.getX(2);
            y = (motionEvent.getY(0) + motionEvent.getY(1)) / 2.0f;
            y2 = motionEvent.getY(2);
        } else if (602 == i) {
            f = ((motionEvent.getX(0) + motionEvent.getX(2)) / 2.0f) - motionEvent.getX(1);
            y = (motionEvent.getY(0) + motionEvent.getY(2)) / 2.0f;
            y2 = motionEvent.getY(1);
        } else {
            if (603 == i) {
                f = ((motionEvent.getX(2) + motionEvent.getX(1)) / 2.0f) - motionEvent.getX(0);
                f4 = (motionEvent.getY(2) + motionEvent.getY(1)) / 2.0f;
                f3 = motionEvent.getY(0);
            } else {
                f = motionEvent.getX(0) - motionEvent.getX(1);
                f4 = motionEvent.getY(0);
                f3 = motionEvent.getY(1);
            }
            f2 = f4 - f3;
            return (float) Math.sqrt((double) ((f * f) + (f2 * f2)));
        }
        f2 = y - y2;
        return (float) Math.sqrt((double) ((f * f) + (f2 * f2)));
    }

    public static void midPoint(PointF pointF, MotionEvent motionEvent) {
        pointF.set(((motionEvent.getX(0) + motionEvent.getX(1)) + motionEvent.getX(2)) / 3.0f, ((motionEvent.getY(0) + motionEvent.getY(1)) + motionEvent.getY(2)) / 3.0f);
    }

    public static int calcFingerFlag(MotionEvent motionEvent) {
        float calcSpacing = calcSpacing(motionEvent, 0, 1);
        float calcSpacing2 = calcSpacing(motionEvent, 0, 2);
        float calcSpacing3 = calcSpacing(motionEvent, 2, 1);
        float min = Math.min(calcSpacing, Math.min(calcSpacing2, calcSpacing3));
        if (min == calcSpacing) {
            return 601;
        }
        if (min == calcSpacing2) {
            return 602;
        }
        return min == calcSpacing3 ? 603 : -1;
    }

    public static float rotation(MotionEvent motionEvent, int i) {
        double x;
        float y;
        float y2;
        if (601 == i) {
            x = (double) (((motionEvent.getX(0) + motionEvent.getX(1)) / 2.0f) - motionEvent.getX(2));
            y = (motionEvent.getY(0) + motionEvent.getY(1)) / 2.0f;
            y2 = motionEvent.getY(2);
        } else if (602 == i) {
            x = (double) (((motionEvent.getX(0) + motionEvent.getX(2)) / 2.0f) - motionEvent.getX(1));
            y = (motionEvent.getY(0) + motionEvent.getY(2)) / 2.0f;
            y2 = motionEvent.getY(1);
        } else if (603 == i) {
            x = (double) (((motionEvent.getX(2) + motionEvent.getX(1)) / 2.0f) - motionEvent.getX(0));
            y = (motionEvent.getY(2) + motionEvent.getY(1)) / 2.0f;
            y2 = motionEvent.getY(0);
        } else {
            x = (double) (motionEvent.getX(0) - motionEvent.getX(1));
            y = motionEvent.getY(0);
            y2 = motionEvent.getY(1);
        }
        return (float) Math.toDegrees(Math.atan2((double) (y - y2), x));
    }
}
