package io.dcloud.media.weex.weex_video.ijkplayer.media;

import android.animation.ValueAnimator;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.MediaController;
import dc.squareup.HttpConstants;
import dc.squareup.okhttp3.internal.http.BridgeInterceptor;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.feature.weex_media.option.EnumPlayStrategy;
import io.dcloud.media.weex.weex_video.ijkplayer.media.IRenderView;
import io.dcloud.media.weex.weex_video.ijkplayer.utils.VideoCacheUtil;
import java.io.File;
import java.io.IOException;
import java.net.CookieHandler;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.json.JSONObject;
import tv.danmaku.ijk.media.player.AndroidMediaPlayer;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;
import tv.danmaku.ijk.media.player.TextureMediaPlayer;
import tv.danmaku.ijk.media.player.misc.ITrackInfo;

public class IjkVideoView extends FrameLayout implements MediaController.MediaPlayerControl {
    public static final int RENDER_NONE = 0;
    public static final int RENDER_SURFACE_VIEW = 1;
    public static final int RENDER_TEXTURE_VIEW = 2;
    private static final int[] s_allAspectRatio = {0, 1, 2, 4, 5};
    private String TAG = "TTAG";
    private IMediaPlayer.OnBufferingUpdateListener bufferingUpdateListener;
    private ImageView coverImage;
    private String customUA = "";
    private EnumPlayStrategy enumPlayStrategy = EnumPlayStrategy.DEFAULT;
    private AssetsDataSourceProvider fd;
    private String headerInfo;
    private boolean isHttpCacheOpen = false;
    private boolean isMediaReady = true;
    private boolean isSetSeekTo = false;
    private boolean isStoped = false;
    private Context mAppContext;
    private IMediaPlayer.OnBufferingUpdateListener mBufferingUpdateListener = new IMediaPlayer.OnBufferingUpdateListener() {
        /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkVideoView.AnonymousClass8 */

        @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnBufferingUpdateListener
        public void onBufferingUpdate(IMediaPlayer iMediaPlayer, int i) {
            IjkVideoView.this.mCurrentBufferPercentage = i;
            if (IjkVideoView.this.bufferingUpdateListener != null) {
                IjkVideoView.this.bufferingUpdateListener.onBufferingUpdate(iMediaPlayer, i);
            }
        }
    };
    private boolean mCanPause = true;
    private boolean mCanSeekBack = true;
    private boolean mCanSeekForward = true;
    private IMediaPlayer.OnCompletionListener mCompletionListener = new IMediaPlayer.OnCompletionListener() {
        /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkVideoView.AnonymousClass5 */

        @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnCompletionListener
        public void onCompletion(IMediaPlayer iMediaPlayer) {
            Log.w(IjkVideoView.this.TAG, "OnCompletionListener:");
            IjkVideoView.this.mCurrentState = 336;
            IjkVideoView.this.mTargetState = 336;
            IjkVideoView.this._notifyMediaStatus();
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.hide();
            }
            if (IjkVideoView.this.mOnCompletionListener != null) {
                IjkVideoView.this.mOnCompletionListener.onCompletion(IjkVideoView.this.mMediaPlayer);
            }
        }
    };
    private int mCurrentAspectRatio = s_allAspectRatio[0];
    private int mCurrentBufferPercentage;
    private int mCurrentState = 330;
    private boolean mEnableBackgroundPlay = false;
    private IMediaPlayer.OnErrorListener mErrorListener = new IMediaPlayer.OnErrorListener() {
        /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkVideoView.AnonymousClass7 */

        @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnErrorListener
        public boolean onError(IMediaPlayer iMediaPlayer, int i, int i2) {
            Log.d("TTAG", "Error: " + i + "," + i2);
            IjkVideoView.this.mCurrentState = 331;
            IjkVideoView.this.mTargetState = 331;
            IjkVideoView.this._notifyMediaStatus();
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.hide();
            }
            if (IjkVideoView.this.mOnErrorListener == null || IjkVideoView.this.mOnErrorListener.onError(IjkVideoView.this.mMediaPlayer, i, i2)) {
            }
            return true;
        }
    };
    private Map<String, String> mHeaders;
    private IMediaPlayer.OnInfoListener mInfoListener = new IMediaPlayer.OnInfoListener() {
        /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkVideoView.AnonymousClass6 */

        @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnInfoListener
        public boolean onInfo(IMediaPlayer iMediaPlayer, int i, int i2) {
            if (IjkVideoView.this.mOnInfoListener != null) {
                IjkVideoView.this.mOnInfoListener.onInfo(iMediaPlayer, i, i2);
            }
            if (i == 3) {
                Log.d(IjkVideoView.this.TAG, "MEDIA_INFO_VIDEO_RENDERING_START:");
                return true;
            } else if (i == 901) {
                Log.d(IjkVideoView.this.TAG, "MEDIA_INFO_UNSUPPORTED_SUBTITLE:");
                return true;
            } else if (i == 902) {
                Log.d(IjkVideoView.this.TAG, "MEDIA_INFO_SUBTITLE_TIMED_OUT:");
                return true;
            } else if (i == 10001) {
                IjkVideoView.this.mVideoRotationDegree = i2;
                String str = IjkVideoView.this.TAG;
                Log.d(str, "MEDIA_INFO_VIDEO_ROTATION_CHANGED: " + i2);
                if (IjkVideoView.this.mRenderView == null) {
                    return true;
                }
                IjkVideoView.this.mRenderView.setVideoRotation(i2);
                return true;
            } else if (i != 10002) {
                switch (i) {
                    case 700:
                        Log.d(IjkVideoView.this.TAG, "MEDIA_INFO_VIDEO_TRACK_LAGGING:");
                        return true;
                    case IMediaPlayer.MEDIA_INFO_BUFFERING_START /*{ENCODED_INT: 701}*/:
                        Log.d(IjkVideoView.this.TAG, "MEDIA_INFO_BUFFERING_START:");
                        return true;
                    case IMediaPlayer.MEDIA_INFO_BUFFERING_END /*{ENCODED_INT: 702}*/:
                        Log.d(IjkVideoView.this.TAG, "MEDIA_INFO_BUFFERING_END:");
                        return true;
                    case IMediaPlayer.MEDIA_INFO_NETWORK_BANDWIDTH /*{ENCODED_INT: 703}*/:
                        String str2 = IjkVideoView.this.TAG;
                        Log.d(str2, "MEDIA_INFO_NETWORK_BANDWIDTH: " + i2);
                        return true;
                    default:
                        switch (i) {
                            case 800:
                                Log.d(IjkVideoView.this.TAG, "MEDIA_INFO_BAD_INTERLEAVING:");
                                return true;
                            case IMediaPlayer.MEDIA_INFO_NOT_SEEKABLE /*{ENCODED_INT: 801}*/:
                                Log.d(IjkVideoView.this.TAG, "MEDIA_INFO_NOT_SEEKABLE:");
                                return true;
                            case IMediaPlayer.MEDIA_INFO_METADATA_UPDATE /*{ENCODED_INT: 802}*/:
                                Log.d(IjkVideoView.this.TAG, "MEDIA_INFO_METADATA_UPDATE:");
                                return true;
                            default:
                                return true;
                        }
                }
            } else {
                Log.d(IjkVideoView.this.TAG, "MEDIA_INFO_AUDIO_RENDERING_START:");
                return true;
            }
        }
    };
    private boolean mIsMediaCodecHandleResolutionChange = false;
    private boolean mIsNormalScreen = true;
    private boolean mIsUsingMediaCodec = true;
    private boolean mIsUsingMediaCodecAutoRotate = false;
    private boolean mIsUsingMediaDataSource;
    private boolean mIsUsingOpenSLES = false;
    private IMediaController mMediaController;
    private IMediaPlayer mMediaPlayer = null;
    private IMediaPlayer.OnCompletionListener mOnCompletionListener;
    private IMediaPlayer.OnErrorListener mOnErrorListener;
    private IMediaPlayer.OnInfoListener mOnInfoListener;
    private IMediaPlayer.OnPreparedListener mOnPreparedListener;
    private Matrix mOriginalMatrix;
    private String mPixelFormat = "";
    private long mPrepareEndTime = 0;
    private long mPrepareStartTime = 0;
    IMediaPlayer.OnPreparedListener mPreparedListener = new IMediaPlayer.OnPreparedListener() {
        /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkVideoView.AnonymousClass3 */

        @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnPreparedListener
        public void onPrepared(IMediaPlayer iMediaPlayer) {
            IjkVideoView.this.mPrepareEndTime = System.currentTimeMillis();
            IjkVideoView.this.mCurrentState = 333;
            IjkVideoView.this._notifyMediaStatus();
            if (IjkVideoView.this.mOnPreparedListener != null) {
                IjkVideoView.this.mOnPreparedListener.onPrepared(IjkVideoView.this.mMediaPlayer);
            }
            if (IjkVideoView.this.mMediaController != null) {
                IjkVideoView.this.mMediaController.setEnabled(true);
            }
            IjkVideoView.this.mVideoWidth = iMediaPlayer.getVideoWidth();
            IjkVideoView.this.mVideoHeight = iMediaPlayer.getVideoHeight();
            int i = IjkVideoView.this.mSeekWhenPrepared;
            if (i != 0) {
                IjkVideoView.this.seekTo(i);
            }
            if (IjkVideoView.this.mVideoWidth == 0 || IjkVideoView.this.mVideoHeight == 0) {
                if (IjkVideoView.this.mTargetState == 334) {
                    IjkVideoView.this.start();
                }
            } else if (IjkVideoView.this.mRenderView != null) {
                IjkVideoView.this.mRenderView.setVideoSize(IjkVideoView.this.mVideoWidth, IjkVideoView.this.mVideoHeight);
                IjkVideoView.this.mRenderView.setVideoSampleAspectRatio(IjkVideoView.this.mVideoSarNum, IjkVideoView.this.mVideoSarDen);
                if (IjkVideoView.this.mRenderView.shouldWaitForResize() && (IjkVideoView.this.mSurfaceWidth != IjkVideoView.this.mVideoWidth || IjkVideoView.this.mSurfaceHeight != IjkVideoView.this.mVideoHeight)) {
                    return;
                }
                if (IjkVideoView.this.mTargetState == 334) {
                    IjkVideoView.this.start();
                    if (IjkVideoView.this.mMediaController != null) {
                        IjkVideoView.this.mMediaController.show();
                    }
                } else if (IjkVideoView.this.isPlaying()) {
                } else {
                    if ((i != 0 || IjkVideoView.this.getCurrentPosition() > 0) && IjkVideoView.this.mMediaController != null) {
                        IjkVideoView.this.mMediaController.show(0);
                    }
                }
            }
        }
    };
    private IRenderView mRenderView;
    IRenderView.IRenderCallback mSHCallback = new IRenderView.IRenderCallback() {
        /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkVideoView.AnonymousClass9 */

        @Override // io.dcloud.media.weex.weex_video.ijkplayer.media.IRenderView.IRenderCallback
        public void onSurfaceChanged(IRenderView.ISurfaceHolder iSurfaceHolder, int i, int i2, int i3) {
            if (iSurfaceHolder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e(IjkVideoView.this.TAG, "onSurfaceChanged: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceWidth = i2;
            IjkVideoView.this.mSurfaceHeight = i3;
            boolean z = true;
            boolean z2 = IjkVideoView.this.mTargetState == 334;
            if (IjkVideoView.this.mRenderView.shouldWaitForResize() && !(IjkVideoView.this.mVideoWidth == i2 && IjkVideoView.this.mVideoHeight == i3)) {
                z = false;
            }
            if (IjkVideoView.this.mMediaPlayer != null && z2 && z) {
                if (IjkVideoView.this.mSeekWhenPrepared != 0) {
                    IjkVideoView ijkVideoView = IjkVideoView.this;
                    ijkVideoView.seekTo(ijkVideoView.mSeekWhenPrepared);
                }
                IjkVideoView.this.start();
            }
        }

        @Override // io.dcloud.media.weex.weex_video.ijkplayer.media.IRenderView.IRenderCallback
        public void onSurfaceCreated(IRenderView.ISurfaceHolder iSurfaceHolder, int i, int i2) {
            if (iSurfaceHolder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e(IjkVideoView.this.TAG, "onSurfaceCreated: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceHolder = iSurfaceHolder;
            if (IjkVideoView.this.mMediaPlayer != null) {
                IjkVideoView ijkVideoView = IjkVideoView.this;
                ijkVideoView.bindSurfaceHolder(ijkVideoView.mMediaPlayer, iSurfaceHolder);
                return;
            }
            IjkVideoView.this.openVideo();
        }

        @Override // io.dcloud.media.weex.weex_video.ijkplayer.media.IRenderView.IRenderCallback
        public void onSurfaceDestroyed(IRenderView.ISurfaceHolder iSurfaceHolder) {
            if (iSurfaceHolder.getRenderView() != IjkVideoView.this.mRenderView) {
                Log.e(IjkVideoView.this.TAG, "onSurfaceDestroyed: unmatched render callback\n");
                return;
            }
            IjkVideoView.this.mSurfaceHolder = null;
            IjkVideoView.this.releaseWithoutStop();
        }
    };
    private Matrix mSaveMatrix;
    private int mScreenOrHeight;
    private int mScreenOrWidth;
    private IMediaPlayer.OnSeekCompleteListener mSeekCompleteListener = new IMediaPlayer.OnSeekCompleteListener() {
        /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkVideoView.AnonymousClass4 */

        @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnSeekCompleteListener
        public void onSeekComplete(IMediaPlayer iMediaPlayer) {
            IjkVideoView.this.mSeekEndTime = System.currentTimeMillis();
            IjkVideoView.this.mOnInfoListener.onInfo(iMediaPlayer, 337, -1);
        }
    };
    private long mSeekEndTime = 0;
    private long mSeekStartTime = 0;
    private int mSeekWhenPrepared;
    IMediaPlayer.OnVideoSizeChangedListener mSizeChangedListener = new IMediaPlayer.OnVideoSizeChangedListener() {
        /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkVideoView.AnonymousClass2 */

        @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnVideoSizeChangedListener
        public void onVideoSizeChanged(IMediaPlayer iMediaPlayer, int i, int i2, int i3, int i4) {
            IjkVideoView.this.mVideoWidth = iMediaPlayer.getVideoWidth();
            IjkVideoView.this.mVideoHeight = iMediaPlayer.getVideoHeight();
            IjkVideoView.this.mVideoSarNum = iMediaPlayer.getVideoSarNum();
            IjkVideoView.this.mVideoSarDen = iMediaPlayer.getVideoSarDen();
            if (IjkVideoView.this.mVideoWidth != 0 && IjkVideoView.this.mVideoHeight != 0) {
                if (IjkVideoView.this.mRenderView != null) {
                    IjkVideoView.this.mRenderView.setVideoSize(IjkVideoView.this.mVideoWidth, IjkVideoView.this.mVideoHeight);
                    IjkVideoView.this.mRenderView.setVideoSampleAspectRatio(IjkVideoView.this.mVideoSarNum, IjkVideoView.this.mVideoSarDen);
                }
                IjkVideoView.this.requestLayout();
            }
        }
    };
    private int mSurfaceHeight;
    private IRenderView.ISurfaceHolder mSurfaceHolder = null;
    private int mSurfaceWidth;
    private int mTargetState = 330;
    private Uri mUri;
    private int mVideoHeight;
    private int mVideoRotationDegree;
    private int mVideoSarDen;
    private int mVideoSarNum;
    private float mVideoScale = 1.0f;
    private int mVideoTargetRotationDegree;
    private int mVideoWidth;
    private float volume = 0.0f;

    private void initBackground() {
    }

    public void enterBackground() {
    }

    public int getAudioSessionId() {
        return 0;
    }

    public void stopBackgroundPlay() {
    }

    public int getCurrentState() {
        return this.mCurrentState;
    }

    public IjkVideoView(Context context) {
        super(context);
        initVideoView(context);
    }

    public IjkVideoView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        initVideoView(context);
    }

    public IjkVideoView(Context context, AttributeSet attributeSet, int i) {
        super(context, attributeSet, i);
        initVideoView(context);
    }

    public IjkVideoView(Context context, AttributeSet attributeSet, int i, int i2) {
        super(context, attributeSet, i, i2);
        initVideoView(context);
    }

    private void initVideoView(Context context) {
        this.mAppContext = context.getApplicationContext();
        initBackground();
        initRenders();
        this.mVideoWidth = 0;
        this.mVideoHeight = 0;
        setFocusable(true);
        setFocusableInTouchMode(true);
        requestFocus();
        this.mCurrentState = 330;
        this.mTargetState = 330;
        _notifyMediaStatus();
        ImageView imageView = new ImageView(getContext());
        this.coverImage = imageView;
        imageView.setScaleType(ImageView.ScaleType.FIT_CENTER);
        this.coverImage.setBackgroundColor(-16777216);
        this.coverImage.setVisibility(8);
        addView(this.coverImage, new ViewGroup.LayoutParams(-1, -1));
        if (Build.VERSION.SDK_INT < 26) {
            this.mIsUsingMediaCodec = false;
        }
    }

    public void setmIsUsingMediaCodec(boolean z) {
        this.mIsUsingMediaCodec = z;
        if (Build.VERSION.SDK_INT < 26) {
            this.mIsUsingMediaCodec = false;
        }
    }

    public void setIsHttpCacheOpen(boolean z) {
        this.isHttpCacheOpen = z;
    }

    public void setHeaderInfo(String str) {
        this.headerInfo = str;
    }

    public void setFlowStrategy(EnumPlayStrategy enumPlayStrategy2) {
        this.enumPlayStrategy = enumPlayStrategy2;
    }

    public void setRenderView(IRenderView iRenderView) {
        int i;
        int i2;
        if (this.mRenderView != null) {
            IMediaPlayer iMediaPlayer = this.mMediaPlayer;
            if (iMediaPlayer != null) {
                iMediaPlayer.setDisplay(null);
            }
            View view = this.mRenderView.getView();
            this.mRenderView.removeRenderCallback(this.mSHCallback);
            this.mRenderView = null;
            removeView(view);
        }
        if (iRenderView != null) {
            this.mRenderView = iRenderView;
            iRenderView.setAspectRatio(this.mCurrentAspectRatio);
            int i3 = this.mVideoWidth;
            if (i3 > 0 && (i2 = this.mVideoHeight) > 0) {
                iRenderView.setVideoSize(i3, i2);
            }
            int i4 = this.mVideoSarNum;
            if (i4 > 0 && (i = this.mVideoSarDen) > 0) {
                iRenderView.setVideoSampleAspectRatio(i4, i);
            }
            View view2 = this.mRenderView.getView();
            view2.setLayoutParams(new FrameLayout.LayoutParams(-1, -2, 17));
            addView(view2);
            this.mRenderView.addRenderCallback(this.mSHCallback);
            this.mRenderView.setVideoRotation(this.mVideoRotationDegree);
        }
    }

    public void setVideoRotation(int i) {
        int i2 = this.mVideoRotationDegree + i;
        this.mVideoTargetRotationDegree = i2;
        this.mRenderView.setVideoRotation(i2);
    }

    public Matrix getVideoTransform() {
        if (this.mOriginalMatrix == null) {
            this.mOriginalMatrix = this.mRenderView.getTransform();
        }
        return this.mRenderView.getTransform();
    }

    public void setVideoTransform(Matrix matrix) {
        this.mRenderView.setTransform(matrix);
    }

    public boolean adjustVideoView(float f) {
        float f2 = this.mVideoScale * f;
        this.mVideoScale = f2;
        int i = this.mVideoTargetRotationDegree;
        int i2 = (i + 360) % 360;
        if (f2 == 1.0f && i2 == 0) {
            return false;
        }
        if (i2 > 315 || i2 <= 45) {
            this.mVideoRotationDegree = 0;
        } else if (i2 > 45 && i2 <= 135) {
            this.mVideoRotationDegree = 90;
        } else if (i2 > 135 && i2 <= 225) {
            this.mVideoRotationDegree = 180;
        } else if (i2 <= 225 || i2 > 315) {
            this.mVideoRotationDegree = 0;
        } else {
            this.mVideoRotationDegree = 270;
        }
        int i3 = this.mVideoRotationDegree;
        final int i4 = i3 - i;
        this.mVideoTargetRotationDegree = i3;
        final Matrix videoTransform = getVideoTransform();
        if (this.mScreenOrWidth == 0 || this.mScreenOrHeight == 0) {
            this.mScreenOrWidth = this.mRenderView.getView().getWidth();
            this.mScreenOrHeight = this.mRenderView.getView().getHeight();
        }
        if (!this.mIsNormalScreen) {
            float f3 = this.mVideoScale;
            videoTransform.preScale(f3, f3);
            float f4 = this.mVideoScale;
            videoTransform.postTranslate((((float) this.mScreenOrWidth) * (1.0f - f4)) / 2.0f, (((float) this.mScreenOrHeight) * (1.0f - f4)) / 2.0f);
            this.mRenderView.setTransform(videoTransform);
            this.mIsNormalScreen = true;
        } else {
            float[] fArr = new float[2];
            videoTransform.mapPoints(fArr);
            float f5 = this.mVideoScale;
            final float f6 = ((((float) this.mScreenOrWidth) * (1.0f - f5)) / 2.0f) - fArr[0];
            final float f7 = ((((float) this.mScreenOrHeight) * (1.0f - f5)) / 2.0f) - fArr[1];
            if (this.mSaveMatrix == null) {
                this.mSaveMatrix = new Matrix();
            }
            ValueAnimator duration = ValueAnimator.ofFloat(0.0f, 1.0f).setDuration(300L);
            duration.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
                /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkVideoView.AnonymousClass1 */

                public void onAnimationUpdate(ValueAnimator valueAnimator) {
                    float floatValue = ((Float) valueAnimator.getAnimatedValue()).floatValue();
                    IjkVideoView.this.mSaveMatrix.set(videoTransform);
                    IjkVideoView.this.mSaveMatrix.postTranslate(f6 * floatValue, f7 * floatValue);
                    IjkVideoView.this.mRenderView.setTransform(IjkVideoView.this.mSaveMatrix);
                    IjkVideoView.this.mRenderView.setVideoRotation((int) (((float) IjkVideoView.this.mVideoRotationDegree) - (((float) i4) * (1.0f - floatValue))));
                }
            });
            duration.start();
        }
        return true;
    }

    public void resetVideoView(boolean z) {
        this.mIsNormalScreen = z;
        this.mVideoRotationDegree = 0;
        if (z) {
            this.mVideoTargetRotationDegree = 0;
            this.mVideoScale = 1.0f;
        }
        this.mRenderView.setTransform(this.mOriginalMatrix);
        this.mRenderView.setVideoRotation(this.mVideoRotationDegree);
    }

    public void setRender(int i) {
        if (i == 0) {
            setRenderView(null);
        } else if (i == 1) {
            setRenderView(new SurfaceRenderView(getContext()));
        } else if (i != 2) {
            Log.e(this.TAG, String.format(Locale.US, "invalid render %d\n", Integer.valueOf(i)));
        } else {
            TextureRenderView textureRenderView = new TextureRenderView(getContext());
            if (this.mMediaPlayer != null) {
                textureRenderView.getSurfaceHolder().bindToMediaPlayer(this.mMediaPlayer);
                textureRenderView.setVideoSize(this.mMediaPlayer.getVideoWidth(), this.mMediaPlayer.getVideoHeight());
                textureRenderView.setVideoSampleAspectRatio(this.mMediaPlayer.getVideoSarNum(), this.mMediaPlayer.getVideoSarDen());
                textureRenderView.setAspectRatio(this.mCurrentAspectRatio);
            }
            setRenderView(textureRenderView);
        }
    }

    public void setVideoURI(Uri uri) {
        this.customUA = "";
        new HashMap();
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        try {
            Map<String, List<String>> map = CookieHandler.getDefault().get(URI.create(uri.toString()), hashMap);
            if (map != null) {
                for (Map.Entry<String, List<String>> entry : map.entrySet()) {
                    String key = entry.getKey();
                    List<String> value = entry.getValue();
                    if (key.equalsIgnoreCase(IWebview.COOKIE) || key.equalsIgnoreCase("Cookie2")) {
                        hashMap2.put(key, BridgeInterceptor.buildCookieHeader(value));
                    }
                }
            }
        } catch (Exception e) {
            e.printStackTrace();
            hashMap2 = new HashMap();
        }
        try {
            JSONObject jSONObject = new JSONObject(this.headerInfo);
            Iterator<String> keys = jSONObject.keys();
            while (keys.hasNext()) {
                String next = keys.next();
                String optString = jSONObject.optString(next);
                if (!TextUtils.isEmpty(next)) {
                    if (IWebview.USER_AGENT.equalsIgnoreCase(next)) {
                        this.customUA = optString;
                    } else {
                        hashMap2.put(next, optString);
                    }
                }
            }
        } catch (Exception unused) {
        }
        setVideoURI(uri, hashMap2);
    }

    public void setVideoFileDescriptor(AssetsDataSourceProvider assetsDataSourceProvider) {
        this.fd = assetsDataSourceProvider;
        this.mSeekWhenPrepared = 0;
        this.isSetSeekTo = false;
        openVideo();
        requestLayout();
        invalidate();
    }

    private void setVideoURI(Uri uri, Map<String, String> map) {
        this.mUri = uri;
        this.mHeaders = map;
        this.mSeekWhenPrepared = 0;
        this.isSetSeekTo = false;
        openVideo();
        requestLayout();
        invalidate();
    }

    public Uri getUri() {
        return this.mUri;
    }

    public void setSpeed(float f) {
        IMediaPlayer iMediaPlayer = this.mMediaPlayer;
        if (iMediaPlayer instanceof IjkMediaPlayer) {
            ((IjkMediaPlayer) iMediaPlayer).setSpeed(f);
        } else if (iMediaPlayer instanceof TextureMediaPlayer) {
            IjkMediaPlayer ijkMediaPlayer = (IjkMediaPlayer) ((TextureMediaPlayer) iMediaPlayer).getInternalMediaPlayer();
            if (ijkMediaPlayer instanceof IjkMediaPlayer) {
                ijkMediaPlayer.setSpeed(f);
            }
        }
    }

    public Bitmap getScreenshot() {
        IRenderView iRenderView = this.mRenderView;
        if (iRenderView != null) {
            return iRenderView.getVideoScreenshot();
        }
        return null;
    }

    public void stopPlayback() {
        IMediaPlayer iMediaPlayer = this.mMediaPlayer;
        if (iMediaPlayer != null) {
            iMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 330;
            this.mTargetState = 330;
            _notifyMediaStatus();
            ((AudioManager) this.mAppContext.getSystemService("audio")).abandonAudioFocus(null);
            this.isStoped = true;
            showCoverImage();
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    /* JADX WARNING: Missing exception handler attribute for start block: B:35:0x00f1 */
    private void openVideo() {
        Uri uri = this.mUri;
        if ((uri != null || this.fd != null) && this.mSurfaceHolder != null) {
            release(false);
            try {
                this.mMediaPlayer = createPlayer(2);
                if (!this.isMediaReady) {
                    setvolume(this.volume);
                    this.isMediaReady = true;
                }
                getContext();
                this.mMediaPlayer.setOnPreparedListener(this.mPreparedListener);
                this.mMediaPlayer.setOnVideoSizeChangedListener(this.mSizeChangedListener);
                this.mMediaPlayer.setOnCompletionListener(this.mCompletionListener);
                this.mMediaPlayer.setOnErrorListener(this.mErrorListener);
                this.mMediaPlayer.setOnInfoListener(this.mInfoListener);
                this.mMediaPlayer.setOnBufferingUpdateListener(this.mBufferingUpdateListener);
                this.mMediaPlayer.setOnSeekCompleteListener(this.mSeekCompleteListener);
                this.mCurrentBufferPercentage = 0;
                Uri uri2 = this.mUri;
                if (uri2 != null) {
                    String scheme = uri2.getScheme();
                    if (Build.VERSION.SDK_INT >= 23 && this.mIsUsingMediaDataSource && (TextUtils.isEmpty(scheme) || scheme.equalsIgnoreCase("file"))) {
                        this.mMediaPlayer.setDataSource(new FileMediaDataSource(new File(this.mUri.toString())));
                    } else if (Build.VERSION.SDK_INT >= 14) {
                        this.mMediaPlayer.setDataSource(this.mAppContext, this.mUri, this.mHeaders);
                    } else {
                        this.mMediaPlayer.setDataSource(this.mUri.toString());
                    }
                } else {
                    AssetsDataSourceProvider assetsDataSourceProvider = this.fd;
                    if (assetsDataSourceProvider != null) {
                        this.mMediaPlayer.setDataSource(assetsDataSourceProvider);
                    }
                }
                bindSurfaceHolder(this.mMediaPlayer, this.mSurfaceHolder);
                this.mMediaPlayer.setAudioStreamType(3);
                this.mMediaPlayer.setScreenOnWhilePlaying(true);
                this.mPrepareStartTime = System.currentTimeMillis();
                this.mMediaPlayer.prepareAsync();
                this.mCurrentState = 332;
                attachMediaController();
            } catch (IOException unused) {
                this.mCurrentState = 331;
                this.mTargetState = 331;
                this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            } catch (IllegalArgumentException unknown) {
                this.mCurrentState = 331;
                this.mTargetState = 331;
                this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
            } catch (Throwable th) {
                _notifyMediaStatus();
                throw th;
            }
            _notifyMediaStatus();
        } else if (uri == null && this.fd == null) {
            this.mCurrentState = 331;
            this.mTargetState = 331;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
        }
    }

    public void setMediaController(IMediaController iMediaController) {
        IMediaController iMediaController2 = this.mMediaController;
        if (iMediaController2 != null) {
            iMediaController2.hide();
        }
        this.mMediaController = iMediaController;
        attachMediaController();
    }

    private void attachMediaController() {
        IMediaController iMediaController;
        if (this.mMediaPlayer != null && (iMediaController = this.mMediaController) != null) {
            iMediaController.setMediaPlayer(this);
            this.mMediaController.setAnchorView(getParent() instanceof View ? (View) getParent() : this);
            this.mMediaController.setEnabled(isInPlaybackState());
        }
    }

    public IMediaPlayer getMediaPlayer() {
        return this.mMediaPlayer;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _notifyMediaStatus() {
        IMediaPlayer.OnInfoListener onInfoListener = this.mOnInfoListener;
        if (onInfoListener != null) {
            onInfoListener.onInfo(this.mMediaPlayer, this.mCurrentState, -1);
        }
    }

    private void showCoverImage() {
        if (this.mRenderView != null) {
            if (this.mCurrentAspectRatio == 1) {
                this.coverImage.setScaleType(ImageView.ScaleType.CENTER_CROP);
            } else {
                this.coverImage.setScaleType(ImageView.ScaleType.FIT_CENTER);
            }
            Bitmap videoScreenshot = this.mRenderView.getVideoScreenshot();
            int i = this.mVideoRotationDegree;
            if (i > 0) {
                videoScreenshot = adjustPhotoRotation(videoScreenshot, i);
            }
            if (videoScreenshot != null) {
                this.coverImage.setImageBitmap(videoScreenshot);
            } else {
                this.coverImage.setBackgroundColor(-16777216);
            }
            this.coverImage.bringToFront();
            this.coverImage.setVisibility(0);
        }
    }

    private Bitmap adjustPhotoRotation(Bitmap bitmap, int i) {
        if (bitmap == null) {
            return null;
        }
        Matrix matrix = new Matrix();
        matrix.setRotate((float) i, ((float) bitmap.getWidth()) / 2.0f, ((float) bitmap.getHeight()) / 2.0f);
        try {
            return Bitmap.createBitmap(bitmap, 0, 0, bitmap.getWidth(), bitmap.getHeight(), matrix, true);
        } catch (OutOfMemoryError unused) {
            return null;
        }
    }

    public void setOnBufferingUpdateListener(IMediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener) {
        this.bufferingUpdateListener = onBufferingUpdateListener;
    }

    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener onPreparedListener) {
        this.mOnPreparedListener = onPreparedListener;
    }

    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener onCompletionListener) {
        this.mOnCompletionListener = onCompletionListener;
    }

    public void setOnErrorListener(IMediaPlayer.OnErrorListener onErrorListener) {
        this.mOnErrorListener = onErrorListener;
    }

    public void setOnInfoListener(IMediaPlayer.OnInfoListener onInfoListener) {
        this.mOnInfoListener = onInfoListener;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void bindSurfaceHolder(IMediaPlayer iMediaPlayer, IRenderView.ISurfaceHolder iSurfaceHolder) {
        if (iMediaPlayer != null) {
            if (iSurfaceHolder == null) {
                iMediaPlayer.setDisplay(null);
            } else {
                iSurfaceHolder.bindToMediaPlayer(iMediaPlayer);
            }
        }
    }

    public void releaseWithoutStop() {
        IMediaPlayer iMediaPlayer = this.mMediaPlayer;
        if (iMediaPlayer != null) {
            iMediaPlayer.setDisplay(null);
        }
    }

    public void release(boolean z) {
        IMediaPlayer iMediaPlayer = this.mMediaPlayer;
        if (iMediaPlayer != null) {
            iMediaPlayer.reset();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            this.mCurrentState = 330;
            _notifyMediaStatus();
            if (z) {
                this.mTargetState = 330;
            }
            ((AudioManager) this.mAppContext.getSystemService("audio")).abandonAudioFocus(null);
        }
    }

    public void releaseOnWorkerThread(boolean z) {
        if (this.mMediaPlayer != null) {
            ThreadPool.self().addThreadTask(new Runnable() {
                /* class io.dcloud.media.weex.weex_video.ijkplayer.media.$$Lambda$IjkVideoView$GZs7uEeOUBkKWhbWORNmok4PBo */

                public final void run() {
                    IjkVideoView.this.lambda$releaseOnWorkerThread$0$IjkVideoView();
                }
            });
            this.mCurrentState = 330;
            _notifyMediaStatus();
            if (z) {
                this.mTargetState = 330;
            }
            ((AudioManager) this.mAppContext.getSystemService("audio")).abandonAudioFocus(null);
        }
    }

    public /* synthetic */ void lambda$releaseOnWorkerThread$0$IjkVideoView() {
        this.mMediaPlayer.reset();
        this.mMediaPlayer.release();
        this.mMediaPlayer = null;
    }

    public void destroy() {
        releaseOnWorkerThread(true);
    }

    public boolean onTouchEvent(MotionEvent motionEvent) {
        if (!isInPlaybackState() || this.mMediaController == null) {
            return false;
        }
        toggleMediaControlsVisibility();
        return false;
    }

    public boolean onTrackballEvent(MotionEvent motionEvent) {
        if (!isInPlaybackState() || this.mMediaController == null) {
            return false;
        }
        toggleMediaControlsVisibility();
        return false;
    }

    public boolean onKeyDown(int i, KeyEvent keyEvent) {
        boolean z = (i == 4 || i == 24 || i == 25 || i == 164 || i == 82 || i == 5 || i == 6) ? false : true;
        if (isInPlaybackState() && z && this.mMediaController != null) {
            if (i == 79 || i == 85) {
                if (this.mMediaPlayer.isPlaying()) {
                    pause();
                    this.mMediaController.show();
                } else {
                    start();
                    this.mMediaController.hide();
                }
                return true;
            } else if (i == 126) {
                if (!this.mMediaPlayer.isPlaying()) {
                    start();
                    this.mMediaController.hide();
                }
                return true;
            } else if (i == 86 || i == 127) {
                if (this.mMediaPlayer.isPlaying()) {
                    pause();
                    this.mMediaController.show();
                }
                return true;
            } else {
                toggleMediaControlsVisibility();
            }
        }
        return super.onKeyDown(i, keyEvent);
    }

    private void toggleMediaControlsVisibility() {
        if (this.mMediaController.isShowing()) {
            this.mMediaController.hide();
        } else {
            this.mMediaController.show();
        }
    }

    public void start() {
        Log.e("TTAG", "start " + isInPlaybackState());
        ((AudioManager) this.mAppContext.getSystemService("audio")).requestAudioFocus(null, 3, 4);
        if (this.isStoped && this.mMediaPlayer == null && this.mCurrentState == 330) {
            this.isStoped = false;
            setRender(2);
            openVideo();
            requestLayout();
            invalidate();
        }
        if (isInPlaybackState()) {
            this.mMediaPlayer.start();
            this.mCurrentState = 334;
            _notifyMediaStatus();
            this.isSetSeekTo = false;
        }
        this.mTargetState = 334;
        if (this.mCurrentState == 331) {
            this.mTargetState = 331;
            this.mErrorListener.onError(this.mMediaPlayer, 1, 0);
        }
        this.coverImage.setVisibility(8);
    }

    public void pause() {
        if (isInPlaybackState() && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.pause();
            this.mCurrentState = 335;
            _notifyMediaStatus();
        }
        this.mTargetState = 335;
        showCoverImage();
    }

    public void suspend() {
        release(false);
    }

    public void resume() {
        openVideo();
    }

    public void reload() {
        this.mCurrentState = 334;
        this.mTargetState = 334;
    }

    public int getDuration() {
        if (isInPlaybackState()) {
            return (int) this.mMediaPlayer.getDuration();
        }
        return -1;
    }

    public void setvolume(float f) {
        IMediaPlayer iMediaPlayer = this.mMediaPlayer;
        if (iMediaPlayer != null) {
            iMediaPlayer.setVolume(f, f);
            return;
        }
        this.isMediaReady = false;
        this.volume = f;
    }

    public int getInterruptPosition() {
        IMediaPlayer iMediaPlayer = this.mMediaPlayer;
        if (iMediaPlayer != null) {
            return (int) iMediaPlayer.getCurrentPosition();
        }
        return 0;
    }

    public int getCurrentPosition() {
        long currentPosition;
        if (!isInPlaybackState()) {
            return 0;
        }
        if (this.mCurrentState != 336 || this.isSetSeekTo) {
            currentPosition = this.mMediaPlayer.getCurrentPosition();
        } else {
            currentPosition = this.mMediaPlayer.getDuration();
        }
        return (int) currentPosition;
    }

    public void seekTo(int i) {
        if (isInPlaybackState()) {
            this.mSeekStartTime = System.currentTimeMillis();
            this.mMediaPlayer.seekTo((long) i);
            this.mSeekWhenPrepared = 0;
            if (isPlaying()) {
                this.isSetSeekTo = false;
            } else {
                this.isSetSeekTo = true;
            }
        } else {
            this.mSeekWhenPrepared = i;
            this.isSetSeekTo = false;
        }
    }

    public boolean isPlaying() {
        return isInPlaybackState() && this.mMediaPlayer.isPlaying();
    }

    public int getBufferPercentage() {
        if (this.mMediaPlayer != null) {
            return this.mCurrentBufferPercentage;
        }
        return 0;
    }

    private boolean isInPlaybackState() {
        int i;
        return (this.mMediaPlayer == null || (i = this.mCurrentState) == 331 || i == 330 || i == 332) ? false : true;
    }

    public boolean canPause() {
        return this.mCanPause;
    }

    public boolean canSeekBackward() {
        return this.mCanSeekBack;
    }

    public boolean canSeekForward() {
        return this.mCanSeekForward;
    }

    public void setAspectRatio(int i) {
        this.mCurrentAspectRatio = i;
        IRenderView iRenderView = this.mRenderView;
        if (iRenderView != null) {
            iRenderView.setAspectRatio(i);
        }
    }

    private void initRenders() {
        setRender(2);
    }

    /* access modifiers changed from: package-private */
    public int getVideoWidth() {
        IMediaPlayer iMediaPlayer = this.mMediaPlayer;
        if (iMediaPlayer == null) {
            return 0;
        }
        return iMediaPlayer.getVideoWidth();
    }

    /* access modifiers changed from: package-private */
    public int getVideoHeight() {
        IMediaPlayer iMediaPlayer = this.mMediaPlayer;
        if (iMediaPlayer == null) {
            return 0;
        }
        return iMediaPlayer.getVideoHeight();
    }

    public IMediaPlayer createPlayer(int i) {
        if (i == 1) {
            return new AndroidMediaPlayer();
        }
        IjkMediaPlayer ijkMediaPlayer = null;
        if (!(this.mUri == null && this.fd == null)) {
            ijkMediaPlayer = new IjkMediaPlayer();
            if (TextUtils.isEmpty(this.customUA)) {
                ijkMediaPlayer.setOption(1, "user_agent", HttpConstants.getDefaultUA());
            } else {
                ijkMediaPlayer.setOption(1, "user_agent", this.customUA);
            }
            if (this.mIsUsingMediaCodec) {
                ijkMediaPlayer.setOption(4, "mediacodec", 1);
                if (this.mIsUsingMediaCodecAutoRotate) {
                    ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", 1);
                } else {
                    ijkMediaPlayer.setOption(4, "mediacodec-auto-rotate", 0);
                }
                if (this.mIsMediaCodecHandleResolutionChange) {
                    ijkMediaPlayer.setOption(4, "mediacodec-handle-resolution-change", 1);
                } else {
                    ijkMediaPlayer.setOption(4, "mediacodec-handle-resolution-change", 0);
                }
            } else {
                ijkMediaPlayer.setOption(4, "mediacodec", 0);
            }
            if (this.mIsUsingOpenSLES) {
                ijkMediaPlayer.setOption(4, "opensles", 1);
            } else {
                ijkMediaPlayer.setOption(4, "opensles", 0);
            }
            if (TextUtils.isEmpty(this.mPixelFormat)) {
                ijkMediaPlayer.setOption(4, "overlay-format", 842225234);
            } else {
                ijkMediaPlayer.setOption(4, "overlay-format", this.mPixelFormat);
            }
            if (this.enumPlayStrategy == EnumPlayStrategy.PLAY_SMOOTH) {
                ijkMediaPlayer.setOption(4, "infbuf", 1);
                ijkMediaPlayer.setOption(4, "max-fps", 25);
                ijkMediaPlayer.setOption(4, "opensles", 1);
                ijkMediaPlayer.setOption(4, "mediacodec-mpeg4", 1);
                ijkMediaPlayer.setOption(4, "mediacodec-hevc", 1);
            } else if (this.enumPlayStrategy != EnumPlayStrategy.START_QUICK && this.enumPlayStrategy == EnumPlayStrategy.M3U8_SMOOTH) {
                ijkMediaPlayer.setOption(4, "infbuf", 1);
                ijkMediaPlayer.setOption(4, "max-fps", 25);
            }
            ijkMediaPlayer.setOption(4, "start-on-prepared", 0);
            ijkMediaPlayer.setOption(1, "http-detect-range-support", 0);
            ijkMediaPlayer.setOption(2, "skip_loop_filter", 0);
            ijkMediaPlayer.setOption(4, "soundtouch", 1);
            ijkMediaPlayer.setOption(1, "dns_cache_clear", 1);
            Uri uri = this.mUri;
            if (uri == null || (!uri.toString().startsWith("rtmp://") && !this.mUri.toString().startsWith("rtsp://"))) {
                Uri uri2 = this.mUri;
                if (uri2 != null && (uri2.toString().startsWith(DeviceInfo.HTTP_PROTOCOL) || this.mUri.toString().startsWith(DeviceInfo.HTTPS_PROTOCOL))) {
                    if (this.mUri.toString().endsWith(".m3u8") || this.mUri.toString().endsWith(".M3U8")) {
                        this.isHttpCacheOpen = false;
                    } else {
                        ijkMediaPlayer.setOption(4, "enable-accurate-seek", 1);
                    }
                    if (this.isHttpCacheOpen) {
                        VideoCacheUtil.cleanCacheIfNesscessary(this.mAppContext);
                        Uri cacheHttpUriWrap = VideoCacheUtil.cacheHttpUriWrap(this.mUri);
                        this.mUri = cacheHttpUriWrap;
                        String cacheFilePath = VideoCacheUtil.getCacheFilePath(this.mAppContext, cacheHttpUriWrap);
                        String cacheMapFilePath = VideoCacheUtil.getCacheMapFilePath(this.mAppContext, this.mUri);
                        if (!TextUtils.isEmpty(cacheFilePath) && !TextUtils.isEmpty(cacheMapFilePath)) {
                            ijkMediaPlayer.setOption(1, "cache_file_path", cacheFilePath);
                            ijkMediaPlayer.setOption(1, "cache_map_path", cacheMapFilePath);
                            ijkMediaPlayer.setOption(1, "auto_save_map", 1);
                            ijkMediaPlayer.setOption(1, "parse_cache_map", 1);
                        }
                    }
                }
            } else {
                if (this.mUri.toString().startsWith("rtsp://")) {
                    ijkMediaPlayer.setOption(1, "rtsp_transport", "tcp");
                }
                ijkMediaPlayer.setOption(1, "flush_packets", 1);
                ijkMediaPlayer.setOption(4, "packet-buffering", 0);
                ijkMediaPlayer.setOption(4, "framedrop", 1);
            }
        }
        return this.mIsUsingMediaCodec ? new TextureMediaPlayer(ijkMediaPlayer) : ijkMediaPlayer;
    }

    public boolean isBackgroundPlayEnabled() {
        return this.mEnableBackgroundPlay;
    }

    private String buildTimeMilli(long j) {
        long j2 = j / 1000;
        long j3 = j2 / 3600;
        long j4 = (j2 % 3600) / 60;
        long j5 = j2 % 60;
        if (j <= 0) {
            return "--:--";
        }
        if (j3 >= 100) {
            return String.format(Locale.US, "%d:%02d:%02d", Long.valueOf(j3), Long.valueOf(j4), Long.valueOf(j5));
        } else if (j3 > 0) {
            return String.format(Locale.US, "%02d:%02d:%02d", Long.valueOf(j3), Long.valueOf(j4), Long.valueOf(j5));
        } else {
            return String.format(Locale.US, "%02d:%02d", Long.valueOf(j4), Long.valueOf(j5));
        }
    }

    public ITrackInfo[] getTrackInfo() {
        IMediaPlayer iMediaPlayer = this.mMediaPlayer;
        if (iMediaPlayer == null) {
            return null;
        }
        return iMediaPlayer.getTrackInfo();
    }

    public void selectTrack(int i) {
        MediaPlayerCompat.selectTrack(this.mMediaPlayer, i);
    }

    public void deselectTrack(int i) {
        MediaPlayerCompat.deselectTrack(this.mMediaPlayer, i);
    }

    public int getSelectedTrack(int i) {
        return MediaPlayerCompat.getSelectedTrack(this.mMediaPlayer, i);
    }
}
