package io.dcloud.media.weex.weex_video.ijkplayer.media;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.res.Configuration;
import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.PorterDuff;
import android.graphics.drawable.LayerDrawable;
import android.media.AudioManager;
import android.net.Uri;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.SparseArray;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.OrientationEventListener;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import android.widget.SeekBar;
import android.widget.TextView;
import com.dcloud.android.v4.view.MotionEventCompat;
import com.taobao.weex.common.Constants;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.module.WXModalUIModule;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.utils.WXDataStructureUtil;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.WebAppActivity;
import io.dcloud.application.DCLoudApplicationImpl;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.constant.DOMException;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.common.util.net.NetCheckReceiver;
import io.dcloud.feature.ui.navigator.QueryNotchTool;
import io.dcloud.feature.weex_media.R;
import io.dcloud.feature.weex_media.VideoPlayerView;
import io.dcloud.feature.weex_media.option.EnumPlayStrategy;
import io.dcloud.media.weex.weex_video.ijkplayer.OnPlayerChangedListener;
import io.dcloud.media.weex.weex_video.ijkplayer.VideoR;
import io.dcloud.media.weex.weex_video.ijkplayer.danmaku.BaseDanmakuConverter;
import io.dcloud.media.weex.weex_video.ijkplayer.danmaku.BiliDanmukuParser;
import io.dcloud.media.weex.weex_video.ijkplayer.danmaku.OnDanmakuListener;
import io.dcloud.media.weex.weex_video.ijkplayer.danmaku.StandardDanmaKuParser;
import io.dcloud.media.weex.weex_video.ijkplayer.utils.MotionEventUtils;
import io.dcloud.media.weex.weex_video.ijkplayer.utils.NetWorkUtils;
import io.dcloud.media.weex.weex_video.ijkplayer.utils.StringUtils;
import io.dcloud.media.weex.weex_video.ijkplayer.widgets.MarqueeTextView;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.HashMap;
import master.flame.danmaku.controller.DrawHandler;
import master.flame.danmaku.controller.IDanmakuView;
import master.flame.danmaku.danmaku.loader.ILoader;
import master.flame.danmaku.danmaku.loader.IllegalDataException;
import master.flame.danmaku.danmaku.loader.android.DanmakuLoaderFactory;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.DanmakuTimer;
import master.flame.danmaku.danmaku.model.android.DanmakuContext;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.parser.IDataSource;
import org.json.JSONObject;
import tv.danmaku.ijk.media.player.IMediaPlayer;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class IjkPlayerView extends FrameLayout implements View.OnClickListener {
    private static final int DANMAKU_TAG_ACFUN = 702;
    private static final int DANMAKU_TAG_BILI = 701;
    private static final int DANMAKU_TAG_CUSTOM = 703;
    private static final int DEFAULT_HIDE_TIMEOUT = 5000;
    private static final int INTERRUPT_WHEN_PAUSE = 503;
    private static final int INTERRUPT_WHEN_PLAY = 502;
    private static final int INTERVAL_TIME = 1000;
    private static final int INVALID_VALUE = -1;
    private static final int MAX_VIDEO_SEEK = 1000;
    private static final int MSG_ENABLE_ORIENTATION = 10087;
    private static final int MSG_TRY_RELOAD = 10088;
    private static final int MSG_UPDATE_SEEK = 10086;
    private static final int MSG_UPDATE_TIME = 10099;
    private static final int NORMAL_STATUS = 501;
    private IMediaPlayer.OnBufferingUpdateListener bufferingUpdateListener;
    private VideoPlayerView.IOnPlayerViewChangeListener changeListener;
    private WXVContainer component;
    private boolean controlShowEnable;
    private int defaultDisplayCutoutMode;
    private float defaultScreenBrightness;
    private int defaultSystemUI;
    int duration;
    String fullCallFormat;
    private boolean isCenterPlayBtnVisibility;
    private boolean isFullScreenPageGesture;
    private boolean isLoadingVisibility;
    private boolean isMutePlayer;
    private boolean isPageGesture;
    private boolean isPlayBtnCenter;
    private boolean isPlayBtnVisibility;
    private boolean isProgressGesture;
    private boolean isRtmpUri;
    private boolean isShowProgress;
    private boolean isShowScreenLockButton;
    private int mAspectOptionsHeight;
    private Activity mAttachActivity;
    private AudioManager mAudioManager;
    private int mBasicOptionsWidth;
    private IMediaPlayer.OnCompletionListener mCompletionListener;
    private float mCurBrightness;
    private int mCurPosition;
    private int mCurVolume;
    private DanmakuContext mDanmakuContext;
    private BaseDanmakuConverter mDanmakuConverter;
    private OnDanmakuListener mDanmakuListener;
    private ILoader mDanmakuLoader;
    private BaseDanmakuParser mDanmakuParser;
    private int mDanmakuTag;
    private long mDanmakuTargetPosition;
    private int mDanmakuTextColor;
    private float mDanmakuTextSize;
    private int mDanmakuType;
    private IDanmakuView mDanmakuView;
    private String mDanmuList;
    private long mExitTime;
    private FrameLayout mFlTouchLayout;
    private FrameLayout mFlVideoBox;
    private LinearLayout mFullscreenTopBar;
    private GestureDetector mGestureDetector;
    private Handler mHandler;
    private Runnable mHideBarRunnable;
    private Runnable mHideTouchViewRunnable;
    private ImageView mIVMute;
    private IMediaPlayer.OnInfoListener mInfoListener;
    private int mInitHeight;
    private int mInterruptPosition;
    private boolean mIsAlwaysFullScreen;
    private boolean mIsBufferingStart;
    private boolean mIsDoubleTapEnable;
    private boolean mIsEnableDanmaku;
    private boolean mIsForbidOrientation;
    private boolean mIsForbidTouch;
    private boolean mIsFullscreen;
    private boolean mIsNeedRecoverScreen;
    private boolean mIsNetConnected;
    private boolean mIsNeverPlay;
    private boolean mIsPlayComplete;
    private boolean mIsReady;
    private boolean mIsRenderingStart;
    private boolean mIsScreenLocked;
    private boolean mIsSeeking;
    private boolean mIsShowBar;
    private ImageView mIvBack;
    private TextView mIvDanmakuControl;
    private ImageView mIvFullscreen;
    private ImageView mIvPlay;
    private ImageView mIvPlayCenter;
    private ImageView mIvPlayCircle;
    private ImageView mIvScreenLock;
    private LinearLayout mLlBottomBar;
    private ProgressBar mLoadingView;
    private int mMaxVolume;
    private int mMoreOptionsWidth;
    private NetBroadcastReceiver mNetReceiver;
    private OnPlayerChangedListener mOnPlayerChangedListener;
    private int mOrientation;
    private OrientationEventListener mOrientationListener;
    private IMediaPlayer.OnInfoListener mOutsideInfoListener;
    private GestureDetector.OnGestureListener mPlayerGestureListener;
    private SeekBar mPlayerSeek;
    public ImageView mPlayerThumb;
    private View.OnTouchListener mPlayerTouchListener;
    private ViewGroup.LayoutParams mRawParams;
    private ViewGroup mRootLayout;
    private Matrix mSaveMatrix;
    private ScreenBroadcastReceiver mScreenReceiver;
    private int mScreenUiVisibility;
    private final SeekBar.OnSeekBarChangeListener mSeekListener;
    private long mTargetPosition;
    private TextView mTvBrightness;
    private TextView mTvCurTime;
    private TextView mTvEndTime;
    private TextView mTvFastForward;
    private TextView mTvRecoverScreen;
    private MarqueeTextView mTvTitle;
    private TextView mTvVolume;
    private Matrix mVideoMatrix;
    private SparseArray<String> mVideoSource;
    private int mVideoStatus;
    private IjkVideoView mVideoView;
    private int mWidthPixels;
    private IMediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener;
    public int orientation;
    private int originOrientation;
    private VideoPlayerView parentView;
    String[] rates;
    Runnable screenLockHideRunnable;
    String timeUpdateF;

    @Target({ElementType.FIELD, ElementType.PARAMETER})
    @Retention(RetentionPolicy.SOURCE)
    public @interface DanmakuTag {
    }

    private void _recoverScreen() {
    }

    private void _toggleMoreColorOptions() {
    }

    public void hiddenLoaded(boolean z) {
    }

    public void setChangeListener(VideoPlayerView.IOnPlayerViewChangeListener iOnPlayerViewChangeListener) {
        this.changeListener = iOnPlayerViewChangeListener;
    }

    public IjkPlayerView(Context context) {
        this(context, null);
    }

    public IjkPlayerView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mHandler = new Handler() {
            /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass1 */

            public void handleMessage(Message message) {
                if (message.what == IjkPlayerView.MSG_UPDATE_SEEK) {
                    int _setProgress = IjkPlayerView.this._setProgress();
                    if (!IjkPlayerView.this.mIsSeeking && IjkPlayerView.this.mIsShowBar && IjkPlayerView.this.mVideoView.isPlaying()) {
                        sendMessageDelayed(obtainMessage(IjkPlayerView.MSG_UPDATE_SEEK), (long) (1000 - (_setProgress % 1000)));
                    }
                } else if (message.what == IjkPlayerView.MSG_ENABLE_ORIENTATION) {
                    if (IjkPlayerView.this.mOrientationListener != null) {
                        IjkPlayerView.this.mOrientationListener.enable();
                    }
                } else if (message.what == IjkPlayerView.MSG_TRY_RELOAD) {
                    if (IjkPlayerView.this.mIsNetConnected) {
                        IjkPlayerView.this.reload();
                    }
                    sendMessageDelayed(obtainMessage(IjkPlayerView.MSG_TRY_RELOAD), 3000);
                } else if (message.what == IjkPlayerView.MSG_UPDATE_TIME) {
                    IjkPlayerView.this.progressCallBack();
                    sendMessageDelayed(obtainMessage(IjkPlayerView.MSG_UPDATE_TIME), 250);
                }
            }
        };
        this.mIsForbidTouch = false;
        this.mIsDoubleTapEnable = false;
        this.mIsShowBar = true;
        this.mIsPlayComplete = false;
        this.mTargetPosition = -1;
        this.mCurPosition = -1;
        this.mCurVolume = -1;
        this.mCurBrightness = -1.0f;
        this.mIsNeverPlay = true;
        this.mIsForbidOrientation = true;
        this.mIsAlwaysFullScreen = false;
        this.mExitTime = 0;
        this.mVideoMatrix = new Matrix();
        this.mSaveMatrix = new Matrix();
        this.mIsNeedRecoverScreen = false;
        this.mIsReady = false;
        this.isRtmpUri = false;
        this.isPageGesture = false;
        this.isFullScreenPageGesture = true;
        this.isShowScreenLockButton = false;
        this.isProgressGesture = true;
        this.screenLockHideRunnable = new Runnable() {
            /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass2 */

            public void run() {
                IjkPlayerView.this.mIvScreenLock.setVisibility(8);
            }
        };
        this.isPlayBtnCenter = false;
        this.mSeekListener = new SeekBar.OnSeekBarChangeListener() {
            /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass3 */
            private long curPosition;

            public void onStartTrackingTouch(SeekBar seekBar) {
                IjkPlayerView.this.mIsSeeking = true;
                IjkPlayerView.this._showControlBar(3600000);
                IjkPlayerView.this.mHandler.removeMessages(IjkPlayerView.MSG_UPDATE_SEEK);
                this.curPosition = (long) IjkPlayerView.this.mVideoView.getCurrentPosition();
            }

            public void onProgressChanged(SeekBar seekBar, int i, boolean z) {
                String str;
                if (z) {
                    long duration = (long) IjkPlayerView.this.getDuration();
                    IjkPlayerView.this.mTargetPosition = (((long) i) * duration) / 1000;
                    int i2 = (int) ((IjkPlayerView.this.mTargetPosition - this.curPosition) / 1000);
                    if (IjkPlayerView.this.mTargetPosition > this.curPosition) {
                        str = StringUtils.generateTime(IjkPlayerView.this.mTargetPosition) + "/" + StringUtils.generateTime(duration) + "\n+" + i2 + DCLoudApplicationImpl.self().getContext().getString(R.string.dcloud_feature_weex_video_second_unit);
                    } else {
                        str = StringUtils.generateTime(IjkPlayerView.this.mTargetPosition) + "/" + StringUtils.generateTime(duration) + "\n" + i2 + DCLoudApplicationImpl.self().getContext().getString(R.string.dcloud_feature_weex_video_second_unit);
                    }
                    IjkPlayerView.this._setFastForward(str);
                }
            }

            public void onStopTrackingTouch(SeekBar seekBar) {
                IjkPlayerView.this._hideTouchView();
                IjkPlayerView.this.mIsSeeking = false;
                IjkPlayerView ijkPlayerView = IjkPlayerView.this;
                ijkPlayerView.seekTo((int) ijkPlayerView.mTargetPosition);
                IjkPlayerView.this.mTargetPosition = -1;
                IjkPlayerView.this._setProgress();
                IjkPlayerView.this._showControlBar(5000);
            }
        };
        this.mHideBarRunnable = new Runnable() {
            /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass4 */

            public void run() {
                IjkPlayerView.this._hideAllView(false);
            }
        };
        this.controlShowEnable = false;
        this.isShowProgress = true;
        this.isPlayBtnVisibility = true;
        this.isCenterPlayBtnVisibility = true;
        this.fullCallFormat = "{fullScreen:%b, direction:'%s'}";
        this.mOrientation = -90;
        this.orientation = 90;
        this.defaultSystemUI = 0;
        this.defaultDisplayCutoutMode = 0;
        this.rates = new String[]{"0.5", "0.8", "1.0", "1.25", "1.5", "2.0"};
        this.mPlayerGestureListener = new GestureDetector.SimpleOnGestureListener() {
            /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass7 */
            private boolean isDownTouch;
            private boolean isLandscape;
            private boolean isRecoverFromDanmaku;
            private boolean isVolume;

            public boolean onDown(MotionEvent motionEvent) {
                this.isDownTouch = true;
                this.isRecoverFromDanmaku = IjkPlayerView.this.recoverFromEditVideo();
                return super.onDown(motionEvent);
            }

            public boolean onScroll(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
                if (!IjkPlayerView.this.mIsForbidTouch && !IjkPlayerView.this.mIsNeverPlay) {
                    float x = motionEvent.getX();
                    float y = motionEvent.getY() - motionEvent2.getY();
                    float x2 = x - motionEvent2.getX();
                    if (this.isDownTouch) {
                        boolean z = true;
                        this.isLandscape = Math.abs(f) >= Math.abs(f2);
                        if (x <= ((float) IjkPlayerView.this.getResources().getDisplayMetrics().widthPixels) * 0.5f) {
                            z = false;
                        }
                        this.isVolume = z;
                        this.isDownTouch = false;
                    }
                    if (this.isLandscape) {
                        IjkPlayerView ijkPlayerView = IjkPlayerView.this;
                        ijkPlayerView._onProgressSlide((-x2) / ((float) ijkPlayerView.mVideoView.getWidth()));
                    } else {
                        float height = y / ((float) IjkPlayerView.this.mVideoView.getHeight());
                        if (this.isVolume) {
                            IjkPlayerView.this._onVolumeSlide(height);
                        } else {
                            IjkPlayerView.this._onBrightnessSlide(height);
                        }
                    }
                }
                return super.onScroll(motionEvent, motionEvent2, f, f2);
            }

            public boolean onSingleTapConfirmed(MotionEvent motionEvent) {
                if (!(IjkPlayerView.this.component == null || IjkPlayerView.this.component.getInstance() == null || !IjkPlayerView.this.component.getEvents().contains(Constants.Event.CLICK))) {
                    HashMap newHashMapWithExpectedSize = WXDataStructureUtil.newHashMapWithExpectedSize(1);
                    HashMap newHashMapWithExpectedSize2 = WXDataStructureUtil.newHashMapWithExpectedSize(4);
                    newHashMapWithExpectedSize2.put(Constants.Name.X, Float.valueOf(WXViewUtils.getWebPxByWidth(0.0f, IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth())));
                    newHashMapWithExpectedSize2.put(Constants.Name.Y, Float.valueOf(WXViewUtils.getWebPxByWidth(0.0f, IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth())));
                    newHashMapWithExpectedSize2.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth(IjkPlayerView.this.component.getLayoutWidth(), IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth())));
                    newHashMapWithExpectedSize2.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth(IjkPlayerView.this.component.getLayoutHeight(), IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth())));
                    newHashMapWithExpectedSize.put("position", newHashMapWithExpectedSize2);
                    IjkPlayerView.this.component.fireEvent(Constants.Event.CLICK, newHashMapWithExpectedSize);
                }
                if (!(!IjkPlayerView.this.isFullscreen() || IjkPlayerView.this.component == null || IjkPlayerView.this.component.getInstance() == null)) {
                    JSONObject jSONObject = new JSONObject();
                    try {
                        jSONObject.put(WXGestureType.GestureInfo.SCREEN_X, (double) WXViewUtils.getWebPxByWidth(motionEvent.getX(), IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth()));
                        jSONObject.put(WXGestureType.GestureInfo.SCREEN_Y, (double) WXViewUtils.getWebPxByWidth(motionEvent.getY(), IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth()));
                        jSONObject.put("screenWidth", (double) WXViewUtils.getWebPxByWidth((float) IjkPlayerView.this.getWidth(), IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth()));
                        jSONObject.put("screenHeight", (double) WXViewUtils.getWebPxByWidth((float) IjkPlayerView.this.getHeight(), IjkPlayerView.this.component.getInstance().getInstanceViewPortWidth()));
                    } catch (Exception unused) {
                    }
                    IjkPlayerView.this.mOnPlayerChangedListener.onChanged("fullscreenclick", jSONObject.toString());
                }
                if (this.isRecoverFromDanmaku) {
                    return true;
                }
                IjkPlayerView.this._toggleControlBar();
                if (IjkPlayerView.this.mIsFullscreen) {
                    IjkPlayerView.this.showScreenLockView();
                }
                return true;
            }

            public boolean onDoubleTap(MotionEvent motionEvent) {
                if (!IjkPlayerView.this.mIsNeverPlay && !this.isRecoverFromDanmaku && !IjkPlayerView.this.mIsForbidTouch && IjkPlayerView.this.mIsDoubleTapEnable) {
                    IjkPlayerView.this._refreshHideRunnable();
                    IjkPlayerView.this._togglePlayStatus();
                }
                return true;
            }
        };
        this.mHideTouchViewRunnable = new Runnable() {
            /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass8 */

            public void run() {
                IjkPlayerView.this._hideTouchView();
            }
        };
        this.mPlayerTouchListener = new View.OnTouchListener() {
            /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass9 */
            private static final int INVALID_POINTER = 2;
            private static final int NORMAL = 1;
            private static final int ZOOM_AND_ROTATE = 3;
            private float degree = 0.0f;
            private int fingerFlag = -1;
            private PointF midPoint = new PointF(0.0f, 0.0f);
            private int mode = 1;
            private float oldDist;
            private float scale;

            public boolean onTouch(View view, MotionEvent motionEvent) {
                int actionMasked = MotionEventCompat.getActionMasked(motionEvent);
                if (actionMasked == 0) {
                    this.mode = 1;
                    IjkPlayerView.this.mHandler.removeCallbacks(IjkPlayerView.this.mHideBarRunnable);
                } else if (actionMasked != 2) {
                    if (actionMasked != 5) {
                        if (actionMasked == 6) {
                            if (this.mode == 3) {
                                IjkPlayerView ijkPlayerView = IjkPlayerView.this;
                                ijkPlayerView.mIsNeedRecoverScreen = ijkPlayerView.mVideoView.adjustVideoView(this.scale);
                                if (IjkPlayerView.this.mIsNeedRecoverScreen && IjkPlayerView.this.mIsShowBar) {
                                    IjkPlayerView.this.mTvRecoverScreen.setVisibility(0);
                                }
                            }
                            this.mode = 2;
                        }
                    } else if (motionEvent.getPointerCount() != 3 || !IjkPlayerView.this.mIsFullscreen) {
                        this.mode = 2;
                    } else {
                        IjkPlayerView.this._hideTouchView();
                        this.mode = 3;
                        MotionEventUtils.midPoint(this.midPoint, motionEvent);
                        int calcFingerFlag = MotionEventUtils.calcFingerFlag(motionEvent);
                        this.fingerFlag = calcFingerFlag;
                        this.degree = MotionEventUtils.rotation(motionEvent, calcFingerFlag);
                        this.oldDist = MotionEventUtils.calcSpacing(motionEvent, this.fingerFlag);
                        IjkPlayerView ijkPlayerView2 = IjkPlayerView.this;
                        ijkPlayerView2.mSaveMatrix = ijkPlayerView2.mVideoView.getVideoTransform();
                    }
                } else if (this.mode == 3) {
                    IjkPlayerView.this.mVideoView.setVideoRotation((int) (MotionEventUtils.rotation(motionEvent, this.fingerFlag) - this.degree));
                    IjkPlayerView.this.mVideoMatrix.set(IjkPlayerView.this.mSaveMatrix);
                    this.scale = MotionEventUtils.calcSpacing(motionEvent, this.fingerFlag) / this.oldDist;
                    Matrix matrix = IjkPlayerView.this.mVideoMatrix;
                    float f = this.scale;
                    matrix.postScale(f, f, this.midPoint.x, this.midPoint.y);
                    IjkPlayerView.this.mVideoView.setVideoTransform(IjkPlayerView.this.mVideoMatrix);
                }
                if (this.mode == 1 && !IjkPlayerView.this.mGestureDetector.onTouchEvent(motionEvent) && MotionEventCompat.getActionMasked(motionEvent) == 1) {
                    IjkPlayerView.this._endGesture();
                }
                return true;
            }
        };
        this.timeUpdateF = "{currentTime:%f,duration:%f}";
        this.duration = -1;
        this.isLoadingVisibility = true;
        this.isMutePlayer = false;
        this.mIsRenderingStart = false;
        this.mIsBufferingStart = false;
        this.mInfoListener = new IMediaPlayer.OnInfoListener() {
            /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass10 */

            @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnInfoListener
            public boolean onInfo(IMediaPlayer iMediaPlayer, int i, int i2) {
                IjkPlayerView.this._switchStatus(i);
                if (IjkPlayerView.this.mOutsideInfoListener == null) {
                    return true;
                }
                IjkPlayerView.this.mOutsideInfoListener.onInfo(iMediaPlayer, i, i2);
                return true;
            }
        };
        this.onBufferingUpdateListener = new IMediaPlayer.OnBufferingUpdateListener() {
            /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass11 */

            @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnBufferingUpdateListener
            public void onBufferingUpdate(IMediaPlayer iMediaPlayer, int i) {
                if (IjkPlayerView.this.bufferingUpdateListener != null) {
                    IjkPlayerView.this.bufferingUpdateListener.onBufferingUpdate(iMediaPlayer, i);
                }
            }
        };
        this.mVideoSource = new SparseArray<>();
        this.mVideoStatus = NORMAL_STATUS;
        this.mDanmakuTag = 701;
        this.mIsEnableDanmaku = false;
        this.mDanmakuTextColor = -1;
        this.mDanmakuTextSize = -1.0f;
        this.mDanmakuType = 1;
        this.mBasicOptionsWidth = -1;
        this.mMoreOptionsWidth = -1;
        this.mDanmakuTargetPosition = -1;
        this.mDanmuList = "";
        this.mIsScreenLocked = false;
        _initView(context);
    }

    public IjkPlayerView(Context context, AttributeSet attributeSet, VideoPlayerView videoPlayerView) {
        this(context, attributeSet);
        this.parentView = videoPlayerView;
    }

    public void setComponent(WXVContainer wXVContainer) {
        this.component = wXVContainer;
    }

    private void _initView(Context context) {
        if (context instanceof Activity) {
            this.mAttachActivity = (Activity) context;
            View.inflate(context, VideoR.VIDEO_IJK_LAYOUT_PLAYER_VIEW, this);
            this.mVideoView = (IjkVideoView) findViewById(VideoR.VIDEO_IJK_ID_VIDEO_VIEW);
            this.mPlayerThumb = (ImageView) findViewById(VideoR.VIDEO_IJK_ID_IV_THUMB);
            this.mLoadingView = (ProgressBar) findViewById(VideoR.VIDEO_IJK_ID_PD_LOADING);
            this.mTvVolume = (TextView) findViewById(VideoR.VIDEO_IJK_ID_TV_VOLUME);
            this.mTvBrightness = (TextView) findViewById(VideoR.VIDEO_IJK_ID_TV_BRIGHTNESS);
            this.mTvFastForward = (TextView) findViewById(VideoR.VIDEO_IJK_ID_TV_FAST_FORWARD);
            this.mFlTouchLayout = (FrameLayout) findViewById(VideoR.VIDEO_IJK_ID_FL_TOUCH_LAYOUT);
            this.mIvBack = (ImageView) findViewById(VideoR.VIDEO_IJK_ID_IV_BACK);
            this.mTvTitle = (MarqueeTextView) findViewById(VideoR.VIDEO_IJK_ID_TV_TITLE);
            this.mFullscreenTopBar = (LinearLayout) findViewById(VideoR.VIDEO_IJK_ID_FULLSCREEN_TOP_BAR);
            this.mIvPlay = (ImageView) findViewById(VideoR.VIDEO_IJK_ID_IV_PLAY);
            this.mTvCurTime = (TextView) findViewById(VideoR.VIDEO_IJK_ID_TV_CUR_TIME);
            this.mPlayerSeek = (SeekBar) findViewById(VideoR.VIDEO_IJK_ID_PLAYER_SEEK);
            this.mTvEndTime = (TextView) findViewById(VideoR.VIDEO_IJK_ID_TV_END_TIME);
            this.mIvFullscreen = (ImageView) findViewById(VideoR.VIDEO_IJK_ID_IV_FULLSCREEN);
            this.mLlBottomBar = (LinearLayout) findViewById(VideoR.VIDEO_IJK_ID_LL_BOTTOM_BAR);
            this.mFlVideoBox = (FrameLayout) findViewById(VideoR.VIDEO_IJK_ID_FL_VIDEO_BOX);
            this.mIvPlayCircle = (ImageView) findViewById(VideoR.VIDEO_IJK_ID_IV_PLAY_CIRCLE);
            this.mTvRecoverScreen = (TextView) findViewById(VideoR.VIDEO_IJK_ID_TV_RECOVER_SCREEN);
            this.mIvDanmakuControl = (TextView) findViewById(VideoR.VIDEO_IJK_ID_IV_DANMAKU_CONTROL);
            this.mIVMute = (ImageView) findViewById(VideoR.VIDEO_IJK_ID_IV_MUTE);
            this.mIvPlayCenter = (ImageView) findViewById(VideoR.VIDEO_IJK_ID_IV_PLAY_CENTER);
            this.mIvScreenLock = (ImageView) findViewById(VideoR.VIDEO_IJK_ID_IV_SCREEN_LOCK);
            this.mAspectOptionsHeight = getResources().getDimensionPixelSize(VideoR.VIDEO_IJK_DIMEN_ASPECT_BNT_SIZE) * 4;
            _initReceiver();
            this.mIvPlay.setOnClickListener(this);
            this.mIvBack.setOnClickListener(this);
            this.mIvFullscreen.setOnClickListener(this);
            this.mIvPlayCircle.setOnClickListener(this);
            this.mTvRecoverScreen.setOnClickListener(this);
            this.mIVMute.setOnClickListener(this);
            this.mIvPlayCenter.setOnClickListener(this);
            setOnClickListener(this);
            this.mIvScreenLock.setOnClickListener(this);
            if (this.mIsForbidTouch) {
                this.mIvScreenLock.setImageResource(R.drawable.video_screen_lock);
                this.mIvScreenLock.setTag(1);
                return;
            }
            this.mIvScreenLock.setImageResource(R.drawable.video_screen_unlock);
            this.mIvScreenLock.setTag(0);
            return;
        }
        throw new IllegalArgumentException("Context must be Activity");
    }

    public void setVideoVisibility() {
        IjkVideoView ijkVideoView = this.mVideoView;
        if (ijkVideoView != null) {
            ijkVideoView.setVisibility(0);
        }
    }

    public void setIsShowScreenLockButton(boolean z) {
        this.isShowScreenLockButton = z;
    }

    public void showScreenLockView() {
        if (this.isShowScreenLockButton) {
            this.mIvScreenLock.setVisibility(0);
            getHandler().removeCallbacks(this.screenLockHideRunnable);
            getHandler().postDelayed(this.screenLockHideRunnable, WebAppActivity.SPLASH_SECOND);
            return;
        }
        this.mIvScreenLock.setVisibility(8);
    }

    public void setmIsDoubleTapEnable(boolean z) {
        this.mIsDoubleTapEnable = z;
    }

    private void setSeekBarColor() {
        LayerDrawable layerDrawable = (LayerDrawable) this.mPlayerSeek.getProgressDrawable();
        layerDrawable.findDrawableByLayerId(16908288).setColorFilter(Color.parseColor("#ff00ff"), PorterDuff.Mode.SRC_ATOP);
        layerDrawable.findDrawableByLayerId(16908303).setColorFilter(Color.parseColor("#ffff00"), PorterDuff.Mode.SRC_ATOP);
        layerDrawable.findDrawableByLayerId(16908301).setColorFilter(Color.parseColor("#00ffff"), PorterDuff.Mode.SRC_ATOP);
        this.mPlayerSeek.getThumb().setColorFilter(Color.parseColor("#0000ff"), PorterDuff.Mode.SRC_ATOP);
    }

    private void _initMediaPlayer() {
        IjkMediaPlayer.loadLibrariesOnce(null);
        IjkMediaPlayer.native_profileBegin("libijkplayer.so");
        AudioManager audioManager = (AudioManager) this.mAttachActivity.getSystemService("audio");
        this.mAudioManager = audioManager;
        this.mMaxVolume = audioManager.getStreamMaxVolume(3);
        this.defaultScreenBrightness = this.mAttachActivity.getWindow().getAttributes().screenBrightness;
        this.mPlayerSeek.setMax(1000);
        this.mPlayerSeek.setOnSeekBarChangeListener(this.mSeekListener);
        this.mVideoView.setOnInfoListener(this.mInfoListener);
        this.mVideoView.setOnBufferingUpdateListener(this.onBufferingUpdateListener);
        this.mGestureDetector = new GestureDetector(this.mAttachActivity, this.mPlayerGestureListener);
        this.mFlVideoBox.setClickable(true);
        this.mFlVideoBox.setOnTouchListener(this.mPlayerTouchListener);
        if (!this.mIsForbidOrientation) {
            initOrientationEventListener();
        }
    }

    /* access modifiers changed from: protected */
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        if (this.mInitHeight == 0) {
            this.mInitHeight = getHeight();
            this.mWidthPixels = getResources().getDisplayMetrics().widthPixels;
        }
    }

    public void onResume() {
        if (this.mIsScreenLocked) {
            this.mIsScreenLocked = false;
        }
        this.mVideoView.setRender(2);
        this.mVideoView.resume();
        if (!this.mIsForbidTouch && !this.mIsForbidOrientation) {
            this.mOrientationListener.enable();
        }
        int i = this.mCurPosition;
        if (i != -1) {
            seekTo(i);
            this.mCurPosition = -1;
        }
    }

    public void onPause() {
        this.mCurPosition = this.mVideoView.getCurrentPosition();
        this.mVideoView.pause();
        this.mIvPlay.setSelected(false);
        this.mIvPlayCenter.setSelected(false);
        OrientationEventListener orientationEventListener = this.mOrientationListener;
        if (orientationEventListener != null) {
            orientationEventListener.disable();
        }
        _pauseDanmaku();
    }

    public int onDestroy() {
        int currentPosition = this.mVideoView.getCurrentPosition();
        this.mVideoView.destroy();
        IjkMediaPlayer.native_profileEnd();
        IDanmakuView iDanmakuView = this.mDanmakuView;
        if (iDanmakuView != null) {
            iDanmakuView.release();
            this.mDanmakuView = null;
        }
        MarqueeTextView marqueeTextView = this.mTvTitle;
        if (marqueeTextView != null) {
            marqueeTextView.stopMotion();
        }
        this.mHandler.removeMessages(MSG_TRY_RELOAD);
        this.mHandler.removeMessages(MSG_UPDATE_SEEK);
        this.mHandler.removeMessages(MSG_UPDATE_TIME);
        this.mAttachActivity.unregisterReceiver(this.mScreenReceiver);
        this.mAttachActivity.unregisterReceiver(this.mNetReceiver);
        this.mAttachActivity.getWindow().clearFlags(128);
        setMutePlayer(false);
        this.mAudioManager.abandonAudioFocus(null);
        WindowManager.LayoutParams attributes = this.mAttachActivity.getWindow().getAttributes();
        attributes.screenBrightness = this.defaultScreenBrightness;
        this.mAttachActivity.getWindow().setAttributes(attributes);
        return currentPosition;
    }

    public boolean handleVolumeKey(int i) {
        if (i == 24) {
            _setVolume(true);
            return true;
        } else if (i != 25) {
            return false;
        } else {
            _setVolume(false);
            return true;
        }
    }

    public boolean onBackPressed() {
        if (recoverFromEditVideo() || this.mIsAlwaysFullScreen) {
            return true;
        }
        if (!this.mIsFullscreen) {
            return false;
        }
        exitFullScreen();
        if (this.mIsForbidTouch) {
            this.mIsForbidTouch = false;
            _setControlBarVisible(this.mIsShowBar);
        }
        return true;
    }

    public IjkPlayerView init() {
        _initMediaPlayer();
        return this;
    }

    public IjkPlayerView switchVideoPath(String str) {
        return switchVideoPath(Uri.parse(str));
    }

    public IjkPlayerView switchVideoPath(Uri uri) {
        reset();
        _setControlBarVisible(true);
        this.duration = -1;
        return setVideoPath(uri);
    }

    public IjkPlayerView setVideoPath(String str) {
        return setVideoPath(Uri.parse(str));
    }

    public IjkPlayerView setPlayerRootView(ViewGroup viewGroup) {
        this.mRootLayout = viewGroup;
        return this;
    }

    public IjkPlayerView setVideoPath(Uri uri) {
        int i = 4;
        if (uri.toString().startsWith("rtmp:")) {
            this.isRtmpUri = true;
            this.mPlayerSeek.setEnabled(false);
            this.mPlayerSeek.setVisibility(4);
            this.mTvEndTime.setVisibility(4);
            this.mTvCurTime.setVisibility(4);
        } else {
            this.isRtmpUri = false;
            this.mPlayerSeek.setEnabled(true);
            SeekBar seekBar = this.mPlayerSeek;
            if (this.isShowProgress) {
                i = 0;
            }
            seekBar.setVisibility(i);
            this.mTvEndTime.setVisibility(0);
            this.mTvCurTime.setVisibility(0);
        }
        int i2 = this.mCurPosition;
        if (i2 != -1) {
            seekTo(i2);
            this.mCurPosition = -1;
        } else {
            seekTo(0);
        }
        this.mVideoView.setVideoURI(uri);
        return this;
    }

    public IjkPlayerView setVideoFileDescriptor(AssetsDataSourceProvider assetsDataSourceProvider) {
        int i = this.mCurPosition;
        if (i != -1) {
            seekTo(i);
            this.mCurPosition = -1;
        } else {
            seekTo(0);
        }
        this.mVideoView.setVideoFileDescriptor(assetsDataSourceProvider);
        return this;
    }

    public IjkPlayerView switchVideoFileDescriptor(AssetsDataSourceProvider assetsDataSourceProvider) {
        reset();
        _setControlBarVisible(true);
        this.duration = -1;
        return setVideoFileDescriptor(assetsDataSourceProvider);
    }

    public IjkPlayerView setTitle(String str) {
        this.mTvTitle.setText(str);
        return this;
    }

    public IjkPlayerView setHttpCacheEnable(boolean z) {
        IjkVideoView ijkVideoView = this.mVideoView;
        if (ijkVideoView != null) {
            ijkVideoView.setIsHttpCacheOpen(z);
        }
        return this;
    }

    public IjkPlayerView setHeader(String str) {
        IjkVideoView ijkVideoView = this.mVideoView;
        if (ijkVideoView != null) {
            ijkVideoView.setHeaderInfo(str);
        }
        return this;
    }

    public IjkPlayerView setFlowStrategy(EnumPlayStrategy enumPlayStrategy) {
        IjkVideoView ijkVideoView = this.mVideoView;
        if (ijkVideoView != null) {
            ijkVideoView.setFlowStrategy(enumPlayStrategy);
        }
        return this;
    }

    public void isMuteBtnShow(boolean z) {
        if (z) {
            this.mIVMute.setVisibility(0);
        } else {
            this.mIVMute.setVisibility(8);
        }
    }

    public void setPlayBtnPosition(String str) {
        boolean equals = str.equals("center");
        this.isPlayBtnCenter = equals;
        if (equals) {
            this.mIvPlay.setVisibility(8);
        } else if (this.isPlayBtnVisibility) {
            this.mIvPlayCenter.setVisibility(8);
            this.mIvPlay.setVisibility(0);
        }
    }

    public IjkPlayerView alwaysFullScreen() {
        this.mIsAlwaysFullScreen = true;
        fullScreen(this.mOrientation);
        this.mIvFullscreen.setVisibility(8);
        return this;
    }

    public void start() {
        if (this.mIsPlayComplete) {
            IDanmakuView iDanmakuView = this.mDanmakuView;
            if (iDanmakuView != null && iDanmakuView.isPrepared()) {
                this.mDanmakuView.seekTo(0L);
                this.mDanmakuView.pause();
            }
            this.mIsPlayComplete = false;
        }
        if (!this.mVideoView.isPlaying()) {
            this.mIvPlay.setSelected(true);
            this.mIvPlayCenter.setSelected(true);
            this.mVideoView.start();
            this.mHandler.sendEmptyMessage(MSG_UPDATE_SEEK);
            this.mHandler.sendEmptyMessage(MSG_UPDATE_TIME);
        }
        this.mIvPlayCircle.setVisibility(8);
        if (this.mIsNeverPlay) {
            this.mIsNeverPlay = false;
            if (this.mVideoView.getCurrentState() != 331) {
                setLoadingVisibility(0);
            }
            this.mIsShowBar = false;
            _loadDanmaku();
        }
        this.mAttachActivity.getWindow().addFlags(128);
    }

    public void reload() {
        setLoadingVisibility(0);
        if (!this.mIsReady) {
            this.mVideoView.release(false);
            this.mVideoView.setRender(2);
            start();
        } else if (NetWorkUtils.isNetworkAvailable(this.mAttachActivity)) {
            this.mVideoView.reload();
            this.mVideoView.start();
            int i = this.mInterruptPosition;
            if (i > 0) {
                seekTo(i);
                this.mInterruptPosition = 0;
            }
        } else {
            OnPlayerChangedListener onPlayerChangedListener = this.mOnPlayerChangedListener;
            if (onPlayerChangedListener != null) {
                onPlayerChangedListener.onChanged("error", DOMException.MSG_NETWORK_ERROR);
                setLoadingVisibility(8);
                return;
            }
            return;
        }
        this.mHandler.removeMessages(MSG_UPDATE_SEEK);
        this.mHandler.sendEmptyMessage(MSG_UPDATE_SEEK);
        this.mHandler.removeMessages(MSG_UPDATE_TIME);
        this.mHandler.sendEmptyMessage(MSG_UPDATE_TIME);
    }

    public boolean isPlaying() {
        return this.mVideoView.isPlaying();
    }

    public void pause() {
        this.mCurPosition = this.mVideoView.getCurrentPosition();
        this.mIvPlay.setSelected(false);
        this.mIvPlayCenter.setSelected(false);
        if (this.mVideoView.isPlaying()) {
            this.mVideoView.pause();
        }
        this.mHandler.removeMessages(MSG_UPDATE_TIME);
        _pauseDanmaku();
        this.mAttachActivity.getWindow().clearFlags(128);
    }

    public void seekTo(int i) {
        if (!this.isRtmpUri) {
            this.mVideoView.seekTo(i);
            this.mDanmakuTargetPosition = (long) i;
        }
    }

    public void stop() {
        pause();
        this.mVideoView.stopPlayback();
    }

    public void reset() {
        IDanmakuView iDanmakuView;
        if (this.mIsEnableDanmaku && (iDanmakuView = this.mDanmakuView) != null) {
            iDanmakuView.release();
            this.mDanmakuView = null;
            this.mIsEnableDanmaku = false;
        }
        this.mIsNeverPlay = true;
        this.mCurPosition = 0;
        stop();
        this.mVideoView.setRender(2);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _hideAllView(boolean z) {
        this.mFlTouchLayout.setVisibility(8);
        this.mFullscreenTopBar.setVisibility(8);
        this.mTvTitle.stopMotion();
        this.mIvPlayCenter.setVisibility(8);
        if (this.mLlBottomBar.getVisibility() == 0) {
            this.mOnPlayerChangedListener.onChanged("controlstoggle", "{'show':false}");
        }
        this.mLlBottomBar.setVisibility(8);
        if (!z) {
            this.mIsShowBar = false;
        }
        if (this.mIsNeedRecoverScreen) {
            this.mTvRecoverScreen.setVisibility(8);
        }
        if (this.mIvScreenLock.getVisibility() == 0) {
            this.mIvScreenLock.setVisibility(8);
        }
    }

    private void _setControlBarVisible(boolean z) {
        int i = 8;
        if (!this.controlShowEnable) {
            this.mLlBottomBar.setVisibility(8);
            this.mFullscreenTopBar.setVisibility(8);
            this.mTvTitle.stopMotion();
            if (this.mIsNeedRecoverScreen) {
                this.mTvRecoverScreen.setVisibility(8);
            }
        } else if (this.mIsNeverPlay) {
            if (this.mIvPlayCircle.getVisibility() != 0) {
                LinearLayout linearLayout = this.mLlBottomBar;
                if (z) {
                    i = 0;
                }
                linearLayout.setVisibility(i);
            }
        } else if (!this.mIsForbidTouch) {
            this.mLlBottomBar.setVisibility(z ? 0 : 8);
            if (this.isPlayBtnCenter && this.isPlayBtnVisibility) {
                this.mIvPlayCenter.setVisibility(z ? 0 : 8);
            }
            if (this.mIsFullscreen) {
                this.mFullscreenTopBar.setVisibility(z ? 0 : 8);
                if (z) {
                    this.mTvTitle.startMotion();
                } else {
                    this.mTvTitle.stopMotion();
                }
                if (this.mIsNeedRecoverScreen) {
                    TextView textView = this.mTvRecoverScreen;
                    if (z) {
                        i = 0;
                    }
                    textView.setVisibility(i);
                    return;
                }
                return;
            }
            this.mFullscreenTopBar.setVisibility(8);
            this.mTvTitle.stopMotion();
            if (this.mIsNeedRecoverScreen) {
                this.mTvRecoverScreen.setVisibility(8);
            }
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _toggleControlBar() {
        this.mIsShowBar = !this.mIsShowBar;
        OnPlayerChangedListener onPlayerChangedListener = this.mOnPlayerChangedListener;
        onPlayerChangedListener.onChanged("controlstoggle", "{'show':" + this.mIsShowBar + Operators.BLOCK_END_STR);
        _setControlBarVisible(this.mIsShowBar);
        this.mHandler.removeCallbacks(this.mHideBarRunnable);
        if (this.mIsShowBar) {
            this.mHandler.postDelayed(this.mHideBarRunnable, WebAppActivity.SPLASH_SECOND);
            this.mHandler.sendEmptyMessage(MSG_UPDATE_SEEK);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _showControlBar(int i) {
        if (!this.mIsShowBar) {
            _setProgress();
            this.mIsShowBar = true;
        }
        _setControlBarVisible(true);
        this.mHandler.removeMessages(MSG_UPDATE_SEEK);
        this.mHandler.sendEmptyMessage(MSG_UPDATE_SEEK);
        this.mHandler.removeCallbacks(this.mHideBarRunnable);
        if (i != 0) {
            this.mHandler.postDelayed(this.mHideBarRunnable, (long) i);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _togglePlayStatus() {
        if (this.mVideoView.isPlaying()) {
            pause();
        } else {
            start();
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _refreshHideRunnable() {
        this.mHandler.removeCallbacks(this.mHideBarRunnable);
        this.mHandler.postDelayed(this.mHideBarRunnable, WebAppActivity.SPLASH_SECOND);
    }

    private void _togglePlayerLock() {
        boolean z = !this.mIsForbidTouch;
        this.mIsForbidTouch = z;
        if (z) {
            OrientationEventListener orientationEventListener = this.mOrientationListener;
            if (orientationEventListener != null) {
                orientationEventListener.disable();
            }
            _hideAllView(true);
            return;
        }
        if (!this.mIsForbidOrientation) {
            this.mOrientationListener.enable();
        }
        this.mFullscreenTopBar.setVisibility(0);
        if (this.controlShowEnable) {
            this.mLlBottomBar.setVisibility(0);
        }
        if (this.mIsNeedRecoverScreen) {
            this.mTvRecoverScreen.setVisibility(0);
        }
    }

    public void setControls(boolean z) {
        this.controlShowEnable = z;
        this.mIsShowBar = z;
        OnPlayerChangedListener onPlayerChangedListener = this.mOnPlayerChangedListener;
        onPlayerChangedListener.onChanged("controlstoggle", "{'show':" + this.mIsShowBar + Operators.BLOCK_END_STR);
        _setControlBarVisible(this.mIsShowBar);
        if (this.mIsShowBar) {
            this.mHandler.sendEmptyMessage(MSG_UPDATE_SEEK);
        }
    }

    public void setPageGesture(boolean z) {
        this.isPageGesture = z;
    }

    public void setFullScreenPageGesture(boolean z) {
        this.isFullScreenPageGesture = z;
    }

    public void setProgressVisibility(boolean z) {
        SeekBar seekBar = this.mPlayerSeek;
        if (seekBar != null && !this.isRtmpUri) {
            this.isShowProgress = z;
            seekBar.setVisibility(z ? 0 : 4);
        }
    }

    public void setFullscreenBntVisibility(boolean z) {
        ImageView imageView = this.mIvFullscreen;
        if (imageView != null) {
            imageView.setVisibility(z ? 0 : 4);
        }
    }

    public void setPlayBntVisibility(boolean z) {
        ImageView imageView = this.mIvPlay;
        if (imageView != null) {
            this.isPlayBtnVisibility = z;
            int i = z ? 0 : 4;
            if (this.isPlayBtnCenter) {
                this.mIvPlayCenter.setVisibility(i);
            } else {
                imageView.setVisibility(i);
            }
        }
    }

    public void setCenterPlayBtnVisibility(boolean z) {
        ImageView imageView;
        if (this.mIsNeverPlay && !isPlaying() && (imageView = this.mIvPlayCircle) != null) {
            this.isCenterPlayBtnVisibility = z;
            imageView.setVisibility(z ? 0 : 8);
        }
    }

    public void setIsEnableProgressGesture(boolean z) {
        this.isProgressGesture = z;
    }

    public void onClick(View view) {
        WXVContainer wXVContainer;
        _refreshHideRunnable();
        int id = view.getId();
        if (id == VideoR.VIDEO_IJK_ID_IV_BACK) {
            onBackPressed();
        } else if (id == VideoR.VIDEO_IJK_ID_IV_PLAY || id == VideoR.VIDEO_IJK_ID_IV_PLAY_CIRCLE || id == VideoR.VIDEO_IJK_ID_IV_PLAY_CENTER) {
            _togglePlayStatus();
        } else if (id == VideoR.VIDEO_IJK_ID_IV_FULLSCREEN) {
            _toggleFullScreen();
        } else if (id == VideoR.VIDEO_IJK_ID_IV_DANMAKU_CONTROL) {
            _toggleDanmakuShow();
        } else if (id == VideoR.VIDEO_IJK_ID_TV_RECOVER_SCREEN) {
            this.mVideoView.resetVideoView(true);
            this.mIsNeedRecoverScreen = false;
            this.mTvRecoverScreen.setVisibility(8);
        } else if (id == VideoR.VIDEO_IJK_ID_IV_MUTE) {
            boolean z = !this.isMutePlayer;
            this.isMutePlayer = z;
            setMutePlayer(z);
            this.mIVMute.setSelected(this.isMutePlayer);
        } else if (id == VideoR.VIDEO_IJK_ID_IV_SCREEN_LOCK) {
            if (this.isShowScreenLockButton) {
                if (((Integer) this.mIvScreenLock.getTag()).intValue() == 1) {
                    this.mIvScreenLock.setTag(0);
                    this.mIvScreenLock.setImageResource(R.drawable.video_screen_unlock);
                    this.mIsForbidTouch = true;
                } else {
                    this.mIvScreenLock.setTag(1);
                    this.mIvScreenLock.setImageResource(R.drawable.video_screen_lock);
                    this.mIsForbidTouch = false;
                }
                _togglePlayerLock();
                this.mIvScreenLock.setVisibility(0);
                getHandler().removeCallbacks(this.screenLockHideRunnable);
                getHandler().postDelayed(this.screenLockHideRunnable, WebAppActivity.SPLASH_SECOND);
            }
        } else if (view == this && (wXVContainer = this.component) != null && wXVContainer.getEvents().contains(Constants.Event.CLICK)) {
            HashMap newHashMapWithExpectedSize = WXDataStructureUtil.newHashMapWithExpectedSize(1);
            HashMap newHashMapWithExpectedSize2 = WXDataStructureUtil.newHashMapWithExpectedSize(4);
            int[] iArr = new int[2];
            view.getLocationOnScreen(iArr);
            newHashMapWithExpectedSize2.put(Constants.Name.X, Float.valueOf(WXViewUtils.getWebPxByWidth((float) iArr[0], this.component.getInstance().getInstanceViewPortWidthWithFloat())));
            newHashMapWithExpectedSize2.put(Constants.Name.Y, Float.valueOf(WXViewUtils.getWebPxByWidth((float) iArr[1], this.component.getInstance().getInstanceViewPortWidthWithFloat())));
            newHashMapWithExpectedSize2.put("width", Float.valueOf(WXViewUtils.getWebPxByWidth(this.component.getLayoutWidth(), this.component.getInstance().getInstanceViewPortWidthWithFloat())));
            newHashMapWithExpectedSize2.put("height", Float.valueOf(WXViewUtils.getWebPxByWidth(this.component.getLayoutHeight(), this.component.getInstance().getInstanceViewPortWidthWithFloat())));
            newHashMapWithExpectedSize.put("position", newHashMapWithExpectedSize2);
            this.component.fireEvent(Constants.Event.CLICK, newHashMapWithExpectedSize);
        }
    }

    public IjkPlayerView enableOrientation() {
        this.mIsForbidOrientation = false;
        if (this.mOrientationListener == null) {
            initOrientationEventListener();
        }
        this.mOrientationListener.enable();
        return this;
    }

    private void _toggleFullScreen() {
        IjkVideoView ijkVideoView;
        if (isFullscreen()) {
            exitFullScreen();
            return;
        }
        VideoPlayerView videoPlayerView = this.parentView;
        if (videoPlayerView != null) {
            int direction = videoPlayerView.getDirection();
            if (direction == Integer.MIN_VALUE && (ijkVideoView = this.mVideoView) != null) {
                direction = ijkVideoView.getVideoHeight() > this.mVideoView.getVideoWidth() ? 0 : -90;
            }
            this.mOrientation = direction;
        }
        fullScreen(this.mOrientation);
    }

    private void _setFullScreen(boolean z) {
        String str;
        this.mIsFullscreen = z;
        this.mIvFullscreen.setSelected(z);
        int i = 0;
        if (this.mOnPlayerChangedListener != null) {
            if (z) {
                str = StringUtil.format(this.fullCallFormat, true, Constants.Value.HORIZONTAL);
            } else {
                str = StringUtil.format(this.fullCallFormat, false, "vertical");
            }
            this.mOnPlayerChangedListener.onChanged("fullscreenchange", str);
        }
        _showControlBar(5000);
        if (!this.mIsNeedRecoverScreen) {
            return;
        }
        if (z) {
            this.mVideoView.adjustVideoView(1.0f);
            TextView textView = this.mTvRecoverScreen;
            if (!this.mIsShowBar) {
                i = 8;
            }
            textView.setVisibility(i);
            return;
        }
        this.mVideoView.resetVideoView(false);
        this.mTvRecoverScreen.setVisibility(8);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _handleOrientation(int i) {
        if (!this.mIsNeverPlay) {
            if (!this.mIsFullscreen || this.mIsAlwaysFullScreen) {
                if (i >= 60 && i <= 120) {
                    this.mAttachActivity.setRequestedOrientation(8);
                } else if (i >= 240 && i <= 300) {
                    this.mAttachActivity.setRequestedOrientation(0);
                }
            } else if ((i >= 0 && i <= 30) || i >= 330) {
                this.mAttachActivity.setRequestedOrientation(1);
            }
        }
    }

    private void _refreshOrientationEnable() {
        if (!this.mIsForbidOrientation) {
            this.mOrientationListener.disable();
            this.mHandler.removeMessages(MSG_ENABLE_ORIENTATION);
            this.mHandler.sendEmptyMessageDelayed(MSG_ENABLE_ORIENTATION, 3000);
        }
    }

    private void initOrientationEventListener() {
        this.mOrientationListener = new OrientationEventListener(this.mAttachActivity) {
            /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass5 */

            public void onOrientationChanged(int i) {
                IjkPlayerView.this._handleOrientation(i);
            }
        };
    }

    public boolean isFullscreen() {
        return this.mIsFullscreen;
    }

    public void fullScreen(int i) {
        ViewGroup.LayoutParams layoutParams;
        VideoPlayerView.IOnPlayerViewChangeListener iOnPlayerViewChangeListener = this.changeListener;
        if (iOnPlayerViewChangeListener != null) {
            iOnPlayerViewChangeListener.onChanged(true);
        }
        _refreshOrientationEnable();
        if (!this.mIsFullscreen) {
            this.originOrientation = this.mAttachActivity.getRequestedOrientation();
            this.orientation = i;
            if (i == 0) {
                if (this.mAttachActivity.getRequestedOrientation() != 1) {
                    this.mAttachActivity.setRequestedOrientation(1);
                }
            } else if (i == 90) {
                if (this.mAttachActivity.getRequestedOrientation() != 8) {
                    this.mAttachActivity.setRequestedOrientation(8);
                }
            } else if (i == -90 && this.mAttachActivity.getRequestedOrientation() != 0) {
                this.mAttachActivity.setRequestedOrientation(0);
            }
            setNavigationBar(true);
            DisplayMetrics displayMetrics = new DisplayMetrics();
            this.mAttachActivity.getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
            ViewGroup.LayoutParams layoutParams2 = getLayoutParams();
            this.mRawParams = layoutParams2;
            if (layoutParams2 instanceof RelativeLayout.LayoutParams) {
                layoutParams = new RelativeLayout.LayoutParams(displayMetrics.widthPixels, displayMetrics.heightPixels);
            } else if (layoutParams2 instanceof LinearLayout.LayoutParams) {
                layoutParams = new LinearLayout.LayoutParams(displayMetrics.widthPixels, displayMetrics.heightPixels);
            } else if (layoutParams2 instanceof FrameLayout.LayoutParams) {
                layoutParams = new FrameLayout.LayoutParams(displayMetrics.widthPixels, displayMetrics.heightPixels);
            } else {
                new AlertDialog.Builder(getContext()).setMessage("nonsupport parent layout, please do it by yourself").setPositiveButton(WXModalUIModule.OK, new DialogInterface.OnClickListener() {
                    /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass6 */

                    public void onClick(DialogInterface dialogInterface, int i) {
                    }
                }).setCancelable(false).show();
                return;
            }
            setLayoutParams(layoutParams);
            _setFullScreen(true);
            ViewGroup viewGroup = (ViewGroup) this.mAttachActivity.getWindow().getDecorView().findViewById(16908290);
            if ((viewGroup instanceof FrameLayout) && getParent() != viewGroup) {
                ((ViewGroup) getParent()).removeView(this);
                viewGroup.addView(this, new FrameLayout.LayoutParams(-1, -1));
            }
            if (Build.VERSION.SDK_INT >= 28 && QueryNotchTool.hasNotchInScreen(this.mAttachActivity)) {
                int statusHeight = DeviceInfo.getStatusHeight(getContext()) - PdrUtil.pxFromDp(10.0f, getContext().getResources().getDisplayMetrics());
                if (i == 0) {
                    this.mFullscreenTopBar.setPadding(0, statusHeight, 0, 0);
                    return;
                }
                this.mLlBottomBar.setPadding(statusHeight, 0, statusHeight, 0);
                this.mFullscreenTopBar.setPadding(statusHeight, 0, statusHeight, 0);
            }
        }
    }

    public void exitFullScreen() {
        _refreshOrientationEnable();
        VideoPlayerView.IOnPlayerViewChangeListener iOnPlayerViewChangeListener = this.changeListener;
        if (iOnPlayerViewChangeListener != null) {
            iOnPlayerViewChangeListener.onChanged(false);
        }
        if (this.mIsFullscreen) {
            int requestedOrientation = this.mAttachActivity.getRequestedOrientation();
            int i = this.originOrientation;
            if (requestedOrientation != i) {
                this.mAttachActivity.setRequestedOrientation(i);
            }
            setNavigationBar(false);
            setLayoutParams(this.mRawParams);
            if (getParent() != this.mRootLayout) {
                ((ViewGroup) getParent()).removeView(this);
                this.mRootLayout.addView(this, new FrameLayout.LayoutParams(-1, -1));
            }
            _setFullScreen(false);
            if (Build.VERSION.SDK_INT >= 28 && QueryNotchTool.hasNotchInScreen(this.mAttachActivity)) {
                this.mLlBottomBar.setPadding(0, 0, 0, 0);
                this.mFullscreenTopBar.setPadding(0, 0, 0, 0);
            }
        }
    }

    private void setNavigationBar(boolean z) {
        Window window = this.mAttachActivity.getWindow();
        View decorView = window.getDecorView();
        WindowManager.LayoutParams attributes = window.getAttributes();
        if (!z) {
            decorView.setSystemUiVisibility(this.defaultSystemUI);
            if (QueryNotchTool.hasNotchInScreen(this.mAttachActivity) && Build.VERSION.SDK_INT >= 28) {
                window.getAttributes().layoutInDisplayCutoutMode = this.defaultDisplayCutoutMode;
            }
        } else {
            this.defaultSystemUI = decorView.getSystemUiVisibility();
            this.mAttachActivity.getWindow().getDecorView().setSystemUiVisibility(5894);
            if (QueryNotchTool.hasNotchInScreen(this.mAttachActivity) && Build.VERSION.SDK_INT >= 28) {
                this.defaultDisplayCutoutMode = attributes.layoutInDisplayCutoutMode;
                attributes.layoutInDisplayCutoutMode = 1;
            }
        }
        window.setAttributes(attributes);
    }

    public void setScaleType(String str) {
        if (this.mVideoView != null) {
            str.hashCode();
            char c = 65535;
            switch (str.hashCode()) {
                case 3143043:
                    if (str.equals("fill")) {
                        c = 0;
                        break;
                    }
                    break;
                case 94852023:
                    if (str.equals(IApp.ConfigProperty.CONFIG_COVER)) {
                        c = 1;
                        break;
                    }
                    break;
                case 951526612:
                    if (str.equals("contain")) {
                        c = 2;
                        break;
                    }
                    break;
            }
            switch (c) {
                case 0:
                    this.mVideoView.setAspectRatio(3);
                    this.mPlayerThumb.setScaleType(ImageView.ScaleType.FIT_XY);
                    return;
                case 1:
                    this.mVideoView.setAspectRatio(1);
                    this.mPlayerThumb.setScaleType(ImageView.ScaleType.CENTER_CROP);
                    return;
                case 2:
                    this.mVideoView.setAspectRatio(0);
                    this.mPlayerThumb.setScaleType(ImageView.ScaleType.FIT_CENTER);
                    return;
                default:
                    return;
            }
        }
    }

    public void playbackRate(String str) {
        if (this.mVideoView == null) {
            return;
        }
        if (Arrays.binarySearch(this.rates, str) >= 0) {
            this.mVideoView.setSpeed(Float.parseFloat(str));
        } else {
            this.mVideoView.setSpeed(1.0f);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private int _setProgress() {
        IjkVideoView ijkVideoView = this.mVideoView;
        if (ijkVideoView == null || this.mIsSeeking) {
            return 0;
        }
        int max = Math.max(ijkVideoView.getCurrentPosition(), this.mInterruptPosition);
        int duration2 = getDuration();
        if (duration2 > 0) {
            this.mPlayerSeek.setProgress((int) ((((long) max) * 1000) / ((long) duration2)));
        }
        this.mPlayerSeek.setSecondaryProgress(this.mVideoView.getBufferPercentage() * 10);
        this.mTvCurTime.setText(StringUtils.generateTime((long) max));
        this.mTvEndTime.setText(StringUtils.generateTime((long) duration2));
        return max;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void progressCallBack() {
        IjkVideoView ijkVideoView = this.mVideoView;
        if (ijkVideoView != null && !this.mIsSeeking && !this.mIsBufferingStart && this.mOnPlayerChangedListener != null) {
            this.mOnPlayerChangedListener.onChanged("timeupdate", StringUtil.format(this.timeUpdateF, Float.valueOf(((float) Math.max(ijkVideoView.getCurrentPosition(), this.mInterruptPosition)) / 1000.0f), Float.valueOf(((float) getDuration()) / 1000.0f)));
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _setFastForward(String str) {
        if (this.mFlTouchLayout.getVisibility() == 8) {
            this.mFlTouchLayout.setVisibility(0);
        }
        if (this.mTvFastForward.getVisibility() == 8) {
            this.mTvFastForward.setVisibility(0);
        }
        this.mTvFastForward.setText(str);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _hideTouchView() {
        if (this.mFlTouchLayout.getVisibility() == 0) {
            this.mTvFastForward.setVisibility(8);
            this.mTvVolume.setVisibility(8);
            this.mTvBrightness.setVisibility(8);
            this.mFlTouchLayout.setVisibility(8);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _onProgressSlide(float f) {
        String str;
        if (!this.isRtmpUri && this.isProgressGesture) {
            int currentPosition = this.mVideoView.getCurrentPosition();
            long duration2 = (long) getDuration();
            long j = (long) currentPosition;
            long min = ((long) (((float) Math.min(100000L, duration2 / 2)) * f)) + j;
            this.mTargetPosition = min;
            if (min > duration2) {
                this.mTargetPosition = duration2;
            } else if (min <= 0) {
                this.mTargetPosition = 0;
            }
            long j2 = this.mTargetPosition;
            long j3 = (j2 - j) / 1000;
            if (j2 > j) {
                str = StringUtils.generateTime(this.mTargetPosition) + "/" + StringUtils.generateTime(duration2);
            } else {
                str = StringUtils.generateTime(this.mTargetPosition) + "/" + StringUtils.generateTime(duration2);
            }
            _setFastForward(str);
        }
    }

    private void _setVolumeInfo(int i) {
        if (this.mFlTouchLayout.getVisibility() == 8) {
            this.mFlTouchLayout.setVisibility(0);
        }
        if (this.mTvVolume.getVisibility() == 8) {
            this.mTvVolume.setVisibility(0);
        }
        TextView textView = this.mTvVolume;
        textView.setText(((i * 100) / this.mMaxVolume) + "%");
    }

    public void setDuration(int i) {
        if (this.mIsNeverPlay && !isPlaying()) {
            if (i > 0) {
                this.duration = i;
            } else {
                this.duration = -1;
            }
        }
    }

    public int getDuration() {
        if (this.duration <= -1) {
            this.duration = this.mVideoView.getDuration();
        }
        return this.duration;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _onVolumeSlide(float f) {
        if (!this.isMutePlayer) {
            boolean z = this.mIsFullscreen;
            if (!z && !this.isPageGesture) {
                return;
            }
            if (!z || this.isFullScreenPageGesture) {
                if (this.mCurVolume == -1) {
                    int streamVolume = this.mAudioManager.getStreamVolume(3);
                    this.mCurVolume = streamVolume;
                    if (streamVolume < 0) {
                        this.mCurVolume = 0;
                    }
                }
                int i = this.mMaxVolume;
                int i2 = ((int) (f * ((float) i))) + this.mCurVolume;
                if (i2 <= i) {
                    i = i2 < 0 ? 0 : i2;
                }
                this.mAudioManager.setStreamVolume(3, i, 0);
                _setVolumeInfo(i);
            }
        }
    }

    public void setLoadingVisibility(boolean z) {
        this.isLoadingVisibility = z;
    }

    private void setLoadingVisibility(int i) {
        ProgressBar progressBar = this.mLoadingView;
        if (!this.isLoadingVisibility) {
            i = 8;
        }
        progressBar.setVisibility(i);
    }

    public void isUseMediaCodec(boolean z) {
        IjkVideoView ijkVideoView = this.mVideoView;
        if (ijkVideoView != null) {
            ijkVideoView.setmIsUsingMediaCodec(z);
        }
    }

    public void setMutePlayer(boolean z) {
        this.isMutePlayer = z;
        this.mIVMute.setSelected(z);
        this.mVideoView.setvolume(z ? 0.0f : 1.0f);
    }

    public boolean isMutePlayer() {
        return this.isMutePlayer;
    }

    private void _setVolume(boolean z) {
        int i;
        if (!this.isMutePlayer) {
            int streamVolume = this.mAudioManager.getStreamVolume(3);
            if (z) {
                i = streamVolume + (this.mMaxVolume / 15);
            } else {
                i = streamVolume - (this.mMaxVolume / 15);
            }
            int i2 = this.mMaxVolume;
            if (i > i2) {
                i = i2;
            } else if (i < 0) {
                i = 0;
            }
            this.mAudioManager.setStreamVolume(3, i, 0);
            _setVolumeInfo(i);
            this.mHandler.removeCallbacks(this.mHideTouchViewRunnable);
            this.mHandler.postDelayed(this.mHideTouchViewRunnable, 1000);
        }
    }

    private void _setBrightnessInfo(float f) {
        if (this.mFlTouchLayout.getVisibility() == 8) {
            this.mFlTouchLayout.setVisibility(0);
        }
        if (this.mTvBrightness.getVisibility() == 8) {
            this.mTvBrightness.setVisibility(0);
        }
        TextView textView = this.mTvBrightness;
        textView.setText(Math.ceil((double) (f * 100.0f)) + "%");
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _onBrightnessSlide(float f) {
        boolean z = this.mIsFullscreen;
        if (!z && !this.isPageGesture) {
            return;
        }
        if (!z || this.isFullScreenPageGesture) {
            if (this.mCurBrightness < 0.0f) {
                float f2 = this.mAttachActivity.getWindow().getAttributes().screenBrightness;
                this.mCurBrightness = f2;
                if (f2 < 0.0f) {
                    this.mCurBrightness = 0.5f;
                } else if (f2 < 0.01f) {
                    this.mCurBrightness = 0.01f;
                }
            }
            WindowManager.LayoutParams attributes = this.mAttachActivity.getWindow().getAttributes();
            attributes.screenBrightness = this.mCurBrightness + f;
            if (attributes.screenBrightness > 1.0f) {
                attributes.screenBrightness = 1.0f;
            } else if (attributes.screenBrightness < 0.01f) {
                attributes.screenBrightness = 0.01f;
            }
            _setBrightnessInfo(attributes.screenBrightness);
            this.mAttachActivity.getWindow().setAttributes(attributes);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _endGesture() {
        long j = this.mTargetPosition;
        if (j >= 0 && j != ((long) this.mVideoView.getCurrentPosition()) && getDuration() > 0) {
            seekTo((int) this.mTargetPosition);
            this.mPlayerSeek.setProgress((int) ((this.mTargetPosition * 1000) / ((long) getDuration())));
            this.mTargetPosition = -1;
        }
        _hideTouchView();
        _refreshHideRunnable();
        this.mCurVolume = -1;
        this.mCurBrightness = -1.0f;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void _switchStatus(int i) {
        Log.i("IjkPlayerView", "status " + i);
        if (i == 3) {
            this.mIsRenderingStart = true;
        } else if (i != 336) {
            if (i != 701) {
                if (i != 702) {
                    switch (i) {
                        case 331:
                            this.mInterruptPosition = Math.max(this.mVideoView.getInterruptPosition(), this.mInterruptPosition);
                            pause();
                            if (this.mVideoView.getDuration() != -1 || this.mIsReady) {
                                setLoadingVisibility(0);
                                this.mHandler.sendEmptyMessage(MSG_TRY_RELOAD);
                                return;
                            }
                            setLoadingVisibility(8);
                            this.mPlayerThumb.setVisibility(8);
                            this.mIvPlayCircle.setVisibility(8);
                            return;
                        case 332:
                            break;
                        case 333:
                            this.mIsReady = true;
                            return;
                        case 334:
                            this.mHandler.removeMessages(MSG_TRY_RELOAD);
                            if (this.mIsRenderingStart && !this.mIsBufferingStart && this.mVideoView.getCurrentPosition() > 0) {
                                _resumeDanmaku();
                                return;
                            }
                            return;
                        default:
                            return;
                    }
                }
            }
            this.mIsBufferingStart = true;
            _pauseDanmaku();
            if (!this.mIsNeverPlay) {
                setLoadingVisibility(0);
            }
            this.mHandler.removeMessages(MSG_TRY_RELOAD);
            return;
        } else {
            pause();
            if (this.mVideoView.getDuration() == -1 || this.mVideoView.getInterruptPosition() + 1000 < this.mVideoView.getDuration()) {
                this.mInterruptPosition = Math.max(this.mVideoView.getInterruptPosition(), this.mInterruptPosition);
                OnPlayerChangedListener onPlayerChangedListener = this.mOnPlayerChangedListener;
                if (onPlayerChangedListener != null) {
                    onPlayerChangedListener.onChanged("error", DOMException.MSG_NETWORK_ERROR);
                    return;
                }
                return;
            }
            this.mIsPlayComplete = true;
            IMediaPlayer.OnCompletionListener onCompletionListener = this.mCompletionListener;
            if (onCompletionListener != null) {
                onCompletionListener.onCompletion(this.mVideoView.getMediaPlayer());
                return;
            }
            return;
        }
        this.mIsBufferingStart = false;
        setLoadingVisibility(8);
        this.mPlayerThumb.setVisibility(8);
        if (this.mLlBottomBar.getVisibility() == 0 && !this.mIsShowBar) {
            this.mIsShowBar = true;
        }
        this.mHandler.removeMessages(MSG_UPDATE_SEEK);
        this.mHandler.sendEmptyMessage(MSG_UPDATE_SEEK);
        if (this.mVideoView.isPlaying() && this.mIsNetConnected) {
            this.mInterruptPosition = 0;
            _resumeDanmaku();
            if (!this.mIvPlay.isSelected()) {
                this.mVideoView.start();
                this.mIvPlay.setSelected(true);
                this.mIvPlayCenter.setSelected(true);
            }
        }
    }

    public void setOnPreparedListener(IMediaPlayer.OnPreparedListener onPreparedListener) {
        this.mVideoView.setOnPreparedListener(onPreparedListener);
    }

    public void setOnCompletionListener(IMediaPlayer.OnCompletionListener onCompletionListener) {
        this.mCompletionListener = onCompletionListener;
    }

    public void setOnErrorListener(IMediaPlayer.OnErrorListener onErrorListener) {
        this.mVideoView.setOnErrorListener(onErrorListener);
    }

    public void setOnInfoListener(IMediaPlayer.OnInfoListener onInfoListener) {
        this.mOutsideInfoListener = onInfoListener;
    }

    public IjkPlayerView setDanmakuListener(OnDanmakuListener onDanmakuListener) {
        this.mDanmakuListener = onDanmakuListener;
        return this;
    }

    public void setOnPlayerChangedListener(OnPlayerChangedListener onPlayerChangedListener) {
        this.mOnPlayerChangedListener = onPlayerChangedListener;
    }

    public void setOnBufferingUpdateListener(IMediaPlayer.OnBufferingUpdateListener onBufferingUpdateListener2) {
        this.bufferingUpdateListener = onBufferingUpdateListener2;
    }

    public int getCurPosition() {
        return this.mVideoView.getCurrentPosition();
    }

    public void setDirection(int i) {
        this.mOrientation = i;
    }

    public void setmDanmuList(String str) {
        this.mDanmuList = str;
    }

    private void _initDanmaku() {
        this.mDanmakuView = (IDanmakuView) findViewById(VideoR.VIDEO_IJK_ID_SV_DANMAKU);
        this.mIvDanmakuControl.setOnClickListener(this);
        this.mMoreOptionsWidth = getResources().getDimensionPixelOffset(VideoR.VIDEO_IJK_DIMEN_DANMAKU_INPUT_BTN_SIZE) * 12;
    }

    private void _loadDanmaku() {
        if (this.mIsEnableDanmaku) {
            this.mDanmakuContext = DanmakuContext.create();
            if (this.mDanmakuParser == null) {
                this.mDanmakuParser = new BaseDanmakuParser() {
                    /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass12 */

                    /* access modifiers changed from: protected */
                    @Override // master.flame.danmaku.danmaku.parser.BaseDanmakuParser
                    public Danmakus parse() {
                        return new Danmakus();
                    }
                };
            }
            try {
                setDanmakuSource(new ByteArrayInputStream(this.mDanmuList.getBytes("utf-8")));
                this.mDanmakuView.setCallback(new DrawHandler.Callback() {
                    /* class io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView.AnonymousClass13 */

                    @Override // master.flame.danmaku.controller.DrawHandler.Callback
                    public void danmakuShown(BaseDanmaku baseDanmaku) {
                    }

                    @Override // master.flame.danmaku.controller.DrawHandler.Callback
                    public void drawingFinished() {
                    }

                    @Override // master.flame.danmaku.controller.DrawHandler.Callback
                    public void updateTimer(DanmakuTimer danmakuTimer) {
                    }

                    @Override // master.flame.danmaku.controller.DrawHandler.Callback
                    public void prepared() {
                        if (IjkPlayerView.this.mVideoView.isPlaying() && !IjkPlayerView.this.mIsBufferingStart) {
                            IjkPlayerView.this.mDanmakuView.start();
                        }
                    }
                });
                this.mDanmakuView.enableDanmakuDrawingCache(true);
                this.mDanmakuView.prepare(this.mDanmakuParser, this.mDanmakuContext);
            } catch (UnsupportedEncodingException unused) {
            }
        }
    }

    public IjkPlayerView enableDanmaku() {
        this.mIsEnableDanmaku = true;
        _initDanmaku();
        return this;
    }

    public void enableDanmaku(boolean z) {
        this.mIsEnableDanmaku = z;
        if (z) {
            _initDanmaku();
        } else {
            this.mIvDanmakuControl.setVisibility(8);
        }
    }

    public void enableDanmuBtn(boolean z) {
        if (!this.mIsEnableDanmaku) {
            this.mIvDanmakuControl.setVisibility(8);
        } else if (z) {
            this.mIvDanmakuControl.setVisibility(0);
        } else {
            this.mIvDanmakuControl.setVisibility(8);
        }
    }

    public IjkPlayerView setDanmakuSource(InputStream inputStream) {
        if (inputStream == null) {
            return this;
        }
        if (this.mIsEnableDanmaku) {
            if (this.mDanmakuLoader == null) {
                this.mDanmakuLoader = DanmakuLoaderFactory.create(DanmakuLoaderFactory.TAG_ACFUN);
            }
            try {
                this.mDanmakuLoader.load(inputStream);
            } catch (IllegalDataException e) {
                e.printStackTrace();
            }
            IDataSource<?> dataSource = this.mDanmakuLoader.getDataSource();
            StandardDanmaKuParser standardDanmaKuParser = new StandardDanmaKuParser();
            this.mDanmakuParser = standardDanmaKuParser;
            standardDanmaKuParser.load(dataSource);
            return this;
        }
        throw new RuntimeException("Danmaku is disable, use enableDanmaku() first");
    }

    public IjkPlayerView setDanmakuSource(String str) {
        if (TextUtils.isEmpty(str)) {
            return this;
        }
        if (this.mIsEnableDanmaku) {
            if (this.mDanmakuLoader == null) {
                this.mDanmakuLoader = DanmakuLoaderFactory.create(DanmakuLoaderFactory.TAG_BILI);
            }
            try {
                this.mDanmakuLoader.load(str);
            } catch (IllegalDataException e) {
                e.printStackTrace();
            }
            IDataSource<?> dataSource = this.mDanmakuLoader.getDataSource();
            BiliDanmukuParser biliDanmukuParser = new BiliDanmukuParser();
            this.mDanmakuParser = biliDanmukuParser;
            biliDanmukuParser.load(dataSource);
            return this;
        }
        throw new RuntimeException("Danmaku is disable, use enableDanmaku() first");
    }

    public IjkPlayerView setDanmakuCustomParser(BaseDanmakuParser baseDanmakuParser, ILoader iLoader, BaseDanmakuConverter baseDanmakuConverter) {
        this.mDanmakuParser = baseDanmakuParser;
        this.mDanmakuLoader = iLoader;
        this.mDanmakuConverter = baseDanmakuConverter;
        return this;
    }

    public IjkPlayerView showOrHideDanmaku(boolean z) {
        if (z) {
            this.mIvDanmakuControl.setSelected(false);
            this.mDanmakuView.show();
        } else {
            this.mIvDanmakuControl.setSelected(true);
            this.mDanmakuView.hide();
        }
        return this;
    }

    public void sendDanmaku(JSONObject jSONObject, boolean z) {
        BaseDanmaku createDanmaku;
        if (this.mIsEnableDanmaku && !TextUtils.isEmpty(jSONObject.optString("text")) && this.mDanmakuView.isPrepared() && (createDanmaku = this.mDanmakuContext.mDanmakuFactory.createDanmaku(this.mDanmakuType)) != null && this.mDanmakuView != null) {
            if (this.mDanmakuTextSize == -1.0f) {
                this.mDanmakuTextSize = (this.mDanmakuParser.getDisplayer().getDensity() - 0.6f) * 25.0f;
            }
            createDanmaku.text = jSONObject.optString("text", "....");
            createDanmaku.padding = 5;
            createDanmaku.isLive = z;
            createDanmaku.priority = 0;
            createDanmaku.textSize = this.mDanmakuTextSize;
            createDanmaku.textColor = Color.parseColor(jSONObject.optString("color", "#ffffff"));
            createDanmaku.setTime(this.mDanmakuView.getCurrentTime() + 500);
            this.mDanmakuView.addDanmaku(createDanmaku);
            OnDanmakuListener onDanmakuListener = this.mDanmakuListener;
            if (onDanmakuListener != null) {
                BaseDanmakuConverter baseDanmakuConverter = this.mDanmakuConverter;
                if (baseDanmakuConverter != null) {
                    onDanmakuListener.onDataObtain(baseDanmakuConverter.convertDanmaku(createDanmaku));
                } else {
                    onDanmakuListener.onDataObtain(createDanmaku);
                }
            }
        }
    }

    public void editVideo() {
        if (this.mVideoView.isPlaying()) {
            pause();
            this.mVideoStatus = INTERRUPT_WHEN_PLAY;
        } else {
            this.mVideoStatus = INTERRUPT_WHEN_PAUSE;
        }
        _hideAllView(false);
    }

    public boolean recoverFromEditVideo() {
        if (this.mVideoStatus == NORMAL_STATUS) {
            return false;
        }
        if (this.mIsFullscreen) {
            _recoverScreen();
        }
        if (this.mVideoStatus == INTERRUPT_WHEN_PLAY) {
            start();
        }
        this.mVideoStatus = NORMAL_STATUS;
        return true;
    }

    public void clearDanma() {
        IDanmakuView iDanmakuView = this.mDanmakuView;
        if (iDanmakuView != null && iDanmakuView.isPrepared()) {
            this.mDanmakuView.clearDanmakusOnScreen();
        }
    }

    private void _resumeDanmaku() {
        IDanmakuView iDanmakuView = this.mDanmakuView;
        if (iDanmakuView != null && iDanmakuView.isPrepared() && this.mDanmakuView.isPaused()) {
            long j = this.mDanmakuTargetPosition;
            if (j != -1) {
                this.mDanmakuView.seekTo(Long.valueOf(j));
                this.mDanmakuTargetPosition = -1;
                return;
            }
            this.mDanmakuView.resume();
        }
    }

    private void _pauseDanmaku() {
        IDanmakuView iDanmakuView = this.mDanmakuView;
        if (iDanmakuView != null && iDanmakuView.isPrepared()) {
            this.mDanmakuView.pause();
        }
    }

    private void _toggleDanmakuShow() {
        if (this.mIvDanmakuControl.isSelected()) {
            showOrHideDanmaku(true);
        } else {
            showOrHideDanmaku(false);
        }
    }

    /* access modifiers changed from: protected */
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        this.mOnPlayerChangedListener.onChanged("onConfigurationChanged", null);
    }

    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (isFullscreen() || !this.mIsForbidTouch || this.mIvPlayCircle.getVisibility() == 0) {
            return super.onInterceptTouchEvent(motionEvent);
        }
        return true;
    }

    private void _initReceiver() {
        this.mScreenReceiver = new ScreenBroadcastReceiver();
        this.mNetReceiver = new NetBroadcastReceiver();
        this.mAttachActivity.registerReceiver(this.mScreenReceiver, new IntentFilter("android.intent.action.SCREEN_OFF"));
        this.mAttachActivity.registerReceiver(this.mNetReceiver, new IntentFilter(NetCheckReceiver.netACTION));
    }

    /* access modifiers changed from: private */
    public class ScreenBroadcastReceiver extends BroadcastReceiver {
        private ScreenBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if ("android.intent.action.SCREEN_OFF".equals(intent.getAction())) {
                IjkPlayerView.this.mIsScreenLocked = true;
            }
        }
    }

    public class NetBroadcastReceiver extends BroadcastReceiver {
        public NetBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            if (NetCheckReceiver.netACTION.equals(intent.getAction())) {
                IjkPlayerView ijkPlayerView = IjkPlayerView.this;
                ijkPlayerView.mIsNetConnected = NetWorkUtils.isNetworkAvailable(ijkPlayerView.mAttachActivity);
            }
        }
    }
}
