package io.dcloud.media.weex.weex_video.ijkplayer.media;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.MediaController;
import java.util.ArrayList;
import java.util.Iterator;

public class AndroidMediaController extends MediaController implements IMediaController {
    private ArrayList<View> mShowOnceArray = new ArrayList<>();

    private void initView(Context context) {
    }

    public AndroidMediaController(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        initView(context);
    }

    public AndroidMediaController(Context context, boolean z) {
        super(context, z);
        initView(context);
    }

    public AndroidMediaController(Context context) {
        super(context);
        initView(context);
    }

    @Override // io.dcloud.media.weex.weex_video.ijkplayer.media.IMediaController
    public void show() {
        super.show();
    }

    @Override // io.dcloud.media.weex.weex_video.ijkplayer.media.IMediaController
    public void hide() {
        super.hide();
        Iterator<View> it = this.mShowOnceArray.iterator();
        while (it.hasNext()) {
            it.next().setVisibility(8);
        }
        this.mShowOnceArray.clear();
    }

    @Override // io.dcloud.media.weex.weex_video.ijkplayer.media.IMediaController
    public void showOnce(View view) {
        this.mShowOnceArray.add(view);
        view.setVisibility(0);
        show();
    }
}
