package io.dcloud.media.weex.weex_video.ijkplayer.danmaku;

import android.graphics.Color;
import com.taobao.weex.common.Constants;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.util.DanmakuUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class StandardDanmaKuParser extends AcFunDanmakuParser {
    private int count = 0;

    /* access modifiers changed from: protected */
    @Override // io.dcloud.media.weex.weex_video.ijkplayer.danmaku.AcFunDanmakuParser
    public Danmakus doParse(JSONArray jSONArray) {
        Danmakus danmakus = new Danmakus();
        if (jSONArray == null) {
            return danmakus;
        }
        this.count = jSONArray.length();
        for (int i = 0; i < this.count; i++) {
            try {
                JSONObject jSONObject = jSONArray.getJSONObject(i);
                if (jSONObject != null) {
                    danmakus = _parse(jSONObject, danmakus);
                }
            } catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return danmakus;
    }

    /* access modifiers changed from: protected */
    @Override // io.dcloud.media.weex.weex_video.ijkplayer.danmaku.AcFunDanmakuParser
    public Danmakus _parse(JSONObject jSONObject, Danmakus danmakus) {
        if (danmakus == null) {
            danmakus = new Danmakus();
        }
        if (!(jSONObject == null || jSONObject.length() == 0)) {
            try {
                String optString = jSONObject.optString("text", "....");
                String string = jSONObject.getString("color");
                BaseDanmaku createDanmaku = this.mContext.mDanmakuFactory.createDanmaku(1, this.mContext);
                if (createDanmaku != null) {
                    createDanmaku.setTime(jSONObject.optLong(Constants.Value.TIME, 0) * 1000);
                    createDanmaku.textSize = (this.mDispDensity - 0.6f) * 25.0f;
                    int parseColor = Color.parseColor(string);
                    createDanmaku.textColor = parseColor;
                    int i = -16777216;
                    if (parseColor <= -16777216) {
                        i = -1;
                    }
                    createDanmaku.textShadowColor = i;
                    DanmakuUtils.fillText(createDanmaku, optString);
                    createDanmaku.setTimer(this.mTimer);
                    danmakus.addItem(createDanmaku);
                }
            } catch (JSONException unused) {
            }
        }
        return danmakus;
    }
}
