package io.dcloud.media.weex.weex_video.ijkplayer.danmaku;

import com.taobao.weex.ui.component.WXComponent;
import io.dcloud.feature.ui.nativeui.c;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.parser.android.JSONSource;
import master.flame.danmaku.danmaku.util.DanmakuUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class AcFunDanmakuParser extends BaseDanmakuParser {
    @Override // master.flame.danmaku.danmaku.parser.BaseDanmakuParser
    public Danmakus parse() {
        if (this.mDataSource == null || !(this.mDataSource instanceof JSONSource)) {
            return new Danmakus();
        }
        return doParse(((JSONSource) this.mDataSource).data());
    }

    /* access modifiers changed from: protected */
    public Danmakus doParse(JSONArray jSONArray) {
        Danmakus danmakus = new Danmakus();
        if (!(jSONArray == null || jSONArray.length() == 0)) {
            for (int i = 0; i < jSONArray.length(); i++) {
                try {
                    JSONArray jSONArray2 = jSONArray.getJSONArray(i);
                    if (jSONArray2.length() > 0) {
                        for (int i2 = 0; i2 < jSONArray2.length(); i2++) {
                            JSONObject jSONObject = jSONArray2.getJSONObject(i2);
                            if (jSONObject != null) {
                                danmakus = _parse(jSONObject, danmakus);
                            }
                        }
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
        return danmakus;
    }

    /* access modifiers changed from: protected */
    public Danmakus _parse(JSONObject jSONObject, Danmakus danmakus) {
        int parseInt;
        if (danmakus == null) {
            danmakus = new Danmakus();
        }
        if (!(jSONObject == null || jSONObject.length() == 0)) {
            try {
                String[] split = jSONObject.getString(c.a).split(",");
                if (split.length > 0 && (parseInt = Integer.parseInt(split[2])) != 7) {
                    long parseFloat = (long) (Float.parseFloat(split[0]) * 1000.0f);
                    int i = -16777216;
                    int parseInt2 = Integer.parseInt(split[1]) | -16777216;
                    float parseFloat2 = Float.parseFloat(split[3]);
                    BaseDanmaku createDanmaku = this.mContext.mDanmakuFactory.createDanmaku(parseInt, this.mContext);
                    if (createDanmaku != null) {
                        createDanmaku.setTime(parseFloat);
                        createDanmaku.textSize = parseFloat2 * (this.mDispDensity - 0.6f);
                        createDanmaku.textColor = parseInt2;
                        if (parseInt2 <= -16777216) {
                            i = -1;
                        }
                        createDanmaku.textShadowColor = i;
                        DanmakuUtils.fillText(createDanmaku, jSONObject.optString(WXComponent.PROP_FS_MATCH_PARENT, "...."));
                        createDanmaku.setTimer(this.mTimer);
                        danmakus.addItem(createDanmaku);
                    }
                }
            } catch (NumberFormatException | JSONException unused) {
            }
        }
        return danmakus;
    }
}
