package io.dcloud.media.video.ijkplayer.utils;

import io.dcloud.common.util.StringUtil;
import java.text.SimpleDateFormat;
import java.util.Date;
import tv.danmaku.ijk.media.player.IjkMediaMeta;

public final class StringUtils {
    private StringUtils() {
        throw new AssertionError();
    }

    public static String generateTime(long j) {
        int i = (int) (j / 1000);
        int i2 = i % 60;
        int i3 = i / 60;
        Object[] objArr = new Object[2];
        if (i3 > 99) {
            objArr[0] = Integer.valueOf(i3);
            objArr[1] = Integer.valueOf(i2);
            return StringUtil.format("%d:%02d", objArr);
        }
        objArr[0] = Integer.valueOf(i3);
        objArr[1] = Integer.valueOf(i2);
        return StringUtil.format("%02d:%02d", objArr);
    }

    public static String getFormatSize(int i) {
        long j = (long) i;
        if (j >= 0 && j < IjkMediaMeta.AV_CH_SIDE_RIGHT) {
            return j + "Kb/s";
        } else if (j >= IjkMediaMeta.AV_CH_SIDE_RIGHT && j < 1048576) {
            return Long.toString(j / IjkMediaMeta.AV_CH_SIDE_RIGHT) + "KB/s";
        } else if (j < 1048576 || j >= IjkMediaMeta.AV_CH_STEREO_RIGHT) {
            return "";
        } else {
            return Long.toString(j / 1048576) + "MB/s";
        }
    }

    public static String getCurFormatTime() {
        return new SimpleDateFormat("HH:mm").format(new Date(System.currentTimeMillis()));
    }
}
