package io.dcloud.media.video.ijkplayer.utils;

import android.content.Context;
import android.content.res.Resources;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.performance.WXInstanceApm;

public final class NavUtils {
    private NavUtils() {
        throw new RuntimeException("NavUtils cannot be initialized!");
    }

    public static int getNavigationBarHeight(Context context) {
        if (!checkDeviceHasNavigationBar(context)) {
            return 0;
        }
        Resources resources = context.getResources();
        return resources.getDimensionPixelSize(resources.getIdentifier("navigation_bar_height", "dimen", WXEnvironment.OS));
    }

    public static boolean checkDeviceHasNavigationBar(Context context) {
        Resources resources = context.getResources();
        int identifier = resources.getIdentifier("config_showNavigationBar", "bool", WXEnvironment.OS);
        boolean z = false;
        boolean z2 = identifier > 0 ? resources.getBoolean(identifier) : false;
        try {
            Class<?> cls = Class.forName("android.os.SystemProperties");
            String str = (String) cls.getMethod("get", String.class).invoke(cls, "qemu.hw.mainkeys");
            if (!"1".equals(str)) {
                z = WXInstanceApm.VALUE_ERROR_CODE_DEFAULT.equals(str) ? true : z2;
            }
            return z;
        } catch (Exception unused) {
            return z2;
        }
    }
}
