package io.dcloud.media.video.ijkplayer.utils;

import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.animation.ValueAnimator;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AccelerateInterpolator;

public final class AnimHelper {
    private AnimHelper() {
        throw new AssertionError();
    }

    public static void doSlideRightIn(View view, int i, int i2, int i3) {
        ObjectAnimator ofFloat = ObjectAnimator.ofFloat(view, "translationX", (float) i, (float) i2);
        ObjectAnimator ofFloat2 = ObjectAnimator.ofFloat(view, "alpha", 0.0f, 1.0f);
        AnimatorSet animatorSet = new AnimatorSet();
        animatorSet.setDuration((long) i3);
        animatorSet.playTogether(ofFloat, ofFloat2);
        animatorSet.start();
    }

    public static void doClipViewWidth(final View view, int i, int i2, int i3) {
        ValueAnimator duration = ValueAnimator.ofInt(i, i2).setDuration((long) i3);
        duration.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            /* class io.dcloud.media.video.ijkplayer.utils.AnimHelper.AnonymousClass1 */

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int intValue = ((Integer) valueAnimator.getAnimatedValue()).intValue();
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                layoutParams.width = intValue;
                view.setLayoutParams(layoutParams);
            }
        });
        duration.setInterpolator(new AccelerateInterpolator());
        duration.start();
    }

    public static void doClipViewHeight(final View view, int i, int i2, int i3) {
        ValueAnimator duration = ValueAnimator.ofInt(i, i2).setDuration((long) i3);
        duration.addUpdateListener(new ValueAnimator.AnimatorUpdateListener() {
            /* class io.dcloud.media.video.ijkplayer.utils.AnimHelper.AnonymousClass2 */

            public void onAnimationUpdate(ValueAnimator valueAnimator) {
                int intValue = ((Integer) valueAnimator.getAnimatedValue()).intValue();
                ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
                layoutParams.height = intValue;
                view.setLayoutParams(layoutParams);
            }
        });
        duration.setInterpolator(new AccelerateInterpolator());
        duration.start();
    }
}
