package io.dcloud.media.video.ijkplayer.danmaku;

import android.text.TextUtils;
import com.facebook.common.callercontext.ContextChain;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.util.JSUtil;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Locale;
import master.flame.danmaku.danmaku.model.AlphaValue;
import master.flame.danmaku.danmaku.model.BaseDanmaku;
import master.flame.danmaku.danmaku.model.Duration;
import master.flame.danmaku.danmaku.model.IDisplayer;
import master.flame.danmaku.danmaku.model.android.DanmakuFactory;
import master.flame.danmaku.danmaku.model.android.Danmakus;
import master.flame.danmaku.danmaku.parser.BaseDanmakuParser;
import master.flame.danmaku.danmaku.parser.android.AndroidFileSource;
import master.flame.danmaku.danmaku.util.DanmakuUtils;
import org.json.JSONArray;
import org.json.JSONException;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.XMLReaderFactory;

public class BiliDanmukuParser extends BaseDanmakuParser {
    private float mDispScaleX;
    private float mDispScaleY;

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private boolean isPercentageNumber(float f) {
        return f >= 0.0f && f <= 1.0f;
    }

    static {
        System.setProperty("org.xml.sax.driver", "org.xmlpull.v1.sax2.Driver");
    }

    @Override // master.flame.danmaku.danmaku.parser.BaseDanmakuParser
    public Danmakus parse() {
        if (this.mDataSource == null) {
            return null;
        }
        AndroidFileSource androidFileSource = (AndroidFileSource) this.mDataSource;
        try {
            XMLReader createXMLReader = XMLReaderFactory.createXMLReader();
            XmlContentHandler xmlContentHandler = new XmlContentHandler();
            createXMLReader.setContentHandler(xmlContentHandler);
            createXMLReader.parse(new InputSource(androidFileSource.data()));
            return xmlContentHandler.getResult();
        } catch (SAXException e) {
            e.printStackTrace();
            return null;
        } catch (IOException e2) {
            e2.printStackTrace();
            return null;
        }
    }

    public class XmlContentHandler extends DefaultHandler {
        private static final String TRUE_STRING = "true";
        public boolean completed = false;
        public int index = 0;
        public BaseDanmaku item = null;
        public Danmakus result = null;

        public XmlContentHandler() {
        }

        public Danmakus getResult() {
            return this.result;
        }

        @Override // org.xml.sax.helpers.DefaultHandler, org.xml.sax.ContentHandler
        public void startDocument() throws SAXException {
            this.result = new Danmakus();
        }

        @Override // org.xml.sax.helpers.DefaultHandler, org.xml.sax.ContentHandler
        public void endDocument() throws SAXException {
            this.completed = true;
        }

        @Override // org.xml.sax.helpers.DefaultHandler, org.xml.sax.ContentHandler
        public void startElement(String str, String str2, String str3, Attributes attributes) throws SAXException {
            if (str2.length() == 0) {
                str2 = str3;
            }
            if (str2.toLowerCase(Locale.getDefault()).trim().equals("d")) {
                String[] split = attributes.getValue(ContextChain.TAG_PRODUCT).split(",");
                if (split.length > 0) {
                    long parseFloat = (long) (Float.parseFloat(split[0]) * 1000.0f);
                    int parseInt = Integer.parseInt(split[1]);
                    float parseFloat2 = Float.parseFloat(split[2]);
                    int parseLong = (int) ((-16777216 | Long.parseLong(split[3])) & -1);
                    BaseDanmaku createDanmaku = BiliDanmukuParser.this.mContext.mDanmakuFactory.createDanmaku(parseInt, BiliDanmukuParser.this.mContext);
                    this.item = createDanmaku;
                    if (createDanmaku != null) {
                        createDanmaku.setTime(parseFloat);
                        this.item.textSize = parseFloat2 * (BiliDanmukuParser.this.mDispDensity - 0.6f);
                        this.item.textColor = parseLong;
                        BaseDanmaku baseDanmaku = this.item;
                        int i = -16777216;
                        if (parseLong <= -16777216) {
                            i = -1;
                        }
                        baseDanmaku.textShadowColor = i;
                    }
                }
            }
        }

        @Override // org.xml.sax.helpers.DefaultHandler, org.xml.sax.ContentHandler
        public void endElement(String str, String str2, String str3) throws SAXException {
            BaseDanmaku baseDanmaku = this.item;
            if (baseDanmaku != null) {
                if (baseDanmaku.duration != null) {
                    if (str2.length() == 0) {
                        str2 = str3;
                    }
                    if (str2.equalsIgnoreCase("d")) {
                        this.item.setTimer(BiliDanmukuParser.this.mTimer);
                        this.result.addItem(this.item);
                    }
                }
                this.item = null;
            }
        }

        /* JADX WARNING: Removed duplicated region for block: B:21:0x0069  */
        /* JADX WARNING: Removed duplicated region for block: B:45:0x0128  */
        /* JADX WARNING: Removed duplicated region for block: B:48:0x0136  */
        /* JADX WARNING: Removed duplicated region for block: B:51:0x0142  */
        /* JADX WARNING: Removed duplicated region for block: B:54:0x014e  */
        @Override // org.xml.sax.helpers.DefaultHandler, org.xml.sax.ContentHandler
        public void characters(char[] cArr, int i, int i2) {
            String[] strArr;
            float f;
            float f2;
            long j;
            long j2;
            float f3;
            float f4;
            float f5;
            String[] split;
            long j3;
            JSONException e;
            BaseDanmaku baseDanmaku = this.item;
            if (baseDanmaku != null) {
                DanmakuUtils.fillText(baseDanmaku, decodeXmlString(new String(cArr, i, i2)));
                BaseDanmaku baseDanmaku2 = this.item;
                int i3 = this.index;
                this.index = i3 + 1;
                baseDanmaku2.index = i3;
                String trim = String.valueOf(this.item.text).trim();
                if (this.item.getType() == 7 && trim.startsWith(Operators.ARRAY_START_STR) && trim.endsWith(Operators.ARRAY_END_STR)) {
                    try {
                        JSONArray jSONArray = new JSONArray(trim);
                        int length = jSONArray.length();
                        strArr = new String[length];
                        for (int i4 = 0; i4 < length; i4++) {
                            try {
                                strArr[i4] = jSONArray.getString(i4);
                            } catch (JSONException e2) {
                                e = e2;
                                e.printStackTrace();
                                if (strArr != null) {
                                }
                                this.item = null;
                                return;
                            }
                        }
                    } catch (JSONException e3) {
                        e = e3;
                        strArr = null;
                        e.printStackTrace();
                        if (strArr != null) {
                        }
                        this.item = null;
                        return;
                    }
                    if (strArr != null || strArr.length < 5) {
                        this.item = null;
                        return;
                    }
                    this.item.text = strArr[4];
                    float parseFloat = Float.parseFloat(strArr[0]);
                    float parseFloat2 = Float.parseFloat(strArr[1]);
                    String[] split2 = strArr[2].split(Operators.SUB);
                    int parseFloat3 = (int) (((float) AlphaValue.MAX) * Float.parseFloat(split2[0]));
                    int parseFloat4 = split2.length > 1 ? (int) (((float) AlphaValue.MAX) * Float.parseFloat(split2[1])) : parseFloat3;
                    long parseFloat5 = (long) (Float.parseFloat(strArr[3]) * 1000.0f);
                    if (strArr.length >= 7) {
                        float parseFloat6 = Float.parseFloat(strArr[5]);
                        f2 = Float.parseFloat(strArr[6]);
                        f = parseFloat6;
                    } else {
                        f2 = 0.0f;
                        f = 0.0f;
                    }
                    if (strArr.length >= 11) {
                        f5 = Float.parseFloat(strArr[7]);
                        f4 = Float.parseFloat(strArr[8]);
                        if (!"".equals(strArr[9])) {
                            f3 = f2;
                            j3 = (long) Integer.parseInt(strArr[9]);
                        } else {
                            f3 = f2;
                            j3 = parseFloat5;
                        }
                        if (!"".equals(strArr[10])) {
                            j = (long) Float.parseFloat(strArr[10]);
                            j2 = j3;
                            f5 = f5;
                            if (BiliDanmukuParser.this.isPercentageNumber(parseFloat)) {
                                parseFloat *= 682.0f;
                            }
                            if (BiliDanmukuParser.this.isPercentageNumber(parseFloat2)) {
                                parseFloat2 *= 438.0f;
                            }
                            if (BiliDanmukuParser.this.isPercentageNumber(f5)) {
                                f5 *= 682.0f;
                            }
                            if (BiliDanmukuParser.this.isPercentageNumber(f4)) {
                                f4 *= 438.0f;
                            }
                            this.item.duration = new Duration(parseFloat5);
                            this.item.rotationZ = f;
                            this.item.rotationY = f3;
                            BiliDanmukuParser.this.mContext.mDanmakuFactory.fillTranslationData(this.item, parseFloat, parseFloat2, f5, f4, j2, j, BiliDanmukuParser.this.mDispScaleX, BiliDanmukuParser.this.mDispScaleY);
                            BiliDanmukuParser.this.mContext.mDanmakuFactory.fillAlphaData(this.item, parseFloat3, parseFloat4, parseFloat5);
                            if (strArr.length >= 12 && !TextUtils.isEmpty(strArr[11]) && "true".equals(strArr[11])) {
                                this.item.textShadowColor = 0;
                            }
                            int length2 = strArr.length;
                            int length3 = strArr.length;
                            if (strArr.length >= 15 && !"".equals(strArr[14]) && (split = strArr[14].substring(1).split("L")) != null && split.length > 0) {
                                int length4 = split.length;
                                int[] iArr = new int[2];
                                iArr[1] = 2;
                                iArr[0] = length4;
                                float[][] fArr = (float[][]) Array.newInstance(float.class, iArr);
                                for (int i5 = 0; i5 < split.length; i5++) {
                                    String[] split3 = split[i5].split(",");
                                    fArr[i5][0] = Float.parseFloat(split3[0]);
                                    fArr[i5][1] = Float.parseFloat(split3[1]);
                                }
                                DanmakuFactory danmakuFactory = BiliDanmukuParser.this.mContext.mDanmakuFactory;
                                DanmakuFactory.fillLinePathData(this.item, fArr, BiliDanmukuParser.this.mDispScaleX, BiliDanmukuParser.this.mDispScaleY);
                                return;
                            }
                            return;
                        }
                        j2 = j3;
                    } else {
                        f3 = f2;
                        f5 = parseFloat;
                        f4 = parseFloat2;
                        j2 = parseFloat5;
                    }
                    j = 0;
                    if (BiliDanmukuParser.this.isPercentageNumber(parseFloat)) {
                    }
                    if (BiliDanmukuParser.this.isPercentageNumber(parseFloat2)) {
                    }
                    if (BiliDanmukuParser.this.isPercentageNumber(f5)) {
                    }
                    if (BiliDanmukuParser.this.isPercentageNumber(f4)) {
                    }
                    this.item.duration = new Duration(parseFloat5);
                    this.item.rotationZ = f;
                    this.item.rotationY = f3;
                    BiliDanmukuParser.this.mContext.mDanmakuFactory.fillTranslationData(this.item, parseFloat, parseFloat2, f5, f4, j2, j, BiliDanmukuParser.this.mDispScaleX, BiliDanmukuParser.this.mDispScaleY);
                    BiliDanmukuParser.this.mContext.mDanmakuFactory.fillAlphaData(this.item, parseFloat3, parseFloat4, parseFloat5);
                    this.item.textShadowColor = 0;
                    int length22 = strArr.length;
                    int length32 = strArr.length;
                    if (strArr.length >= 15) {
                    }
                }
            }
        }

        private String decodeXmlString(String str) {
            if (str.contains("&amp;")) {
                str = str.replace("&amp;", "&");
            }
            if (str.contains("&quot;")) {
                str = str.replace("&quot;", JSUtil.QUOTE);
            }
            if (str.contains("&gt;")) {
                str = str.replace("&gt;", Operators.G);
            }
            return str.contains("&lt;") ? str.replace("&lt;", Operators.L) : str;
        }
    }

    @Override // master.flame.danmaku.danmaku.parser.BaseDanmakuParser
    public BaseDanmakuParser setDisplayer(IDisplayer iDisplayer) {
        super.setDisplayer(iDisplayer);
        this.mDispScaleX = ((float) this.mDispWidth) / 682.0f;
        this.mDispScaleY = ((float) this.mDispHeight) / 438.0f;
        return this;
    }
}
