package io.dcloud.media.video.ijkplayer;

import android.app.Activity;
import android.net.Uri;
import android.text.TextUtils;
import android.widget.FrameLayout;
import com.bumptech.glide.Glide;
import com.taobao.weex.common.Constants;
import com.taobao.weex.ui.component.WXBasicComponentType;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IVideoPlayer;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.Deprecated_JSUtil;
import io.dcloud.common.util.FileUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.media.video.VideoPlayerMgr;
import io.dcloud.media.video.ijkplayer.media.IjkPlayerView;
import io.dcloud.media.video.ijkplayer.option.EnumPlayStrategy;
import java.util.HashMap;
import org.json.JSONObject;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class VideoPlayerView extends FrameLayout implements IVideoPlayer {
    public JSONObject fullScreenOptions = null;
    private boolean isAutoPlay = false;
    private boolean isLoopPlay = false;
    private HashMap<String, HashMap<String, String>> mCallbacks;
    private String mHeaderInfo;
    private IWebview mIWebview;
    private JSONObject mOptions;
    private IjkPlayerView mPlayerView;
    private String mPosterUrl;
    private String mUrl;
    private int[] rect;
    public boolean videoHandleTouch = false;

    public void setFullScreenOptions(JSONObject jSONObject) {
        this.fullScreenOptions = jSONObject;
    }

    public VideoPlayerView(Activity activity, IWebview iWebview, JSONObject jSONObject) {
        super(activity);
        this.mIWebview = iWebview;
        IjkPlayerView ijkPlayerView = new IjkPlayerView(activity, null, this);
        this.mPlayerView = ijkPlayerView;
        addView(ijkPlayerView, new FrameLayout.LayoutParams(-1, -1));
        this.mCallbacks = new HashMap<>();
        this.mPlayerView.init().setPlayerRootView(this);
        this.mPlayerView.setOnInfoListener(new IMediaPlayer.OnInfoListener() {
            /* class io.dcloud.media.video.ijkplayer.VideoPlayerView.AnonymousClass1 */

            @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnInfoListener
            public boolean onInfo(IMediaPlayer iMediaPlayer, int i, int i2) {
                if (VideoPlayerView.this.mIWebview.obtainApp() == null) {
                    return false;
                }
                if (i == 336) {
                    VideoPlayerView.this.statusChanged("ended", "");
                    if (VideoPlayerView.this.isLoopPlay) {
                        int optInt = VideoPlayerView.this.mOptions.optInt("initial-time");
                        if (optInt > 0) {
                            VideoPlayerView.this.mPlayerView.seekTo(optInt * 1000);
                        }
                        VideoPlayerView.this.play();
                    }
                } else if (i == 334) {
                    VideoPlayerView.this.statusChanged(Constants.Value.PLAY, "");
                } else if (i == 335) {
                    VideoPlayerView.this.statusChanged("pause", "");
                } else if (i == 331) {
                    VideoPlayerView.this.statusChanged("error", "");
                } else if (i == 332 || i == 701) {
                    VideoPlayerView.this.statusChanged(IApp.ConfigProperty.CONFIG_WAITING, "");
                } else if (i == 337) {
                    VideoPlayerView videoPlayerView = VideoPlayerView.this;
                    Object[] objArr = new Object[1];
                    objArr[0] = Integer.valueOf(videoPlayerView.mPlayerView != null ? VideoPlayerView.this.mPlayerView.getCurPosition() : 0);
                    videoPlayerView.statusChanged("seekcomplete", StringUtil.format("{'position':%d}", objArr));
                }
                return false;
            }
        });
        this.mPlayerView.setOnPlayerChangedListener(new OnPlayerChangedListener() {
            /* class io.dcloud.media.video.ijkplayer.VideoPlayerView.AnonymousClass2 */

            @Override // io.dcloud.media.video.ijkplayer.OnPlayerChangedListener
            public void onChanged(String str, String str2) {
                VideoPlayerView.this.statusChanged(str, str2);
            }
        });
        initOptionsPlayerView(this.mPlayerView, jSONObject);
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public boolean isVideoHandleTouch() {
        return this.videoHandleTouch;
    }

    public void initOptionsPlayerView(IjkPlayerView ijkPlayerView, JSONObject jSONObject) {
        boolean z;
        Uri videoFileUri;
        this.mOptions = jSONObject;
        String optString = jSONObject.optString("src");
        if (!TextUtils.isEmpty(optString)) {
            if (!PdrUtil.isNetPath(optString)) {
                optString = this.mIWebview.obtainApp().convert2AbsFullPath(this.mIWebview.obtainFullUrl(), optString);
                if (optString.startsWith("/android_asset")) {
                    optString = optString.replace("/android_asset", "");
                } else if (optString.startsWith("android_asset")) {
                    optString = optString.replace("android_asset", "");
                }
                if (!PdrUtil.isDeviceRootDir(optString) && !TextUtils.isEmpty(optString)) {
                    optString = this.mIWebview.obtainApp().convert2AbsFullPath(this.mIWebview.obtainFullUrl(), this.mIWebview.obtainApp().checkPrivateDirAndCopy2Temp(optString));
                }
                if (!FileUtil.checkPrivatePath(getContext(), optString) && (videoFileUri = FileUtil.getVideoFileUri(getContext(), optString)) != null) {
                    optString = videoFileUri.toString();
                }
            }
            this.isAutoPlay = this.mOptions.optBoolean(Constants.Name.AUTOPLAY, this.isAutoPlay);
            this.isLoopPlay = this.mOptions.optBoolean("loop", this.isLoopPlay);
            setPoster(this.mOptions.optString("poster"));
            if (!this.mOptions.isNull("muted")) {
                ijkPlayerView.setMutePlayer(this.mOptions.optBoolean("muted", false));
            }
            if (this.mOptions.optBoolean("page-gesture", false) || this.mOptions.optBoolean("vslide-gesture", false)) {
                this.videoHandleTouch = true;
                z = true;
            } else {
                z = false;
            }
            ijkPlayerView.setPageGesture(z);
            ijkPlayerView.setIsFullScreenPageGesture(this.mOptions.optBoolean("vslide-gesture-in-fullscreen", true));
            ijkPlayerView.setIsShowScreenLockButton(this.mOptions.optBoolean("show-screen-lock-button", false));
            ijkPlayerView.setProgressVisibility(this.mOptions.optBoolean("show-progress", true));
            ijkPlayerView.setFullscreenBntVisibility(this.mOptions.optBoolean("show-fullscreen-btn", true));
            ijkPlayerView.setPlayBntVisibility(this.mOptions.optBoolean("show-play-btn", true));
            ijkPlayerView.setIsEnableProgressGesture(this.mOptions.optBoolean("enable-progress-gesture", true));
            ijkPlayerView.setmIsDoubleTapEnable(this.mOptions.optBoolean("enable-play-gesture", false));
            ijkPlayerView.setLoadingVisibility(this.mOptions.optBoolean(Constants.Name.SHOW_LOADING, true));
            ijkPlayerView.setDirection(this.mOptions.optInt("direction", -90));
            ijkPlayerView.setmDanmuList(this.mOptions.optString("danmu-list"));
            if (this.mOptions.has("objectFit")) {
                ijkPlayerView.setScaleType(this.mOptions.optString("objectFit", "contain"));
            } else if (this.mOptions.has("object-fit")) {
                ijkPlayerView.setScaleType(this.mOptions.optString("object-fit", "contain"));
            }
            ijkPlayerView.isMuteBtnShow(this.mOptions.optBoolean("show-mute-btn", false));
            if (this.mOptions.has("codec")) {
                ijkPlayerView.isUseMediaCodec(this.mOptions.optString("codec").equals("hardware"));
            }
            if (this.mOptions.has("advanced")) {
                ijkPlayerView.setCustomAdvanced(this.mOptions.optString("advanced"));
            }
            if (this.mOptions.has("httpCache")) {
                ijkPlayerView.setViewHttpCacheOpen(this.mOptions.optBoolean("httpCache", false));
            }
            if (this.mOptions.has("playStrategy")) {
                int optInt = this.mOptions.optInt("playStrategy", EnumPlayStrategy.DEFAULT.getFlagVal());
                EnumPlayStrategy enumPlayStrategy = EnumPlayStrategy.PLAY_SMOOTH;
                if (optInt == EnumPlayStrategy.PLAY_SMOOTH.getFlagVal()) {
                    enumPlayStrategy = EnumPlayStrategy.PLAY_SMOOTH;
                } else if (optInt == EnumPlayStrategy.START_QUICK.getFlagVal()) {
                    enumPlayStrategy = EnumPlayStrategy.START_QUICK;
                } else if (optInt == EnumPlayStrategy.M3U8_SMOOTH.getFlagVal()) {
                    enumPlayStrategy = EnumPlayStrategy.M3U8_SMOOTH;
                } else if (optInt == EnumPlayStrategy.DEFAULT.getFlagVal()) {
                    enumPlayStrategy = EnumPlayStrategy.DEFAULT;
                }
                ijkPlayerView.setFlowStrategy(enumPlayStrategy);
            }
            String optString2 = jSONObject.optString(WXBasicComponentType.HEADER);
            if (TextUtils.isEmpty(this.mUrl)) {
                this.mPlayerView.setVideoPath(optString, optString2);
                resetSeek(ijkPlayerView);
            } else if (!this.mUrl.equalsIgnoreCase(optString) || !this.mHeaderInfo.equalsIgnoreCase(optString2)) {
                this.mPlayerView.switchVideoPath(optString, optString2);
                resetSeek(ijkPlayerView);
                IjkPlayerView ijkPlayerView2 = this.mPlayerView;
                ijkPlayerView2.setMutePlayer(ijkPlayerView2.isMutePlayer());
            }
            ijkPlayerView.setCenterPlayBntVisibility(this.mOptions.optBoolean("show-center-play-btn", true));
            ijkPlayerView.setControls(this.mOptions.optBoolean(Constants.Name.CONTROLS, true));
            ijkPlayerView.setDuration(this.mOptions.optInt("duration", -1) * 1000);
            if (jSONObject.has(AbsoluteConst.JSON_KEY_TITLE)) {
                ijkPlayerView.setTitle(jSONObject.optString(AbsoluteConst.JSON_KEY_TITLE));
            }
            this.mUrl = optString;
            this.mHeaderInfo = optString2;
        }
    }

    public int getDirection() {
        JSONObject jSONObject = this.mOptions;
        if (jSONObject != null && jSONObject.has("direction")) {
            try {
                return Integer.parseInt(this.mOptions.optString("direction"));
            } catch (Exception unused) {
            }
        }
        return Integer.MIN_VALUE;
    }

    private void resetSeek(IjkPlayerView ijkPlayerView) {
        ijkPlayerView.seekTo(this.mOptions.optInt("initial-time") * 1000);
        this.mPlayerView.clearDanma();
        ijkPlayerView.enableDanmaku(this.mOptions.optBoolean("enable-danmu", false));
        ijkPlayerView.enableDanmuBtn(this.mOptions.optBoolean("danmu-btn", false));
        if (this.isAutoPlay) {
            play();
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void play() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.start();
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void pause() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.pause();
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void resume() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.onResume();
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void stop() {
        statusChanged(IApp.ConfigProperty.CONFIG_WAITING, "");
        if (this.mPlayerView != null && !TextUtils.isEmpty(this.mUrl)) {
            this.mPlayerView.clearDanma();
            this.mPlayerView.switchVideoPath(this.mUrl, this.mHeaderInfo);
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void close() {
        statusChanged(IApp.ConfigProperty.CONFIG_WAITING, "");
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.stop();
            this.mPlayerView.onDestroy();
            this.mPlayerView = null;
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void seek(String str) {
        int parseInt = Integer.parseInt(str);
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.seekTo(parseInt * 1000);
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void sendDanmu(JSONObject jSONObject) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.sendDanmaku(jSONObject, true);
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void playbackRate(String str) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.playbackRate(str);
        }
    }

    public boolean onBackPressed() {
        return this.mPlayerView.onBackPressed();
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void requestFullScreen(String str) {
        int parseInt = Integer.parseInt(str);
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.fullScreen(parseInt);
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void exitFullScreen() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.exitFullScreen();
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void setOptions(JSONObject jSONObject) {
        if (jSONObject != null) {
            this.mPlayerView.hiddenLoaded(true);
            initOptionsPlayerView(this.mPlayerView, jSONObject);
        }
    }

    private void setPoster(String str) {
        if (!TextUtils.isEmpty(str)) {
            if (TextUtils.isEmpty(this.mPosterUrl) || !this.mPosterUrl.equalsIgnoreCase(str)) {
                Glide.with(this).load(str).into(this.mPlayerView.mPlayerThumb);
            }
            this.mPosterUrl = str;
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void addEventListener(String str, String str2, String str3) {
        HashMap<String, String> hashMap = this.mCallbacks.get(str);
        if (hashMap == null) {
            hashMap = new HashMap<>();
        }
        hashMap.put(str2, str3);
        this.mCallbacks.put(str, hashMap);
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public boolean isFullScreen() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            return ijkPlayerView.isFullscreen();
        }
        return false;
    }

    public boolean isPlaying() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            return ijkPlayerView.isPlaying();
        }
        return false;
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public void release() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.onDestroy();
            this.mPlayerView = null;
        }
    }

    @Override // io.dcloud.common.DHInterface.IVideoPlayer
    public boolean isPointInRect(float f, float f2) {
        int[] iArr = this.rect;
        if (iArr == null || f <= ((float) iArr[0]) || f >= ((float) iArr[2]) || f2 <= ((float) iArr[1]) || f2 >= ((float) iArr[3])) {
            return false;
        }
        return true;
    }

    public void setRect(int[] iArr) {
        this.rect = iArr;
    }

    public void statusChanged(String str, String str2) {
        IWebview iWebview;
        if (this.mCallbacks.containsKey(str)) {
            HashMap<String, String> hashMap = this.mCallbacks.get(str);
            for (String str3 : hashMap.keySet()) {
                if (PdrUtil.isEmpty(hashMap.get(str3))) {
                    iWebview = this.mIWebview;
                } else {
                    iWebview = VideoPlayerMgr.getInstance().findWebview(this.mIWebview, hashMap.get(str3));
                }
                Deprecated_JSUtil.execCallback(iWebview, str3, str2, JSUtil.OK, !TextUtils.isEmpty(str2), true);
            }
        }
    }
}
