package io.dcloud.media.video;

import android.view.ViewGroup;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.common.constant.AbsoluteConst;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class VideoPlayerMgr {
    private static VideoPlayerMgr mInstance;
    private ViewGroup.LayoutParams _vlps;
    private AbsMgr mFeatureMgr;
    private HashMap<String, DHVideoFrameItem> mPlayerCaches = new HashMap<>();

    public static VideoPlayerMgr getInstance() {
        if (mInstance == null) {
            mInstance = new VideoPlayerMgr();
        }
        return mInstance;
    }

    public void initFeature(AbsMgr absMgr) {
        this.mFeatureMgr = absMgr;
    }

    public IWebview findWebview(IWebview iWebview, String str) {
        IApp obtainApp;
        if (iWebview == null || (obtainApp = iWebview.obtainApp()) == null) {
            return null;
        }
        Object processEvent = this.mFeatureMgr.processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{iWebview, AbsoluteConst.F_UI, "findWebview", new String[]{obtainApp.obtainAppId(), str}});
        if (processEvent instanceof IWebview) {
            return (IWebview) processEvent;
        }
        return null;
    }

    public void createVideoPlayer(IWebview iWebview, String str, JSONArray jSONArray, JSONObject jSONObject, String str2, boolean z) {
        DHVideoFrameItem dHVideoFrameItem;
        if (this.mPlayerCaches.containsKey(str)) {
            dHVideoFrameItem = this.mPlayerCaches.get(str);
        } else {
            DHVideoFrameItem dHVideoFrameItem2 = new DHVideoFrameItem(iWebview.getContext(), str, iWebview, jSONArray, jSONObject, str2);
            this.mPlayerCaches.put(str, dHVideoFrameItem2);
            dHVideoFrameItem = dHVideoFrameItem2;
        }
        if (!z) {
            dHVideoFrameItem.appendToFrame(iWebview.obtainFrameView());
        }
    }

    public void play(String str) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.play();
        }
    }

    public void pause(String str) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.pause();
        }
    }

    public void stop(String str) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.stop();
        }
    }

    public void close(IWebview iWebview, String str) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.close();
            dHVideoFrameItem.removeFrameItem();
        }
    }

    public void sendDanmu(String str, JSONObject jSONObject) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.sendDanmu(jSONObject);
        }
    }

    public JSONObject findVideoPlayer(String str) {
        DHVideoFrameItem dHVideoFrameItem;
        if (str == null) {
            return null;
        }
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        if (hashMap != null) {
            dHVideoFrameItem = null;
            for (String str2 : hashMap.keySet()) {
                DHVideoFrameItem dHVideoFrameItem2 = this.mPlayerCaches.get(str2);
                if (str.equals(dHVideoFrameItem2.getUserId())) {
                    dHVideoFrameItem = dHVideoFrameItem2;
                }
            }
        } else {
            dHVideoFrameItem = null;
        }
        if (dHVideoFrameItem != null) {
            try {
                return new JSONObject("{'name':'" + dHVideoFrameItem.getUserId() + "','uid':'" + dHVideoFrameItem.getmId() + "'}");
            } catch (JSONException unused) {
            }
        }
        return null;
    }

    public AdaFrameItem appendVideoPlayer(String str, IFrameView iFrameView) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.appendToFrame(iFrameView);
        }
        return dHVideoFrameItem;
    }

    public void seekTo(String str, String str2) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.seek(str2);
        }
    }

    public void recovery() {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        if (hashMap != null && hashMap.size() > 0) {
            for (String str : this.mPlayerCaches.keySet()) {
                this.mPlayerCaches.get(str).release();
            }
        }
        this.mPlayerCaches.clear();
    }

    public void rmovePlayer(String str) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        if (hashMap != null && hashMap.size() > 0 && this.mPlayerCaches.containsKey(str)) {
            this.mPlayerCaches.remove(str);
        }
    }

    public void requestFullScreen(String str, String str2) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.requestFullScreen(str2);
        }
    }

    public void exitFullScreen(String str) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.exitFullScreen();
        }
    }

    public void show(String str) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.show();
        }
    }

    public void hidden(String str) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.hidden();
        }
    }

    public void addEventListener(IWebview iWebview, String str, String str2, String str3, String str4) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.addEventListener(str2, str3, str4);
        }
    }

    public void setOptions(String str, JSONObject jSONObject) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.setOptions(jSONObject);
        }
    }

    public void setPlayBackRate(String str, String str2) {
        HashMap<String, DHVideoFrameItem> hashMap = this.mPlayerCaches;
        DHVideoFrameItem dHVideoFrameItem = (hashMap == null || !hashMap.containsKey(str)) ? null : this.mPlayerCaches.get(str);
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.sendPlayBackRate(str2);
        }
    }

    public void resize(IWebview iWebview, String str, JSONArray jSONArray) {
        DHVideoFrameItem dHVideoFrameItem = this.mPlayerCaches.containsKey(str) ? this.mPlayerCaches.get(str) : null;
        if (dHVideoFrameItem != null) {
            dHVideoFrameItem.resize(jSONArray);
        }
    }
}
