package io.dcloud.media.video;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.common.adapter.util.ViewOptions;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.media.video.ijkplayer.VideoPlayerView;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DHVideoFrameItem extends AdaFrameItem implements ISysEventListener {
    private ViewGroup.LayoutParams _vlps;
    private boolean isRegisterResize = false;
    private IWebview mAppendWebview = null;
    private IWebview mContenterView = null;
    private IWebview mIWebview;
    private String mId;
    private VideoPlayerView mPlayerView;
    public String position = "static";
    private JSONArray rect = null;
    private long resumeTime = 0;
    private JSONObject styles = null;
    private String userId;

    public void removeFrameItem() {
        if (this.position.equals(AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE)) {
            this.mContenterView.obtainFrameView().removeFrameItem(this);
        } else {
            this.mContenterView.removeFrameItem(this);
        }
    }

    protected DHVideoFrameItem(Context context, String str, IWebview iWebview, JSONArray jSONArray, JSONObject jSONObject, String str2) {
        super(context);
        this.mIWebview = iWebview;
        this.mContenterView = iWebview;
        this.mId = str;
        this.userId = str2;
        this.rect = jSONArray;
        this.styles = jSONObject;
        IApp obtainApp = iWebview.obtainFrameView().obtainApp();
        obtainApp.registerSysEventListener(this, ISysEventListener.SysEventType.onPause);
        obtainApp.registerSysEventListener(this, ISysEventListener.SysEventType.onResume);
        obtainApp.registerSysEventListener(this, ISysEventListener.SysEventType.onStop);
        obtainApp.registerSysEventListener(this, ISysEventListener.SysEventType.onKeyUp);
        VideoPlayerView videoPlayerView = new VideoPlayerView(this.mIWebview.getActivity(), iWebview, this.styles);
        this.mPlayerView = videoPlayerView;
        setMainView(videoPlayerView);
        initFrame(this.rect);
        this.position = this.styles.optString("position");
    }

    private void initFrame(JSONArray jSONArray) {
        ViewOptions obtainFrameOptions = ((AdaFrameItem) this.mContenterView.obtainFrameView()).obtainFrameOptions();
        float scale = this.mContenterView.getScale();
        int convertToScreenInt = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONArray, 2), obtainFrameOptions.width, obtainFrameOptions.width, scale, true);
        int convertToScreenInt2 = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONArray, 3), obtainFrameOptions.height, obtainFrameOptions.height, scale, true);
        int convertToScreenInt3 = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONArray, 0), obtainFrameOptions.width, 0, scale, true);
        int convertToScreenInt4 = PdrUtil.convertToScreenInt(JSONUtil.getString(jSONArray, 1), obtainFrameOptions.height, 0, scale, true);
        updateViewRect((AdaFrameItem) this.mContenterView.obtainFrameView(), new int[]{convertToScreenInt3, convertToScreenInt4, convertToScreenInt, convertToScreenInt2}, new int[]{obtainFrameOptions.width, obtainFrameOptions.height});
        this._vlps = AdaFrameItem.LayoutParamsUtil.createLayoutParams(convertToScreenInt3, convertToScreenInt4, convertToScreenInt, convertToScreenInt2);
        this.mPlayerView.setRect(new int[]{convertToScreenInt3, convertToScreenInt4, convertToScreenInt + convertToScreenInt3, convertToScreenInt2 + convertToScreenInt4});
    }

    public String getUserId() {
        return this.userId;
    }

    public String getmId() {
        return this.mId;
    }

    @Override // io.dcloud.common.adapter.ui.AdaFrameItem
    public void dispose() {
        super.dispose();
        release();
        VideoPlayerMgr.getInstance().rmovePlayer(this.mId);
    }

    @Override // io.dcloud.common.DHInterface.ISysEventListener
    public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
        VideoPlayerView videoPlayerView;
        if (sysEventType == ISysEventListener.SysEventType.onPause) {
            if (System.currentTimeMillis() - this.resumeTime > 100) {
                pause();
                this.resumeTime = 0;
            }
            return true;
        } else if (sysEventType == ISysEventListener.SysEventType.onResume) {
            if (this.resumeTime > 0) {
                resume();
            }
            this.resumeTime = System.currentTimeMillis();
            return true;
        } else if (sysEventType == ISysEventListener.SysEventType.onStop) {
            release();
            return true;
        } else if (sysEventType != ISysEventListener.SysEventType.onKeyUp || ((Integer) ((Object[]) obj)[0]).intValue() != 4 || !isFullScreen() || (videoPlayerView = this.mPlayerView) == null) {
            return false;
        } else {
            return videoPlayerView.onBackPressed();
        }
    }

    public void play() {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.play();
        }
    }

    public void pause() {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.pause();
        }
    }

    public void resume() {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.resume();
        }
    }

    public void seek(String str) {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.seek(str);
        }
    }

    public void sendDanmu(JSONObject jSONObject) {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.sendDanmu(jSONObject);
        }
    }

    public void sendPlayBackRate(String str) {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.playbackRate(str);
        }
    }

    public void playbackRate(String str) {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.playbackRate(str);
        }
    }

    public void requestFullScreen(String str) {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.requestFullScreen(str);
        }
    }

    public void exitFullScreen() {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.exitFullScreen();
        }
    }

    public void setOptions(JSONObject jSONObject) {
        if (this.mPlayerView != null) {
            this.styles = JSONUtil.combinJSONObject(this.styles, jSONObject);
            if (this.mPlayerView.isFullScreen()) {
                try {
                    JSONObject jSONObject2 = new JSONObject(this.styles.toString());
                    jSONObject2.remove("top");
                    jSONObject2.remove("left");
                    jSONObject2.remove("width");
                    jSONObject2.remove("height");
                    jSONObject2.remove("position");
                    this.mPlayerView.setOptions(jSONObject2);
                } catch (JSONException unused) {
                }
            } else {
                if (jSONObject.has("top") || jSONObject.has("left") || jSONObject.has("width") || jSONObject.has("height") || jSONObject.has("position")) {
                    try {
                        this.rect.put(0, JSONUtil.getString(jSONObject, "left"));
                        this.rect.put(1, JSONUtil.getString(jSONObject, "top"));
                        this.rect.put(2, JSONUtil.getString(jSONObject, "width"));
                        this.rect.put(3, JSONUtil.getString(jSONObject, "height"));
                    } catch (JSONException unused2) {
                    }
                    String string = JSONUtil.getString(jSONObject, "position");
                    initFrame(this.rect);
                    if (jSONObject.has("position")) {
                        if (string.equals(this.position)) {
                            obtainMainView().setLayoutParams(this._vlps);
                        } else if (AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE.equals(this.position)) {
                            this.mContenterView.obtainFrameView().removeFrameItem(this);
                            this.mContenterView.addFrameItem(this, this._vlps);
                        } else if ("static".equals(this.position)) {
                            this.mContenterView.removeFrameItem(this);
                            this.mContenterView.obtainFrameView().addFrameItem(this, this._vlps);
                        }
                        this.position = string;
                    } else {
                        obtainMainView().setLayoutParams(this._vlps);
                    }
                }
                this.mPlayerView.setOptions(this.styles);
            }
        }
    }

    public void addEventListener(String str, String str2, String str3) {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.addEventListener(str, str2, str3);
        }
    }

    public void release() {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.release();
            this.mPlayerView = null;
        }
    }

    public boolean isFullScreen() {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            return videoPlayerView.isFullScreen();
        }
        return false;
    }

    public void stop() {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.stop();
        }
    }

    public void close() {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.close();
        }
    }

    public void hidden() {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.setVisibility(4);
        }
    }

    public void show() {
        VideoPlayerView videoPlayerView = this.mPlayerView;
        if (videoPlayerView != null) {
            videoPlayerView.setVisibility(0);
        }
    }

    public void appendToFrame(IFrameView iFrameView) {
        View obtainMainView = obtainMainView();
        if (!(obtainMainView == null || obtainMainView.getParent() == null)) {
            removeFrameItem();
        }
        this.mContenterView = iFrameView.obtainWebView();
        initFrame(this.rect);
        if (this.position.equals("static")) {
            this.mContenterView.addFrameItem(this, this._vlps);
        } else if (this.position.equals(AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE)) {
            this.mContenterView.obtainFrameView().addFrameItem(this, this._vlps);
        } else {
            this.mContenterView.addFrameItem(this, this._vlps);
        }
    }

    /* access modifiers changed from: protected */
    @Override // io.dcloud.common.adapter.ui.AdaFrameItem
    public void onResize() {
        if (!this.isRegisterResize) {
            super.onResize();
            initFrame(this.rect);
            obtainMainView().setLayoutParams(this._vlps);
        }
    }

    public void resize(JSONArray jSONArray) {
        initFrame(jSONArray);
        obtainMainView().setLayoutParams(this._vlps);
        this.isRegisterResize = true;
    }
}
