package io.dcloud.js.gallery;

import android.app.Activity;
import android.content.BroadcastReceiver;
import android.content.ClipData;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.graphics.BitmapFactory;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.Parcelable;
import android.text.TextUtils;
import androidx.core.app.ActivityCompat;
import androidx.localbroadcastmanager.content.LocalBroadcastManager;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.transition.Transition;
import com.dmcbig.mediapicker.PickerConfig;
import com.dmcbig.mediapicker.entity.Media;
import com.taobao.weex.common.Constants;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IActivityHandler;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IFeature;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.util.ContentUriUtil;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.constant.DOMException;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.Deprecated_JSUtil;
import io.dcloud.common.util.FileUtil;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class GalleryFeatureImpl implements IFeature {
    private static String a = (Environment.getExternalStoragePublicDirectory(Environment.DIRECTORY_DCIM).getAbsolutePath() + "/Camera/");
    private static int b = 1001;
    private static int c = 1002;
    private static int d = 1003;
    private static int e = 1004;
    private static IWebview f;
    AbsMgr g = null;
    private ArrayList<BroadcastReceiver> h;
    private boolean i = false;

    class a extends PermissionUtil.Request {
        final /* synthetic */ String[] a;
        final /* synthetic */ IWebview b;
        final /* synthetic */ String c;

        a(String[] strArr, IWebview iWebview, String str) {
            this.a = strArr;
            this.b = iWebview;
            this.c = str;
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onDenied(String str) {
            if (!"android.permission.READ_MEDIA_VIDEO".equals(str)) {
                if (!(ActivityCompat.checkSelfPermission(this.b.getContext(), "android.permission.READ_MEDIA_VISUAL_USER_SELECTED") == -1)) {
                    onGranted("android.permission.READ_MEDIA_IMAGES");
                    return;
                }
                Deprecated_JSUtil.execCallback(this.b, this.a[0], DOMException.toJSON(12, DOMException.MSG_NO_PERMISSION), JSUtil.ERROR, true, false);
            }
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onGranted(String str) {
            String[] strArr = this.a;
            boolean z = false;
            if (strArr.length >= 2) {
                String str2 = strArr[1];
                if (!PdrUtil.isEmpty(str2)) {
                    try {
                        z = new JSONObject(str2).optBoolean("multiple", false);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                }
            }
            if (!GalleryFeatureImpl.this.i) {
                if (z) {
                    GalleryFeatureImpl.this.a(this.b, this.c, this.a);
                } else {
                    GalleryFeatureImpl.this.b(this.b, this.c, this.a);
                }
                GalleryFeatureImpl.this.i = true;
            }
        }
    }

    /* access modifiers changed from: package-private */
    public class b extends PermissionUtil.StreamPermissionRequest {
        final /* synthetic */ String a;
        final /* synthetic */ IApp b;
        final /* synthetic */ IWebview c;
        final /* synthetic */ String d;
        final /* synthetic */ String[] e;

        class a extends CustomTarget<byte[]> {
            a() {
            }

            /* renamed from: a */
            public void onResourceReady(byte[] bArr, Transition<? super byte[]> transition) {
                String downloadFilename = PdrUtil.getDownloadFilename(null, "image/*", b.this.a);
                if (!downloadFilename.contains(Operators.DOT_STR) || FileUtil.getFileTypeForSuffix(downloadFilename.substring(downloadFilename.lastIndexOf(Operators.DOT_STR) + 1)) == null) {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inJustDecodeBounds = true;
                    BitmapFactory.decodeByteArray(bArr, 0, bArr.length, options);
                    String str = options.outMimeType;
                    if (!PdrUtil.isEmpty(str)) {
                        String[] split = str.split("/");
                        if (split.length > 1 && !PdrUtil.isEmpty(split[1]) && !split[1].contains("*")) {
                            downloadFilename = downloadFilename + "_" + System.currentTimeMillis() + Operators.DOT_STR + split[1];
                        }
                    }
                }
                String str2 = GalleryFeatureImpl.a + downloadFilename;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bArr);
                if (!FileUtil.needMediaStoreOpenFile(b.this.b.getActivity())) {
                    FileUtil.writeStream2File(byteArrayInputStream, new File(str2));
                } else {
                    Uri copyMediaFileToDCIM = FileUtil.copyMediaFileToDCIM(b.this.c.getContext(), byteArrayInputStream, downloadFilename);
                    if (copyMediaFileToDCIM != null) {
                        str2 = FileUtil.getPathFromUri(b.this.c.getContext(), copyMediaFileToDCIM);
                    } else {
                        String json = DOMException.toJSON(12, "SAVE ERROR");
                        b bVar = b.this;
                        Deprecated_JSUtil.execCallback(bVar.c, bVar.d, json, JSUtil.ERROR, true, false);
                    }
                }
                String convert2WebviewFullPath = b.this.b.convert2WebviewFullPath(null, str2);
                try {
                    JSONObject jSONObject = new JSONObject();
                    jSONObject.put("file", convert2WebviewFullPath);
                    jSONObject.put(AbsoluteConst.XML_PATH, convert2WebviewFullPath);
                    b bVar2 = b.this;
                    JSUtil.execCallback(bVar2.c, bVar2.d, jSONObject, JSUtil.OK, false);
                    b.this.c.getContext().sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse(DeviceInfo.FILE_PROTOCOL + str2)));
                } catch (JSONException unused) {
                }
            }

            @Override // com.bumptech.glide.request.target.Target
            public void onLoadCleared(Drawable drawable) {
            }

            @Override // com.bumptech.glide.request.target.CustomTarget, com.bumptech.glide.request.target.Target
            public void onLoadFailed(Drawable drawable) {
                String json = DOMException.toJSON(12, "UNKOWN ERROR");
                b bVar = b.this;
                Deprecated_JSUtil.execCallback(bVar.c, bVar.d, json, JSUtil.ERROR, true, false);
            }
        }

        /* JADX INFO: super call moved to the top of the method (can break code semantics) */
        b(IApp iApp, String str, IApp iApp2, IWebview iWebview, String str2, String[] strArr) {
            super(iApp);
            this.a = str;
            this.b = iApp2;
            this.c = iWebview;
            this.d = str2;
            this.e = strArr;
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onDenied(String str) {
            Deprecated_JSUtil.execCallback(this.c, this.d, DOMException.toJSON(12, DOMException.MSG_NO_PERMISSION), JSUtil.ERROR, true, false);
        }

        /* JADX WARNING: Removed duplicated region for block: B:28:0x00c1 A[Catch:{ Exception -> 0x011e }] */
        /* JADX WARNING: Removed duplicated region for block: B:30:0x0106  */
        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onGranted(String str) {
            try {
                String str2 = this.a;
                if (str2 == null) {
                    throw new IOException();
                } else if (PdrUtil.isNetPath(str2)) {
                    Glide.with(this.b.getActivity()).as(byte[].class).load(this.a).into(new a());
                } else {
                    String convert2AbsFullPath = this.b.convert2AbsFullPath(this.c.obtainFullUrl(), this.e[0]);
                    if (FileUtil.checkPrivatePath(this.b.getActivity(), convert2AbsFullPath) || FileUtil.isFilePathForPublic(this.b.getActivity(), convert2AbsFullPath)) {
                        boolean z = true;
                        String str3 = GalleryFeatureImpl.a + convert2AbsFullPath.substring(convert2AbsFullPath.lastIndexOf("/") + 1);
                        if (Build.VERSION.SDK_INT >= 29) {
                            if (FileUtil.needMediaStoreOpenFile(this.b.getActivity())) {
                                Uri copyMediaFileToDCIM = FileUtil.copyMediaFileToDCIM(this.c.getContext(), convert2AbsFullPath);
                                if (copyMediaFileToDCIM != null) {
                                    str3 = FileUtil.getPathFromUri(this.c.getContext(), copyMediaFileToDCIM);
                                    if (!z) {
                                    }
                                }
                            } else if (1 == DHFile.copyFile(convert2AbsFullPath, str3)) {
                                if (!z) {
                                    String convert2WebviewFullPath = this.b.convert2WebviewFullPath(null, str3);
                                    JSONObject jSONObject = new JSONObject();
                                    jSONObject.put("file", convert2WebviewFullPath);
                                    jSONObject.put(AbsoluteConst.XML_PATH, convert2WebviewFullPath);
                                    JSUtil.execCallback(this.c, this.d, jSONObject, JSUtil.OK, false);
                                    this.c.getContext().sendBroadcast(new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE", Uri.parse(DeviceInfo.FILE_PROTOCOL + str3)));
                                    return;
                                }
                                Deprecated_JSUtil.execCallback(this.c, this.d, DOMException.toJSON(12, "UNKOWN ERROR3"), JSUtil.ERROR, true, false);
                                return;
                            }
                        } else if (1 == DHFile.copyFile(convert2AbsFullPath, str3)) {
                            if (!z) {
                            }
                        }
                        z = false;
                        if (!z) {
                        }
                    } else {
                        Deprecated_JSUtil.execCallback(this.c, this.d, DOMException.toJSON(12, DOMException.MSG_PATH_NOT_PRIVATE_ERROR), JSUtil.ERROR, true, false);
                    }
                }
            } catch (Exception e2) {
                e2.printStackTrace();
                Deprecated_JSUtil.execCallback(this.c, this.d, DOMException.toJSON(12, "UNKOWN ERROR4"), JSUtil.ERROR, true, false);
            }
        }
    }

    /* access modifiers changed from: package-private */
    public class c implements ISysEventListener {
        final /* synthetic */ IApp a;
        final /* synthetic */ IWebview b;
        final /* synthetic */ String c;

        c(IApp iApp, IWebview iWebview, String str) {
            this.a = iApp;
            this.b = iWebview;
            this.c = str;
        }

        /* JADX WARNING: Removed duplicated region for block: B:35:0x00b1  */
        /* JADX WARNING: Removed duplicated region for block: B:36:0x00b3  */
        @Override // io.dcloud.common.DHInterface.ISysEventListener
        public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
            String[] strArr;
            String[] strArr2;
            String str;
            Object[] objArr = (Object[]) obj;
            int intValue = ((Integer) objArr[0]).intValue();
            ((Integer) objArr[1]).intValue();
            Intent intent = (Intent) objArr[2];
            ISysEventListener.SysEventType sysEventType2 = ISysEventListener.SysEventType.onActivityResult;
            if (sysEventType == sysEventType2) {
                this.a.unregisterSysEventListener(this, sysEventType2);
                try {
                    if (intValue == GalleryFeatureImpl.c) {
                        strArr2 = intent.getStringArrayExtra("all_path");
                    } else {
                        if (intValue == GalleryFeatureImpl.d) {
                            if (intent != null) {
                                ClipData clipData = intent.getClipData();
                                if (clipData != null) {
                                    int itemCount = clipData.getItemCount();
                                    strArr = new String[itemCount];
                                    for (int i = 0; i < itemCount; i++) {
                                        try {
                                            strArr[i] = ContentUriUtil.getImageAbsolutePath(this.b.getActivity(), clipData.getItemAt(i).getUri());
                                        } catch (Exception unused) {
                                        }
                                    }
                                } else if (intent.getData() != null) {
                                    if (PdrUtil.isDeviceRootDir(intent.getData().getPath())) {
                                        str = intent.getData().getPath();
                                    } else {
                                        str = ContentUriUtil.getImageAbsolutePath(this.b.getActivity(), intent.getData());
                                    }
                                    if (str != null) {
                                        strArr = new String[]{str};
                                    }
                                }
                                GalleryFeatureImpl.this.a(this.a, this.b, this.c, intent != null ? strArr : null, true);
                            }
                        } else if (intValue == GalleryFeatureImpl.e) {
                            strArr2 = GalleryFeatureImpl.this.mediasToJSONArray(intent.getParcelableArrayListExtra(PickerConfig.EXTRA_RESULT));
                        }
                        strArr = null;
                        GalleryFeatureImpl.this.a(this.a, this.b, this.c, intent != null ? strArr : null, true);
                    }
                    strArr = strArr2;
                } catch (Exception unused2) {
                }
                GalleryFeatureImpl.this.a(this.a, this.b, this.c, intent != null ? strArr : null, true);
            }
            return false;
        }
    }

    /* access modifiers changed from: package-private */
    public class d extends BroadcastReceiver {
        final /* synthetic */ Activity a;

        d(Activity activity) {
            this.a = activity;
        }

        public void onReceive(Context context, Intent intent) {
            String stringExtra = intent.getStringExtra("_onMaxedId");
            if (TextUtils.isEmpty(stringExtra)) {
                if (GalleryFeatureImpl.this.h != null) {
                    GalleryFeatureImpl.this.h.remove(this);
                }
                LocalBroadcastManager.getInstance(this.a).unregisterReceiver(this);
                return;
            }
            GalleryFeatureImpl.onMaxed(this.a, stringExtra);
        }
    }

    /* access modifiers changed from: package-private */
    public class e implements ISysEventListener {
        final /* synthetic */ IApp a;
        final /* synthetic */ IWebview b;
        final /* synthetic */ String c;

        e(IApp iApp, IWebview iWebview, String str) {
            this.a = iApp;
            this.b = iWebview;
            this.c = str;
        }

        @Override // io.dcloud.common.DHInterface.ISysEventListener
        public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
            String[] mediasToJSONArray;
            String str;
            Uri data;
            Object[] objArr = (Object[]) obj;
            int intValue = ((Integer) objArr[0]).intValue();
            ((Integer) objArr[1]).intValue();
            Intent intent = (Intent) objArr[2];
            ISysEventListener.SysEventType sysEventType2 = ISysEventListener.SysEventType.onActivityResult;
            if (sysEventType == sysEventType2) {
                this.a.unregisterSysEventListener(this, sysEventType2);
                String[] strArr = null;
                if (intValue == GalleryFeatureImpl.b) {
                    if (intent == null || (data = intent.getData()) == null) {
                        str = null;
                    } else {
                        str = PdrUtil.isDeviceRootDir(data.getPath()) ? data.getPath() : data.toString();
                    }
                    GalleryFeatureImpl galleryFeatureImpl = GalleryFeatureImpl.this;
                    IApp iApp = this.a;
                    IWebview iWebview = this.b;
                    String str2 = this.c;
                    if (str != null) {
                        strArr = new String[]{str};
                    }
                    galleryFeatureImpl.a(iApp, iWebview, str2, strArr, false);
                } else if (intValue == GalleryFeatureImpl.e) {
                    String str3 = (intent == null || (mediasToJSONArray = GalleryFeatureImpl.this.mediasToJSONArray(intent.getParcelableArrayListExtra(PickerConfig.EXTRA_RESULT))) == null || mediasToJSONArray.length <= 0) ? null : mediasToJSONArray[0];
                    GalleryFeatureImpl galleryFeatureImpl2 = GalleryFeatureImpl.this;
                    IApp iApp2 = this.a;
                    IWebview iWebview2 = this.b;
                    String str4 = this.c;
                    if (str3 != null) {
                        strArr = new String[]{str3};
                    }
                    galleryFeatureImpl2.a(iApp2, iWebview2, str4, strArr, false);
                }
            }
            return false;
        }
    }

    public static void onMaxed(Context context, String str) {
        IWebview iWebview = f;
        if (iWebview != null) {
            JSUtil.execCallback(iWebview, str, "", JSUtil.OK, true);
            return;
        }
        Intent intent = new Intent("io.dcloud.streamapp.Gallery.onMax." + str);
        intent.putExtra("_onMaxedId", str);
        LocalBroadcastManager.getInstance(context).sendBroadcast(intent);
    }

    public ArrayList<Media> JSONArrayToMedias(int i2, JSONArray jSONArray) {
        ArrayList<Media> arrayList = null;
        for (int i3 = 0; i3 < jSONArray.length(); i3++) {
            try {
                if (arrayList == null) {
                    arrayList = new ArrayList<>();
                }
                File file = new File(URI.create(jSONArray.getString(i3)));
                if (file.exists()) {
                    arrayList.add(new Media(file.getPath(), file.getName(), 0, i2 == 102 ? 3 : 1, file.length(), 0, ""));
                }
            } catch (Exception e2) {
                e2.printStackTrace();
            }
        }
        return arrayList;
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public void dispose(String str) {
        ArrayList<BroadcastReceiver> arrayList = this.h;
        if (!(arrayList == null || f == null)) {
            Iterator<BroadcastReceiver> it = arrayList.iterator();
            while (it.hasNext()) {
                LocalBroadcastManager.getInstance(f.getActivity()).unregisterReceiver(it.next());
            }
            this.h.clear();
        }
        f = null;
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public String execute(IWebview iWebview, String str, String[] strArr) {
        f = iWebview;
        Context context = iWebview.getContext();
        AppRuntime.checkPrivacyComplianceAndPrompt(context, "Gallery-" + str);
        boolean z = true;
        if ("pick".equals(str)) {
            this.i = false;
            a aVar = new a(strArr, iWebview, str);
            if (Build.VERSION.SDK_INT >= 34) {
                if (ActivityCompat.checkSelfPermission(iWebview.getContext(), "android.permission.READ_MEDIA_VISUAL_USER_SELECTED") != -1) {
                    z = false;
                }
                if (!z) {
                    aVar.onGranted("android.permission.READ_MEDIA_IMAGES");
                    return null;
                }
                PermissionUtil.usePermission(iWebview.obtainApp().getActivity(), "gallery", PermissionUtil.PMS_STORAGE_IMAGE, 2, aVar);
                return null;
            }
            PermissionUtil.usePermission(iWebview.obtainApp().getActivity(), "gallery", PermissionUtil.PMS_STORAGE_IMAGE, 2, aVar);
            return null;
        } else if (!"save".equals(str)) {
            return null;
        } else {
            IApp obtainApp = iWebview.obtainFrameView().obtainApp();
            PermissionUtil.usePermission(obtainApp.getActivity(), "gallery", PermissionUtil.PMS_STORAGE, 2, new b(obtainApp, strArr[0], obtainApp, iWebview, strArr[1], strArr));
            return null;
        }
    }

    public Intent getMediaPickerIntent(Context context, String str, int i2, JSONArray jSONArray, String str2, boolean z, String str3, JSONObject jSONObject, String str4, String str5, boolean z2) {
        int i3;
        Intent intent = new Intent();
        if (!str.contains("video") || !str.contains("image")) {
            i3 = str.contains("video") ? 102 : 100;
        } else {
            i3 = 101;
        }
        boolean contains = str.contains("__Single__");
        intent.setClassName(context, "com.dmcbig.mediapicker.PickerActivity");
        intent.putExtra(PickerConfig.SELECT_MODE, i3);
        intent.putExtra(PickerConfig.SINGLE_SELECT, contains);
        intent.putExtra(PickerConfig.COMPRESSED, z2);
        if (i2 > 0) {
            intent.putExtra(PickerConfig.MAX_SELECT_COUNT, i2);
        }
        if (jSONArray != null) {
            intent.putExtra(PickerConfig.DEFAULT_SELECTED_LIST, JSONArrayToMedias(i3, jSONArray));
        }
        if (!TextUtils.isEmpty(str3)) {
            intent.putExtra(PickerConfig.SELECTED_MAX_CALLBACK_ID, str3);
        }
        if (!TextUtils.isEmpty(str2)) {
            intent.putExtra(PickerConfig.DONE_BUTTON_TEXT, str2);
        }
        if (!TextUtils.isEmpty(str4)) {
            intent.putExtra(PickerConfig.SIZE_TYPE, str4);
        }
        if (!TextUtils.isEmpty(str5)) {
            intent.putExtra(PickerConfig.DOC_PATH, str5);
        }
        if (jSONObject != null && jSONObject.has("width") && jSONObject.has("height")) {
            Pattern compile = Pattern.compile("[^0-9]");
            try {
                int parseInt = Integer.parseInt(compile.matcher(jSONObject.optString("width")).replaceAll(""));
                int parseInt2 = Integer.parseInt(compile.matcher(jSONObject.optString("height")).replaceAll(""));
                if (parseInt > 0 && parseInt2 > 0) {
                    jSONObject.put("width", parseInt);
                    jSONObject.put("height", parseInt2);
                    intent.putExtra(PickerConfig.IMAGE_CROP, jSONObject.toString());
                    intent.putExtra(PickerConfig.MAX_SELECT_COUNT, 1);
                }
            } catch (Exception unused) {
            }
        }
        intent.putExtra(PickerConfig.IMAGE_EDITABLE, z);
        return intent;
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public void init(AbsMgr absMgr, String str) {
        this.g = absMgr;
    }

    public String[] mediasToJSONArray(ArrayList<Parcelable> arrayList) {
        String[] strArr = null;
        for (int i2 = 0; i2 < arrayList.size(); i2++) {
            Media media = (Media) arrayList.get(i2);
            if (strArr == null) {
                strArr = new String[arrayList.size()];
            }
            strArr[i2] = media.path;
        }
        return strArr;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void b(IWebview iWebview, String str, String[] strArr) {
        String str2;
        Exception e2;
        boolean z;
        String str3;
        JSONObject jSONObject;
        boolean z2;
        String str4;
        String str5;
        try {
            String str6 = strArr[0];
            try {
                IApp obtainApp = iWebview.obtainFrameView().obtainApp();
                try {
                    obtainApp.registerSysEventListener(new e(obtainApp, iWebview, str6), ISysEventListener.SysEventType.onActivityResult);
                    String str7 = "image/*";
                    if (!PdrUtil.isEmpty(strArr[1])) {
                        JSONObject createJSONObject = JSONUtil.createJSONObject(strArr[1]);
                        String string = JSONUtil.getString(createJSONObject, Constants.Name.FILTER);
                        if ("video".equals(string)) {
                            str7 = "video/*";
                        } else if ("none".equals(string)) {
                            str7 = "image/*|video/*";
                        }
                        str4 = createJSONObject.optString("confirmText");
                        boolean optBoolean = createJSONObject.optBoolean("editable", true);
                        JSONObject optJSONObject = createJSONObject.optJSONObject("crop");
                        String optString = createJSONObject.optString("sizeType");
                        z = createJSONObject.optBoolean("videoCompress", false);
                        jSONObject = optJSONObject;
                        str3 = optString;
                        z2 = optBoolean;
                    } else {
                        str4 = null;
                        jSONObject = null;
                        str3 = null;
                        z2 = true;
                        z = false;
                    }
                    new Intent("android.intent.action.PICK");
                    String str8 = str7 + "__Single__";
                    if (strArr.length > 2) {
                        String str9 = strArr[2];
                        a(iWebview.getActivity(), str9);
                        str5 = str9;
                    } else {
                        str5 = null;
                    }
                    iWebview.getActivity().startActivityForResult(getMediaPickerIntent(iWebview.getContext(), str8, 1, null, str4, z2, str5, jSONObject, str3, iWebview.obtainApp().convert2LocalFullPath(null, BaseInfo.REL_PRIVATE_DOC_DIR), z), e);
                } catch (Exception e3) {
                    e2 = e3;
                    str2 = str6;
                    e2.printStackTrace();
                    Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(12, e2.getMessage()), JSUtil.ERROR, true, false);
                }
            } catch (Exception e4) {
                e2 = e4;
                str2 = str6;
                e2.printStackTrace();
                Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(12, e2.getMessage()), JSUtil.ERROR, true, false);
            }
        } catch (Exception e5) {
            e2 = e5;
            str2 = null;
            e2.printStackTrace();
            Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(12, e2.getMessage()), JSUtil.ERROR, true, false);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void a(IWebview iWebview, String str, String[] strArr) {
        String str2;
        Exception e2;
        String str3;
        IApp obtainApp;
        boolean z;
        String str4;
        JSONObject jSONObject;
        boolean z2;
        JSONArray jSONArray;
        String str5;
        int i2;
        int i3;
        String str6;
        Exception e3;
        String str7;
        try {
            String str8 = strArr[0];
            try {
                obtainApp = iWebview.obtainFrameView().obtainApp();
            } catch (Exception e4) {
                e2 = e4;
                str3 = str8;
                str2 = str3;
                e2.printStackTrace();
                Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(12, e2.getMessage()), JSUtil.ERROR, true, false);
            }
            try {
                obtainApp.registerSysEventListener(new c(obtainApp, iWebview, str8), ISysEventListener.SysEventType.onActivityResult);
                Intent intent = new Intent();
                String str9 = "image/*";
                int i4 = -1;
                if (!PdrUtil.isEmpty(strArr[1])) {
                    try {
                        JSONObject createJSONObject = JSONUtil.createJSONObject(strArr[1]);
                        String string = JSONUtil.getString(createJSONObject, Constants.Name.FILTER);
                        if ("video".equals(string)) {
                            str9 = "video/*";
                        } else if ("none".equals(string)) {
                            str9 = "image/*|video/*";
                        }
                        i4 = createJSONObject.optInt("maximum", -1);
                        jSONArray = createJSONObject.optJSONArray("selected");
                        String optString = createJSONObject.optString("confirmText");
                        z2 = createJSONObject.optBoolean("editable", true);
                        jSONObject = createJSONObject.optJSONObject("crop");
                        str4 = createJSONObject.optString("sizeType");
                        z = createJSONObject.optBoolean("videoCompress", false);
                        str5 = optString;
                    } catch (Exception e5) {
                        e2 = e5;
                        str2 = str8;
                        e2.printStackTrace();
                        Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(12, e2.getMessage()), JSUtil.ERROR, true, false);
                    }
                } else {
                    str5 = null;
                    jSONArray = null;
                    z2 = true;
                    jSONObject = null;
                    str4 = null;
                    z = false;
                }
                intent.setType(str9);
                if (Build.VERSION.SDK_INT >= 19) {
                    intent.setAction("android.intent.action.OPEN_DOCUMENT");
                    intent.putExtra("android.intent.extra.ALLOW_MULTIPLE", true);
                    intent.addCategory("android.intent.category.OPENABLE");
                    i2 = d;
                    try {
                        if (strArr.length > 2) {
                            try {
                                str7 = strArr[2];
                                a(iWebview.getActivity(), str7);
                            } catch (Exception e6) {
                                e3 = e6;
                                str3 = str8;
                            }
                        } else {
                            str7 = null;
                        }
                        str3 = str8;
                        try {
                            intent = getMediaPickerIntent(iWebview.getContext(), str9, i4, jSONArray, str5, z2, str7, jSONObject, str4, iWebview.obtainApp().convert2LocalFullPath(null, BaseInfo.REL_PRIVATE_DOC_DIR), z);
                            try {
                                i3 = e;
                            } catch (Exception e7) {
                                e3 = e7;
                            }
                        } catch (Exception e8) {
                            e3 = e8;
                            intent = intent;
                            try {
                                e3.printStackTrace();
                                iWebview.getActivity().startActivityForResult(intent, i2);
                            } catch (Exception e9) {
                                e2 = e9;
                                str2 = str3;
                                e2.printStackTrace();
                                Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(12, e2.getMessage()), JSUtil.ERROR, true, false);
                            }
                        }
                    } catch (Exception e10) {
                        e3 = e10;
                        str3 = str8;
                        e3.printStackTrace();
                        iWebview.getActivity().startActivityForResult(intent, i2);
                    }
                } else {
                    if (strArr.length > 2) {
                        str6 = strArr[2];
                        intent.putExtra("_onMaxedId", str6);
                        a(iWebview.getActivity(), str6);
                    } else {
                        str6 = null;
                    }
                    intent = getMediaPickerIntent(iWebview.getContext(), str9, i4, jSONArray, str5, z2, str6, jSONObject, str4, iWebview.obtainApp().convert2LocalFullPath(null, BaseInfo.REL_PRIVATE_DOC_DIR), z);
                    i3 = e;
                }
                i2 = i3;
                iWebview.getActivity().startActivityForResult(intent, i2);
            } catch (Exception e11) {
                e2 = e11;
                str3 = str8;
                str2 = str3;
                e2.printStackTrace();
                Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(12, e2.getMessage()), JSUtil.ERROR, true, false);
            }
        } catch (Exception e12) {
            e2 = e12;
            str2 = null;
            e2.printStackTrace();
            Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(12, e2.getMessage()), JSUtil.ERROR, true, false);
        }
    }

    private void a(Activity activity, String str) {
        if ((activity instanceof IActivityHandler) && ((IActivityHandler) activity).isMultiProcessMode()) {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("io.dcloud.streamapp.Gallery.onMax." + str);
            d dVar = new d(activity);
            if (this.h == null) {
                this.h = new ArrayList<>();
            }
            this.h.add(dVar);
            LocalBroadcastManager.getInstance(activity).registerReceiver(dVar, intentFilter);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void a(IApp iApp, IWebview iWebview, String str, String[] strArr, boolean z) {
        String str2;
        boolean z2;
        String str3;
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("multiple", z);
        } catch (JSONException e2) {
            e2.printStackTrace();
        }
        JSONArray jSONArray = new JSONArray();
        if (strArr == null || strArr.length <= 0) {
            str2 = "User cancelled";
            z2 = false;
        } else {
            for (String str4 : strArr) {
                if (str4.startsWith("content://")) {
                    str3 = FileUtil.getPathFromUri(iApp.getActivity(), Uri.parse(str4));
                    if (!TextUtils.isEmpty(str3) && !str3.startsWith(DeviceInfo.FILE_PROTOCOL)) {
                        str3 = DeviceInfo.FILE_PROTOCOL + str3;
                    }
                } else {
                    str3 = iApp.convert2WebviewFullPath(null, str4);
                }
                jSONArray.put(str3);
            }
            try {
                jSONObject.put("files", jSONArray);
            } catch (JSONException e3) {
                e3.printStackTrace();
            }
            z2 = true;
            str2 = "pickImage path wrong";
        }
        if (z2) {
            JSUtil.execCallback(iWebview, str, jSONObject, JSUtil.OK, false);
        } else {
            Deprecated_JSUtil.execCallback(iWebview, str, DOMException.toJSON(12, str2), JSUtil.ERROR, true, false);
        }
    }
}
