package io.dcloud.js.camera;

import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.StrictMode;
import android.text.TextUtils;
import androidtranscoder.MediaTranscoder;
import androidtranscoder.format.MediaFormatStrategyPresets;
import androidx.core.content.FileProvider;
import com.dmcbig.mediapicker.entity.Media;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IFeature;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.util.ContentUriUtil;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.constant.DOMException;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.CompressUtil;
import io.dcloud.common.util.DCFileUriData;
import io.dcloud.common.util.Deprecated_JSUtil;
import io.dcloud.common.util.FileUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.ThreadPool;
import io.dcloud.feature.gallery.imageedit.IMGEditActivity;
import io.dcloud.js.camera.CameraFeatureImpl;
import io.dcloud.js.camera.a;
import java.io.File;
import java.io.IOException;
import org.json.JSONObject;

public class CameraFeatureImpl implements IFeature {
    AbsMgr a = null;

    class b extends PermissionUtil.StreamPermissionRequest {
        final /* synthetic */ String[] a;
        final /* synthetic */ IApp b;
        final /* synthetic */ IWebview c;
        final /* synthetic */ String d;

        class a implements ISysEventListener {
            final /* synthetic */ String a;
            final /* synthetic */ a.C0072a b;
            final /* synthetic */ String c;

            /* renamed from: io.dcloud.js.camera.CameraFeatureImpl$b$a$a  reason: collision with other inner class name */
            class C0071a implements MediaTranscoder.Listener {
                final /* synthetic */ Dialog a;

                C0071a(Dialog dialog) {
                    this.a = dialog;
                }

                @Override // androidtranscoder.MediaTranscoder.Listener
                public void onTranscodeCanceled() {
                    this.a.dismiss();
                    a aVar = a.this;
                    CameraFeatureImpl.this.a(aVar.b.h, aVar.a);
                    String json = DOMException.toJSON(-2, DOMException.MSG_USER_CANCEL);
                    b bVar = b.this;
                    Deprecated_JSUtil.execCallback(bVar.c, bVar.d, json, JSUtil.ERROR, true, false);
                }

                @Override // androidtranscoder.MediaTranscoder.Listener
                public void onTranscodeCompleted() {
                    this.a.dismiss();
                    a aVar = a.this;
                    CameraFeatureImpl.this.a(aVar.b.h, aVar.a);
                    a aVar2 = a.this;
                    String convert2RelPath = b.this.b.convert2RelPath(aVar2.c);
                    b bVar = b.this;
                    Deprecated_JSUtil.execCallback(bVar.c, bVar.d, convert2RelPath, JSUtil.OK, false, false);
                }

                @Override // androidtranscoder.MediaTranscoder.Listener
                public void onTranscodeFailed(Exception exc) {
                    this.a.dismiss();
                    a aVar = a.this;
                    CameraFeatureImpl.this.a(aVar.b.h, aVar.a);
                    String json = DOMException.toJSON(-99, exc.getMessage());
                    b bVar = b.this;
                    Deprecated_JSUtil.execCallback(bVar.c, bVar.d, json, JSUtil.ERROR, true, false);
                }

                @Override // androidtranscoder.MediaTranscoder.Listener
                public void onTranscodeProgress(double d) {
                }
            }

            a(String str, a.C0072a aVar, String str2) {
                this.a = str;
                this.b = aVar;
                this.c = str2;
            }

            @Override // io.dcloud.common.DHInterface.ISysEventListener
            public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
                Object[] objArr = (Object[]) obj;
                int intValue = ((Integer) objArr[0]).intValue();
                int intValue2 = ((Integer) objArr[1]).intValue();
                if (sysEventType == ISysEventListener.SysEventType.onActivityResult && intValue == a.b) {
                    if (intValue2 != -1) {
                        b bVar = b.this;
                        Deprecated_JSUtil.execCallback(bVar.c, bVar.d, null, JSUtil.ERROR, false, false);
                    } else if (new File(this.a).exists() || DHFile.copyFile(ContentUriUtil.getImageAbsolutePath(b.this.b.getActivity(), ((Intent) objArr[2]).getData()), this.a) == 1) {
                        Dialog dialog = null;
                        try {
                            if (this.b.h) {
                                Dialog a2 = b.a(b.this.c.getContext());
                                a2.show();
                                MediaTranscoder.getInstance().transcodeVideo(this.a, this.c, MediaFormatStrategyPresets.createAndroid720pStrategy(2, 1.0d), new C0071a(a2));
                            } else {
                                String convert2RelPath = b.this.b.convert2RelPath(this.c);
                                b bVar2 = b.this;
                                Deprecated_JSUtil.execCallback(bVar2.c, bVar2.d, convert2RelPath, JSUtil.OK, false, false);
                            }
                        } catch (IOException e) {
                            if (0 != 0) {
                                dialog.dismiss();
                            }
                            CameraFeatureImpl.this.a(this.b.h, this.a);
                            String json = DOMException.toJSON(-99, e.getMessage());
                            b bVar3 = b.this;
                            Deprecated_JSUtil.execCallback(bVar3.c, bVar3.d, json, JSUtil.ERROR, true, false);
                        }
                    } else {
                        b bVar4 = b.this;
                        Deprecated_JSUtil.execCallback(bVar4.c, bVar4.d, null, JSUtil.ERROR, false, false);
                        b.this.b.unregisterSysEventListener(this, sysEventType);
                        return false;
                    }
                    b.this.b.unregisterSysEventListener(this, sysEventType);
                }
                return false;
            }
        }

        /* JADX INFO: super call moved to the top of the method (can break code semantics) */
        b(IApp iApp, String[] strArr, IApp iApp2, IWebview iWebview, String str) {
            super(iApp);
            this.a = strArr;
            this.b = iApp2;
            this.c = iWebview;
            this.d = str;
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onDenied(String str) {
            Deprecated_JSUtil.execCallback(this.c, this.d, DOMException.toJSON(11, DOMException.MSG_NO_PERMISSION), JSUtil.ERROR, true, false);
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onGranted(String str) {
            String str2;
            try {
                a.C0072a a2 = a.a(this.a[1], false);
                String convert2AbsFullPath = this.b.convert2AbsFullPath(this.c.obtainFullUrl(), a2.a());
                if (JSUtil.checkOperateDirErrorAndCallback(this.c, this.d, convert2AbsFullPath)) {
                    Deprecated_JSUtil.execCallback(this.c, this.d, DOMException.toJSON(-5, DOMException.MSG_IO_ERROR), JSUtil.ERROR, true, false);
                    return;
                }
                if (a2.h) {
                    str2 = convert2AbsFullPath + ".temp";
                } else {
                    str2 = convert2AbsFullPath;
                }
                File file = new File(str2);
                File parentFile = file.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                this.b.registerSysEventListener(new a(str2, a2, convert2AbsFullPath), ISysEventListener.SysEventType.onActivityResult);
                Intent intent = new Intent("android.media.action.VIDEO_CAPTURE");
                if (a2.b() != 0) {
                    intent.putExtra("android.intent.extra.durationLimit", a2.b());
                }
                if (Build.VERSION.SDK_INT >= 29) {
                    intent.putExtra("output", FileProvider.getUriForFile(this.c.getContext(), this.c.getContext().getPackageName() + ".dc.fileprovider", file));
                }
                this.c.getActivity().startActivityForResult(intent, a.b);
            } catch (Exception e2) {
                Deprecated_JSUtil.execCallback(this.c, this.d, DOMException.toJSON(11, e2.getMessage()), JSUtil.ERROR, true, false);
            }
        }
    }

    class c extends PermissionUtil.StreamPermissionRequest {
        final /* synthetic */ a a;
        final /* synthetic */ String[] b;
        final /* synthetic */ IWebview c;

        /* JADX INFO: super call moved to the top of the method (can break code semantics) */
        c(IApp iApp, a aVar, String[] strArr, IWebview iWebview) {
            super(iApp);
            this.a = aVar;
            this.b = strArr;
            this.c = iWebview;
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onDenied(String str) {
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onGranted(String str) {
            this.a.b();
            String[] strArr = this.b;
            if (strArr.length >= 3) {
                Deprecated_JSUtil.execCallback(this.c, strArr[2], this.a.a(), JSUtil.OK, true, false);
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public void dispose(String str) {
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public String execute(IWebview iWebview, String str, String[] strArr) {
        IApp obtainApp = iWebview.obtainFrameView().obtainApp();
        Context context = iWebview.getContext();
        AppRuntime.checkPrivacyComplianceAndPrompt(context, "Camera-" + str);
        String str2 = strArr[0];
        if (Build.VERSION.SDK_INT >= 24) {
            StrictMode.setVmPolicy(new StrictMode.VmPolicy.Builder().build());
        }
        if (str.equals("captureImage")) {
            a.C0072a a2 = a.a(strArr[1], true);
            String convert2AbsFullPath = obtainApp.convert2AbsFullPath(iWebview.obtainFullUrl(), a2.a());
            if (FileUtil.checkPrivatePath(iWebview.getContext(), convert2AbsFullPath) || FileUtil.getPathForPublicType(convert2AbsFullPath) != null) {
                PermissionUtil.usePermission(obtainApp.getActivity(), "camera", PermissionUtil.PMS_CAMERA, 2, new a(obtainApp, iWebview, str2, convert2AbsFullPath, a2, obtainApp));
            } else {
                Deprecated_JSUtil.execCallback(iWebview, str2, DOMException.toJSON(-5, DOMException.MSG_PATH_NOT_PRIVATE_ERROR), JSUtil.ERROR, true, false);
                return null;
            }
        } else if (str.equals("startVideoCapture")) {
            PermissionUtil.usePermission(obtainApp.getActivity(), "camera", PermissionUtil.PMS_CAMERA, 2, new b(obtainApp, strArr, obtainApp, iWebview, str2));
        } else if (str.equals("getCamera")) {
            a aVar = new a(PdrUtil.parseInt(strArr[1], 1));
            if (PermissionUtil.checkSelfPermission(obtainApp.getActivity(), "android.permission.CAMERA") == 0) {
                aVar.b();
                return aVar.a();
            }
            PermissionUtil.usePermission(obtainApp.getActivity(), "camera", PermissionUtil.PMS_CAMERA, 2, new c(obtainApp, aVar, strArr, iWebview));
        }
        return null;
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public void init(AbsMgr absMgr, String str) {
        this.a = absMgr;
    }

    class a extends PermissionUtil.StreamPermissionRequest {
        final /* synthetic */ IWebview a;
        final /* synthetic */ String b;
        final /* synthetic */ String c;
        final /* synthetic */ a.C0072a d;
        final /* synthetic */ IApp e;

        /* JADX INFO: super call moved to the top of the method (can break code semantics) */
        a(IApp iApp, IWebview iWebview, String str, String str2, a.C0072a aVar, IApp iApp2) {
            super(iApp);
            this.a = iWebview;
            this.b = str;
            this.c = str2;
            this.d = aVar;
            this.e = iApp2;
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onDenied(String str) {
            Deprecated_JSUtil.execCallback(this.a, this.b, DOMException.toJSON(11, DOMException.MSG_NO_PERMISSION), JSUtil.ERROR, true, false);
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onGranted(String str) {
            try {
                if (JSUtil.checkOperateDirErrorAndCallback(this.a, this.b, this.c)) {
                    Deprecated_JSUtil.execCallback(this.a, this.b, DOMException.toJSON(-5, DOMException.MSG_IO_ERROR), JSUtil.ERROR, true, false);
                    return;
                }
                File file = new File(this.c);
                File parentFile = file.getParentFile();
                if (!parentFile.exists()) {
                    parentFile.mkdirs();
                }
                Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
                DCFileUriData shareImageUri = FileUtil.getShareImageUri(this.a.getContext(), file, this.d.a(), intent);
                this.e.registerSysEventListener(new C0066a(shareImageUri), ISysEventListener.SysEventType.onActivityResult);
                intent.putExtra("output", shareImageUri.fileUri);
                this.a.getActivity().startActivityForResult(intent, a.a);
            } catch (Exception e2) {
                Deprecated_JSUtil.execCallback(this.a, this.b, DOMException.toJSON(11, e2.getMessage()), JSUtil.ERROR, true, false);
            }
        }

        /* renamed from: io.dcloud.js.camera.CameraFeatureImpl$a$a  reason: collision with other inner class name */
        class C0066a implements ISysEventListener {
            final /* synthetic */ DCFileUriData a;

            C0066a(DCFileUriData dCFileUriData) {
                this.a = dCFileUriData;
            }

            @Override // io.dcloud.common.DHInterface.ISysEventListener
            public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
                Object[] objArr = (Object[]) obj;
                int intValue = ((Integer) objArr[0]).intValue();
                int intValue2 = ((Integer) objArr[1]).intValue();
                if (sysEventType == ISysEventListener.SysEventType.onActivityResult && intValue == a.a) {
                    if (intValue2 == -1) {
                        ThreadPool.self().addThreadTask(new RunnableC0067a());
                    } else {
                        String json = DOMException.toJSON(11, "resultCode is wrong");
                        a aVar = a.this;
                        Deprecated_JSUtil.execCallback(aVar.a, aVar.b, json, JSUtil.ERROR, true, false);
                    }
                    a.this.e.unregisterSysEventListener(this, sysEventType);
                }
                return false;
            }

            /* renamed from: io.dcloud.js.camera.CameraFeatureImpl$a$a$a  reason: collision with other inner class name */
            class RunnableC0067a implements Runnable {

                /* renamed from: io.dcloud.js.camera.CameraFeatureImpl$a$a$a$a  reason: collision with other inner class name */
                class RunnableC0068a implements Runnable {
                    RunnableC0068a() {
                    }

                    public void run() {
                        String json = DOMException.toJSON(-5, DOMException.MSG_IO_ERROR);
                        a aVar = a.this;
                        Deprecated_JSUtil.execCallback(aVar.a, aVar.b, json, JSUtil.ERROR, true, false);
                    }
                }

                /* renamed from: io.dcloud.js.camera.CameraFeatureImpl$a$a$a$b */
                class b implements Runnable {
                    b() {
                    }

                    public void run() {
                        String json = DOMException.toJSON(-5, DOMException.MSG_IO_ERROR);
                        a aVar = a.this;
                        Deprecated_JSUtil.execCallback(aVar.a, aVar.b, json, JSUtil.ERROR, true, false);
                    }
                }

                /* renamed from: io.dcloud.js.camera.CameraFeatureImpl$a$a$a$c */
                class c implements ISysEventListener {
                    final /* synthetic */ String a;

                    /* renamed from: io.dcloud.js.camera.CameraFeatureImpl$a$a$a$c$a  reason: collision with other inner class name */
                    class RunnableC0069a implements Runnable {

                        /* renamed from: io.dcloud.js.camera.CameraFeatureImpl$a$a$a$c$a$a  reason: collision with other inner class name */
                        class RunnableC0070a implements Runnable {
                            RunnableC0070a() {
                            }

                            public void run() {
                                c cVar = c.this;
                                a aVar = a.this;
                                Deprecated_JSUtil.execCallback(aVar.a, aVar.b, cVar.a, JSUtil.OK, false, false);
                            }
                        }

                        RunnableC0069a() {
                        }

                        public void run() {
                            a.this.e.getActivity().runOnUiThread(new RunnableC0070a());
                        }
                    }

                    c(String str) {
                        this.a = str;
                    }

                    @Override // io.dcloud.common.DHInterface.ISysEventListener
                    public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
                        Object[] objArr = (Object[]) obj;
                        int intValue = ((Integer) objArr[0]).intValue();
                        int intValue2 = ((Integer) objArr[1]).intValue();
                        if (sysEventType == ISysEventListener.SysEventType.onActivityResult && intValue == a.c) {
                            if (intValue2 == -1) {
                                ThreadPool.self().addThreadTask(new RunnableC0069a());
                            } else {
                                String json = DOMException.toJSON(11, "resultCode is wrong");
                                a aVar = a.this;
                                Deprecated_JSUtil.execCallback(aVar.a, aVar.b, json, JSUtil.ERROR, true, false);
                            }
                            a.this.e.unregisterSysEventListener(this, sysEventType);
                        }
                        return false;
                    }
                }

                RunnableC0067a() {
                }

                /* access modifiers changed from: private */
                public static /* synthetic */ void a(a.C0072a aVar, String str, IApp iApp, IWebview iWebview, String str2, String str3) {
                    if (aVar.h) {
                        CompressUtil.compressImage(str, str, false, iApp.getActivity());
                    }
                    iApp.getActivity().runOnUiThread(new Runnable(str2, str3) {
                        /* class io.dcloud.js.camera.$$Lambda$CameraFeatureImpl$a$a$a$gDnxNnI07kpyxHgrhs8Mg5WBwKA */
                        public final /* synthetic */ String f$1;
                        public final /* synthetic */ String f$2;

                        {
                            this.f$1 = r2;
                            this.f$2 = r3;
                        }

                        public final void run() {
                            CameraFeatureImpl.a.C0066a.RunnableC0067a.lambda$gDnxNnI07kpyxHgrhs8Mg5WBwKA(IWebview.this, this.f$1, this.f$2);
                        }
                    });
                }

                public void run() {
                    String str;
                    String str2;
                    DCFileUriData dCFileUriData = C0066a.this.a;
                    if (dCFileUriData.isReplace) {
                        if (DHFile.copyFile(dCFileUriData.fileReplacePath, dCFileUriData.filePath, true, false) != 1) {
                            a.this.e.getActivity().runOnUiThread(new RunnableC0068a());
                            return;
                        }
                        try {
                            DHFile.deleteFile(C0066a.this.a.fileReplacePath);
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    C0066a aVar = C0066a.this;
                    a aVar2 = a.this;
                    if (aVar2.d.e) {
                        str2 = b.a(aVar.a.filePath);
                        if (TextUtils.isEmpty(str2)) {
                            a.this.e.getActivity().runOnUiThread(new b());
                            return;
                        }
                        str = a.this.e.convert2RelPath(str2);
                    } else {
                        str = aVar2.e.convert2RelPath(aVar.a.filePath);
                        str2 = C0066a.this.a.filePath;
                    }
                    JSONObject jSONObject = a.this.d.g;
                    if (jSONObject == null || !jSONObject.has("width") || !a.this.d.g.has("height")) {
                        C0066a.this.a.clear();
                        ThreadPool self = ThreadPool.self();
                        a aVar3 = a.this;
                        self.addThreadTask(new Runnable(str2, aVar3.e, aVar3.a, aVar3.b, str) {
                            /* class io.dcloud.js.camera.$$Lambda$CameraFeatureImpl$a$a$a$H7AuhLD7YZIKZiAKNggjJT8M2BQ */
                            public final /* synthetic */ String f$1;
                            public final /* synthetic */ IApp f$2;
                            public final /* synthetic */ IWebview f$3;
                            public final /* synthetic */ String f$4;
                            public final /* synthetic */ String f$5;

                            {
                                this.f$1 = r2;
                                this.f$2 = r3;
                                this.f$3 = r4;
                                this.f$4 = r5;
                                this.f$5 = r6;
                            }

                            public final void run() {
                                CameraFeatureImpl.a.C0066a.RunnableC0067a.lambda$H7AuhLD7YZIKZiAKNggjJT8M2BQ(a.C0072a.this, this.f$1, this.f$2, this.f$3, this.f$4, this.f$5);
                            }
                        });
                        return;
                    }
                    Media media = new Media(C0066a.this.a.filePath, "", System.currentTimeMillis(), 1, 1, -1001, new File(C0066a.this.a.filePath).getParent());
                    Intent intent = new Intent(a.this.e.getActivity(), IMGEditActivity.class);
                    intent.putExtra("IMAGE_URI", Uri.parse(DeviceInfo.FILE_PROTOCOL + media.path));
                    intent.putExtra("IMAGE_MEDIA_ID", media.id);
                    intent.putExtra("IMAGE_INDEX", 0);
                    intent.putExtra("IMAGE_CROP", a.this.d.g.toString());
                    intent.putExtra("IMAGE_SAVE_PATH", media.path);
                    a.this.e.registerSysEventListener(new c(str), ISysEventListener.SysEventType.onActivityResult);
                    C0066a.this.a.clear();
                    a.this.e.getActivity().startActivityForResult(intent, a.c);
                    a.this.e.getActivity().overridePendingTransition(0, 0);
                }

                /* access modifiers changed from: private */
                public static /* synthetic */ void a(IWebview iWebview, String str, String str2) {
                    Deprecated_JSUtil.execCallback(iWebview, str, str2, JSUtil.OK, false, false);
                }
            }
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void a(boolean z, String str) {
        if (z) {
            try {
                if (str.endsWith(".temp")) {
                    new File(str).delete();
                }
            } catch (Exception unused) {
            }
        }
    }
}
