package io.dcloud.feature.weex_websocket;

import android.os.Looper;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.appfram.websocket.IWebSocketAdapter;
import com.taobao.weex.appfram.websocket.WebSocketCloseCodes;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.ui.component.WXBasicComponentType;
import com.taobao.weex.utils.WXLogUtils;
import java.util.HashMap;
import java.util.Map;

public class UniWebSocketModule extends WXSDKEngine.DestroyableModule {
    private static final String KEY_CODE = "code";
    private static final String KEY_DATA = "data";
    private static final String KEY_ID = "id";
    private static final String KEY_REASON = "reason";
    private static final String KEY_WAS_CLEAN = "wasClean";
    private static final String TAG = "WebSocketModule";
    private JSCallback callback_onclose;
    private JSCallback callback_onerror;
    private JSCallback callback_onmessage;
    private JSCallback callback_onopen;
    private String currentId;
    private Map<String, IWebSocketAdapter> webSocketAdapterMap;
    private Map<String, WebSocketEventListener> webSocketEventListenerMap;

    public UniWebSocketModule() {
        WXLogUtils.e(TAG, "create new instance");
    }

    @JSMethod(uiThread = false)
    public void WebSocket(String str) {
        if (!TextUtils.isEmpty(str)) {
            try {
                JSONObject parseObject = JSON.parseObject(new String(str.getBytes(), "utf-8"));
                String string = parseObject.getString("id");
                String string2 = parseObject.getString("url");
                String string3 = parseObject.getString("protocol");
                String string4 = parseObject.getString(WXBasicComponentType.HEADER);
                if (this.webSocketAdapterMap == null) {
                    this.webSocketAdapterMap = new HashMap();
                    this.webSocketEventListenerMap = new HashMap();
                }
                if (this.webSocketAdapterMap.get(string) == null || this.webSocketEventListenerMap.get(string) == null) {
                    if (this.webSocketAdapterMap.get(string) != null && this.webSocketEventListenerMap.get(string) == null) {
                        this.webSocketAdapterMap.remove(string);
                    }
                    IWebSocketAdapter wXWebSocketAdapter = this.mWXSDKInstance.getWXWebSocketAdapter();
                    WebSocketEventListener webSocketEventListener = new WebSocketEventListener(string);
                    webSocketEventListener.onOpen = this.callback_onopen;
                    webSocketEventListener.onMessage = this.callback_onmessage;
                    webSocketEventListener.onClose = this.callback_onclose;
                    webSocketEventListener.onError = this.callback_onerror;
                    wXWebSocketAdapter.connect(string2, string3, string4, webSocketEventListener);
                    this.webSocketEventListenerMap.put(string, webSocketEventListener);
                    this.currentId = string;
                    this.webSocketAdapterMap.put(string, wXWebSocketAdapter);
                }
            } catch (Exception e) {
                WXLogUtils.e("[UniWebSocketModule] alert param parse error ", e);
            }
        }
    }

    @JSMethod(uiThread = false)
    public void send(String str) {
        if (!TextUtils.isEmpty(str)) {
            try {
                JSONObject parseObject = JSON.parseObject(new String(str.getBytes(), "utf-8"));
                String string = parseObject.getString("id");
                this.webSocketAdapterMap.get(string).send(parseObject.getString("data"));
            } catch (Exception e) {
                WXLogUtils.e("[UniWebSocketModule] alert param parse error ", e);
            }
        }
    }

    @JSMethod(uiThread = false)
    public void close(String str) {
        if (!TextUtils.isEmpty(str)) {
            try {
                JSONObject parseObject = JSON.parseObject(new String(str.getBytes(), "utf-8"));
                String string = parseObject.getString("id");
                String string2 = parseObject.getString("code");
                String string3 = parseObject.getString(KEY_REASON);
                int code = WebSocketCloseCodes.CLOSE_NORMAL.getCode();
                if (string2 != null) {
                    try {
                        code = Integer.parseInt(string2);
                    } catch (NumberFormatException unused) {
                    }
                }
                this.webSocketAdapterMap.get(string).close(code, string3);
            } catch (Exception e) {
                WXLogUtils.e("[UniWebSocketModule] alert param parse error ", e);
            }
        }
    }

    @JSMethod(uiThread = false)
    public void onopen(JSCallback jSCallback) {
        this.callback_onopen = jSCallback;
        Map<String, WebSocketEventListener> map = this.webSocketEventListenerMap;
        if (map != null) {
            for (Map.Entry<String, WebSocketEventListener> entry : map.entrySet()) {
                entry.getValue().onOpen = this.callback_onopen;
            }
        }
    }

    @JSMethod(uiThread = false)
    public void onmessage(JSCallback jSCallback) {
        this.callback_onmessage = jSCallback;
        Map<String, WebSocketEventListener> map = this.webSocketEventListenerMap;
        if (map != null) {
            for (Map.Entry<String, WebSocketEventListener> entry : map.entrySet()) {
                entry.getValue().onMessage = this.callback_onmessage;
            }
        }
    }

    @JSMethod(uiThread = false)
    public void onclose(JSCallback jSCallback) {
        this.callback_onclose = jSCallback;
        Map<String, WebSocketEventListener> map = this.webSocketEventListenerMap;
        if (map != null) {
            for (Map.Entry<String, WebSocketEventListener> entry : map.entrySet()) {
                entry.getValue().onClose = this.callback_onclose;
            }
        }
    }

    @JSMethod(uiThread = false)
    public void onerror(JSCallback jSCallback) {
        this.callback_onerror = jSCallback;
        Map<String, WebSocketEventListener> map = this.webSocketEventListenerMap;
        if (map != null) {
            for (Map.Entry<String, WebSocketEventListener> entry : map.entrySet()) {
                entry.getValue().onError = this.callback_onerror;
            }
        }
    }

    @Override // com.taobao.weex.common.Destroyable
    public void destroy() {
        AnonymousClass1 r0 = new Runnable() {
            /* class io.dcloud.feature.weex_websocket.UniWebSocketModule.AnonymousClass1 */

            public void run() {
                WXLogUtils.w(UniWebSocketModule.TAG, "close session with instance id " + UniWebSocketModule.this.mWXSDKInstance.getInstanceId());
                if (UniWebSocketModule.this.webSocketAdapterMap != null) {
                    for (Map.Entry entry : UniWebSocketModule.this.webSocketAdapterMap.entrySet()) {
                        ((IWebSocketAdapter) entry.getValue()).destroy();
                    }
                    UniWebSocketModule.this.webSocketAdapterMap.clear();
                    UniWebSocketModule.this.webSocketAdapterMap = null;
                }
                if (UniWebSocketModule.this.webSocketEventListenerMap != null) {
                    UniWebSocketModule.this.webSocketEventListenerMap.clear();
                }
                UniWebSocketModule.this.webSocketEventListenerMap = null;
            }
        };
        if (Looper.myLooper() == Looper.getMainLooper()) {
            WXBridgeManager.getInstance().post(r0);
        } else {
            r0.run();
        }
    }

    /* access modifiers changed from: private */
    public class WebSocketEventListener implements IWebSocketAdapter.EventListener {
        private String id;
        private JSCallback onClose;
        private JSCallback onError;
        private JSCallback onMessage;
        private JSCallback onOpen;

        public WebSocketEventListener(String str) {
            this.id = str;
        }

        @Override // com.taobao.weex.appfram.websocket.IWebSocketAdapter.EventListener
        public void onOpen() {
            if (this.onOpen != null) {
                HashMap hashMap = new HashMap();
                hashMap.put("id", this.id);
                this.onOpen.invokeAndKeepAlive(hashMap);
            }
        }

        @Override // com.taobao.weex.appfram.websocket.IWebSocketAdapter.EventListener
        public void onMessage(String str) {
            if (this.onMessage != null) {
                HashMap hashMap = new HashMap(2);
                hashMap.put("id", this.id);
                try {
                    JSONObject parseObject = JSON.parseObject(str);
                    if (!parseObject.containsKey("@type") || !parseObject.containsKey("base64")) {
                        hashMap.put("data", str);
                    } else {
                        hashMap.put("data", parseObject);
                    }
                } catch (Exception unused) {
                    hashMap.put("data", str);
                }
                this.onMessage.invokeAndKeepAlive(hashMap);
            }
        }

        @Override // com.taobao.weex.appfram.websocket.IWebSocketAdapter.EventListener
        public void onClose(int i, String str, boolean z) {
            if (this.onClose != null) {
                HashMap hashMap = new HashMap(4);
                hashMap.put("id", this.id);
                hashMap.put("code", Integer.valueOf(i));
                hashMap.put(UniWebSocketModule.KEY_REASON, str);
                hashMap.put(UniWebSocketModule.KEY_WAS_CLEAN, Boolean.valueOf(z));
                this.onClose.invokeAndKeepAlive(hashMap);
                if (UniWebSocketModule.this.webSocketEventListenerMap != null) {
                    UniWebSocketModule.this.webSocketEventListenerMap.remove(this.id);
                }
            }
        }

        @Override // com.taobao.weex.appfram.websocket.IWebSocketAdapter.EventListener
        public void onError(String str) {
            if (this.onError != null) {
                HashMap hashMap = new HashMap(2);
                hashMap.put("id", this.id);
                hashMap.put("data", str);
                this.onError.invokeAndKeepAlive(hashMap);
                if (UniWebSocketModule.this.webSocketEventListenerMap != null) {
                    UniWebSocketModule.this.webSocketEventListenerMap.remove(this.id);
                }
            }
        }
    }
}
