package io.dcloud.feature.weex_media;

import android.content.Context;
import android.graphics.Canvas;
import android.net.Uri;
import android.text.TextUtils;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.bumptech.glide.Glide;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.Constants;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.util.FileUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.feature.weex.adapter.ScalableViewComponent;
import io.dcloud.feature.weex_media.option.EnumPlayStrategy;
import io.dcloud.media.weex.weex_video.ijkplayer.OnPlayerChangedListener;
import io.dcloud.media.weex.weex_video.ijkplayer.media.AssetsDataSourceProvider;
import io.dcloud.media.weex.weex_video.ijkplayer.media.IjkPlayerView;
import java.util.HashMap;
import java.util.Map;
import tv.danmaku.ijk.media.player.IMediaPlayer;

public class VideoPlayerView extends FrameLayout implements IMediaPlayer.OnInfoListener, OnPlayerChangedListener, IMediaPlayer.OnBufferingUpdateListener {
    private boolean autoplay = false;
    private float duration = -1.0f;
    private float initialTime = 0.0f;
    private boolean isCreate = false;
    private boolean isEnableDanmu = false;
    private boolean isEnableDanmuBtn = false;
    private boolean isFinishLayout = false;
    private boolean loop = false;
    private VideoComponent mComponent;
    private Context mContext;
    private String mHeader = "";
    public boolean mIsFullScreen = false;
    public IjkPlayerView mPlayerView;
    private String mSrc = "";
    private String poster = "";
    private int seek = 0;
    private FrameLayout subViewContainer;

    public interface IOnPlayerViewChangeListener {
        void onChanged(boolean z);
    }

    public VideoPlayerView(Context context, VideoComponent videoComponent) {
        super(context);
        this.mContext = context;
        this.mComponent = videoComponent;
        FrameLayout frameLayout = new FrameLayout(context);
        this.subViewContainer = frameLayout;
        addView(frameLayout, new FrameLayout.LayoutParams(-1, -1));
        createVideoView();
        this.subViewContainer.bringToFront();
        this.mPlayerView.setChangeListener(new IOnPlayerViewChangeListener() {
            /* class io.dcloud.feature.weex_media.VideoPlayerView.AnonymousClass1 */

            @Override // io.dcloud.feature.weex_media.VideoPlayerView.IOnPlayerViewChangeListener
            public void onChanged(boolean z) {
                VideoPlayerView.this.mIsFullScreen = z;
            }
        });
        if (videoComponent.getInstance().isFrameViewShow()) {
            this.mPlayerView.setVideoVisibility();
        } else {
            videoComponent.getInstance().addFrameViewEventListener(new WXSDKInstance.FrameViewEventListener() {
                /* class io.dcloud.feature.weex_media.VideoPlayerView.AnonymousClass2 */

                @Override // com.taobao.weex.WXSDKInstance.FrameViewEventListener
                public void onShowAnimationEnd() {
                    if (VideoPlayerView.this.mPlayerView != null) {
                        VideoPlayerView.this.mPlayerView.setVideoVisibility();
                    }
                    if (VideoPlayerView.this.mComponent != null && VideoPlayerView.this.mComponent.getInstance() != null) {
                        VideoPlayerView.this.mComponent.getInstance().removeFrameViewEventListener(this);
                    }
                }
            });
        }
    }

    public void createVideoView() {
        if (!this.isCreate) {
            this.isCreate = true;
            IjkPlayerView ijkPlayerView = new IjkPlayerView(this.mContext, null, this);
            this.mPlayerView = ijkPlayerView;
            ijkPlayerView.setComponent(this.mComponent);
            addView(this.mPlayerView, new FrameLayout.LayoutParams(-1, -1));
            this.mPlayerView.init().setPlayerRootView(this);
            this.mPlayerView.setOnInfoListener(this);
            this.mPlayerView.setOnPlayerChangedListener(this);
            this.mPlayerView.setOnBufferingUpdateListener(this);
        }
    }

    public ViewGroup getPlayerView() {
        return this.subViewContainer;
    }

    /* access modifiers changed from: protected */
    public void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (PdrUtil.isEmpty(this.mComponent.getStyles().getBackgroundColor())) {
            setBackgroundColor(-16777216);
        }
    }

    public synchronized void onLayoutFinished(String str) {
        Uri videoFileUri;
        if (this.mPlayerView != null) {
            if (!TextUtils.isEmpty(this.mSrc) || !TextUtils.isEmpty(str)) {
                AssetsDataSourceProvider assetsDataSourceProvider = null;
                if (!TextUtils.isEmpty(str) && !PdrUtil.isNetPath(str)) {
                    str = this.mComponent.getInstance().rewriteUri(Uri.parse(str), "video").getPath();
                    if (str != null && !PdrUtil.isDeviceRootDir(str)) {
                        try {
                            if (this.mComponent.getIApp() != null) {
                                if (!str.startsWith("/")) {
                                    str = "/" + str;
                                }
                                str = this.mComponent.getInstance().rewriteUri(Uri.parse(this.mComponent.getIApp().checkPrivateDirAndCopy2Temp(str)), "video").getPath();
                            } else {
                                if (str.startsWith("/")) {
                                    str = str.replaceFirst("/", "");
                                }
                                assetsDataSourceProvider = new AssetsDataSourceProvider(this.mComponent.getContext().getAssets().openFd(str));
                            }
                        } catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    if (!FileUtil.checkPrivatePath(getContext(), str) && (videoFileUri = FileUtil.getVideoFileUri(getContext(), str)) != null) {
                        str = videoFileUri.toString();
                    }
                }
                if (TextUtils.isEmpty(this.mSrc)) {
                    if (assetsDataSourceProvider == null) {
                        this.mPlayerView.setVideoPath(str);
                    } else {
                        this.mPlayerView.setVideoFileDescriptor(assetsDataSourceProvider);
                    }
                    this.mPlayerView.clearDanma();
                } else if (!this.mSrc.equalsIgnoreCase(str)) {
                    if (assetsDataSourceProvider == null) {
                        this.mPlayerView.switchVideoPath(str);
                    } else {
                        this.mPlayerView.switchVideoFileDescriptor(assetsDataSourceProvider);
                    }
                    this.mPlayerView.clearDanma();
                    IjkPlayerView ijkPlayerView = this.mPlayerView;
                    ijkPlayerView.setMutePlayer(ijkPlayerView.isMutePlayer());
                }
                this.mSrc = str;
                this.mPlayerView.setDuration((int) this.duration);
                float f = this.initialTime;
                if (f > 0.0f) {
                    this.mPlayerView.seekTo((int) f);
                }
                this.mPlayerView.enableDanmaku(this.isEnableDanmu);
                this.mPlayerView.enableDanmuBtn(this.isEnableDanmuBtn);
                this.isFinishLayout = true;
                if (this.autoplay) {
                    play();
                }
            }
        }
    }

    public void requestFullScreen(int i) {
        if (PdrUtil.isEmpty(Integer.valueOf(i))) {
            i = 90;
        }
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.fullScreen(i);
        }
    }

    public void exitFullScreen() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.exitFullScreen();
        }
    }

    public void play() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.start();
        }
    }

    public void pause() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.pause();
        }
    }

    public void resume() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.onResume();
        }
    }

    public void stop() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.stop();
        }
    }

    public void seek(int i) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            this.seek = i;
            ijkPlayerView.seekTo(i);
        }
    }

    public void sendDanmu(JSONObject jSONObject) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.sendDanmaku(new org.json.JSONObject(jSONObject), true);
        }
    }

    public void sendPlayBackRate(String str) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.playbackRate(str);
        }
    }

    public void destory() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.onDestroy();
            this.mPlayerView = null;
        }
    }

    public void setSrc(String str) {
        if (!TextUtils.isEmpty(str) && this.isFinishLayout) {
            onLayoutFinished(str);
        }
    }

    public void setHeader(String str) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setHeader(str);
            if (this.isFinishLayout) {
                onLayoutFinished("");
            }
        }
    }

    public void onActivityResume() {
        if (!TextUtils.isEmpty(this.poster)) {
            Glide.with(this).load(this.poster).into(this.mPlayerView.mPlayerThumb);
        }
    }

    public void setAutoplay(boolean z) {
        this.autoplay = z;
    }

    public void setLoop(boolean z) {
        this.loop = z;
    }

    public void setPoster(String str) {
        if (this.mPlayerView != null && !TextUtils.isEmpty(str) && !this.poster.equalsIgnoreCase(str)) {
            Glide.with(this).load(str).into(this.mPlayerView.mPlayerThumb);
            this.poster = str;
        }
    }

    public void setProgress(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setProgressVisibility(z);
        }
    }

    public void setPlayBtnVisibility(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setPlayBntVisibility(z);
        }
    }

    public void setMuted(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setMutePlayer(z);
        }
    }

    public void setControls(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setControls(z);
        }
    }

    public void setPageGesture(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setPageGesture(z);
        }
    }

    public void setLockScreen(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setIsShowScreenLockButton(z);
        }
    }

    public void setEnablePlayGesture(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setmIsDoubleTapEnable(z);
        }
    }

    public void setFullScreenPageGesture(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setFullScreenPageGesture(z);
        }
    }

    public void setShowFullScreenBtn(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setFullscreenBntVisibility(z);
        }
    }

    public void setEnableProgressGesture(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setIsEnableProgressGesture(z);
        }
    }

    public void setDirection(int i) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setDirection(i);
        }
    }

    public void setEnableDanmu(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            this.isEnableDanmu = z;
            ijkPlayerView.enableDanmaku(z);
        }
    }

    public void setDanmuBtn(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            this.isEnableDanmuBtn = z;
            ijkPlayerView.enableDanmuBtn(z);
        }
    }

    public void setDanmuList(JSONArray jSONArray) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setmDanmuList(jSONArray.toString());
        }
    }

    public void setObjectFit(String str) {
        IjkPlayerView ijkPlayerView;
        if (!TextUtils.isEmpty(str) && (ijkPlayerView = this.mPlayerView) != null) {
            ijkPlayerView.setScaleType(str);
        }
    }

    public void setMuteBtn(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.isMuteBtnShow(z);
        }
    }

    public void setTitle(String str) {
        IjkPlayerView ijkPlayerView;
        if (!PdrUtil.isEmpty(str) && (ijkPlayerView = this.mPlayerView) != null) {
            ijkPlayerView.setTitle(str);
        }
    }

    public void setHttpCacheEnable(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setHttpCacheEnable(z);
        }
    }

    public void setFlowStrategy(EnumPlayStrategy enumPlayStrategy) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setFlowStrategy(enumPlayStrategy);
        }
    }

    public void setShowLoading(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setLoadingVisibility(z);
        }
    }

    public void setPlayBtnPosition(String str) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setPlayBtnPosition(str);
        }
    }

    public void setShowCenterPlayBtn(boolean z) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.setCenterPlayBtnVisibility(z);
        }
    }

    public void setCodec(String str) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            ijkPlayerView.isUseMediaCodec(str.equals("hardware"));
        }
    }

    public void setDuration(float f) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null) {
            float f2 = f * 1000.0f;
            this.duration = f2;
            if (this.isFinishLayout) {
                ijkPlayerView.setDuration((int) f2);
            }
        }
    }

    public void setInitialTime(float f) {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        if (ijkPlayerView != null && f > 0.0f) {
            float f2 = f * 1000.0f;
            this.initialTime = f2;
            if (this.isFinishLayout) {
                ijkPlayerView.seekTo((int) f2);
            }
        }
    }

    @Override // io.dcloud.media.weex.weex_video.ijkplayer.OnPlayerChangedListener
    public void onChanged(String str, String str2) {
        HashMap hashMap = new HashMap();
        if (!TextUtils.isEmpty(str2)) {
            try {
                hashMap.put("detail", JSON.parse(str2));
            } catch (Exception unused) {
                hashMap.put("detail", str2);
            }
        }
        execCallBack(str, hashMap);
        if (this.mPlayerView == null || !(this.mComponent.getChild(0) instanceof ScalableViewComponent) || !str.equals("fullscreenchange")) {
            return;
        }
        if (isFullScreen()) {
            removeView(this.subViewContainer);
            this.mPlayerView.addView(this.subViewContainer);
            this.subViewContainer.bringToFront();
            return;
        }
        this.mPlayerView.removeView(this.subViewContainer);
        removeView(this.subViewContainer);
        addView(this.subViewContainer);
        this.subViewContainer.bringToFront();
    }

    public boolean isFullScreen() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        return ijkPlayerView != null && ijkPlayerView.isFullscreen();
    }

    public boolean onBackPress() {
        IjkPlayerView ijkPlayerView = this.mPlayerView;
        return ijkPlayerView != null && ijkPlayerView.onBackPressed();
    }

    @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnInfoListener
    public boolean onInfo(IMediaPlayer iMediaPlayer, int i, int i2) {
        if (i != 331) {
            if (i != 332 && i != 701) {
                switch (i) {
                    case 334:
                        execCallBack(Constants.Value.PLAY, new HashMap<>());
                        break;
                    case 335:
                        execCallBack("pause", new HashMap<>());
                        break;
                    case 336:
                        if (this.loop) {
                            float f = this.initialTime;
                            if (f > 0.0f) {
                                this.mPlayerView.seekTo((int) f);
                            }
                            play();
                        }
                        execCallBack("ended", new HashMap<>());
                        break;
                    case 337:
                        Object[] objArr = new Object[1];
                        IjkPlayerView ijkPlayerView = this.mPlayerView;
                        objArr[0] = Integer.valueOf(ijkPlayerView != null ? ijkPlayerView.getCurPosition() : 0);
                        String format = StringUtil.format("{'position':%d}", objArr);
                        HashMap hashMap = new HashMap();
                        hashMap.put("detail", format);
                        execCallBack("seekcomplete", hashMap);
                        break;
                }
            } else {
                execCallBack(IApp.ConfigProperty.CONFIG_WAITING, new HashMap<>());
            }
        } else {
            execCallBack("error", new HashMap<>());
        }
        return false;
    }

    private void execCallBack(String str, Map<String, Object> map) {
        if (this.mComponent.getEvents().contains(str)) {
            this.mComponent.fireEvent(str, map);
        }
    }

    @Override // tv.danmaku.ijk.media.player.IMediaPlayer.OnBufferingUpdateListener
    public void onBufferingUpdate(IMediaPlayer iMediaPlayer, int i) {
        Map<String, Object> hashMap = new HashMap<>();
        HashMap hashMap2 = new HashMap();
        hashMap2.put("buffered", Integer.valueOf(i));
        hashMap.put("detail", hashMap2);
        execCallBack("progress", hashMap);
    }

    public int getDirection() {
        VideoComponent videoComponent = this.mComponent;
        if (videoComponent != null && videoComponent.getAttrs().containsKey("direction")) {
            try {
                return Integer.parseInt(String.valueOf(this.mComponent.getAttrs().get("direction")));
            } catch (Exception unused) {
            }
        }
        return Integer.MIN_VALUE;
    }
}
