package io.dcloud.feature.weex_media;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.common.Constants;
import com.taobao.weex.dom.CSSConstants;
import com.taobao.weex.dom.WXAttr;
import com.taobao.weex.layout.ContentBoxMeasurement;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXBasicComponentType;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.view.WXBaseRefreshLayout;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.weex.WeexInstanceMgr;
import io.dcloud.feature.weex.adapter.ScalableViewComponent;
import io.dcloud.feature.weex_media.option.EnumPlayStrategy;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;

public class VideoComponent extends WXVContainer<VideoPlayerView> implements ISysEventListener {
    private WXAttr attrs;
    private AtomicBoolean isLoad = new AtomicBoolean(false);
    private IApp mApp;
    private Map<String, Object> params;

    public VideoComponent(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, basicComponentData);
        this.attrs = basicComponentData.getAttrs();
        if (!basicComponentData.getStyles().containsKey(Constants.Name.FLEX)) {
            setContentBoxMeasurement(new ContentBoxMeasurement() {
                /* class io.dcloud.feature.weex_media.VideoComponent.AnonymousClass1 */

                @Override // com.taobao.weex.layout.ContentBoxMeasurement
                public void layoutAfter(float f, float f2) {
                }

                @Override // com.taobao.weex.layout.ContentBoxMeasurement
                public void layoutBefore() {
                }

                @Override // com.taobao.weex.layout.ContentBoxMeasurement
                public void measureInternal(float f, float f2, int i, int i2) {
                    if (CSSConstants.isUndefined(f)) {
                        this.mMeasureWidth = WXViewUtils.getRealPxByWidth(300.0f, VideoComponent.this.getInstance().getInstanceViewPortWidthWithFloat());
                    }
                    if (CSSConstants.isUndefined(f2)) {
                        this.mMeasureHeight = WXViewUtils.getRealPxByWidth(225.0f, VideoComponent.this.getInstance().getInstanceViewPortWidthWithFloat());
                    }
                }
            });
        }
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public VideoPlayerView initComponentHostView(Context context) {
        IWebview findWebview = WeexInstanceMgr.self().findWebview(getInstance());
        if (findWebview != null) {
            IApp obtainApp = findWebview.obtainApp();
            this.mApp = obtainApp;
            obtainApp.registerSysEventListener(this, ISysEventListener.SysEventType.onKeyUp);
        }
        return new VideoPlayerView(getContext(), this);
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer, io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public ViewGroup getRealView() {
        if (getHostView() != null) {
            return ((VideoPlayerView) getHostView()).getPlayerView();
        }
        return null;
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer
    public void addChild(WXComponent wXComponent, int i) {
        if (wXComponent instanceof ScalableViewComponent) {
            ((ScalableViewComponent) wXComponent).setScalable(true);
            super.addChild(wXComponent, i);
        }
    }

    public IApp getIApp() {
        IWebview findWebview;
        if (this.mApp == null && (findWebview = WeexInstanceMgr.self().findWebview(getInstance())) != null) {
            this.mApp = findWebview.obtainApp();
        }
        return this.mApp;
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer
    public void addSubView(View view, int i) {
        if (view != null && getRealView() != null && !(view instanceof WXBaseRefreshLayout)) {
            if (i >= getRealView().getChildCount()) {
                i = -1;
            }
            if (getRealView().indexOfChild(view) == -1) {
                if (i == -1) {
                    getRealView().addView(view);
                } else {
                    getRealView().addView(view, i);
                }
            }
            view.bringToFront();
        }
    }

    @WXComponentProp(name = "src")
    public void setSrc(String str) {
        if (!PdrUtil.isEmpty(str)) {
            ((VideoPlayerView) getHostView()).setSrc(str);
        }
    }

    @WXComponentProp(name = WXBasicComponentType.HEADER)
    public void setHeader(String str) {
        if (!PdrUtil.isEmpty(str)) {
            ((VideoPlayerView) getHostView()).setHeader(str);
        }
    }

    @WXComponentProp(name = Constants.Name.AUTOPLAY)
    public void setAutoPlay(boolean z) {
        if (!PdrUtil.isEmpty(Boolean.valueOf(z))) {
            ((VideoPlayerView) getHostView()).setAutoplay(z);
        }
    }

    @WXComponentProp(name = "initialTime")
    public void setInitTime(float f) {
        ((VideoPlayerView) getHostView()).setInitialTime(f);
    }

    @WXComponentProp(name = "duration")
    public void setDuration(float f) {
        ((VideoPlayerView) getHostView()).setDuration(f);
    }

    @WXComponentProp(name = "danmuList")
    public void setDanmuList(JSONArray jSONArray) {
        ((VideoPlayerView) getHostView()).setDanmuList(jSONArray);
    }

    @WXComponentProp(name = "loop")
    public void setLoop(boolean z) {
        ((VideoPlayerView) getHostView()).setLoop(z);
    }

    @WXComponentProp(name = "muted")
    public void setMute(boolean z) {
        ((VideoPlayerView) getHostView()).setMuted(z);
    }

    @WXComponentProp(name = "direction")
    public void setDirection(int i) {
        ((VideoPlayerView) getHostView()).setDirection(i);
    }

    @WXComponentProp(name = "playStrategy")
    public void setPlayStrategy(int i) {
        EnumPlayStrategy enumPlayStrategy = EnumPlayStrategy.DEFAULT;
        if (i == EnumPlayStrategy.PLAY_SMOOTH.getFlagVal()) {
            enumPlayStrategy = EnumPlayStrategy.PLAY_SMOOTH;
        } else if (i == EnumPlayStrategy.START_QUICK.getFlagVal()) {
            enumPlayStrategy = EnumPlayStrategy.START_QUICK;
        } else if (i == EnumPlayStrategy.M3U8_SMOOTH.getFlagVal()) {
            enumPlayStrategy = EnumPlayStrategy.M3U8_SMOOTH;
        } else if (i == EnumPlayStrategy.DEFAULT.getFlagVal()) {
            enumPlayStrategy = EnumPlayStrategy.DEFAULT;
        }
        ((VideoPlayerView) getHostView()).setFlowStrategy(enumPlayStrategy);
    }

    @WXComponentProp(name = "objectFit")
    public void setFit(String str) {
        if (!PdrUtil.isEmpty(str)) {
            ((VideoPlayerView) getHostView()).setObjectFit(str);
        }
    }

    @WXComponentProp(name = "showMuteBtn")
    public void isShowMuteBtn(boolean z) {
        ((VideoPlayerView) getHostView()).setMuteBtn(z);
    }

    @WXComponentProp(name = "playBtnPosition")
    public void setPlayBtnPosition(String str) {
        if (!PdrUtil.isEmpty(str)) {
            ((VideoPlayerView) getHostView()).setPlayBtnPosition(str);
        }
    }

    @WXComponentProp(name = AbsoluteConst.JSON_KEY_TITLE)
    public void setTitle(String str) {
        if (!PdrUtil.isEmpty(str)) {
            ((VideoPlayerView) getHostView()).setTitle(str);
        }
    }

    @WXComponentProp(name = "httpCache")
    public void httpCache(boolean z) {
        ((VideoPlayerView) getHostView()).setHttpCacheEnable(z);
    }

    @WXComponentProp(name = "codec")
    public void setCodeMode(String str) {
        ((VideoPlayerView) getHostView()).setCodec(str);
    }

    @WXComponentProp(name = "showLoading")
    public void showLoading(boolean z) {
        ((VideoPlayerView) getHostView()).setShowLoading(z);
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void updateProperties(Map<String, Object> map) {
        if (map.size() > 0 && getHostView() != null) {
            this.params = combinMap(this.params, map);
            boolean z = false;
            ((VideoPlayerView) getHostView()).setProgress(!this.params.containsKey("showProgress") || Boolean.parseBoolean(this.params.get("showProgress").toString()));
            ((VideoPlayerView) getHostView()).setShowFullScreenBtn(!this.params.containsKey("showFullscreenBtn") || Boolean.parseBoolean(this.params.get("showFullscreenBtn").toString()));
            ((VideoPlayerView) getHostView()).setPlayBtnVisibility(!this.params.containsKey("showPlayBtn") || Boolean.parseBoolean(this.params.get("showPlayBtn").toString()));
            ((VideoPlayerView) getHostView()).setEnableProgressGesture(!this.params.containsKey("enableProgressGesture") || Boolean.parseBoolean(this.params.get("enableProgressGesture").toString()));
            if (map.containsKey("src")) {
                ((VideoPlayerView) getHostView()).setSrc((String) map.get("src"));
            }
            ((VideoPlayerView) getHostView()).setShowCenterPlayBtn(!this.params.containsKey("showCenterPlayBtn") || Boolean.parseBoolean(this.params.get("showCenterPlayBtn").toString()));
            VideoPlayerView videoPlayerView = (VideoPlayerView) getHostView();
            if (!this.params.containsKey(Constants.Name.CONTROLS) || Boolean.parseBoolean(this.params.get(Constants.Name.CONTROLS).toString())) {
                z = true;
            }
            videoPlayerView.setControls(z);
            if (this.params.containsKey("vslideGestureInFullscreen")) {
                ((VideoPlayerView) getHostView()).setFullScreenPageGesture(Boolean.parseBoolean(this.params.get("vslideGestureInFullscreen").toString()));
            }
            if (this.params.containsKey("vslideGesture")) {
                ((VideoPlayerView) getHostView()).setPageGesture(Boolean.parseBoolean(this.params.get("vslideGesture").toString()));
            }
            if (this.params.containsKey("showScreenLockButton")) {
                ((VideoPlayerView) getHostView()).setLockScreen(Boolean.parseBoolean(this.params.get("showScreenLockButton").toString()));
            }
            if (this.params.containsKey("enablePlayGesture")) {
                ((VideoPlayerView) getHostView()).setEnablePlayGesture(Boolean.parseBoolean(this.params.get("enablePlayGesture").toString()));
            }
        }
        super.updateProperties(map);
        if (map.size() > 0 && map.containsKey("src")) {
            ((VideoPlayerView) getHostView()).onLayoutFinished((String) map.get("src"));
        }
    }

    private Map<String, Object> combinMap(Map<String, Object> map, Map<String, Object> map2) {
        if (map == null && map2 == null) {
            return new HashMap();
        }
        if (map == null) {
            return map2;
        }
        if (map2 == null) {
            return map;
        }
        map.putAll(map2);
        return map;
    }

    @WXComponentProp(name = "poster")
    public void setPoster(String str) {
        ((VideoPlayerView) getHostView()).setPoster(str);
    }

    @JSMethod
    public void requestFullScreen(JSONObject jSONObject) {
        int i;
        try {
            i = jSONObject.getInteger("direction").intValue();
        } catch (Exception unused) {
            i = -90;
        }
        ((VideoPlayerView) getHostView()).requestFullScreen(i);
    }

    @JSMethod
    public void play() {
        ((VideoPlayerView) getHostView()).play();
    }

    @JSMethod
    public void pause() {
        ((VideoPlayerView) getHostView()).pause();
    }

    @JSMethod
    public void stop() {
        ((VideoPlayerView) getHostView()).stop();
    }

    @JSMethod
    public void seek(int i) {
        if (!PdrUtil.isEmpty(Integer.valueOf(i))) {
            ((VideoPlayerView) getHostView()).seek(i * 1000);
        }
    }

    @JSMethod
    public void sendDanmu(JSONObject jSONObject) {
        if (jSONObject != null) {
            ((VideoPlayerView) getHostView()).sendDanmu(jSONObject);
        }
    }

    @JSMethod
    public void playbackRate(float f) {
        if (!PdrUtil.isEmpty(Float.valueOf(f))) {
            ((VideoPlayerView) getHostView()).sendPlayBackRate(String.valueOf(f));
        }
    }

    @JSMethod
    public void exitFullScreen() {
        ((VideoPlayerView) getHostView()).exitFullScreen();
    }

    /* access modifiers changed from: protected */
    public void onHostViewInitialized(VideoPlayerView videoPlayerView) {
        super.onHostViewInitialized((View) videoPlayerView);
        WXAttr wXAttr = this.attrs;
        if (wXAttr != null && wXAttr.size() > 0) {
            boolean z = true;
            ((VideoPlayerView) getHostView()).setEnableDanmu(this.attrs.containsKey("enableDanmu") && Boolean.parseBoolean(this.attrs.get("enableDanmu").toString()));
            VideoPlayerView videoPlayerView2 = (VideoPlayerView) getHostView();
            if (!this.attrs.containsKey("danmuBtn") || !Boolean.parseBoolean(this.attrs.get("danmuBtn").toString())) {
                z = false;
            }
            videoPlayerView2.setDanmuBtn(z);
        }
    }

    @Override // com.taobao.weex.IWXActivityStateListener, io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public void onActivityResume() {
        super.onActivityResume();
        if (getHostView() != null) {
            ((VideoPlayerView) getHostView()).onActivityResume();
        }
    }

    @Override // com.taobao.weex.IWXActivityStateListener, io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public void onActivityPause() {
        super.onActivityPause();
        if (getHostView() != null) {
            ((VideoPlayerView) getHostView()).pause();
        }
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public void destroy() {
        super.destroy();
        if (getHostView() != null) {
            ((VideoPlayerView) getHostView()).destory();
        }
        IApp iApp = this.mApp;
        if (iApp != null) {
            iApp.unregisterSysEventListener(this, ISysEventListener.SysEventType.onKeyUp);
        }
    }

    @Override // io.dcloud.common.DHInterface.ISysEventListener
    public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
        if (sysEventType != ISysEventListener.SysEventType.onKeyUp || ((Integer) ((Object[]) obj)[0]).intValue() != 4 || !((VideoPlayerView) getHostView()).isFullScreen() || getHostView() == null) {
            return false;
        }
        return ((VideoPlayerView) getHostView()).onBackPress();
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void addEvent(String str) {
        if (!str.equals(Constants.Event.CLICK)) {
            super.addEvent(str);
        }
    }
}
