package io.dcloud.feature.weex.extend;

import android.content.Context;
import android.text.TextUtils;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import androidx.viewpager.widget.ViewPager;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.annotation.Component;
import com.taobao.weex.common.Constants;
import com.taobao.weex.dom.WXEvent;
import com.taobao.weex.ui.ComponentCreator;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXComponentProp;
import com.taobao.weex.ui.component.WXIndicator;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.ui.component.list.template.TemplateDom;
import com.taobao.weex.ui.view.BaseFrameLayout;
import com.taobao.weex.ui.view.WXCircleIndicator;
import com.taobao.weex.ui.view.WXCirclePageAdapter;
import com.taobao.weex.ui.view.WXCircleViewPager;
import com.taobao.weex.ui.view.gesture.WXGestureType;
import com.taobao.weex.utils.WXLogUtils;
import com.taobao.weex.utils.WXUtils;
import com.taobao.weex.utils.WXViewUtils;
import io.dcloud.common.constant.AbsoluteConst;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

@Component(lazyload = false)
public class DCWXSlider extends WXVContainer<FrameLayout> {
    public static final String INDEX = "index";
    public static final String INFINITE = "infinite";
    public static final String SOURCE = "source";
    private int initIndex;
    private Runnable initRunnable;
    protected boolean isDrag;
    private boolean isInfinite;
    private boolean keepIndex;
    protected WXCirclePageAdapter mAdapter;
    protected WXIndicator mIndicator;
    protected ViewPager.OnPageChangeListener mPageChangeListener;
    protected boolean mShowIndicators;
    DCWXCircleViewPager mViewPager;
    private float offsetXAccuracy;
    Map<String, Object> params;

    public static class Creator implements ComponentCreator {
        @Override // com.taobao.weex.ui.ComponentCreator
        public WXComponent createInstance(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) throws IllegalAccessException, InvocationTargetException, InstantiationException {
            return new DCWXSlider(wXSDKInstance, wXVContainer, basicComponentData);
        }
    }

    @Deprecated
    public DCWXSlider(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, String str, boolean z, BasicComponentData basicComponentData) {
        this(wXSDKInstance, wXVContainer, basicComponentData);
    }

    public DCWXSlider(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, basicComponentData);
        this.isInfinite = true;
        this.params = new HashMap();
        this.offsetXAccuracy = 0.1f;
        this.initIndex = -1;
        this.keepIndex = true;
        this.mShowIndicators = true;
        this.mPageChangeListener = new SliderPageChangeListener();
        this.isDrag = false;
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public BaseFrameLayout initComponentHostView(Context context) {
        BaseFrameLayout baseFrameLayout = new BaseFrameLayout(context);
        if (getAttrs() != null) {
            this.isInfinite = WXUtils.getBoolean(getAttrs().get("infinite"), true).booleanValue();
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, -1);
        DCWXCircleViewPager dCWXCircleViewPager = new DCWXCircleViewPager(context);
        this.mViewPager = dCWXCircleViewPager;
        dCWXCircleViewPager.setCircle(this.isInfinite);
        this.mViewPager.setLayoutParams(layoutParams);
        WXCirclePageAdapter wXCirclePageAdapter = new WXCirclePageAdapter(this.isInfinite);
        this.mAdapter = wXCirclePageAdapter;
        this.mViewPager.setAdapter(wXCirclePageAdapter);
        baseFrameLayout.addView(this.mViewPager);
        this.mViewPager.addOnPageChangeListener(this.mPageChangeListener);
        registerActivityStateListener();
        return baseFrameLayout;
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer
    public ViewGroup.LayoutParams getChildLayoutParams(WXComponent wXComponent, View view, int i, int i2, int i3, int i4, int i5, int i6) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        if (layoutParams == null) {
            layoutParams = new FrameLayout.LayoutParams(i, i2);
        } else {
            layoutParams.width = i;
            layoutParams.height = i2;
        }
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            if (wXComponent instanceof WXIndicator) {
                setMarginsSupportRTL((ViewGroup.MarginLayoutParams) layoutParams, i3, i5, i4, i6);
            } else {
                setMarginsSupportRTL((ViewGroup.MarginLayoutParams) layoutParams, 0, 0, 0, 0);
            }
        }
        return layoutParams;
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void addEvent(String str) {
        DCWXCircleViewPager dCWXCircleViewPager;
        super.addEvent(str);
        if ("scroll".equals(str) && (dCWXCircleViewPager = this.mViewPager) != null) {
            dCWXCircleViewPager.addOnPageChangeListener(new SliderOnScrollListener(this));
        }
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public boolean containsGesture(WXGestureType wXGestureType) {
        return super.containsGesture(wXGestureType);
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer, io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public ViewGroup getRealView() {
        return this.mViewPager;
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer
    public void addSubView(View view, int i) {
        WXCirclePageAdapter wXCirclePageAdapter;
        if (view != null && (wXCirclePageAdapter = this.mAdapter) != null && !(view instanceof WXCircleIndicator)) {
            wXCirclePageAdapter.addPageView(view);
            hackTwoItemsInfiniteScroll();
            if (this.initIndex != -1 && this.mAdapter.getRealCount() > this.initIndex) {
                if (this.initRunnable == null) {
                    this.initRunnable = new Runnable() {
                        /* class io.dcloud.feature.weex.extend.DCWXSlider.AnonymousClass1 */

                        public void run() {
                            DCWXSlider dCWXSlider = DCWXSlider.this;
                            dCWXSlider.initIndex = dCWXSlider.getInitIndex();
                            DCWXSlider dCWXSlider2 = DCWXSlider.this;
                            DCWXSlider.this.mViewPager.setCurrentItem(dCWXSlider2.getRealIndex(dCWXSlider2.initIndex));
                            DCWXSlider.this.initIndex = -1;
                            DCWXSlider.this.initRunnable = null;
                        }
                    };
                }
                int initIndex2 = getInitIndex();
                this.initIndex = initIndex2;
                this.mViewPager.setCurrentItem(getRealIndex(initIndex2));
                this.mViewPager.removeCallbacks(this.initRunnable);
                this.mViewPager.postDelayed(this.initRunnable, 50);
            } else if (!this.keepIndex) {
                this.mViewPager.setCurrentItem(getRealIndex(0));
            }
            WXIndicator wXIndicator = this.mIndicator;
            if (wXIndicator != null) {
                ((WXCircleIndicator) wXIndicator.getHostView()).forceLayout();
                ((WXCircleIndicator) this.mIndicator.getHostView()).requestLayout();
            }
        }
    }

    @Override // com.taobao.weex.ui.component.WXComponent
    public void setLayout(WXComponent wXComponent) {
        WXCirclePageAdapter wXCirclePageAdapter = this.mAdapter;
        if (wXCirclePageAdapter != null) {
            wXCirclePageAdapter.setLayoutDirectionRTL(isLayoutRTL());
        }
        super.setLayout(wXComponent);
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer
    public void remove(WXComponent wXComponent, boolean z) {
        WXCirclePageAdapter wXCirclePageAdapter;
        if (wXComponent != null && wXComponent.getHostView() != null && (wXCirclePageAdapter = this.mAdapter) != null) {
            wXCirclePageAdapter.removePageView(wXComponent.getHostView());
            hackTwoItemsInfiniteScroll();
            super.remove(wXComponent, z);
        }
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public void destroy() {
        super.destroy();
        DCWXCircleViewPager dCWXCircleViewPager = this.mViewPager;
        if (dCWXCircleViewPager != null) {
            dCWXCircleViewPager.stopAutoScroll();
            this.mViewPager.removeAllViews();
            this.mViewPager.destory();
        }
    }

    @Override // com.taobao.weex.IWXActivityStateListener, io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public void onActivityResume() {
        super.onActivityResume();
        DCWXCircleViewPager dCWXCircleViewPager = this.mViewPager;
        if (dCWXCircleViewPager != null && dCWXCircleViewPager.isAutoScroll()) {
            this.mViewPager.startAutoScroll();
        }
    }

    @Override // com.taobao.weex.IWXActivityStateListener, io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public void onActivityStop() {
        super.onActivityStop();
        DCWXCircleViewPager dCWXCircleViewPager = this.mViewPager;
        if (dCWXCircleViewPager != null) {
            dCWXCircleViewPager.pauseAutoScroll();
        }
    }

    public int getCurrentIndex() {
        DCWXCircleViewPager dCWXCircleViewPager = this.mViewPager;
        if (dCWXCircleViewPager != null) {
            return dCWXCircleViewPager.superGetCurrentItem();
        }
        return -1;
    }

    public void addIndicator(WXIndicator wXIndicator) {
        FrameLayout frameLayout = (FrameLayout) getHostView();
        if (frameLayout != null) {
            this.mIndicator = wXIndicator;
            wXIndicator.setShowIndicators(this.mShowIndicators);
            WXCircleIndicator wXCircleIndicator = (WXCircleIndicator) wXIndicator.getHostView();
            if (wXCircleIndicator != null) {
                wXCircleIndicator.setCircleViewPager(this.mViewPager);
                frameLayout.addView(wXCircleIndicator);
            }
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private int getInitIndex() {
        Object obj = getAttrs().get("index");
        if (obj == null) {
            return 0;
        }
        int intValue = WXUtils.getInteger(obj, Integer.valueOf(this.initIndex)).intValue();
        WXCirclePageAdapter wXCirclePageAdapter = this.mAdapter;
        if (wXCirclePageAdapter == null || wXCirclePageAdapter.getCount() == 0) {
            return 0;
        }
        return intValue >= this.mAdapter.getRealCount() ? intValue % this.mAdapter.getRealCount() : intValue;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private int getRealIndex(int i) {
        if (this.mAdapter.getRealCount() > 0) {
            if (i >= this.mAdapter.getRealCount()) {
                i = this.mAdapter.getRealCount() - 1;
            }
            if (isLayoutRTL()) {
                i = (this.mAdapter.getRealCount() - 1) - i;
            }
        }
        return i + 0;
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public boolean setProperty(String str, Object obj) {
        str.hashCode();
        char c = 65535;
        switch (str.hashCode()) {
            case -1768064947:
                if (str.equals(Constants.Name.KEEP_INDEX)) {
                    c = 0;
                    break;
                }
                break;
            case 66669991:
                if (str.equals(Constants.Name.SCROLLABLE)) {
                    c = 1;
                    break;
                }
                break;
            case 100346066:
                if (str.equals("index")) {
                    c = 2;
                    break;
                }
                break;
            case 111972721:
                if (str.equals("value")) {
                    c = 3;
                    break;
                }
                break;
            case 570418373:
                if (str.equals("interval")) {
                    c = 4;
                    break;
                }
                break;
            case 996926241:
                if (str.equals(Constants.Name.SHOW_INDICATORS)) {
                    c = 5;
                    break;
                }
                break;
            case 1438608771:
                if (str.equals(Constants.Name.AUTO_PLAY)) {
                    c = 6;
                    break;
                }
                break;
            case 1565939262:
                if (str.equals(Constants.Name.OFFSET_X_ACCURACY)) {
                    c = 7;
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
                this.keepIndex = WXUtils.getBoolean(obj, false).booleanValue();
                return true;
            case 1:
                setScrollable(WXUtils.getBoolean(obj, true).booleanValue());
                return true;
            case 2:
                Integer integer = WXUtils.getInteger(obj, null);
                if (integer != null) {
                    setIndex(integer.intValue());
                }
                return true;
            case 3:
                String string = WXUtils.getString(obj, null);
                if (string != null) {
                    setValue(string);
                }
                return true;
            case 4:
                Integer integer2 = WXUtils.getInteger(obj, null);
                if (integer2 != null) {
                    setInterval(integer2.intValue());
                }
                return true;
            case 5:
                String string2 = WXUtils.getString(obj, null);
                if (string2 != null) {
                    setShowIndicators(string2);
                }
                return true;
            case 6:
                String string3 = WXUtils.getString(obj, null);
                if (string3 != null) {
                    setAutoPlay(string3);
                }
                return true;
            case 7:
                Float f = WXUtils.getFloat(obj, Float.valueOf(0.1f));
                if (f.floatValue() != 0.0f) {
                    setOffsetXAccuracy(f.floatValue());
                }
                return true;
            default:
                return super.setProperty(str, obj);
        }
    }

    @WXComponentProp(name = "value")
    @Deprecated
    public void setValue(String str) {
        if (str != null && getHostView() != null) {
            try {
                setIndex(Integer.parseInt(str));
            } catch (NumberFormatException e) {
                WXLogUtils.e("", e);
            }
        }
    }

    @WXComponentProp(name = Constants.Name.AUTO_PLAY)
    public void setAutoPlay(String str) {
        if (TextUtils.isEmpty(str) || str.equals(AbsoluteConst.FALSE)) {
            this.mViewPager.stopAutoScroll();
            return;
        }
        this.mViewPager.stopAutoScroll();
        this.mViewPager.startAutoScroll();
    }

    @WXComponentProp(name = "vertical")
    public void setVertical(boolean z) {
        DCWXCircleViewPager dCWXCircleViewPager = this.mViewPager;
        if (dCWXCircleViewPager != null) {
            dCWXCircleViewPager.setVertical(z);
        }
    }

    @WXComponentProp(name = Constants.Name.SHOW_INDICATORS)
    public void setShowIndicators(String str) {
        if (TextUtils.isEmpty(str) || str.equals(AbsoluteConst.FALSE)) {
            this.mShowIndicators = false;
        } else {
            this.mShowIndicators = true;
        }
        WXIndicator wXIndicator = this.mIndicator;
        if (wXIndicator != null) {
            wXIndicator.setShowIndicators(this.mShowIndicators);
        }
    }

    @WXComponentProp(name = "interval")
    public void setInterval(int i) {
        DCWXCircleViewPager dCWXCircleViewPager = this.mViewPager;
        if (dCWXCircleViewPager != null && i > 0) {
            dCWXCircleViewPager.setIntervalTime((long) i);
        }
    }

    @WXComponentProp(name = "index")
    public void setIndex(int i) {
        WXCirclePageAdapter wXCirclePageAdapter;
        WXCirclePageAdapter wXCirclePageAdapter2;
        if (this.mViewPager != null && (wXCirclePageAdapter = this.mAdapter) != null) {
            if (i >= wXCirclePageAdapter.getRealCount() || i < 0) {
                this.initIndex = i;
                return;
            }
            int realIndex = getRealIndex(i);
            if (this.mAdapter.getRealCount() == 3 && realIndex == 2 && this.mViewPager.getCurrentItem() == 0) {
                this.mViewPager.setCurrentItem(1, false);
            }
            this.mViewPager.setCurrentItem(realIndex);
            WXIndicator wXIndicator = this.mIndicator;
            if (wXIndicator != null && wXIndicator.getHostView() != null && ((WXCircleIndicator) this.mIndicator.getHostView()).getRealCurrentItem() != realIndex) {
                WXLogUtils.d("setIndex >>>> correction indicator to " + realIndex);
                ((WXCircleIndicator) this.mIndicator.getHostView()).setRealCurrentItem(realIndex);
                ((WXCircleIndicator) this.mIndicator.getHostView()).invalidate();
                ViewPager.OnPageChangeListener onPageChangeListener = this.mPageChangeListener;
                if (onPageChangeListener != null && (wXCirclePageAdapter2 = this.mAdapter) != null) {
                    onPageChangeListener.onPageSelected(wXCirclePageAdapter2.getFirst() + realIndex);
                }
            }
        }
    }

    @WXComponentProp(name = Constants.Name.SCROLLABLE)
    public void setScrollable(boolean z) {
        DCWXCircleViewPager dCWXCircleViewPager = this.mViewPager;
        if (dCWXCircleViewPager != null && this.mAdapter != null) {
            dCWXCircleViewPager.setScrollable(z);
        }
    }

    @WXComponentProp(name = Constants.Name.OFFSET_X_ACCURACY)
    public void setOffsetXAccuracy(float f) {
        this.offsetXAccuracy = f;
    }

    protected class SliderPageChangeListener implements ViewPager.OnPageChangeListener {
        private int lastPos = -1;

        @Override // androidx.viewpager.widget.ViewPager.OnPageChangeListener
        public void onPageScrolled(int i, float f, int i2) {
        }

        protected SliderPageChangeListener() {
        }

        @Override // androidx.viewpager.widget.ViewPager.OnPageChangeListener
        public void onPageSelected(int i) {
            if (DCWXSlider.this.mAdapter.getRealPosition(i) != this.lastPos) {
                if (WXEnvironment.isApkDebugable()) {
                    WXLogUtils.d("onPageSelected >>>>" + DCWXSlider.this.mAdapter.getRealPosition(i) + " lastPos: " + this.lastPos);
                }
                if (DCWXSlider.this.mAdapter != null && DCWXSlider.this.mAdapter.getRealCount() != 0) {
                    int realPosition = DCWXSlider.this.mAdapter.getRealPosition(i);
                    if (DCWXSlider.this.mChildren != null && realPosition < DCWXSlider.this.mChildren.size() && DCWXSlider.this.getEvents().size() != 0) {
                        WXEvent events = DCWXSlider.this.getEvents();
                        String ref = DCWXSlider.this.getRef();
                        if (events.contains(Constants.Event.CHANGE) && WXViewUtils.onScreenArea(DCWXSlider.this.getHostView())) {
                            DCWXSlider.this.params.put("index", Integer.valueOf(realPosition));
                            String str = "touch";
                            DCWXSlider.this.params.put("source", DCWXSlider.this.isDrag ? str : Constants.Name.AUTOPLAY);
                            HashMap hashMap = new HashMap();
                            HashMap hashMap2 = new HashMap();
                            hashMap2.put("index", Integer.valueOf(realPosition));
                            if (!DCWXSlider.this.isDrag) {
                                str = Constants.Name.AUTOPLAY;
                            }
                            hashMap2.put("source", str);
                            hashMap.put(TemplateDom.KEY_ATTRS, hashMap2);
                            DCWXSlider.this.getAttrs().putAll(hashMap2);
                            WXSDKManager.getInstance().fireEvent(DCWXSlider.this.getInstanceId(), ref, Constants.Event.CHANGE, DCWXSlider.this.params, hashMap);
                        }
                        DCWXSlider.this.mViewPager.requestLayout();
                        ((FrameLayout) DCWXSlider.this.getHostView()).invalidate();
                        this.lastPos = DCWXSlider.this.mAdapter.getRealPosition(i);
                    }
                }
            }
        }

        @Override // androidx.viewpager.widget.ViewPager.OnPageChangeListener
        public void onPageScrollStateChanged(int i) {
            FrameLayout frameLayout = (FrameLayout) DCWXSlider.this.getHostView();
            if (frameLayout != null) {
                frameLayout.invalidate();
            }
        }
    }

    protected static class SliderOnScrollListener implements ViewPager.OnPageChangeListener {
        private float lastPositionOffset = 99.0f;
        private float lastValue = 0.0f;
        private boolean pageSelected = false;
        private int preScrollstate = 0;
        private int scrollState = 0;
        private int selectedPosition;
        private DCWXSlider target;

        public SliderOnScrollListener(DCWXSlider dCWXSlider) {
            this.target = dCWXSlider;
            this.selectedPosition = dCWXSlider.mViewPager.superGetCurrentItem();
        }

        /* JADX WARNING: Code restructure failed: missing block: B:31:0x0067, code lost:
            if (r9.pageSelected != false) goto L_0x006b;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:49:0x0093, code lost:
            if (r9.lastValue < 0.0f) goto L_0x0043;
         */
        /* JADX WARNING: Code restructure failed: missing block: B:53:0x009d, code lost:
            if (r9.lastValue > 0.0f) goto L_0x0043;
         */
        /* JADX WARNING: Removed duplicated region for block: B:66:0x00dc  */
        /* JADX WARNING: Removed duplicated region for block: B:70:0x0105  */
        @Override // androidx.viewpager.widget.ViewPager.OnPageChangeListener
        public void onPageScrolled(int i, float f, int i2) {
            float f2;
            float f3 = this.lastPositionOffset;
            if (f3 == 99.0f) {
                this.lastPositionOffset = f;
                this.lastValue = f;
                return;
            }
            float f4 = f - f3;
            if (f4 == 0.0f) {
                this.lastPositionOffset = f;
                return;
            }
            int i3 = this.scrollState;
            boolean z = false;
            if (i3 == 1) {
                this.pageSelected = false;
                if (f != 0.0f) {
                    if (i == this.target.mViewPager.superGetCurrentItem()) {
                        f2 = Math.abs(f);
                        if (f2 < 0.0f && f2 > -1.0f) {
                            f2 = -(f2 + 1.0f);
                        }
                        if (this.preScrollstate == 2 && this.scrollState == 1) {
                            this.target.mViewPager.getmScroller().forceFinished(true);
                            this.target.fireEvent(Constants.Event.SCROLL_END);
                        }
                        this.preScrollstate = this.scrollState;
                        this.lastValue = f2;
                        if (this.target.mViewPager.isVertical()) {
                            HashMap hashMap = new HashMap(1);
                            hashMap.put("offsetYRatio", Float.valueOf(-f2));
                            if (this.target.mViewPager.getPointCounr() > 0) {
                                z = true;
                            }
                            hashMap.put("drag", Boolean.valueOf(z));
                            this.target.fireEvent("scroll", hashMap);
                            this.lastPositionOffset = f;
                            return;
                        }
                        HashMap hashMap2 = new HashMap(1);
                        hashMap2.put(Constants.Name.OFFSET_X_RATIO, Float.valueOf(-f2));
                        if (this.target.mViewPager.getPointCounr() > 0) {
                            z = true;
                        }
                        hashMap2.put("drag", Boolean.valueOf(z));
                        this.target.fireEvent("scroll", hashMap2);
                        this.lastPositionOffset = f;
                        return;
                    }
                    if (i < this.target.mViewPager.superGetCurrentItem()) {
                        f2 = Math.abs(f);
                    }
                    f2 = f;
                    f2 = -(f2 + 1.0f);
                    this.target.mViewPager.getmScroller().forceFinished(true);
                    this.target.fireEvent(Constants.Event.SCROLL_END);
                    this.preScrollstate = this.scrollState;
                    this.lastValue = f2;
                    if (this.target.mViewPager.isVertical()) {
                    }
                } else {
                    return;
                }
            } else {
                if (i3 == 2 || i3 == 0) {
                    int i4 = -1;
                    if (f == 0.0f) {
                        if (((double) Math.abs(f4)) > 0.9d) {
                            if (this.pageSelected) {
                                i4 = 1;
                                f2 = (float) i4;
                            }
                        }
                        i4 = 0;
                        f2 = (float) i4;
                    } else {
                        if (f4 > 0.0f) {
                        }
                        i4 = 1;
                        f2 = ((float) i4) * Math.abs(f);
                    }
                    if (this.preScrollstate == 2) {
                        if (this.scrollState == 2) {
                            if (f2 > 0.0f) {
                            }
                            if (f2 < 0.0f) {
                            }
                        }
                    }
                    f2 = -(f2 + 1.0f);
                    this.target.mViewPager.getmScroller().forceFinished(true);
                    this.target.fireEvent(Constants.Event.SCROLL_END);
                    this.preScrollstate = this.scrollState;
                    this.lastValue = f2;
                    if (this.target.mViewPager.isVertical()) {
                    }
                }
                f2 = f;
                f2 = -(f2 + 1.0f);
                this.target.mViewPager.getmScroller().forceFinished(true);
                this.target.fireEvent(Constants.Event.SCROLL_END);
                this.preScrollstate = this.scrollState;
                this.lastValue = f2;
                if (this.target.mViewPager.isVertical()) {
                }
            }
            f2 = -f2;
            f2 = -(f2 + 1.0f);
            this.target.mViewPager.getmScroller().forceFinished(true);
            this.target.fireEvent(Constants.Event.SCROLL_END);
            this.preScrollstate = this.scrollState;
            this.lastValue = f2;
            if (this.target.mViewPager.isVertical()) {
            }
        }

        @Override // androidx.viewpager.widget.ViewPager.OnPageChangeListener
        public void onPageSelected(int i) {
            this.pageSelected = true;
            this.selectedPosition = i;
        }

        @Override // androidx.viewpager.widget.ViewPager.OnPageChangeListener
        public void onPageScrollStateChanged(int i) {
            this.scrollState = i;
            if (i == 0) {
                this.lastPositionOffset = 99.0f;
                this.lastValue = 99.0f;
                if (this.preScrollstate == 2) {
                    this.preScrollstate = 0;
                    this.target.isDrag = false;
                    this.target.fireEvent(Constants.Event.SCROLL_END);
                }
            } else if (i == 1) {
                this.target.isDrag = true;
                this.target.fireEvent(Constants.Event.SCROLL_START);
            }
        }
    }

    private void hackTwoItemsInfiniteScroll() {
        WXCirclePageAdapter wXCirclePageAdapter;
        if (this.mViewPager != null && (wXCirclePageAdapter = this.mAdapter) != null && this.isInfinite) {
            if (wXCirclePageAdapter.getRealCount() == 2) {
                final GestureDetector gestureDetector = new GestureDetector(getContext(), new FlingGestureListener(this.mViewPager));
                this.mViewPager.setOnTouchListener(new View.OnTouchListener() {
                    /* class io.dcloud.feature.weex.extend.DCWXSlider.AnonymousClass2 */

                    public boolean onTouch(View view, MotionEvent motionEvent) {
                        return gestureDetector.onTouchEvent(motionEvent);
                    }
                });
                return;
            }
            this.mViewPager.setOnTouchListener(null);
        }
    }

    /* access modifiers changed from: private */
    public static class FlingGestureListener extends GestureDetector.SimpleOnGestureListener {
        private static final int SWIPE_MAX_OFF_PATH = WXViewUtils.dip2px(250.0f);
        private static final int SWIPE_MIN_DISTANCE = WXViewUtils.dip2px(50.0f);
        private static final int SWIPE_THRESHOLD_VELOCITY = WXViewUtils.dip2px(200.0f);
        private WeakReference<WXCircleViewPager> pagerRef;

        FlingGestureListener(WXCircleViewPager wXCircleViewPager) {
            this.pagerRef = new WeakReference<>(wXCircleViewPager);
        }

        public boolean onFling(MotionEvent motionEvent, MotionEvent motionEvent2, float f, float f2) {
            WXCircleViewPager wXCircleViewPager = this.pagerRef.get();
            if (wXCircleViewPager == null) {
                return false;
            }
            try {
                if (Math.abs(motionEvent.getY() - motionEvent2.getY()) > ((float) SWIPE_MAX_OFF_PATH)) {
                    return false;
                }
                float x = motionEvent.getX() - motionEvent2.getX();
                int i = SWIPE_MIN_DISTANCE;
                if (x <= ((float) i) || Math.abs(f) <= ((float) SWIPE_THRESHOLD_VELOCITY) || wXCircleViewPager.superGetCurrentItem() != 1) {
                    if (motionEvent2.getX() - motionEvent.getX() > ((float) i) && Math.abs(f) > ((float) SWIPE_THRESHOLD_VELOCITY) && wXCircleViewPager.superGetCurrentItem() == 0) {
                        wXCircleViewPager.setCurrentItem(1, false);
                        return true;
                    }
                    return false;
                }
                wXCircleViewPager.setCurrentItem(0, false);
                return true;
            } catch (Exception unused) {
            }
        }
    }
}
