package io.dcloud.feature.weex.extend;

import android.content.Context;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import androidx.viewpager.widget.ViewPager;
import com.taobao.weex.ui.view.WXCircleViewPager;

public class DCWXCircleViewPager extends WXCircleViewPager {
    private boolean isVertical = false;
    private int pointCounr = 0;

    public DCWXCircleViewPager(Context context) {
        super(context);
    }

    public DCWXCircleViewPager(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    private MotionEvent swapTouchEvent(MotionEvent motionEvent) {
        float width = (float) getWidth();
        float height = (float) getHeight();
        motionEvent.setLocation((motionEvent.getY() / height) * width, (motionEvent.getX() / width) * height);
        return motionEvent;
    }

    public boolean isVertical() {
        return this.isVertical;
    }

    public void setVertical(boolean z) {
        this.isVertical = z;
        if (z) {
            setPageTransformer(false, new ViewPager.PageTransformer() {
                /* class io.dcloud.feature.weex.extend.DCWXCircleViewPager.AnonymousClass1 */

                @Override // androidx.viewpager.widget.ViewPager.PageTransformer
                public void transformPage(View view, float f) {
                    view.setTranslationX(((float) view.getWidth()) * (-f));
                    view.setTranslationY(f * ((float) view.getHeight()));
                }
            });
        } else {
            setPageTransformer(false, null);
        }
    }

    @Override // androidx.viewpager.widget.ViewPager, com.taobao.weex.ui.view.WXCircleViewPager
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        try {
            if (!this.isVertical) {
                return super.onInterceptTouchEvent(motionEvent);
            }
            boolean onInterceptTouchEvent = super.onInterceptTouchEvent(swapTouchEvent(motionEvent));
            swapTouchEvent(motionEvent);
            return onInterceptTouchEvent;
        } catch (IllegalArgumentException e) {
            e.printStackTrace();
            return super.onInterceptTouchEvent(motionEvent);
        } catch (ArrayIndexOutOfBoundsException e2) {
            e2.printStackTrace();
            return super.onInterceptTouchEvent(motionEvent);
        }
    }

    public int getPointCounr() {
        return this.pointCounr;
    }

    /* JADX WARNING: Code restructure failed: missing block: B:12:0x002a, code lost:
        if (r4 != 3) goto L_0x0034;
     */
    @Override // androidx.viewpager.widget.ViewPager, com.taobao.weex.ui.view.WXCircleViewPager
    public boolean onTouchEvent(MotionEvent motionEvent) {
        int action = motionEvent.getAction();
        if (action == 0) {
            this.pointCounr = motionEvent.getPointerCount();
        } else if (action == 1 || action == 3) {
            this.pointCounr = 0;
        }
        if (!this.isVertical) {
            return super.onTouchEvent(motionEvent);
        }
        ViewGroup viewGroup = (ViewGroup) getParent();
        int action2 = motionEvent.getAction();
        if (action2 != 1) {
            if (action2 == 2) {
                viewGroup.requestDisallowInterceptTouchEvent(true);
            }
            return super.onTouchEvent(swapTouchEvent(motionEvent));
        }
        viewGroup.requestDisallowInterceptTouchEvent(false);
        return super.onTouchEvent(swapTouchEvent(motionEvent));
    }
}
