package io.dcloud.feature.weex.extend;

import android.net.Uri;
import android.text.TextUtils;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.annotation.JSMethod;
import com.taobao.weex.bridge.JSCallback;
import com.taobao.weex.bridge.SimpleJSCallback;
import com.taobao.weex.common.Constants;
import com.taobao.weex.ui.component.WXImage;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.feature.internal.sdk.SDK;
import io.dcloud.feature.uniapp.common.UniModule;
import io.dcloud.feature.weex.EnumStateCode;
import io.dcloud.feature.weex.WeexInstanceMgr;
import java.util.HashMap;

public class DCUniMPModule extends UniModule {
    @JSMethod
    public void showUniMP(final String str, final JSCallback jSCallback) {
        MessageHandler.post(new Runnable() {
            /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass1 */

            public void run() {
                try {
                    if (SDK.isUniMP) {
                        JSCallback jSCallback = jSCallback;
                        if (jSCallback != null) {
                            jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
                        }
                    } else if (TextUtils.isEmpty(str)) {
                        JSCallback jSCallback2 = jSCallback;
                        if (jSCallback2 != null) {
                            jSCallback2.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
                        }
                    } else {
                        IWebview findWebview = WeexInstanceMgr.self().findWebview(DCUniMPModule.this.mWXSDKInstance);
                        if (findWebview != null) {
                            WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, new Object[]{findWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "showUniMP", new Object[]{str, new ICallBack() {
                                /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass1.AnonymousClass1 */

                                @Override // io.dcloud.common.DHInterface.ICallBack
                                public Object onCallBack(int i, Object obj) {
                                    HashMap hashMap = new HashMap();
                                    if (i >= 0) {
                                        hashMap.put("type", WXImage.SUCCEED);
                                        hashMap.put("code", 0);
                                    } else {
                                        hashMap.put("type", Constants.Event.FAIL);
                                        hashMap.put("code", Integer.valueOf(i));
                                        hashMap.put("message", obj != null ? obj.toString() : "Unknown error");
                                    }
                                    if (jSCallback == null) {
                                        return null;
                                    }
                                    jSCallback.invoke(hashMap);
                                    return null;
                                }
                            }}});
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @JSMethod
    public void closeUniMP(final String str, final JSCallback jSCallback) {
        MessageHandler.post(new Runnable() {
            /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass2 */

            public void run() {
                try {
                    if (SDK.isUniMP) {
                        JSCallback jSCallback = jSCallback;
                        if (jSCallback != null) {
                            jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
                        }
                    } else if (TextUtils.isEmpty(str)) {
                        JSCallback jSCallback2 = jSCallback;
                        if (jSCallback2 != null) {
                            jSCallback2.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
                        }
                    } else {
                        IWebview findWebview = WeexInstanceMgr.self().findWebview(DCUniMPModule.this.mWXSDKInstance);
                        if (findWebview != null) {
                            WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, new Object[]{findWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "closeUniMP", new Object[]{str, new ICallBack() {
                                /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass2.AnonymousClass1 */

                                @Override // io.dcloud.common.DHInterface.ICallBack
                                public Object onCallBack(int i, Object obj) {
                                    HashMap hashMap = new HashMap();
                                    if (i >= 0) {
                                        hashMap.put("type", WXImage.SUCCEED);
                                        hashMap.put("code", 0);
                                    } else {
                                        hashMap.put("type", Constants.Event.FAIL);
                                        hashMap.put("code", Integer.valueOf(i));
                                        hashMap.put("message", obj != null ? obj.toString() : "Unknown error");
                                    }
                                    if (jSCallback == null) {
                                        return null;
                                    }
                                    jSCallback.invoke(hashMap);
                                    return null;
                                }
                            }}});
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @JSMethod
    public void hideUniMP(final String str, final JSCallback jSCallback) {
        MessageHandler.post(new Runnable() {
            /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass3 */

            public void run() {
                try {
                    if (SDK.isUniMP) {
                        JSCallback jSCallback = jSCallback;
                        if (jSCallback != null) {
                            jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
                        }
                    } else if (TextUtils.isEmpty(str)) {
                        JSCallback jSCallback2 = jSCallback;
                        if (jSCallback2 != null) {
                            jSCallback2.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
                        }
                    } else {
                        IWebview findWebview = WeexInstanceMgr.self().findWebview(DCUniMPModule.this.mWXSDKInstance);
                        if (findWebview != null) {
                            WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, new Object[]{findWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "hideUniMP", new Object[]{str, new ICallBack() {
                                /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass3.AnonymousClass1 */

                                @Override // io.dcloud.common.DHInterface.ICallBack
                                public Object onCallBack(int i, Object obj) {
                                    HashMap hashMap = new HashMap();
                                    if (i >= 0) {
                                        hashMap.put("type", WXImage.SUCCEED);
                                        hashMap.put("code", 0);
                                    } else {
                                        hashMap.put("type", Constants.Event.FAIL);
                                        hashMap.put("code", Integer.valueOf(i));
                                        hashMap.put("message", obj != null ? obj.toString() : "Unknown error");
                                    }
                                    if (jSCallback == null) {
                                        return null;
                                    }
                                    jSCallback.invoke(hashMap);
                                    return null;
                                }
                            }}});
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @JSMethod
    public void setDefaultMenuItems(String str, final JSCallback jSCallback) {
        JSONObject jSONObject;
        try {
            jSONObject = JSON.parseObject(str);
        } catch (Exception unused) {
            jSONObject = null;
        }
        if (!SDK.isUniMPSDK()) {
            if (jSONObject != null) {
                AnonymousClass4 r0 = new ICallBack() {
                    /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass4 */

                    @Override // io.dcloud.common.DHInterface.ICallBack
                    public Object onCallBack(int i, Object obj) {
                        JSONObject parseObject = JSON.parseObject(String.valueOf(obj));
                        String string = parseObject.getString("appId");
                        String string2 = parseObject.getString("id");
                        if (!TextUtils.isEmpty(string) && !TextUtils.isEmpty(string2)) {
                            HashMap hashMap = new HashMap();
                            hashMap.put("appId", string);
                            hashMap.put("id", string2);
                            JSCallback jSCallback = jSCallback;
                            if (jSCallback != null) {
                                jSCallback.invokeAndKeepAlive(hashMap);
                            }
                        }
                        return null;
                    }
                };
                IWebview findWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
                if (findWebview != null) {
                    WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, new Object[]{findWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "setDefaultMenuItems", new Object[]{str, r0}});
                }
            } else if (jSCallback != null) {
                jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
            }
        }
    }

    @JSMethod
    public void openUniMP(final String str, final JSCallback jSCallback) {
        MessageHandler.post(new Runnable() {
            /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass5 */

            public void run() {
                JSONObject jSONObject;
                try {
                    jSONObject = JSON.parseObject(str);
                } catch (Exception unused) {
                    jSONObject = null;
                }
                try {
                    if (SDK.isUniMP) {
                        JSCallback jSCallback = jSCallback;
                        if (jSCallback != null) {
                            jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
                        }
                    } else if (jSONObject == null) {
                        JSCallback jSCallback2 = jSCallback;
                        if (jSCallback2 != null) {
                            jSCallback2.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
                        }
                    } else {
                        IWebview findWebview = WeexInstanceMgr.self().findWebview(DCUniMPModule.this.mWXSDKInstance);
                        if (findWebview != null) {
                            AnonymousClass1 r2 = new ICallBack() {
                                /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass5.AnonymousClass1 */

                                @Override // io.dcloud.common.DHInterface.ICallBack
                                public Object onCallBack(int i, Object obj) {
                                    HashMap hashMap = new HashMap();
                                    if (i >= 0) {
                                        hashMap.put("type", WXImage.SUCCEED);
                                        hashMap.put("code", 0);
                                    } else {
                                        hashMap.put("type", Constants.Event.FAIL);
                                        hashMap.put("code", Integer.valueOf(i));
                                        hashMap.put("message", obj != null ? obj.toString() : "Unknown error");
                                    }
                                    if (jSCallback == null) {
                                        return null;
                                    }
                                    jSCallback.invoke(hashMap);
                                    return null;
                                }
                            };
                            jSONObject.put("appInfo", (Object) findWebview.obtainApp().obtainAppInfo());
                            WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, new Object[]{findWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "openUniMP", new Object[]{jSONObject.toJSONString(), r2}});
                        }
                    }
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    @JSMethod
    public void installUniMP(String str, final JSCallback jSCallback) {
        JSONObject jSONObject;
        try {
            jSONObject = JSON.parseObject(str);
        } catch (Exception unused) {
            jSONObject = null;
        }
        if (SDK.isUniMPSDK()) {
            if (jSCallback != null) {
                jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
            }
        } else if (jSONObject != null) {
            String string = jSONObject.getString("appid");
            String string2 = jSONObject.getString("wgtFile");
            String string3 = jSONObject.containsKey(Constants.Value.PASSWORD) ? jSONObject.getString(Constants.Value.PASSWORD) : "";
            if (!TextUtils.isEmpty(string2)) {
                Uri rewriteUri = this.mUniSDKInstance.rewriteUri(Uri.parse(string2), "file");
                if (rewriteUri != null) {
                    string2 = rewriteUri.getPath();
                }
            } else if (jSCallback != null) {
                jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_RESOURCE_EXIST));
            }
            AnonymousClass6 r2 = new ICallBack() {
                /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass6 */

                @Override // io.dcloud.common.DHInterface.ICallBack
                public Object onCallBack(int i, Object obj) {
                    HashMap hashMap = new HashMap();
                    if (i >= 0) {
                        hashMap.put("type", WXImage.SUCCEED);
                        hashMap.put("code", 0);
                    } else {
                        hashMap.put("type", Constants.Event.FAIL);
                        hashMap.put("code", Integer.valueOf(i));
                        hashMap.put("message", obj != null ? obj.toString() : "Unknown error");
                    }
                    JSCallback jSCallback = jSCallback;
                    if (jSCallback == null) {
                        return null;
                    }
                    jSCallback.invoke(hashMap);
                    return null;
                }
            };
            IWebview findWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
            if (findWebview != null) {
                WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, new Object[]{findWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "installUniMP", new Object[]{string, string2, string3, r2}});
            }
        } else if (jSCallback != null) {
            jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
        }
    }

    /* JADX WARN: Multi-variable type inference failed */
    /* JADX WARN: Type inference failed for: r0v3, types: [com.alibaba.fastjson.JSONObject] */
    /* JADX WARNING: Unknown variable types count: 1 */
    @JSMethod
    public void sendUniMPEvent(String str, String str2, String str3, final JSCallback jSCallback) {
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2)) {
            if (jSCallback != null) {
                jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
            }
        } else if (!SDK.isUniMPSDK()) {
            ?? parseObject = JSON.parseObject(str3);
            if (parseObject != 0) {
                str3 = parseObject;
            }
            AnonymousClass7 r0 = new ICallBack() {
                /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass7 */

                @Override // io.dcloud.common.DHInterface.ICallBack
                public Object onCallBack(int i, Object obj) {
                    HashMap hashMap = new HashMap();
                    if (i >= 0) {
                        hashMap.put("type", WXImage.SUCCEED);
                        hashMap.put("code", 0);
                    } else {
                        hashMap.put("type", Constants.Event.FAIL);
                        hashMap.put("code", Integer.valueOf(i));
                        hashMap.put("message", obj != null ? obj.toString() : "Unknown error");
                    }
                    JSCallback jSCallback = jSCallback;
                    if (jSCallback == null) {
                        return null;
                    }
                    jSCallback.invoke(hashMap);
                    return null;
                }
            };
            IWebview findWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
            if (findWebview != null) {
                WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, new Object[]{findWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "sendUniMPEvent", new Object[]{str, str2, str3, r0}});
            }
        } else if (jSCallback != null) {
            jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
        }
    }

    @JSMethod
    public void getUniMPVersion(String str, final JSCallback jSCallback) {
        new HashMap();
        if (!SDK.isUniMPSDK()) {
            if ((TextUtils.isEmpty(str) || !str.startsWith("__UNI__")) && jSCallback != null) {
                jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_INVALID_PARAMETER));
            }
            IWebview findWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance);
            if (findWebview != null) {
                WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, new Object[]{findWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "getUniMPVersion", new Object[]{str, new ICallBack() {
                    /* class io.dcloud.feature.weex.extend.DCUniMPModule.AnonymousClass8 */

                    @Override // io.dcloud.common.DHInterface.ICallBack
                    public Object onCallBack(int i, Object obj) {
                        if (obj == null) {
                            JSCallback jSCallback = jSCallback;
                            if (jSCallback == null) {
                                return null;
                            }
                            jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_RESOURCE_EXIST));
                            return null;
                        }
                        JSONObject parseObject = JSON.parseObject(obj.toString());
                        JSCallback jSCallback2 = jSCallback;
                        if (jSCallback2 == null) {
                            return null;
                        }
                        jSCallback2.invoke(EnumStateCode.obtainMap(EnumStateCode.SUCCESS_NO_BODY, "versionInfo", parseObject));
                        return null;
                    }
                }}});
            }
        } else if (jSCallback != null) {
            jSCallback.invoke(EnumStateCode.obtainMap(EnumStateCode.FAIL_BY_NO_PERMISSION));
        }
    }

    @JSMethod
    public void onUniMPEventReceive(JSCallback jSCallback) {
        IWebview findWebview;
        if (!SDK.isUniMPSDK() && (findWebview = WeexInstanceMgr.self().findWebview(this.mWXSDKInstance)) != null && (jSCallback instanceof SimpleJSCallback)) {
            WeexInstanceMgr.self().doForFeature(IMgr.MgrType.FeatureMgr, 10, new Object[]{findWebview.obtainApp(), WeexInstanceMgr.self().getUniMPFeature(), "onUniMPEventReceive", new Object[]{findWebview.obtainApp().obtainAppId(), this.mWXSDKInstance.getInstanceId(), ((SimpleJSCallback) jSCallback).getCallbackId()}});
        }
    }
}
