package io.dcloud.feature.weex.extend;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.common.Constants;
import com.taobao.weex.ui.action.BasicComponentData;
import com.taobao.weex.ui.component.WXComponent;
import com.taobao.weex.ui.component.WXVContainer;
import com.taobao.weex.utils.WXUtils;
import io.dcloud.common.util.ThrottleUtil;
import io.dcloud.feature.weex.adapter.IWeexMap;
import java.util.HashMap;

public class DCCoverViewComponent extends WXVContainer<ViewGroup> {
    HashMap<String, String> CalloutMarkerIds = new HashMap<>();
    private final ViewTreeObserver.OnDrawListener onDrawListener = new ViewTreeObserver.OnDrawListener() {
        /* class io.dcloud.feature.weex.extend.DCCoverViewComponent.AnonymousClass1 */

        public void onDraw() {
            DCCoverViewComponent.this.throttle.throttlePost(new Runnable() {
                /* class io.dcloud.feature.weex.extend.DCCoverViewComponent.AnonymousClass1.AnonymousClass1 */

                public void run() {
                    DCCoverViewComponent.this.updateCallout();
                }
            }, 50);
        }
    };
    private FrameLayout realView;
    private final ThrottleUtil throttle = new ThrottleUtil();

    public DCCoverViewComponent(WXSDKInstance wXSDKInstance, WXVContainer wXVContainer, BasicComponentData basicComponentData) {
        super(wXSDKInstance, wXVContainer, basicComponentData);
    }

    /* access modifiers changed from: protected */
    @Override // com.taobao.weex.ui.component.WXComponent
    public ViewGroup initComponentHostView(Context context) {
        ScrollView scrollView;
        String str = "";
        if (getStyles().containsKey(Constants.Name.OVERFLOW)) {
            str = WXUtils.getString(getStyles().get(Constants.Name.OVERFLOW), str);
        } else if (getStyles().containsKey("overflowY")) {
            str = WXUtils.getString(getStyles().get("overflowY"), str);
        }
        this.realView = new FrameLayout(context);
        if (str.equals("scroll")) {
            ScrollView scrollView2 = new ScrollView(context);
            scrollView2.addView(this.realView, new FrameLayout.LayoutParams(-1, -1));
            scrollView = scrollView2;
        } else {
            scrollView = this.realView;
        }
        Object obj = getAttrs().get("slot");
        if (obj != null && obj.equals("callout")) {
            scrollView.setVisibility(4);
            scrollView.getViewTreeObserver().addOnDrawListener(this.onDrawListener);
        }
        return scrollView;
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer, io.dcloud.feature.uniapp.ui.component.AbsVContainer, com.taobao.weex.ui.component.WXComponent
    public ViewGroup getRealView() {
        return this.realView;
    }

    public HashMap<String, String> getCalloutMarkerIds() {
        return this.CalloutMarkerIds;
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer
    public void addChild(WXComponent wXComponent, int i) {
        Object obj;
        if ((wXComponent instanceof DCCoverViewComponent) && (obj = wXComponent.getAttrs().get("markerId")) != null) {
            this.CalloutMarkerIds.put(obj.toString(), wXComponent.getRef());
            if (getHostView() != null) {
                ((ViewGroup) getHostView()).getViewTreeObserver().addOnDrawListener(this.onDrawListener);
            }
        }
        super.addChild(wXComponent, i);
    }

    @Override // io.dcloud.feature.uniapp.ui.component.AbsVContainer
    public void remove(WXComponent wXComponent, boolean z) {
        if (wXComponent instanceof DCCoverViewComponent) {
            Object obj = wXComponent.getAttrs().get("marker-id");
            if (obj != null && !this.CalloutMarkerIds.get(obj).equals(wXComponent.getRef())) {
                this.CalloutMarkerIds.remove(obj);
                return;
            }
            return;
        }
        super.remove(wXComponent, z);
    }

    public void updateCallout() {
        if (!this.CalloutMarkerIds.isEmpty() && (getParent() instanceof IDCCoverViewUpdate) && (getParent() instanceof IWeexMap)) {
            ((IDCCoverViewUpdate) getParent()).update(this.CalloutMarkerIds);
        }
        new Handler(Looper.getMainLooper()).post(new Runnable() {
            /* class io.dcloud.feature.weex.extend.DCCoverViewComponent.AnonymousClass2 */

            public void run() {
                if (DCCoverViewComponent.this.getHostView() != null) {
                    ((ViewGroup) DCCoverViewComponent.this.getHostView()).getViewTreeObserver().removeOnDrawListener(DCCoverViewComponent.this.onDrawListener);
                }
            }
        });
    }
}
