package io.dcloud.feature.weex.adapter.widget.refresh;

import android.content.Context;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;

public class WeexDcRefreshLayout extends DCWeexBaseRefreshLayout {
    private boolean mDragger;
    private float mStartX;
    private float mStartY;
    private int mTouchSlop;

    public WeexDcRefreshLayout(Context context) {
        super(context);
        this.mTouchSlop = ViewConfiguration.get(context).getScaledTouchSlop();
    }

    /* JADX WARNING: Code restructure failed: missing block: B:11:0x001b, code lost:
        if (r0 != 3) goto L_0x0058;
     */
    @Override // io.dcloud.feature.weex.adapter.widget.refresh.DCWeexBaseRefreshLayout
    public boolean onInterceptTouchEvent(MotionEvent motionEvent) {
        if (isEnabled()) {
            int action = motionEvent.getAction();
            if (!isViewRefresh()) {
                return false;
            }
            if (action != 0) {
                if (action != 1) {
                    if (action == 2) {
                        if (this.mDragger) {
                            return false;
                        }
                        float y = motionEvent.getY();
                        float abs = Math.abs(motionEvent.getX() - this.mStartX);
                        float abs2 = Math.abs(y - this.mStartY);
                        if (abs > ((float) this.mTouchSlop) && abs > abs2) {
                            this.mDragger = true;
                            return false;
                        }
                    }
                }
                this.mDragger = false;
            } else {
                this.mStartY = motionEvent.getY();
                this.mStartX = motionEvent.getX();
                this.mDragger = false;
            }
        }
        return super.onInterceptTouchEvent(motionEvent);
    }

    private boolean isViewRefresh() {
        for (int i = 0; i < getChildCount(); i++) {
            if (canScrollVertically(getChildAt(i))) {
                return false;
            }
        }
        return true;
    }

    private boolean canScrollVertically(View view) {
        if (view instanceof ViewGroup) {
            if (!view.canScrollVertically(-1)) {
                int i = 0;
                while (true) {
                    ViewGroup viewGroup = (ViewGroup) view;
                    if (i >= viewGroup.getChildCount()) {
                        break;
                    } else if (canScrollVertically(viewGroup.getChildAt(i))) {
                        return true;
                    } else {
                        i++;
                    }
                }
            } else {
                return true;
            }
        }
        return false;
    }
}
