package io.dcloud.feature.weex;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.graphics.Typeface;
import android.os.Build;
import android.os.Environment;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.ViewGroup;
import com.alibaba.android.bindingx.plugin.weex.BindingX;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.facebook.drawee.backends.pipeline.Fresco;
import com.taobao.weex.IWXStatisticsListener;
import com.taobao.weex.InitConfig;
import com.taobao.weex.WXEnvironment;
import com.taobao.weex.WXSDKEngine;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.WXSDKManager;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.common.Constants;
import com.taobao.weex.common.RenderTypes;
import com.taobao.weex.common.WXConfig;
import com.taobao.weex.common.WXRenderStrategy;
import com.taobao.weex.ui.IFComponentHolder;
import com.taobao.weex.ui.SimpleComponentHolder;
import com.taobao.weex.ui.component.WXBasicComponentType;
import com.taobao.weex.utils.tools.TimeCalculator;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IConfusionMgr;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.INativeAppInfo;
import io.dcloud.common.DHInterface.IUniInstanceMgr;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.io.UnicodeInputStream;
import io.dcloud.common.adapter.ui.webview.WebLoadEvent;
import io.dcloud.common.adapter.util.AndroidResources;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.IOUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.language.LanguageUtil;
import io.dcloud.feature.internal.sdk.SDK;
import io.dcloud.feature.uniapp.UniMoudlesLoader;
import io.dcloud.feature.uniapp.UniSDKInstance;
import io.dcloud.feature.weex.adapter.DCDefaultConfigAdapter;
import io.dcloud.feature.weex.adapter.DCVueBridgeAdapter;
import io.dcloud.feature.weex.adapter.DCWXHttpAdapter;
import io.dcloud.feature.weex.adapter.DefaultWebSocketAdapterFactory;
import io.dcloud.feature.weex.adapter.Fresco.DCGenericDraweeView;
import io.dcloud.feature.weex.adapter.Fresco.imagepipeline.OkHttpImagePipelineConfigFactory;
import io.dcloud.feature.weex.adapter.FrescoDrawableLoader;
import io.dcloud.feature.weex.adapter.FrescoImageAdapter;
import io.dcloud.feature.weex.adapter.FrescoImageComponent;
import io.dcloud.feature.weex.adapter.FrescoImageComponentU;
import io.dcloud.feature.weex.adapter.JSExceptionAdapter;
import io.dcloud.feature.weex.adapter.PlusUriAdapter;
import io.dcloud.feature.weex.adapter.ScalableViewComponent;
import io.dcloud.feature.weex.adapter.webview.WXDCWeb;
import io.dcloud.feature.weex.extend.DCCoverImageComponent;
import io.dcloud.feature.weex.extend.DCCoverViewComponent;
import io.dcloud.feature.weex.extend.DCTabBarModule;
import io.dcloud.feature.weex.extend.DCUniMPModule;
import io.dcloud.feature.weex.extend.DCWXSlider;
import io.dcloud.feature.weex.extend.DCWXView;
import io.dcloud.feature.weex.extend.PlusModule;
import io.dcloud.feature.weex.extend.PlusStorageModule;
import io.dcloud.feature.weex.extend.RandomBytesModule;
import io.dcloud.feature.weex.extend.WXEventModule;
import io.dcloud.feature.weex_websocket.UniWebSocketModule;
import io.dcloud.weex.MoudlesLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class WeexInstanceMgr implements IWXStatisticsListener, IUniInstanceMgr {
    static final String SERVICE_NAME = "weexPlus";
    private static WeexInstanceMgr instance;
    String TAG = "WeexInstanceMgr";
    private ArrayList<IWXStatisticsCallBack> callBacks = new ArrayList<>();
    private String complier = "weex";
    private String control = AbsoluteConst.UNI_V3;
    private AbsMgr featureMgr;
    private LinkedHashMap<String, WXViewWrapper> instanceHashMap = new LinkedHashMap<>(16);
    private boolean isAssetsRes = false;
    private boolean isJSFKFileNotFound = false;
    private boolean isJsFrameworkReady = false;
    private boolean isUniServiceCreated = false;
    private boolean isWeexInitEnd = false;
    private String jsSACName = "uni-app-config";
    private Application mApplication = null;
    private IConfusionMgr mConfusionMgr;
    private Handler mHandler;
    private String mPreInstanceId = null;
    private String mPreUniAppid = null;
    private Map<String, ICallBack> mPreUniMPCallBackMap = new HashMap();
    private ArrayList<ICallBack> mReladyCallBacks = new ArrayList<>();
    private ICallBack mRestartReadyCall;
    private String mUniNViewModules = null;
    private int mVueVersion = 2;
    private String render = "auto";
    private StringBuffer sb;
    private HashMap<String, WXServiceWrapper> serviceWrapperMapsCache = new HashMap<>(3);

    /* access modifiers changed from: package-private */
    public interface EachListener<T> {
        void onEach(T t);
    }

    public interface IWXStatisticsCallBack {
        void onJsFrameworkReady();
    }

    @Override // com.taobao.weex.IWXStatisticsListener
    public void onException(String str, String str2, String str3) {
    }

    @Override // com.taobao.weex.IWXStatisticsListener
    public void onFirstScreen() {
    }

    @Override // com.taobao.weex.IWXStatisticsListener
    public void onFirstView() {
    }

    @Override // com.taobao.weex.IWXStatisticsListener
    public void onHeadersReceived() {
    }

    @Override // com.taobao.weex.IWXStatisticsListener
    public void onHttpFinish() {
    }

    @Override // com.taobao.weex.IWXStatisticsListener
    public void onHttpStart() {
    }

    @Override // com.taobao.weex.IWXStatisticsListener
    public void onJsFrameworkStart() {
    }

    @Override // com.taobao.weex.IWXStatisticsListener
    public void onSDKEngineInitialize() {
    }

    public static synchronized WeexInstanceMgr self() {
        WeexInstanceMgr weexInstanceMgr;
        synchronized (WeexInstanceMgr.class) {
            if (instance == null) {
                instance = new WeexInstanceMgr();
            }
            weexInstanceMgr = instance;
        }
        return weexInstanceMgr;
    }

    public void setUniNViewModules(String str) {
        this.mUniNViewModules = str;
        if (this.mReladyCallBacks.size() > 0) {
            Iterator<ICallBack> it = this.mReladyCallBacks.iterator();
            while (it.hasNext()) {
                it.next().onCallBack(0, str);
            }
            this.mReladyCallBacks.clear();
        }
    }

    public String getUniNViewModules() {
        return this.mUniNViewModules;
    }

    public void setUniNViewModuleReladyCallBack(ICallBack iCallBack) {
        if (!this.mReladyCallBacks.contains(iCallBack)) {
            this.mReladyCallBacks.add(iCallBack);
        }
    }

    /* access modifiers changed from: package-private */
    public void init(AbsMgr absMgr) {
        this.featureMgr = absMgr;
    }

    public String getUniMPFeature() {
        return "UniMP".toLowerCase(Locale.ENGLISH);
    }

    @Override // io.dcloud.common.DHInterface.IUniInstanceMgr
    public void initWeexEnv(INativeAppInfo iNativeAppInfo) {
        if (iNativeAppInfo != null) {
            this.mConfusionMgr = iNativeAppInfo.getCofusionMgr();
            initWeexEnv(iNativeAppInfo.getApplication());
        }
    }

    public void initWeexEnv(Application application) {
        if (!SDK.isUniMPSDK()) {
            PlatformUtil.invokeMethod("io.dcloud.feature.weex.WeexDevtoolImpl", "registerReloadReceiver", null, new Class[]{Application.class}, new Object[]{application});
        }
        self().setApplication(application);
        if (!WXSDKEngine.isInitialized()) {
            InitConfig.Builder builder = new InitConfig.Builder();
            self().initAppForPath(application, null);
            self().initJSFramework(application, null);
            if (!SDK.isUniMPSDK()) {
                PlatformUtil.invokeMethod("io.dcloud.feature.weex.WeexDevtoolImpl", "initDebugEnvironment", null, new Class[]{Application.class}, new Object[]{application});
            }
            DCWXHttpAdapter dCWXHttpAdapter = new DCWXHttpAdapter();
            builder.setHttpAdapter(dCWXHttpAdapter);
            Fresco.initialize(application, OkHttpImagePipelineConfigFactory.newBuilder(application, dCWXHttpAdapter.getImageOkHttpClient()).build());
            JSON.setDefaultTypeKey("@type_ft");
            DCGenericDraweeView.initialize(Fresco.getDraweeControllerBuilderSupplier());
            builder.setImgAdapter(new FrescoImageAdapter());
            builder.setDrawableLoader(new FrescoDrawableLoader(application));
            builder.setURIAdapter(new PlusUriAdapter());
            builder.setDCVueBridgeAdapter(new DCVueBridgeAdapter());
            builder.setWebSocketAdapterFactory(new DefaultWebSocketAdapterFactory());
            builder.setJSExceptionAdapter(new JSExceptionAdapter());
            InitConfig build = builder.build();
            WXSDKManager.getInstance().setWxConfigAdapter(new DCDefaultConfigAdapter());
            WXSDKEngine.initialize(application, build);
            self().initStatisticsListener();
            try {
                String str = new String(PlatformUtil.getFileContent("io/dcloud/weexUniJs.js", 1));
                this.sb = new StringBuffer();
                String configParam = self().getConfigParam();
                StringBuffer stringBuffer = this.sb;
                stringBuffer.append("var plusContext = {};plusContext.getLocationHerf = function(plus){\n    return plus.weex.config.bundleUrl;\n};var param = " + configParam + ";");
                this.sb.append(str);
                WXSDKEngine.registerComponent("image", FrescoImageComponent.class);
                WXSDKEngine.registerComponent("cover-view", DCCoverViewComponent.class);
                WXSDKEngine.registerComponent("u-image", FrescoImageComponentU.class);
                WXSDKEngine.registerComponent("cover-image", DCCoverImageComponent.class);
                WXSDKEngine.registerComponent((IFComponentHolder) new SimpleComponentHolder(ScalableViewComponent.class, new ScalableViewComponent.Ceator()), false, "u-scalable");
                WXSDKEngine.registerComponent((IFComponentHolder) new SimpleComponentHolder(DCWXSlider.class, new DCWXSlider.Creator()), true, WXBasicComponentType.SLIDER);
                WXSDKEngine.registerComponent((IFComponentHolder) new SimpleComponentHolder(DCWXView.class, new DCWXView.Ceator()), false, WXBasicComponentType.VIEW);
                WXSDKEngine.registerComponent("u-web-view", WXDCWeb.class);
                WXSDKEngine.registerModule(IApp.ConfigProperty.CONFIG_PLUS, PlusModule.class);
                WXSDKEngine.registerModule("DCloud-Crypto", RandomBytesModule.class);
                WXSDKEngine.registerModule("plusstorage", PlusStorageModule.class);
                WXSDKEngine.registerModule("uni-tabview", DCTabBarModule.class);
                addComponentByName(WXBasicComponentType.DIV, ScalableViewComponent.class);
                if (PdrUtil.isUniMPHostForUniApp() && !SDK.isUniMPSDK()) {
                    WXSDKEngine.registerModule("uniMP", DCUniMPModule.class);
                }
                WXSDKEngine.registerModule("event", WXEventModule.class);
                if (this.sb != null) {
                    WXSDKEngine.registerService(SERVICE_NAME, this.sb.toString(), new HashMap());
                }
                if (!SDK.isUniMPSDK()) {
                    self().registerUniappService(application, "");
                }
                WXEnvironment.setGlobalFontFamily("unincomponents", Typeface.createFromAsset(application.getAssets(), "fonts/unincomponents.ttf"));
                WXSDKEngine.registerModule("uni-webSocket", UniWebSocketModule.class);
                BindingX.register();
                registerReflexWeexPlugin(application);
                setWeexInitEnd(true);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setApplication(Application application) {
        this.mApplication = application;
    }

    @Override // io.dcloud.common.DHInterface.IUniInstanceMgr
    public void restartWeex(final Application application, final ICallBack iCallBack, final String str) {
        if (((getControl().equals(AbsoluteConst.UNI_V3) && isWeexInitEnd() && !BaseInfo.isFirstRun) || (SDK.isUniMPSDK() && isWeexInitEnd())) && this.mPreInstanceId == null) {
            Logger.e(this.TAG, "restartWeex-------");
            if (this.instanceHashMap.size() > 0) {
                onActivityDestroy(false);
            }
            getHandler().post(new Runnable() {
                /* class io.dcloud.feature.weex.WeexInstanceMgr.AnonymousClass1 */

                public void run() {
                    WeexInstanceMgr.this.unRegisterUniappService();
                    WeexInstanceMgr.this.mRestartReadyCall = iCallBack;
                    WeexInstanceMgr.this.mApplication = application;
                    WeexInstanceMgr weexInstanceMgr = WeexInstanceMgr.this;
                    weexInstanceMgr.initAppForPath(weexInstanceMgr.mApplication, str);
                    WeexInstanceMgr.this.setJsFrameworkReady(false);
                    WeexInstanceMgr.this.initJSFramework(application, str);
                    WeexInstanceMgr.this.registerUniappService(application, str);
                    WXSDKEngine.restartWeex();
                }
            });
        }
    }

    @Override // io.dcloud.common.DHInterface.IUniInstanceMgr
    public void loadWeexToAppid(Context context, String str, boolean z) {
        int vueVersion = getVueVersion();
        initAppForPath(context, str);
        initJSFramework(context, str);
        if (getVueVersion() != vueVersion) {
            z = true;
        }
        if (!WXBridgeManager.getInstance().isJSFrameworkInit() || z) {
            setJsFrameworkReady(false);
            WXSDKEngine.restartWeex();
        }
    }

    @Override // io.dcloud.common.DHInterface.IUniInstanceMgr
    public void onCreateProcess(Application application, Boolean bool) {
        MoudlesLoader.getInstance().initHooksClass(application, bool);
    }

    public void initStatisticsListener() {
        WXSDKManager.getInstance().registerStatisticsListener(this);
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void initJSFramework(Context context, String str) {
        JSONObject jSONObject;
        JSONObject jSONObject2;
        InputStream appFileStream = getAppFileStream(context, str, BaseInfo.sConfigXML);
        if (appFileStream != null) {
            try {
                JSONObject parseObject = JSON.parseObject(handleEncryptionInputStream(appFileStream, context, true));
                if (parseObject != null && parseObject.containsKey(IApp.ConfigProperty.CONFIG_PLUS)) {
                    JSONObject jSONObject3 = parseObject.getJSONObject(IApp.ConfigProperty.CONFIG_PLUS);
                    if (jSONObject3 != null && jSONObject3.containsKey("uni-app")) {
                        JSONObject jSONObject4 = jSONObject3.getJSONObject("uni-app");
                        self().control = AbsoluteConst.UNI_V3;
                        if (jSONObject4.containsKey("renderer")) {
                            self().render = jSONObject4.getString("renderer");
                        }
                        if (jSONObject4.containsKey("nvueCompiler")) {
                            self().complier = jSONObject4.getString("nvueCompiler");
                        }
                        if (jSONObject4.containsKey("vueVersion")) {
                            self().mVueVersion = jSONObject4.getIntValue("vueVersion");
                        } else {
                            self().mVueVersion = 2;
                        }
                        if (jSONObject4.containsKey("useJSProcess")) {
                            if (AbsoluteConst.FALSE.equals(jSONObject4.getString("useJSProcess"))) {
                                WXBridgeManager.getInstance().setUseSingleProcess(true);
                            } else {
                                WXBridgeManager.getInstance().setUseSingleProcess(false);
                            }
                        }
                        if (jSONObject4.containsKey("webView") && (jSONObject2 = jSONObject4.getJSONObject("webView")) != null) {
                            try {
                                if (jSONObject2.containsKey("minUserAgentVersion")) {
                                    BaseInfo.minUserAgentVersion = jSONObject2.getString("minUserAgentVersion");
                                }
                                if (jSONObject2.containsKey("x5")) {
                                    JSONObject jSONObject5 = jSONObject2.getJSONObject("x5");
                                    if (jSONObject5.containsKey("timeOut")) {
                                        BaseInfo.timeOut = jSONObject5.getIntValue("timeOut");
                                    }
                                    if (jSONObject5.containsKey("showTipsWithoutWifi")) {
                                        BaseInfo.showTipsWithoutWifi = jSONObject5.getBooleanValue("showTipsWithoutWifi");
                                    }
                                    if (jSONObject5.containsKey("allowDownloadWithoutWiFi")) {
                                        BaseInfo.allowDownloadWithoutWiFi = jSONObject5.getBooleanValue("allowDownloadWithoutWiFi");
                                    }
                                }
                            } catch (Exception unused) {
                            }
                        }
                    }
                    if (!(jSONObject3 == null || !jSONObject3.containsKey(IApp.ConfigProperty.CONFIG_UNISTATISTICS) || (jSONObject = jSONObject3.getJSONObject(IApp.ConfigProperty.CONFIG_UNISTATISTICS)) == null)) {
                        JSONObject jSONObject6 = new JSONObject();
                        try {
                            if (jSONObject.containsKey(WebLoadEvent.ENABLE)) {
                                jSONObject6.put(WebLoadEvent.ENABLE, jSONObject.get(WebLoadEvent.ENABLE));
                            }
                            if (jSONObject.containsKey("version")) {
                                jSONObject6.put("version", jSONObject.get("version"));
                            }
                            if (jSONObject.containsKey("uniCloud")) {
                                jSONObject6.put("uniCloud", (Object) jSONObject.getJSONObject("uniCloud"));
                            }
                            AppRuntime.setUniStatistics(jSONObject6.toJSONString());
                        } catch (Exception unused2) {
                        }
                    }
                    if (jSONObject3 != null && jSONObject3.containsKey("renderer")) {
                        BaseInfo.renderer = jSONObject3.getString("renderer");
                    }
                }
            } catch (Exception unused3) {
            }
        }
    }

    /* JADX WARNING: Removed duplicated region for block: B:24:0x0057  */
    /* JADX WARNING: Removed duplicated region for block: B:41:? A[RETURN, SYNTHETIC] */
    private InputStream getAppFileStream(Context context, String str, String str2) {
        Exception e;
        boolean z;
        String str3;
        InputStream inputStream;
        String str4;
        InputStream inputStream2 = null;
        try {
            AndroidResources.initAndroidResources(context);
            if (TextUtils.isEmpty(str)) {
                BaseInfo.parseControl();
            } else {
                BaseInfo.sDefaultBootApp = str;
            }
            if (!BaseInfo.ISDEBUG) {
                if (!DHFile.hasFile()) {
                    z = false;
                    str3 = "apps/" + BaseInfo.sDefaultBootApp + "/www/" + str2;
                    if (this.isAssetsRes && !BaseInfo.SyncDebug && !SDK.isUniMPSDK()) {
                        inputStream = context.getResources().getAssets().open(str3);
                        if (inputStream != null) {
                            return inputStream;
                        }
                        if (z) {
                            try {
                                str4 = Environment.getExternalStorageDirectory().getPath() + "/Android/data/" + context.getPackageName();
                            } catch (Exception e2) {
                                e = e2;
                                inputStream2 = inputStream;
                                e.printStackTrace();
                                return inputStream2;
                            }
                        } else {
                            str4 = context.getFilesDir().getPath();
                        }
                        File file = new File(str4 + "/" + str3);
                        if (file.exists()) {
                            inputStream2 = new FileInputStream(file);
                        } else {
                            try {
                                inputStream2 = context.getResources().getAssets().open(str3);
                            } catch (Exception unused) {
                            }
                        }
                        if (inputStream2 == null) {
                            return inputStream;
                        }
                        return inputStream2;
                    }
                    inputStream = null;
                    if (inputStream != null) {
                    }
                }
            }
            z = true;
            str3 = "apps/" + BaseInfo.sDefaultBootApp + "/www/" + str2;
            try {
                inputStream = context.getResources().getAssets().open(str3);
            } catch (Exception unused2) {
            }
            if (inputStream != null) {
            }
        } catch (Exception e3) {
            e = e3;
            e.printStackTrace();
            return inputStream2;
        }
    }

    public void initAppForPath(Context context, String str) {
        this.isAssetsRes = AppRuntime.isAppResourcesInAssetsPath(context, str);
    }

    private String handleEncryptionInputStream(InputStream inputStream, Context context, boolean z) {
        System.currentTimeMillis();
        if (z) {
            inputStream = new UnicodeInputStream(inputStream, Charset.defaultCharset().name());
        }
        byte[] bArr = new byte[0];
        try {
            bArr = IOUtil.getBytes(inputStream);
        } catch (IOException e) {
            e.printStackTrace();
        }
        String str = null;
        IConfusionMgr iConfusionMgr = this.mConfusionMgr;
        if (iConfusionMgr != null) {
            str = iConfusionMgr.handleEncryption(context.getApplicationContext(), bArr);
        }
        return TextUtils.isEmpty(str) ? new String(bArr) : str;
    }

    @Override // io.dcloud.common.DHInterface.IUniInstanceMgr
    public void registerUniappService(Context context, String str) {
        InputStream appFileStream;
        if (self().control.equals(AbsoluteConst.UNI_V3) && (appFileStream = self().getAppFileStream(context, str, "app-config-service.js")) != null) {
            try {
                WXSDKEngine.registerService(this.jsSACName, handleEncryptionInputStream(appFileStream, context, false), new HashMap());
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.IUniInstanceMgr
    public boolean isUniAppAssetsRes() {
        return this.isAssetsRes;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void unRegisterUniappService() {
        WXSDKEngine.unRegisterService(this.jsSACName);
    }

    private void registerReflexWeexPlugin(Context context) {
        PlatformUtil.invokeMethod("io.dcloud.feature.weex_amap.AMapPluginImpl", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        PlatformUtil.invokeMethod("io.dcloud.feature.weex.map.google.GoogleMapPluginImpl", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        PlatformUtil.invokeMethod("io.dcloud.feature.weex_scroller.DCScrollerPluginImpl", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        PlatformUtil.invokeMethod("io.dcloud.feature.weex_barcode.BarcodePlugin", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        PlatformUtil.invokeMethod("io.dcloud.feature.utsplugin.UTSPlugin", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        PlatformUtil.invokeMethod("io.dcloud.feature.weex_livepusher.LivePusherPlugin", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        PlatformUtil.invokeMethod("io.dcloud.feature.weex_media.VideoPlayerPlugin", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        PlatformUtil.invokeMethod("io.dcloud.feature.weex_text.DCWXTextPlugin", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        PlatformUtil.invokeMethod("io.dcloud.feature.weex_input.DCWXInputRegister", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        PlatformUtil.invokeMethod("io.dcloud.feature.gcanvas.GCanvasRegister", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        PlatformUtil.invokeMethod("io.dcloud.feature.weex_switch.DCWXSwitchPlugin", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        PlatformUtil.invokeMethod("io.dcloud.feature.weex_ad.DCWXAdPlugin", "initPlugin", null, new Class[]{Context.class}, new Object[]{context});
        Object invokeFieldValue = PlatformUtil.invokeFieldValue("com.taobao.weex.devtools.inspector.elements.android.WXComponentDescriptor", "sClassName", null);
        if (invokeFieldValue != null && (invokeFieldValue instanceof HashMap)) {
            HashMap hashMap = (HashMap) invokeFieldValue;
            hashMap.put(FrescoImageComponent.class, "image");
            hashMap.put(FrescoImageComponentU.class, "image");
            hashMap.put(WXDCWeb.class, "web-view");
            hashMap.put(DCWXView.class, WXBasicComponentType.VIEW);
            hashMap.put(DCCoverViewComponent.class, "cover-view");
            hashMap.put(DCWXSlider.class, WXBasicComponentType.SLIDER);
        }
    }

    public void addComponentByName(String str, Class cls) {
        try {
            Object invokeFieldValue = PlatformUtil.invokeFieldValue("com.taobao.weex.devtools.inspector.elements.android.WXComponentDescriptor", "sClassName", null);
            if (invokeFieldValue != null && (invokeFieldValue instanceof HashMap)) {
                ((HashMap) invokeFieldValue).put(cls, str);
            }
        } catch (Exception unused) {
        }
    }

    private String getConfigParam() {
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("__HtMl_Id__", (Object) "__uniapp_webview");
        jSONObject.put(RenderTypes.RENDER_TYPE_NATIVE, (Object) 1);
        jSONObject.put("debug", (Object) true);
        JSONObject jSONObject2 = new JSONObject();
        jSONObject2.put("language", (Object) LanguageUtil.getDeviceDefLocalLanguage());
        jSONObject2.put("version", (Object) Build.VERSION.RELEASE);
        jSONObject2.put("name", (Object) TimeCalculator.PLATFORM_ANDROID);
        jSONObject2.put("vendor", (Object) "Google");
        jSONObject.put(WXConfig.os, (Object) jSONObject2);
        JSONObject jSONObject3 = new JSONObject();
        jSONObject3.put("CONNECTION_TYPE", (Object) 0);
        jSONObject.put("networkinfo", (Object) jSONObject3);
        return jSONObject.toJSONString();
    }

    public WXViewWrapper createWeexView(IWebview iWebview, ViewGroup viewGroup, org.json.JSONObject jSONObject, String str, int i) {
        WXViewWrapper makeWXViewWrapper = makeWXViewWrapper(iWebview, viewGroup, jSONObject, str, i);
        makeWXViewWrapper.loadTemplate(jSONObject);
        return makeWXViewWrapper;
    }

    private WXViewWrapper makeWXViewWrapper(IWebview iWebview, ViewGroup viewGroup, org.json.JSONObject jSONObject, String str, int i) {
        WXViewWrapper wXViewWrapper = new WXViewWrapper(iWebview, viewGroup, jSONObject, str, i, (!str.equals("__uniapp__service") || this.mPreUniAppid == null || WXSDKManager.getInstance().getSDKInstance(this.mPreInstanceId) == null) ? false : true);
        if (this.instanceHashMap.containsKey(str)) {
            this.instanceHashMap.remove(str).mWXSDKInstance.destroy();
        }
        this.instanceHashMap.put(str, wXViewWrapper);
        return wXViewWrapper;
    }

    public WXServiceWrapper createWeexService(IApp iApp, ViewGroup viewGroup, String str, org.json.JSONObject jSONObject) {
        WXServiceWrapper wXServiceWrapper = new WXServiceWrapper(iApp, viewGroup, str, jSONObject);
        this.serviceWrapperMapsCache.put(str, wXServiceWrapper);
        return wXServiceWrapper;
    }

    /* access modifiers changed from: package-private */
    public WXViewWrapper findWXViewWrapper(String str) {
        if (this.instanceHashMap.containsKey(str)) {
            return this.instanceHashMap.get(str);
        }
        return null;
    }

    public WXServiceWrapper findWXServiceWrapper(WXSDKInstance wXSDKInstance) {
        if (this.serviceWrapperMapsCache.size() <= 0) {
            return null;
        }
        for (String str : this.serviceWrapperMapsCache.keySet()) {
            WXServiceWrapper wXServiceWrapper = this.serviceWrapperMapsCache.get(str);
            if (wXServiceWrapper != null && wXServiceWrapper.mWXSDKInstance == wXSDKInstance) {
                return wXServiceWrapper;
            }
        }
        return null;
    }

    public void reloadWXServiceWrapper() {
        if (this.serviceWrapperMapsCache.size() > 0) {
            for (String str : this.serviceWrapperMapsCache.keySet()) {
                WXServiceWrapper wXServiceWrapper = this.serviceWrapperMapsCache.get(str);
                if (wXServiceWrapper != null) {
                    wXServiceWrapper.reload();
                }
            }
        }
    }

    public WXSDKInstance findWXSDKInstance(String str) {
        if (this.serviceWrapperMapsCache.containsKey(str)) {
            return this.serviceWrapperMapsCache.get(str).mWXSDKInstance;
        }
        if (this.instanceHashMap.containsKey(str)) {
            return this.instanceHashMap.get(str).mWXSDKInstance;
        }
        return null;
    }

    /* access modifiers changed from: package-private */
    public WXBaseWrapper findWXBaseWrapper(String str) {
        if (this.serviceWrapperMapsCache.containsKey(str)) {
            return this.serviceWrapperMapsCache.get(str);
        }
        if (this.instanceHashMap.containsKey(str)) {
            return this.instanceHashMap.get(str);
        }
        return null;
    }

    /* JADX DEBUG: Multi-variable search result rejected for r7v0, resolved type: io.dcloud.common.DHInterface.IApp */
    /* JADX WARN: Multi-variable type inference failed */
    public IWebview findWebview(IWebview iWebview, IApp iApp, String str, String str2) {
        AbsMgr absMgr = this.featureMgr;
        IMgr.MgrType mgrType = IMgr.MgrType.FeatureMgr;
        Object[] objArr = new Object[4];
        if (iWebview == null) {
            iWebview = iApp;
        }
        objArr[0] = iWebview;
        objArr[1] = AbsoluteConst.F_UI;
        objArr[2] = "findWebview";
        objArr[3] = new String[]{str, str2};
        Object processEvent = absMgr.processEvent(mgrType, 10, objArr);
        if (processEvent instanceof IWebview) {
            return (IWebview) processEvent;
        }
        return null;
    }

    public Object doForFeature(IMgr.MgrType mgrType, int i, Object[] objArr) {
        AbsMgr absMgr = this.featureMgr;
        if (absMgr != null) {
            return absMgr.processEvent(mgrType, i, objArr);
        }
        return null;
    }

    public WXBaseWrapper findWXBaseWrapper(WXSDKInstance wXSDKInstance) {
        WXViewWrapper wXViewWrapper = null;
        for (String str : this.instanceHashMap.keySet()) {
            WXViewWrapper wXViewWrapper2 = this.instanceHashMap.get(str);
            if (wXViewWrapper2 != null && wXViewWrapper2.mWXSDKInstance == wXSDKInstance) {
                wXViewWrapper = wXViewWrapper2;
            }
        }
        return wXViewWrapper;
    }

    public IWebview findWebview(WXSDKInstance wXSDKInstance) {
        for (String str : this.instanceHashMap.keySet()) {
            WXViewWrapper wXViewWrapper = this.instanceHashMap.get(str);
            if (wXViewWrapper != null && wXViewWrapper.mWXSDKInstance == wXSDKInstance) {
                return wXViewWrapper.mWebview;
            }
        }
        return null;
    }

    public IWebview findWebviewByInstanceId(String str) {
        for (String str2 : this.instanceHashMap.keySet()) {
            WXViewWrapper wXViewWrapper = this.instanceHashMap.get(str2);
            if (wXViewWrapper != null && wXViewWrapper.mWXSDKInstance.getInstanceId().equals(str)) {
                return wXViewWrapper.mWebview;
            }
        }
        return null;
    }

    public WXViewWrapper findPathByWrapper(String str) {
        if (TextUtils.isEmpty(str)) {
            return null;
        }
        for (String str2 : this.instanceHashMap.keySet()) {
            WXViewWrapper wXViewWrapper = this.instanceHashMap.get(str2);
            String initSrcPath = wXViewWrapper.initSrcPath(str);
            String srcPath = wXViewWrapper.getSrcPath();
            if (!(wXViewWrapper == null || TextUtils.isEmpty(srcPath) || !srcPath.equals(initSrcPath))) {
                return wXViewWrapper;
            }
        }
        return null;
    }

    public void removeWeexView(String str) {
        if (this.instanceHashMap.containsKey(str)) {
            this.instanceHashMap.remove(str).onDestroy();
        }
    }

    /* access modifiers changed from: package-private */
    public void onActivityResume() {
        forEach(new EachListener<WXBaseWrapper>() {
            /* class io.dcloud.feature.weex.WeexInstanceMgr.AnonymousClass2 */

            public void onEach(WXBaseWrapper wXBaseWrapper) {
                wXBaseWrapper.onActivityResume();
            }
        });
    }

    /* access modifiers changed from: package-private */
    public void onActivityPause() {
        forEach(new EachListener<WXBaseWrapper>() {
            /* class io.dcloud.feature.weex.WeexInstanceMgr.AnonymousClass3 */

            public void onEach(WXBaseWrapper wXBaseWrapper) {
                wXBaseWrapper.onActivityPause();
            }
        });
    }

    /* access modifiers changed from: package-private */
    public void onActivityResult(final int i, final int i2, final Intent intent) {
        forEach(new EachListener<WXBaseWrapper>() {
            /* class io.dcloud.feature.weex.WeexInstanceMgr.AnonymousClass4 */

            public void onEach(WXBaseWrapper wXBaseWrapper) {
                wXBaseWrapper.onActivityResult(i, i2, intent);
            }
        });
    }

    /* access modifiers changed from: package-private */
    public void onActivityDestroy() {
        onActivityDestroy(true);
    }

    /* access modifiers changed from: package-private */
    public void onActivityDestroy(boolean z) {
        this.mPreUniAppid = null;
        this.mPreInstanceId = null;
        if (this.instanceHashMap.size() > 0 || this.serviceWrapperMapsCache.size() > 0) {
            if (z) {
                getHandler().postDelayed(new Runnable() {
                    /* class io.dcloud.feature.weex.WeexInstanceMgr.AnonymousClass5 */

                    public void run() {
                        WeexInstanceMgr.this.wrapperDestroy();
                    }
                }, 200);
            } else {
                getHandler().post(new Runnable() {
                    /* class io.dcloud.feature.weex.WeexInstanceMgr.AnonymousClass6 */

                    public void run() {
                        WeexInstanceMgr.this.wrapperDestroy();
                    }
                });
            }
        }
        this.mPreUniMPCallBackMap.clear();
        this.mApplication = null;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void wrapperDestroy() {
        forEach(new EachListener<WXBaseWrapper>() {
            /* class io.dcloud.feature.weex.WeexInstanceMgr.AnonymousClass7 */

            public void onEach(WXBaseWrapper wXBaseWrapper) {
                if (wXBaseWrapper != null) {
                    wXBaseWrapper.onDestroy();
                }
            }
        });
        this.instanceHashMap.clear();
        this.serviceWrapperMapsCache.clear();
        if (SDK.isUniMPSDK()) {
            reloadWeexEngine();
        }
    }

    private void reloadWeexEngine() {
        unRegisterUniappService();
        WXSDKEngine.reload();
    }

    private void forEach(EachListener eachListener) {
        try {
            Collection<WXViewWrapper> values = this.instanceHashMap.values();
            if (values != null) {
                for (WXViewWrapper wXViewWrapper : values) {
                    if (wXViewWrapper != null) {
                        eachListener.onEach(wXViewWrapper);
                    }
                }
            }
            Collection<WXServiceWrapper> values2 = this.serviceWrapperMapsCache.values();
            if (values2 != null) {
                for (WXServiceWrapper wXServiceWrapper : values2) {
                    if (wXServiceWrapper != null) {
                        eachListener.onEach(wXServiceWrapper);
                    }
                }
            }
        } catch (Exception e) {
            Logger.e("forEach---" + e.getMessage());
        }
    }

    public void weexDebugReload() {
        LinkedHashMap<String, WXViewWrapper> linkedHashMap = this.instanceHashMap;
        if (linkedHashMap != null && linkedHashMap.size() > 0) {
            Iterator<String> it = this.instanceHashMap.keySet().iterator();
            if (it.hasNext()) {
                this.instanceHashMap.get(it.next()).mWebview.obtainFrameView().obtainWindowMgr().processEvent(IMgr.MgrType.AppMgr, 3, "snc:CID");
            }
        }
    }

    public void onRequestPermissionsResult(final int i, final String[] strArr, final int[] iArr) {
        forEach(new EachListener<WXBaseWrapper>() {
            /* class io.dcloud.feature.weex.WeexInstanceMgr.AnonymousClass8 */

            public void onEach(WXBaseWrapper wXBaseWrapper) {
                if (wXBaseWrapper != null) {
                    wXBaseWrapper.onRequestPermissionsResult(i, strArr, iArr);
                }
            }
        });
    }

    public String getComplier() {
        return this.complier;
    }

    public String getControl() {
        return this.control;
    }

    public int getVueVersion() {
        return this.mVueVersion;
    }

    public boolean isWeexInitEnd() {
        return this.isWeexInitEnd;
    }

    public void setWeexInitEnd(boolean z) {
        this.isWeexInitEnd = z;
    }

    public void setJsFrameworkReady(boolean z) {
        this.isJsFrameworkReady = z;
    }

    public boolean isJsFrameworkReady() {
        return this.isJsFrameworkReady;
    }

    @Override // com.taobao.weex.IWXStatisticsListener
    public void onJsFrameworkReady() {
        this.isJsFrameworkReady = true;
        if (this.mRestartReadyCall != null) {
            MessageHandler.sendMessage(new MessageHandler.IMessages() {
                /* class io.dcloud.feature.weex.WeexInstanceMgr.AnonymousClass9 */

                @Override // io.dcloud.common.adapter.util.MessageHandler.IMessages
                public void execute(Object obj) {
                    WeexInstanceMgr.this.mRestartReadyCall.onCallBack(1, null);
                    WeexInstanceMgr.this.mRestartReadyCall = null;
                }
            }, null);
        }
        ArrayList<IWXStatisticsCallBack> arrayList = this.callBacks;
        if (arrayList != null) {
            Iterator<IWXStatisticsCallBack> it = arrayList.iterator();
            while (it.hasNext()) {
                it.next().onJsFrameworkReady();
            }
        }
    }

    public void setWXStatisticsCallBack(IWXStatisticsCallBack iWXStatisticsCallBack) {
        if (!this.callBacks.contains(iWXStatisticsCallBack)) {
            this.callBacks.add(iWXStatisticsCallBack);
        }
    }

    public void unWXStatisticsCallBack(IWXStatisticsCallBack iWXStatisticsCallBack) {
        if (this.callBacks.contains(iWXStatisticsCallBack)) {
            this.callBacks.remove(iWXStatisticsCallBack);
        }
    }

    public boolean isUniServiceCreated(IApp iApp) {
        String obtainConfigProperty = iApp.obtainConfigProperty(AbsoluteConst.NVUE_LAUNCH_MODE);
        if (!TextUtils.isEmpty(obtainConfigProperty) && !obtainConfigProperty.equals("fast") && getControl().equals(AbsoluteConst.UNI_V3)) {
            return this.isUniServiceCreated;
        }
        if (!getControl().equals(Constants.CodeCache.SAVE_PATH)) {
            return true;
        }
        return this.isUniServiceCreated;
    }

    public String getPreInstanceId() {
        return this.mPreInstanceId;
    }

    public String getPreUniAppid() {
        return this.mPreUniAppid;
    }

    /* JADX WARNING: Code restructure failed: missing block: B:3:0x0010, code lost:
        if (android.text.TextUtils.isEmpty(r4) == false) goto L_0x0014;
     */
    public void setUniServiceCreated(boolean z, IApp iApp) {
        String str;
        this.isUniServiceCreated = z;
        if (iApp != null) {
            str = iApp.obtainConfigProperty(AbsoluteConst.NVUE_LAUNCH_MODE);
        }
        str = "fast";
        if ((getControl().equals(Constants.CodeCache.SAVE_PATH) || (!str.equals("fast") && getControl().equals(AbsoluteConst.UNI_V3))) && this.isUniServiceCreated) {
            for (String str2 : this.instanceHashMap.keySet()) {
                WXViewWrapper wXViewWrapper = this.instanceHashMap.get(str2);
                if (wXViewWrapper != null && !wXViewWrapper.isService) {
                    wXViewWrapper.runDelayedRenderCaches(wXViewWrapper.getWaitServiceRenderList());
                }
            }
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void preUniControlService(Application application, String str) {
        this.isUniServiceCreated = true;
        this.mPreUniAppid = str;
        UniSDKInstance uniSDKInstance = new UniSDKInstance(application);
        this.mPreInstanceId = uniSDKInstance.getInstanceId();
        String uniFileStr = getUniFileStr(application, str, "app-service.js");
        String uniFileStr2 = getUniFileStr(application, str, "app-config.js");
        HashMap hashMap = new HashMap();
        hashMap.put("plus_appid", str);
        hashMap.put("preload", true);
        hashMap.put("bundleUrl", "app-service.js");
        org.json.JSONObject jSONObject = new org.json.JSONObject();
        uniSDKInstance.render("__uniapp__service", (uniFileStr2 + uniFileStr + " plus.weexBridge.preloadReady('" + str + "');").replaceFirst(Pattern.quote("\"use weex:vue\""), Matcher.quoteReplacement("")), hashMap, jSONObject.toString(), WXRenderStrategy.APPEND_ASYNC);
        String str2 = this.TAG;
        StringBuilder sb2 = new StringBuilder();
        sb2.append("preUniControlService------");
        sb2.append(str);
        Logger.e(str2, sb2.toString());
    }

    private String getUniFileStr(Context context, String str, String str2) {
        try {
            return IOUtil.toString(getAppFileStream(context, str, str2));
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ICallBack getPreUniMPCallBack(String str) {
        if (this.mPreUniMPCallBackMap.containsKey(str)) {
            return this.mPreUniMPCallBackMap.remove(str);
        }
        return null;
    }

    public void preUniMP(final Application application, final String str, ICallBack iCallBack) {
        if (TextUtils.isEmpty(this.mPreUniAppid) || iCallBack == null) {
            if (iCallBack != null) {
                this.mPreUniMPCallBackMap.put(str, iCallBack);
            }
            if (isWeexInitEnd()) {
                restartWeex(application, new ICallBack() {
                    /* class io.dcloud.feature.weex.WeexInstanceMgr.AnonymousClass10 */

                    @Override // io.dcloud.common.DHInterface.ICallBack
                    public Object onCallBack(int i, Object obj) {
                        if (i != 1) {
                            return null;
                        }
                        WeexInstanceMgr.this.preUniControlService(application, str);
                        return null;
                    }
                }, str);
                return;
            }
            initWeexEnv(application);
            preUniControlService(application, str);
            return;
        }
        iCallBack.onCallBack(-101, "");
    }

    private Handler getHandler() {
        if (this.mHandler == null) {
            this.mHandler = new Handler(Looper.getMainLooper());
        }
        return this.mHandler;
    }

    private void clearHandler() {
        if (this.mHandler != null) {
            this.mHandler = null;
        }
    }

    @Override // io.dcloud.common.DHInterface.IUniInstanceMgr
    public void initUniappPlugin(Application application) {
        UniMoudlesLoader.getInstance().onCreate(application);
    }

    public boolean isJSFKFileNotFound() {
        return this.isJSFKFileNotFound;
    }

    public void setJSFKFileNotFound(boolean z) {
        this.isJSFKFileNotFound = z;
    }
}
