package io.dcloud.feature.weex;

import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.ViewGroup;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.taobao.weex.WXSDKInstance;
import com.taobao.weex.bridge.WXBridgeManager;
import com.taobao.weex.bridge.WXModuleManager;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IWaiter;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.DHInterface.ReceiveSystemEventVoucher;
import io.dcloud.common.DHInterface.StandardFeature;
import io.dcloud.common.adapter.ui.AdaUniWebView;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import java.util.HashMap;
import org.json.JSONException;

public class WeexFeature extends StandardFeature implements IWaiter, ReceiveSystemEventVoucher {
    boolean isRegisterAllEvent = false;
    IApp mApp;

    @Override // io.dcloud.common.DHInterface.IFeature, io.dcloud.common.DHInterface.BaseFeature, io.dcloud.common.DHInterface.StandardFeature
    public void init(AbsMgr absMgr, String str) {
        super.init(absMgr, str);
        WeexInstanceMgr.self().init(absMgr);
    }

    @Override // io.dcloud.common.DHInterface.BaseFeature, io.dcloud.common.DHInterface.IBoot
    public void onStart(Context context, Bundle bundle, String[] strArr) {
        super.onStart(context, bundle, strArr);
        if (context instanceof Application) {
            WeexInstanceMgr.self().initWeexEnv((Application) context);
        }
    }

    @Override // io.dcloud.common.DHInterface.BaseFeature, io.dcloud.common.DHInterface.IBoot
    public void onResume() {
        super.onResume();
        WeexInstanceMgr.self().onActivityResume();
    }

    @Override // io.dcloud.common.DHInterface.BaseFeature, io.dcloud.common.DHInterface.IBoot
    public void onPause() {
        super.onPause();
        WeexInstanceMgr.self().onActivityPause();
    }

    /* access modifiers changed from: protected */
    @Override // io.dcloud.common.DHInterface.BaseFeature
    public void onRequestPermissionsResult(int i, String[] strArr, int[] iArr) {
        super.onRequestPermissionsResult(i, strArr, iArr);
        WeexInstanceMgr.self().onRequestPermissionsResult(i, strArr, iArr);
    }

    public void onDestroy() {
        IApp iApp = this.mApp;
        if (iApp == null || iApp.getQuitModel() != 2) {
            WeexInstanceMgr.self().onActivityDestroy();
        } else {
            WeexInstanceMgr.self().onActivityDestroy(false);
        }
        WeexInstanceMgr.self().setUniServiceCreated(false, null);
    }

    /* access modifiers changed from: protected */
    @Override // io.dcloud.common.DHInterface.BaseFeature
    public void onActivityResult(int i, int i2, Intent intent) {
        super.onActivityResult(i, i2, intent);
        WeexInstanceMgr.self().onActivityResult(i, i2, intent);
    }

    public void registerAllEvent(IApp iApp) {
        this.mApp = iApp;
        if (!this.isRegisterAllEvent) {
            this.isRegisterAllEvent = true;
            unregisterSysEvent(iApp);
            registerSysEvent(this.mApp);
        }
    }

    @Override // io.dcloud.common.DHInterface.IFeature, io.dcloud.common.DHInterface.BaseFeature
    public void dispose(String str) {
        super.dispose(str);
        if (this.mApp != null) {
            onDestroy();
            if (this.isRegisterAllEvent) {
                unregisterSysEvent(this.mApp);
                this.isRegisterAllEvent = false;
                this.mApp = null;
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.IWaiter
    public Object doForFeature(String str, Object obj) {
        JSONObject registerJsModules;
        WXSDKInstance wXSDKInstance;
        WXBaseWrapper wXBaseWrapper;
        str.hashCode();
        char c = 65535;
        switch (str.hashCode()) {
            case -2004248131:
                if (str.equals("onKeyboardHeightChange")) {
                    c = 0;
                    break;
                }
                break;
            case -1209764397:
                if (str.equals("setUniNViewModuleReladyCallBack")) {
                    c = 1;
                    break;
                }
                break;
            case -982897726:
                if (str.equals("updateReload")) {
                    c = 2;
                    break;
                }
                break;
            case -852986777:
                if (str.equals("findWebviewByInstanceId")) {
                    c = 3;
                    break;
                }
                break;
            case -623580498:
                if (str.equals("getUniNViewModules")) {
                    c = 4;
                    break;
                }
                break;
            case -163799780:
                if (str.equals("callNativeModuleSync")) {
                    c = 5;
                    break;
                }
                break;
            case -149733713:
                if (str.equals("weexViewUpdate")) {
                    c = 6;
                    break;
                }
                break;
            case 369306469:
                if (str.equals("postMessageToUniNView")) {
                    c = 7;
                    break;
                }
                break;
            case 594866751:
                if (str.equals("createUniNView")) {
                    c = '\b';
                    break;
                }
                break;
            case 715247196:
                if (str.equals("createServiceUniNView")) {
                    c = '\t';
                    break;
                }
                break;
            case 2133581413:
                if (str.equals("updateServiceReload")) {
                    c = '\n';
                    break;
                }
                break;
        }
        switch (c) {
            case 0:
                Object[] objArr = (Object[]) obj;
                int intValue = ((Integer) objArr[1]).intValue();
                WXBaseWrapper findWXBaseWrapper = WeexInstanceMgr.self().findWXBaseWrapper((String) objArr[0]);
                if (findWXBaseWrapper != null) {
                    HashMap hashMap = new HashMap();
                    hashMap.put("height", Integer.valueOf((int) (((float) intValue) / findWXBaseWrapper.mWebview.getScale())));
                    findWXBaseWrapper.fireGlobalEvent("KeyboardHeightChange", hashMap);
                }
                return WeexInstanceMgr.self().findWebviewByInstanceId((String) ((Object[]) obj)[0]);
            case 1:
                WeexInstanceMgr.self().setUniNViewModuleReladyCallBack((ICallBack) ((Object[]) obj)[0]);
                return null;
            case 2:
                WXViewWrapper findPathByWrapper = WeexInstanceMgr.self().findPathByWrapper((String) ((Object[]) obj)[0]);
                if (findPathByWrapper != null) {
                    findPathByWrapper.reload();
                }
                return null;
            case 3:
                return WeexInstanceMgr.self().findWebviewByInstanceId((String) ((Object[]) obj)[0]);
            case 4:
                String uniNViewModules = WeexInstanceMgr.self().getUniNViewModules();
                if (uniNViewModules != null || (registerJsModules = WXModuleManager.getRegisterJsModules()) == null) {
                    return uniNViewModules;
                }
                return registerJsModules.toJSONString();
            case 5:
                Object[] objArr2 = (Object[]) obj;
                IWebview iWebview = (IWebview) objArr2[0];
                String str2 = (String) objArr2[1];
                String str3 = (String) objArr2[2];
                String str4 = (String) objArr2[3];
                JSONObject parseObject = JSON.parseObject((String) objArr2[4]);
                if (PdrUtil.isEmpty(str2)) {
                    str2 = str3;
                }
                if (str4.equalsIgnoreCase(str2)) {
                    wXSDKInstance = WeexInstanceMgr.self().findWXSDKInstance(str4);
                } else {
                    wXSDKInstance = WeexInstanceMgr.self().findWXSDKInstance(str2);
                }
                if (wXSDKInstance != null) {
                    return callNativeModule(wXSDKInstance.getInstanceId(), parseObject);
                }
                return null;
            case 6:
                Object[] objArr3 = (Object[]) obj;
                IWebview iWebview2 = (IWebview) objArr3[0];
                ViewGroup viewGroup = (ViewGroup) objArr3[1];
                org.json.JSONObject jSONObject = (org.json.JSONObject) objArr3[2];
                String str5 = (String) objArr3[3];
                if (PdrUtil.isEmpty(str5)) {
                    str5 = iWebview2.obtainApp().obtainAppId();
                }
                if (jSONObject.has(AbsoluteConst.XML_PATH) && !PdrUtil.isEmpty(jSONObject.optString(AbsoluteConst.XML_PATH))) {
                    WXBaseWrapper findWXBaseWrapper2 = WeexInstanceMgr.self().findWXBaseWrapper(str5);
                    org.json.JSONObject jSONObject2 = new org.json.JSONObject();
                    String optString = jSONObject.optString(AbsoluteConst.XML_PATH);
                    if (iWebview2.isUniWebView()) {
                        ((AdaUniWebView) iWebview2).setNVuePath(optString);
                    }
                    try {
                        jSONObject2.put("js", optString);
                        jSONObject2.put("data", jSONObject);
                    } catch (JSONException e) {
                        e.printStackTrace();
                    }
                    if (findWXBaseWrapper2 != null) {
                        findWXBaseWrapper2.loadTemplate(jSONObject2);
                    } else {
                        createUniNView(iWebview2, viewGroup, str5, jSONObject2);
                    }
                }
                return null;
            case 7:
                Object[] objArr4 = (Object[]) obj;
                String str6 = (String) objArr4[1];
                String str7 = (String) objArr4[2];
                String str8 = (String) objArr4[3];
                JSONObject parseObject2 = JSON.parseObject((String) objArr4[4]);
                HashMap hashMap2 = new HashMap();
                hashMap2.put("targetId", str7);
                hashMap2.put("originId", ((IWebview) objArr4[0]).getWebviewUUID());
                hashMap2.put("data", parseObject2);
                if (PdrUtil.isEmpty(str6)) {
                    str6 = str7;
                }
                if (str8.equalsIgnoreCase(str6)) {
                    wXBaseWrapper = WeexInstanceMgr.self().findWXBaseWrapper(str8);
                } else {
                    wXBaseWrapper = WeexInstanceMgr.self().findWXBaseWrapper(str6);
                }
                if (wXBaseWrapper != null) {
                    wXBaseWrapper.fireGlobalEvent("plusMessage", hashMap2);
                }
                return null;
            case '\b':
                return createWeexWindow((Object[]) obj);
            case '\t':
                return createWeexService((Object[]) obj);
            case '\n':
                WeexInstanceMgr.self().reloadWXServiceWrapper();
                return null;
            default:
                return null;
        }
    }

    private void createUniNView(IWebview iWebview, ViewGroup viewGroup, String str, org.json.JSONObject jSONObject) {
        createUniNView(iWebview, viewGroup, str, jSONObject, WXBaseWrapper.DE_INDEX);
    }

    private void createUniNView(IWebview iWebview, ViewGroup viewGroup, String str, org.json.JSONObject jSONObject, int i) {
        WeexInstanceMgr.self().createWeexView(iWebview, viewGroup, jSONObject, str, i);
    }

    private Object createWeexWindow(Object[] objArr) {
        IWebview iWebview = (IWebview) objArr[0];
        registerAllEvent(iWebview.obtainApp());
        return WeexInstanceMgr.self().createWeexView(iWebview, (ViewGroup) objArr[1], (org.json.JSONObject) objArr[2], (String) objArr[3], WXViewWrapper.DE_INDEX);
    }

    private Object createWeexService(Object[] objArr) {
        IApp iApp = (IApp) objArr[0];
        registerAllEvent(iApp);
        ViewGroup viewGroup = (ViewGroup) objArr[2];
        String str = (String) objArr[3];
        return WeexInstanceMgr.self().createWeexService(iApp, viewGroup, str, (org.json.JSONObject) objArr[1]);
    }

    public String callNativeModule(String str, JSONObject jSONObject) {
        Object callNativeModule = WXBridgeManager.getInstance().callNativeModule(str, jSONObject.getString("plugin"), jSONObject.getString("method"), JSON.parseArray(jSONObject.getString("args")), (JSONObject) null);
        if (callNativeModule != null) {
            if (callNativeModule instanceof JSONObject) {
                return JSUtil.wrapJsVar(JSONUtil.createJSONObject(((JSONObject) callNativeModule).toJSONString()));
            }
            if (callNativeModule instanceof HashMap) {
                return JSUtil.wrapJsVar(JSONUtil.createJSONObject(new JSONObject((HashMap) callNativeModule).toJSONString()));
            }
            if (callNativeModule instanceof JSONArray) {
                return JSUtil.wrapJsVar(JSONUtil.createJSONArray(((JSONArray) callNativeModule).toJSONString()));
            }
            if (callNativeModule instanceof String) {
                return JSUtil.wrapJsVar(String.valueOf(callNativeModule));
            }
            if (callNativeModule instanceof org.json.JSONObject) {
                return JSUtil.wrapJsVar((org.json.JSONObject) callNativeModule);
            }
            if (callNativeModule instanceof org.json.JSONArray) {
                return JSUtil.wrapJsVar((org.json.JSONArray) callNativeModule);
            }
        }
        return JSUtil.wrapJsVar("");
    }
}
