package io.dcloud.feature.ui.navigator;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Color;
import android.os.Build;
import android.text.TextUtils;
import android.view.Window;
import com.alibaba.fastjson.parser.JSONLexer;
import com.dcloud.android.widget.toast.ToastCompat;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.PdrR;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IFeature;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.io.DHFile;
import io.dcloud.common.adapter.ui.webview.DCWebView;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.MessageHandler;
import io.dcloud.common.adapter.util.PermissionUtil;
import io.dcloud.common.adapter.util.SP;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.constant.DOMException;
import io.dcloud.common.constant.IntentConst;
import io.dcloud.common.constant.StringConst;
import io.dcloud.common.ui.blur.DCBlurDraweeView;
import io.dcloud.common.util.AppRuntime;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.Deprecated_JSUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.LoadAppUtils;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.ShortCutUtil;
import io.dcloud.common.util.ShortcutCreateUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.common.util.TestUtil;
import io.dcloud.common.util.emulator.EmulatorCheckUtil;
import org.json.JSONException;
import org.json.JSONObject;

public class NavigatorUIFeatureImpl implements IFeature {
    AbsMgr a;

    class a extends PermissionUtil.StreamPermissionRequest {
        final /* synthetic */ IWebview a;
        final /* synthetic */ String[] b;
        final /* synthetic */ IApp c;
        final /* synthetic */ String d;

        /* JADX INFO: super call moved to the top of the method (can break code semantics) */
        a(IApp iApp, IWebview iWebview, String[] strArr, IApp iApp2, String str) {
            super(iApp);
            this.a = iWebview;
            this.b = strArr;
            this.c = iApp2;
            this.d = str;
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onDenied(String str) {
        }

        @Override // io.dcloud.common.adapter.util.PermissionUtil.Request
        public void onGranted(String str) {
            NavigatorUIFeatureImpl.this.a((NavigatorUIFeatureImpl) this.a, (IWebview) this.b, (String[]) this.c, (IApp) this.d);
        }
    }

    class b implements ISysEventListener {
        final /* synthetic */ int a;
        final /* synthetic */ IApp b;
        final /* synthetic */ IWebview c;
        final /* synthetic */ String d;
        final /* synthetic */ String e;

        b(int i, IApp iApp, IWebview iWebview, String str, String str2) {
            this.a = i;
            this.b = iApp;
            this.c = iWebview;
            this.d = str;
            this.e = str2;
        }

        @Override // io.dcloud.common.DHInterface.ISysEventListener
        public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
            int i;
            Object[] objArr = (Object[]) obj;
            int intValue = ((Integer) objArr[0]).intValue();
            String[] strArr = (String[]) objArr[1];
            int[] iArr = (int[]) objArr[2];
            ISysEventListener.SysEventType sysEventType2 = ISysEventListener.SysEventType.onRequestPermissionsResult;
            if (sysEventType2 == sysEventType && intValue == this.a) {
                this.b.unregisterSysEventListener(this, sysEventType2);
                if (iArr.length > 0) {
                    i = iArr[0];
                } else {
                    i = this.c.obtainApp().checkSelfPermission(this.d, this.c.obtainApp().obtainAppName());
                }
                String convert5PlusValue = PermissionUtil.convert5PlusValue(i);
                Deprecated_JSUtil.execCallback(this.c, this.e, StringUtil.format("{result:'%s'}", convert5PlusValue), JSUtil.OK, true, false);
            }
            return true;
        }
    }

    /* access modifiers changed from: package-private */
    public class c implements Runnable {
        final /* synthetic */ Context a;
        final /* synthetic */ String b;
        final /* synthetic */ IWebview c;
        final /* synthetic */ String d;

        c(Context context, String str, IWebview iWebview, String str2) {
            this.a = context;
            this.b = str;
            this.c = iWebview;
            this.d = str2;
        }

        public void run() {
            try {
                JSUtil.execCallback(this.c, this.d, new JSONObject(StringUtil.format(DOMException.JSON_SHORTCUT_SUCCESS_INFO, ShortCutUtil.SHORT_CUT_EXISTING.equals(ShortCutUtil.requestShortCutForCommit(this.a, this.b)) ? AbsoluteConst.TRUE : AbsoluteConst.FALSE)), JSUtil.OK, false);
            } catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
    }

    private void b(Context context, IWebview iWebview, String str, String str2) {
        String str3;
        String requestShortCut = ShortCutUtil.requestShortCut(context, str2);
        if (ShortCutUtil.SHORT_CUT_EXISTING.equals(requestShortCut)) {
            str3 = StringUtil.format(DOMException.JSON_SHORTCUT_RESULT_INFO, "existing");
        } else if (ShortCutUtil.SHORT_CUT_NONE.equals(requestShortCut)) {
            str3 = StringUtil.format(DOMException.JSON_SHORTCUT_RESULT_INFO, "none");
        } else if (ShortCutUtil.NOPERMISSIONS.equals(requestShortCut)) {
            str3 = StringUtil.format(DOMException.JSON_SHORTCUT_RESULT_INFO, ShortCutUtil.NOPERMISSIONS);
        } else {
            str3 = StringUtil.format(DOMException.JSON_SHORTCUT_RESULT_INFO, "unknown");
        }
        try {
            JSUtil.execCallback(iWebview, str, new JSONObject(str3), JSUtil.OK, false);
        } catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public void dispose(String str) {
    }

    /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
    @Override // io.dcloud.common.DHInterface.IFeature
    public String execute(IWebview iWebview, String str, String[] strArr) {
        char c2;
        String str2;
        String str3;
        JSONException e;
        int i;
        IApp obtainApp = iWebview.obtainApp();
        String obtainAppId = obtainApp.obtainAppId();
        str.hashCode();
        switch (str.hashCode()) {
            case -2079769446:
                if (str.equals("getOrientation")) {
                    c2 = 0;
                    break;
                }
                c2 = 65535;
                break;
            case -1980692731:
                if (str.equals("hideSystemNavigation")) {
                    c2 = 1;
                    break;
                }
                c2 = 65535;
                break;
            case -1921914628:
                if (str.equals("updateSplashscreen")) {
                    c2 = 2;
                    break;
                }
                c2 = 65535;
                break;
            case -1763010304:
                if (str.equals("hasShortcut")) {
                    c2 = 3;
                    break;
                }
                c2 = 65535;
                break;
            case -1294581845:
                if (str.equals("closeSplashscreen")) {
                    c2 = 4;
                    break;
                }
                c2 = 65535;
                break;
            case -1250806682:
                if (str.equals("getStatusBarStyle")) {
                    c2 = 5;
                    break;
                }
                c2 = 65535;
                break;
            case -1180327431:
                if (str.equals("isLogs")) {
                    c2 = 6;
                    break;
                }
                c2 = 65535;
                break;
            case -831443264:
                if (str.equals("showSystemNavigation")) {
                    c2 = 7;
                    break;
                }
                c2 = 65535;
                break;
            case -802912774:
                if (str.equals("isSimulator")) {
                    c2 = '\b';
                    break;
                }
                c2 = 65535;
                break;
            case -583672202:
                if (str.equals("removeSessionCookie")) {
                    c2 = '\t';
                    break;
                }
                c2 = 65535;
                break;
            case -452882469:
                if (str.equals("isImmersedStatusbar")) {
                    c2 = '\n';
                    break;
                }
                c2 = 65535;
                break;
            case -108255335:
                if (str.equals("getStatusBarBackground")) {
                    c2 = 11;
                    break;
                }
                c2 = 65535;
                break;
            case 126640486:
                if (str.equals("setCookie")) {
                    c2 = '\f';
                    break;
                }
                c2 = 65535;
                break;
            case 204345677:
                if (str.equals("hasSplashscreen")) {
                    c2 = '\r';
                    break;
                }
                c2 = 65535;
                break;
            case 301825860:
                if (str.equals("getUserAgent")) {
                    c2 = 14;
                    break;
                }
                c2 = 65535;
                break;
            case 341257562:
                if (str.equals("getCookie")) {
                    c2 = 15;
                    break;
                }
                c2 = 65535;
                break;
            case 580068706:
                if (str.equals("createShortcut")) {
                    c2 = 16;
                    break;
                }
                c2 = 65535;
                break;
            case 586449341:
                if (str.equals("setFullscreen")) {
                    c2 = 17;
                    break;
                }
                c2 = 65535;
                break;
            case 586897223:
                if (str.equals("getUiStyle")) {
                    c2 = 18;
                    break;
                }
                c2 = 65535;
                break;
            case 686218487:
                if (str.equals("checkPermission")) {
                    c2 = 19;
                    break;
                }
                c2 = 65535;
                break;
            case 746581438:
                if (str.equals("requestPermission")) {
                    c2 = 20;
                    break;
                }
                c2 = 65535;
                break;
            case 839078392:
                if (str.equals("isBackground")) {
                    c2 = 21;
                    break;
                }
                c2 = 65535;
                break;
            case 1063979522:
                if (str.equals("getSignature")) {
                    c2 = 22;
                    break;
                }
                c2 = 65535;
                break;
            case 1094478863:
                if (str.equals("hasNotchInScreen")) {
                    c2 = 23;
                    break;
                }
                c2 = 65535;
                break;
            case 1204872973:
                if (str.equals("setStatusBarBackground")) {
                    c2 = 24;
                    break;
                }
                c2 = 65535;
                break;
            case 1217359681:
                if (str.equals("removeAllCookie")) {
                    c2 = 25;
                    break;
                }
                c2 = 65535;
                break;
            case 1365206181:
                if (str.equals("isFullScreen")) {
                    c2 = JSONLexer.EOI;
                    break;
                }
                c2 = 65535;
                break;
            case 1841443122:
                if (str.equals("getStatusbarHeight")) {
                    c2 = 27;
                    break;
                }
                c2 = 65535;
                break;
            case 1850818488:
                if (str.equals("setUserAgent")) {
                    c2 = 28;
                    break;
                }
                c2 = 65535;
                break;
            case 1984754993:
                if (str.equals("setLogs")) {
                    c2 = 29;
                    break;
                }
                c2 = 65535;
                break;
            case 2104007794:
                if (str.equals("setStatusBarStyle")) {
                    c2 = 30;
                    break;
                }
                c2 = 65535;
                break;
            default:
                c2 = 65535;
                break;
        }
        switch (c2) {
            case 0:
                int i2 = 0;
                try {
                    int rotation = iWebview.getActivity().getWindowManager().getDefaultDisplay().getRotation();
                    if (rotation == 1) {
                        i2 = 90;
                    } else if (rotation == 2) {
                        i2 = 180;
                    } else if (rotation == 3) {
                        i2 = -90;
                    }
                    str2 = JSUtil.wrapJsVar((float) i2);
                    break;
                } catch (Exception unused) {
                    str2 = JSUtil.wrapJsVar(0.0f);
                    break;
                }
            case 1:
                str3 = null;
                Window window = obtainApp.getActivity().getWindow();
                window.getDecorView().setSystemUiVisibility(window.getDecorView().getSystemUiVisibility() | 256 | 512 | 2 | 4096);
                iWebview.obtainApp().setHideNavBarState(true);
                str2 = str3;
                break;
            case 2:
                try {
                    JSONObject jSONObject = new JSONObject(strArr[0]);
                    SharedPreferences.Editor edit = SP.getOrCreateBundle(iWebview.getContext(), "pdr").edit();
                    String obtainAppId2 = obtainApp.obtainAppId();
                    str3 = null;
                    try {
                        String optString = jSONObject.optString("image", null);
                        if (!TextUtils.isEmpty(optString)) {
                            String convert2AbsFullPath = obtainApp.convert2AbsFullPath(iWebview.obtainFullUrl(), optString);
                            if (PdrUtil.isDeviceRootDir(convert2AbsFullPath)) {
                                DHFile.copyFile(convert2AbsFullPath, StringConst.STREAMAPP_KEY_ROOTPATH + "splash/" + obtainApp.obtainAppId() + ".png", true, false);
                            }
                            edit.putString(SP.UPDATE_SPLASH_IMG_PATH, convert2AbsFullPath);
                        }
                        if (!jSONObject.isNull(IApp.ConfigProperty.CONFIG_AUTOCLOSE)) {
                            edit.putBoolean(obtainAppId2 + SP.UPDATE_SPLASH_AUTOCLOSE, jSONObject.optBoolean(IApp.ConfigProperty.CONFIG_AUTOCLOSE));
                        }
                        if (!jSONObject.isNull(IApp.ConfigProperty.CONFIG_DELAY)) {
                            edit.putInt(obtainAppId2 + SP.UPDATE_SPLASH_DELAY, jSONObject.optInt(IApp.ConfigProperty.CONFIG_DELAY));
                        }
                        if (BaseInfo.isWap2AppAppid(obtainAppId2)) {
                            if (!jSONObject.isNull(IApp.ConfigProperty.CONFIG_AUTOCLOSE_W2A)) {
                                edit.putBoolean(obtainAppId2 + SP.UPDATE_SPLASH_AUTOCLOSE_W2A, jSONObject.optBoolean(IApp.ConfigProperty.CONFIG_AUTOCLOSE_W2A));
                            }
                            if (!jSONObject.isNull(IApp.ConfigProperty.CONFIG_DELAY_W2A)) {
                                edit.putInt(obtainAppId2 + SP.UPDATE_SPLASH_DELAY_W2A, jSONObject.optInt(IApp.ConfigProperty.CONFIG_DELAY_W2A));
                            }
                        }
                        edit.commit();
                    } catch (JSONException e2) {
                        e = e2;
                        e.printStackTrace();
                        str2 = str3;
                        return str2;
                    }
                } catch (JSONException e3) {
                    e = e3;
                    str3 = null;
                    e.printStackTrace();
                    str2 = str3;
                    return str2;
                }
                str2 = str3;
            case 3:
                AppRuntime.checkPrivacyComplianceAndPrompt(iWebview.getContext(), "Navigator-" + str);
                String str4 = strArr[0];
                String str5 = strArr[1];
                String obtainAppName = iWebview.obtainApp().obtainAppName();
                try {
                    obtainAppName = new JSONObject(str4).optString("name", obtainAppName);
                } catch (JSONException e4) {
                    e4.printStackTrace();
                }
                b(iWebview.getContext(), iWebview, str5, obtainAppName);
                str3 = null;
                str2 = str3;
                break;
            case 4:
                Logger.d(Logger.MAIN_TAG, "appid=" + obtainAppId + " closeSplashscreen");
                TestUtil.print(TestUtil.START_STREAM_APP, "closeSplashscreen appid=" + obtainAppId);
                Logger.i("download_manager", "javascript webapp task begin success appid=" + obtainAppId + " closeSplashscreen");
                this.a.processEvent(IMgr.MgrType.WindowMgr, 11, iWebview.obtainFrameView());
                str3 = null;
                str2 = str3;
                break;
            case 5:
                str2 = JSUtil.wrapJsVar(obtainApp.obtainConfigProperty(AbsoluteConst.JSONKEY_STATUSBAR_MODE));
                break;
            case 6:
                str2 = JSUtil.wrapJsVar(Logger.isOpen());
                break;
            case 7:
                Window window2 = obtainApp.getActivity().getWindow();
                window2.getDecorView().setSystemUiVisibility(window2.getDecorView().getSystemUiVisibility() & -515);
                iWebview.obtainApp().setHideNavBarState(false);
                str3 = null;
                str2 = str3;
                break;
            case '\b':
                AppRuntime.checkPrivacyComplianceAndPrompt(iWebview.getContext(), "Navigator-" + str);
                str2 = JSUtil.wrapJsVar(EmulatorCheckUtil.getSingleInstance().emulatorCheck(iWebview.getContext()));
                break;
            case '\t':
                try {
                    iWebview.removeSessionCookie();
                } catch (Exception e5) {
                    e5.printStackTrace();
                }
                str3 = null;
                str2 = str3;
                break;
            case '\n':
                str2 = JSUtil.wrapJsVar(obtainApp.obtainStatusBarMgr().checkImmersedStatusBar(iWebview.getActivity(), Boolean.valueOf(obtainApp.obtainConfigProperty(AbsoluteConst.JSONKEY_STATUSBAR_IMMERSED)).booleanValue()));
                break;
            case 11:
                if (Build.VERSION.SDK_INT >= 21) {
                    str2 = JSUtil.wrapJsVar(PdrUtil.toHexFromColor(obtainApp.getActivity().getWindow().getStatusBarColor()));
                    break;
                }
                str3 = null;
                str2 = str3;
                break;
            case '\f':
                iWebview.setCookie(strArr[0], strArr[1]);
                str3 = null;
                str2 = str3;
                break;
            case '\r':
                str2 = JSUtil.wrapJsVar(!obtainApp.obtainWebAppRootView().didCloseSplash());
                break;
            case 14:
                boolean parseBoolean = Boolean.parseBoolean(obtainApp.obtainConfigProperty(IApp.ConfigProperty.CONFIG_funSetUA));
                String obtainConfigProperty = iWebview.obtainApp().obtainConfigProperty(IApp.ConfigProperty.CONFIG_USER_AGENT);
                if (TextUtils.isEmpty(obtainConfigProperty)) {
                    obtainConfigProperty = "";
                }
                if (parseBoolean) {
                    return obtainConfigProperty;
                }
                boolean parseBoolean2 = Boolean.parseBoolean(obtainApp.obtainConfigProperty(IApp.ConfigProperty.CONFIG_CONCATENATE));
                boolean parseBoolean3 = Boolean.parseBoolean(obtainApp.obtainConfigProperty(IApp.ConfigProperty.CONFIG_H5PLUS));
                if (parseBoolean2) {
                    obtainConfigProperty = BaseInfo.sDefWebViewUserAgent + Operators.SPACE_STR + obtainConfigProperty;
                }
                if (PdrUtil.isEmpty(obtainConfigProperty)) {
                    obtainConfigProperty = obtainConfigProperty + BaseInfo.sDefWebViewUserAgent;
                }
                if (parseBoolean3) {
                    str2 = obtainConfigProperty + DCWebView.UserAgentExtInfo;
                    break;
                } else {
                    return obtainConfigProperty;
                }
            case 15:
                str2 = iWebview.getCookie(strArr[0]);
                break;
            case 16:
                AppRuntime.checkPrivacyComplianceAndPrompt(iWebview.getContext(), "Navigator-" + str);
                PermissionUtil.usePermission(iWebview.getActivity(), IFeature.F_NAVIGATOR, "SHORTCUT", 2, new a(obtainApp, iWebview, strArr, obtainApp, obtainAppId));
                str3 = null;
                str2 = str3;
                break;
            case 17:
                obtainApp.setFullScreen(PdrUtil.parseBoolean(String.valueOf(strArr[0]), false, false));
                str3 = null;
                str2 = str3;
                break;
            case 18:
                str2 = JSUtil.wrapJsVar(AppRuntime.getAppDarkMode(iWebview.getContext()) ? DCBlurDraweeView.DARK : DCBlurDraweeView.LIGHT);
                break;
            case 19:
                str2 = JSUtil.wrapJsVar(PermissionUtil.checkPermission(iWebview, strArr));
                break;
            case 20:
                String str6 = strArr[0];
                String str7 = strArr[1];
                int requestCode = PermissionUtil.getRequestCode();
                String convertNativePermission = PermissionUtil.convertNativePermission(str6);
                obtainApp.registerSysEventListener(new b(requestCode, obtainApp, iWebview, convertNativePermission, str7), ISysEventListener.SysEventType.onRequestPermissionsResult);
                obtainApp.requestPermissions(new String[]{convertNativePermission}, requestCode);
                str3 = null;
                str2 = str3;
                break;
            case 21:
                str2 = JSUtil.wrapJsVar(obtainApp.obtainAppStatus() == 2);
                break;
            case 22:
                str2 = JSUtil.wrapJsVar(LoadAppUtils.getAppSignatureSHA1(iWebview.getContext()));
                break;
            case 23:
                str2 = JSUtil.wrapJsVar(QueryNotchTool.hasNotchInScreen(iWebview.getActivity()));
                break;
            case 24:
                String str8 = strArr[0];
                if (!TextUtils.isEmpty(str8)) {
                    try {
                        i = Color.parseColor(str8);
                    } catch (Exception unused2) {
                        i = PdrUtil.stringToColor(str8);
                    }
                    if (Build.VERSION.SDK_INT >= 21) {
                        obtainApp.setConfigProperty(AbsoluteConst.JSONKEY_STATUSBAR_BC, strArr[0]);
                        obtainApp.obtainStatusBarMgr().setStatusBarColor(obtainApp.getActivity(), i);
                    }
                }
                str3 = null;
                str2 = str3;
                break;
            case 25:
                try {
                    iWebview.removeAllCookie();
                } catch (Exception e6) {
                    e6.printStackTrace();
                }
                str3 = null;
                str2 = str3;
                break;
            case 26:
                str2 = JSUtil.wrapJsVar(obtainApp.isFullScreen());
                break;
            case 27:
                DeviceInfo.updateStatusBarHeight(iWebview.getActivity());
                str2 = JSUtil.wrapJsVar(((float) DeviceInfo.sStatusBarHeight) / iWebview.getScale());
                break;
            case 28:
                String str9 = strArr[0];
                String str10 = strArr[1];
                obtainApp.setConfigProperty(IApp.ConfigProperty.CONFIG_USER_AGENT, str9);
                obtainApp.setConfigProperty(IApp.ConfigProperty.CONFIG_funSetUA, AbsoluteConst.TRUE);
                obtainApp.setConfigProperty(IApp.ConfigProperty.CONFIG_H5PLUS, str10);
                iWebview.setWebviewProperty(IWebview.USER_AGENT, str9);
                str3 = null;
                str2 = str3;
                break;
            case 29:
                Logger.setOpen(PdrUtil.parseBoolean(String.valueOf(strArr[0]), false, false));
                str3 = null;
                str2 = str3;
                break;
            case 30:
                String str11 = strArr[0];
                obtainApp.setConfigProperty(AbsoluteConst.JSONKEY_STATUSBAR_MODE, str11);
                obtainApp.obtainStatusBarMgr().setStatusBarMode(obtainApp.getActivity(), str11);
                str3 = null;
                str2 = str3;
                break;
            default:
                str3 = null;
                str2 = str3;
                break;
        }
        return str2;
    }

    @Override // io.dcloud.common.DHInterface.IFeature
    public void init(AbsMgr absMgr, String str) {
        this.a = absMgr;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    /* JADX WARNING: Removed duplicated region for block: B:37:0x00a1 A[Catch:{ Exception -> 0x00d5 }] */
    /* JADX WARNING: Removed duplicated region for block: B:39:0x00af  */
    /* JADX WARNING: Removed duplicated region for block: B:47:0x00bd A[Catch:{ Exception -> 0x00d3 }] */
    private boolean a(IWebview iWebview, String[] strArr, IApp iApp, String str) {
        boolean z;
        boolean z2;
        JSONObject jSONObject;
        String str2;
        String str3;
        String str4;
        Bitmap bitmap;
        Exception e;
        JSONObject jSONObject2;
        JSONException jSONException;
        boolean z3;
        String str5;
        String str6 = "";
        String str7 = strArr[0];
        String str8 = strArr[1];
        String format = StringUtil.format(iWebview.getContext().getString(R.string.dcloud_short_cut_created), iApp.obtainAppName());
        Bitmap bitmap2 = null;
        try {
            JSONObject jSONObject3 = new JSONObject(str7);
            z3 = jSONObject3.optBoolean(AbsoluteConst.INSTALL_OPTIONS_FORCE, true);
            if (z3) {
                try {
                    format = format + iWebview.getActivity().getString(R.string.dcloud_short_cut_created_removed_manually);
                } catch (JSONException e2) {
                    jSONException = e2;
                    str5 = str6;
                    str2 = str5;
                    jSONObject2 = null;
                    jSONException.printStackTrace();
                    str3 = str6;
                    z2 = z3;
                    jSONObject = jSONObject2;
                    z = true;
                    str4 = str5;
                    if (!TextUtils.isEmpty(str2)) {
                    }
                    if (bitmap2 != null) {
                    }
                    bitmap = BitmapFactory.decodeResource(iWebview.getContext().getResources(), PdrR.DRAWABLE_ICON);
                    a(iWebview, str3, bitmap, str4, format, jSONObject, z2, z, str8);
                    return false;
                }
            }
            String optString = jSONObject3.optString("name");
            try {
                str2 = jSONObject3.optString(AbsoluteConst.JSON_KEY_ICON);
                try {
                    str4 = jSONObject3.optString("classname");
                    if (jSONObject3.has("toast")) {
                        format = jSONObject3.optString("toast");
                    }
                    jSONObject2 = jSONObject3.optJSONObject("extra");
                    try {
                        z2 = z3;
                        z = jSONObject3.optBoolean("check", true);
                        str3 = optString;
                        jSONObject = jSONObject2;
                    } catch (JSONException e3) {
                        jSONException = e3;
                        str5 = str4;
                        str6 = optString;
                        jSONException.printStackTrace();
                        str3 = str6;
                        z2 = z3;
                        jSONObject = jSONObject2;
                        z = true;
                        str4 = str5;
                        if (!TextUtils.isEmpty(str2)) {
                        }
                        if (bitmap2 != null) {
                        }
                        bitmap = BitmapFactory.decodeResource(iWebview.getContext().getResources(), PdrR.DRAWABLE_ICON);
                        a(iWebview, str3, bitmap, str4, format, jSONObject, z2, z, str8);
                        return false;
                    }
                } catch (JSONException e4) {
                    jSONException = e4;
                    str5 = str6;
                    jSONObject2 = null;
                    str6 = optString;
                    jSONException.printStackTrace();
                    str3 = str6;
                    z2 = z3;
                    jSONObject = jSONObject2;
                    z = true;
                    str4 = str5;
                    if (!TextUtils.isEmpty(str2)) {
                    }
                    if (bitmap2 != null) {
                    }
                    bitmap = BitmapFactory.decodeResource(iWebview.getContext().getResources(), PdrR.DRAWABLE_ICON);
                    a(iWebview, str3, bitmap, str4, format, jSONObject, z2, z, str8);
                    return false;
                }
            } catch (JSONException e5) {
                jSONException = e5;
                str5 = str6;
                str2 = str5;
                jSONObject2 = null;
                str6 = optString;
                jSONException.printStackTrace();
                str3 = str6;
                z2 = z3;
                jSONObject = jSONObject2;
                z = true;
                str4 = str5;
                if (!TextUtils.isEmpty(str2)) {
                }
                if (bitmap2 != null) {
                }
                bitmap = BitmapFactory.decodeResource(iWebview.getContext().getResources(), PdrR.DRAWABLE_ICON);
                a(iWebview, str3, bitmap, str4, format, jSONObject, z2, z, str8);
                return false;
            }
        } catch (JSONException e6) {
            jSONException = e6;
            str5 = str6;
            str2 = str5;
            jSONObject2 = null;
            z3 = true;
            jSONException.printStackTrace();
            str3 = str6;
            z2 = z3;
            jSONObject = jSONObject2;
            z = true;
            str4 = str5;
            if (!TextUtils.isEmpty(str2)) {
            }
            if (bitmap2 != null) {
            }
            bitmap = BitmapFactory.decodeResource(iWebview.getContext().getResources(), PdrR.DRAWABLE_ICON);
            a(iWebview, str3, bitmap, str4, format, jSONObject, z2, z, str8);
            return false;
        }
        try {
            if (!TextUtils.isEmpty(str2)) {
                bitmap2 = BitmapFactory.decodeFile(iApp.convert2AbsFullPath(iWebview.obtainFullUrl(), str2));
            }
            if (bitmap2 != null) {
                try {
                    bitmap2 = a(iApp);
                } catch (Exception e7) {
                    try {
                        e7.printStackTrace();
                    } catch (Exception e8) {
                        e = e8;
                        e.printStackTrace();
                        bitmap = bitmap2;
                        a(iWebview, str3, bitmap, str4, format, jSONObject, z2, z, str8);
                        return false;
                    }
                }
            }
            if (bitmap2 == null && bitmap2 == null) {
                bitmap = BitmapFactory.decodeResource(iWebview.getContext().getResources(), PdrR.DRAWABLE_ICON);
                a(iWebview, str3, bitmap, str4, format, jSONObject, z2, z, str8);
                return false;
            }
        } catch (Exception e9) {
            e = e9;
            e.printStackTrace();
            bitmap = bitmap2;
            a(iWebview, str3, bitmap, str4, format, jSONObject, z2, z, str8);
            return false;
        }
        bitmap = bitmap2;
        a(iWebview, str3, bitmap, str4, format, jSONObject, z2, z, str8);
        return false;
    }

    private String b(IApp iApp) {
        Intent obtainWebAppIntent = iApp.obtainWebAppIntent();
        return obtainWebAppIntent != null ? obtainWebAppIntent.getStringExtra(IntentConst.WEBAPP_ACTIVITY_APPICON) : "";
    }

    private void a(Context context, IWebview iWebview, String str, String str2) {
        MessageHandler.postDelayed(new c(context, str2, iWebview, str), (long) (Build.VERSION.SDK_INT >= 25 ? 1500 : 500));
    }

    private Bitmap a(IApp iApp) {
        String b2 = b(iApp);
        if (b2 != null) {
            return BitmapFactory.decodeFile(b2);
        }
        return null;
    }

    private void a(IWebview iWebview, String str, Bitmap bitmap, String str2, String str3, JSONObject jSONObject, boolean z, boolean z2, String str4) {
        Intent obtainWebAppIntent;
        IApp obtainApp = iWebview.obtainApp();
        String obtainAppId = obtainApp.obtainAppId();
        Activity activity = iWebview.getActivity();
        SharedPreferences orCreateBundle = SP.getOrCreateBundle(iWebview.getContext(), "pdr");
        String obtainAppName = PdrUtil.isEmpty(str) ? obtainApp.obtainAppName() : str;
        boolean z3 = orCreateBundle.getBoolean(obtainAppId + SP.K_CREATED_SHORTCUT, false);
        String stringExtra = (!TextUtils.isEmpty(str2) || (obtainWebAppIntent = iWebview.obtainApp().obtainWebAppIntent()) == null) ? str2 : obtainWebAppIntent.getStringExtra(IntentConst.WEBAPP_SHORT_CUT_CLASS_NAME);
        if (Build.VERSION.SDK_INT >= 25) {
            if ((!ShortCutUtil.hasShortcut(activity, obtainAppName) || z) && ShortCutUtil.createShortcutToDeskTop(activity, obtainAppId, obtainAppName, bitmap, stringExtra, jSONObject, true) && !TextUtils.isEmpty(str3)) {
                ToastCompat.makeText(activity.getApplicationContext(), (CharSequence) str3, 1).show();
            }
        } else if (ShortcutCreateUtil.isDuplicateLauncher(activity)) {
            if (ShortCutUtil.createShortcutToDeskTop(activity, obtainAppId, obtainAppName, bitmap, stringExtra, jSONObject, true) && !TextUtils.isEmpty(str3) && ShortcutCreateUtil.needToast(activity)) {
                ToastCompat.makeText(activity.getApplicationContext(), (CharSequence) str3, 1).show();
            }
        } else if (!ShortCutUtil.hasShortcut(activity, obtainAppName)) {
            if (z) {
                if (!TextUtils.isEmpty(str3) && ShortcutCreateUtil.needToast(activity)) {
                    ToastCompat.makeText(activity.getApplicationContext(), (CharSequence) str3, 1).show();
                }
                ShortCutUtil.createShortcutToDeskTop(activity, obtainAppId, obtainAppName, bitmap, stringExtra, jSONObject, true);
            } else if (!z3) {
                if (ShortCutUtil.createShortcutToDeskTop(activity, obtainAppId, obtainAppName, bitmap, stringExtra, jSONObject, true) && !TextUtils.isEmpty(str3) && ShortcutCreateUtil.needToast(activity)) {
                    ToastCompat.makeText(activity.getApplicationContext(), (CharSequence) str3, 1).show();
                }
            } else {
                return;
            }
        }
        a(iWebview.getContext(), iWebview, str4, obtainAppName);
    }
}
