package io.dcloud.feature.nativeObj.richtext;

import android.content.Context;
import android.graphics.Bitmap;
import android.text.TextUtils;
import android.view.MotionEvent;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.nostra13.dcloudimageloader.core.ImageLoaderL;
import com.nostra13.dcloudimageloader.core.assist.FailReason;
import com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.nativeObj.INativeViewChildView;
import io.dcloud.feature.nativeObj.NativeView;
import io.dcloud.feature.nativeObj.richtext.dom.ImgDomElement;
import java.io.InputStream;
import org.json.JSONObject;

public class RichTextLayout {

    /* access modifiers changed from: package-private */
    public static class DefaultAssets implements IAssets {
        boolean isClick;
        String mCallBackId;
        NativeView mNativeView;
        IWebview mWebview;

        DefaultAssets(IWebview iWebview) {
            this(iWebview, null);
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public InputStream convert2InputStream(String str) {
            return this.mWebview.obtainApp().obtainResInStream(this.mWebview.obtainFullUrl(), str);
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public float convertHeight(String str, float f) {
            NativeView nativeView = this.mNativeView;
            if (nativeView != null) {
                return PdrUtil.parseFloat(str, (float) nativeView.mInnerHeight, f, getScale());
            }
            return PdrUtil.parseFloat(str, (float) this.mWebview.obtainApp().getInt(1), f, getScale());
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public float convertWidth(String str, float f) {
            NativeView nativeView = this.mNativeView;
            if (nativeView != null) {
                return PdrUtil.parseFloat(str, (float) nativeView.mInnerWidth, f, getScale());
            }
            return PdrUtil.parseFloat(str, (float) this.mWebview.obtainApp().getInt(0), f, getScale());
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public int getDefaultColor(boolean z) {
            return z ? -16776961 : -16777216;
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public String getOnClickCallBackId() {
            return this.mCallBackId;
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public float getScale() {
            NativeView nativeView = this.mNativeView;
            if (nativeView != null) {
                return nativeView.mCreateScale;
            }
            return this.mWebview.getScale();
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public boolean isClick() {
            return this.isClick;
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public void loadResource(final ImgDomElement.AsycLoader asycLoader) {
            ImageLoaderL.getInstance().loadImage(asycLoader.url, new ImageLoadingListener() {
                /* class io.dcloud.feature.nativeObj.richtext.RichTextLayout.DefaultAssets.AnonymousClass1 */

                @Override // com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener
                public void onLoadingCancelled(String str, View view) {
                }

                @Override // com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener
                public void onLoadingComplete(String str, View view, Bitmap bitmap) {
                    asycLoader.onComplete(bitmap);
                }

                @Override // com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener
                public void onLoadingFailed(String str, View view, FailReason failReason) {
                }

                @Override // com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener
                public void onLoadingStarted(String str, View view) {
                }
            });
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public void setClick(boolean z) {
            this.isClick = z;
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public void setOnClickCallBackId(String str) {
            this.mCallBackId = str;
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public int stringToColor(String str) {
            return PdrUtil.stringToColor(str);
        }

        DefaultAssets(IWebview iWebview, NativeView nativeView) {
            this.mWebview = null;
            this.mNativeView = null;
            this.isClick = false;
            this.mCallBackId = null;
            this.mWebview = iWebview;
            this.mNativeView = nativeView;
        }
    }

    public static class RichTextLayoutHolder extends LinearLayout implements IAssets, INativeViewChildView {
        public boolean isClick = false;
        String mCallBackId = null;
        DefaultAssets mDefaultAssets = null;
        String mItemId = null;
        public TextView mMainView = null;
        NativeView mNativeView = null;
        int mNativeViewHeight = -2;
        IWebview mWebView = null;

        public RichTextLayoutHolder(Context context, IWebview iWebview, NativeView nativeView, String str) {
            super(context);
            this.mWebView = iWebview;
            this.mNativeView = nativeView;
            this.mItemId = str;
            AnonymousClass1 r6 = new TextView(context) {
                /* class io.dcloud.feature.nativeObj.richtext.RichTextLayout.RichTextLayoutHolder.AnonymousClass1 */

                public boolean onTouchEvent(MotionEvent motionEvent) {
                    boolean onTouchEvent = super.onTouchEvent(motionEvent);
                    Object tag = getTag();
                    if (!(tag instanceof String) || !Boolean.parseBoolean((String) tag)) {
                        return false;
                    }
                    return onTouchEvent;
                }
            };
            this.mMainView = r6;
            addView(r6);
            this.mDefaultAssets = new DefaultAssets(iWebview, nativeView);
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public InputStream convert2InputStream(String str) {
            return this.mDefaultAssets.convert2InputStream(str);
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public float convertHeight(String str, float f) {
            return this.mDefaultAssets.convertHeight(str, f);
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public float convertWidth(String str, float f) {
            return this.mDefaultAssets.convertWidth(str, f);
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public int getDefaultColor(boolean z) {
            return this.mDefaultAssets.getDefaultColor(z);
        }

        /* access modifiers changed from: package-private */
        public IWebview getIWebview() {
            return this.mWebView;
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public String getOnClickCallBackId() {
            return this.mCallBackId;
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public float getScale() {
            return this.mNativeView.mCreateScale;
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public boolean isClick() {
            return this.isClick;
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public void loadResource(ImgDomElement.AsycLoader asycLoader) {
            this.mDefaultAssets.loadResource(asycLoader);
        }

        @Override // io.dcloud.feature.nativeObj.INativeViewChildView
        public View obtainMainView() {
            return this.mMainView;
        }

        /* access modifiers changed from: protected */
        public void onMeasure(int i, int i2) {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) getLayoutParams();
            int i3 = layoutParams.width;
            if (!(i3 == -2 || i3 == -1)) {
                i = View.MeasureSpec.makeMeasureSpec(Math.min(this.mNativeView.mInnerWidth, i3), View.MeasureSpec.getMode(i));
            }
            int i4 = layoutParams.height;
            if (!(i4 == -2 || i4 == -1)) {
                i2 = View.MeasureSpec.makeMeasureSpec(Math.min(this.mNativeViewHeight, i4), View.MeasureSpec.getMode(i2));
            }
            super.onMeasure(i, i2);
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public void setClick(boolean z) {
            this.isClick = z;
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public void setOnClickCallBackId(String str) {
            this.mCallBackId = str;
        }

        @Override // io.dcloud.feature.nativeObj.richtext.IAssets
        public int stringToColor(String str) {
            return this.mDefaultAssets.stringToColor(str);
        }

        @Override // io.dcloud.feature.nativeObj.INativeViewChildView
        public void updateLayout() {
            FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) getLayoutParams();
            if (layoutParams == null) {
                layoutParams = new FrameLayout.LayoutParams(this.mNativeView.mInnerWidth, this.mNativeViewHeight);
            }
            NativeView nativeView = this.mNativeView;
            layoutParams.topMargin = nativeView.mInnerTop + (nativeView.isStatusBar() ? DeviceInfo.sStatusBarHeight : 0);
            NativeView nativeView2 = this.mNativeView;
            layoutParams.leftMargin = nativeView2.mInnerLeft;
            layoutParams.width = nativeView2.mInnerWidth;
            int i = nativeView2.mInnerHeight;
            this.mNativeViewHeight = i;
            if (i == 0 && TextUtils.equals("wrap_content", nativeView2.mStyle.optString("height"))) {
                this.mNativeViewHeight = -2;
            }
            layoutParams.height = this.mNativeViewHeight;
            setLayoutParams(layoutParams);
        }
    }

    public static RichTextLayoutHolder makeRichText(Context context, IWebview iWebview, NativeView nativeView, String str, JSONObject jSONObject, JSONObject jSONObject2, String str2) {
        return makeRichText(new RichTextLayoutHolder(context, iWebview, nativeView, str2), str, jSONObject, jSONObject2);
    }

    /* JADX WARNING: Removed duplicated region for block: B:16:0x009b  */
    /* JADX WARNING: Removed duplicated region for block: B:20:0x00ad  */
    /* JADX WARNING: Removed duplicated region for block: B:25:0x00c2  */
    /* JADX WARNING: Removed duplicated region for block: B:30:0x00d6  */
    /* JADX WARNING: Removed duplicated region for block: B:35:0x00ec  */
    /* JADX WARNING: Removed duplicated region for block: B:44:0x0102 A[ADDED_TO_REGION] */
    /* JADX WARNING: Removed duplicated region for block: B:48:0x010b  */
    /* JADX WARNING: Removed duplicated region for block: B:57:0x0121 A[ADDED_TO_REGION] */
    public static RichTextLayoutHolder makeRichText(RichTextLayoutHolder richTextLayoutHolder, String str, JSONObject jSONObject, JSONObject jSONObject2) {
        int i;
        int i2;
        int i3;
        int i4;
        int i5;
        RichTextParser.updateFromHTML(richTextLayoutHolder, richTextLayoutHolder.mWebView, richTextLayoutHolder.mMainView, str, jSONObject2);
        richTextLayoutHolder.updateLayout();
        NativeView nativeView = richTextLayoutHolder.mNativeView;
        int i6 = nativeView.mInnerWidth;
        int i7 = nativeView.mInnerHeight;
        boolean z = !jSONObject.isNull("left");
        boolean z2 = !jSONObject.isNull("right");
        boolean z3 = !jSONObject.isNull("top");
        boolean z4 = !jSONObject.isNull("width");
        boolean z5 = !jSONObject.isNull("height");
        boolean z6 = !jSONObject.isNull("bottom");
        int i8 = nativeView.mInnerLeft;
        int i9 = nativeView.mInnerTop;
        if (z5) {
            String optString = jSONObject.optString("height");
            if (TextUtils.isEmpty(optString)) {
                i = nativeView.mInnerHeight;
            } else if ("wrap_content".equals(optString)) {
                i = -2;
                z5 = false;
            } else {
                i = (int) Math.min((float) richTextLayoutHolder.mNativeViewHeight, richTextLayoutHolder.convertHeight(optString, (float) i7));
                z5 = z5;
            }
        } else {
            i = i7;
        }
        if (z4) {
            String optString2 = jSONObject.optString("width");
            if (!TextUtils.isEmpty(optString2)) {
                i2 = (int) richTextLayoutHolder.convertWidth(optString2, (float) i6);
                if (z3) {
                    String optString3 = jSONObject.optString("top");
                    if (!TextUtils.isEmpty(optString3)) {
                        i9 = (int) richTextLayoutHolder.convertHeight(optString3, (float) i7);
                    }
                }
                if (z) {
                    String optString4 = jSONObject.optString("left");
                    if (!TextUtils.isEmpty(optString4)) {
                        i3 = (int) richTextLayoutHolder.convertWidth(optString4, (float) i6);
                        if (z2) {
                            String optString5 = jSONObject.optString("right");
                            if (!TextUtils.isEmpty(optString5)) {
                                i4 = (int) richTextLayoutHolder.convertWidth(optString5, (float) i6);
                                if (z6) {
                                    String optString6 = jSONObject.optString("bottom");
                                    if (!TextUtils.isEmpty(optString6)) {
                                        i5 = (int) richTextLayoutHolder.convertHeight(optString6, (float) i7);
                                        if (!z) {
                                            if (!z4 && z2) {
                                                i3 = -i4;
                                            } else if (z4 && !z2) {
                                                i3 = (i6 - i2) / 2;
                                            } else if (z4 && z2) {
                                                i3 = (i6 - i2) - i4;
                                            }
                                        } else if (!z4 && z2) {
                                            i2 = (i6 - i3) - i4;
                                        }
                                        if (!z3) {
                                            if (!z5 && z6) {
                                                i9 = -i5;
                                            } else if (z5 && !z6) {
                                                i9 = (i7 - i) / 2;
                                            } else if (z5 && z6) {
                                                i9 = (i7 - i) - i5;
                                            }
                                        } else if (!z5 && z6) {
                                            i = (i7 - i9) - i5;
                                        }
                                        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(i2, i);
                                        layoutParams.leftMargin = i3;
                                        layoutParams.rightMargin = i4;
                                        layoutParams.bottomMargin = i5;
                                        layoutParams.topMargin = i9;
                                        richTextLayoutHolder.mMainView.setLayoutParams(layoutParams);
                                        return richTextLayoutHolder;
                                    }
                                }
                                i5 = 0;
                                if (!z) {
                                }
                                if (!z3) {
                                }
                                LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(i2, i);
                                layoutParams2.leftMargin = i3;
                                layoutParams2.rightMargin = i4;
                                layoutParams2.bottomMargin = i5;
                                layoutParams2.topMargin = i9;
                                richTextLayoutHolder.mMainView.setLayoutParams(layoutParams2);
                                return richTextLayoutHolder;
                            }
                        }
                        i4 = 0;
                        if (z6) {
                        }
                        i5 = 0;
                        if (!z) {
                        }
                        if (!z3) {
                        }
                        LinearLayout.LayoutParams layoutParams22 = new LinearLayout.LayoutParams(i2, i);
                        layoutParams22.leftMargin = i3;
                        layoutParams22.rightMargin = i4;
                        layoutParams22.bottomMargin = i5;
                        layoutParams22.topMargin = i9;
                        richTextLayoutHolder.mMainView.setLayoutParams(layoutParams22);
                        return richTextLayoutHolder;
                    }
                }
                i3 = i8;
                if (z2) {
                }
                i4 = 0;
                if (z6) {
                }
                i5 = 0;
                if (!z) {
                }
                if (!z3) {
                }
                LinearLayout.LayoutParams layoutParams222 = new LinearLayout.LayoutParams(i2, i);
                layoutParams222.leftMargin = i3;
                layoutParams222.rightMargin = i4;
                layoutParams222.bottomMargin = i5;
                layoutParams222.topMargin = i9;
                richTextLayoutHolder.mMainView.setLayoutParams(layoutParams222);
                return richTextLayoutHolder;
            }
        }
        i2 = i6;
        if (z3) {
        }
        if (z) {
        }
        i3 = i8;
        if (z2) {
        }
        i4 = 0;
        if (z6) {
        }
        i5 = 0;
        if (!z) {
        }
        if (!z3) {
        }
        LinearLayout.LayoutParams layoutParams2222 = new LinearLayout.LayoutParams(i2, i);
        layoutParams2222.leftMargin = i3;
        layoutParams2222.rightMargin = i4;
        layoutParams2222.bottomMargin = i5;
        layoutParams2222.topMargin = i9;
        richTextLayoutHolder.mMainView.setLayoutParams(layoutParams2222);
        return richTextLayoutHolder;
    }

    public static TextView makeRichText(Object[] objArr) {
        IWebview obtainWebView = ((IFrameView) objArr[0]).obtainWebView();
        String str = (String) objArr[1];
        JSONObject jSONObject = (JSONObject) objArr[2];
        TextView textView = new TextView(obtainWebView.getContext());
        RichTextParser.updateFromHTML(new DefaultAssets(obtainWebView) {
            /* class io.dcloud.feature.nativeObj.richtext.RichTextLayout.AnonymousClass1 */

            @Override // io.dcloud.feature.nativeObj.richtext.IAssets, io.dcloud.feature.nativeObj.richtext.RichTextLayout.DefaultAssets
            public int getDefaultColor(boolean z) {
                return z ? -16776961 : -1;
            }
        }, obtainWebView, textView, str, jSONObject, (ICallBack) objArr[3]);
        return textView;
    }
}
