package io.dcloud.feature.nativeObj;

import android.app.Activity;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LinearGradient;
import android.graphics.Matrix;
import android.graphics.NinePatch;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Shader;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.graphics.drawable.NinePatchDrawable;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextPaint;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.Base64;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.core.view.GravityCompat;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.load.MultiTransformation;
import com.bumptech.glide.load.resource.bitmap.CenterCrop;
import com.bumptech.glide.load.resource.bitmap.RoundedCorners;
import com.dcloud.android.widget.CapsuleLayout;
import com.dcloud.android.widget.DCProgressView;
import com.taobao.weex.common.Constants;
import com.taobao.weex.el.parse.Operators;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IEventCallback;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.ISysEventListener;
import io.dcloud.common.DHInterface.ITitleNView;
import io.dcloud.common.DHInterface.IWebAppRootView;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.DHInterface.IWebviewStateListener;
import io.dcloud.common.DHInterface.IX5WebView;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.UniMPConfig;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.ui.blur.DCBlurDraweeView;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.Deprecated_JSUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.common.util.TitleNViewUtil;
import io.dcloud.feature.internal.sdk.SDK;
import io.dcloud.feature.nativeObj.NativeView;
import io.dcloud.feature.nativeObj.data.ButtonDataItem;
import io.dcloud.feature.ui.nativeui.a;
import java.io.File;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pl.droidsonroids.gif.GifDrawable;

public class TitleNView extends NativeView implements ITitleNView {
    private final String CLOSE = AbsoluteConst.EVENTS_CLOSE;
    private final String MENU = AbsoluteConst.EVENTS_MENU;
    private LinearLayout centerSearchLayout = null;
    private TextView closeBt = null;
    private AtomicBoolean isSetText = new AtomicBoolean(false);
    private BadgeLinearLayout mBackButton = null;
    private BackGroundDrawable mBackGroundDrawable;
    private View mBackgroudView;
    private DCBlurDraweeView mBlurDraweeView;
    public String mBlurEffect = "none";
    private ArrayList<Object> mButtons = new ArrayList<>();
    private CapsuleLayout mCapsuleLayout;
    private TextView mHomeButton = null;
    protected IWebviewStateListenerImpl mIWebviewStateListenerImpl;
    private LinearLayout mLeftButtonLayout = null;
    private String mMenuButtonFontSize = "22px";
    private String mMenuButtonFontWeight = "normal";
    private int mMenuButtonTextColor = -16777216;
    private ArrayList<ButtonDataItem> mMenuButtons;
    private Progress mProgress;
    private LinearLayout mRightButtonLayout = null;
    private View mSplitLine;
    private RelativeLayout mTitleNViewLayout = null;
    private TextView mTitleView = null;
    private RelativeLayout mTitlelayout;
    public int maxButton = 2;
    private TextView menuBt = null;
    private int redDotColor;
    private EditText searchInput;

    class BackGroundDrawable extends Drawable {
        private String bitmapPath = null;
        private Rect bound;
        private Paint colorPaint;
        private int height = 0;
        private Shader mBackgroundBitmap = null;
        private int mBackgroundColor = 0;
        private Paint mPaint;
        private int offset = 0;
        private String repeatType = "no-repeat";
        private int shadow5PX;
        private String shadowColor = "";
        private int shadowColorInt = 0;
        private Paint shadowPaint;

        public BackGroundDrawable() {
            this.shadow5PX = PdrUtil.convertToScreenInt("10px", TitleNView.this.mInnerWidth, 0, TitleNView.this.mCreateScale);
        }

        private Shader getShader(List<String> list, float f, float f2) {
            float[] parseGradientDirection = parseGradientDirection(list.get(0).trim(), f, f2);
            if (parseGradientDirection == null) {
                return null;
            }
            return new LinearGradient(parseGradientDirection[0], parseGradientDirection[1], parseGradientDirection[2], parseGradientDirection[3], PdrUtil.stringToColor(list.get(1).trim()), PdrUtil.stringToColor(list.get(2).trim()), Shader.TileMode.CLAMP);
        }

        private Paint getShadowPaint() {
            if (this.shadowPaint == null) {
                this.shadowPaint = new Paint();
            }
            return this.shadowPaint;
        }

        /* JADX INFO: Can't fix incorrect switch cases order, some code will duplicate */
        /* JADX WARNING: Code restructure failed: missing block: B:10:0x003f, code lost:
            if (r9.equals("totop") == false) goto L_0x002c;
         */
        private float[] parseGradientDirection(String str, float f, float f2) {
            char c = 4;
            float[] fArr = {0.0f, 0.0f, 0.0f, 0.0f};
            if (!TextUtils.isEmpty(str)) {
                str = str.replaceAll("\\s*", "").toLowerCase(Locale.ENGLISH);
            }
            str.hashCode();
            str.hashCode();
            switch (str.hashCode()) {
                case -1352032154:
                    if (str.equals("tobottom")) {
                        c = 0;
                        break;
                    }
                    c = 65535;
                    break;
                case -1137407871:
                    if (str.equals("toright")) {
                        c = 1;
                        break;
                    }
                    c = 65535;
                    break;
                case -868157182:
                    if (str.equals("toleft")) {
                        c = 2;
                        break;
                    }
                    c = 65535;
                    break;
                case -172068863:
                    if (str.equals("totopleft")) {
                        c = 3;
                        break;
                    }
                    c = 65535;
                    break;
                case 110550266:
                    break;
                case 1176531318:
                    if (str.equals("tobottomright")) {
                        c = 5;
                        break;
                    }
                    c = 65535;
                    break;
                default:
                    c = 65535;
                    break;
            }
            switch (c) {
                case 0:
                    fArr[3] = f2;
                    break;
                case 1:
                    fArr[2] = f;
                    break;
                case 2:
                    fArr[0] = f;
                    break;
                case 3:
                    fArr[0] = f;
                    fArr[1] = f2;
                    break;
                case 4:
                    fArr[1] = f2;
                    break;
                case 5:
                    fArr[2] = f;
                    fArr[3] = f2;
                    break;
                default:
                    return null;
            }
            return fArr;
        }

        private List<String> parseGradientValues(String str) {
            if (TextUtils.isEmpty(str)) {
                return null;
            }
            str.trim();
            try {
                if (str.startsWith("linear-gradient")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(str.substring(str.indexOf(Operators.BRACKET_START_STR) + 1, str.lastIndexOf(Operators.BRACKET_END_STR)), ",");
                    ArrayList arrayList = new ArrayList();
                    while (true) {
                        String str2 = null;
                        while (stringTokenizer.hasMoreTokens()) {
                            String nextToken = stringTokenizer.nextToken();
                            if (nextToken.contains(Operators.BRACKET_START_STR)) {
                                str2 = nextToken + ",";
                            } else if (nextToken.contains(Operators.BRACKET_END_STR)) {
                                arrayList.add(str2 + nextToken);
                            } else if (str2 != null) {
                                str2 = str2 + nextToken + ",";
                            } else {
                                arrayList.add(nextToken);
                            }
                        }
                        return arrayList;
                    }
                }
            } catch (Exception unused) {
            }
            return null;
        }

        private Bitmap scaleBitmap(Bitmap bitmap, int i, int i2) {
            if (bitmap == null) {
                return null;
            }
            if (this.repeatType.equals("repeat")) {
                return bitmap;
            }
            int height2 = bitmap.getHeight();
            int width = bitmap.getWidth();
            float f = ((float) i) / ((float) width);
            float f2 = ((float) i2) / ((float) height2);
            Matrix matrix = new Matrix();
            if (this.repeatType.equals("repeat-x")) {
                matrix.preScale(1.0f, f2);
            } else if (this.repeatType.equals("repeat-y")) {
                matrix.preScale(f, 1.0f);
            } else {
                matrix.preScale(f, f2);
            }
            Bitmap createBitmap = Bitmap.createBitmap(bitmap, 0, 0, width, height2, matrix, false);
            if (!bitmap.isRecycled()) {
                bitmap.recycle();
            }
            return createBitmap;
        }

        public void draw(Canvas canvas) {
            updatebound();
            if (this.mBackgroundBitmap != null) {
                getPaint().setShader(this.mBackgroundBitmap);
                getBackgroundColorPaint().setColor(Color.argb(getBackgroundColorPaint().getAlpha(), 255, 255, 255));
                canvas.drawRect(this.bound, getBackgroundColorPaint());
            } else {
                String str = this.bitmapPath;
                if (str != null) {
                    setBackgroundImage(str);
                    this.bitmapPath = null;
                    getPaint().setShader(this.mBackgroundBitmap);
                    getBackgroundColorPaint().setColor(Color.argb(getBackgroundColorPaint().getAlpha(), 255, 255, 255));
                    canvas.drawRect(this.bound, getBackgroundColorPaint());
                } else {
                    getPaint().setColor(this.mBackgroundColor);
                }
            }
            canvas.drawRect(this.bound, getPaint());
            if (!PdrUtil.isEmpty(this.shadowColor)) {
                Rect rect = this.bound;
                int i = rect.left;
                int i2 = rect.bottom;
                int i3 = rect.right;
                int i4 = this.height;
                if (i4 == 0) {
                    i4 = this.shadow5PX;
                }
                Rect rect2 = new Rect(i, i2, i3, i4 + i2 + this.offset);
                Paint shadowPaint2 = getShadowPaint();
                int i5 = rect2.top;
                int i6 = this.offset;
                shadowPaint2.setShader(new LinearGradient(0.0f, (float) (i5 - i6), 0.0f, (float) (rect2.bottom - i6), this.shadowColorInt, 0, Shader.TileMode.CLAMP));
                canvas.drawRect(rect2, getShadowPaint());
            }
            if (this.mBackgroundBitmap != null) {
                getPaint().setShader(null);
            }
        }

        public Paint getBackgroundColorPaint() {
            if (this.colorPaint == null) {
                this.colorPaint = new Paint();
            }
            return this.colorPaint;
        }

        public int getOpacity() {
            return 0;
        }

        public Paint getPaint() {
            if (this.mPaint == null) {
                this.mPaint = new Paint(1);
            }
            return this.mPaint;
        }

        public void setAlpha(int i) {
            if (this.mBackgroundBitmap != null || this.bitmapPath != null) {
                getPaint().setAlpha(i);
                getBackgroundColorPaint().setAlpha(i);
            }
        }

        public void setBackgroundColor(int i) {
            if (this.mBackgroundBitmap != null) {
                setAlpha(Color.alpha(i));
            }
            this.mBackgroundColor = i;
            getShadowPaint().setAlpha(Color.alpha(i));
            invalidateSelf();
        }

        public void setBackgroundImage(String str) {
            Bitmap bitmap;
            Bitmap bitmap2;
            Rect rect = this.bound;
            if (rect == null || rect.width() == 0) {
                this.bitmapPath = str;
            } else if (str != null) {
                List<String> parseGradientValues = parseGradientValues(str);
                if (parseGradientValues == null || parseGradientValues.size() != 3) {
                    String convert2AbsFullPath = TitleNView.this.mWebView.obtainApp().convert2AbsFullPath(TitleNView.this.mWebView.obtainFullUrl(), str);
                    if (!PdrUtil.isDeviceRootDir(convert2AbsFullPath)) {
                        try {
                            bitmap = BitmapFactory.decodeStream(TitleNView.this.mWebView.getContext().getAssets().open(convert2AbsFullPath));
                        } catch (Exception unused) {
                            bitmap = null;
                        }
                    } else {
                        bitmap = BitmapFactory.decodeFile(convert2AbsFullPath);
                    }
                    if (bitmap == null) {
                        this.mBackgroundBitmap = null;
                        this.bitmapPath = null;
                        invalidateSelf();
                        return;
                    }
                    byte[] ninePatchChunk = bitmap.getNinePatchChunk();
                    if (ninePatchChunk == null || !NinePatch.isNinePatchChunk(ninePatchChunk)) {
                        bitmap2 = scaleBitmap(bitmap, this.bound.width(), this.bound.height());
                    } else {
                        NinePatchDrawable ninePatchDrawable = new NinePatchDrawable(bitmap, ninePatchChunk, new Rect(), null);
                        bitmap2 = Bitmap.createBitmap(this.bound.width(), this.bound.height(), Bitmap.Config.ARGB_8888);
                        Canvas canvas = new Canvas(bitmap2);
                        ninePatchDrawable.setBounds(0, 0, canvas.getWidth(), canvas.getHeight());
                        ninePatchDrawable.draw(canvas);
                    }
                    if (bitmap2 == null) {
                        this.mBackgroundBitmap = null;
                    } else {
                        Shader.TileMode tileMode = Shader.TileMode.REPEAT;
                        this.mBackgroundBitmap = new BitmapShader(bitmap2, tileMode, tileMode);
                    }
                } else {
                    this.mBackgroundBitmap = getShader(parseGradientValues, (float) this.bound.width(), (float) this.bound.height());
                }
                invalidateSelf();
            }
        }

        public void setColorFilter(ColorFilter colorFilter) {
        }

        public void setRepeatType(String str, String str2) {
            if (!PdrUtil.isEmpty(str) && !this.repeatType.equals(str)) {
                this.repeatType = str;
                this.mBackgroundBitmap = null;
                updatebound();
                setBackgroundImage(str2);
            }
        }

        public void setShadowColor(JSONObject jSONObject) {
            String optString = jSONObject.has("color") ? jSONObject.optString("color") : "";
            String optString2 = jSONObject.has("height") ? jSONObject.optString("height") : "10px";
            String optString3 = jSONObject.has("offset") ? jSONObject.optString("offset") : "0px";
            TitleNView titleNView = TitleNView.this;
            this.height = PdrUtil.convertToScreenInt(optString2, titleNView.mInnerWidth, 0, titleNView.mCreateScale);
            TitleNView titleNView2 = TitleNView.this;
            this.offset = PdrUtil.convertToScreenInt(optString3, titleNView2.mInnerWidth, 0, titleNView2.mCreateScale);
            if (!optString.equals(this.shadowColor)) {
                this.shadowColor = optString;
                this.shadowColorInt = PdrUtil.stringToColor(optString);
                invalidateSelf();
            }
        }

        public void updatebound() {
            View view;
            if (this.bound == null) {
                this.bound = new Rect();
            }
            TitleNView titleNView = TitleNView.this;
            if (!titleNView.isImmersed || !titleNView.isStatusBarHas()) {
                this.bound.top = 0;
            } else {
                this.bound.top = DeviceInfo.sStatusBarHeight;
            }
            TitleNView titleNView2 = TitleNView.this;
            if (titleNView2.isStatusBar && (view = titleNView2.mStatusbarView) != null && view.getVisibility() == 0) {
                this.bound.top = DeviceInfo.sStatusBarHeight;
            }
            Rect rect = this.bound;
            TitleNView titleNView3 = TitleNView.this;
            int i = titleNView3.mInnerHeight;
            rect.bottom = rect.top + i;
            if (titleNView3.isStatusBar && titleNView3.isImmersed) {
                rect.bottom = i + DeviceInfo.sStatusBarHeight;
            }
            rect.left = 0;
            rect.right = getBounds().right;
        }
    }

    static class IWebviewStateListenerImpl implements IWebviewStateListener {
        private SoftReference<Progress> mProgress;

        public IWebviewStateListenerImpl(Progress progress) {
            this.mProgress = new SoftReference<>(progress);
        }

        @Override // io.dcloud.common.DHInterface.ICallBack
        public Object onCallBack(int i, Object obj) {
            if (this.mProgress.get() == null || this.mProgress.get().getParent() == null || this.mProgress.get().getVisibility() != 0) {
                return null;
            }
            if (i == 3) {
                this.mProgress.get().updateProgress(((Integer) obj).intValue());
                return null;
            } else if ((i != 1 && i != 5) || this.mProgress.get() == null || this.mProgress.get().isFinish()) {
                return null;
            } else {
                this.mProgress.get().finishProgress();
                return null;
            }
        }
    }

    static class Progress extends DCProgressView {
        Progress(Context context) {
            super(context);
        }
    }

    private class SearchInputDrawable extends Drawable {
        private Paint mPaint;
        private int radius;

        public SearchInputDrawable(int i, int i2) {
            Paint paint = new Paint();
            this.mPaint = paint;
            paint.setAntiAlias(true);
            this.mPaint.setColor(i);
            this.radius = i2;
        }

        public void draw(Canvas canvas) {
            RectF rectF = new RectF(getBounds());
            float f = (float) this.radius;
            canvas.drawRoundRect(rectF, f, f, this.mPaint);
        }

        public int getAlpha() {
            return this.mPaint.getAlpha();
        }

        public int getDrawableColor() {
            Paint paint = this.mPaint;
            if (paint != null) {
                return paint.getColor();
            }
            return 0;
        }

        public int getOpacity() {
            return -3;
        }

        public void setAlpha(int i) {
            this.mPaint.setAlpha(i);
            invalidateSelf();
        }

        public void setColorFilter(ColorFilter colorFilter) {
            this.mPaint.setColorFilter(colorFilter);
            invalidateSelf();
        }

        public void setDrawableColor(int i) {
            Paint paint = this.mPaint;
            if (paint != null) {
                paint.setColor(i);
            }
            invalidateSelf();
        }
    }

    public TitleNView(Context context, IWebview iWebview, String str, String str2, JSONObject jSONObject) {
        super(context, iWebview, str, str2, jSONObject);
        setTag("titleNView");
        if (SDK.isUniMPSDK()) {
            initCapsuleLayout();
        }
    }

    private void addButtonOnClickListener(final String str, final IWebview iWebview, View view) {
        view.setOnClickListener(new View.OnClickListener() {
            /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass12 */

            public void onClick(View view) {
                TitleNView.this.buttonOnclick(str, iWebview);
            }
        });
    }

    private TextView addSelect(ViewGroup viewGroup, TextView textView, int i) {
        TextView textView2 = new TextView(getContext());
        textView2.setText("");
        textView2.setTypeface(Typeface.createFromAsset(getContext().getAssets(), "fonts/dcloud_iconfont.ttf"));
        textView2.setSingleLine();
        textView2.setLines(1);
        textView2.setGravity(17);
        textView2.setIncludeFontPadding(false);
        textView2.getPaint().setTextSize((float) PdrUtil.convertToScreenInt("15px", this.mInnerWidth, i, this.mCreateScale));
        viewGroup.addView(textView2, new LinearLayout.LayoutParams(-2, -1));
        return textView2;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void buttonOnclick(String str, IWebview iWebview) {
        if (!TextUtils.isEmpty(str)) {
            if (str.toLowerCase(Locale.ENGLISH).startsWith(AbsoluteConst.PROTOCOL_JAVASCRIPT)) {
                IFrameView iFrameView = this.mFrameViewParent;
                if (!(iFrameView == null || iFrameView.obtainWindowMgr() == null || this.mFrameViewParent.obtainApp() == null)) {
                    Object processEvent = this.mFrameViewParent.obtainWindowMgr().processEvent(IMgr.MgrType.WindowMgr, 47, this.mFrameViewParent.obtainApp().obtainAppId());
                    if (processEvent instanceof IFrameView) {
                        IFrameView iFrameView2 = (IFrameView) processEvent;
                        if (!(iFrameView2.obtainWebView() == null || iFrameView2.obtainWebView().obtainWindowView() == null)) {
                            iFrameView2.obtainWebView().loadUrl(str);
                            return;
                        }
                    }
                }
                IWebview iWebview2 = this.mWebView;
                if (iWebview2 != null && iWebview2.obtainWindowView() != null) {
                    this.mWebView.loadUrl(str);
                    return;
                } else if (!(iWebview == null || iWebview.obtainWindowView() == null)) {
                    iWebview.loadUrl(str);
                    return;
                }
            }
            if (iWebview != null) {
                Deprecated_JSUtil.execCallback(iWebview, str, "", JSUtil.OK, false, true);
                if (iWebview.getOpener() != null) {
                    Deprecated_JSUtil.execCallback(iWebview.getOpener(), str, "", JSUtil.OK, false, true);
                }
            }
        }
    }

    private void caculateTitleMargin() {
        RelativeLayout relativeLayout = this.mTitlelayout;
        if (relativeLayout != null && relativeLayout.getVisibility() == 0) {
            int convertToScreenInt = PdrUtil.convertToScreenInt("10px", this.mInnerWidth, 0, this.mCreateScale);
            initLeftButtonLayout();
            initRightButtonLayout();
            int width = this.mLeftButtonLayout.getWidth();
            int width2 = this.mRightButtonLayout.getWidth();
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) this.mTitlelayout.getLayoutParams();
            int i = convertToScreenInt / 2;
            int i2 = this.mInnerHeight - i;
            float f = 0.0f;
            TextView textView = this.mTitleView;
            if (textView != null) {
                f = textView.getPaint().measureText("张磊 ");
            }
            int i3 = layoutParams.rightMargin;
            int min = ((int) Math.min((((float) (this.mTitleNViewLayout.getWidth() - i2)) - f) / 2.0f, (float) Math.max(width, width2))) + i;
            if (i3 != min) {
                int[] rules = layoutParams.getRules();
                if (rules == null || rules.length <= 0 || rules[1] <= 0) {
                    layoutParams.rightMargin = min;
                    layoutParams.leftMargin = min;
                } else {
                    layoutParams.rightMargin = min;
                }
                this.mTitlelayout.setLayoutParams(layoutParams);
                this.mTitlelayout.bringToFront();
            }
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void capsuleButtonClick(String str) {
        IWebview iWebview = this.mWebView;
        if (iWebview != null && iWebview.obtainFrameView() != null) {
            str.hashCode();
            if (str.equals(AbsoluteConst.EVENTS_MENU)) {
                Bundle bundle = new Bundle();
                bundle.putString("appid", this.mWebView.obtainApp().obtainAppId());
                bundle.putString("type", AbsoluteConst.EVENTS_MENU);
                IWebview iWebview2 = this.mWebView;
                iWebview2.obtainFrameView().obtainWindowMgr().processEvent(IMgr.MgrType.WindowMgr, 80, new Object[]{iWebview2, bundle});
                if (!UniMPConfig.isCapsuleMenuIntercept) {
                    showCapsuleMenu(getMenuArray());
                }
            } else if (str.equals(AbsoluteConst.EVENTS_CLOSE)) {
                Bundle bundle2 = new Bundle();
                bundle2.putString("appid", this.mWebView.obtainApp().obtainAppId());
                bundle2.putString("type", AbsoluteConst.EVENTS_CLOSE);
                IWebview iWebview3 = this.mWebView;
                Object[] objArr = {iWebview3, bundle2};
                AbsMgr obtainWindowMgr = iWebview3.obtainFrameView().obtainWindowMgr();
                IMgr.MgrType mgrType = IMgr.MgrType.WindowMgr;
                obtainWindowMgr.processEvent(mgrType, 80, objArr);
                if (!UniMPConfig.isCapsuleCloseIntercept) {
                    this.mWebView.obtainFrameView().obtainWindowMgr().processEvent(mgrType, 20, this.mWebView.obtainApp().obtainAppId());
                }
            } else {
                throw new IllegalStateException("Unexpected value: " + str);
            }
        }
    }

    private View createButton(String str, String str2, String str3, String str4, String str5, String str6, String str7, String str8, IWebview iWebview, String str9, String str10, boolean z, String str11, boolean z2, String str12, String str13) {
        int stringToColor;
        int stringToColor2;
        int i;
        int convertToScreenInt;
        BadgeRelateiveLayout badgeRelateiveLayout = new BadgeRelateiveLayout(this, getContext(), this.mCreateScale, this.redDotColor);
        int i2 = 0;
        badgeRelateiveLayout.setOrientation(0);
        badgeRelateiveLayout.setGravity(17);
        badgeRelateiveLayout.setPadding(0, 0, 0, 0);
        TextView textView = new TextView(getContext());
        textView.setGravity(17);
        StringBuilder sb = new StringBuilder();
        sb.append("TitleNView.Button.");
        sb.append(str == null ? "" : str);
        textView.setTag(sb.toString());
        textView.setId(View.generateViewId());
        textView.setSingleLine();
        textView.setLines(1);
        textView.setIncludeFontPadding(false);
        if (!PdrUtil.isEmpty(str12) && (convertToScreenInt = PdrUtil.convertToScreenInt(str12, this.mAppScreenWidth, 0, this.mCreateScale)) > 0) {
            textView.setEllipsize(TextUtils.TruncateAt.END);
            textView.setMaxWidth(convertToScreenInt);
        }
        try {
            stringToColor = Color.parseColor(str2);
        } catch (Exception unused) {
            stringToColor = PdrUtil.stringToColor(str2);
        }
        try {
            stringToColor2 = Color.parseColor(str3);
        } catch (Exception unused2) {
            stringToColor2 = PdrUtil.stringToColor(str3);
        }
        textView.setTextColor(createColorStateList(stringToColor, stringToColor2));
        if (Constants.Value.BOLD.equals(str4)) {
            textView.getPaint().setFakeBoldText(true);
        }
        setTextAndFont(str, str6, str7, textView, TextUtils.isEmpty(str7));
        int convertToScreenInt2 = PdrUtil.convertToScreenInt(TextUtils.isEmpty(str5) ? "transparent".equals(str9) ? "22px" : "27px" : "17px", this.mInnerWidth, 0, this.mCreateScale);
        textView.getPaint().setTextSize((float) PdrUtil.convertToScreenInt(str5, this.mInnerWidth, convertToScreenInt2, this.mCreateScale));
        try {
            i = Color.parseColor(str10);
        } catch (Exception unused3) {
            i = PdrUtil.stringToColor(str10);
        }
        if ("transparent".equals(str9)) {
            i2 = i;
        }
        NativeViewBackButtonDrawable nativeViewBackButtonDrawable = new NativeViewBackButtonDrawable(i2);
        nativeViewBackButtonDrawable.setWidth(str13);
        badgeRelateiveLayout.addView(textView, new LinearLayout.LayoutParams(-2, -1, 1.0f));
        if (z2) {
            addSelect(badgeRelateiveLayout, textView, convertToScreenInt2).setTextColor(createColorStateList(stringToColor, stringToColor2));
            textView.setEllipsize(TextUtils.TruncateAt.END);
        }
        badgeRelateiveLayout.setBackground(nativeViewBackButtonDrawable);
        addButtonOnClickListener(str8, iWebview, badgeRelateiveLayout);
        badgeRelateiveLayout.setBadgeStr(str11);
        badgeRelateiveLayout.setDrawRedDot(z);
        this.mButtons.add(badgeRelateiveLayout);
        return badgeRelateiveLayout;
    }

    private TextView getCapsuleButton(String str) {
        TextView textView = new TextView(getContext());
        textView.setGravity(17);
        textView.setId(View.generateViewId());
        textView.setSingleLine();
        textView.setLines(1);
        textView.setIncludeFontPadding(false);
        textView.getPaint().setFakeBoldText(true);
        textView.getPaint().setTextSize((float) PdrUtil.convertToScreenInt("19px", this.mInnerWidth, 0, this.mCreateScale));
        Typeface createFromAsset = Typeface.createFromAsset(getContext().getAssets(), "fonts/dcloud_iconfont.ttf");
        if (createFromAsset != null) {
            textView.setTypeface(createFromAsset);
        }
        return textView;
    }

    private String getIconPath(String str) {
        if (PdrUtil.isNetPath(str)) {
            return str;
        }
        String convert2AbsFullPath = this.mApp.convert2AbsFullPath(this.mWebView.obtainFullUrl(), str);
        if (convert2AbsFullPath == null || !PdrUtil.isDeviceRootDir(convert2AbsFullPath)) {
            if (convert2AbsFullPath != null && convert2AbsFullPath.startsWith("/") && convert2AbsFullPath.length() > 1) {
                convert2AbsFullPath = convert2AbsFullPath.substring(1);
            }
            return SDK.ANDROID_ASSET + convert2AbsFullPath;
        }
        return DeviceInfo.FILE_PROTOCOL + convert2AbsFullPath;
    }

    private JSONArray getMenuArray() {
        JSONObject jSONObject;
        JSONArray jSONArray = new JSONArray();
        for (int i = 0; i < this.mMenuButtons.size(); i++) {
            ButtonDataItem buttonDataItem = this.mMenuButtons.get(i);
            JSONObject jSONObject2 = new JSONObject();
            try {
                jSONObject2.put(AbsoluteConst.JSON_KEY_TITLE, TextUtils.isEmpty(buttonDataItem.getTitle()) ? buttonDataItem.getText() : buttonDataItem.getTitle());
            } catch (JSONException e) {
                e.printStackTrace();
            }
            jSONArray.put(jSONObject2);
        }
        if (this.mMenuButtons.size() > 0) {
            JSONObject jSONObject3 = new JSONObject();
            try {
                jSONObject3.put(AbsoluteConst.JSON_KEY_TITLE, "");
                jSONObject3.put("type", "interval");
                jSONArray.put(jSONObject3);
            } catch (JSONException e2) {
                e2.printStackTrace();
            }
        }
        if (SDK.sDefaultMenuButton != null) {
            try {
                JSONObject jSONObject4 = new JSONObject(SDK.sDefaultMenuButton);
                if (jSONObject4.has(AbsoluteConst.EVENTS_MENU) && (jSONObject = jSONObject4.getJSONObject(AbsoluteConst.EVENTS_MENU)) != null && jSONObject.has("buttons")) {
                    JSONArray jSONArray2 = jSONObject.getJSONArray("buttons");
                    for (int i2 = 0; i2 < jSONArray2.length(); i2++) {
                        jSONArray.put(jSONArray2.getJSONObject(i2));
                    }
                }
            } catch (JSONException e3) {
                e3.printStackTrace();
            }
        }
        return jSONArray;
    }

    private void initCapsuleLayout() {
        JSONObject jSONObject;
        if (this.mCapsuleLayout == null && SDK.isCapsule) {
            this.mMenuButtons = new ArrayList<>();
            int convertToScreenInt = this.mInnerHeight - PdrUtil.convertToScreenInt("12px", this.mAppScreenWidth, 0, this.mCreateScale);
            CapsuleLayout capsuleLayout = new CapsuleLayout(getContext(), (float) (convertToScreenInt / 2));
            this.mCapsuleLayout = capsuleLayout;
            capsuleLayout.setId(View.generateViewId());
            this.mCapsuleLayout.setGravity(16);
            this.mCapsuleLayout.setOrientation(0);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, convertToScreenInt);
            layoutParams.addRule(15);
            layoutParams.addRule(11);
            float f = this.mCreateScale;
            int i = (int) (13.0f * f);
            int i2 = (int) (f * 10.0f);
            layoutParams.rightMargin = i;
            initTitleNViewLayout();
            this.mTitleNViewLayout.addView(this.mCapsuleLayout, layoutParams);
            if (this.menuBt == null) {
                TextView capsuleButton = getCapsuleButton(AbsoluteConst.EVENTS_MENU);
                this.menuBt = capsuleButton;
                capsuleButton.setText("");
            }
            this.menuBt.setTextColor(-16777216);
            LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-2, -2);
            layoutParams2.leftMargin = i;
            layoutParams2.gravity = 17;
            layoutParams2.rightMargin = i2;
            this.mCapsuleLayout.addButtonView(this.menuBt, layoutParams2, CapsuleLayout.ButtonType.LIFT, new View.OnClickListener() {
                /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass13 */

                public void onClick(View view) {
                    TitleNView.this.capsuleButtonClick(AbsoluteConst.EVENTS_MENU);
                }
            });
            this.mCapsuleLayout.addIntervalView(this.mCreateScale);
            if (this.closeBt == null) {
                TextView capsuleButton2 = getCapsuleButton(AbsoluteConst.EVENTS_CLOSE);
                this.closeBt = capsuleButton2;
                capsuleButton2.setText("");
            }
            this.closeBt.setTextColor(-16777216);
            LinearLayout.LayoutParams layoutParams3 = new LinearLayout.LayoutParams(-2, -2);
            layoutParams3.rightMargin = i;
            layoutParams3.gravity = 17;
            layoutParams3.leftMargin = i2;
            this.mCapsuleLayout.addButtonView(this.closeBt, layoutParams3, CapsuleLayout.ButtonType.RIGHT, new View.OnClickListener() {
                /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass14 */

                public void onClick(View view) {
                    TitleNView.this.capsuleButtonClick(AbsoluteConst.EVENTS_CLOSE);
                }
            });
            if (!TextUtils.isEmpty(SDK.sDefaultMenuButton)) {
                try {
                    JSONObject jSONObject2 = new JSONObject(SDK.sDefaultMenuButton);
                    if (jSONObject2.has(AbsoluteConst.EVENTS_MENU) && (jSONObject = jSONObject2.getJSONObject(AbsoluteConst.EVENTS_MENU)) != null) {
                        if (jSONObject.has("textColor")) {
                            this.mMenuButtonTextColor = PdrUtil.stringToColor(jSONObject.getString("textColor"));
                        }
                        if (jSONObject.has(Constants.Name.FONT_SIZE) && !TextUtils.isEmpty(jSONObject.getString(Constants.Name.FONT_SIZE))) {
                            this.mMenuButtonFontSize = jSONObject.getString(Constants.Name.FONT_SIZE);
                        }
                        if (jSONObject.has(Constants.Name.FONT_WEIGHT)) {
                            if (Constants.Value.BOLD.equals(jSONObject.getString(Constants.Name.FONT_WEIGHT))) {
                                this.mMenuButtonFontWeight = Constants.Value.BOLD;
                            } else {
                                this.mMenuButtonFontWeight = "normal";
                            }
                        }
                    }
                    if (jSONObject2.has("capsuleButtonStyle")) {
                        setCapsuleButtonStyle(jSONObject2.getJSONObject("capsuleButtonStyle"));
                    }
                } catch (JSONException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private void initCenterSearchLayout() {
        if (this.centerSearchLayout == null) {
            LinearLayout linearLayout = new LinearLayout(getContext());
            this.centerSearchLayout = linearLayout;
            linearLayout.setId(View.generateViewId());
            this.centerSearchLayout.setGravity(16);
            this.centerSearchLayout.setOrientation(0);
            this.centerSearchLayout.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, this.mInnerHeight - PdrUtil.convertToScreenInt("12px", this.mAppScreenWidth, 0, this.mCreateScale));
            LinearLayout linearLayout2 = this.mRightButtonLayout;
            if (linearLayout2 != null) {
                layoutParams.addRule(0, linearLayout2.getId());
            } else {
                layoutParams.addRule(11);
            }
            LinearLayout linearLayout3 = this.mLeftButtonLayout;
            if (linearLayout3 != null) {
                layoutParams.addRule(1, linearLayout3.getId());
            } else {
                layoutParams.addRule(9);
            }
            layoutParams.addRule(15);
            layoutParams.rightMargin = PdrUtil.convertToScreenInt("5px", this.mAppScreenWidth, 0, this.mCreateScale);
            layoutParams.leftMargin = PdrUtil.convertToScreenInt("5px", this.mAppScreenWidth, 0, this.mCreateScale);
            this.mTitleNViewLayout.addView(this.centerSearchLayout, layoutParams);
        }
    }

    private void initLeftButtonLayout() {
        if (this.mLeftButtonLayout == null) {
            LinearLayout linearLayout = new LinearLayout(getContext());
            this.mLeftButtonLayout = linearLayout;
            linearLayout.setId(View.generateViewId());
            this.mLeftButtonLayout.setGravity(16);
            this.mLeftButtonLayout.setOrientation(0);
            this.mLeftButtonLayout.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -1);
            layoutParams.addRule(15);
            layoutParams.addRule(9);
            this.mTitleNViewLayout.addView(this.mLeftButtonLayout, layoutParams);
        }
    }

    private void initRightButtonLayout() {
        if (this.mRightButtonLayout == null) {
            LinearLayout linearLayout = new LinearLayout(getContext());
            this.mRightButtonLayout = linearLayout;
            linearLayout.setId(View.generateViewId());
            this.mRightButtonLayout.setGravity(16);
            this.mRightButtonLayout.setOrientation(0);
            this.mRightButtonLayout.setLayoutParams(new ViewGroup.LayoutParams(-2, -1));
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -1);
            layoutParams.addRule(15);
            CapsuleLayout capsuleLayout = this.mCapsuleLayout;
            if (capsuleLayout != null) {
                layoutParams.addRule(0, capsuleLayout.getId());
            } else {
                layoutParams.addRule(11);
            }
            this.mTitleNViewLayout.addView(this.mRightButtonLayout, layoutParams);
        }
    }

    private void initTitleNViewLayout() {
        boolean z;
        IFrameView iFrameView;
        if (this.mTitleNViewLayout == null) {
            this.mTitleNViewLayout = new RelativeLayout(getContext());
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(-1, this.mInnerHeight);
            ViewParent parent = getParent();
            int i = 0;
            if (!TextUtils.equals(this.mStyle.optString("position", AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE), AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE) && parent != null && (parent instanceof ViewGroup)) {
                int i2 = 0;
                while (true) {
                    ViewGroup viewGroup = (ViewGroup) parent;
                    if (i2 >= viewGroup.getChildCount()) {
                        break;
                    }
                    Object tag = viewGroup.getChildAt(i2).getTag();
                    if (tag != null && "StatusBar".equalsIgnoreCase(tag.toString())) {
                        z = true;
                        break;
                    }
                    i2++;
                }
            }
            z = false;
            if (!z && (iFrameView = this.mFrameViewParent) != null && iFrameView.obtainApp().obtainStatusBarMgr().isImmersive) {
                i = 0 + DeviceInfo.sStatusBarHeight;
            }
            layoutParams.topMargin = i;
            addView(this.mTitleNViewLayout, layoutParams);
        }
    }

    public static boolean isBase64Image(String str) {
        return Pattern.compile("^data:image/.*;base64,").matcher(str).find();
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private boolean isStatusBarHas() {
        IWebview iWebview = this.mWebView;
        if (iWebview == null || iWebview.obtainFrameView() == null) {
            return false;
        }
        return ((AdaFrameItem) this.mWebView.obtainFrameView()).obtainFrameOptions().isStatusbar;
    }

    private void layoutSubtitleIcon(String str, String str2, String str3, String str4, String str5, String str6, ImageView imageView, TextView textView, int i, String str7, String str8) {
        GifDrawable gifDrawable;
        int convertToScreenInt = PdrUtil.convertToScreenInt("10px", this.mInnerWidth, 0, this.mCreateScale);
        if (-1 == this.mTitlelayout.indexOfChild(imageView)) {
            this.mTitlelayout.addView(imageView);
        }
        if (!PdrUtil.isEmpty(str)) {
            int convertToScreenInt2 = PdrUtil.convertToScreenInt(str8, this.mInnerWidth, 0, this.mCreateScale);
            if (convertToScreenInt2 <= 0) {
                convertToScreenInt2 = this.mInnerHeight - convertToScreenInt;
            }
            int i2 = this.mInnerHeight;
            if (convertToScreenInt2 > i2) {
                convertToScreenInt2 = i2;
            }
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(convertToScreenInt2, convertToScreenInt2);
            layoutParams.addRule(9);
            layoutParams.addRule(15);
            layoutParams.rightMargin = convertToScreenInt / 2;
            int convertToScreenInt3 = PdrUtil.convertToScreenInt(str2, this.mInnerWidth, 0, this.mCreateScale);
            boolean isBase64Image = isBase64Image(str);
            if (!isBase64Image) {
                try {
                    gifDrawable = new GifDrawable(getContext().getContentResolver(), Uri.parse(getIconPath(str)));
                } catch (IOException unused) {
                    gifDrawable = null;
                }
            } else {
                gifDrawable = new GifDrawable(Base64.decode(str.replaceFirst("^data:image/.*;base64,", ""), 0));
            }
            if (convertToScreenInt3 <= 0) {
                RequestManager with = Glide.with(getContext());
                if (gifDrawable != null) {
                    imageView.setImageDrawable(gifDrawable);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                } else {
                    ((RequestBuilder) with.load(isBase64Image ? Base64.decode(str.replaceFirst("^data:image/.*;base64,", ""), 0) : getIconPath(str)).transform(new CenterCrop())).into(imageView);
                }
            } else {
                RequestManager with2 = Glide.with(getContext());
                if (gifDrawable != null) {
                    gifDrawable.setTransform(new GIFCornerRadiusTransform((float) convertToScreenInt3, convertToScreenInt2));
                    imageView.setImageDrawable(gifDrawable);
                    imageView.setScaleType(ImageView.ScaleType.CENTER_CROP);
                } else {
                    ((RequestBuilder) with2.load(isBase64Image ? Base64.decode(str.replaceFirst("^data:image/.*;base64,", ""), 0) : getIconPath(str)).transform(new MultiTransformation(new CenterCrop(), new RoundedCorners(convertToScreenInt3)))).into(imageView);
                }
            }
            if (-1 == this.mTitlelayout.indexOfChild(imageView)) {
                this.mTitlelayout.addView(imageView, layoutParams);
            } else {
                imageView.setLayoutParams(layoutParams);
            }
            imageView.setVisibility(0);
        } else {
            imageView.setVisibility(8);
        }
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-2, -2);
        layoutParams2.addRule(10);
        if (imageView.getVisibility() == 0 || str7.equals("left") || str7.equals("auto")) {
            layoutParams2.addRule(1, imageView.getId());
        } else {
            layoutParams2.addRule(14);
        }
        if (-1 == this.mTitlelayout.indexOfChild(this.mTitleView)) {
            this.mTitlelayout.addView(this.mTitleView, layoutParams2);
        } else {
            this.mTitleView.setLayoutParams(layoutParams2);
        }
        if (-1 == this.mTitlelayout.indexOfChild(textView)) {
            this.mTitlelayout.addView(textView);
        }
        if (!PdrUtil.isEmpty(str3)) {
            RelativeLayout.LayoutParams layoutParams3 = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams3.addRule(3, this.mTitleView.getId());
            if (imageView.getVisibility() == 0 || str7.equals("left") || str7.equals("auto")) {
                layoutParams3.addRule(1, imageView.getId());
            } else {
                layoutParams3.addRule(14);
            }
            textView.setText(str3);
            if ("clip".equals(str6)) {
                textView.setEllipsize(null);
            } else {
                textView.setEllipsize(TextUtils.TruncateAt.END);
            }
            textView.setSingleLine();
            textView.setLines(1);
            textView.setTextColor(PdrUtil.isEmpty(str4) ? i : PdrUtil.stringToColor(str4));
            textView.getPaint().setTextSize((float) PdrUtil.convertToScreenInt(PdrUtil.isEmpty(str5) ? "12px" : str5, this.mInnerWidth, 0, this.mCreateScale));
            if (-1 == this.mTitlelayout.indexOfChild(textView)) {
                this.mTitlelayout.addView(textView, layoutParams3);
            } else {
                textView.setLayoutParams(layoutParams3);
            }
            textView.setVisibility(0);
        } else {
            textView.setVisibility(8);
        }
        if (textView.getVisibility() == 0) {
            RelativeLayout.LayoutParams layoutParams4 = (RelativeLayout.LayoutParams) this.mTitleView.getLayoutParams();
            layoutParams4.addRule(10);
            layoutParams4.removeRule(15);
            this.mTitleView.setLayoutParams(layoutParams2);
            return;
        }
        RelativeLayout.LayoutParams layoutParams5 = (RelativeLayout.LayoutParams) this.mTitleView.getLayoutParams();
        layoutParams5.removeRule(10);
        layoutParams5.addRule(15);
        this.mTitleView.setLayoutParams(layoutParams2);
    }

    private void setButtonColor(View view, String str, String str2, String str3) {
        int i;
        int i2;
        int i3;
        if (view != null) {
            Drawable background = view.getBackground();
            if (background != null && (background instanceof NativeViewBackButtonDrawable)) {
                try {
                    i3 = Color.parseColor(str);
                } catch (Exception unused) {
                    i3 = PdrUtil.stringToColor(str);
                }
                NativeViewBackButtonDrawable nativeViewBackButtonDrawable = (NativeViewBackButtonDrawable) background;
                if (i3 != nativeViewBackButtonDrawable.getDrawableColor()) {
                    nativeViewBackButtonDrawable.setDrawableColor(i3);
                }
            }
            try {
                i = Color.parseColor(str2);
            } catch (Exception unused2) {
                i = PdrUtil.stringToColor(str2);
            }
            try {
                i2 = Color.parseColor(str3);
            } catch (Exception unused3) {
                i2 = PdrUtil.stringToColor(str3);
            }
            if ((view instanceof RelativeLayout) || (view instanceof BadgeRelateiveLayout)) {
                ViewGroup viewGroup = (ViewGroup) view;
                for (int i4 = 0; i4 < viewGroup.getChildCount(); i4++) {
                    TextView textView = (TextView) viewGroup.getChildAt(i4);
                    if (i != textView.getTextColors().getDefaultColor()) {
                        textView.setTextColor(createColorStateList(i, i2));
                    }
                }
            } else if (view instanceof TextView) {
                TextView textView2 = (TextView) view;
                if (i != textView2.getTextColors().getDefaultColor()) {
                    textView2.setTextColor(createColorStateList(i, i2));
                }
            } else if (view instanceof LinearLayout) {
                LinearLayout linearLayout = (LinearLayout) view;
                for (int i5 = 0; i5 < linearLayout.getChildCount(); i5++) {
                    View childAt = linearLayout.getChildAt(i5);
                    if (childAt instanceof TextView) {
                        TextView textView3 = (TextView) childAt;
                        if (i != textView3.getTextColors().getDefaultColor()) {
                            textView3.setTextColor(createColorStateList(i, i2));
                        }
                    } else if (childAt instanceof RelativeLayout) {
                        TextView textView4 = (TextView) ((RelativeLayout) childAt).getChildAt(0);
                        if (i != textView4.getTextColors().getDefaultColor()) {
                            textView4.setTextColor(createColorStateList(i, i2));
                        }
                    }
                }
            }
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void setTextAndFont(String str, String str2, String str3, TextView textView, boolean z) {
        Typeface typeface;
        String str4;
        if (z || str3.equals("none")) {
            textView.setText(str);
            if (this.mApp == null || this.mWebView == null || TextUtils.isEmpty(str2)) {
                typeface = null;
            } else {
                if (str2.contains("__wap2app.ttf")) {
                    str4 = BaseInfo.sBaseWap2AppTemplatePath + "wap2app__template/__wap2app.ttf";
                    if (!new File(str4).exists()) {
                        str4 = this.mWebView.obtainApp().convert2AbsFullPath(this.mWebView.obtainFullUrl(), str2);
                    }
                } else {
                    str4 = this.mWebView.obtainApp().convert2AbsFullPath(this.mWebView.obtainFullUrl(), str2);
                }
                typeface = NativeTypefaceFactory.getTypeface(this.mWebView.obtainApp(), str4);
            }
        } else {
            typeface = Typeface.createFromAsset(getContext().getAssets(), "fonts/dcloud_iconfont.ttf");
            str3.hashCode();
            char c = 65535;
            switch (str3.hashCode()) {
                case -677145915:
                    if (str3.equals("forward")) {
                        c = 0;
                        break;
                    }
                    break;
                case 3015911:
                    if (str3.equals("back")) {
                        c = 1;
                        break;
                    }
                    break;
                case 3208415:
                    if (str3.equals("home")) {
                        c = 2;
                        break;
                    }
                    break;
                case 3347807:
                    if (str3.equals(AbsoluteConst.EVENTS_MENU)) {
                        c = 3;
                        break;
                    }
                    break;
                case 94756344:
                    if (str3.equals(AbsoluteConst.EVENTS_CLOSE)) {
                        c = 4;
                        break;
                    }
                    break;
                case 109400031:
                    if (str3.equals("share")) {
                        c = 5;
                        break;
                    }
                    break;
                case 1050790300:
                    if (str3.equals("favorite")) {
                        c = 6;
                        break;
                    }
                    break;
            }
            switch (c) {
                case 0:
                    str = "";
                    break;
                case 1:
                    str = "";
                    break;
                case 2:
                    str = "";
                    break;
                case 3:
                    str = "";
                    break;
                case 4:
                    str = "";
                    break;
                case 5:
                    str = "";
                    break;
                case 6:
                    str = "";
                    break;
            }
            textView.setText(str);
        }
        if (typeface != null) {
            textView.setTypeface(typeface);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    /* JADX WARNING: Removed duplicated region for block: B:17:0x0036  */
    /* JADX WARNING: Removed duplicated region for block: B:21:0x0074  */
    private void setTextGravity(String str, String str2) {
        char c;
        int hashCode = str.hashCode();
        if (hashCode != -1364013995) {
            if (hashCode != 3317767) {
                if (hashCode == 108511772 && str.equals("right")) {
                    c = 1;
                    if (c != 0) {
                        this.searchInput.setGravity(GravityCompat.START);
                        this.searchInput.setHint(str2);
                        return;
                    } else if (c != 1) {
                        this.searchInput.setGravity(17);
                        EditText editText = this.searchInput;
                        editText.setHint(" " + str2);
                        return;
                    } else {
                        this.searchInput.setGravity(GravityCompat.END);
                        EditText editText2 = this.searchInput;
                        editText2.setHint(" " + str2);
                        return;
                    }
                }
            } else if (str.equals("left")) {
                c = 0;
                if (c != 0) {
                }
            }
        } else if (str.equals("center")) {
            c = 2;
            if (c != 0) {
            }
        }
        c = 65535;
        if (c != 0) {
        }
    }

    private void showCapsuleMenu(final JSONArray jSONArray) {
        a aVar;
        try {
            if (Build.VERSION.SDK_INT >= 21) {
                aVar = new a(this.mWebView.getActivity());
            } else {
                aVar = new a(this.mWebView.getActivity(), 16973837);
            }
            aVar.a(new a.b() {
                /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass15 */

                @Override // io.dcloud.feature.ui.nativeui.a.b
                public void initCancelText(TextView textView) {
                    TextPaint paint = textView.getPaint();
                    if (TitleNView.this.mMenuButtonFontWeight.equals(Constants.Value.BOLD)) {
                        paint.setFakeBoldText(true);
                    } else {
                        paint.setFakeBoldText(false);
                    }
                }

                @Override // io.dcloud.feature.ui.nativeui.a.b
                public void initTextItem(int i, TextView textView, String str) {
                    if (TitleNView.this.mMenuButtons.size() > i) {
                        ButtonDataItem buttonDataItem = (ButtonDataItem) TitleNView.this.mMenuButtons.get(i);
                        TitleNView.this.setTextAndFont(str, buttonDataItem.getFontSrc(), buttonDataItem.getFontType(), textView, TextUtils.isEmpty(buttonDataItem.getFontType()));
                    } else if (jSONArray.length() > i) {
                        if (jSONArray.optJSONObject(i).optString("type", "").equals("interval")) {
                            textView.setBackgroundDrawable(new ColorDrawable(Color.parseColor("#e5e5e5")));
                            textView.getLayoutParams().height = 10;
                            return;
                        }
                        textView.setText(str);
                    }
                    TextPaint paint = textView.getPaint();
                    if (TitleNView.this.mMenuButtonFontWeight.equals(Constants.Value.BOLD)) {
                        paint.setFakeBoldText(true);
                    } else {
                        paint.setFakeBoldText(false);
                    }
                    textView.setTextColor(TitleNView.this.mMenuButtonTextColor);
                }

                @Override // io.dcloud.feature.ui.nativeui.a.b
                public boolean onDismiss(int i) {
                    int i2 = i - 1;
                    if (i2 <= 0 || jSONArray.length() <= i2 || !jSONArray.optJSONObject(i2).optString("type", "").equals("interval")) {
                        return false;
                    }
                    return true;
                }

                @Override // io.dcloud.feature.ui.nativeui.a.b
                public void onItemClick(int i) {
                    int i2 = i - 1;
                    if (i2 >= 0) {
                        if (TitleNView.this.mMenuButtons.size() > i2) {
                            ButtonDataItem buttonDataItem = (ButtonDataItem) TitleNView.this.mMenuButtons.get(i2);
                            if (buttonDataItem != null) {
                                AbsMgr obtainWindowMgr = TitleNView.this.mWebView.obtainFrameView().obtainWindowMgr();
                                IMgr.MgrType mgrType = IMgr.MgrType.FeatureMgr;
                                IApp iApp = TitleNView.this.mApp;
                                Object processEvent = obtainWindowMgr.processEvent(mgrType, 10, new Object[]{iApp, AbsoluteConst.F_UI, "findWebview", new String[]{iApp.obtainAppId(), buttonDataItem.getWebviewUuid()}});
                                IWebview iWebview = null;
                                if (processEvent != null && (processEvent instanceof IWebview)) {
                                    iWebview = (IWebview) processEvent;
                                }
                                if (iWebview == null) {
                                    iWebview = TitleNView.this.mWebView;
                                }
                                TitleNView.this.buttonOnclick(buttonDataItem.getOnclick(), iWebview);
                            }
                        } else if (jSONArray.length() > i2) {
                            JSONObject optJSONObject = jSONArray.optJSONObject(i2);
                            if (!optJSONObject.optString("type", "").equals("interval") && optJSONObject.has("id")) {
                                String optString = optJSONObject.optString("id");
                                Bundle bundle = new Bundle();
                                bundle.putString("id", optString);
                                bundle.putString("appid", TitleNView.this.mWebView.obtainApp().obtainAppId());
                                IWebview iWebview2 = TitleNView.this.mWebView;
                                iWebview2.obtainFrameView().obtainWindowMgr().processEvent(IMgr.MgrType.WindowMgr, 77, new Object[]{iWebview2, bundle});
                            }
                        }
                    }
                }
            });
            aVar.b(getContext().getString(R.string.dcloud_common_cancel)).d(this.mMenuButtonTextColor).a(PdrUtil.parseFloat(this.mMenuButtonFontSize, 0.0f, 0.0f, 1.0f)).a(jSONArray).a(true).b(false).e(0);
            aVar.j();
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateCapsuleLayout() {
        CapsuleLayout capsuleLayout = this.mCapsuleLayout;
        if (capsuleLayout != null && !capsuleLayout.isDiy) {
            String backgroundColor = getBackgroundColor();
            if (!TextUtils.isEmpty(backgroundColor)) {
                if (this.mCapsuleLayout.checkColorToStyle(PdrUtil.stringToColor(backgroundColor)) == 1) {
                    this.closeBt.setTextColor(-16777216);
                    this.menuBt.setTextColor(-16777216);
                    return;
                }
                this.closeBt.setTextColor(-1);
                this.menuBt.setTextColor(-1);
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void addBackButton(String str, String str2, String str3, JSONObject jSONObject) {
        TextView textView;
        TextView textView2;
        TextView textView3;
        String str4;
        String str5;
        String str6;
        String str7;
        int i;
        int i2;
        initTitleNViewLayout();
        initLeftButtonLayout();
        BadgeLinearLayout badgeLinearLayout = this.mBackButton;
        boolean z = true;
        if (badgeLinearLayout == null) {
            BadgeLinearLayout badgeLinearLayout2 = new BadgeLinearLayout(this, getContext(), this.mCreateScale, this.redDotColor);
            this.mBackButton = badgeLinearLayout2;
            badgeLinearLayout2.setContentDescription(getResources().getString(R.string.dcloud_titlenview_back_button_description));
            this.mBackButton.setTag("TitleNView.BackButton");
            this.mBackButton.setGravity(17);
            textView3 = new TextView(getContext());
            textView3.setGravity(17);
            textView3.setId(View.generateViewId());
            textView3.setIncludeFontPadding(false);
            textView2 = new TextView(getContext());
            textView2.setGravity(17);
            textView2.setIncludeFontPadding(false);
            textView = new TextView(getContext());
            textView.setGravity(17);
            textView.setIncludeFontPadding(false);
            textView.setTextColor(-1);
            textView.setVisibility(8);
            RelativeLayout relativeLayout = new RelativeLayout(getContext());
            relativeLayout.setGravity(16);
            this.mBackButton.addView(textView3, new LinearLayout.LayoutParams(-2, 500));
            this.mBackButton.addView(relativeLayout, new LinearLayout.LayoutParams(-2, -1));
            relativeLayout.addView(textView2, new RelativeLayout.LayoutParams(-2, -1));
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(15);
            relativeLayout.addView(textView, layoutParams);
        } else {
            textView3 = (TextView) badgeLinearLayout.getChildAt(0);
            RelativeLayout relativeLayout2 = (RelativeLayout) this.mBackButton.getChildAt(1);
            textView2 = (TextView) relativeLayout2.getChildAt(0);
            textView = (TextView) relativeLayout2.getChildAt(1);
        }
        IFrameView iFrameView = this.mFrameViewParent;
        if (iFrameView == null || 5 != iFrameView.getFrameType()) {
            textView3.setText((jSONObject == null || !jSONObject.has("text")) ? "" : jSONObject.optString("text"));
        } else {
            textView3.setText((jSONObject == null || !jSONObject.has("text")) ? "" : jSONObject.optString("text"));
        }
        textView3.setTypeface(Typeface.createFromAsset(getContext().getAssets(), "fonts/dcloud_iconfont.ttf"));
        textView2.setText((jSONObject == null || !jSONObject.has(AbsoluteConst.JSON_KEY_TITLE)) ? "" : jSONObject.optString(AbsoluteConst.JSON_KEY_TITLE));
        this.mBackButton.setOnClickListener(new View.OnClickListener() {
            /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass3 */

            public void onClick(View view) {
                Activity activity;
                IApp iApp = TitleNView.this.mApp;
                if (iApp != null && (activity = iApp.getActivity()) != null) {
                    activity.onBackPressed();
                }
            }
        });
        String str8 = "16px";
        if ("transparent".equals(str3)) {
            textView3.getPaint().setTextSize((float) PdrUtil.convertToScreenInt((jSONObject == null || !jSONObject.has(Constants.Name.FONT_SIZE)) ? "22px" : jSONObject.optString(Constants.Name.FONT_SIZE), this.mInnerWidth, 0, this.mCreateScale));
            textView2.getPaint().setTextSize((float) PdrUtil.convertToScreenInt((jSONObject == null || !jSONObject.has("titleSize")) ? str8 : jSONObject.optString("titleSize"), this.mInnerWidth, 0, this.mCreateScale));
            IFrameView iFrameView2 = this.mFrameViewParent;
            if (iFrameView2 == null || 5 != iFrameView2.getFrameType()) {
                this.mBackButton.setPadding(0, 0, PdrUtil.convertToScreenInt("2px", this.mInnerWidth, 0, this.mCreateScale), 0);
            } else {
                this.mBackButton.setPadding(0, 0, 0, 0);
            }
            NativeViewBackButtonDrawable nativeViewBackButtonDrawable = new NativeViewBackButtonDrawable(PdrUtil.stringToColor((jSONObject == null || !jSONObject.has("background")) ? TitleNViewUtil.TRANSPARENT_BUTTON_BACKGROUND_COLOR : jSONObject.optString("background")));
            nativeViewBackButtonDrawable.setWidth("backButton");
            this.mBackButton.setBackground(nativeViewBackButtonDrawable);
            str5 = TitleNViewUtil.TRANSPARENT_BUTTON_TEXT_COLOR;
            str4 = TitleNViewUtil.changeColorAlpha(str5, 0.3f);
        } else {
            textView3.getPaint().setTextSize((float) PdrUtil.convertToScreenInt((jSONObject == null || !jSONObject.has(Constants.Name.FONT_SIZE)) ? "27px" : jSONObject.optString(Constants.Name.FONT_SIZE), this.mInnerWidth, 0, this.mCreateScale));
            textView2.getPaint().setTextSize((float) PdrUtil.convertToScreenInt((jSONObject == null || !jSONObject.has("titleSize")) ? str8 : jSONObject.optString("titleSize"), this.mInnerWidth, 0, this.mCreateScale));
            str5 = str;
            str4 = str2;
        }
        if (jSONObject != null && jSONObject.has("badgeSize")) {
            str8 = jSONObject.optString("badgeSize");
        }
        int convertToScreenInt = PdrUtil.convertToScreenInt(str8, this.mInnerWidth, 0, this.mCreateScale);
        textView.getPaint().setTextSize((float) convertToScreenInt);
        ViewGroup.LayoutParams layoutParams2 = textView.getLayoutParams();
        layoutParams2.height = PdrUtil.convertToScreenInt("2px", this.mInnerWidth, 0, this.mCreateScale) + convertToScreenInt;
        textView.setLayoutParams(layoutParams2);
        textView.setMinWidth(layoutParams2.height);
        int i3 = convertToScreenInt / 4;
        textView.setPadding(i3, getPaddingTop(), i3, getPaddingBottom());
        if (jSONObject == null || !jSONObject.has(Constants.Name.FONT_WEIGHT)) {
            str6 = "normal";
        } else {
            str6 = jSONObject.optString(Constants.Name.FONT_WEIGHT);
        }
        if (str6.equals("normal")) {
            textView3.getPaint().setFakeBoldText(false);
        } else if (str6.equals(Constants.Value.BOLD)) {
            textView3.getPaint().setFakeBoldText(true);
        }
        if (jSONObject == null || !jSONObject.has("titleWeight")) {
            str7 = "normal";
        } else {
            str7 = jSONObject.optString("titleWeight");
        }
        if (str7.equals("normal")) {
            textView2.getPaint().setFakeBoldText(false);
        } else if (str7.equals(Constants.Value.BOLD)) {
            textView2.getPaint().setFakeBoldText(true);
        }
        String str9 = null;
        String optString = (jSONObject == null || !jSONObject.has("badgeText")) ? null : jSONObject.optString("badgeText");
        this.mBackButton.setBadgeStr(optString);
        BadgeLinearLayout badgeLinearLayout3 = this.mBackButton;
        if (jSONObject == null || !jSONObject.has("redDot") || !jSONObject.optBoolean("redDot")) {
            z = false;
        }
        badgeLinearLayout3.setDrawRedDot(z);
        if (!PdrUtil.isEmpty(optString)) {
            textView.setText(optString, TextView.BufferType.SPANNABLE);
            textView.setVisibility(0);
        } else {
            textView.setVisibility(8);
        }
        String optString2 = (jSONObject == null || !jSONObject.has("badgeBackground")) ? null : jSONObject.optString("badgeBackground");
        if (jSONObject != null && jSONObject.has("badgeColor")) {
            str9 = jSONObject.optString("badgeColor");
        }
        GradientDrawable gradientDrawable = new GradientDrawable();
        if (!PdrUtil.isEmpty(optString2)) {
            gradientDrawable.setColor(PdrUtil.stringToColor(optString2));
        } else {
            gradientDrawable.setColor(-65536);
        }
        gradientDrawable.setCornerRadius((float) (layoutParams2.height / 2));
        textView.setBackground(gradientDrawable);
        if (!PdrUtil.isEmpty(str9)) {
            textView.setTextColor(PdrUtil.stringToColor(str9));
        }
        try {
            i = Color.parseColor(str5);
        } catch (Exception unused) {
            i = PdrUtil.stringToColor(str5);
        }
        try {
            i2 = Color.parseColor(str4);
        } catch (Exception unused2) {
            i2 = PdrUtil.stringToColor(str4);
        }
        textView3.setTextColor(createColorStateList(i, i2));
        textView2.setTextColor(createColorStateList(i, i2));
        if (this.mBackButton.getParent() != null) {
            ((ViewGroup) this.mBackButton.getParent()).removeView(this.mBackButton);
        }
        if (-1 == this.mLeftButtonLayout.indexOfChild(this.mBackButton)) {
            int convertToScreenInt2 = this.mInnerHeight - PdrUtil.convertToScreenInt("12px", this.mAppScreenWidth, 0, this.mCreateScale);
            LinearLayout.LayoutParams layoutParams3 = new LinearLayout.LayoutParams(-2, convertToScreenInt2);
            layoutParams3.leftMargin = PdrUtil.convertToScreenInt("5px", this.mAppScreenWidth, 0, this.mCreateScale);
            this.mBackButton.setMinimumWidth(convertToScreenInt2);
            this.mLeftButtonLayout.addView(this.mBackButton, 0, layoutParams3);
        }
        this.mBackButton.setVisibility(0);
        requestLayout();
        caculateTitleMargin();
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void addHomeButton(String str, String str2, String str3) {
        int i;
        int i2;
        initTitleNViewLayout();
        initLeftButtonLayout();
        initRightButtonLayout();
        if (this.mHomeButton == null) {
            TextView textView = new TextView(getContext());
            this.mHomeButton = textView;
            textView.setGravity(17);
            this.mHomeButton.setTag("TitleNView.HomeButton");
            this.mHomeButton.setTypeface(Typeface.createFromAsset(getContext().getAssets(), "fonts/dcloud_iconfont.ttf"));
            this.mHomeButton.setText("");
            this.mHomeButton.setIncludeFontPadding(false);
            this.mHomeButton.setOnClickListener(new View.OnClickListener() {
                /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass4 */

                public void onClick(View view) {
                    IApp iApp = TitleNView.this.mApp;
                    if (iApp != null && iApp.getActivity() != null) {
                        TitleNView.this.mFrameViewParent.obtainWebAppRootView().goHome(TitleNView.this.mFrameViewParent);
                    }
                }
            });
            if ("transparent".equals(str3)) {
                this.mHomeButton.getPaint().setTextSize((float) PdrUtil.convertToScreenInt("22px", this.mInnerWidth, 0, this.mCreateScale));
                NativeViewBackButtonDrawable nativeViewBackButtonDrawable = new NativeViewBackButtonDrawable(Color.parseColor(TitleNViewUtil.TRANSPARENT_BUTTON_BACKGROUND_COLOR));
                nativeViewBackButtonDrawable.setWidth("");
                this.mHomeButton.setBackground(nativeViewBackButtonDrawable);
                str = TitleNViewUtil.TRANSPARENT_BUTTON_TEXT_COLOR;
                str2 = TitleNViewUtil.changeColorAlpha(str, 0.3f);
            } else {
                this.mHomeButton.getPaint().setTextSize((float) PdrUtil.convertToScreenInt("27px", this.mInnerWidth, 0, this.mCreateScale));
            }
            try {
                i = Color.parseColor(str);
            } catch (Exception unused) {
                i = PdrUtil.stringToColor(str);
            }
            try {
                i2 = Color.parseColor(str2);
            } catch (Exception unused2) {
                i2 = PdrUtil.stringToColor(str2);
            }
            this.mHomeButton.setTextColor(createColorStateList(i, i2));
        }
        int convertToScreenInt = this.mInnerHeight - PdrUtil.convertToScreenInt("12px", this.mAppScreenWidth, 0, this.mCreateScale);
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(convertToScreenInt, convertToScreenInt);
        if (this.mHomeButton.getParent() != null) {
            ((ViewGroup) this.mHomeButton.getParent()).removeView(this.mHomeButton);
        }
        if (this.mRightButtonLayout.getChildCount() == 0) {
            layoutParams.rightMargin = PdrUtil.convertToScreenInt("5px", this.mAppScreenWidth, 0, this.mCreateScale);
            this.mRightButtonLayout.addView(this.mHomeButton, 0, layoutParams);
        } else if (this.mRightButtonLayout.getChildCount() == 1 && -1 == this.mRightButtonLayout.indexOfChild(this.mHomeButton)) {
            layoutParams.rightMargin = PdrUtil.convertToScreenInt("5px", this.mAppScreenWidth, 0, this.mCreateScale);
            this.mRightButtonLayout.addView(this.mHomeButton, 0, layoutParams);
        } else if (this.mRightButtonLayout.getChildCount() == 2 && -1 == this.mRightButtonLayout.indexOfChild(this.mHomeButton)) {
            if (this.mLeftButtonLayout.getChildCount() == 1 && this.mBackButton != null && -1 == this.mLeftButtonLayout.indexOfChild(this.mHomeButton)) {
                layoutParams.leftMargin = PdrUtil.convertToScreenInt("5px", this.mAppScreenWidth, 0, this.mCreateScale);
                this.mLeftButtonLayout.addView(this.mHomeButton, 1, layoutParams);
            } else if (this.mLeftButtonLayout.getChildCount() == 2 && -1 == this.mLeftButtonLayout.indexOfChild(this.mHomeButton)) {
                LinearLayout linearLayout = this.mLeftButtonLayout;
                linearLayout.removeView(linearLayout.getChildAt(1));
                layoutParams.leftMargin = PdrUtil.convertToScreenInt("5px", this.mAppScreenWidth, 0, this.mCreateScale);
                this.mLeftButtonLayout.addView(this.mHomeButton, 1, layoutParams);
            }
        }
        this.mHomeButton.setVisibility(0);
        requestLayout();
        caculateTitleMargin();
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void addLeftButton(String str, String str2, String str3, String str4, String str5, String str6, String str7, String str8, String str9, String str10, IWebview iWebview, String str11, String str12, boolean z, String str13, boolean z2, String str14) {
        int i;
        View createButton = createButton(str, str3, str4, str5, str6, str7, str8, str10, iWebview, str11, str12, z, str13, z2, str14, str9);
        initTitleNViewLayout();
        initLeftButtonLayout();
        if (-1 == this.mLeftButtonLayout.indexOfChild(createButton)) {
            int convertToScreenInt = this.mInnerHeight - PdrUtil.convertToScreenInt("12px", this.mAppScreenWidth, 0, this.mCreateScale);
            int convertToScreenInt2 = PdrUtil.convertToScreenInt(str14, this.mAppScreenWidth, -1, this.mCreateScale);
            int convertToScreenInt3 = PdrUtil.convertToScreenInt(str9, this.mAppScreenWidth, -1, this.mCreateScale);
            String str15 = "5px";
            if (convertToScreenInt2 <= 0 || convertToScreenInt3 <= convertToScreenInt2) {
                if (PdrUtil.isEmpty(str9)) {
                    i = convertToScreenInt;
                } else if (!str9.equals("auto")) {
                    i = PdrUtil.convertToScreenInt(str9, this.mAppScreenWidth, convertToScreenInt, this.mCreateScale);
                    str15 = "0px";
                }
                int convertToScreenInt4 = PdrUtil.convertToScreenInt(str15, this.mAppScreenWidth, 0, this.mCreateScale);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(i, convertToScreenInt);
                layoutParams.leftMargin = convertToScreenInt4;
                this.mLeftButtonLayout.addView(createButton, layoutParams);
                if (!PdrUtil.isEmpty(str9) && str9.equals("auto") && z2) {
                    createButton.setPadding(convertToScreenInt4, createButton.getPaddingTop(), convertToScreenInt4, createButton.getPaddingBottom());
                }
            }
            i = -2;
            int convertToScreenInt42 = PdrUtil.convertToScreenInt(str15, this.mAppScreenWidth, 0, this.mCreateScale);
            LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(i, convertToScreenInt);
            layoutParams2.leftMargin = convertToScreenInt42;
            this.mLeftButtonLayout.addView(createButton, layoutParams2);
            createButton.setPadding(convertToScreenInt42, createButton.getPaddingTop(), convertToScreenInt42, createButton.getPaddingBottom());
        }
        caculateTitleMargin();
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void addRightButton(String str, String str2, String str3, String str4, String str5, String str6, String str7, String str8, String str9, String str10, IWebview iWebview, String str11, String str12, boolean z, String str13, boolean z2, String str14) {
        int i;
        initTitleNViewLayout();
        initRightButtonLayout();
        if ((this.maxButton <= 2 || this.mRightButtonLayout.getChildCount() > this.maxButton - 2) && this.mMenuButtons != null) {
            String str15 = null;
            if (iWebview != null) {
                str15 = iWebview.getWebviewUUID();
            }
            ButtonDataItem buttonDataItem = new ButtonDataItem(str, str2, str15, str7, str8, str10);
            this.mMenuButtons.add(buttonDataItem);
            this.mButtons.add(buttonDataItem);
            return;
        }
        View createButton = createButton(str, str3, str4, str5, str6, str7, str8, str10, iWebview, str11, str12, z, str13, z2, str14, str9);
        if (-1 == this.mRightButtonLayout.indexOfChild(createButton)) {
            int convertToScreenInt = this.mInnerHeight - PdrUtil.convertToScreenInt("12px", this.mAppScreenWidth, 0, this.mCreateScale);
            int convertToScreenInt2 = PdrUtil.convertToScreenInt(str14, this.mAppScreenWidth, -1, this.mCreateScale);
            int convertToScreenInt3 = PdrUtil.convertToScreenInt(str9, this.mAppScreenWidth, -1, this.mCreateScale);
            String str16 = "5px";
            if (convertToScreenInt2 <= 0 || convertToScreenInt3 <= convertToScreenInt2) {
                if (PdrUtil.isEmpty(str9)) {
                    i = convertToScreenInt;
                } else if (!str9.equals("auto")) {
                    i = PdrUtil.convertToScreenInt(str9, this.mAppScreenWidth, convertToScreenInt, this.mCreateScale);
                    str16 = "0px";
                }
                int convertToScreenInt4 = PdrUtil.convertToScreenInt(str16, this.mAppScreenWidth, 0, this.mCreateScale);
                LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(i, convertToScreenInt);
                layoutParams.rightMargin = convertToScreenInt4;
                this.mRightButtonLayout.addView(createButton, 0, layoutParams);
                if (!PdrUtil.isEmpty(str9) && str9.equals("auto") && z2) {
                    createButton.setPadding(convertToScreenInt4, createButton.getPaddingTop(), convertToScreenInt4, createButton.getPaddingBottom());
                }
            }
            i = -2;
            int convertToScreenInt42 = PdrUtil.convertToScreenInt(str16, this.mAppScreenWidth, 0, this.mCreateScale);
            LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(i, convertToScreenInt);
            layoutParams2.rightMargin = convertToScreenInt42;
            this.mRightButtonLayout.addView(createButton, 0, layoutParams2);
            createButton.setPadding(convertToScreenInt42, createButton.getPaddingTop(), convertToScreenInt42, createButton.getPaddingBottom());
        }
        caculateTitleMargin();
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void addSearchInput(final String str, String str2, String str3, String str4, String str5, String str6, boolean z, final boolean z2, final IWebview iWebview) {
        boolean z3;
        final TextView textView;
        int i;
        int i2;
        int i3;
        int i4;
        initTitleNViewLayout();
        initLeftButtonLayout();
        initRightButtonLayout();
        initCenterSearchLayout();
        RelativeLayout relativeLayout = this.mTitlelayout;
        if (relativeLayout != null) {
            relativeLayout.setVisibility(4);
        }
        Typeface createFromAsset = Typeface.createFromAsset(getContext().getAssets(), "fonts/dcloud_iconfont.ttf");
        int convertToScreenInt = PdrUtil.convertToScreenInt("13px", this.mInnerWidth, 0, this.mCreateScale);
        int convertToScreenInt2 = PdrUtil.convertToScreenInt("8px", this.mAppScreenWidth, 0, this.mCreateScale);
        if (this.searchInput == null) {
            TextView textView2 = new TextView(getContext());
            textView2.setGravity(17);
            textView2.setTypeface(createFromAsset);
            textView2.setText(" ");
            textView2.setIncludeFontPadding(false);
            float f = (float) convertToScreenInt;
            textView2.getPaint().setTextSize(f);
            LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -1);
            layoutParams.leftMargin = convertToScreenInt2;
            this.centerSearchLayout.addView(textView2, layoutParams);
            EditText editText = new EditText(getContext());
            this.searchInput = editText;
            editText.setTag("TitleNView.SearchInput");
            int i5 = convertToScreenInt2 / 2;
            this.searchInput.setPadding(0, i5, 0, i5);
            this.searchInput.setPaddingRelative(0, i5, 0, i5);
            this.searchInput.setIncludeFontPadding(false);
            this.searchInput.setGravity(17);
            this.searchInput.setSingleLine();
            this.searchInput.setLines(1);
            this.searchInput.setTypeface(createFromAsset);
            this.searchInput.setImeOptions(3);
            this.searchInput.getPaint().setTextSize(f);
            this.searchInput.setLayoutParams(new LinearLayout.LayoutParams(-1, -2));
            z3 = true;
        } else {
            z3 = false;
        }
        initTitleNViewLayout();
        if (this.searchInput.getParent() != null) {
            ((ViewGroup) this.searchInput.getParent()).removeView(this.searchInput);
        }
        if (-1 == this.centerSearchLayout.indexOfChild(this.searchInput)) {
            this.centerSearchLayout.addView(this.searchInput, 1, new LinearLayout.LayoutParams(-1, -2, 1.0f));
        }
        final TextView textView3 = this.centerSearchLayout.getChildAt(0) instanceof TextView ? (TextView) this.centerSearchLayout.getChildAt(0) : null;
        if (textView3 != null) {
            if (str.equalsIgnoreCase("left")) {
                textView3.setVisibility(0);
            } else if (this.searchInput.getText() == null || this.searchInput.getText().toString().length() <= 0) {
                textView3.setVisibility(8);
            } else {
                textView3.setVisibility(0);
            }
        }
        if (this.centerSearchLayout.getChildCount() > 2) {
            textView = (TextView) this.centerSearchLayout.getChildAt(2);
        } else {
            TextView textView4 = new TextView(getContext());
            textView4.setGravity(17);
            textView4.setTypeface(createFromAsset);
            textView4.setText("");
            textView4.setTextColor(-1);
            textView4.setTextSize(0, (float) convertToScreenInt);
            textView4.setIncludeFontPadding(false);
            textView4.getPaint().setFakeBoldText(true);
            GradientDrawable gradientDrawable = new GradientDrawable();
            gradientDrawable.setCornerRadius(100.0f);
            gradientDrawable.setColor(-4802890);
            textView4.setBackground(gradientDrawable);
            int i6 = convertToScreenInt2 / 4;
            textView4.setPadding(i6, i6, i6, i6);
            LinearLayout.LayoutParams layoutParams2 = new LinearLayout.LayoutParams(-2, -2);
            layoutParams2.rightMargin = convertToScreenInt2;
            this.centerSearchLayout.addView(textView4, 2, layoutParams2);
            textView4.setOnClickListener(new View.OnClickListener() {
                /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass5 */

                public void onClick(View view) {
                    TitleNView.this.searchInput.setText("");
                }
            });
            textView4.setVisibility(8);
            textView = textView4;
        }
        if (PdrUtil.isEmpty(str2)) {
            i = Color.parseColor("#8fffffff");
        } else {
            try {
                i = Color.parseColor(str2);
            } catch (Exception unused) {
                i = PdrUtil.stringToColor(str2);
            }
        }
        if (PdrUtil.isEmpty(str3)) {
            i2 = 0;
        } else {
            i2 = PdrUtil.convertToScreenInt(str3, this.mInnerWidth, 0, this.mCreateScale);
        }
        final String str7 = !PdrUtil.isEmpty(str4) ? str4 : "";
        this.searchInput.setHint(" " + str7);
        if (PdrUtil.isEmpty(str5)) {
            i3 = Color.parseColor("#CCCCCC");
        } else {
            try {
                i3 = Color.parseColor(str5);
            } catch (Exception unused2) {
                i3 = PdrUtil.stringToColor(str5);
            }
        }
        if (textView3 != null) {
            textView3.setTextColor(i3);
        }
        this.searchInput.setHintTextColor(i3);
        this.searchInput.setEllipsize(TextUtils.TruncateAt.END);
        this.searchInput.setBackground(null);
        this.centerSearchLayout.setBackground(new SearchInputDrawable(i, i2));
        if (PdrUtil.isEmpty(str6)) {
            i4 = -16777216;
        } else {
            try {
                i4 = Color.parseColor(str6);
            } catch (Exception unused3) {
                i4 = PdrUtil.stringToColor(str6);
            }
        }
        this.searchInput.setTextColor(i4);
        if (z3) {
            this.searchInput.addTextChangedListener(new TextWatcher() {
                /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass6 */

                public void afterTextChanged(Editable editable) {
                }

                public void beforeTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                }

                public void onTextChanged(CharSequence charSequence, int i, int i2, int i3) {
                    if (charSequence.toString().length() > 0) {
                        textView.setVisibility(0);
                    } else {
                        textView.setVisibility(8);
                    }
                    String jsResponseText = JSUtil.toJsResponseText(charSequence.toString());
                    IWebview iWebview = TitleNView.this.mWebView;
                    if (iWebview == null || iWebview.obtainFrameView() == null || !(TitleNView.this.mWebView.obtainFrameView() instanceof AdaFrameView)) {
                        IWebview iWebview2 = iWebview;
                        if (iWebview2 != null && iWebview2.obtainFrameView() != null && (iWebview.obtainFrameView() instanceof AdaFrameView)) {
                            ((AdaFrameView) iWebview.obtainFrameView()).dispatchFrameViewEvents(AbsoluteConst.EVENT_TITLENVIEW_SEARCHINPUT_CHANGED, StringUtil.format("{text:\"%s\"}", jsResponseText));
                            return;
                        }
                        return;
                    }
                    ((AdaFrameView) TitleNView.this.mWebView.obtainFrameView()).dispatchFrameViewEvents(AbsoluteConst.EVENT_TITLENVIEW_SEARCHINPUT_CHANGED, StringUtil.format("{text:\"%s\"}", jsResponseText));
                }
            });
        }
        this.searchInput.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass7 */

            public void onFocusChange(View view, boolean z) {
                if (!TitleNView.this.isSetText.get()) {
                    IWebview iWebview = TitleNView.this.mWebView;
                    if (!(iWebview == null || iWebview.obtainFrameView() == null || !(TitleNView.this.mWebView.obtainFrameView() instanceof AdaFrameView))) {
                        ((AdaFrameView) TitleNView.this.mWebView.obtainFrameView()).dispatchFrameViewEvents(AbsoluteConst.EVENT_TITLENVIEW_SEARCHINPUT_FOCUSCHANGED, StringUtil.format("{focus:%b}", Boolean.valueOf(z)));
                    }
                    IWebview iWebview2 = iWebview;
                    if (!(iWebview2 == null || iWebview2.obtainFrameView() == null || !(iWebview.obtainFrameView() instanceof AdaFrameView))) {
                        ((AdaFrameView) iWebview.obtainFrameView()).dispatchFrameViewEvents(AbsoluteConst.EVENT_TITLENVIEW_SEARCHINPUT_FOCUSCHANGED, StringUtil.format("{focus:%b}", Boolean.valueOf(z)));
                    }
                }
                if (z) {
                    TitleNView.this.searchInput.setGravity(3);
                    textView3.setVisibility(0);
                    TitleNView.this.searchInput.setHint(str7);
                } else if (TitleNView.this.searchInput.getText().toString().length() < 1) {
                    TitleNView.this.setTextGravity(str, str7);
                    if (str.equalsIgnoreCase("left")) {
                        textView3.setVisibility(0);
                    } else {
                        textView3.setVisibility(8);
                    }
                }
            }
        });
        this.searchInput.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass8 */

            public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
                if (i == 3) {
                    String jsResponseText = JSUtil.toJsResponseText(textView.getText().toString());
                    IWebview iWebview = TitleNView.this.mWebView;
                    if (iWebview == null || iWebview.obtainFrameView() == null || !(TitleNView.this.mWebView.obtainFrameView() instanceof AdaFrameView)) {
                        IWebview iWebview2 = iWebview;
                        if (!(iWebview2 == null || iWebview2.obtainFrameView() == null || !(iWebview.obtainFrameView() instanceof AdaFrameView))) {
                            ((AdaFrameView) iWebview.obtainFrameView()).dispatchFrameViewEvents(AbsoluteConst.EVENT_TITLENVIEW_SEARCHINPUT_CONFIRMED, StringUtil.format("{text:\"%s\"}", jsResponseText));
                        }
                    } else {
                        ((AdaFrameView) TitleNView.this.mWebView.obtainFrameView()).dispatchFrameViewEvents(AbsoluteConst.EVENT_TITLENVIEW_SEARCHINPUT_CONFIRMED, StringUtil.format("{text:\"%s\"}", jsResponseText));
                        return true;
                    }
                }
                return false;
            }
        });
        if (this.searchInput.getText() == null || this.searchInput.getText().toString().length() < 1) {
            setTextGravity(str, str7);
        }
        boolean z4 = !z;
        this.searchInput.setCursorVisible(z4);
        this.searchInput.setFocusable(z4);
        this.searchInput.setFocusableInTouchMode(z4);
        final IWebview iWebview2 = this.mWebView;
        if (iWebview2 == null) {
            iWebview2 = iWebview;
        }
        try {
            final boolean didCloseSplash = ((IWebAppRootView) ((AdaFrameView) iWebview2.obtainFrameView()).getParent()).didCloseSplash();
            if (!didCloseSplash) {
                iWebview2.obtainApp().registerSysEventListener(new ISysEventListener() {
                    /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass9 */

                    @Override // io.dcloud.common.DHInterface.ISysEventListener
                    public boolean onExecute(ISysEventListener.SysEventType sysEventType, Object obj) {
                        ISysEventListener.SysEventType sysEventType2;
                        if (z2 && sysEventType == (sysEventType2 = ISysEventListener.SysEventType.onSplashclosed)) {
                            TitleNView.this.searchInput.requestFocus();
                            if (!DeviceInfo.isIMEShow) {
                                DeviceInfo.showIME(TitleNView.this.searchInput);
                            }
                            iWebview2.obtainApp().unregisterSysEventListener(this, sysEventType2);
                        }
                        if (z2) {
                            return false;
                        }
                        DeviceInfo.hideIME(TitleNView.this.searchInput);
                        return false;
                    }
                }, ISysEventListener.SysEventType.onSplashclosed);
            }
            iWebview2.obtainFrameView().addFrameViewListener(new IEventCallback() {
                /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass10 */

                @Override // io.dcloud.common.DHInterface.IEventCallback
                public Object onCallBack(String str, Object obj) {
                    if (!AbsoluteConst.EVENTS_SHOW_ANIMATION_END.equalsIgnoreCase(str) || !z2 || !didCloseSplash) {
                        return null;
                    }
                    TitleNView.this.searchInput.requestFocus();
                    if (!DeviceInfo.isIMEShow) {
                        DeviceInfo.showIME(TitleNView.this.searchInput);
                    }
                    iWebview2.obtainFrameView().removeFrameViewListener(this);
                    return null;
                }
            });
        } catch (Exception unused4) {
        }
        if (!z2) {
            DeviceInfo.hideIME(this.searchInput);
        }
        if (z) {
            this.searchInput.setOnClickListener(new View.OnClickListener() {
                /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass11 */

                public void onClick(View view) {
                    IWebview iWebview = TitleNView.this.mWebView;
                    if (iWebview == null || iWebview.obtainFrameView() == null || !(TitleNView.this.mWebView.obtainFrameView() instanceof AdaFrameView)) {
                        IWebview iWebview2 = iWebview;
                        if (iWebview2 != null && iWebview2.obtainFrameView() != null && (iWebview.obtainFrameView() instanceof AdaFrameView)) {
                            ((AdaFrameView) iWebview.obtainFrameView()).dispatchFrameViewEvents(AbsoluteConst.EVENT_TITLENVIEW_SEARCHINPUT_CLICKED, String.format(Operators.SPACE_STR, new Object[0]));
                            return;
                        }
                        return;
                    }
                    ((AdaFrameView) TitleNView.this.mWebView.obtainFrameView()).dispatchFrameViewEvents(AbsoluteConst.EVENT_TITLENVIEW_SEARCHINPUT_CLICKED, String.format(Operators.SPACE_STR, new Object[0]));
                }
            });
        }
        this.searchInput.setVisibility(0);
        requestLayout();
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void clearButtons() {
        LinearLayout linearLayout = this.mRightButtonLayout;
        if (linearLayout != null) {
            linearLayout.removeAllViews();
        }
        LinearLayout linearLayout2 = this.mLeftButtonLayout;
        if (linearLayout2 != null) {
            linearLayout2.removeAllViews();
        }
        ArrayList<ButtonDataItem> arrayList = this.mMenuButtons;
        if (arrayList != null) {
            arrayList.clear();
        }
        ArrayList<Object> arrayList2 = this.mButtons;
        if (arrayList2 != null) {
            arrayList2.clear();
        }
    }

    @Override // io.dcloud.feature.nativeObj.NativeView
    public void clearNativeViewData() {
        IFrameView iFrameView = this.mFrameViewParent;
        if (iFrameView != null && (iFrameView instanceof AdaFrameView)) {
            ((AdaFrameView) iFrameView).removeNativeViewChild(this);
        }
        postDelayed(new Runnable() {
            /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass2 */

            public void run() {
                try {
                    TitleNView.this.setVisibility(8);
                    if (TitleNView.this.getParent() != null) {
                        ((ViewGroup) TitleNView.this.getParent()).removeView(TitleNView.this);
                    }
                    TitleNView.this.clearViewData();
                    if (TitleNView.this.mButtons != null) {
                        Iterator it = TitleNView.this.mButtons.iterator();
                        while (it.hasNext()) {
                            Object next = it.next();
                            if (next instanceof BadgeRelateiveLayout) {
                                View view = (View) next;
                                if (view.getBackground() != null) {
                                    view.getBackground().setCallback(null);
                                }
                            }
                        }
                        TitleNView.this.mButtons.clear();
                    }
                    TitleNView.this.mFrameViewParent = null;
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, (long) 200);
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void clearSearchInput() {
        LinearLayout linearLayout = this.centerSearchLayout;
        if (linearLayout != null && this.mTitleNViewLayout != null) {
            linearLayout.removeAllViews();
            this.mTitleNViewLayout.removeView(this.centerSearchLayout);
            this.centerSearchLayout = null;
            this.searchInput = null;
            RelativeLayout relativeLayout = this.mTitlelayout;
            if (relativeLayout != null) {
                relativeLayout.setVisibility(0);
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public String getBackgroundColor() {
        return getStyleBackgroundColor();
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public String getStatusBarColor() {
        JSONObject optJSONObject;
        int i;
        if (!this.isImmersed) {
            return "{color:-1,alpha:true}";
        }
        if (!this.mStyle.has(AbsoluteConst.JSONKEY_STATUSBAR) || (optJSONObject = this.mStyle.optJSONObject(AbsoluteConst.JSONKEY_STATUSBAR)) == null || !optJSONObject.has("backgroundnoalpha")) {
            View view = this.mStatusbarView;
            if (view != null) {
                Drawable background = view.getBackground();
                if (!(background instanceof ColorDrawable)) {
                    return "{color:-1,alpha:true}";
                }
                int color = ((ColorDrawable) background).getColor();
                return "{color:" + color + ",alpha:true}";
            }
            ViewParent parent = getParent();
            if (!TextUtils.equals(this.mStyle.optString("position", AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE), AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE) || parent == null || !(parent instanceof ViewGroup)) {
                return "{color:-1,alpha:true}";
            }
            int i2 = 0;
            while (true) {
                ViewGroup viewGroup = (ViewGroup) parent;
                if (i2 >= viewGroup.getChildCount()) {
                    return "{color:-1,alpha:true}";
                }
                Object tag = viewGroup.getChildAt(i2).getTag();
                if (tag != null && "StatusBar".equalsIgnoreCase(tag.toString())) {
                    Drawable background2 = viewGroup.getChildAt(i2).getBackground();
                    if (background2 instanceof ColorDrawable) {
                        int color2 = ((ColorDrawable) background2).getColor();
                        return "{color:" + color2 + ",alpha:true}";
                    }
                }
                i2++;
            }
        } else {
            String optString = optJSONObject.optString("backgroundnoalpha");
            try {
                i = Color.parseColor(optString);
            } catch (Exception unused) {
                i = PdrUtil.stringToColor(optString);
            }
            return "{color:" + i + ",alpha:false}";
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public int getTitleColor() {
        return this.mTitleView.getTextColors().getDefaultColor();
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public String getTitleNViewSearchInputText() {
        EditText editText = this.searchInput;
        return editText != null ? editText.getText().toString() : "";
    }

    @Override // io.dcloud.common.DHInterface.INativeView, io.dcloud.feature.nativeObj.NativeView
    public String getViewType() {
        return AbsoluteConst.NATIVE_TITLE_N_VIEW;
    }

    /* access modifiers changed from: protected */
    @Override // io.dcloud.feature.nativeObj.NativeView
    public void init() {
        View view;
        super.init();
        if (this.mStyle.has("blurEffect")) {
            this.mBlurEffect = this.mStyle.optString("blurEffect", "none");
        }
        if (this.mBackgroudView == null) {
            View view2 = new View(getContext());
            this.mBackgroudView = view2;
            addView(view2, 0, new FrameLayout.LayoutParams(-1, -1));
        }
        updateCapsuleLayout();
        this.redDotColor = -65536;
        if (this.mStyle != null) {
            if (this.mBackGroundDrawable == null) {
                BackGroundDrawable backGroundDrawable = new BackGroundDrawable();
                this.mBackGroundDrawable = backGroundDrawable;
                this.mBackgroudView.setBackground(backGroundDrawable);
            }
            if (this.mStyle.has(AbsoluteConst.JSONKEY_STATUSBAR) && this.mStyle.has(Constants.Name.BACKGROUND_IMAGE) && (view = this.mStatusbarView) != null) {
                view.setVisibility(8);
            }
            this.mBackGroundDrawable.setBackgroundColor(this.mBackGroundColor);
            this.mBackGroundDrawable.updatebound();
            this.mBackGroundDrawable.setBackgroundImage(this.mBackgroundImageSrc);
            this.mBackGroundDrawable.setAlpha(Color.alpha(this.mBackGroundColor));
            this.mBackGroundDrawable.invalidateSelf();
            if (this.mStyle.has("redDotColor") && !PdrUtil.isEmpty(this.mStyle.optString("redDotColor"))) {
                this.redDotColor = PdrUtil.stringToColor(this.mStyle.optString("redDotColor"));
            }
        }
        if ((DCBlurDraweeView.LIGHT.equals(this.mBlurEffect) || DCBlurDraweeView.DARK.equals(this.mBlurEffect) || DCBlurDraweeView.EXTRALIGHT.equals(this.mBlurEffect)) && this.mBlurDraweeView == null) {
            int i = this.mInnerHeight;
            if (this.isStatusBar && this.isImmersed) {
                i += DeviceInfo.sStatusBarHeight;
            }
            if (this.mWebView.obtainWindowView() instanceof IX5WebView) {
                this.mBlurDraweeView = new DCBlurDraweeView(getContext(), false, "none");
            } else {
                this.mBlurDraweeView = new DCBlurDraweeView(getContext(), true, DCBlurDraweeView.SEMI_AUTOMATICALLY);
            }
            addView(this.mBlurDraweeView, 0, new FrameLayout.LayoutParams(-1, i));
            this.mBlurDraweeView.setGravityType(48);
            this.mBlurDraweeView.setBlurEffect(this.mBlurEffect);
            this.mBlurDraweeView.setBlurRadius(20);
            this.mBlurDraweeView.setDownscaleFactor(0.3f);
            this.mBlurDraweeView.setRootView(this.mWebView.obtainFrameView().obtainMainView());
            this.mBlurDraweeView.setBlurLayoutChangeCallBack(new DCBlurDraweeView.BlurLayoutChangeCallBack() {
                /* class io.dcloud.feature.nativeObj.TitleNView.AnonymousClass1 */

                @Override // io.dcloud.common.ui.blur.DCBlurDraweeView.BlurLayoutChangeCallBack
                public void setVisibility(int i) {
                    NativeView.NativeCanvasView nativeCanvasView = TitleNView.this.mCanvasView;
                    if (nativeCanvasView != null) {
                        nativeCanvasView.setVisibility(i);
                    }
                    if (TitleNView.this.mTitleNViewLayout != null) {
                        TitleNView.this.mTitleNViewLayout.setVisibility(i);
                    }
                    View view = TitleNView.this.mStatusbarView;
                    if (!(view == null || view.getVisibility() == 8)) {
                        TitleNView.this.mStatusbarView.setVisibility(i);
                    }
                    if (TitleNView.this.mBackgroudView != null) {
                        TitleNView.this.mBackgroudView.setVisibility(i);
                    }
                }
            });
        }
    }

    /* access modifiers changed from: protected */
    @Override // io.dcloud.feature.nativeObj.NativeView
    public void measureChildViewToTop(int i) {
        super.measureChildViewToTop(i);
        RelativeLayout relativeLayout = this.mTitleNViewLayout;
        if (relativeLayout != null && relativeLayout.getLayoutParams() != null) {
            ((FrameLayout.LayoutParams) this.mTitleNViewLayout.getLayoutParams()).topMargin = i;
        }
    }

    /* access modifiers changed from: protected */
    public void onLayout(boolean z, int i, int i2, int i3, int i4) {
        super.onLayout(z, i, i2, i3, i4);
        caculateTitleMargin();
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void reMeasure() {
        measureFitViewParent(false);
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void removeBackButton() {
        BadgeLinearLayout badgeLinearLayout = this.mBackButton;
        if (badgeLinearLayout != null) {
            badgeLinearLayout.setVisibility(8);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void removeHomeButton() {
        TextView textView = this.mHomeButton;
        if (textView != null) {
            textView.setVisibility(8);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void removeSplitLine() {
        RelativeLayout relativeLayout;
        View view = this.mSplitLine;
        if (!(view == null || (relativeLayout = this.mTitleNViewLayout) == null)) {
            relativeLayout.removeView(view);
        }
        this.mSplitLine = null;
    }

    @Override // io.dcloud.feature.nativeObj.NativeView
    public void resetNativeView() {
        int i;
        IFrameView iFrameView = this.mFrameViewParent;
        if (iFrameView != null) {
            try {
                String titleNViewId = TitleNViewUtil.getTitleNViewId(iFrameView);
                if (this.mOverlayMaps.containsKey(titleNViewId)) {
                    i = this.mOverlayMaps.get(titleNViewId).intValue();
                    this.mOverlayMaps.clear();
                    this.mOverlayMaps.put(titleNViewId, Integer.valueOf(i));
                } else {
                    this.mOverlayMaps.clear();
                    i = -1;
                }
                if (-1 != i) {
                    NativeView.Overlay overlay = this.mOverlays.get(i);
                    Iterator<NativeView.Overlay> it = this.mOverlays.iterator();
                    while (it.hasNext()) {
                        NativeView.Overlay next = it.next();
                        if (next != overlay) {
                            NativeBitmap nativeBitmap = next.mNativeBitmap;
                            if (nativeBitmap != null) {
                                nativeBitmap.recycle(true);
                            }
                            it.remove();
                        }
                    }
                } else {
                    clearViewData();
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            clearViewData();
        }
        clearAnimate();
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setBackButtonColor(String str, String str2, String str3) {
        setButtonColor(this.mBackButton, str, str2, str3);
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setBackgroundColor(String str) {
        setStyleBackgroundColor(str);
        updateCapsuleLayout();
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setBackgroundImage(String str) {
        if (!this.mBackgroundImageSrc.equals(str)) {
            this.mBackgroundImageSrc = str;
            if (this.mBackGroundDrawable == null) {
                this.mBackGroundDrawable = new BackGroundDrawable();
            }
            this.mBackGroundDrawable.setBackgroundImage(this.mBackgroundImageSrc);
            this.mBackgroudView.setBackground(this.mBackGroundDrawable);
            this.mBackGroundDrawable.invalidateSelf();
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setBackgroundRepeat(String str) {
        BackGroundDrawable backGroundDrawable = this.mBackGroundDrawable;
        if (backGroundDrawable != null) {
            backGroundDrawable.setRepeatType(str, this.mBackgroundImageSrc);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setBadgeText(JSONObject jSONObject, boolean z) {
        int optInt = jSONObject.optInt("index");
        String optString = jSONObject.optString("text");
        if (!z) {
            optString = "";
        }
        if (optInt < this.mButtons.size() && optInt >= 0) {
            Object obj = this.mButtons.get(optInt);
            if (obj instanceof BadgeRelateiveLayout) {
                ((BadgeRelateiveLayout) obj).setBadgeStr(optString);
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setButtonColorByIndex(int i, String str, String str2, String str3) {
        Object obj = this.mButtons.get(i);
        if (obj != null && (obj instanceof View)) {
            setButtonColor((View) obj, str, str2, str3);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setButtonsColor(String str, String str2, String str3) {
        for (int i = 0; i < this.mButtons.size(); i++) {
            setButtonColorByIndex(i, str, str2, str3);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setCapsuleButtonStyle(JSONObject jSONObject) {
        CapsuleLayout capsuleLayout = this.mCapsuleLayout;
        if (capsuleLayout != null && jSONObject != null) {
            capsuleLayout.isDiy = true;
            if (jSONObject.has("backgroundColor")) {
                this.mCapsuleLayout.setBackgroundColor(PdrUtil.stringToColor(jSONObject.optString("backgroundColor")));
            }
            if (jSONObject.has(Constants.Name.BORDER_COLOR)) {
                this.mCapsuleLayout.setRoundColor(PdrUtil.stringToColor(jSONObject.optString(Constants.Name.BORDER_COLOR)));
            }
            if (jSONObject.has("highlightColor")) {
                int stringToColor = PdrUtil.stringToColor(jSONObject.optString("highlightColor"));
                TextView textView = this.menuBt;
                if (textView != null) {
                    this.mCapsuleLayout.setButtonSelectColor(textView, CapsuleLayout.ButtonType.LIFT, stringToColor);
                }
                TextView textView2 = this.closeBt;
                if (textView2 != null) {
                    this.mCapsuleLayout.setButtonSelectColor(textView2, CapsuleLayout.ButtonType.RIGHT, stringToColor);
                }
            }
            if (jSONObject.has("textColor")) {
                int stringToColor2 = PdrUtil.stringToColor(jSONObject.optString("textColor"));
                TextView textView3 = this.menuBt;
                if (textView3 != null) {
                    textView3.setTextColor(stringToColor2);
                }
                TextView textView4 = this.closeBt;
                if (textView4 != null) {
                    textView4.setTextColor(stringToColor2);
                }
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setHomeButtonColor(String str, String str2, String str3) {
        setButtonColor(this.mHomeButton, str, str2, str3);
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setIconSubTitleStyle(String str, String str2, String str3, String str4, String str5, String str6, String str7, String str8, String str9) {
        ImageView imageView;
        TextView textView;
        RelativeLayout relativeLayout = this.mTitlelayout;
        if (relativeLayout != null) {
            if (relativeLayout.getChildAt(0) instanceof ImageView) {
                imageView = (ImageView) this.mTitlelayout.getChildAt(0);
            } else {
                imageView = new ImageView(getContext());
                imageView.setId(View.generateViewId());
            }
            if (this.mTitlelayout.getChildAt(2) instanceof TextView) {
                textView = (TextView) this.mTitlelayout.getChildAt(2);
            } else {
                textView = new TextView(getContext());
                textView.setId(View.generateViewId());
            }
            layoutSubtitleIcon(str, str2, str3, str4, str5, str6, imageView, textView, PdrUtil.stringToColor(str7), str8, str9);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setProgress(String str, String str2) {
        int i;
        if (TextUtils.isEmpty(str) || TextUtils.isEmpty(str2)) {
            Progress progress = this.mProgress;
            if (progress == null) {
                return;
            }
            if (!progress.isFinish()) {
                this.mProgress.finishProgress();
            } else {
                this.mProgress.setVisibility(0);
            }
        } else {
            if (this.mProgress == null) {
                Progress progress2 = new Progress(getContext());
                this.mProgress = progress2;
                progress2.setTag("TitleNView.Progress");
            }
            try {
                i = Color.parseColor(str2);
            } catch (Exception unused) {
                i = PdrUtil.stringToColor(str2);
            }
            this.mProgress.setColorInt(i);
            this.mProgress.setHeightInt(PdrUtil.convertToScreenInt(str, this.mInnerWidth, 0, this.mCreateScale));
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setRedDot(JSONObject jSONObject, boolean z) {
        int optInt = jSONObject.optInt("index");
        if (optInt < this.mButtons.size() && optInt >= 0) {
            Object obj = this.mButtons.get(optInt);
            if (obj instanceof BadgeRelateiveLayout) {
                ((BadgeRelateiveLayout) obj).setDrawRedDot(z);
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setRedDotColor(int i) {
        if (this.redDotColor != i) {
            this.redDotColor = i;
            this.mBackButton.setRedDotColor(i);
            if (this.mButtons.size() > 0) {
                Iterator<Object> it = this.mButtons.iterator();
                while (it.hasNext()) {
                    Object next = it.next();
                    if (next instanceof BadgeRelateiveLayout) {
                        ((BadgeRelateiveLayout) next).setRedDotColor(this.redDotColor);
                    }
                }
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setSearchInputColor(String str) {
        Drawable background;
        int i;
        LinearLayout linearLayout = this.centerSearchLayout;
        if (linearLayout != null && (background = linearLayout.getBackground()) != null && (background instanceof SearchInputDrawable)) {
            try {
                i = Color.parseColor(str);
            } catch (Exception unused) {
                i = PdrUtil.stringToColor(str);
            }
            SearchInputDrawable searchInputDrawable = (SearchInputDrawable) background;
            if (i != searchInputDrawable.getDrawableColor()) {
                searchInputDrawable.setDrawableColor(i);
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setSearchInputFocus(boolean z) {
        EditText editText = this.searchInput;
        if (editText == null) {
            return;
        }
        if (z) {
            DeviceInfo.hideIME(editText);
            if (this.searchInput.requestFocus()) {
                DeviceInfo.showIME(this.searchInput);
                return;
            }
            return;
        }
        editText.clearFocus();
        DeviceInfo.hideIME(this.searchInput);
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setShadow(JSONObject jSONObject) {
        BackGroundDrawable backGroundDrawable = this.mBackGroundDrawable;
        if (backGroundDrawable != null) {
            backGroundDrawable.setShadowColor(jSONObject);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setSplitLine(String str, String str2) {
        int i;
        if (this.mSplitLine == null) {
            View view = new View(getContext());
            this.mSplitLine = view;
            view.setTag("TitleNView.SplitLine");
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, -2);
            layoutParams.addRule(12);
            this.mSplitLine.setLayoutParams(layoutParams);
        }
        initTitleNViewLayout();
        RelativeLayout relativeLayout = this.mTitleNViewLayout;
        if (relativeLayout != null && -1 == relativeLayout.indexOfChild(this.mSplitLine)) {
            RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-1, -2);
            layoutParams2.addRule(12);
            this.mTitleNViewLayout.addView(this.mSplitLine, layoutParams2);
        }
        try {
            i = Color.parseColor(str2);
        } catch (Exception unused) {
            i = PdrUtil.stringToColor(str2);
        }
        this.mSplitLine.setBackgroundColor(i);
        this.mSplitLine.getLayoutParams().height = PdrUtil.convertToScreenInt(str, this.mInnerWidth, 0, this.mCreateScale);
        this.mSplitLine.requestLayout();
        this.mSplitLine.invalidate();
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setStatusBarColor(int i) {
        if (!this.isImmersed) {
            return;
        }
        if (this.mStatusbarView == null) {
            ViewParent parent = getParent();
            if (TextUtils.equals(this.mStyle.optString("position", AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE), AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE) && parent != null && (parent instanceof ViewGroup)) {
                int i2 = 0;
                while (true) {
                    ViewGroup viewGroup = (ViewGroup) parent;
                    if (i2 < viewGroup.getChildCount()) {
                        View childAt = viewGroup.getChildAt(i2);
                        if (childAt.getTag() == null || !"StatusBar".equalsIgnoreCase(childAt.getTag().toString())) {
                            i2++;
                        } else {
                            childAt.setBackgroundColor(i);
                            childAt.invalidate();
                            return;
                        }
                    } else {
                        return;
                    }
                }
            }
        } else if (TextUtils.isEmpty(this.mBackgroundImageSrc) || !isStatusBar()) {
            this.mStatusbarView.setBackgroundColor(i);
            this.mStatusbarView.invalidate();
        }
    }

    @Override // io.dcloud.common.DHInterface.INativeView, io.dcloud.feature.nativeObj.NativeView
    public void setStyleBackgroundColor(int i) {
        this.mBackGroundDrawable.setBackgroundColor(i);
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setTitle(String str, String str2, String str3, String str4, String str5, String str6, String str7, String str8, String str9, String str10, String str11, String str12) {
        ImageView imageView;
        TextView textView;
        int stringToColor;
        initTitleNViewLayout();
        initLeftButtonLayout();
        if (this.mTitlelayout == null) {
            this.mTitlelayout = new RelativeLayout(getContext());
        }
        if (this.mTitlelayout.getChildAt(0) instanceof ImageView) {
            imageView = (ImageView) this.mTitlelayout.getChildAt(0);
        } else {
            imageView = new ImageView(getContext());
            imageView.setId(View.generateViewId());
        }
        if (this.mTitleView == null) {
            TextView textView2 = new TextView(getContext());
            this.mTitleView = textView2;
            textView2.setTag("TitleNView.Title");
            this.mTitleView.setLines(1);
            this.mTitleView.setSingleLine(true);
            this.mTitleView.setIncludeFontPadding(false);
            RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-2, -2);
            layoutParams.addRule(13);
            this.mTitleView.setLayoutParams(layoutParams);
            if ("clip".equals(str4)) {
                this.mTitleView.setEllipsize(null);
            } else {
                this.mTitleView.setEllipsize(TextUtils.TruncateAt.END);
            }
            this.mTitleView.setId(View.generateViewId());
        }
        if (this.mTitlelayout.getChildAt(2) instanceof TextView) {
            textView = (TextView) this.mTitlelayout.getChildAt(2);
        } else {
            textView = new TextView(getContext());
            textView.setId(View.generateViewId());
        }
        if (!TextUtils.isEmpty(str) && !str.equals(this.mTitleView.getText())) {
            this.mTitleView.setText(str);
        }
        this.mTitleView.getPaint().setTextSize((float) PdrUtil.convertToScreenInt(str3, this.mInnerWidth, PdrUtil.convertToScreenInt("17px", this.mInnerWidth, 0, this.mCreateScale), this.mCreateScale));
        try {
            stringToColor = Color.parseColor(str2);
        } catch (Exception unused) {
            stringToColor = PdrUtil.stringToColor(str2);
        }
        this.mTitleView.setTextColor(stringToColor);
        if (-1 == this.mTitleNViewLayout.indexOfChild(this.mTitlelayout)) {
            this.mTitleNViewLayout.addView(this.mTitlelayout);
        }
        RelativeLayout.LayoutParams layoutParams2 = new RelativeLayout.LayoutParams(-2, -2);
        int convertToScreenInt = PdrUtil.convertToScreenInt("88px", this.mInnerWidth, 0, this.mCreateScale);
        if (str5.equals("left") || str5.equals("auto")) {
            layoutParams2.addRule(1, this.mLeftButtonLayout.getId());
            layoutParams2.addRule(15);
            layoutParams2.removeRule(13);
            layoutParams2.leftMargin = PdrUtil.convertToScreenInt("10px", this.mInnerWidth, 0, this.mCreateScale);
        } else {
            layoutParams2.addRule(13);
            layoutParams2.removeRule(1);
            layoutParams2.removeRule(15);
            layoutParams2.leftMargin = convertToScreenInt;
        }
        layoutSubtitleIcon(str6, str7, str8, str9, str10, str11, imageView, textView, stringToColor, str5, str12);
        layoutParams2.rightMargin = convertToScreenInt;
        this.mTitlelayout.setLayoutParams(layoutParams2);
        EditText editText = this.searchInput;
        if (editText != null && editText.getVisibility() == 0) {
            this.mTitlelayout.setVisibility(4);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setTitleAlign(String str) {
        RelativeLayout relativeLayout = this.mTitlelayout;
        if (relativeLayout != null) {
            RelativeLayout.LayoutParams layoutParams = (RelativeLayout.LayoutParams) relativeLayout.getLayoutParams();
            if (str.equals("left") || str.equals("auto")) {
                layoutParams.addRule(1, this.mLeftButtonLayout.getId());
                layoutParams.addRule(15);
                layoutParams.removeRule(13);
                layoutParams.leftMargin = PdrUtil.convertToScreenInt("5px", this.mInnerWidth, 0, this.mCreateScale);
            } else {
                layoutParams.addRule(13);
                layoutParams.removeRule(1);
                layoutParams.removeRule(15);
                layoutParams.leftMargin = layoutParams.rightMargin;
            }
            this.mTitlelayout.setLayoutParams(layoutParams);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setTitleColor(String str) {
        int i;
        TextView textView = this.mTitleView;
        if (textView != null) {
            int defaultColor = textView.getTextColors().getDefaultColor();
            try {
                i = Color.parseColor(str);
            } catch (Exception unused) {
                i = PdrUtil.stringToColor(str);
            }
            if (i != defaultColor) {
                this.mTitleView.setTextColor(i);
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public boolean setTitleNViewButtonStyle(int i, String str, String str2, String str3, String str4, String str5, String str6, String str7, String str8, String str9, IWebview iWebview, String str10, String str11, String str12, String str13, String str14, String str15, String str16, String str17) {
        int i2;
        int i3;
        int i4;
        int i5;
        int i6;
        int i7;
        int i8;
        if (i >= this.mButtons.size() || i < 0) {
            return false;
        }
        Object obj = this.mButtons.get(i);
        if (obj instanceof View) {
            ViewGroup viewGroup = (ViewGroup) obj;
            String str18 = null;
            if (viewGroup.getChildCount() >= 1) {
                TextView textView = (TextView) viewGroup.getChildAt(0);
                if (PdrUtil.isEmpty(str3) || PdrUtil.isEmpty(str4)) {
                    i3 = -1;
                    i2 = -1;
                } else {
                    try {
                        i7 = Color.parseColor(str3);
                    } catch (Exception unused) {
                        i7 = PdrUtil.stringToColor(str3);
                    }
                    try {
                        i8 = Color.parseColor(str4);
                    } catch (Exception unused2) {
                        i8 = PdrUtil.stringToColor(str4);
                    }
                    textView.setTextColor(createColorStateList(i7, i8));
                    i2 = i7;
                    i3 = i8;
                }
                if (!PdrUtil.isEmpty(str5)) {
                    if (Constants.Value.BOLD.equals(str5)) {
                        textView.getPaint().setFakeBoldText(true);
                    } else {
                        textView.getPaint().setFakeBoldText(false);
                    }
                    textView.postInvalidate();
                }
                if (!PdrUtil.isEmpty(str6)) {
                    textView.setTextSize(0, (float) PdrUtil.convertToScreenInt(str6, this.mInnerWidth, 0, this.mCreateScale));
                }
                if (!PdrUtil.isEmpty(str8) || !PdrUtil.isEmpty(str)) {
                    i5 = i3;
                    i4 = i2;
                    setTextAndFont(str, str7, str8, textView, PdrUtil.isEmpty(str8));
                } else {
                    i5 = i3;
                    i4 = i2;
                }
                Drawable background = viewGroup.getBackground();
                if (!PdrUtil.isEmpty(str10) && str15.equals("transparent")) {
                    try {
                        i6 = Color.parseColor(str10);
                    } catch (Exception unused3) {
                        i6 = PdrUtil.stringToColor(str10);
                    }
                    boolean z = background instanceof NativeViewBackButtonDrawable;
                    if (z) {
                        ((NativeViewBackButtonDrawable) background).setWidth(str14);
                    }
                    if (z) {
                        NativeViewBackButtonDrawable nativeViewBackButtonDrawable = (NativeViewBackButtonDrawable) background;
                        if (i6 != nativeViewBackButtonDrawable.getDrawableColor()) {
                            nativeViewBackButtonDrawable.setDrawableColor(i6);
                        }
                    }
                }
                if (str12 != null && (viewGroup instanceof BadgeRelateiveLayout)) {
                    ((BadgeRelateiveLayout) viewGroup).setBadgeStr(str12);
                }
                if ((viewGroup instanceof BadgeRelateiveLayout) && !PdrUtil.isEmpty(str11)) {
                    ((BadgeRelateiveLayout) viewGroup).setDrawRedDot(Boolean.parseBoolean(str11));
                }
                if (viewGroup.getChildCount() >= 2 && !PdrUtil.isEmpty(str13)) {
                    TextView textView2 = (TextView) viewGroup.getChildAt(1);
                    if (Boolean.parseBoolean(str13)) {
                        textView2.setVisibility(0);
                        textView.setEllipsize(TextUtils.TruncateAt.END);
                    } else {
                        textView2.setVisibility(8);
                        textView.setEllipsize(null);
                    }
                } else if (!PdrUtil.isEmpty(str13) && Boolean.parseBoolean(str13)) {
                    TextView addSelect = addSelect(viewGroup, textView, 0);
                    if (!(-1 == i4 || -1 == i5)) {
                        addSelect.setTextColor(createColorStateList(i4, i5));
                    }
                }
                if (str9 != null) {
                    addButtonOnClickListener(str9, iWebview, viewGroup);
                }
                if (PdrUtil.isEmpty(str14) || !str14.equals("auto") || PdrUtil.isEmpty(str13) || !Boolean.parseBoolean(str13)) {
                    viewGroup.setPadding(0, textView.getPaddingTop(), 0, textView.getPaddingBottom());
                } else {
                    int convertToScreenInt = PdrUtil.convertToScreenInt("5px", this.mAppScreenWidth, 0, this.mCreateScale);
                    viewGroup.setPadding(convertToScreenInt, textView.getPaddingTop(), convertToScreenInt, textView.getPaddingBottom());
                }
                if (!PdrUtil.isEmpty(str16) || !PdrUtil.isEmpty(str14)) {
                    int convertToScreenInt2 = PdrUtil.convertToScreenInt(str16, this.mAppScreenWidth, 0, this.mCreateScale);
                    int convertToScreenInt3 = PdrUtil.convertToScreenInt(PdrUtil.isEmpty(str14) ? str17 : str14, this.mAppScreenWidth, 0, this.mCreateScale);
                    if (convertToScreenInt2 > 0) {
                        textView.setEllipsize(TextUtils.TruncateAt.END);
                        textView.setMaxWidth(convertToScreenInt2);
                    }
                    ViewGroup.LayoutParams layoutParams = viewGroup.getLayoutParams();
                    int i9 = layoutParams.width;
                    if (convertToScreenInt2 <= 0 || convertToScreenInt3 <= convertToScreenInt2) {
                        if (!PdrUtil.isEmpty(str14)) {
                            if (!str14.equals("auto")) {
                                i9 = PdrUtil.convertToScreenInt(str14, this.mAppScreenWidth, layoutParams.height, this.mCreateScale);
                            }
                        }
                        layoutParams.width = i9;
                        viewGroup.setLayoutParams(layoutParams);
                    }
                    i9 = -2;
                    layoutParams.width = i9;
                    viewGroup.setLayoutParams(layoutParams);
                }
                caculateTitleMargin();
            } else if (obj instanceof ButtonDataItem) {
                ButtonDataItem buttonDataItem = (ButtonDataItem) obj;
                if (iWebview != null) {
                    str18 = iWebview.getWebviewUUID();
                }
                buttonDataItem.update(str, str2, str18, str7, str8, str9);
            }
        }
        return true;
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setTitleNViewFocusable(boolean z) {
        DCBlurDraweeView dCBlurDraweeView = this.mBlurDraweeView;
        if (dCBlurDraweeView != null && dCBlurDraweeView.checkBlurEffect(this.mBlurEffect)) {
            this.mBlurDraweeView.setContentFocusable(z);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setTitleNViewPadding(int i, int i2, int i3, int i4) {
        initTitleNViewLayout();
        this.mTitleNViewLayout.setPadding(i, i2, i3, i4);
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setTitleNViewSearchInputText(String str) {
        EditText editText = this.searchInput;
        if (editText != null) {
            editText.setText(str);
            this.searchInput.setSelection(str.length());
            if (!this.searchInput.isFocusable()) {
                this.isSetText.set(true);
                this.searchInput.setFocusable(true);
                this.searchInput.setFocusableInTouchMode(true);
                this.searchInput.requestFocus();
                this.searchInput.setFocusable(false);
                this.searchInput.setFocusableInTouchMode(false);
                this.isSetText.set(false);
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setTitleOverflow(String str) {
        if (this.mTitleView != null && !TextUtils.isEmpty(str)) {
            if ("clip".equals(str)) {
                this.mTitleView.setEllipsize(null);
            } else {
                this.mTitleView.setEllipsize(TextUtils.TruncateAt.END);
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setTitleSize(String str) {
        if (this.mTitleView != null && !TextUtils.isEmpty(str) && str.endsWith("px")) {
            float textSize = this.mTitleView.getPaint().getTextSize();
            float convertToScreenInt = (float) PdrUtil.convertToScreenInt(str, this.mInnerWidth, 0, this.mCreateScale);
            if (textSize != convertToScreenInt) {
                this.mTitleView.getPaint().setTextSize(convertToScreenInt);
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setTitleText(String str) {
        if (this.mTitleView != null && !TextUtils.isEmpty(str) && !str.equals(this.mTitleView.getText())) {
            this.mTitleView.setText(str);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void startProgress() {
        Progress progress = this.mProgress;
        if (progress != null) {
            progress.setVisibility(0);
            this.mProgress.setAlphaInt(255);
            this.mProgress.setCurProgress(0);
            this.mProgress.setWebviewProgress(0);
            RelativeLayout relativeLayout = this.mTitleNViewLayout;
            if (relativeLayout != null && -1 == relativeLayout.indexOfChild(this.mProgress)) {
                RelativeLayout.LayoutParams layoutParams = new RelativeLayout.LayoutParams(-1, (int) this.mProgress.getHeightInt());
                layoutParams.addRule(12);
                this.mTitleNViewLayout.addView(this.mProgress, layoutParams);
            }
            IFrameView iFrameView = this.mFrameViewParent;
            if (iFrameView != null && iFrameView.obtainWebView() != null && this.mFrameViewParent.obtainWebView().obtainWindowView() != null) {
                if (this.mIWebviewStateListenerImpl != null) {
                    this.mFrameViewParent.obtainWebView().removeStateListener(this.mIWebviewStateListenerImpl);
                }
                this.mIWebviewStateListenerImpl = new IWebviewStateListenerImpl(this.mProgress);
                this.mFrameViewParent.obtainWebView().addStateListener(this.mIWebviewStateListenerImpl);
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void stopProgress() {
        Progress progress = this.mProgress;
        if (progress != null && !progress.isFinish()) {
            this.mProgress.finishProgress();
        }
    }

    private ColorStateList createColorStateList(int i, int i2) {
        int[] iArr = {i2, i, i, i, i, i};
        return new ColorStateList(new int[][]{new int[]{16842919, 16842910}, new int[]{16842910, 16842908}, new int[]{16842910}, new int[]{16842908}, new int[]{16842909}, new int[0]}, iArr);
    }

    private class BadgeLinearLayout extends LinearLayout {
        private String badgeStr;
        Rect canvasRect;
        float circle4PX;
        float circle8PX;
        private boolean isDrawRedDot;
        private Paint redDotPaint;
        TextPaint textPaint;

        public BadgeLinearLayout(Context context) {
            super(context);
            this.isDrawRedDot = false;
            this.badgeStr = "";
            this.canvasRect = new Rect();
        }

        /* access modifiers changed from: protected */
        public void dispatchDraw(Canvas canvas) {
            super.dispatchDraw(canvas);
            canvas.getClipBounds(this.canvasRect);
            if (this.isDrawRedDot && PdrUtil.isEmpty(this.badgeStr)) {
                Rect rect = this.canvasRect;
                float f = this.circle4PX;
                canvas.drawCircle(((float) rect.right) - f, ((float) rect.top) + f, f, this.redDotPaint);
            }
        }

        public void draw(Canvas canvas) {
            super.draw(canvas);
        }

        public void setBadgeStr(String str) {
            if (str != null && !str.equals(this.badgeStr)) {
                if (str.length() > 4) {
                    this.badgeStr = str.trim().substring(0, 3) + "…";
                } else {
                    this.badgeStr = str.trim();
                }
                postInvalidate();
            }
        }

        public void setDrawRedDot(boolean z) {
            if (this.isDrawRedDot != z) {
                this.isDrawRedDot = z;
                postInvalidate();
            }
        }

        public void setRedDotColor(int i) {
            this.redDotPaint.setColor(i);
            postInvalidate();
        }

        public BadgeLinearLayout(TitleNView titleNView, Context context, float f, int i) {
            this(context);
            Paint paint = new Paint();
            this.redDotPaint = paint;
            paint.setColor(i);
            this.redDotPaint.setAntiAlias(true);
            TextPaint textPaint2 = new TextPaint();
            this.textPaint = textPaint2;
            textPaint2.setColor(-1);
            this.textPaint.setFakeBoldText(true);
            this.textPaint.setTextAlign(Paint.Align.CENTER);
            float convertToScreenInt = (float) PdrUtil.convertToScreenInt("8px", 0, 0, f);
            this.circle8PX = convertToScreenInt;
            this.textPaint.setTextSize(convertToScreenInt);
            this.circle4PX = (float) PdrUtil.convertToScreenInt("4px", 0, 0, f);
        }
    }

    /* access modifiers changed from: private */
    public class BadgeRelateiveLayout extends LinearLayout {
        private String badgeStr;
        Rect canvasRect;
        float circle4PX;
        float circle8PX;
        private boolean isDrawRedDot;
        private Paint redDotPaint;
        TextPaint textPaint;

        public BadgeRelateiveLayout(Context context) {
            super(context);
            this.isDrawRedDot = false;
            this.badgeStr = "";
            this.canvasRect = new Rect();
        }

        /* access modifiers changed from: protected */
        public void dispatchDraw(Canvas canvas) {
            super.dispatchDraw(canvas);
            canvas.getClipBounds(this.canvasRect);
            if (this.isDrawRedDot && PdrUtil.isEmpty(this.badgeStr)) {
                Rect rect = this.canvasRect;
                float f = this.circle4PX;
                canvas.drawCircle(((float) rect.right) - f, ((float) rect.top) + f, f, this.redDotPaint);
            }
            if (this.badgeStr.length() > 0) {
                Rect rect2 = new Rect();
                TextPaint textPaint2 = this.textPaint;
                String str = this.badgeStr;
                textPaint2.getTextBounds(str, 0, str.length(), rect2);
                Paint paint = new Paint(this.redDotPaint);
                paint.setColor(-65536);
                float abs = ((float) (this.canvasRect.right - Math.abs(rect2.width()))) - this.circle8PX;
                Rect rect3 = this.canvasRect;
                int i = rect3.top;
                RectF rectF = new RectF(abs, (float) i, (float) rect3.right, ((float) (i + Math.abs(rect2.height()))) + this.circle4PX);
                canvas.drawRoundRect(rectF, rectF.height() / 2.0f, rectF.height() / 2.0f, paint);
                Paint.FontMetrics fontMetrics = this.textPaint.getFontMetrics();
                canvas.drawText(this.badgeStr, rectF.centerX(), (rectF.centerY() - (fontMetrics.top / 2.0f)) - (fontMetrics.bottom / 2.0f), this.textPaint);
            }
        }

        public void draw(Canvas canvas) {
            super.draw(canvas);
        }

        public void setBadgeStr(String str) {
            if (str != null && !str.equals(this.badgeStr)) {
                if (str.length() > 4) {
                    this.badgeStr = str.trim().substring(0, 3) + "…";
                } else {
                    this.badgeStr = str.trim();
                }
                postInvalidate();
            }
        }

        public void setDrawRedDot(boolean z) {
            if (this.isDrawRedDot != z) {
                this.isDrawRedDot = z;
                postInvalidate();
            }
        }

        public void setRedDotColor(int i) {
            this.redDotPaint.setColor(i);
            postInvalidate();
        }

        public BadgeRelateiveLayout(TitleNView titleNView, Context context, float f, int i) {
            this(context);
            Paint paint = new Paint();
            this.redDotPaint = paint;
            paint.setColor(i);
            this.redDotPaint.setAntiAlias(true);
            TextPaint textPaint2 = new TextPaint();
            this.textPaint = textPaint2;
            textPaint2.setColor(-1);
            this.textPaint.setFakeBoldText(true);
            this.textPaint.setTextAlign(Paint.Align.CENTER);
            float convertToScreenInt = (float) PdrUtil.convertToScreenInt("8px", 0, 0, f);
            this.circle8PX = convertToScreenInt;
            this.textPaint.setTextSize(convertToScreenInt);
            this.circle4PX = (float) PdrUtil.convertToScreenInt("4px", 0, 0, f);
        }
    }

    @Override // io.dcloud.common.DHInterface.ITitleNView
    public void setTitleColor(int i) {
        TextView textView = this.mTitleView;
        if (textView != null && i != textView.getTextColors().getDefaultColor()) {
            this.mTitleView.setTextColor(i);
        }
    }
}
