package io.dcloud.feature.nativeObj;

import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Typeface;
import android.graphics.drawable.GradientDrawable;
import android.os.Build;
import android.os.Handler;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import android.text.TextUtils;
import android.util.TypedValue;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.view.inputmethod.InputMethodManager;
import android.widget.EditText;
import android.widget.FrameLayout;
import android.widget.TextView;
import com.dcloud.android.widget.AbsoluteLayout;
import com.dcloud.android.widget.StatusBarView;
import com.nostra13.dcloudimageloader.core.assist.FailReason;
import com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener;
import com.taobao.weex.common.Constants;
import com.taobao.weex.el.parse.Operators;
import com.taobao.weex.ui.component.WXBasicComponentType;
import io.dcloud.common.DHInterface.AbsMgr;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.IEventCallback;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.INativeView;
import io.dcloud.common.DHInterface.IReflectAble;
import io.dcloud.common.DHInterface.IWaiter;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameItem;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.adapter.ui.FrameBitmapView;
import io.dcloud.common.adapter.util.DeviceInfo;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.adapter.util.ViewOptions;
import io.dcloud.common.adapter.util.ViewRect;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.BaseInfo;
import io.dcloud.common.util.Deprecated_JSUtil;
import io.dcloud.common.util.JSONUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.TitleNViewUtil;
import io.dcloud.feature.nativeObj.richtext.RichTextLayout;
import io.dcloud.feature.uniapp.adapter.AbsURIAdapter;
import io.dcloud.nineoldandroids.view.ViewHelper;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import pl.droidsonroids.gif.GifDrawable;
import pl.droidsonroids.gif.GifImageView;
import tv.danmaku.ijk.media.player.IjkMediaPlayer;

public class NativeView extends FrameLayout implements IWaiter, INativeView, IReflectAble {
    static final String T = "{clientX:%d,clientY:%d,pageX:%d,pageY:%d,screenX:%d,screenY:%d}";
    private boolean isAnimate = false;
    protected boolean isImmersed = false;
    public boolean isLayoutAdapt = false;
    public boolean isStatusBar = false;
    boolean isWebAnimationRuning = false;
    IApp mApp = null;
    public int mAppScreenHeight;
    public int mAppScreenWidth;
    boolean mAttached = false;
    protected int mBackGroundColor = 0;
    protected String mBackgroundImageSrc = null;
    public NativeCanvasView mCanvasView = null;
    HashMap<String, INativeViewChildView> mChildViewMaps = new HashMap<>();
    public float mCreateScale = 1.0f;
    IFrameView mFrameViewParent = null;
    private Handler mHandler = new Handler();
    String mID = null;
    IEventCallback mIEventCallback = null;
    protected int mInnerBottom;
    public int mInnerHeight;
    public int mInnerLeft;
    protected int mInnerRight;
    public int mInnerTop;
    public int mInnerWidth;
    boolean mIntercept = true;
    public int mMarginBottom = 0;
    public int mMarginTop = 0;
    HashMap<String, Integer> mOverlayMaps = new HashMap<>();
    ArrayList<Overlay> mOverlays = new ArrayList<>();
    Paint mPaint = new Paint();
    private int mRegionBottom;
    private JSONObject mRegionJson;
    private int mRegionLeft;
    private RectF mRegionRect;
    private int mRegionRight;
    private int mRegionTop;
    boolean mShow = false;
    public int mStatusColor;
    protected View mStatusbarView = null;
    public JSONObject mStyle = null;
    String mTouchRectJson = null;
    ArrayList<RectF> mTouchRects = new ArrayList<>();
    float mTouchX;
    float mTouchY;
    public String mUUID = null;
    protected IWebview mWebView;

    /* access modifiers changed from: package-private */
    public class NativeCanvasView extends View implements View.OnClickListener {
        private Runnable clickEventRunnable = null;
        HashMap<String, HashMap<String, IWebview>> doEventListenerMap = new HashMap<>(2);
        boolean isAddDoubleClickEvent = false;
        boolean isTouchDown = false;
        long mCurClickTime = 0;
        long mLastClickTime = 0;

        public NativeCanvasView(Context context) {
            super(context);
            setOnClickListener(this);
            setClickable(false);
        }

        private void drawRect(Canvas canvas, int i, int i2, int i3, int i4, Overlay overlay) {
            NativeView.this.mPaint.reset();
            NativeView.this.mPaint.setAntiAlias(true);
            RectF rectF = new RectF((float) i, (float) i2, (float) i3, (float) i4);
            if (overlay.borderWidth <= 0.0f) {
                NativeView.this.mPaint.setColor(overlay.mRectColor);
                canvas.drawRoundRect(rectF, overlay.radius, overlay.radius, NativeView.this.mPaint);
                return;
            }
            int i5 = overlay.mRectColor;
            if ((-16777216 & i5) == 0) {
                NativeView.this.mPaint.setStyle(Paint.Style.STROKE);
                NativeView.this.mPaint.setStrokeWidth(overlay.borderWidth);
                NativeView.this.mPaint.setColor(overlay.borderColor);
                canvas.drawRoundRect(rectF, overlay.radius, overlay.radius, NativeView.this.mPaint);
                return;
            }
            NativeView.this.mPaint.setColor(i5);
            NativeView.this.mPaint.setStyle(Paint.Style.FILL);
            canvas.drawRoundRect(rectF, overlay.radius, overlay.radius, NativeView.this.mPaint);
            NativeView.this.mPaint.setStyle(Paint.Style.STROKE);
            NativeView.this.mPaint.setStrokeWidth(overlay.borderWidth);
            NativeView.this.mPaint.setColor(overlay.borderColor);
            canvas.drawRoundRect(rectF, overlay.radius, overlay.radius, NativeView.this.mPaint);
        }

        private void initAuto(Overlay overlay) {
            Rect rect = overlay.mDestRect;
            if (rect.left == Integer.MIN_VALUE) {
                NativeView nativeView = NativeView.this;
                int i = nativeView.mInnerLeft;
                int i2 = nativeView.mInnerWidth;
                int i3 = rect.right;
                int i4 = i + ((i2 - i3) / 2);
                rect.left = i4;
                rect.right = i3 + i4;
            }
            if (rect.top == Integer.MIN_VALUE) {
                NativeView nativeView2 = NativeView.this;
                int i5 = nativeView2.mInnerTop;
                int i6 = nativeView2.mInnerHeight;
                int i7 = rect.bottom;
                int i8 = i5 + ((i6 - i7) / 2);
                rect.top = i8;
                rect.bottom = i7 + i8;
            }
        }

        private void postDelayedClickEvent() {
            if (this.clickEventRunnable == null) {
                this.clickEventRunnable = new Runnable() {
                    /* class io.dcloud.feature.nativeObj.NativeView.NativeCanvasView.AnonymousClass1 */

                    public void run() {
                        NativeCanvasView.this.doTypeEvent(Constants.Event.CLICK);
                        NativeCanvasView.this.clickEventRunnable = null;
                    }
                };
            }
            postDelayed(this.clickEventRunnable, 300);
        }

        /* access modifiers changed from: package-private */
        public void addEventListener(String str, IWebview iWebview, String str2) {
            HashMap<String, IWebview> hashMap = this.doEventListenerMap.get(str);
            if (hashMap == null) {
                hashMap = new HashMap<>(2);
                this.doEventListenerMap.put(str, hashMap);
            }
            boolean z = true;
            if (TextUtils.equals(str, Constants.Event.CLICK)) {
                setClickable(true);
            }
            if (TextUtils.equals(str, "doubleclick")) {
                this.isAddDoubleClickEvent = true;
            }
            Iterator<String> it = this.doEventListenerMap.keySet().iterator();
            while (true) {
                if (!it.hasNext()) {
                    break;
                }
                String next = it.next();
                HashMap<String, IWebview> hashMap2 = this.doEventListenerMap.get(next);
                if (next != null && hashMap2.containsValue(iWebview)) {
                    z = false;
                    break;
                }
            }
            if (z) {
                iWebview.obtainFrameView().addFrameViewListener(new IEventCallback() {
                    /* class io.dcloud.feature.nativeObj.NativeView.NativeCanvasView.AnonymousClass2 */

                    @Override // io.dcloud.common.DHInterface.IEventCallback
                    public Object onCallBack(String str, Object obj) {
                        if (!(str == AbsoluteConst.EVENTS_CLOSE || str == AbsoluteConst.EVENTS_WINDOW_CLOSE)) {
                            return null;
                        }
                        for (String str2 : NativeCanvasView.this.doEventListenerMap.keySet()) {
                            HashMap<String, IWebview> hashMap = NativeCanvasView.this.doEventListenerMap.get(str2);
                            if (!hashMap.isEmpty()) {
                                Set<String> keySet = hashMap.keySet();
                                int size = keySet.size();
                                String[] strArr = new String[size];
                                keySet.toArray(strArr);
                                for (int i = size - 1; i >= 0; i--) {
                                    String str3 = strArr[i];
                                    if (hashMap.get(str3) == obj) {
                                        hashMap.remove(str3);
                                    }
                                }
                            }
                            if (hashMap.isEmpty() && TextUtils.equals(str2, Constants.Event.CLICK)) {
                                NativeCanvasView.this.setClickable(false);
                            }
                        }
                        ((IWebview) obj).obtainFrameView().removeFrameViewListener(this);
                        return null;
                    }
                });
            }
            hashMap.put(str2, iWebview);
        }

        public boolean doTypeEvent(String str) {
            HashMap<String, IWebview> hashMap = this.doEventListenerMap.get(str);
            boolean z = false;
            if (hashMap != null) {
                for (String str2 : hashMap.keySet()) {
                    z = true;
                    Deprecated_JSUtil.execCallback(hashMap.get(str2), str2, NativeView.this.getEventJSON(), JSUtil.OK, true, true);
                }
            }
            return z;
        }

        public boolean listenClick() {
            HashMap<String, IWebview> hashMap = this.doEventListenerMap.get(Constants.Event.CLICK);
            return hashMap != null && !hashMap.isEmpty();
        }

        public void onClick(View view) {
            NativeView nativeView = NativeView.this;
            if (nativeView.checkTouchRectsContains(nativeView.mTouchX, nativeView.mTouchY)) {
                this.mLastClickTime = this.mCurClickTime;
                long currentTimeMillis = System.currentTimeMillis();
                this.mCurClickTime = currentTimeMillis;
                boolean z = this.isAddDoubleClickEvent;
                if (z && currentTimeMillis - this.mLastClickTime < 300) {
                    Runnable runnable = this.clickEventRunnable;
                    if (runnable != null) {
                        removeCallbacks(runnable);
                    }
                    doTypeEvent("doubleclick");
                } else if (z) {
                    postDelayedClickEvent();
                } else {
                    doTypeEvent(Constants.Event.CLICK);
                }
            }
        }

        /* access modifiers changed from: protected */
        public void onDraw(Canvas canvas) {
            int i;
            Typeface create;
            canvas.save();
            int i2 = 0;
            canvas.setDrawFilter(new PaintFlagsDrawFilter(0, 3));
            NativeView nativeView = NativeView.this;
            canvas.clipRect(nativeView.mInnerLeft, nativeView.mInnerTop, nativeView.mInnerRight, nativeView.mInnerBottom);
            if (NativeView.this.getViewType().equals(AbsoluteConst.NATIVE_NVIEW)) {
                canvas.drawColor(NativeView.this.mBackGroundColor);
            }
            if (NativeView.this.mRegionRect != null) {
                canvas.clipRect(NativeView.this.mRegionRect, Region.Op.DIFFERENCE);
            }
            Iterator<Overlay> it = NativeView.this.mOverlays.iterator();
            while (it.hasNext()) {
                Overlay next = it.next();
                if (next.type.equals("clear")) {
                    canvas.clipRect(next.mDestRect, Region.Op.DIFFERENCE);
                }
            }
            Iterator<Overlay> it2 = NativeView.this.mOverlays.iterator();
            while (it2.hasNext()) {
                Overlay next2 = it2.next();
                NativeView.this.mPaint.reset();
                canvas.save();
                NativeBitmap nativeBitmap = next2.mNativeBitmap;
                if (nativeBitmap != null && nativeBitmap.getBitmap() != null && !next2.mNativeBitmap.isRecycled() && !next2.mNativeBitmap.isGif()) {
                    Rect rect = next2.mDestRect;
                    if (rect.left == Integer.MIN_VALUE || rect.top == Integer.MIN_VALUE) {
                        initAuto(next2);
                        canvas.drawBitmap(next2.mNativeBitmap.getBitmap(), next2.mSrcRect, next2.mDestRect, NativeView.this.mPaint);
                    } else {
                        canvas.clipRect(rect);
                        canvas.drawBitmap(next2.mNativeBitmap.getBitmap(), next2.mSrcRect, next2.mDestRect, NativeView.this.mPaint);
                    }
                } else if (next2.mText != null) {
                    initAuto(next2);
                    canvas.clipRect(next2.mDestRect);
                    NativeView.this.mPaint.reset();
                    NativeView.this.mPaint.setAntiAlias(true);
                    int i3 = next2.mFontColor;
                    if (i3 != 0) {
                        NativeView.this.mPaint.setColor(i3);
                    }
                    if (next2.mFontColor == 0) {
                        NativeView.this.mPaint.setColor(i2);
                    }
                    float f = next2.mFontSize;
                    if (f != 0.0f) {
                        NativeView.this.mPaint.setTextSize(f);
                    }
                    if (!TextUtils.isEmpty(next2.textTTFPh)) {
                        Typeface typeface = NativeTypefaceFactory.getTypeface(NativeView.this.mApp, next2.textTTFPh);
                        if (typeface != null) {
                            NativeView.this.mPaint.setTypeface(typeface);
                        }
                    } else if (!TextUtils.isEmpty(next2.textFamily) && (create = Typeface.create(next2.textFamily, i2)) != null) {
                        NativeView.this.mPaint.setTypeface(create);
                    }
                    NativeView.this.mPaint.setFakeBoldText(next2.textWeight.equals(FrameBitmapView.BOLD));
                    if (next2.textStyle.equals(FrameBitmapView.ITALIC)) {
                        NativeView.this.mPaint.setTextSkewX(-0.5f);
                    }
                    NativeView.this.mPaint.setTextAlign(Paint.Align.CENTER);
                    int centerX = next2.mDestRect.centerX();
                    if (next2.textAlign.equals("right")) {
                        NativeView.this.mPaint.setTextAlign(Paint.Align.RIGHT);
                        centerX = next2.mDestRect.right;
                    } else if (next2.textAlign.equals("left")) {
                        NativeView.this.mPaint.setTextAlign(Paint.Align.LEFT);
                        centerX = next2.mDestRect.left;
                    }
                    String str = next2.mText;
                    if (next2.textDecoration.equals("underline")) {
                        NativeView.this.mPaint.setUnderlineText(true);
                    } else if (next2.textDecoration.equals("line-through")) {
                        NativeView.this.mPaint.setFlags(16);
                    }
                    TextPaint textPaint = new TextPaint();
                    textPaint.set(NativeView.this.mPaint);
                    if (next2.textWhiteSpace.equals("normal")) {
                        StaticLayout staticLayout = new StaticLayout(str, textPaint, next2.mDestRect.width(), Layout.Alignment.ALIGN_NORMAL, next2.textLineSpacing + 0.9f, 0.0f, true);
                        if (!next2.textAdapt && staticLayout.getHeight() > next2.mDestRect.height()) {
                            int lineEnd = staticLayout.getLineEnd((next2.mDestRect.height() / (staticLayout.getHeight() / staticLayout.getLineCount())) - 1);
                            String str2 = next2.textOverflow.equals(Constants.Name.ELLIPSIS) ? "…" : "";
                            StringBuilder sb = new StringBuilder();
                            if (!TextUtils.isEmpty(str2)) {
                                lineEnd--;
                            }
                            sb.append(str.substring(0, lineEnd));
                            sb.append(str2);
                            staticLayout = new StaticLayout(sb.toString(), textPaint, next2.mDestRect.width(), Layout.Alignment.ALIGN_NORMAL, next2.textLineSpacing + 0.9f, 0.0f, false);
                        }
                        int height = (next2.mDestRect.height() - staticLayout.getHeight()) / 2;
                        if (next2.textVerticalAligin.equals("top")) {
                            height = 0;
                        } else if (next2.textVerticalAligin.equals("bottom")) {
                            height = next2.mDestRect.height() - staticLayout.getHeight();
                        }
                        canvas.save();
                        canvas.translate((float) centerX, (float) (height + next2.mDestRect.top));
                        staticLayout.draw(canvas);
                        canvas.restore();
                    } else {
                        if (next2.textOverflow.equals(Constants.Name.ELLIPSIS)) {
                            str = TextUtils.ellipsize(str, textPaint, (float) next2.mDestRect.width(), TextUtils.TruncateAt.END).toString();
                        }
                        Paint.FontMetrics fontMetrics = textPaint.getFontMetrics();
                        float f2 = fontMetrics.top;
                        float f3 = fontMetrics.bottom;
                        int centerY = (int) ((((float) next2.mDestRect.centerY()) - (f2 / 2.0f)) - (f3 / 2.0f));
                        if (next2.textVerticalAligin.equals("top")) {
                            centerY = (int) (((float) next2.mDestRect.top) - f2);
                        } else if (next2.textVerticalAligin.equals("bottom")) {
                            centerY = (int) (((float) next2.mDestRect.bottom) - f3);
                        }
                        canvas.drawText(str, (float) centerX, (float) centerY, textPaint);
                    }
                } else if (next2.type.equals("rect")) {
                    canvas.save();
                    Rect rect2 = next2.mDestRect;
                    int i4 = rect2.left;
                    if (i4 == Integer.MIN_VALUE || (i = rect2.top) == Integer.MIN_VALUE) {
                        int i5 = rect2.top;
                        int i6 = rect2.right;
                        int i7 = rect2.bottom;
                        if (i4 == Integer.MIN_VALUE) {
                            NativeView nativeView2 = NativeView.this;
                            int i8 = (nativeView2.mInnerWidth - (i6 - nativeView2.mInnerLeft)) / 2;
                            i6 += i8;
                            i4 = i8;
                        }
                        if (i5 == Integer.MIN_VALUE) {
                            NativeView nativeView3 = NativeView.this;
                            i5 = (nativeView3.mInnerHeight - (i7 - nativeView3.mInnerTop)) / 2;
                            i7 += i5;
                        }
                        drawRect(canvas, i4, i5, i6, i7, next2);
                    } else {
                        drawRect(canvas, i4, i, rect2.right, rect2.bottom, next2);
                    }
                    canvas.restore();
                }
                canvas.restore();
                i2 = 0;
            }
            canvas.restore();
        }

        /* access modifiers changed from: protected */
        public void onMeasure(int i, int i2) {
            super.onMeasure(i, i2);
            int size = View.MeasureSpec.getSize(i);
            int size2 = View.MeasureSpec.getSize(i2);
            NativeView nativeView = NativeView.this;
            if (!(size == nativeView.mAppScreenWidth && size2 == nativeView.mAppScreenHeight)) {
                nativeView.mAppScreenWidth = size;
                nativeView.mAppScreenHeight = size2;
                nativeView.init();
                Logger.e("NativeView", NativeView.this.mAppScreenWidth + ";onMeasure;" + NativeView.this.mAppScreenHeight);
            }
            NativeView nativeView2 = NativeView.this;
            int i3 = nativeView2.mInnerHeight + nativeView2.mInnerTop;
            int i4 = nativeView2.mAppScreenHeight;
            if (i3 <= i4) {
                i3 = i4;
            }
            nativeView2.mAppScreenHeight = i3;
            nativeView2.measureFitViewParent(false);
            IWebview iWebview = NativeView.this.mWebView;
            if (!(iWebview == null || iWebview.obtainApp() == null)) {
                Iterator<Overlay> it = NativeView.this.mOverlays.iterator();
                while (it.hasNext()) {
                    it.next().parseJson(NativeView.this.mWebView);
                }
            }
            NativeView nativeView3 = NativeView.this;
            setMeasuredDimension(nativeView3.mAppScreenWidth, nativeView3.mAppScreenHeight);
        }

        public boolean onTouchEvent(MotionEvent motionEvent) {
            int actionMasked = motionEvent.getActionMasked();
            NativeView.this.mTouchX = motionEvent.getX();
            NativeView.this.mTouchY = motionEvent.getY();
            NativeView nativeView = NativeView.this;
            if (!nativeView.mIntercept) {
                return false;
            }
            boolean checkTouchRectsContains = nativeView.checkTouchRectsContains(nativeView.mTouchX, nativeView.mTouchY);
            if (actionMasked != 0) {
                if (actionMasked == 1) {
                    this.isTouchDown = false;
                    if (checkTouchRectsContains) {
                        doTypeEvent("touchend");
                    }
                } else if (actionMasked != 2) {
                    if (actionMasked == 3) {
                        this.isTouchDown = false;
                        if (checkTouchRectsContains) {
                            doTypeEvent("touchcancel");
                        }
                    }
                } else if (this.isTouchDown) {
                    doTypeEvent("touchmove");
                }
            } else if (checkTouchRectsContains) {
                this.isTouchDown = true;
                doTypeEvent(AbsoluteConst.EVENTS_WEBVIEW_ONTOUCH_START);
            }
            if (checkTouchRectsContains) {
                if (NativeView.this.mIntercept) {
                    return listenClick() ? super.onTouchEvent(motionEvent) : NativeView.this.mIntercept;
                }
                return false;
            } else if (listenClick()) {
                return false;
            } else {
                return super.onTouchEvent(motionEvent);
            }
        }
    }

    /* access modifiers changed from: package-private */
    public class Overlay {
        private int borderColor;
        private int borderRadius;
        private float borderWidth;
        String callBackId;
        int inputBackgroundColor;
        String inputOnBlurCallBackId;
        String inputOnFocusCallBackId;
        String inputType;
        JSONObject mDestJson;
        Rect mDestRect;
        int mFontColor = -16777216;
        float mFontSize;
        NativeBitmap mNativeBitmap;
        NativeView mNativeView;
        int mRectColor;
        JSONObject mSrcJson;
        Rect mSrcRect;
        JSONObject mStyleJson;
        String mText;
        int margin;
        String placeholder;
        int placeholderColor;
        private float radius;
        boolean textAdapt;
        String textAlign;
        String textDecoration;
        String textFamily;
        float textLineSpacing;
        String textOverflow;
        String textStyle;
        String textTTFPh;
        String textVerticalAligin;
        String textWeight;
        String textWhiteSpace;
        String type;
        IWebview webview;

        Overlay() {
            String str = FrameBitmapView.NORMAL;
            this.textWeight = str;
            this.textStyle = str;
            this.textFamily = "";
            this.textAlign = "center";
            this.textTTFPh = null;
            this.textOverflow = "clip";
            this.textDecoration = "none";
            this.textWhiteSpace = "nowrap";
            this.textVerticalAligin = "middle";
            this.textLineSpacing = 0.2f;
            this.textAdapt = false;
            this.margin = 0;
            this.borderWidth = -1.0f;
            this.borderColor = -1;
            this.borderRadius = 0;
            this.radius = 0.0f;
            this.inputType = "text";
            this.inputBackgroundColor = 0;
            this.placeholder = "";
        }

        /* access modifiers changed from: package-private */
        public void parseJson(IWebview iWebview) {
            int i;
            NativeBitmap nativeBitmap = this.mNativeBitmap;
            if (nativeBitmap != null) {
                this.mSrcRect = NativeView.makeBitmapSrcRect(this.mNativeView, this.mSrcJson, nativeBitmap);
                if (this.mNativeBitmap.isNetWorkBitmap()) {
                    this.mNativeBitmap.initNetworkBitmap(new ImageLoadingListener() {
                        /* class io.dcloud.feature.nativeObj.NativeView.Overlay.AnonymousClass1 */

                        @Override // com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener
                        public void onLoadingCancelled(String str, View view) {
                        }

                        @Override // com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener
                        public void onLoadingComplete(String str, View view, Bitmap bitmap) {
                            NativeBitmap nativeBitmap = Overlay.this.mNativeBitmap;
                            if (nativeBitmap != null) {
                                nativeBitmap.setBitmap(bitmap);
                                Overlay.this.mNativeBitmap.setNetWorkBitmapDownload(true);
                            }
                            NativeView nativeView = Overlay.this.mNativeView;
                            if (nativeView != null && nativeView.getParent() != null) {
                                Overlay overlay = Overlay.this;
                                NativeView nativeView2 = overlay.mNativeView;
                                if (nativeView2.mCanvasView != null) {
                                    overlay.mSrcRect = NativeView.makeBitmapSrcRect(nativeView2, overlay.mSrcJson, overlay.mNativeBitmap);
                                    Overlay overlay2 = Overlay.this;
                                    overlay2.mDestRect = NativeView.this.makeRect(overlay2.mNativeView, overlay2.mDestJson, this);
                                    if (Overlay.this.mNativeBitmap.isGif()) {
                                        NativeView.this.addGifImagview(this);
                                    } else {
                                        Overlay.this.mNativeView.mCanvasView.invalidate();
                                    }
                                }
                            }
                        }

                        @Override // com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener
                        public void onLoadingFailed(String str, View view, FailReason failReason) {
                        }

                        @Override // com.nostra13.dcloudimageloader.core.assist.ImageLoadingListener
                        public void onLoadingStarted(String str, View view) {
                        }
                    });
                }
            }
            JSONObject jSONObject = this.mStyleJson;
            if (jSONObject != null) {
                String optString = jSONObject.optString("color");
                if (!TextUtils.isEmpty(optString) && !optString.equals("null")) {
                    try {
                        this.mFontColor = Color.parseColor(optString);
                    } catch (Exception unused) {
                        this.mFontColor = PdrUtil.stringToColor(optString);
                    }
                }
                String optString2 = this.mStyleJson.optString(AbsoluteConst.JSON_KEY_SIZE);
                String str = "16px";
                if (TextUtils.isEmpty(optString2)) {
                    optString2 = str;
                }
                NativeView nativeView = this.mNativeView;
                this.mFontSize = (float) PdrUtil.convertToScreenInt(optString2, nativeView.mInnerWidth, 0, nativeView.mCreateScale);
                this.textWeight = this.mStyleJson.optString("weight", this.textWeight);
                this.textStyle = this.mStyleJson.optString("style", this.textStyle);
                this.textFamily = this.mStyleJson.optString(IjkMediaPlayer.OnNativeInvokeListener.ARG_FAMILIY, this.textFamily);
                this.textAlign = this.mStyleJson.optString(AbsoluteConst.JSON_KEY_ALIGN, this.textAlign);
                this.textOverflow = this.mStyleJson.optString(Constants.Name.OVERFLOW, this.textOverflow);
                this.textDecoration = this.mStyleJson.optString("decoration", this.textDecoration);
                this.textWhiteSpace = this.mStyleJson.optString("whiteSpace", this.textWhiteSpace);
                this.textVerticalAligin = this.mStyleJson.optString(AbsoluteConst.JSON_KEY_VERTICAL_ALIGN, this.textVerticalAligin);
                String str2 = "0px";
                if (this.mStyleJson.has(Constants.Name.BORDER_WIDTH)) {
                    String optString3 = this.mStyleJson.optString(Constants.Name.BORDER_WIDTH);
                    if (TextUtils.isEmpty(optString3)) {
                        optString3 = str2;
                    }
                    NativeView nativeView2 = this.mNativeView;
                    this.borderWidth = (float) PdrUtil.convertToScreenInt(optString3, nativeView2.mInnerWidth, 0, nativeView2.mCreateScale);
                }
                this.borderColor = this.mRectColor;
                if (this.mStyleJson.has(Constants.Name.BORDER_COLOR)) {
                    this.borderColor = PdrUtil.stringToColor(this.mStyleJson.optString(Constants.Name.BORDER_COLOR));
                }
                if (this.mStyleJson.has("radius")) {
                    String optString4 = this.mStyleJson.optString("radius");
                    if (TextUtils.isEmpty(optString4)) {
                        optString4 = str2;
                    }
                    NativeView nativeView3 = this.mNativeView;
                    this.radius = (float) PdrUtil.convertToScreenInt(optString4, nativeView3.mInnerWidth, 0, nativeView3.mCreateScale);
                }
                if (this.mStyleJson.has("lineSpacing")) {
                    this.textLineSpacing = ((float) PdrUtil.convertToScreenInt(this.mStyleJson.optString("lineSpacing"), (int) this.mFontSize, 0, this.mNativeView.mCreateScale)) / this.mFontSize;
                }
                if (this.mStyleJson.has("fontSrc")) {
                    String optString5 = this.mStyleJson.optString("fontSrc", "");
                    if (optString5.contains("__wap2app.ttf")) {
                        String str3 = BaseInfo.sBaseWap2AppTemplatePath + "wap2app__template/__wap2app.ttf";
                        if (new File(str3).exists()) {
                            this.textTTFPh = str3;
                        } else {
                            this.textTTFPh = iWebview.obtainApp().convert2AbsFullPath(iWebview.obtainFullUrl(), optString5);
                        }
                    } else {
                        this.textTTFPh = iWebview.obtainApp().convert2AbsFullPath(iWebview.obtainFullUrl(), optString5);
                    }
                }
                String optString6 = this.mStyleJson.optString("margin", str2);
                NativeView nativeView4 = this.mNativeView;
                this.margin = PdrUtil.convertToScreenInt(optString6, nativeView4.mInnerWidth, 0, nativeView4.mCreateScale);
                if ("input".equals(this.type)) {
                    this.inputType = "text";
                    if (this.mStyleJson.has("type")) {
                        String optString7 = this.mStyleJson.optString("type");
                        if (!TextUtils.isEmpty(optString7)) {
                            this.inputType = optString7;
                        }
                    }
                    this.placeholderColor = -7829368;
                    this.placeholder = "";
                    if (this.mStyleJson.has(Constants.Name.PLACEHOLDER)) {
                        this.placeholder = this.mStyleJson.optString(Constants.Name.PLACEHOLDER);
                    }
                    if (this.mStyleJson.has(Constants.Name.FONT_SIZE)) {
                        String optString8 = this.mStyleJson.optString(Constants.Name.FONT_SIZE);
                        if (!TextUtils.isEmpty(optString8)) {
                            str = optString8;
                        }
                        NativeView nativeView5 = this.mNativeView;
                        this.mFontSize = (float) PdrUtil.convertToScreenInt(str, nativeView5.mInnerWidth, 0, nativeView5.mCreateScale);
                    }
                    this.mFontColor = -16777216;
                    if (this.mStyleJson.has("fontColor")) {
                        String optString9 = this.mStyleJson.optString("fontColor");
                        if (!TextUtils.isEmpty(optString9)) {
                            if (Pattern.compile("^#[0-9a-fA-F]{6}$").matcher(optString9).matches()) {
                                this.mFontSize = (float) PdrUtil.stringToColor(optString9);
                            }
                            if (Pattern.compile("^rgba\\(((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\,){3}([0-1]{1}|0\\.[1-9]{1})\\)$").matcher(optString9).matches()) {
                                this.mFontSize = (float) PdrUtil.stringToColor(optString9);
                            }
                        }
                    }
                    this.inputBackgroundColor = 0;
                    if (this.mStyleJson.has("backgroundColor")) {
                        String optString10 = this.mStyleJson.optString("backgroundColor");
                        if (!TextUtils.isEmpty(optString10)) {
                            if (Pattern.compile("^#[0-9a-fA-F]{6}$").matcher(optString10).matches()) {
                                this.inputBackgroundColor = PdrUtil.stringToColor(optString10);
                            }
                            if (Pattern.compile("^rgba\\(((2[0-4]\\d|25[0-5]|[01]?\\d\\d?)\\,){3}([0-1]{1}|0\\.[1-9]{1})\\)$").matcher(optString10).matches()) {
                                this.inputBackgroundColor = PdrUtil.stringToColor(optString10);
                            }
                        }
                    }
                    this.borderColor = -16777216;
                    if (this.mStyleJson.has(Constants.Name.BORDER_COLOR)) {
                        String optString11 = this.mStyleJson.optString(Constants.Name.BORDER_COLOR);
                        if (!TextUtils.isEmpty(optString11) && Pattern.compile("^#[0-9a-fA-F]{6}$").matcher(optString11).matches()) {
                            this.borderColor = PdrUtil.stringToColor(optString11);
                        }
                    }
                    NativeView nativeView6 = this.mNativeView;
                    String str4 = "1px";
                    this.borderWidth = (float) PdrUtil.convertToScreenInt(str4, nativeView6.mInnerWidth, 0, nativeView6.mCreateScale);
                    if (this.mStyleJson.has(Constants.Name.BORDER_WIDTH)) {
                        String optString12 = this.mStyleJson.optString(Constants.Name.BORDER_WIDTH);
                        if (!TextUtils.isEmpty(optString12) && Pattern.compile("^[1-9]\\d*px$").matcher(optString12).matches()) {
                            try {
                                if (!TextUtils.isEmpty(optString12)) {
                                    str4 = optString12;
                                }
                                NativeView nativeView7 = this.mNativeView;
                                this.borderWidth = (float) PdrUtil.convertToScreenInt(str4, nativeView7.mInnerWidth, 0, nativeView7.mCreateScale);
                            } catch (Exception unused2) {
                            }
                        }
                    }
                    this.borderRadius = 0;
                    if (this.mStyleJson.has(Constants.Name.BORDER_RADIUS)) {
                        String optString13 = this.mStyleJson.optString(Constants.Name.BORDER_RADIUS);
                        if (!TextUtils.isEmpty(optString13) && Pattern.compile("^[1-9]\\d*px$").matcher(optString13).matches()) {
                            try {
                                if (!TextUtils.isEmpty(optString13)) {
                                    str2 = optString13;
                                }
                                NativeView nativeView8 = this.mNativeView;
                                this.borderRadius = PdrUtil.convertToScreenInt(str2, nativeView8.mInnerWidth, 0, nativeView8.mCreateScale);
                            } catch (Exception unused3) {
                            }
                        }
                    }
                    if (this.mStyleJson.has("__onCompleteCallBackId__")) {
                        this.callBackId = this.mStyleJson.optString("__onCompleteCallBackId__");
                        this.mStyleJson.remove("__onCompleteCallBackId__");
                    } else if (this.mStyleJson.has("onComplete")) {
                        String optString14 = this.mStyleJson.optString("onComplete");
                        if (optString14.startsWith(AbsoluteConst.PROTOCOL_JAVASCRIPT) || optString14.startsWith("javaScript:")) {
                            this.callBackId = optString14;
                        }
                    }
                    if (this.mStyleJson.has("__onFocusCallBackId__")) {
                        this.inputOnFocusCallBackId = this.mStyleJson.optString("__onFocusCallBackId__");
                        this.mStyleJson.remove("__onFocusCallBackId__");
                    } else if (this.mStyleJson.has("onFocus")) {
                        String optString15 = this.mStyleJson.optString("onFocus");
                        if (optString15.startsWith(AbsoluteConst.PROTOCOL_JAVASCRIPT) || optString15.startsWith("javaScript:")) {
                            this.inputOnFocusCallBackId = optString15;
                        }
                    }
                    if (this.mStyleJson.has("__onBlurCallBackId__")) {
                        this.inputOnBlurCallBackId = this.mStyleJson.optString("__onBlurCallBackId__");
                        this.mStyleJson.remove("__onBlurCallBackId__");
                    } else if (this.mStyleJson.has("onBlur")) {
                        String optString16 = this.mStyleJson.optString("onBlur");
                        if (optString16.startsWith(AbsoluteConst.PROTOCOL_JAVASCRIPT) || optString16.startsWith("javaScript:")) {
                            this.inputOnBlurCallBackId = optString16;
                        }
                    }
                }
            }
            Rect makeRect = NativeView.this.makeRect(this.mNativeView, this.mDestJson, this);
            this.mDestRect = makeRect;
            if (makeRect != null && (i = this.margin) != 0) {
                makeRect.left += i;
                makeRect.top += i;
                makeRect.right -= i;
                makeRect.bottom -= i;
            }
        }
    }

    public NativeView(Context context, IWebview iWebview, String str, String str2, JSONObject jSONObject) {
        super(context);
        this.mCanvasView = new NativeCanvasView(context);
        setWillNotDraw(false);
        IApp obtainApp = iWebview.obtainApp();
        this.mApp = obtainApp;
        int statusBarDefaultColor = obtainApp.obtainStatusBarMgr().getStatusBarDefaultColor();
        if (statusBarDefaultColor != 0) {
            this.mStatusColor = statusBarDefaultColor;
        }
        this.mWebView = iWebview;
        this.mCreateScale = iWebview.getScale();
        this.mUUID = str;
        this.mID = str2;
        this.mStyle = jSONObject;
        this.isImmersed = this.mApp.obtainStatusBarMgr().checkImmersedStatusBar(this.mApp.getActivity(), Boolean.valueOf(this.mApp.obtainConfigProperty(AbsoluteConst.JSONKEY_STATUSBAR_IMMERSED)).booleanValue());
        setLayoutParams(new ViewGroup.LayoutParams(-2, -2));
        attachCanvasView();
        initScreenData();
        try {
            float optDouble = (float) jSONObject.optDouble("opacity", 1.0d);
            if (Build.VERSION.SDK_INT >= 11) {
                setAlpha(optDouble);
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void UpdateRegionData() {
        if (this.mRegionRect != null) {
            askRegionJson();
            RectF rectF = this.mRegionRect;
            rectF.left = (float) this.mRegionLeft;
            rectF.right = (float) (this.mAppScreenWidth - this.mRegionRight);
            rectF.top = (float) (this.mRegionTop + this.mInnerTop);
            rectF.bottom = (float) (this.mInnerBottom - this.mRegionBottom);
        }
    }

    private void askRegionJson() {
        JSONObject jSONObject = this.mRegionJson;
        if (jSONObject != null) {
            this.mRegionLeft = PdrUtil.convertToScreenInt(jSONObject.optString("left"), this.mInnerWidth, 0, this.mCreateScale);
            this.mRegionRight = PdrUtil.convertToScreenInt(this.mRegionJson.optString("right"), this.mInnerWidth, 0, this.mCreateScale);
            this.mRegionTop = PdrUtil.convertToScreenInt(this.mRegionJson.optString("top"), this.mInnerHeight, 0, this.mCreateScale);
            this.mRegionBottom = PdrUtil.convertToScreenInt(this.mRegionJson.optString("bottom"), this.mInnerHeight, 0, this.mCreateScale);
        }
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private boolean checkTouchRectsContains(float f, float f2) {
        ArrayList<RectF> arrayList = this.mTouchRects;
        boolean z = false;
        if (arrayList != null && arrayList.size() > 0) {
            Iterator<RectF> it = this.mTouchRects.iterator();
            while (it.hasNext()) {
                if (it.next().contains(f, f2)) {
                    z = true;
                }
            }
        }
        return z;
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void endAnimatecallback(IWebview iWebview, String str) {
        if (!TextUtils.isEmpty(str)) {
            Deprecated_JSUtil.execCallback(iWebview, str, null, JSUtil.OK, false, false);
        }
    }

    private int getDrawLeft(int i) {
        return this.mInnerLeft + i;
    }

    private int getDrawTop(int i) {
        return this.mInnerTop + i;
    }

    private EditText getInputById(String str) {
        if (TextUtils.isEmpty(str)) {
            return null;
        }
        for (int childCount = getChildCount() - 1; childCount >= 0; childCount--) {
            View childAt = getChildAt(childCount);
            if (childAt != null && (childAt instanceof EditText) && childAt.getTag() != null && childAt.getTag().toString().equals(str)) {
                return (EditText) childAt;
            }
        }
        return null;
    }

    private void initScreenData() {
        int i;
        int i2;
        IApp iApp = this.mApp;
        if (iApp != null) {
            View obtainMainView = iApp.obtainWebAppRootView() != null ? this.mApp.obtainWebAppRootView().obtainMainView() : null;
            if (obtainMainView == null) {
                Object invokeMethod = PlatformUtil.invokeMethod("io.dcloud.appstream.actionbar.StreamAppActionBarUtil", "isTitlebarVisible", null, new Class[]{Activity.class, String.class}, new Object[]{this.mApp.getActivity(), this.mApp.obtainAppId()});
                if (invokeMethod instanceof Boolean ? Boolean.valueOf(invokeMethod.toString()).booleanValue() : false) {
                    Object invokeMethod2 = PlatformUtil.invokeMethod("io.dcloud.appstream.actionbar.StreamAppActionBarUtil", "getTitlebarHeightPx", null, new Class[]{Activity.class}, new Object[]{this.mApp.getActivity()});
                    if (invokeMethod2 instanceof Integer) {
                        i2 = Integer.valueOf(invokeMethod2.toString()).intValue();
                        i = i2;
                        obtainMainView = this.mApp.getActivity().getWindow().getDecorView().findViewById(16908290);
                    }
                }
                i2 = 0;
                i = i2;
                obtainMainView = this.mApp.getActivity().getWindow().getDecorView().findViewById(16908290);
            } else {
                i = 0;
            }
            if (obtainMainView != null) {
                this.mApp.getActivity().getWindowManager();
                int i3 = this.mApp.getInt(0);
                this.mAppScreenHeight = this.mApp.getInt(1) - i;
                this.mAppScreenWidth = i3 - i;
                init();
            }
        }
    }

    static Rect makeBitmapSrcRect(NativeView nativeView, JSONObject jSONObject, NativeBitmap nativeBitmap) {
        Rect rect = new Rect();
        if (nativeBitmap.getBitmap() == null) {
            return rect;
        }
        int width = nativeBitmap.getBitmap().getWidth();
        int height = nativeBitmap.getBitmap().getHeight();
        if (jSONObject != null) {
            int convertToScreenInt = PdrUtil.convertToScreenInt(jSONObject.optString("bottom"), height, 0, 1.0f);
            int convertToScreenInt2 = PdrUtil.convertToScreenInt(jSONObject.optString("right"), width, 0, 1.0f);
            int convertToScreenInt3 = PdrUtil.convertToScreenInt(jSONObject.optString("left"), width, 0, 1.0f);
            int convertToScreenInt4 = PdrUtil.convertToScreenInt(jSONObject.optString("top"), height, 0, 1.0f);
            if (convertToScreenInt2 == 0 || (jSONObject.has("width") && jSONObject.has("left"))) {
                rect.left = PdrUtil.convertToScreenInt(jSONObject.optString("left"), width, convertToScreenInt3, 1.0f);
                int convertToScreenInt5 = PdrUtil.convertToScreenInt(jSONObject.optString("width"), width, width, 1.0f) + rect.left;
                rect.right = convertToScreenInt5;
                if (convertToScreenInt5 <= width) {
                    width = convertToScreenInt5;
                }
                rect.right = width;
            } else {
                rect.right = width - convertToScreenInt2;
                if (jSONObject.has("width")) {
                    rect.left = rect.right - PdrUtil.convertToScreenInt(jSONObject.optString("width"), width, width, 1.0f);
                } else if (jSONObject.has("left")) {
                    rect.left = PdrUtil.convertToScreenInt(jSONObject.optString("left"), width, convertToScreenInt3, 1.0f);
                } else {
                    rect.left = convertToScreenInt3;
                }
            }
            if (convertToScreenInt == 0 || (jSONObject.has("height") && jSONObject.has("top"))) {
                rect.top = PdrUtil.convertToScreenInt(jSONObject.optString("top"), height, convertToScreenInt4, 1.0f);
                int convertToScreenInt6 = PdrUtil.convertToScreenInt(jSONObject.optString("height"), height, height, 1.0f) + rect.top;
                rect.bottom = convertToScreenInt6;
                if (convertToScreenInt6 <= height) {
                    height = convertToScreenInt6;
                }
                rect.bottom = height;
            } else {
                rect.bottom = height - convertToScreenInt;
                if (jSONObject.has("height")) {
                    rect.top = convertToScreenInt - PdrUtil.convertToScreenInt(jSONObject.optString("height"), height, height, 1.0f);
                } else if (jSONObject.has("top")) {
                    rect.top = PdrUtil.convertToScreenInt(jSONObject.optString("top"), height, convertToScreenInt4, 1.0f);
                } else {
                    rect.top = convertToScreenInt4;
                }
            }
        } else {
            rect.left = 0;
            rect.top = 0;
            rect.right = width;
            rect.bottom = height;
        }
        return rect;
    }

    private void measureGifImageview(int i) {
        for (int i2 = 0; i2 < getChildCount(); i2++) {
            View childAt = getChildAt(i2);
            if (childAt instanceof GifImageView) {
                GifImageView gifImageView = (GifImageView) childAt;
                if (gifImageView.getTag() != null) {
                    FrameLayout.LayoutParams layoutParams = (FrameLayout.LayoutParams) gifImageView.getLayoutParams();
                    Rect rect = ((Overlay) gifImageView.getTag()).mDestRect;
                    int i3 = rect.top;
                    if (i3 != Integer.MIN_VALUE) {
                        layoutParams.topMargin = i3 + i;
                    } else {
                        int i4 = rect.bottom;
                        layoutParams.height = i4;
                        layoutParams.topMargin = ((this.mInnerHeight - i4) + this.mInnerTop) / 2;
                    }
                }
            }
        }
    }

    private int pxFromDp(int i) {
        return (int) TypedValue.applyDimension(1, (float) i, getResources().getDisplayMetrics());
    }

    /* access modifiers changed from: private */
    /* access modifiers changed from: public */
    private void runDrawRectF(final IWebview iWebview, final String str, final int i, final int i2, final int i3, final int i4, final int i5, final int i6, final int i7, final int i8, final int i9) {
        if (!this.isAnimate) {
            endAnimatecallback(iWebview, str);
            return;
        }
        if (this.mRegionRect == null) {
            this.mRegionRect = new RectF();
        }
        RectF rectF = this.mRegionRect;
        rectF.left = (float) i;
        rectF.right = (float) (this.mAppScreenWidth - i2);
        float f = (float) i3;
        rectF.top = f;
        if (i9 == i7) {
            rectF.bottom = (float) ((i6 * i9) + i3 + i8);
        } else {
            rectF.bottom = (float) ((i6 * i9) + i3);
        }
        if (this.isStatusBar) {
            float f2 = (float) DeviceInfo.sStatusBarHeight;
            rectF.top = f + f2;
            rectF.bottom += f2;
        }
        postDelayed(new Runnable() {
            /* class io.dcloud.feature.nativeObj.NativeView.AnonymousClass4 */

            public void run() {
                NativeView.this.invalidate();
                int i = i9;
                int i2 = i7;
                if (i == i2) {
                    NativeView.this.endAnimatecallback(iWebview, str);
                } else {
                    NativeView.this.runDrawRectF(iWebview, str, i, i2, i3, i4, i5, i6, i2, i8, i + 1);
                }
            }
        }, (long) i5);
    }

    private void viewPostResize(final View view, final ViewGroup.LayoutParams layoutParams, final int i, final int i2, final int i3, final int i4) {
        view.post(new Runnable() {
            /* class io.dcloud.feature.nativeObj.NativeView.AnonymousClass3 */

            public void run() {
                ViewGroup.LayoutParams layoutParams = layoutParams;
                layoutParams.height = i2;
                layoutParams.width = i;
                view.setLayoutParams(layoutParams);
                ViewHelper.setY(view, (float) i4);
                ViewHelper.setX(view, (float) i3);
            }
        });
    }

    public void StartAnimate(IWebview iWebview, String str, String str2) throws Exception {
        if (this.isWebAnimationRuning || TextUtils.isEmpty(str)) {
            return;
        }
        if (getParent() == null) {
            endAnimatecallback(iWebview, str2);
            return;
        }
        this.isAnimate = true;
        JSONObject jSONObject = new JSONObject(str);
        String optString = jSONObject.optString("type");
        int optInt = jSONObject.optInt("duration", 200);
        int optInt2 = jSONObject.optInt("frames", 12);
        this.mRegionJson = jSONObject.optJSONObject("region");
        askRegionJson();
        int i = optInt / optInt2;
        int i2 = this.mInnerBottom - ((this.mRegionTop + this.mInnerTop) + this.mRegionBottom);
        int i3 = i2 / optInt2;
        int i4 = i2 - (i3 * optInt2);
        if (!TextUtils.isEmpty(optString) && optString.equals("shrink")) {
            runDrawRectF(iWebview, str2, this.mRegionLeft, this.mRegionRight, this.mInnerTop + this.mRegionTop, this.mInnerBottom - this.mRegionBottom, i, i3, optInt2, i4, 1);
        }
    }

    public void addEventListener(String str, IWebview iWebview, String str2) {
        this.mCanvasView.addEventListener(str, iWebview, str2);
    }

    public void addGifImagview(Overlay overlay) {
        GifDrawable gifDrawable = overlay.mNativeBitmap.getGifDrawable();
        if (gifDrawable != null) {
            GifImageView gifImageView = new GifImageView(this.mApp.getActivity());
            gifImageView.setImageDrawable(gifDrawable);
            gifImageView.setTag(overlay);
            int i = 0;
            if (this.isStatusBar) {
                i = DeviceInfo.sStatusBarHeight / 2;
            }
            FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(overlay.mDestRect.width(), overlay.mDestRect.height());
            Rect rect = overlay.mDestRect;
            int i2 = rect.left;
            if (i2 != Integer.MIN_VALUE) {
                layoutParams.leftMargin = i2;
            } else {
                int i3 = rect.right;
                layoutParams.width = i3;
                layoutParams.leftMargin = ((this.mInnerWidth - i3) + this.mInnerLeft) / 2;
            }
            int i4 = rect.top;
            if (i4 != Integer.MIN_VALUE) {
                layoutParams.topMargin = i4 + i;
            } else {
                int i5 = rect.bottom;
                layoutParams.height = i5;
                layoutParams.topMargin = ((this.mInnerHeight - i5) + this.mInnerTop) / 2;
            }
            addView(gifImageView, layoutParams);
            requestLayout();
            invalidate();
            NativeCanvasView nativeCanvasView = this.mCanvasView;
            if (nativeCanvasView != null) {
                nativeCanvasView.requestLayout();
                this.mCanvasView.invalidate();
            }
        }
    }

    public void addInput(final Overlay overlay, final String str) {
        EditText inputById = getInputById(str);
        if (inputById == null) {
            inputById = new EditText(this.mApp.getActivity());
            inputById.setTag(str);
            if (Build.VERSION.SDK_INT >= 14) {
                inputById.setGravity(8388627);
            } else {
                inputById.setGravity(19);
            }
            inputById.setSingleLine();
        }
        int i = 1;
        inputById.setImeOptions(1);
        if (!"text".equals(overlay.inputType)) {
            if ("email".equals(overlay.inputType)) {
                if (Build.VERSION.SDK_INT >= 11) {
                    i = 33;
                }
            } else if ("number".equals(overlay.inputType)) {
                i = 2;
            } else if ("search".equals(overlay.inputType)) {
                inputById.setImeOptions(3);
            } else if (Constants.Value.TEL.equals(overlay.inputType)) {
                i = 3;
            } else if ("url".equals(overlay.inputType)) {
                i = 17;
                inputById.setImeOptions(2);
            }
        }
        inputById.setInputType(i);
        inputById.getPaint().setTextSize(overlay.mFontSize);
        inputById.setTextColor(overlay.mFontColor);
        inputById.setHint(overlay.placeholder);
        inputById.setHintTextColor(overlay.placeholderColor);
        int i2 = (int) overlay.borderWidth;
        GradientDrawable gradientDrawable = new GradientDrawable();
        gradientDrawable.setColor(overlay.inputBackgroundColor);
        int i3 = 0;
        gradientDrawable.setShape(0);
        gradientDrawable.setStroke(i2, overlay.borderColor);
        gradientDrawable.setCornerRadius((float) overlay.borderRadius);
        int i4 = overlay.borderRadius + i2;
        inputById.setPadding(i4, i2, i4, i2);
        if (Build.VERSION.SDK_INT >= 16) {
            inputById.setBackground(gradientDrawable);
        } else {
            inputById.setBackgroundDrawable(gradientDrawable);
        }
        inputById.setOnEditorActionListener(new TextView.OnEditorActionListener() {
            /* class io.dcloud.feature.nativeObj.NativeView.AnonymousClass6 */

            public boolean onEditorAction(TextView textView, int i, KeyEvent keyEvent) {
                String str;
                IFrameView iFrameView;
                if ((i == 4 || i == 6 || i == 3 || i == 2 || (keyEvent != null && 66 == keyEvent.getKeyCode() && keyEvent.getAction() == 0)) && !TextUtils.isEmpty(overlay.callBackId)) {
                    if (overlay.callBackId.toLowerCase(Locale.ENGLISH).startsWith(AbsoluteConst.PROTOCOL_JAVASCRIPT)) {
                        AbsMgr absMgr = null;
                        String obtainAppId = NativeView.this.mApp.obtainAppId();
                        IWebview iWebview = NativeView.this.mWebView;
                        if (!(iWebview == null || iWebview.obtainFrameView() == null)) {
                            absMgr = NativeView.this.mWebView.obtainFrameView().obtainWindowMgr();
                        }
                        if (absMgr == null && (iFrameView = NativeView.this.mFrameViewParent) != null) {
                            absMgr = iFrameView.obtainWindowMgr();
                        }
                        if (absMgr != null) {
                            Object processEvent = absMgr.processEvent(IMgr.MgrType.WindowMgr, 47, obtainAppId);
                            if (processEvent instanceof IFrameView) {
                                IFrameView iFrameView2 = (IFrameView) processEvent;
                                if (!(iFrameView2.obtainWebView() == null || iFrameView2.obtainWebView().obtainWindowView() == null)) {
                                    iFrameView2.obtainWebView().loadUrl(overlay.callBackId);
                                    return true;
                                }
                            }
                        }
                        IWebview iWebview2 = overlay.webview;
                        if (iWebview2 == null || iWebview2.obtainWindowView() == null) {
                            IWebview iWebview3 = NativeView.this.mWebView;
                            if (!(iWebview3 == null || iWebview3.obtainWindowView() == null)) {
                                NativeView.this.mWebView.loadUrl(overlay.callBackId);
                                return true;
                            }
                        } else {
                            Overlay overlay = overlay;
                            overlay.webview.loadUrl(overlay.callBackId);
                            return true;
                        }
                    }
                    if (overlay.webview != null) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("{\"text\":\"");
                        sb.append((Object) textView.getText());
                        sb.append("\",\"id\":");
                        if (!TextUtils.isEmpty(str)) {
                            str = JSUtil.QUOTE + str + JSUtil.QUOTE;
                        } else {
                            str = "\"\"";
                        }
                        sb.append(str);
                        sb.append(Operators.BLOCK_END_STR);
                        String sb2 = sb.toString();
                        Overlay overlay2 = overlay;
                        Deprecated_JSUtil.execCallback(overlay2.webview, overlay2.callBackId, sb2, JSUtil.OK, true, true);
                        if (overlay.webview.getOpener() != null) {
                            Deprecated_JSUtil.execCallback(overlay.webview.getOpener(), overlay.callBackId, sb2, JSUtil.OK, true, true);
                        }
                    }
                }
                return true;
            }
        });
        inputById.setOnFocusChangeListener(new View.OnFocusChangeListener() {
            /* class io.dcloud.feature.nativeObj.NativeView.AnonymousClass7 */

            public void onFocusChange(View view, boolean z) {
                String str;
                String str2;
                IFrameView iFrameView;
                StringBuilder sb = new StringBuilder();
                sb.append("{\"id\":");
                if (!TextUtils.isEmpty(str)) {
                    str = JSUtil.QUOTE + str + JSUtil.QUOTE;
                } else {
                    str = "\"\"";
                }
                sb.append(str);
                sb.append(Operators.BLOCK_END_STR);
                String sb2 = sb.toString();
                if (z) {
                    str2 = overlay.inputOnFocusCallBackId;
                } else {
                    str2 = overlay.inputOnBlurCallBackId;
                }
                if (!TextUtils.isEmpty(str2)) {
                    if (str2.toLowerCase(Locale.ENGLISH).startsWith(AbsoluteConst.PROTOCOL_JAVASCRIPT)) {
                        AbsMgr absMgr = null;
                        String obtainAppId = NativeView.this.mApp.obtainAppId();
                        IWebview iWebview = NativeView.this.mWebView;
                        if (!(iWebview == null || iWebview.obtainFrameView() == null)) {
                            absMgr = NativeView.this.mWebView.obtainFrameView().obtainWindowMgr();
                        }
                        if (absMgr == null && (iFrameView = NativeView.this.mFrameViewParent) != null) {
                            absMgr = iFrameView.obtainWindowMgr();
                        }
                        if (absMgr != null) {
                            Object processEvent = absMgr.processEvent(IMgr.MgrType.WindowMgr, 47, obtainAppId);
                            if (processEvent instanceof IFrameView) {
                                IFrameView iFrameView2 = (IFrameView) processEvent;
                                if (!(iFrameView2.obtainWebView() == null || iFrameView2.obtainWebView().obtainWindowView() == null)) {
                                    iFrameView2.obtainWebView().loadUrl(str2);
                                    return;
                                }
                            }
                        }
                        IWebview iWebview2 = overlay.webview;
                        if (iWebview2 == null || iWebview2.obtainWindowView() == null) {
                            IWebview iWebview3 = NativeView.this.mWebView;
                            if (!(iWebview3 == null || iWebview3.obtainWindowView() == null)) {
                                NativeView.this.mWebView.loadUrl(str2);
                                return;
                            }
                        } else {
                            overlay.webview.loadUrl(str2);
                            return;
                        }
                    }
                    IWebview iWebview4 = overlay.webview;
                    if (iWebview4 != null) {
                        Deprecated_JSUtil.execCallback(iWebview4, str2, sb2, JSUtil.OK, true, true);
                        if (overlay.webview.getOpener() != null) {
                            Deprecated_JSUtil.execCallback(overlay.webview.getOpener(), str2, sb2, JSUtil.OK, true, true);
                        }
                    }
                }
            }
        });
        if (this.isStatusBar) {
            i3 = DeviceInfo.sStatusBarHeight;
        }
        FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(overlay.mDestRect.width(), overlay.mDestRect.height());
        Rect rect = overlay.mDestRect;
        int i5 = rect.left;
        if (i5 != Integer.MIN_VALUE) {
            layoutParams.leftMargin = i5;
        } else {
            int i6 = rect.right;
            layoutParams.width = i6;
            layoutParams.leftMargin = ((this.mInnerWidth - i6) + this.mInnerLeft) / 2;
        }
        int i7 = rect.top;
        if (i7 != Integer.MIN_VALUE) {
            layoutParams.topMargin = i7 + i3;
        } else {
            int i8 = rect.bottom;
            layoutParams.height = i8;
            layoutParams.topMargin = ((this.mInnerHeight - i8) + this.mInnerTop) / 2;
        }
        addView(inputById, layoutParams);
        requestLayout();
        invalidate();
        NativeCanvasView nativeCanvasView = this.mCanvasView;
        if (nativeCanvasView != null) {
            nativeCanvasView.requestLayout();
            this.mCanvasView.invalidate();
        }
    }

    /* access modifiers changed from: protected */
    public void attachCanvasView() {
        if (this.mCanvasView.getParent() != null) {
            ((ViewGroup) this.mCanvasView.getParent()).removeView(this.mCanvasView);
        }
        addView(this.mCanvasView, new FrameLayout.LayoutParams(-1, -2));
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public void attachToViewGroup(IFrameView iFrameView) {
        if (!this.mAttached) {
            this.mFrameViewParent = iFrameView;
            if (iFrameView instanceof AdaFrameView) {
                ((AdaFrameView) iFrameView).addNativeViewChild(this);
            }
            final String obtainAppId = iFrameView.obtainApp().obtainAppId();
            AnonymousClass2 r1 = new IEventCallback() {
                /* class io.dcloud.feature.nativeObj.NativeView.AnonymousClass2 */

                @Override // io.dcloud.common.DHInterface.IEventCallback
                public Object onCallBack(String str, Object obj) {
                    if (TextUtils.equals(str, AbsoluteConst.EVENTS_CLOSE)) {
                        FeatureImpl.destroyNativeView(obtainAppId, NativeView.this);
                        PlatformUtil.invokeMethod("io.dcloud.feature.ad.AdFlowFeatureImpl", "destroyNativeView", null, new Class[]{String.class, NativeView.class}, new Object[]{obtainAppId, NativeView.this});
                    } else {
                        TextUtils.equals(str, AbsoluteConst.EVENTS_FRAME_ONRESIZE);
                    }
                    return null;
                }
            };
            this.mIEventCallback = r1;
            iFrameView.addFrameViewListener(r1);
            ViewParent parent = getParent();
            if (parent != null) {
                ((ViewGroup) parent).removeView(this);
                setVisibility(0);
            }
            measureFitViewParent(true);
            this.mShow = true;
            this.mAttached = true;
        }
    }

    public void clearAnimate() {
        this.isAnimate = false;
        this.mRegionRect = null;
        this.mRegionJson = null;
        invalidate();
        NativeCanvasView nativeCanvasView = this.mCanvasView;
        if (nativeCanvasView != null) {
            nativeCanvasView.requestLayout();
            this.mCanvasView.invalidate();
        }
    }

    public void clearNativeViewData() {
        IFrameView iFrameView = this.mFrameViewParent;
        if (iFrameView != null && (iFrameView instanceof AdaFrameView)) {
            ((AdaFrameView) iFrameView).removeNativeViewChild(this);
        }
        postDelayed(new Runnable() {
            /* class io.dcloud.feature.nativeObj.NativeView.AnonymousClass5 */

            public void run() {
                try {
                    NativeView.this.setVisibility(8);
                    if (NativeView.this.getParent() != null) {
                        ((ViewGroup) NativeView.this.getParent()).removeView(NativeView.this);
                    }
                    NativeView.this.clearViewData();
                    NativeView.this.mFrameViewParent = null;
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }, (long) 200);
    }

    public void clearViewData() {
        NativeBitmap nativeBitmap;
        Iterator<Overlay> it = this.mOverlays.iterator();
        while (it.hasNext()) {
            Overlay next = it.next();
            if (next.type.equals(WXBasicComponentType.IMG) && (nativeBitmap = next.mNativeBitmap) != null && nativeBitmap.getBitmap() != null && !next.mNativeBitmap.isRecycled()) {
                next.mNativeBitmap.recycle(true);
            }
        }
        this.mOverlays.clear();
        this.mOverlayMaps.clear();
        this.mChildViewMaps.clear();
    }

    /* access modifiers changed from: protected */
    public void configurationCange() {
    }

    /* access modifiers changed from: package-private */
    public RectF createTouchRect(JSONObject jSONObject) {
        RectF rectF = new RectF(makeRect(this, jSONObject, null));
        float f = rectF.left;
        if (f != -2.14748365E9f && rectF.top != -2.14748365E9f) {
            return rectF;
        }
        float f2 = rectF.top;
        float f3 = rectF.right;
        float f4 = rectF.bottom;
        if (f == -2.14748365E9f) {
            float f5 = (float) this.mInnerLeft;
            f = ((((float) this.mInnerWidth) - (f3 - f5)) / 2.0f) + f5;
            f3 += f;
        }
        if (f2 == -2.14748365E9f) {
            float f6 = (float) this.mInnerTop;
            f2 = f6 + ((((float) this.mInnerHeight) - (f4 - f6)) / 2.0f);
            f4 += f2;
        }
        return new RectF(f, f2, f3, f4);
    }

    /* access modifiers changed from: protected */
    public void dispatchDraw(Canvas canvas) {
        RectF rectF = this.mRegionRect;
        if (rectF != null) {
            canvas.clipRect(rectF, Region.Op.DIFFERENCE);
        }
        Iterator<Overlay> it = this.mOverlays.iterator();
        while (it.hasNext()) {
            Overlay next = it.next();
            if (next.type.equals("clear")) {
                canvas.clipRect(next.mDestRect, Region.Op.DIFFERENCE);
            }
        }
        super.dispatchDraw(canvas);
    }

    @Override // io.dcloud.common.DHInterface.IWaiter
    public Object doForFeature(String str, Object obj) {
        if (str.equals("clearAnimate")) {
            clearAnimate();
            return null;
        } else if (!str.equals("checkTouch")) {
            return null;
        } else {
            MotionEvent motionEvent = (MotionEvent) obj;
            if (checkTouchRectsContains(motionEvent.getX(), motionEvent.getY())) {
                return Boolean.valueOf(this.mIntercept);
            }
            return Boolean.FALSE;
        }
    }

    /* access modifiers changed from: package-private */
    public String getEventJSON() {
        return String.format(Locale.ENGLISH, T, Integer.valueOf((int) ((this.mTouchX - ((float) this.mInnerLeft)) / this.mCreateScale)), Integer.valueOf((int) ((this.mTouchY - ((float) this.mInnerTop)) / this.mCreateScale)), Integer.valueOf((int) (this.mTouchX / this.mCreateScale)), Integer.valueOf((int) (this.mTouchY / this.mCreateScale)), Integer.valueOf((int) (this.mTouchX / this.mCreateScale)), Integer.valueOf((int) (this.mTouchY / this.mCreateScale)));
    }

    public int getInnerBottom() {
        return this.mInnerBottom;
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public int getInnerHeight() {
        return this.mInnerHeight;
    }

    public boolean getInputFocusById(String str) {
        EditText inputById = getInputById(str);
        if (inputById != null) {
            return inputById.hasFocus();
        }
        return false;
    }

    public String getInputValueById(String str) {
        EditText inputById;
        if (TextUtils.isEmpty(str) || (inputById = getInputById(str)) == null || inputById.getText() == null) {
            return null;
        }
        return inputById.getText().toString();
    }

    /* access modifiers changed from: protected */
    public int getNViewContentHeight() {
        ArrayList<Overlay> arrayList = this.mOverlays;
        if (arrayList == null) {
            return this.mAppScreenHeight;
        }
        int i = 0;
        this.mInnerHeight = this.mAppScreenHeight;
        Iterator<Overlay> it = arrayList.iterator();
        while (it.hasNext()) {
            Overlay next = it.next();
            int i2 = makeRect(this, next.mDestJson, next).bottom;
            if (i2 > i) {
                i = i2;
            }
        }
        return i;
    }

    public int getRectHeightForBitmap(NativeView nativeView, JSONObject jSONObject, Rect rect, Overlay overlay, int i) {
        if (overlay == null) {
            String optString = jSONObject.optString("height");
            int i2 = nativeView.mInnerHeight;
            return PdrUtil.convertToScreenInt(optString, i2, i2, nativeView.mCreateScale);
        }
        overlay.textAdapt = false;
        if (!jSONObject.has("height") || !"auto".equals(jSONObject.optString("height")) || rect == null) {
            if (jSONObject.has("height") && "wrap_content".equals(jSONObject.optString("height")) && PdrUtil.isEquals(overlay.type, AbsURIAdapter.FONT)) {
                overlay.textAdapt = true;
                if (!PdrUtil.isEquals(overlay.textWhiteSpace, "normal")) {
                    return (int) (overlay.mFontSize + ((float) (overlay.margin * 2)));
                }
                this.mPaint.reset();
                this.mPaint.setTextSize(overlay.mFontSize);
                return new StaticLayout(overlay.mText, new TextPaint(this.mPaint), i - (overlay.margin * 2), Layout.Alignment.ALIGN_NORMAL, overlay.textLineSpacing + 0.9f, 0.0f, false).getHeight() + (overlay.margin * 2);
            }
        } else if (jSONObject.has("width") && "auto".equals(jSONObject.optString("width"))) {
            return rect.height();
        } else {
            if (jSONObject.has("width")) {
                String optString2 = jSONObject.optString("width");
                int i3 = nativeView.mInnerWidth;
                return (int) (((float) rect.height()) * (((float) PdrUtil.convertToScreenInt(optString2, i3, i3, nativeView.mCreateScale)) / ((float) rect.width())));
            }
        }
        String optString3 = jSONObject.optString("height");
        int i4 = nativeView.mInnerHeight;
        return PdrUtil.convertToScreenInt(optString3, i4, i4, nativeView.mCreateScale);
    }

    public int getRectWidthForBitmap(NativeView nativeView, JSONObject jSONObject, Rect rect) {
        if (jSONObject.has("width") && "auto".equals(jSONObject.optString("width")) && rect != null) {
            if (jSONObject.has("height") && "auto".equals(jSONObject.optString("height"))) {
                return rect.width();
            }
            if (jSONObject.has("height")) {
                String optString = jSONObject.optString("height");
                int i = nativeView.mInnerHeight;
                return (int) (((float) rect.width()) * (((float) PdrUtil.convertToScreenInt(optString, i, i, nativeView.mCreateScale)) / ((float) rect.height())));
            }
        }
        String optString2 = jSONObject.optString("width");
        int i2 = nativeView.mInnerWidth;
        return PdrUtil.convertToScreenInt(optString2, i2, i2, nativeView.mCreateScale);
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public String getStyleBackgroundColor() {
        JSONObject jSONObject = this.mStyle;
        if (jSONObject != null) {
            if (jSONObject.has("backgroudColor")) {
                return this.mStyle.optString("backgroudColor");
            }
            if (this.mStyle.has("backgroundColor")) {
                return this.mStyle.optString("backgroundColor");
            }
        }
        return null;
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public int getStyleLeft() {
        return PdrUtil.convertToScreenInt(this.mStyle.optString("left"), this.mAppScreenWidth, 0, this.mCreateScale);
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public int getStyleWidth() {
        return this.mInnerWidth;
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public String getViewId() {
        return this.mID;
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public String getViewType() {
        return AbsoluteConst.NATIVE_NVIEW;
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public String getViewUUId() {
        return this.mUUID;
    }

    /* access modifiers changed from: protected */
    public void init() {
        String str;
        int i;
        String str2;
        JSONObject jSONObject = this.mStyle;
        if (jSONObject != null) {
            try {
                String str3 = null;
                if (jSONObject.has("backgroudColor")) {
                    str = this.mStyle.optString("backgroudColor");
                } else {
                    str = this.mStyle.has("backgroundColor") ? this.mStyle.optString("backgroundColor") : null;
                }
                if (!TextUtils.isEmpty(str)) {
                    try {
                        this.mBackGroundColor = Color.parseColor(str);
                    } catch (Exception unused) {
                        this.mBackGroundColor = PdrUtil.stringToColor(str);
                    }
                } else if (TextUtils.equals(AbsoluteConst.NATIVE_IMAGESLIDER, getViewType())) {
                    this.mBackGroundColor = -1118482;
                }
                if (this.mStyle.has(Constants.Name.BACKGROUND_IMAGE)) {
                    str3 = this.mStyle.optString(Constants.Name.BACKGROUND_IMAGE);
                }
                if (str3 != null && ((str2 = this.mBackgroundImageSrc) == null || !str2.equalsIgnoreCase(str3))) {
                    this.mBackgroundImageSrc = str3;
                }
                if (this.mStyle.has(AbsoluteConst.JSONKEY_STATUSBAR) && BaseInfo.isImmersive && Build.VERSION.SDK_INT >= 19) {
                    this.isStatusBar = true;
                    JSONObject optJSONObject = this.mStyle.optJSONObject(AbsoluteConst.JSONKEY_STATUSBAR);
                    if (optJSONObject != null && optJSONObject.has("background")) {
                        String optString = optJSONObject.optString("background");
                        if (PdrUtil.checkStatusbarColor(PdrUtil.stringToColor(optString))) {
                            this.mStatusColor = PdrUtil.stringToColor(optString);
                        }
                    }
                    if (AbsoluteConst.NATIVE_TITLE_N_VIEW.equals(getViewType()) && (i = this.mBackGroundColor) != 0 && this.mStatusColor != i && PdrUtil.checkStatusbarColor(i)) {
                        this.mStatusColor = this.mBackGroundColor;
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
        initStatusBarView(DeviceInfo.sStatusBarHeight);
        this.mInnerLeft = PdrUtil.convertToScreenInt(this.mStyle.optString("left"), this.mAppScreenWidth, 0, this.mCreateScale);
        int convertToScreenInt = PdrUtil.convertToScreenInt(this.mStyle.optString("top"), this.mAppScreenHeight, 0, this.mCreateScale);
        this.mMarginTop = convertToScreenInt;
        this.mInnerTop = convertToScreenInt;
        String optString2 = this.mStyle.optString("width");
        int i2 = this.mAppScreenWidth;
        this.mInnerRight = PdrUtil.convertToScreenInt(optString2, i2, i2, this.mCreateScale) + this.mInnerLeft;
        String optString3 = this.mStyle.optString("height");
        if (TextUtils.isEmpty(optString3) || !optString3.equals("wrap_content")) {
            this.isLayoutAdapt = false;
        } else {
            this.isLayoutAdapt = true;
        }
        if (!this.mStyle.has("bottom") || this.isLayoutAdapt) {
            if (this.isLayoutAdapt) {
                this.mInnerHeight = getNViewContentHeight();
            } else {
                int i3 = this.mAppScreenHeight;
                this.mInnerHeight = PdrUtil.convertToScreenInt(optString3, i3, i3, this.mCreateScale);
            }
            int i4 = this.mInnerHeight;
            if (i4 >= this.mAppScreenHeight || this.isLayoutAdapt) {
                this.mInnerBottom = i4;
            } else {
                this.mInnerBottom = i4 + this.mInnerTop;
            }
        } else {
            String optString4 = this.mStyle.optString("bottom");
            int i5 = this.mAppScreenHeight;
            int convertToScreenInt2 = PdrUtil.convertToScreenInt(optString4, i5, i5, this.mCreateScale);
            this.mMarginBottom = convertToScreenInt2;
            this.mInnerBottom = this.mAppScreenHeight - convertToScreenInt2;
            if (this.mStyle.has("height") && !this.mStyle.has("top")) {
                int i6 = this.mAppScreenHeight;
                int convertToScreenInt3 = PdrUtil.convertToScreenInt(optString3, i6, i6, this.mCreateScale);
                this.mInnerHeight = convertToScreenInt3;
                int i7 = this.mInnerBottom - convertToScreenInt3;
                this.mInnerTop = i7;
                if (i7 < 0) {
                    this.mInnerTop = 0;
                }
            } else if (!this.mStyle.has("height")) {
                this.mInnerHeight = this.mInnerBottom - this.mInnerTop;
            } else {
                int i8 = this.mAppScreenHeight;
                this.mInnerHeight = PdrUtil.convertToScreenInt(optString3, i8, i8, this.mCreateScale);
            }
        }
        this.mInnerWidth = this.mInnerRight - this.mInnerLeft;
        initJsonTouchRect();
    }

    /* access modifiers changed from: package-private */
    public void initJsonTouchRect() {
        this.mTouchRects.clear();
        JSONObject jSONObject = null;
        JSONArray jSONArray = null;
        if (TextUtils.isEmpty(this.mTouchRectJson) || !this.mTouchRectJson.startsWith(Operators.ARRAY_START_STR)) {
            try {
                jSONObject = new JSONObject(this.mTouchRectJson);
            } catch (Exception unused) {
            }
            this.mTouchRects.add(createTouchRect(jSONObject));
            return;
        }
        try {
            jSONArray = new JSONArray(this.mTouchRectJson);
        } catch (Exception unused2) {
        }
        for (int i = 0; i < jSONArray.length(); i++) {
            try {
                JSONObject optJSONObject = jSONArray.optJSONObject(i);
                if (optJSONObject != null) {
                    this.mTouchRects.add(createTouchRect(optJSONObject));
                }
            } catch (Exception unused3) {
            }
        }
    }

    /* access modifiers changed from: package-private */
    public void initStatusBarView(int i) {
        if (-1 == indexOfChild(this.mCanvasView)) {
            attachCanvasView();
        }
        if (this.isStatusBar) {
            for (int i2 = 0; i2 < getChildCount(); i2++) {
                View childAt = getChildAt(i2);
                if (childAt.getTag() != null && childAt.getTag().equals("StatusBar")) {
                    childAt.setBackgroundColor(this.mStatusColor);
                    return;
                }
            }
            View view = new View(getContext());
            this.mStatusbarView = view;
            view.setTag("StatusBar");
            this.mStatusbarView.setBackgroundColor(this.mStatusColor);
            this.mStatusbarView.setVisibility(0);
            this.mStatusbarView.setLayoutParams(new FrameLayout.LayoutParams(-1, i));
            addView(this.mStatusbarView);
            this.mStatusbarView.bringToFront();
            measureFitViewParent(false);
        }
    }

    /* access modifiers changed from: package-private */
    public void interceptTouchEvent(boolean z) {
        this.mIntercept = z;
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public boolean isAnimate() {
        return this.mRegionRect != null;
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public boolean isDock() {
        return TextUtils.equals(this.mStyle.optString("position", AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE), "dock");
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public boolean isDockTop() {
        return TextUtils.equals(this.mStyle.optString("position", AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE), "dock") && TextUtils.equals(this.mStyle.optString("dock"), "top");
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public boolean isStatusBar() {
        return this.isStatusBar;
    }

    /* access modifiers changed from: package-private */
    public Overlay makeOverlay(IWebview iWebview, NativeBitmap nativeBitmap, String str, int i, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, String str2, String str3, boolean z) {
        return makeOverlay(iWebview, nativeBitmap, str, i, jSONObject, jSONObject2, jSONObject3, str2, str3, true, z);
    }

    /* access modifiers changed from: package-private */
    public Rect makeRect(NativeView nativeView, JSONObject jSONObject, Overlay overlay) {
        Rect rect = new Rect();
        Rect rect2 = overlay != null ? overlay.mSrcRect : null;
        if (jSONObject != null) {
            if (jSONObject.has("right") && (!jSONObject.has("left") || !jSONObject.has("width"))) {
                rect.right = nativeView.mInnerWidth - PdrUtil.convertToScreenInt(jSONObject.optString("right"), nativeView.mInnerWidth, 0, nativeView.mCreateScale);
                if (jSONObject.has("width")) {
                    rect.left = rect.right - getRectWidthForBitmap(nativeView, jSONObject, rect2);
                } else if (!jSONObject.has("left") || "auto".equals(jSONObject.optString("left"))) {
                    rect.left = nativeView.getDrawLeft(0);
                } else {
                    rect.left = nativeView.getDrawLeft(PdrUtil.convertToScreenInt(jSONObject.optString("left"), nativeView.mInnerWidth, 0, nativeView.mCreateScale));
                }
            } else if ("auto".equals(jSONObject.optString("left"))) {
                rect.left = Integer.MIN_VALUE;
                rect.right = getRectWidthForBitmap(nativeView, jSONObject, rect2);
            } else {
                rect.left = nativeView.getDrawLeft(PdrUtil.convertToScreenInt(jSONObject.optString("left"), nativeView.mInnerWidth, 0, nativeView.mCreateScale));
                rect.right = getRectWidthForBitmap(nativeView, jSONObject, rect2) + rect.left;
            }
            if (jSONObject.has("bottom") && (!jSONObject.has("top") || !jSONObject.has("height"))) {
                rect.bottom = nativeView.mInnerBottom - PdrUtil.convertToScreenInt(jSONObject.optString("bottom"), nativeView.mInnerWidth, 0, nativeView.mCreateScale);
                if (jSONObject.has("height")) {
                    rect.top = rect.bottom - getRectHeightForBitmap(nativeView, jSONObject, rect2, overlay, rect.width());
                } else if (!jSONObject.has("top") || "auto".equals(jSONObject.optString("top"))) {
                    rect.top = nativeView.getDrawTop(0);
                } else {
                    rect.top = nativeView.getDrawTop(PdrUtil.convertToScreenInt(jSONObject.optString("top"), nativeView.mInnerHeight, 0, nativeView.mCreateScale));
                }
            } else if ("auto".equals(jSONObject.optString("top"))) {
                rect.top = Integer.MIN_VALUE;
                rect.bottom = getRectHeightForBitmap(nativeView, jSONObject, rect2, overlay, rect.width());
            } else {
                rect.top = nativeView.getDrawTop(PdrUtil.convertToScreenInt(jSONObject.optString("top"), nativeView.mInnerHeight, 0, nativeView.mCreateScale));
                rect.bottom = getRectHeightForBitmap(nativeView, jSONObject, rect2, overlay, rect.width()) + rect.top;
            }
        } else {
            rect.left = nativeView.mInnerLeft;
            rect.top = nativeView.mInnerTop;
            rect.right = nativeView.mInnerRight;
            rect.bottom = nativeView.mInnerBottom;
        }
        return rect;
    }

    public void makeRichText(IWebview iWebview, String str, JSONObject jSONObject, JSONObject jSONObject2, String str2) {
        if (PdrUtil.isEmpty(str2)) {
            str2 = "richtext_" + System.currentTimeMillis();
        }
        INativeViewChildView iNativeViewChildView = this.mChildViewMaps.get(str2);
        if (iNativeViewChildView == null) {
            RichTextLayout.RichTextLayoutHolder makeRichText = RichTextLayout.makeRichText(getContext(), iWebview, this, str, jSONObject, jSONObject2, str2);
            addView(makeRichText);
            this.mChildViewMaps.put(str2, makeRichText);
            return;
        }
        RichTextLayout.makeRichText((RichTextLayout.RichTextLayoutHolder) iNativeViewChildView, str, jSONObject, jSONObject2);
    }

    public void makeWeexView(IWebview iWebview, JSONObject jSONObject, String str) {
        if (PdrUtil.isEmpty(str)) {
            str = "weexview_" + System.currentTimeMillis();
        }
        if (this.mChildViewMaps.get(str) == null) {
            INativeViewChildView iNativeViewChildView = (INativeViewChildView) iWebview.obtainFrameView().obtainWindowMgr().processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{iWebview.obtainApp(), "weex,io.dcloud.feature.weex.WeexFeature", "createWeexWindow", new Object[]{iWebview, this, jSONObject, str}});
            addView((View) iNativeViewChildView);
            this.mChildViewMaps.put(str, iNativeViewChildView);
        }
    }

    /* access modifiers changed from: protected */
    public void measureChildViewToTop(int i) {
        measureGifImageview(i);
    }

    /* access modifiers changed from: protected */
    /* JADX WARNING: Removed duplicated region for block: B:115:0x0218  */
    public void measureFitViewParent(boolean z) {
        View obtainMainView;
        int i;
        int i2;
        int i3;
        int i4;
        int i5;
        if (this.mFrameViewParent != null) {
            String optString = this.mStyle.optString("position", AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE);
            if (TextUtils.equals(optString, "dock")) {
                ViewGroup viewGroup = (ViewGroup) ((AdaFrameItem) this.mFrameViewParent).obtainMainView();
                ViewGroup viewGroup2 = (ViewGroup) this.mFrameViewParent.obtainWebviewParent().obtainMainView();
                ViewGroup.LayoutParams layoutParams = viewGroup2.getLayoutParams();
                ViewOptions obtainFrameOptions = ((AdaFrameItem) this.mFrameViewParent).obtainFrameOptions();
                int left = z ? obtainFrameOptions.left : viewGroup2.getLeft();
                if (getTag() != null && "titleNView".equals(getTag().toString())) {
                    left = 0;
                }
                int y = z ? obtainFrameOptions.top : (int) ViewHelper.getY(viewGroup2);
                int i6 = obtainFrameOptions.width;
                int i7 = this.mApp.getInt(1);
                int i8 = this.mAppScreenHeight;
                if (i7 >= i8) {
                    i8 = this.mApp.getInt(1);
                }
                int i9 = i8 - obtainFrameOptions.bottom;
                String optString2 = this.mStyle.optString("dock", "top");
                ViewGroup viewGroup3 = (ViewGroup) this.mFrameViewParent.obtainMainView();
                if (TextUtils.equals(optString2, "left")) {
                    int i10 = this.mInnerWidth;
                    this.mInnerRight = i10;
                    this.mInnerLeft = 0;
                    i6 -= i10;
                    i = i10;
                } else {
                    if (TextUtils.equals(optString2, "top")) {
                        this.mInnerBottom = this.mInnerHeight;
                        this.mInnerTop = 0;
                        int indexOfChild = viewGroup3.indexOfChild(this);
                        int i11 = 0;
                        int i12 = 0;
                        int i13 = 0;
                        int i14 = 0;
                        while (i11 < viewGroup3.getChildCount()) {
                            View childAt = viewGroup3.getChildAt(i11);
                            if (!(childAt instanceof StatusBarView)) {
                                if (childAt != null && (childAt instanceof NativeView) && childAt != this) {
                                    boolean z2 = childAt instanceof TitleNView;
                                    NativeView nativeView = (NativeView) childAt;
                                    if (nativeView.isDock()) {
                                        if (z2) {
                                            i14 += nativeView.getInnerHeight();
                                        }
                                        if (nativeView.isDockTop()) {
                                            i13 += nativeView.getInnerBottom();
                                            if (!z2 && (i11 < indexOfChild || indexOfChild == -1)) {
                                                i14 += nativeView.getInnerHeight();
                                            }
                                        }
                                        i12 += nativeView.getInnerHeight();
                                    }
                                } else if (childAt instanceof AbsoluteLayout) {
                                    AbsoluteLayout absoluteLayout = (AbsoluteLayout) childAt;
                                    if (absoluteLayout.getFrameView() != null) {
                                        i5 = indexOfChild;
                                        if (absoluteLayout.getFrameView().mPosition == ViewRect.DOCK_BOTTOM) {
                                            i12 += childAt.getHeight();
                                        }
                                        i11++;
                                        left = left;
                                        indexOfChild = i5;
                                    }
                                }
                            }
                            i5 = indexOfChild;
                            i11++;
                            left = left;
                            indexOfChild = i5;
                        }
                        i = left;
                        int i15 = this.mInnerHeight;
                        int i16 = i13 + i15;
                        int i17 = i12 + i15;
                        if (obtainFrameOptions.isStatusbar || (this.isImmersed && TitleNViewUtil.isTitleTypeForDef(obtainFrameOptions.titleNView))) {
                            int i18 = DeviceInfo.sStatusBarHeight;
                            int i19 = i17 + i18;
                            i14 += i18;
                            i4 = i16 + i18;
                            i16 = i19;
                        } else {
                            if (this.isStatusBar) {
                                i16 += DeviceInfo.sStatusBarHeight;
                            }
                            i4 = i16;
                        }
                        ((FrameLayout.LayoutParams) this.mCanvasView.getLayoutParams()).topMargin = i14;
                        measureChildViewToTop(i14);
                        i9 -= i16;
                        i2 = i4;
                    } else {
                        i = left;
                        if (TextUtils.equals(optString2, "right")) {
                            int right = viewGroup.getRight();
                            this.mInnerRight = right;
                            int i20 = this.mInnerWidth;
                            this.mInnerLeft = right - i20;
                            i6 -= i20;
                        } else {
                            int i21 = this.mAppScreenHeight;
                            this.mInnerBottom = i21;
                            if (i21 == 0) {
                                this.mInnerBottom = obtainFrameOptions.top + obtainFrameOptions.height;
                            }
                            int i22 = 0;
                            i2 = 0;
                            for (int i23 = 0; i23 < viewGroup3.getChildCount(); i23++) {
                                View childAt2 = viewGroup3.getChildAt(i23);
                                if (childAt2 != null && (childAt2 instanceof NativeView) && childAt2 != this && (childAt2.getTag() == null || !childAt2.getTag().equals("StatusBar"))) {
                                    NativeView nativeView2 = (NativeView) childAt2;
                                    if (nativeView2.isDock()) {
                                        if ((childAt2 instanceof TitleNView) && TitleNViewUtil.isTitleTypeForDef(nativeView2.mStyle)) {
                                            i22 = nativeView2.getInnerHeight();
                                        }
                                        if (nativeView2.isDockTop()) {
                                            i2 += nativeView2.getInnerBottom();
                                        }
                                    }
                                }
                            }
                            this.mInnerTop = this.mInnerBottom - this.mInnerHeight;
                            FrameLayout.LayoutParams layoutParams2 = (FrameLayout.LayoutParams) this.mCanvasView.getLayoutParams();
                            if (this.isImmersed && (obtainFrameOptions.isStatusbar || TitleNViewUtil.isTitleTypeForDef(obtainFrameOptions.titleNView))) {
                                i22 += DeviceInfo.sStatusBarHeight;
                            }
                            layoutParams2.topMargin = i22;
                            measureChildViewToTop(i22);
                            if (obtainFrameOptions.isStatusbar) {
                                i3 = DeviceInfo.sStatusBarHeight;
                            } else {
                                if (this.isStatusBar) {
                                    i3 = DeviceInfo.sStatusBarHeight;
                                }
                                i9 -= this.mInnerHeight + i2;
                            }
                            i2 += i3;
                            i9 -= this.mInnerHeight + i2;
                        }
                    }
                    if (z) {
                        viewGroup.addView(this);
                        if (obtainFrameOptions.titleNView != null) {
                            int i24 = 0;
                            while (true) {
                                if (i24 >= viewGroup.getChildCount()) {
                                    break;
                                }
                                View childAt3 = viewGroup.getChildAt(i24);
                                if (childAt3 instanceof TitleNView) {
                                    childAt3.bringToFront();
                                    break;
                                }
                                i24++;
                            }
                        }
                    }
                    viewPostResize(viewGroup2, layoutParams, i6, i9, i, i2);
                }
                i2 = y;
                if (z) {
                }
                viewPostResize(viewGroup2, layoutParams, i6, i9, i, i2);
            } else if (TextUtils.equals(optString, "static")) {
                if (z) {
                    this.mFrameViewParent.obtainWebView().obtainWindowView().addView(this);
                }
            } else if (TextUtils.equals(optString, AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE)) {
                ViewOptions obtainFrameOptions2 = ((AdaFrameItem) this.mFrameViewParent).obtainFrameOptions();
                ViewGroup viewGroup4 = (ViewGroup) ((AdaFrameItem) this.mFrameViewParent).obtainMainView();
                int i25 = 0;
                for (int i26 = 0; i26 < viewGroup4.getChildCount(); i26++) {
                    View childAt4 = viewGroup4.getChildAt(i26);
                    if (childAt4 instanceof NativeView) {
                        NativeView nativeView3 = (NativeView) childAt4;
                        if (nativeView3.isDockTop() && nativeView3 != this) {
                            i25 += nativeView3.getInnerHeight();
                        }
                    }
                }
                if (this.isImmersed && (obtainFrameOptions2.isStatusbar || TitleNViewUtil.isTitleTypeForDef(obtainFrameOptions2.titleNView))) {
                    i25 += DeviceInfo.sStatusBarHeight;
                }
                if (this.isImmersed && !obtainFrameOptions2.isStatusbar && (this instanceof TitleNView)) {
                    i25 += DeviceInfo.sStatusBarHeight;
                }
                for (int i27 = 0; i27 < getChildCount(); i27++) {
                    View childAt5 = getChildAt(i27);
                    NativeCanvasView nativeCanvasView = this.mCanvasView;
                    if (childAt5 == nativeCanvasView) {
                        ((FrameLayout.LayoutParams) nativeCanvasView.getLayoutParams()).topMargin = i25;
                        measureChildViewToTop(i25);
                    } else if ((childAt5 instanceof INativeViewChildView) && (obtainMainView = ((INativeViewChildView) childAt5).obtainMainView()) != null) {
                        ViewGroup.LayoutParams layoutParams3 = obtainMainView.getLayoutParams();
                        if (layoutParams3 instanceof ViewGroup.MarginLayoutParams) {
                            ((ViewGroup.MarginLayoutParams) layoutParams3).topMargin = i25;
                        }
                    }
                }
                if (z) {
                    viewGroup4.addView(this);
                }
            }
            if (this.mInnerHeight > this.mAppScreenHeight) {
                getLayoutParams().height = this.mInnerHeight;
            } else if (TextUtils.equals(optString, "static")) {
                getLayoutParams().height = this.mAppScreenHeight;
            } else {
                getLayoutParams().height = -1;
            }
            initJsonTouchRect();
            Collection<INativeViewChildView> values = this.mChildViewMaps.values();
            if (values != null) {
                for (INativeViewChildView iNativeViewChildView : values) {
                    iNativeViewChildView.updateLayout();
                }
            }
        }
    }

    public void nativeInvalidate(boolean z) {
        if (this.mShow) {
            if (z) {
                requestLayout();
            }
            postInvalidate();
            NativeCanvasView nativeCanvasView = this.mCanvasView;
            if (nativeCanvasView != null) {
                if (z) {
                    nativeCanvasView.requestLayout();
                }
                this.mCanvasView.invalidate();
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public View obtanMainView() {
        return this;
    }

    /* access modifiers changed from: protected */
    public void onConfigurationChanged(Configuration configuration) {
        super.onConfigurationChanged(configuration);
        if (this.isAnimate) {
            this.isAnimate = false;
        }
        postDelayed(new Runnable() {
            /* class io.dcloud.feature.nativeObj.NativeView.AnonymousClass1 */

            public void run() {
                NativeView nativeView = NativeView.this;
                nativeView.mAppScreenWidth = nativeView.mApp.getInt(0);
                NativeView nativeView2 = NativeView.this;
                nativeView2.mAppScreenHeight = nativeView2.mApp.getInt(1);
                IWebview iWebview = NativeView.this.mWebView;
                if (!(iWebview == null || iWebview.obtainFrameView() == null)) {
                    NativeView.this.init();
                    NativeView.this.UpdateRegionData();
                    NativeView.this.configurationCange();
                    NativeView.this.requestLayout();
                    NativeView.this.invalidate();
                }
                NativeCanvasView nativeCanvasView = NativeView.this.mCanvasView;
                if (nativeCanvasView != null) {
                    nativeCanvasView.requestLayout();
                    NativeView.this.mCanvasView.invalidate();
                }
            }
        }, 100);
    }

    /* access modifiers changed from: package-private */
    public void removeFromViewGroup() {
        ViewGroup viewGroup;
        if (!this.mAttached) {
            if (getParent() != null) {
                ((ViewGroup) getParent()).removeView(this);
            }
            clearViewData();
            return;
        }
        IFrameView iFrameView = this.mFrameViewParent;
        if (iFrameView != null) {
            iFrameView.removeFrameViewListener(this.mIEventCallback);
            String optString = this.mStyle.optString("position", AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE);
            if (TextUtils.equals(optString, "dock")) {
                viewGroup = (ViewGroup) ((AdaFrameItem) this.mFrameViewParent).obtainMainView();
            } else if (TextUtils.equals(optString, "static")) {
                viewGroup = this.mFrameViewParent.obtainWebView().obtainWindowView();
            } else {
                viewGroup = TextUtils.equals(optString, AbsoluteConst.JSON_VALUE_POSITION_ABSOLUTE) ? (ViewGroup) ((AdaFrameItem) this.mFrameViewParent).obtainMainView() : null;
            }
            if (viewGroup != null) {
                viewGroup.removeView(this);
            } else {
                ViewParent parent = getParent();
                if (parent != null) {
                    ((ViewGroup) parent).removeView(this);
                }
            }
            if (this instanceof TitleNView) {
                ((AdaFrameView) this.mFrameViewParent).obtainFrameOptions().titleNView = null;
            }
            ((AdaFrameView) this.mFrameViewParent).changeWebParentViewRect();
            this.mAttached = false;
            this.mFrameViewParent = null;
            clearViewData();
        }
    }

    public void resetNativeView() {
        clearViewData();
        clearAnimate();
    }

    public void setInputFocusById(String str, boolean z) {
        EditText inputById = getInputById(str);
        if (inputById == null) {
            return;
        }
        if (z) {
            inputById.requestFocus();
            InputMethodManager inputMethodManager = (InputMethodManager) inputById.getContext().getSystemService("input_method");
            if (inputMethodManager != null) {
                try {
                    inputMethodManager.showSoftInput(inputById, 0);
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else {
            inputById.clearFocus();
            InputMethodManager inputMethodManager2 = (InputMethodManager) inputById.getContext().getSystemService("input_method");
            if (inputMethodManager2 != null) {
                try {
                    inputMethodManager2.hideSoftInputFromWindow(inputById.getApplicationWindowToken(), 0);
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public void setNativeShowType(boolean z) {
        this.mShow = z;
    }

    public void setStyle(JSONObject jSONObject, boolean z) {
        if (jSONObject != null) {
            try {
                JSONObject jSONObject2 = this.mStyle;
                if (jSONObject2 == null) {
                    this.mStyle = jSONObject;
                } else {
                    this.mStyle = JSONUtil.combinJSONObject(jSONObject2, jSONObject);
                }
                if (z) {
                    init();
                    requestLayout();
                    invalidate();
                    NativeCanvasView nativeCanvasView = this.mCanvasView;
                    if (nativeCanvasView != null) {
                        nativeCanvasView.requestLayout();
                        this.mCanvasView.invalidate();
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public void setStyleBackgroundColor(String str) {
        int i;
        if (!TextUtils.isEmpty(str)) {
            try {
                JSONObject jSONObject = this.mStyle;
                if (jSONObject != null) {
                    if (jSONObject.has("backgroudColor")) {
                        this.mStyle.put("backgroudColor", str);
                    } else if (this.mStyle.has("backgroundColor")) {
                        this.mStyle.put("backgroundColor", str);
                    }
                }
            } catch (Exception e) {
                e.printStackTrace();
            }
            try {
                i = Color.parseColor(str);
            } catch (Exception unused) {
                i = PdrUtil.stringToColor(str);
            }
            setStyleBackgroundColor(i);
        }
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public void setStyleLeft(int i) {
        try {
            JSONObject jSONObject = this.mStyle;
            jSONObject.put("left", (Float.valueOf(String.valueOf(i)).floatValue() / this.mCreateScale) + "px");
            requestLayout();
            invalidate();
            NativeCanvasView nativeCanvasView = this.mCanvasView;
            if (nativeCanvasView != null) {
                nativeCanvasView.requestLayout();
                this.mCanvasView.invalidate();
            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /* access modifiers changed from: package-private */
    public void setTouchEventRect(String str) {
        this.mTouchRectJson = str;
        initJsonTouchRect();
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public void setWebAnimationRuning(boolean z) {
        this.isWebAnimationRuning = z;
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public JSONObject toJSON() {
        JSONObject jSONObject = new JSONObject();
        try {
            jSONObject.put("id", this.mID);
            jSONObject.put("uuid", this.mUUID);
            jSONObject.put("type", getViewType());
            JSONObject jSONObject2 = this.mStyle;
            if (jSONObject2 != null) {
                jSONObject.put("styles", jSONObject2.toString());
            }
        } catch (JSONException e) {
            e.printStackTrace();
        }
        return jSONObject;
    }

    public Overlay makeOverlay(IWebview iWebview, NativeBitmap nativeBitmap, String str, int i, JSONObject jSONObject, JSONObject jSONObject2, JSONObject jSONObject3, String str2, String str3, boolean z, boolean z2) {
        Overlay overlay = new Overlay();
        this.mWebView = iWebview;
        overlay.mNativeView = this;
        overlay.mSrcJson = jSONObject;
        overlay.mDestJson = jSONObject2;
        overlay.mStyleJson = jSONObject3;
        overlay.mNativeBitmap = nativeBitmap;
        overlay.mText = str;
        overlay.mRectColor = i;
        overlay.type = str3;
        if (PdrUtil.isEmpty(str2)) {
            this.mOverlays.add(overlay);
        } else if (this.mOverlayMaps.containsKey(str2)) {
            this.mOverlays.set(this.mOverlayMaps.get(str2).intValue(), overlay);
        } else {
            this.mOverlays.add(overlay);
            this.mOverlayMaps.put(str2, Integer.valueOf(this.mOverlays.indexOf(overlay)));
        }
        overlay.parseJson(this.mWebView);
        if (str3.equals(WXBasicComponentType.IMG) && nativeBitmap != null && nativeBitmap.isGif()) {
            addGifImagview(overlay);
        }
        if (str3.equals("input")) {
            overlay.webview = iWebview;
            addInput(overlay, str2);
        }
        if (z) {
            nativeInvalidate(z2);
        }
        return overlay;
    }

    @Override // io.dcloud.common.DHInterface.INativeView
    public void setStyleBackgroundColor(int i) {
        this.mBackGroundColor = i;
        NativeCanvasView nativeCanvasView = this.mCanvasView;
        if (nativeCanvasView != null) {
            nativeCanvasView.invalidate();
        }
    }
}
