package io.dcloud.feature.nativeObj;

import android.graphics.Color;
import android.text.TextUtils;
import android.view.ViewGroup;
import com.taobao.weex.ui.component.WXBasicComponentType;
import io.dcloud.base.R;
import io.dcloud.common.DHInterface.IApp;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.DHInterface.IFrameView;
import io.dcloud.common.DHInterface.IMgr;
import io.dcloud.common.DHInterface.INativeBitmap;
import io.dcloud.common.DHInterface.INativeView;
import io.dcloud.common.DHInterface.IWebview;
import io.dcloud.common.adapter.ui.AdaFrameView;
import io.dcloud.common.adapter.ui.DHImageView;
import io.dcloud.common.adapter.ui.FrameSwitchView;
import io.dcloud.common.adapter.util.Logger;
import io.dcloud.common.constant.AbsoluteConst;
import io.dcloud.common.util.Deprecated_JSUtil;
import io.dcloud.common.util.JSUtil;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.common.util.StringUtil;
import io.dcloud.common.util.TitleNViewUtil;
import io.dcloud.feature.internal.splash.ISplash;
import io.dcloud.feature.nativeObj.richtext.RichTextLayout;
import io.dcloud.feature.uniapp.adapter.AbsURIAdapter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class NativeBitmapMgr {
    public final String SUCCESS_INFO = "{path:'file://%s', w:%d, h:%d, size:%d}";
    private HashMap<String, String> mIds = new HashMap<>();
    protected LinkedHashMap<String, NativeView> mNativeViews = new LinkedHashMap<>();
    private HashMap<String, INativeBitmap> mSnaps = new HashMap<>();

    /* access modifiers changed from: package-private */
    /* renamed from: io.dcloud.feature.nativeObj.NativeBitmapMgr$7  reason: invalid class name */
    public static /* synthetic */ class AnonymousClass7 {
        static final /* synthetic */ int[] $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action;

        /* JADX WARNING: Can't wrap try/catch for region: R(76:0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|33|34|35|36|37|38|39|40|41|42|43|44|45|46|47|48|49|50|51|52|53|54|55|56|57|58|59|60|61|62|63|64|65|66|67|68|69|70|71|72|73|74|(3:75|76|78)) */
        /* JADX WARNING: Can't wrap try/catch for region: R(78:0|1|2|3|4|5|6|7|8|9|10|11|12|13|14|15|16|17|18|19|20|21|22|23|24|25|26|27|28|29|30|31|32|33|34|35|36|37|38|39|40|41|42|43|44|45|46|47|48|49|50|51|52|53|54|55|56|57|58|59|60|61|62|63|64|65|66|67|68|69|70|71|72|73|74|75|76|78) */
        /* JADX WARNING: Failed to process nested try/catch */
        /* JADX WARNING: Missing exception handler attribute for start block: B:11:0x003e */
        /* JADX WARNING: Missing exception handler attribute for start block: B:13:0x0049 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:15:0x0054 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:17:0x0060 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:19:0x006c */
        /* JADX WARNING: Missing exception handler attribute for start block: B:21:0x0078 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:23:0x0084 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:25:0x0090 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:27:0x009c */
        /* JADX WARNING: Missing exception handler attribute for start block: B:29:0x00a8 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:31:0x00b4 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:33:0x00c0 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:35:0x00cc */
        /* JADX WARNING: Missing exception handler attribute for start block: B:37:0x00d8 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:39:0x00e4 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:3:0x0012 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:41:0x00f0 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:43:0x00fc */
        /* JADX WARNING: Missing exception handler attribute for start block: B:45:0x0108 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:47:0x0114 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:49:0x0120 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:51:0x012c */
        /* JADX WARNING: Missing exception handler attribute for start block: B:53:0x0138 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:55:0x0144 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:57:0x0150 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:59:0x015c */
        /* JADX WARNING: Missing exception handler attribute for start block: B:5:0x001d */
        /* JADX WARNING: Missing exception handler attribute for start block: B:61:0x0168 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:63:0x0174 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:65:0x0180 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:67:0x018c */
        /* JADX WARNING: Missing exception handler attribute for start block: B:69:0x0198 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:71:0x01a4 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:73:0x01b0 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:75:0x01bc */
        /* JADX WARNING: Missing exception handler attribute for start block: B:7:0x0028 */
        /* JADX WARNING: Missing exception handler attribute for start block: B:9:0x0033 */
        static {
            int[] iArr = new int[Action.values().length];
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action = iArr;
            iArr[Action.View.ordinal()] = 1;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.setStyle.ordinal()] = 2;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.addEventListener.ordinal()] = 3;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.interceptTouchEvent.ordinal()] = 4;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.setTouchEventRect.ordinal()] = 5;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.getViewById.ordinal()] = 6;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.evalWeexJS.ordinal()] = 7;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.drawRichText.ordinal()] = 8;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.drawBitmap.ordinal()] = 9;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.drawText.ordinal()] = 10;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.drawInput.ordinal()] = 11;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.getInputValueById.ordinal()] = 12;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.getInputFocusById.ordinal()] = 13;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.setInputFocusById.ordinal()] = 14;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.show.ordinal()] = 15;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.hide.ordinal()] = 16;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.view_close.ordinal()] = 17;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.view_animate.ordinal()] = 18;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.view_reset.ordinal()] = 19;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.view_restore.ordinal()] = 20;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.view_drawRect.ordinal()] = 21;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.isVisible.ordinal()] = 22;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.Bitmap.ordinal()] = 23;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.getItems.ordinal()] = 24;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.getBitmapById.ordinal()] = 25;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.clear.ordinal()] = 26;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.bitmapRecycle.ordinal()] = 27;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.load.ordinal()] = 28;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.loadBase64Data.ordinal()] = 29;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.save.ordinal()] = 30;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.toBase64Data.ordinal()] = 31;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.startAnimation.ordinal()] = 32;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.clearAnimation.ordinal()] = 33;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.view_clearRect.ordinal()] = 34;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.view_draw.ordinal()] = 35;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.setImages.ordinal()] = 36;
            $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.addImages.ordinal()] = 37;
            try {
                $SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[Action.currentImageIndex.ordinal()] = 38;
            } catch (NoSuchFieldError unused) {
            }
        }
    }

    /* access modifiers changed from: protected */
    public enum Action {
        Bitmap,
        getItems,
        getBitmapById,
        clear,
        load,
        loadBase64Data,
        save,
        toBase64Data,
        View,
        startAnimation,
        clearAnimation,
        getViewById,
        drawBitmap,
        drawText,
        evalWeexJS,
        drawRichText,
        show,
        hide,
        setImages,
        addImages,
        view_animate,
        view_reset,
        view_restore,
        view_drawRect,
        isVisible,
        addEventListener,
        interceptTouchEvent,
        setTouchEventRect,
        bitmapRecycle,
        setStyle,
        view_clearRect,
        view_draw,
        view_close,
        currentImageIndex,
        drawInput,
        getInputValueById,
        getInputFocusById,
        setInputFocusById
    }

    private void createBitmap(IApp iApp, String str, String str2, String str3) {
        if (TextUtils.isEmpty(str2)) {
            str2 = "" + System.currentTimeMillis();
        }
        if (!this.mSnaps.containsKey(str)) {
            this.mSnaps.put(str, new NativeBitmap(iApp, str2, str, str3));
            this.mIds.put(str2, str);
        }
    }

    private NativeView getNativeView(String str, String str2) {
        NativeView nativeView = this.mNativeViews.get(str2);
        if (nativeView != null || TextUtils.isEmpty(str)) {
            return nativeView;
        }
        for (NativeView nativeView2 : this.mNativeViews.values()) {
            if (TextUtils.equals(nativeView2.mID, str)) {
                return nativeView2;
            }
        }
        return nativeView;
    }

    private void load(final IWebview iWebview, NativeBitmap nativeBitmap, String str, final String str2) {
        nativeBitmap.load(iWebview, iWebview.obtainFrameView().obtainMainView().getContext(), str, TextUtils.isEmpty(str2) ? null : new ICallBack() {
            /* class io.dcloud.feature.nativeObj.NativeBitmapMgr.AnonymousClass1 */

            @Override // io.dcloud.common.DHInterface.ICallBack
            public Object onCallBack(int i, Object obj) {
                Deprecated_JSUtil.execCallback(iWebview, str2, null, JSUtil.OK, false, false);
                return null;
            }
        }, TextUtils.isEmpty(str2) ? null : new ICallBack() {
            /* class io.dcloud.feature.nativeObj.NativeBitmapMgr.AnonymousClass2 */

            @Override // io.dcloud.common.DHInterface.ICallBack
            public Object onCallBack(int i, Object obj) {
                String string = obj == null ? iWebview.getContext().getString(R.string.dcloud_native_obj_load_failed) : obj.toString();
                IWebview iWebview = iWebview;
                String str = str2;
                Deprecated_JSUtil.execCallback(iWebview, str, "{\"code\":-100,\"message\":\"" + string + "\"}", JSUtil.ERROR, true, false);
                return null;
            }
        });
    }

    private void loadBase64Data(final IWebview iWebview, NativeBitmap nativeBitmap, String str, final String str2) {
        AnonymousClass3 r0;
        AnonymousClass4 r1 = null;
        if (TextUtils.isEmpty(str2)) {
            r0 = null;
        } else {
            r0 = new ICallBack() {
                /* class io.dcloud.feature.nativeObj.NativeBitmapMgr.AnonymousClass3 */

                @Override // io.dcloud.common.DHInterface.ICallBack
                public Object onCallBack(int i, Object obj) {
                    Deprecated_JSUtil.execCallback(iWebview, str2, null, JSUtil.OK, false, false);
                    return null;
                }
            };
        }
        if (!TextUtils.isEmpty(str2)) {
            r1 = new ICallBack() {
                /* class io.dcloud.feature.nativeObj.NativeBitmapMgr.AnonymousClass4 */

                @Override // io.dcloud.common.DHInterface.ICallBack
                public Object onCallBack(int i, Object obj) {
                    IWebview iWebview = iWebview;
                    String str = str2;
                    Deprecated_JSUtil.execCallback(iWebview, str, "{\"code\":-100,\"message\":\"" + iWebview.getContext().getString(R.string.dcloud_native_obj_load_failed) + "\"}", JSUtil.ERROR, true, false);
                    return null;
                }
            };
        }
        nativeBitmap.loadBase64Data(str, r0, r1);
    }

    private void save(final IWebview iWebview, NativeBitmap nativeBitmap, String str, JSONObject jSONObject, final String str2) {
        nativeBitmap.save(iWebview.obtainFrameView().obtainApp(), str, new NativeBitmapSaveOptions(jSONObject.toString()), iWebview.getScale(), TextUtils.isEmpty(str2) ? null : new ICallBack() {
            /* class io.dcloud.feature.nativeObj.NativeBitmapMgr.AnonymousClass5 */

            @Override // io.dcloud.common.DHInterface.ICallBack
            public Object onCallBack(int i, Object obj) {
                String str;
                if (obj == null || !(obj instanceof NativeBitmapSaveOptions)) {
                    str = null;
                } else {
                    NativeBitmapSaveOptions nativeBitmapSaveOptions = (NativeBitmapSaveOptions) obj;
                    str = StringUtil.format("{path:'file://%s', w:%d, h:%d, size:%d}", nativeBitmapSaveOptions.path, Integer.valueOf(nativeBitmapSaveOptions.width), Integer.valueOf(nativeBitmapSaveOptions.height), Long.valueOf(nativeBitmapSaveOptions.size));
                }
                Deprecated_JSUtil.execCallback(iWebview, str2, str, JSUtil.OK, true, false);
                return null;
            }
        }, TextUtils.isEmpty(str2) ? null : new ICallBack() {
            /* class io.dcloud.feature.nativeObj.NativeBitmapMgr.AnonymousClass6 */

            @Override // io.dcloud.common.DHInterface.ICallBack
            public Object onCallBack(int i, Object obj) {
                Deprecated_JSUtil.execCallback(iWebview, str2, "{\"code\":-100,\"message\":\"\"+webview.getContext().getString(R.string.dcloud_native_obj_load_failed)+\"\"}", JSUtil.ERROR, true, false);
                return null;
            }
        });
    }

    public void destroy() {
        try {
            for (INativeBitmap iNativeBitmap : this.mSnaps.values()) {
                try {
                    iNativeBitmap.clear();
                } catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.mIds.clear();
            this.mSnaps.clear();
            for (NativeView nativeView : this.mNativeViews.values()) {
                if (nativeView != null) {
                    nativeView.clearNativeViewData();
                }
            }
            this.mNativeViews.clear();
            NativeTypefaceFactory.clearCache();
            System.gc();
        } catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    public void destroyNativeView(NativeView nativeView) {
        NativeView nativeView2 = this.mNativeViews.get(nativeView.mUUID);
        nativeView.clearNativeViewData();
        if (nativeView2 == nativeView) {
            this.mNativeViews.remove(nativeView.mUUID);
        } else {
            this.mNativeViews.remove(nativeView.mID);
        }
    }

    public Object doForFeature(String str, Object obj) {
        NativeView nativeView;
        NativeView nativeView2;
        NativeView nativeView3 = null;
        if ("addNativeView".equals(str)) {
            Object[] objArr = (Object[]) obj;
            IFrameView iFrameView = (IFrameView) objArr[0];
            String str2 = (String) objArr[1];
            NativeView nativeView4 = getNativeView(str2, str2);
            Logger.d("adadad", "addNativeView outter" + nativeView4);
            if (nativeView4 != null) {
                Logger.d("adadad", "addNativeView inner" + iFrameView);
                nativeView4.attachToViewGroup(iFrameView);
            }
        } else if ("removeNativeView".equals(str)) {
            String str3 = (String) ((Object[]) obj)[1];
            NativeView nativeView5 = getNativeView(str3, str3);
            if (nativeView5 != null) {
                nativeView5.removeFromViewGroup();
            }
        } else if ("getNativeView".equals(str)) {
            try {
                Object[] objArr2 = (Object[]) obj;
                IFrameView iFrameView2 = (IFrameView) objArr2[0];
                String str4 = (String) objArr2[1];
                nativeView3 = getNativeView(str4, str4);
            } catch (Exception e) {
                e.printStackTrace();
            }
        } else if ("makeRichText".equals(str)) {
            return RichTextLayout.makeRichText((Object[]) obj);
        } else {
            if ("View".equals(str)) {
                try {
                    Object[] objArr3 = (Object[]) obj;
                    IFrameView iFrameView3 = (IFrameView) objArr3[0];
                    IWebview iWebview = (IWebview) objArr3[1];
                    String str5 = (String) objArr3[2];
                    String str6 = (String) objArr3[3];
                    JSONObject jSONObject = (JSONObject) objArr3[4];
                    if (jSONObject == null) {
                        jSONObject = new JSONObject();
                    }
                    JSONArray jSONArray = objArr3.length > 5 ? (JSONArray) objArr3[5] : null;
                    String str7 = objArr3.length > 6 ? (String) objArr3[6] : AbsoluteConst.NATIVE_NVIEW;
                    if (!this.mNativeViews.containsKey(str6)) {
                        if (str7.equals(AbsoluteConst.NATIVE_IMAGESLIDER)) {
                            nativeView2 = new NativeImageSlider(iWebview.getContext(), iWebview, str6, str5, jSONObject);
                        } else if (AbsoluteConst.NATIVE_TITLE_N_VIEW.equals(str7)) {
                            nativeView2 = new TitleNView(iWebview.getContext(), iWebview, str6, str5, jSONObject);
                        } else {
                            nativeView2 = new NativeView(iWebview.getContext(), iWebview, str6, str5, jSONObject);
                        }
                        this.mNativeViews.put(nativeView2.mUUID, nativeView2);
                        initViewDrawItme(iWebview, nativeView2, jSONArray);
                        return nativeView2;
                    }
                } catch (Exception e2) {
                    e2.printStackTrace();
                }
            } else if ("updateSubNViews".equals(str)) {
                Object[] objArr4 = (Object[]) obj;
                IWebview iWebview2 = (IWebview) objArr4[1];
                JSONArray jSONArray2 = (JSONArray) objArr4[2];
                AdaFrameView adaFrameView = (AdaFrameView) iWebview2.obtainFrameView();
                for (int i = 0; i < jSONArray2.length(); i++) {
                    try {
                        JSONObject jSONObject2 = jSONArray2.getJSONObject(i);
                        String optString = jSONObject2.optString("id");
                        if (!PdrUtil.isEmpty(optString)) {
                            Iterator<INativeView> it = adaFrameView.mChildNativeViewList.iterator();
                            while (true) {
                                if (!it.hasNext()) {
                                    nativeView = null;
                                    break;
                                }
                                INativeView next = it.next();
                                if (optString.equals(next.getViewId())) {
                                    nativeView = (NativeView) next;
                                    break;
                                }
                            }
                            if (nativeView != null) {
                                JSONArray optJSONArray = jSONObject2.optJSONArray("tags");
                                nativeView.setStyle(jSONObject2.optJSONObject("styles"), optJSONArray == null);
                                initViewDrawItme(iWebview2, nativeView, optJSONArray);
                            }
                        }
                    } catch (JSONException e3) {
                        e3.printStackTrace();
                    }
                }
            }
        }
        return nativeView3;
    }

    /* JADX WARNING: Removed duplicated region for block: B:146:0x031c  */
    /* JADX WARNING: Removed duplicated region for block: B:311:0x0655  */
    public String execute(IWebview iWebview, String str, String[] strArr) {
        Exception e;
        Action action;
        String str2;
        JSONObject jSONObject;
        JSONArray jSONArray;
        NativeView nativeView;
        JSONObject jSONObject2;
        String wrapJsVar;
        JSONObject jSONObject3;
        JSONObject jSONObject4;
        NativeBitmap srcNativeBitmap;
        JSONObject jSONObject5;
        JSONObject jSONObject6;
        JSONObject jSONObject7;
        JSONObject jSONObject8;
        JSONObject jSONObject9;
        JSONObject jSONObject10;
        String str3;
        JSONObject jSONObject11;
        int stringToColor;
        String str4;
        JSONException e2;
        String str5;
        Object obj;
        String str6;
        String str7;
        NativeView nativeView2;
        String str8 = null;
        try {
            IApp obtainApp = iWebview.obtainFrameView().obtainApp();
            if (obtainApp == null) {
                return null;
            }
            obtainApp.obtainAppId();
            try {
                action = Action.valueOf(str);
            } catch (Exception unused) {
                action = null;
            }
            boolean z = true;
            boolean z2 = false;
            int i = 0;
            switch (AnonymousClass7.$SwitchMap$io$dcloud$feature$nativeObj$NativeBitmapMgr$Action[action.ordinal()]) {
                case 1:
                    str2 = null;
                    String str9 = strArr[0];
                    String str10 = strArr[1];
                    String str11 = strArr.length > 4 ? strArr[4] : AbsoluteConst.NATIVE_NVIEW;
                    try {
                        jSONObject = new JSONObject(strArr[2]);
                    } catch (JSONException unused2) {
                        jSONObject = new JSONObject();
                    }
                    if (strArr.length > 3) {
                        try {
                            jSONArray = new JSONArray(strArr[3]);
                        } catch (JSONException unused3) {
                        }
                        if (!this.mNativeViews.containsKey(str10)) {
                            if (str11.equals(AbsoluteConst.NATIVE_IMAGESLIDER)) {
                                nativeView = new NativeImageSlider(iWebview.getContext(), iWebview, str10, str9, jSONObject);
                            } else {
                                nativeView = new NativeView(iWebview.getContext(), iWebview, str10, str9, jSONObject);
                            }
                            initViewDrawItme(iWebview, nativeView, jSONArray);
                            this.mNativeViews.put(nativeView.mUUID, nativeView);
                        }
                        return str2;
                    }
                    jSONArray = null;
                    if (!this.mNativeViews.containsKey(str10)) {
                    }
                    return str2;
                case 2:
                    str2 = null;
                    String str12 = strArr[0];
                    String str13 = strArr[1];
                    try {
                        jSONObject2 = new JSONObject(strArr[2]);
                    } catch (JSONException unused4) {
                        jSONObject2 = new JSONObject();
                    }
                    NativeView nativeView3 = getNativeView(str12, str13);
                    if (nativeView3 != null) {
                        nativeView3.setStyle(jSONObject2, true);
                    }
                    return str2;
                case 3:
                    str2 = null;
                    NativeView nativeView4 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView4 != null) {
                        nativeView4.addEventListener(strArr[2], iWebview, strArr[3]);
                    }
                    return str2;
                case 4:
                    str2 = null;
                    NativeView nativeView5 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView5 != null) {
                        nativeView5.interceptTouchEvent(PdrUtil.parseBoolean(strArr[2], true, false));
                    }
                    return str2;
                case 5:
                    str2 = null;
                    NativeView nativeView6 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView6 != null) {
                        String str14 = strArr[2];
                        if (!TextUtils.isEmpty(str14) && !str14.equals("null")) {
                            nativeView6.setTouchEventRect(str14);
                        }
                    }
                    return str2;
                case 6:
                    str2 = null;
                    NativeView nativeView7 = getNativeView(strArr[0], strArr.length > 1 ? strArr[1] : null);
                    if (nativeView7 != null) {
                        wrapJsVar = JSUtil.wrapJsVar(nativeView7.toJSON());
                        return wrapJsVar;
                    }
                    return str2;
                case 7:
                    str2 = null;
                    String str15 = strArr[0];
                    String str16 = strArr[1];
                    iWebview.obtainFrameView().obtainWindowMgr().processEvent(IMgr.MgrType.FeatureMgr, 10, new Object[]{iWebview.obtainApp(), "weex,io.dcloud.feature.weex.WeexFeature", "evalWeexJS", new Object[]{iWebview, strArr[2], strArr[3], strArr[4]}});
                    return str2;
                case 8:
                    str2 = null;
                    NativeView nativeView8 = getNativeView(strArr[0], strArr[1]);
                    String str17 = strArr[2];
                    if (nativeView8 != null && !TextUtils.isEmpty(str17)) {
                        try {
                            jSONObject3 = new JSONObject(strArr[3]);
                        } catch (JSONException unused5) {
                            jSONObject3 = new JSONObject();
                        }
                        try {
                            jSONObject4 = new JSONObject(strArr[4]);
                        } catch (JSONException unused6) {
                            jSONObject4 = new JSONObject();
                        }
                        nativeView8.makeRichText(iWebview, str17, jSONObject3, jSONObject4, strArr[5]);
                    }
                    return str2;
                case 9:
                    str2 = null;
                    NativeView nativeView9 = getNativeView(strArr[0], strArr[1]);
                    if (!(nativeView9 == null || (srcNativeBitmap = getSrcNativeBitmap(iWebview, obtainApp, strArr[2])) == null || srcNativeBitmap.getBitmap() == null)) {
                        try {
                            jSONObject5 = new JSONObject(strArr[3]);
                        } catch (JSONException unused7) {
                            jSONObject5 = new JSONObject();
                        }
                        try {
                            jSONObject6 = new JSONObject(strArr[4]);
                        } catch (JSONException unused8) {
                            jSONObject6 = new JSONObject();
                        }
                        nativeView9.makeOverlay(iWebview, srcNativeBitmap, null, -1, jSONObject5, jSONObject6, null, strArr[5], WXBasicComponentType.IMG, true);
                    }
                    return str2;
                case 10:
                    str2 = null;
                    NativeView nativeView10 = getNativeView(strArr[0], strArr[1]);
                    String str18 = strArr[2];
                    if (!(nativeView10 == null || str18 == null)) {
                        try {
                            jSONObject7 = new JSONObject(strArr[3]);
                        } catch (JSONException unused9) {
                            jSONObject7 = new JSONObject();
                        }
                        try {
                            jSONObject8 = new JSONObject(strArr[4]);
                        } catch (JSONException unused10) {
                            jSONObject8 = new JSONObject();
                        }
                        nativeView10.makeOverlay(iWebview, null, str18, -1, null, jSONObject7, jSONObject8, strArr[5], AbsURIAdapter.FONT, !AbsoluteConst.FALSE.equals(strArr[6]));
                    }
                    return str2;
                case 11:
                    str2 = null;
                    NativeView nativeView11 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView11 != null) {
                        try {
                            jSONObject9 = new JSONObject(strArr[2]);
                        } catch (JSONException unused11) {
                            jSONObject9 = new JSONObject();
                        }
                        try {
                            jSONObject10 = new JSONObject(strArr[3]);
                        } catch (JSONException unused12) {
                            jSONObject10 = new JSONObject();
                        }
                        try {
                            str3 = strArr[4];
                        } catch (Exception unused13) {
                            str3 = null;
                        }
                        nativeView11.makeOverlay(iWebview, null, null, -1, null, jSONObject9, jSONObject10, str3, "input", true);
                    }
                    return str2;
                case 12:
                    str2 = null;
                    NativeView nativeView12 = getNativeView(strArr[0], strArr[1]);
                    String str19 = strArr[2];
                    if (nativeView12 != null) {
                        wrapJsVar = Deprecated_JSUtil.wrapJsVar(nativeView12.getInputValueById(str19), true);
                        return wrapJsVar;
                    }
                    return str2;
                case 13:
                    str2 = null;
                    NativeView nativeView13 = getNativeView(strArr[0], strArr[1]);
                    String str20 = strArr[2];
                    if (nativeView13 != null) {
                        wrapJsVar = Deprecated_JSUtil.wrapJsVar(String.valueOf(nativeView13.getInputFocusById(str20)), false);
                        return wrapJsVar;
                    }
                    return str2;
                case 14:
                    str2 = null;
                    NativeView nativeView14 = getNativeView(strArr[0], strArr[1]);
                    try {
                        String str21 = strArr[2];
                        if (4 <= strArr.length) {
                            z2 = Boolean.valueOf(strArr[3]).booleanValue();
                        }
                        if (nativeView14 != null) {
                            nativeView14.setInputFocusById(str21, z2);
                        }
                    } catch (Exception unused14) {
                    }
                    return str2;
                case 15:
                    str2 = null;
                    NativeView nativeView15 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView15 != null) {
                        nativeView15.setVisibility(0);
                        ViewGroup viewGroup = (ViewGroup) iWebview.obtainApp().obtainWebAppRootView().obtainMainView().getParent();
                        if (nativeView15.getParent() == null) {
                            nativeView15.mShow = true;
                            int childCount = viewGroup.getChildCount();
                            while (true) {
                                if (i < childCount) {
                                    if (viewGroup.getChildAt(i) instanceof ISplash) {
                                        childCount = i;
                                    } else {
                                        i++;
                                    }
                                }
                            }
                            viewGroup.addView(nativeView15, childCount);
                        }
                    }
                    return str2;
                case 16:
                    str2 = null;
                    NativeView nativeView16 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView16 != null) {
                        nativeView16.setVisibility(4);
                        ViewGroup viewGroup2 = (ViewGroup) nativeView16.getParent();
                        if (viewGroup2 != null && (viewGroup2 instanceof DHImageView)) {
                            DHImageView dHImageView = (DHImageView) viewGroup2;
                            dHImageView.clear();
                            dHImageView.setVisibility(4);
                        }
                    }
                    return str2;
                case 17:
                    str2 = null;
                    String str22 = strArr[0];
                    String str23 = strArr[1];
                    NativeView nativeView17 = getNativeView(str22, str23);
                    if (nativeView17 != null) {
                        this.mNativeViews.remove(str23);
                        nativeView17.removeFromViewGroup();
                    }
                    return str2;
                case 18:
                    str2 = null;
                    NativeView nativeView18 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView18 != null) {
                        nativeView18.StartAnimate(iWebview, strArr[2], strArr[3]);
                    }
                    return str2;
                case 19:
                    str2 = null;
                    NativeView nativeView19 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView19 != null) {
                        nativeView19.resetNativeView();
                    }
                    return str2;
                case 20:
                    str2 = null;
                    NativeView nativeView20 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView20 != null) {
                        nativeView20.clearAnimate();
                    }
                    return str2;
                case 21:
                    str2 = null;
                    NativeView nativeView21 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView21 != null) {
                        boolean isEmpty = PdrUtil.isEmpty(strArr[2]);
                        String str24 = TitleNViewUtil.TRANSPARENT_BUTTON_TEXT_COLOR;
                        if (!isEmpty) {
                            try {
                                jSONObject11 = new JSONObject(strArr[2]);
                                try {
                                    if (jSONObject11.has("color")) {
                                        str4 = jSONObject11.optString("color");
                                        str24 = str4;
                                    }
                                } catch (JSONException e3) {
                                    e2 = e3;
                                    e2.printStackTrace();
                                    str4 = strArr[2];
                                    str24 = str4;
                                    String str25 = strArr[3];
                                    if (!TextUtils.isEmpty(str25)) {
                                    }
                                    String str26 = strArr[4];
                                    stringToColor = Color.parseColor(str24);
                                    nativeView21.makeOverlay(iWebview, null, null, stringToColor, null, r14, jSONObject11, str26, "rect", !AbsoluteConst.FALSE.equals(strArr[5]));
                                    return str2;
                                }
                            } catch (JSONException e4) {
                                e2 = e4;
                                jSONObject11 = null;
                                e2.printStackTrace();
                                str4 = strArr[2];
                                str24 = str4;
                                String str252 = strArr[3];
                                if (!TextUtils.isEmpty(str252)) {
                                }
                                String str262 = strArr[4];
                                stringToColor = Color.parseColor(str24);
                                nativeView21.makeOverlay(iWebview, null, null, stringToColor, null, r14, jSONObject11, str262, "rect", !AbsoluteConst.FALSE.equals(strArr[5]));
                                return str2;
                            }
                        } else {
                            jSONObject11 = null;
                        }
                        String str2522 = strArr[3];
                        JSONObject jSONObject12 = (!TextUtils.isEmpty(str2522) || str2522.equals("null")) ? null : new JSONObject(str2522);
                        String str2622 = strArr[4];
                        try {
                            stringToColor = Color.parseColor(str24);
                        } catch (Exception unused15) {
                            stringToColor = PdrUtil.stringToColor(str24);
                        }
                        nativeView21.makeOverlay(iWebview, null, null, stringToColor, null, jSONObject12, jSONObject11, str2622, "rect", !AbsoluteConst.FALSE.equals(strArr[5]));
                    }
                    return str2;
                case 22:
                    NativeView nativeView22 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView22 == null || nativeView22.getParent() == null) {
                        wrapJsVar = Deprecated_JSUtil.wrapJsVar(String.valueOf(false), false);
                        return wrapJsVar;
                    }
                    if (nativeView22.getVisibility() != 0) {
                        z = false;
                    }
                    wrapJsVar = Deprecated_JSUtil.wrapJsVar(String.valueOf(z), false);
                    return wrapJsVar;
                case 23:
                    str2 = null;
                    if (strArr.length > 2) {
                        str5 = strArr[2];
                        if (!PdrUtil.isNetPath(str5)) {
                            if (!TextUtils.isEmpty(str5) && !str5.equals("null")) {
                                str5 = obtainApp.convert2AbsFullPath(iWebview.obtainFullUrl(), str5);
                            }
                        }
                        createBitmap(obtainApp, strArr[0], strArr[1], str5);
                        return str2;
                    }
                    str5 = null;
                    createBitmap(obtainApp, strArr[0], strArr[1], str5);
                    return str2;
                case 24:
                    String jSONArray2 = getItems().toString();
                    try {
                        wrapJsVar = Deprecated_JSUtil.wrapJsVar(jSONArray2, false);
                        return wrapJsVar;
                    } catch (Exception e5) {
                        e = e5;
                        str8 = jSONArray2;
                        Logger.e("NativeBitmapMgr", e.toString());
                        e.printStackTrace();
                        return str8;
                    }
                case 25:
                    NativeBitmap nativeBitmap = (NativeBitmap) getBitmapById(strArr[0]);
                    wrapJsVar = Deprecated_JSUtil.wrapJsVar(nativeBitmap != null ? nativeBitmap.toJsString() : null, false);
                    return wrapJsVar;
                case 26:
                    str2 = null;
                    NativeBitmap nativeBitmap2 = (NativeBitmap) getBitmapByUuid(strArr[0]);
                    this.mSnaps.remove(this.mIds.get(nativeBitmap2.getId()));
                    this.mIds.remove(nativeBitmap2.getId());
                    nativeBitmap2.clear();
                    return str2;
                case 27:
                    str2 = null;
                    NativeBitmap nativeBitmap3 = (NativeBitmap) getBitmapByUuid(strArr[0]);
                    if (nativeBitmap3 != null) {
                        nativeBitmap3.recycle();
                    }
                    return str2;
                case 28:
                    str2 = null;
                    NativeBitmap nativeBitmap4 = (NativeBitmap) getBitmapByUuid(strArr[0]);
                    String str27 = strArr[1];
                    String str28 = strArr[2];
                    if (nativeBitmap4 != null) {
                        load(iWebview, nativeBitmap4, str27, str28);
                    }
                    return str2;
                case 29:
                    str2 = null;
                    NativeBitmap nativeBitmap5 = (NativeBitmap) getBitmapByUuid(strArr[0]);
                    String str29 = strArr[1];
                    String str30 = strArr[2];
                    if (nativeBitmap5 != null) {
                        loadBase64Data(iWebview, nativeBitmap5, str29, str30);
                    }
                    return str2;
                case 30:
                    NativeBitmap nativeBitmap6 = (NativeBitmap) getBitmapByUuid(strArr[0]);
                    String str31 = strArr[1];
                    JSONObject jSONObject13 = new JSONObject(strArr[2]);
                    String str32 = strArr[3];
                    String convert2AbsFullPath = obtainApp.convert2AbsFullPath(iWebview.obtainFullUrl(), str31);
                    if (nativeBitmap6 != null) {
                        str2 = null;
                        try {
                            save(iWebview, nativeBitmap6, convert2AbsFullPath, jSONObject13, str32);
                            return str2;
                        } catch (Exception e6) {
                            e = e6;
                            str8 = null;
                            Logger.e("NativeBitmapMgr", e.toString());
                            e.printStackTrace();
                            return str8;
                        }
                    }
                    str2 = null;
                    return str2;
                case 31:
                    NativeBitmap nativeBitmap7 = (NativeBitmap) getBitmapByUuid(strArr[0]);
                    if (nativeBitmap7 != null) {
                        str8 = nativeBitmap7.toBase64Data();
                    }
                    wrapJsVar = Deprecated_JSUtil.wrapJsVar(str8, true);
                    return wrapJsVar;
                case 32:
                    String str33 = strArr[0];
                    String str34 = strArr[1];
                    String str35 = strArr.length > 2 ? strArr[2] : null;
                    String str36 = strArr.length > 3 ? strArr[3] : null;
                    JSONObject jSONObject14 = new JSONObject(str34);
                    String optString = jSONObject14.optString("viewId", null);
                    if (TextUtils.isEmpty(optString)) {
                        str6 = jSONObject14.optString("texts", null);
                        obj = getBitmapByUuid(jSONObject14.optString("uuid", null));
                    } else if (this.mNativeViews.containsKey(optString)) {
                        obj = this.mNativeViews.get(optString);
                        this.mNativeViews.get(optString).mShow = true;
                        str6 = null;
                    } else {
                        str6 = null;
                        obj = null;
                    }
                    if (TextUtils.isEmpty(str35) || str35.equals("null")) {
                        nativeView2 = null;
                        str7 = null;
                    } else {
                        JSONObject jSONObject15 = new JSONObject(str35);
                        String optString2 = jSONObject15.optString("viewId", null);
                        if (!TextUtils.isEmpty(optString2)) {
                            NativeView nativeView23 = this.mNativeViews.get(optString2);
                            this.mNativeViews.get(optString2).mShow = true;
                            nativeView2 = nativeView23;
                            str7 = null;
                        } else {
                            str7 = jSONObject15.optString("texts", null);
                            nativeView2 = getBitmapByUuid(jSONObject15.optString("uuid", null));
                        }
                    }
                    FrameSwitchView instance = FrameSwitchView.getInstance(obtainApp.getActivity());
                    if (!instance.isInit()) {
                        instance.initView();
                    }
                    instance.startAnimation(iWebview, str33, obj, str6, nativeView2, str7, str36);
                    str2 = null;
                    return str2;
                case 33:
                    FrameSwitchView instance2 = FrameSwitchView.getInstance(obtainApp.getActivity());
                    if (!instance2.isInit()) {
                        instance2.initView();
                    }
                    instance2.clearSwitchAnimation(strArr[0]);
                    str2 = null;
                    return str2;
                case 34:
                    NativeView nativeView24 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView24 != null) {
                        String str37 = strArr[2];
                        nativeView24.makeOverlay(iWebview, null, null, -1, null, (TextUtils.isEmpty(str37) || str37.equals("null")) ? null : new JSONObject(str37), null, strArr[3], "clear", false, true);
                    }
                    str2 = null;
                    return str2;
                case 35:
                    NativeView nativeView25 = getNativeView(strArr[0], strArr[1]);
                    if (nativeView25 != null) {
                        try {
                            initViewDrawItme(iWebview, nativeView25, new JSONArray(strArr[2]));
                        } catch (JSONException unused16) {
                        }
                    }
                    str2 = null;
                    return str2;
                case 36:
                    String str38 = strArr[0];
                    String str39 = strArr[1];
                    String str40 = strArr[2];
                    NativeView nativeView26 = getNativeView(str38, str39);
                    if (!PdrUtil.isEmpty(str40) && nativeView26 != null && nativeView26.getViewType().equals(AbsoluteConst.NATIVE_IMAGESLIDER)) {
                        ((NativeImageSlider) nativeView26).setImages(iWebview, new JSONArray(str40));
                    }
                    str2 = null;
                    return str2;
                case 37:
                    String str41 = strArr[0];
                    String str42 = strArr[1];
                    String str43 = strArr[2];
                    NativeView nativeView27 = getNativeView(str41, str42);
                    if (!PdrUtil.isEmpty(str43) && nativeView27 != null && nativeView27.getViewType().equals(AbsoluteConst.NATIVE_IMAGESLIDER)) {
                        ((NativeImageSlider) nativeView27).addImages(iWebview, new JSONArray(str43));
                    }
                    str2 = null;
                    return str2;
                case 38:
                    try {
                        NativeView nativeView28 = getNativeView(strArr[0], strArr[1]);
                        if (nativeView28 != null && nativeView28.getViewType().equals(AbsoluteConst.NATIVE_IMAGESLIDER)) {
                            wrapJsVar = String.valueOf(((NativeImageSlider) nativeView28).getCurrentImageIndex());
                            return wrapJsVar;
                        }
                        str2 = null;
                        return str2;
                    } catch (Exception e7) {
                        e = e7;
                        Logger.e("NativeBitmapMgr", e.toString());
                        e.printStackTrace();
                        return str8;
                    }
                default:
                    str2 = null;
                    return str2;
            }
        } catch (Exception e8) {
            e = e8;
            Logger.e("NativeBitmapMgr", e.toString());
            e.printStackTrace();
            return str8;
        }
    }

    public INativeBitmap getBitmapById(String str) {
        return getBitmapByUuid(this.mIds.get(str));
    }

    public INativeBitmap getBitmapByUuid(String str) {
        return this.mSnaps.get(str);
    }

    public JSONArray getItems() {
        JSONArray jSONArray = new JSONArray();
        for (Map.Entry<String, INativeBitmap> entry : this.mSnaps.entrySet()) {
            try {
                jSONArray.put(new JSONObject(((NativeBitmap) entry.getValue()).toJsString()));
            } catch (Exception unused) {
            }
        }
        return jSONArray;
    }

    public NativeBitmap getSrcNativeBitmap(IWebview iWebview, IApp iApp, String str) {
        JSONObject jSONObject;
        try {
            jSONObject = new JSONObject(str);
        } catch (JSONException unused) {
            jSONObject = null;
        }
        if (jSONObject != null) {
            return (NativeBitmap) getBitmapById(jSONObject.optString("id"));
        }
        if (!PdrUtil.isNetPath(str)) {
            str = (TextUtils.isEmpty(str) || str.equals("null")) ? null : iApp.convert2AbsFullPath(iWebview.obtainFullUrl(), str);
        }
        if (PdrUtil.isEmpty(str)) {
            return null;
        }
        String str2 = iApp.obtainAppId() + str.hashCode();
        return new NativeBitmap(iApp, str2, str2, str);
    }

    /* access modifiers changed from: protected */
    public void initViewDrawItme(IWebview iWebview, NativeView nativeView, JSONArray jSONArray) {
        String str;
        String str2;
        int i;
        String str3;
        String str4;
        JSONObject jSONObject;
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        int stringToColor;
        JSONObject jSONObject4;
        JSONObject jSONObject5;
        JSONObject jSONObject6;
        JSONObject jSONObject7;
        JSONArray jSONArray2 = jSONArray;
        String str5 = "rectStyles";
        String str6 = "id";
        String str7 = "color";
        if (jSONArray2 != null && nativeView != null) {
            int i2 = 0;
            while (i2 < jSONArray.length()) {
                try {
                    JSONObject jSONObject8 = jSONArray2.getJSONObject(i2);
                    String optString = jSONObject8.has(str6) ? jSONObject8.optString(str6) : null;
                    String optString2 = jSONObject8.optString("tag");
                    if (optString2.equals(WXBasicComponentType.IMG)) {
                        NativeBitmap srcNativeBitmap = getSrcNativeBitmap(iWebview, iWebview.obtainApp(), jSONObject8.optString("src"));
                        try {
                            jSONObject6 = new JSONObject(jSONObject8.optString("sprite"));
                        } catch (JSONException unused) {
                            jSONObject6 = new JSONObject();
                        }
                        try {
                            jSONObject7 = new JSONObject(jSONObject8.optString("position"));
                        } catch (JSONException unused2) {
                            jSONObject7 = new JSONObject();
                        }
                        i = i2;
                        str4 = str7;
                        str2 = str6;
                        str3 = str5;
                        nativeView.makeOverlay(iWebview, srcNativeBitmap, null, -1, jSONObject6, jSONObject7, null, optString, WXBasicComponentType.IMG, false, true);
                    } else {
                        i = i2;
                        str4 = str7;
                        str2 = str6;
                        str3 = str5;
                        if (optString2.equals(AbsURIAdapter.FONT)) {
                            String optString3 = jSONObject8.optString("text");
                            if (optString3 != null) {
                                try {
                                    jSONObject4 = new JSONObject(jSONObject8.optString("position"));
                                } catch (JSONException unused3) {
                                    jSONObject4 = new JSONObject();
                                }
                                try {
                                    jSONObject5 = new JSONObject(jSONObject8.optString("textStyles"));
                                } catch (JSONException unused4) {
                                    jSONObject5 = new JSONObject();
                                }
                                nativeView.makeOverlay(iWebview, null, optString3, -1, null, jSONObject4, jSONObject5, optString, AbsURIAdapter.FONT, false, true);
                            }
                        } else {
                            if (optString2.equals("rect")) {
                                String optString4 = jSONObject8.has(str4) ? jSONObject8.optString(str4) : TitleNViewUtil.TRANSPARENT_BUTTON_TEXT_COLOR;
                                String optString5 = jSONObject8.optString("position");
                                JSONObject jSONObject9 = (TextUtils.isEmpty(optString5) || optString5.equals("null")) ? null : new JSONObject(optString5);
                                if (jSONObject8.has(str3)) {
                                    JSONObject optJSONObject = jSONObject8.optJSONObject(str3);
                                    if (optJSONObject.has(str4)) {
                                        optString4 = optJSONObject.optString(str4);
                                    }
                                    jSONObject3 = optJSONObject;
                                } else {
                                    jSONObject3 = null;
                                }
                                try {
                                    stringToColor = Color.parseColor(optString4);
                                } catch (Exception unused5) {
                                    stringToColor = PdrUtil.stringToColor(optString4);
                                }
                                str = str4;
                                nativeView.makeOverlay(iWebview, null, null, stringToColor, null, jSONObject9, jSONObject3, optString, "rect", false, true);
                            } else {
                                str = str4;
                                if (optString2.equals(WXBasicComponentType.RICHTEXT)) {
                                    String optString6 = jSONObject8.optString("text");
                                    String optString7 = jSONObject8.optString("position");
                                    nativeView.makeRichText(iWebview, optString6, (TextUtils.isEmpty(optString7) || optString7.equals("null")) ? null : new JSONObject(optString7), jSONObject8.has("richTextStyles") ? jSONObject8.optJSONObject("richTextStyles") : null, optString);
                                } else if (optString2.equals("input")) {
                                    try {
                                        jSONObject = new JSONObject(jSONObject8.optString("position"));
                                    } catch (JSONException unused6) {
                                        jSONObject = new JSONObject();
                                    }
                                    try {
                                        jSONObject2 = new JSONObject(jSONObject8.optString("inputStyles"));
                                    } catch (JSONException unused7) {
                                        jSONObject2 = new JSONObject();
                                    }
                                    nativeView.makeOverlay(iWebview, null, null, -1, null, jSONObject, jSONObject2, optString, "input", false, true);
                                } else if (optString2.equals("weex")) {
                                    nativeView.makeWeexView(iWebview, jSONObject8, optString);
                                }
                            }
                            i2 = i + 1;
                            str5 = str3;
                            str6 = str2;
                            str7 = str;
                            jSONArray2 = jSONArray;
                        }
                    }
                    str = str4;
                    i2 = i + 1;
                    str5 = str3;
                    str6 = str2;
                    str7 = str;
                    jSONArray2 = jSONArray;
                } catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            nativeView.nativeInvalidate(true);
        }
    }
}
