package io.dcloud.feature.gg.dcloud;

import android.app.Activity;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.taobao.weex.common.Constants;
import com.taobao.weex.ui.component.WXBasicComponentType;
import io.dcloud.PdrR;
import io.dcloud.common.DHInterface.ICallBack;
import io.dcloud.common.adapter.util.PlatformUtil;
import io.dcloud.common.adapter.util.SP;
import io.dcloud.common.util.PdrUtil;
import io.dcloud.feature.gg.AolSplashUtil;
import io.dcloud.feature.internal.splash.ISplash;
import io.dcloud.h.c.d.a;
import java.io.File;

public class GGSplashView extends FrameLayout implements ISplash {
    String appid;
    View bottomIcon;
    FrameLayout container;
    Handler handler = new Handler(Looper.getMainLooper());
    ICallBack mCallBack;
    private long pullTime;

    public GGSplashView(Activity activity) {
        super(activity);
        initView(activity);
    }

    private void initView(Activity activity) {
        try {
            View inflate = LayoutInflater.from(activity).inflate(PdrR.getInt(activity, Constants.Name.LAYOUT, PdrUtil.dealString("ilWlkdg}lW{xdi{`")), (ViewGroup) null);
            inflate.setBackgroundColor(getBgColor());
            addView(inflate);
            this.container = (FrameLayout) inflate.findViewById(PdrR.getInt(activity, "id", PdrUtil.dealString("ilWlkdg}lW{xdi{`Wkgf|iafmz")));
            Drawable icon = getIcon();
            this.bottomIcon = inflate.findViewById(PdrR.getInt(activity, "id", PdrUtil.dealString("ilWlkdg}lW{xdi{`Wjg||geWjiz")));
            ImageView imageView = (ImageView) findViewById(PdrR.getInt(activity, "id", PdrUtil.dealString("ilWlkdg}lWakgfW{afodm")));
            if (icon == null) {
                imageView.setVisibility(8);
                ((ImageView) findViewById(PdrR.getInt(activity, "id", PdrUtil.dealString("ilWlkdg}lWakgf")))).setImageDrawable(AolSplashUtil.getApplicationIcon(activity));
                ((TextView) findViewById(PdrR.getInt(activity, "id", PdrUtil.dealString("ilWlkdg}lWfiem")))).setText(AolSplashUtil.getApplicationName(activity));
                return;
            }
            imageView.setVisibility(0);
            imageView.setImageDrawable(icon);
            findViewById(PdrR.getInt(activity, "id", PdrUtil.dealString("ilWlkdg}lWfiem"))).setVisibility(8);
            findViewById(PdrR.getInt(activity, "id", PdrUtil.dealString("ilWlkdg}lWakgf"))).setVisibility(8);
        } catch (Exception unused) {
        }
    }

    /* access modifiers changed from: package-private */
    public String get(String str) {
        return SP.getBundleData(ADHandler.AdTag, str);
    }

    public int getBgColor() {
        int stringToColor = PdrUtil.stringToColor(get("bg"));
        if (stringToColor != -1) {
            return stringToColor;
        }
        return -1;
    }

    public View getBottomIcon() {
        return this.bottomIcon;
    }

    /* JADX WARNING: Removed duplicated region for block: B:10:0x0030  */
    /* JADX WARNING: Removed duplicated region for block: B:12:0x0036 A[RETURN] */
    public Drawable getIcon() {
        Bitmap bitmap;
        String str = get(WXBasicComponentType.IMG);
        if (!TextUtils.isEmpty(str)) {
            if (!PdrUtil.isDeviceRootDir(str)) {
                bitmap = BitmapFactory.decodeStream(PlatformUtil.getInputStream(str, 0));
            } else if (new File(str).exists()) {
                bitmap = BitmapFactory.decodeFile(str);
            }
            if (bitmap == null) {
                return new BitmapDrawable(bitmap);
            }
            return null;
        }
        bitmap = null;
        if (bitmap == null) {
        }
    }

    public FrameLayout getImgContainer() {
        return this.container;
    }

    public void onFinishShow() {
        ICallBack iCallBack = this.mCallBack;
        if (iCallBack != null) {
            iCallBack.onCallBack(1, this.appid);
            this.mCallBack = null;
        }
        FrameLayout frameLayout = this.container;
        if (frameLayout != null) {
            frameLayout.removeAllViews();
        }
    }

    public void onWillCloseSplash() {
        if (this.container.getChildCount() == 0) {
            onFinishShow();
        }
    }

    public void setAppid(String str) {
        this.appid = str;
    }

    public void setCallBack(ICallBack iCallBack) {
        this.mCallBack = iCallBack;
    }

    @Override // io.dcloud.feature.internal.splash.ISplash
    public void setImageBitmap(Bitmap bitmap) {
    }

    @Override // io.dcloud.feature.internal.splash.ISplash
    public void setNameText(String str) {
    }

    public void setPullTime(long j) {
        this.pullTime = j;
    }

    public void showAd(final a aVar) {
        if (getParent() != null) {
            aVar.a((ViewGroup) this.container);
        } else {
            this.handler.postDelayed(new Runnable() {
                /* class io.dcloud.feature.gg.dcloud.GGSplashView.AnonymousClass1 */

                public void run() {
                    if (GGSplashView.this.getParent() != null) {
                        aVar.a((ViewGroup) GGSplashView.this.container);
                    } else {
                        GGSplashView.this.handler.postDelayed(this, 20);
                    }
                }
            }, 20);
        }
    }
}
